<?php 
get_header();

if (have_posts()){ while (have_posts()){ the_post(); global $post;

	$service_icon = get_post_meta( get_the_ID(), 'service_icon', true );
	$service_list = get_post_meta( get_the_ID(), 'service_list', true );
	
	$service_sec_title = get_post_meta( get_the_ID(), 'service_sec_title', true );
	$service_discount = get_post_meta( get_the_ID(), 'service_discount', true );
	$service_discount_text = get_post_meta( get_the_ID(), 'service_discount_text', true );
	$service_caption_text = get_post_meta( get_the_ID(), 'service_caption_text', true );
	
	/* Get Inner Header */ 
	if(function_exists('kriate_secondary_header')) {
		kriate_secondary_header($post->ID, esc_html__('Service Details','kriate')); 
	} ?>
	<section>
		<div class="w-100 pt-70 pb-40 position-relative">
			<div class="container">
				<div class="services-detail-wrap w-100">
					<div class="serv-detail-info w-100">
						<div class="row align-items-end">
							<div class="col-md-12 col-sm-12 col-lg-5">
								<div class="serv-detail-info-inner w-100">
									<i class="thm-clr <?php echo esc_html($service_icon); ?>"></i>
									<h2 class="mb-0"><?php echo get_the_title(); ?></h2>
								</div>
							</div>
							<div class="col-md-12 col-sm-12 col-lg-7">
								<p class="mb-0"><?php echo get_the_excerpt(); ?></p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<section>
		<div class="w-100 position-relative">
			<div class="container">
				<div class="services-detail-wrap w-100">
					<div class="serv-detail-info w-100">
						<div class="row">
							<div class="col-md-12 col-sm-12 col-lg-5">
								<div class="w-100">
									<?php if(has_post_thumbnail()){ ?> 
										<?php echo get_the_post_thumbnail($post->ID, 'full', array( 'class' => 'img-fluid w-100' ));?>
									<?php } /*endif*/ ?>
								</div>
							</div>
							<div class="col-md-12 col-sm-12 col-lg-7">
								<div class="sec-title2 w-100">
									<div class="sec-title-inner2 d-inline-block">								
										<h2 class="mb-0">
											<?php esc_html_e($service_sec_title);?>
											<?php if($service_discount){ ?><i><?php esc_html_e($service_discount);?> <br> <?php esc_html_e($service_discount_text);?></i><?php } ?>
										</h2>
										<?php if($service_caption_text){ ?><p class="mb-0"><?php esc_html_e($service_caption_text);?></p><?php } ?>
									</div>
								</div>
								<ul class="services-info-list mb-0 list-unstyled">
									<?php 
									if(is_array($service_list)){
										foreach($service_list as $list){ ?>
											<li><?php echo esc_html($list); ?></li>
									<?php }
									} ?>	
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<section>
		<div class="w-100 pt-40 position-relative sec-head">
			<div class="container">
				<div class="sec-title2 w-100">
					<div class="sec-title-inner2 d-inline-block">
						<h4 class="mb-0"><?php esc_html_e('Complete Service Offer Details:', 'kriate');?></h4>
					</div>
				</div>
				<div class="serv-detail-wrap w-100">
					<?php /* The Content */
				the_content(); 		
				wp_link_pages( array(
					'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'kriate' ) . '</span>',
					'after'       => '</div>',
					'link_before' => '',
					'link_after'  => '',
					'pagelink'    => '<span>%</span>',
					'separator'   => '',
				) );
			?>
				</div><!-- Services Detail Wrap -->
			</div>
		</div>
	</section>

	<?php 
	}/*end of while statement*/

} /*end of if statement*/
get_footer(); ?>