<?php
/*
 * This file is used to generate main index page.
 */
	
	/* Get Header */
	@get_header(); 
	
	/* Get Inner Header */ 
	if(function_exists('kriate_secondary_header')) {
		kriate_secondary_header('', esc_html__('Blog Posts', 'kriate')); 
	}
	
	/* Variable Redux Options */
	global $kriate_options;
	
	/* 1. Set Sidebar Layout */
	$default_page_layout_style = isset($kriate_options['sidebar-layout']) ? $kriate_options['sidebar-layout'] : ''; ?>
	
	<section>
		<div class="w-100 pt-100 pb-100 position-relative">
			<div class="container">
				<div class="blog-wrap w-100">
					<div class="row masonry editted">
					<?php
					/* Loop Begins */
						if ( have_posts() ) {
						 
							while ( have_posts() ) { the_post(); global $post;

								/* Get Comment Count */
								$comment_count = wp_count_comments( $post->ID );
								
								$comment_count = $comment_count->total_comments; ?>
									
									<div class="col-md-6 col-sm-6 col-lg-4 fltr-itm">
										<div <?php post_class('tt-posts'); ?>>
										<div class="post-box w-100 text-center">
											<?php if(has_post_thumbnail()){ ?> 
												<div class="post-img w-100">
													<a href="<?php echo get_the_permalink(); ?>">
														<span class = "cato">
															<?php
															$categories = get_the_category($post->ID);

															if ( ! empty( $categories ) ) {
																echo esc_html( $categories[0]->name );   
															}?>
														</span>
														
															<div class="post-img2">
																<?php echo get_the_post_thumbnail($post->ID, 'kriate-post-detail', array( 'class' => 'img-fluid w-100' ));?>
															</div>
													</a>
												</div>
											<?php } /*endif*/ ?>
											<div class="post-info w-100">
												<ul class="post-meta <?php if(has_post_thumbnail()){ echo 'pt-0';}else{ echo 'pt-30';} ?> mb-0 list-unstyled d-inline-flex">
													<li><i class="far fa-calendar-alt"></i><?php echo get_the_date(get_option('date_format')); ?></li>
													<li><i class="far fa-comment-dots"></i>
														<?php
																printf(
																	/* translators: %s: Number of comments. */
																	_nx( '%s Comment', '%s Comments', $comment_count, 'comments title', 'kriate' ),
																	number_format_i18n( $comment_count )
																);
															?>
													</li>
												</ul>
												<h3 class="mb-0"><a href="<?php echo get_the_permalink();?>"><?php echo get_the_title(); ?></a></h3>
												<p class="mb-0"><?php echo wp_trim_words( strip_tags(get_the_content()), 8, '...' ); ?></p>
												<div class="post-info-bottom d-flex flex-wrap w-100">
													<span class="d-inline-block text-center"><i class="far fa-edit"></i><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php esc_html_e('Posted By:','kriate');?> <?php echo get_the_author_meta( 'display_name' , $post->post_author ); ?></a></span>
												</div>
											</div>
										</div>
									</div>
									</div>
							<?php } /* endwhile */
						} ?>
					</div>
					<?php 
					if(function_exists('kriate_numeric_posts_nav')){ ?>
						<div class="pagination-wrap mt-30 d-flex flex-wrap justify-content-center text-center w-100">
							<ul class="pagination mb-0">
								<?php echo kriate_numeric_posts_nav(); ?>
							</ul>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
	</section>
	
<?php @get_footer(); ?>