<?php 

/* Add Default Styles 

*  Default Color Scheme: #b59d5a;

*/
	function kriate_color_scheme_default(){

		/* Get Option Value From Theme Options */
		global $kriate_options, $post;
		if ( ! isset( $kriate_options ) || ! is_array( $kriate_options ) ) {
			$kriate_options = array();
		}

		/* Get Color Scheme From Theme Options */
		$color_primary = isset($kriate_options['color-primary']) ? $kriate_options['color-primary'] : '#ff5e15'; 
		$color_secondary = isset($kriate_options['color-secondary']) ? $kriate_options['color-secondary'] : '#0a1024'; 
		/* Get Background Settings */
		$selected_type = isset($kriate_options['select-bodybg-type']) ? $kriate_options['select-bodybg-type'] : 'color';
		$body_color = isset($kriate_options['body_color']) ? $kriate_options['body_color'] : '#ffffff';
		$body_patterns = kriate_get_pattern( isset($kriate_options['body_patterns']) ? $kriate_options['body_patterns'] : '2' );
		$background_image = isset($kriate_options['background_image']['url']) ? $kriate_options['background_image']['url'] : '';

		/* Create StyleSheet */

		$default_html = '<style id="stylesheet">';
		
		/* Body Color */
		if($selected_type == 'color'){ $default_html .= 'body{background:'.esc_attr($body_color).';}'; }
		/* Body Pattern */
		if($selected_type == 'pattren'){ $default_html .= 'body{background:url('.esc_url($body_patterns).') repeat;}'; }
		/* Body Background */
		if($selected_type == 'image'){ $default_html .= 'body{background:url('.esc_url($background_image).') repeat;}'; }
		
		$page_color_seperate = '';
		
		if(function_exists('get_post_meta') != (is_search() || is_404() || is_archive())){
			$page_color_seperate = get_post_meta( get_the_ID(), 'page_color_seperate', 1 );
		}
		
		
		if(is_search() || is_404() || is_archive()){
			$color_primary = $color_primary;
		}elseif(!empty($page_color_seperate) ){
			$color_primary = $page_color_seperate; /*green*/
		}else{
			$color_primary = $color_primary;
		}
		
		$default_html .= '.thm-bg,
.thm-layer:before,
.header-right-btns > a.get-quote,
.feat-caro > button.slick-arrow:hover:before,
.feat-caro > button.slick-arrow:focus:before,
.video-btn:hover > span, 
.video-btn:focus > span,
.about-image > span,
.proj-box:hover .proj-info,
.solutions-list > li:hover > i,
.sec-title-inner2 > h2 i:before,
.sec-title-inner2 > h2 i:after,
.slick-dots > li.slick-active button,
.black-layer .slick-dots > li.slick-active button,
.blue-layer .slick-dots > li.slick-active button,
.dark-layer .slick-dots > li.slick-active button,
.dark-layer2 .slick-dots > li.slick-active button,
.dark-layer3 .slick-dots > li.slick-active button,
.feat-caro .slick-dots > li.slick-active button,
header.style2 .header-right-btns > a.get-quote,
.team-social > a,
.about-image > a:hover,
.about-image > a:focus,
.post-detail-gallery-video-box > a:hover,
.post-detail-gallery-video-box > a:focus,
.tagclouds > a:before,
.widget2 ul li > a:after,
.widget-video-box > a,
.widget-video-box > a:before,
.widget-video-box > a:after,
.tagclouds > a:before,
.shop-img:before,
.shop-detail-tabs ul.nav-tabs li.nav-item a.nav-link.active,
.shop-detail-tabs ul.nav-tabs li.nav-item a.nav-link:hover,
.shop-detail-tabs ul.nav-tabs li.nav-item a.nav-link:focus,
.simple-btn.bg-color1:hover,
.simple-btn.bg-color1:focus,
.slick-slider:not(.feat-caro) > button.slick-arrow:hover:before,
.slick-slider:not(.feat-caro) > button.slick-arrow:focus:before,
.rspn-scil > a:hover,
.rspn-scil > a:focus,
.rspn-mnu-btn:hover,
.rspn-mnu-btn:focus,
.rspn-mnu-cls:hover,
.rspn-mnu-cls:focus,
.social-links > a:hover,
.social-links > a:focus,
/* .getin-touch-blob:before,
.getin-touch-blob:after, */
.bootstrap-select .dropdown-menu li a.dropdown-item.active, 
.bootstrap-select .dropdown-menu li a.dropdown-item:active,
.bootstrap-select .dropdown-menu li a:hover,
.bootstrap-select .dropdown-menu li a:focus,
.serv-box2:hover:before,
header.style2 .social-links > a:hover,
header.style2 .social-links > a:focus, .solutions-list > li.active i,
.wp-block-button__link:hover,
.wp-block-button__link:focus,
.calendar_wrap > table tbody td#today,
table#wp-calendar tbody td#today,
.post-password-form input:not([type="password"]):hover,
.post-password-form input:not([type="password"]):focus,
.woocommerce-page.woocommerce nav.woocommerce-pagination ul li a:hover, 
.woocommerce-page.woocommerce nav.woocommerce-pagination ul li a:focus, 
.woocommerce-page.woocommerce nav.woocommerce-pagination ul li span,
.woocommerce ul.products li.product .onsale,
.woocommerce ul.products li.product .button, 
.woocommerce ul.products li.product .added_to_cart,
.woocommerce #content .quantity .bootstrap-touchspin > span button:hover, 
.woocommerce .quantity .bootstrap-touchspin > span button:hover,
.woocommerce-page #content .quantity .bootstrap-touchspin > span button:hover, 
.woocommerce-page .quantity .bootstrap-touchspin > span button:hover,
.woocommerce #content .quantity .bootstrap-touchspin > span button:focus, 
.woocommerce .quantity .bootstrap-touchspin > span button:focus,
.woocommerce-page #content .quantity .bootstrap-touchspin > span button:focus, 
.woocommerce-page .quantity .bootstrap-touchspin > span button:focus,
.single-product div.product form.cart .button,
.woocommerce #review_form #respond .form-submit input,
.woocommerce a.remove,
.woocommerce a.button, 
.woocommerce button.button, 
.woocommerce button.button.alt, 
.woocommerce-page a.button, 
.woocommerce-page button.button, 
.woocommerce-page button.button.alt,
.woocommerce #respond input#submit.alt, 
.woocommerce a.button.alt, 
.woocommerce button.button.alt, 
.woocommerce input.button.alt, .woocommerce div.product p.price ins, .woocommerce div.product span.price ins,
.tt-posts.tag-sticky-2 .post-box::before,
.single-product .product span.onsale,
.add-cart ul.woocommerce-mini-cart li a.remove,
.add-cart .widget_shopping_cart_content .buttons a, .editted .cato, .pagination-wrap ul.pagination > li.page-item a.active.page-link
 {
			background-color:'.esc_attr($color_primary).' !important; 
		}';
		
$default_html .= '.pr-tm-wrp:before {
    background-image: linear-gradient(120deg, '.esc_attr($color_primary).', '.esc_attr($color_primary).') !important;
}';

$default_html .= '.ramadan-times {
    background: linear-gradient(106deg, '.esc_attr($color_primary).', '.esc_attr($color_primary).' 26%, '.esc_attr($color_secondary).'), linear-gradient(106deg, rgba(71, 229, 238, 0), '.esc_attr($color_secondary).' 28%, '.esc_attr($color_secondary).' 74%);
}';
			
		/* Theme - PRIMARY - Brown Color */
		
		$default_html .= '.thm-clr, .topbar-info-list > li a:hover, .topbar-info-list > li a:focus, .topbar-links > li a:hover, .topbar-links > li a:focus, nav ul li:hover > a, nav ul li > a:focus, .rsnp-mnu ul > li:hover > a, .rsnp-mnu ul > li.active > a, .rsnp-mnu ul > li > a:focus, .feat-caro > button.slick-arrow:hover, .feat-caro > button.slick-arrow:focus, .serv-box-inner > h3 a:hover, .serv-box-inner > h3 a:focus, .testi-img::before, .toggle-item.active > h4, .toggle-item > h4:hover, .post-info > h3 a:hover, .post-info > h3 a:focus, .post-info-bottom > span a:hover, .post-info-bottom > span a:focus, .post-meta > li a:hover, .post-meta > li a:focus, .social-links2 > a:hover, .social-links2 > a:focus, .widget ul li:hover > a, .widget ul li > a:focus, .copyright p a:hover, .copyright p a:focus, .team-info > h3 a:hover, .team-info > h3 a:focus, .about-image > a, ol.breadcrumb li.breadcrumb-item.active, ol.breadcrumb li.breadcrumb-item a:hover, ol.breadcrumb li.breadcrumb-item a:focus, .contact-info-box > a:hover, .contact-info-box > a:focus, blockquote, .detail-share > a:hover, .detail-share > a:focus, .comment-reply-link:hover, .comment-reply-link:focus, .widget2 form button:hover, .widget2 form button:focus, .widget2 ul li:hover > a, .widget2 ul li > a:focus, .blog-mini-post-info > h4 a:hover, .blog-mini-post-info > h4 a:focus, .post-detail-gallery-video-box > a, .filter-inner > a:hover, .filter-inner > a:focus, .shop-info > h3 a:hover, .shop-info > h3 a:focus, .shop-detail-nav-caro > button.slick-arrow:hover, .shop-detail-nav-caro > button.slick-arrow:focus, .review-link > a:hover, .review-link > a:focus, .price-stock .price ins, .product-cart-btns > a:hover, .product-cart-btns > a:focus, .product-table td h4 a:hover, .product-table td h4 a:focus, .qty-wrp .bootstrap-touchspin span.input-group-btn button:hover, .qty-wrp .bootstrap-touchspin span.input-group-btn button:focus, .rspn-srch > button:hover, .rspn-srch > button:focus, .rspn-cnt > span a:hover, .rspn-cnt > span a:focus, .post-info-bottom > span i, .post-meta > li i, .logged-in-as a:hover, blockquote > p::before, blockquote > p::after, .comment-detail > span i, .comment-reply-link > i, .proj-info > i, .woocommerce .star-rating span::before,
		.logged-in-as a:hover,
		.logged-in-as a:focus, 
		figcaption a,
		.wp-calendar-nav > span a,
		.post-detail > p a,
		.wp-caption-text a, .woocommerce div.product .stock,
.woocommerce-page.woocommerce div.product p.price,
.single-product.woocommerce .posted_in > a:hover, 
.single-product.woocommerce .sku_wrapper > a:hover,
.single-product.woocommerce .posted_in > a:focus, 
.single-product.woocommerce .sku_wrapper > a:focus,
.scl1 > a:hover,
.scl1 > a:focus,
.woocommerce .cart_totals table.shop_table td span.amount,
.price ins,
.price,
.woocommerce ul.products li.product .price,
.woocommerce table.shop_table td.product-name > a:hover,
.woocommerce table.shop_table td.product-name > a:focus,
a.showcoupon,
.woocommerce-MyAccount-content p a,
.woocommerce-account .woocommerce-MyAccount-navigation ul li.is-active a,
.woocommerce-account .woocommerce-MyAccount-navigation ul li a:hover,
.woocommerce-account .woocommerce-MyAccount-navigation ul li a:focus,
.woocommerce-account .addresses .title .edit,
.widget.widget_archive ul li,
.widget.widget_categories ul li,
.add-cart ul.woocommerce-mini-cart li a:not(.remove):hover,
.add-cart ul.woocommerce-mini-cart li a:not(.remove):focus,
.add-cart .widget_shopping_cart_content .total .amount, .widget .social-links3 a:hover i, nav ul li.current-menu-item > a,
.add-cart ul.woocommerce-mini-cart li span .amount, body h3 a:hover, .tt-posts .post-meta2 li a:hover, .woocommerce .rate-wrap .star-rating::before, .woocommerce .rate-wrap .star-rating span::before, .woocommerce div.product .woocommerce-tabs ul.tabs li.active > a, .woocommerce div.product .woocommerce-tabs ul.tabs li > a:hover, .woocommerce div.product .woocommerce-tabs ul.tabs li > a:focus, .woocommerce .woocommerce-tabs ul.tabs li:hover .star-rating::before, .woocommerce .woocommerce-tabs ul.tabs li:hover .star-rating span, .woocommerce .woocommerce-tabs ul.tabs li.active .star-rating::before, .woocommerce .woocommerce-tabs ul.tabs li.active .star-rating span, .related h2.woocommerce-loop-product__title:hover, .product_meta span.posted_in a:hover, .woocommerce-review__author
		{
			color:'.esc_attr($color_primary).' !important; 
		}';
		
		/* Theme - PRIMARY - Brown  border Color */
		$default_html .= '.theme-brd-clr,
.dnt-lst > a:hover,
.dnt-lst > a:focus,
.abt-vdo.style2:before,
.serv-bx2:hover .serv-inf2,
.pagination > li:hover,
.pagination > li.active,
.product-detail-tabs > ul li a.nav-link:hover,
.product-detail-tabs > ul li a.nav-link:focus,
.product-detail-tabs > ul li a.nav-link.active,
.wp-block-button .wp-block-button__link:hover,
.wp-block-button .wp-block-button__link:focus, .plr-box.alim > i::after, .thm-brd-clr, .plr-box > i::after, .testi-itm, .hstry-img:before, .thm-layer .team-box2 > img, .plr-box:hover > i, .srv-box2:hover, .style5 .namaz-drp button#dropdownMenuButton, .thm-brd-clr, .pillar-box > span:before, .pillar-box > span span, .video-box > a:hover, .video-box > a:focus, .about-video > a:hover, .about-video > a:focus, .post-share:hover > i, .pillar-box2 > span:before, .pillar-box2 > span:after, ul.pagination > li.page-item.active a.page-link, .sermons-btns2 > a i, .prod-detail-tabs ul.nav-tabs li.nav-item a.nav-link:hover, .prod-detail-tabs ul.nav-tabs li.nav-item a.nav-link:focus, .prod-detail-tabs ul.nav-tabs li.nav-item a.nav-link.active, .thm-brd-clr,
.about-image > span:before,
.shop-detail-tabs ul:not(.nav-tabs) li:before,
.shop-detail-nav-caro .slick-slide.slick-current img,
.is-style-outline .wp-block-button__link:hover,
.is-style-outline .wp-block-button__link:focus, .sec-title-inner span::before, .sec-title-inner span::after, .pagination-wrap ul.pagination > li.page-item a.active.page-link
		{
			border-color: '.esc_attr($color_primary).' !important;
		}';
		
		$default_html .= '.testi-desc
		{
			border-top-color: '.esc_attr($color_primary).';
		}';
		
		
		/* Theme - SECONDARY */
		
		$default_html .= '.header-right-btns > a.get-quote:hover:before,
.header-right-btns > a.get-quote:focus:before,
.rspn-srch > button, .style-thr nav, .search-form form button, .bg-color1, .simple-btn.thm-bg:hover, .bg-color5,
.simple-btn.thm-bg:focus, .proj-thumb > a:before, .post-img > a:before, .team-social > a:hover, .widget2 .srch-frm button, .widget .srch-frm button
.team-social > a:focus, .serv-detail-desc a:before, .single-product div.product form.cart .button:hover
		{
			background-color: '.esc_attr($color_secondary).' !important;
		}';
		
		$default_html .= '.call-us > strong, .add-cart > a, .sticky-menu nav > div > ul > li, .proj-info > i, .solutions-list > li > i,
.contact-info-box > strong, .error-page-inner > h1
		{
			color: '.esc_attr($color_secondary).' !important;
		}';
		
		/* Theme - PRIMARY - Brown Color */
		$default_html .= '.green-brd-clr, .plr-box.alim > i, .namaz-drp button#dropdownMenuButton
		{
			border-color: '.esc_attr($color_secondary).';
		}';
		
		/* Theme - PRIMARY - Brown Color */
		$default_html .= '#triangle-right
		{
			border-left: 25px solid '.esc_attr($color_secondary).';
		}';
		
		$default_html .= '</style>';

		/* Return All */
		return $default_html;
	}
	

	/* Add Style to Frontend */

	function kriate_add_font_code(){

		/* Color Scheme */
		echo kriate_color_scheme_default();

	}

	/* Add Style in Footer */

	global $pagenow;

	if( $GLOBALS['pagenow'] != 'wp-login.php' ){

		if(!is_admin()){

			add_action('wp_head', 'kriate_add_font_code');
			add_action('wp_head', 'kriate_color_scheme_default');

		}

	}
	/* get pattern url */
	function kriate_get_pattern($patter_id){
		
		switch ($patter_id) {
			case 1:
				return esc_url(get_template_directory_uri().'/assets/images/pattern/pattern-1.png');
				break;
			case 2:
				return esc_url(get_template_directory_uri().'/assets/images/pattern/pattern-2.png');
				break;
			case 3:
				return esc_url(get_template_directory_uri().'/assets/images/pattern/pattern-3.png');
				break;
			case 4:
				return esc_url(get_template_directory_uri().'/assets/images/pattern/pattern-4.png');
				break;
			case 5:
				return esc_url(get_template_directory_uri().'/assets/images/pattern/pattern-5.png');
				break;
			case 6:
				return esc_url(get_template_directory_uri().'/assets/images/pattern/pattern-6.png');
				break;
			default:
				return esc_url(get_template_directory_uri().'/assets/images/pattern/pattern-1.png');
		}
	}
?>