<?php

	/*	
	*	Include Script File
	*	---------------------------------------------------------------------
	*	This file manage to embed the stylesheet and javascript to each page
	*	based on the content of that page.
	*	---------------------------------------------------------------------
	*/
	
	if(is_admin()){
		
		add_action('admin_enqueue_scripts', 'kriate_admin_resources');
		
		function kriate_admin_resources(){
			/* CSS Resources */
			wp_enqueue_style('kriate-meta-stylesheet', get_template_directory_uri().'/assets/css/admin-stylesheet.css');
		}
		
	}
	
	add_action( 'wp_enqueue_scripts', 'kriate_enqueue_styles' );
	
	function kriate_enqueue_styles(){
		
		/* For RTL Option */
		global $kriate_options;
		
		/* Bootstrap */
		wp_enqueue_style('bootstrap', get_template_directory_uri().'/assets/css/bootstrap.min.css');

		/* Web Fonts */
		wp_enqueue_style('fontAwesome',get_template_directory_uri().'/assets/css/fontAwesome.min.css');
			
			/*** generic CSS Section Start ***/

				/* 1. Developer CSS */
				wp_enqueue_style('kriate-wp-developers',get_template_directory_uri().'/assets/css/wp-developer.css');
				wp_enqueue_style('fancybox',get_template_directory_uri().'/assets/css/jquery.fancybox.min.css');
				wp_enqueue_style('kriate-ttstyles',get_template_directory_uri().'/assets/css/ttstyles.css');
				wp_enqueue_style('perfect-scrollbar',get_template_directory_uri().'/assets/css/perfect-scrollbar.css');
				
				$anime_switch = isset($kriate_options['anime_switch']) ? $kriate_options['anime_switch'] : '';
				
				if($anime_switch == 1){
					wp_enqueue_style('animate',get_template_directory_uri().'/assets/css/animate.min.css');
				}
				
				/* woocommerce css */	
				wp_enqueue_style('bootstrap-select',get_template_directory_uri().'/assets/css/bootstrap-select.min.css');
				wp_enqueue_style('touchspin',get_template_directory_uri().'/assets/css/jquery-touchspin.min.css'); 
				wp_enqueue_style('kriate-woocommerce',get_template_directory_uri().'/assets/css/woocommerce.css');
				
			
			
			/*** generic CSS Section Ends ***/
		
		/* Default Stylesheet */
		wp_enqueue_style( 'kriate-default', get_stylesheet_uri() );  
		
		/* Responsive CSS */
		wp_enqueue_style('kriate-responsive',get_template_directory_uri().'/assets/css/responsive.css');
		
		/* Default Colors CSS */
		if ( ! class_exists( 'Redux' ) ) {
			wp_enqueue_style('kriate-colors',get_template_directory_uri().'/assets/css/color.css');
		}

		/* RTL CSS */
		/*$rtl_layout = isset($kriate_options['rtl_switch']) ? $kriate_options['rtl_switch'] : '';
		
		if($rtl_layout == 1){
			
			wp_enqueue_style('kriate-rtl',get_template_directory_uri().'/assets/css/rtl.css');
		}*/
		
		/* Icons CSS */
		wp_enqueue_style('flaticons',get_template_directory_uri().'/assets/css/flaticon.css');
	}
	
	add_action( 'wp_enqueue_scripts', 'kriate_enqueue_scripts' );
	
	function kriate_enqueue_scripts(){ 
	
		global $kriate_options;
	
		if ( is_singular() && get_option( 'thread_comments' ) ) 	wp_enqueue_script( 'comment-reply' );
		
		wp_enqueue_script( 'popper', get_template_directory_uri() . '/assets/js/popper.min.js', array('jquery'), '1.0.0', true );
			
		/* Bootstrap JS */
		wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.min.js', array('jquery'), '1.0.0', true );

		/* Ajax For Comments */
		wp_localize_script('bootstrap', 'ajax_var', array('url' => admin_url('admin-ajax.php'),'nonce' => wp_create_nonce('ajax-nonce')));

		if ( class_exists( 'WooCommerce' ) ) {
			if(is_woocommerce() || is_cart() || is_checkout() || is_account_page()){
				wp_enqueue_script( 'touchspin', get_template_directory_uri() . '/assets/js/jquery-touchspin.min.js', array('jquery'), '1.0.0', true );
			}
		}

		wp_enqueue_script( 'fancybox', get_template_directory_uri() . '/assets/js/jquery.fancybox.min.js', array('jquery'), '1.0.0', true );
		
		wp_enqueue_script( 'perfect-scrollbar', get_template_directory_uri() . '/assets/js/perfect-scrollbar.min.js', array('jquery'), '1.0.0', true );
		
		
		wp_enqueue_script( 'ResizeSensor', get_template_directory_uri() . '/assets/js/ResizeSensor.min.js', array('jquery'), '1.0.0', true );
	
		wp_enqueue_script( 'theia-sticky-sidebar', get_template_directory_uri() . '/assets/js/theia-sticky-sidebar.min.js', array('jquery'), '1.0.0', true ); 


		wp_enqueue_script( 'woo-animation', get_template_directory_uri() . '/assets/js/wow.min.js', array('jquery'), '1.0.0', true );
		
		wp_enqueue_script( 'bootstrap-select', get_template_directory_uri() . '/assets/js/bootstrap-select.min.js', array('jquery'), '1.0.0', true );
		
		wp_enqueue_script( 'isotope', get_template_directory_uri() . '/assets/js/isotope.pkgd.min.js', array('jquery'), '1.0.0', true );
		
		/* Custom JS */
		wp_enqueue_script( 'kriate-custom-scripts', get_template_directory_uri() . '/assets/js/custom-scripts.js', array('jquery'), '1.0.0', true );
	} 
?>