<?php


/*	
	*	Core Scripts
	*	---------------------------------------------------------------------
	*	This file manage to embed the stylesheet and javascript to each page
	*	based on the content of that page.
	*	---------------------------------------------------------------------
	*/

	/* Theme Check Recommendation */
	if ( ! isset( $content_width ) ) $content_width = 1170;
	
	/* 1. Add Theme Support - WordPress 6.7: theme setup & translations must run at after_setup_theme or init */
	add_action( 'after_setup_theme', 'kriate_theme_setup', 10 );
	add_action( 'init', 'kriate_load_translations', 1 );
	
	function kriate_load_translations() {
		/* WordPress 6.5+ PHP format tercih ediyor - MO dosyasını zorla yükle */
		$locale = determine_locale();
		$mofile = get_template_directory() . '/languages/kriate-' . $locale . '.mo';
		if ( file_exists( $mofile ) ) {
			load_textdomain( 'kriate', $mofile, $locale );
		}
	}
	
	function kriate_theme_setup() {
		/* Load translations first (before any esc_html__ with 'kriate') */
		load_theme_textdomain( 'kriate', get_template_directory() . '/languages/' );
		kriate_load_translations();
		
		if ( ! function_exists( 'add_theme_support' ) ) {
			return;
		}
		
		/* Custom background Support */
		$args = array(
			'default-color'          => '',
			'default-image'          => '',
			'wp-head-callback'       => '_custom_background_cb',
			'admin-head-callback'    => '',
			'admin-preview-callback' => ''
		);

		/* Custom Header Support */
		$defaults = array(
			'default-image'          => '',
			'random-default'         => false,
			'width'                  => 950,
			'height'                 => 200,
			'flex-height'            => false,
			'flex-width'             => false,
			'default-text-color'     => '',
			'header-text'            => true,
			'uploads'                => true,
			'wp-head-callback'       => '',
			'admin-head-callback'    => '',
			'admin-preview-callback' => '',
		);
		
		add_theme_support( "custom-header", $args );
		
		add_theme_support( "custom-background", $args );

		add_theme_support( 'html5', array('search-form', 'comment-form', 'comment-list',) );

		add_theme_support( 'post-formats', array('aside', 'image', 'video', 'audio', 'quote', 'link', 'gallery') );
		
		/* enable featured image */
		
		add_theme_support('post-thumbnails');
		
		/*  enable editor style */
		
		add_editor_style('editor-style.css');
		
		/* enable navigation menu */
		register_nav_menus(array('header-menu'=>esc_html__('Header Menu', 'kriate'), 'topbar-menu'=> esc_html__('TopBar Menu', 'kriate'), 'footer-menu'=> esc_html__('Footer Menu', 'kriate')));
		
		add_theme_support( 'title-tag' );
		
		/*  Add Another theme support */
		add_theme_support( 'automatic-feed-links' );	
		
		/* WooCommerce Support */
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );
		
		add_action( 'woocommerce_before_main_content', 'kriate_wrapper_start', 10 );
		add_action( 'woocommerce_after_main_content', 'kriate_wrapper_end', 10 );
		add_action( 'woocommerce_before_main_content', 'kriate_woocommerce_remove_breadcrumb' );
		add_action( 'woo_custom_breadcrumb', 'kriate_woocommerce_custom_breadcrumb' );
		remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating' );
		add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 15 );
	}

	/* 3. excerpt filter */
	add_filter('excerpt_length','kriate_excerpt_length');
	
	function kriate_excerpt_length(){
		
		return 50;
	}
	
	/* 4. Custom Post type Feed */
	add_filter('request', 'kriate_myfeed_request');
	function kriate_myfeed_request($qv) {
		
		if (isset($qv['feed']) && !isset($qv['post_type']))
		$qv['post_type'] = array('post'); /* array('post','team') */
		return $qv;
	}

	/* 5. Translate the wpml shortcode */
	function kriate_webtreats_lang_test( $atts, $content = null ) {
		extract(shortcode_atts(array( 'lang' => '' ), $atts));
		
		$kriate_lang_active = ICL_LANGUAGE_CODE;
		
		if($lang == $kriate_lang_active){
			return $content;
		}
	}
	
	/* Themeforest Recommendation - 1170 */
	if ( ! isset( $kriate_content_width ) ){ $kriate_content_width = 1170; }

	
	/* 6. Sidebar Controls */
	add_action( 'widgets_init', 'kriate_sidebars_init' );
	function kriate_sidebars_init() {
	
		/* Variable Redux Options */
		global $kriate_options;
		
		/* Only for default footer */
		$footer_columms = isset($kriate_options['default-footer-columns']) ? $kriate_options['default-footer-columns'] : '';
		
		if($footer_columms == '2-col'){ $lay_class = 'col-md-6 col-sm-6 col-lg-6'; }elseif($footer_columms == '3-col'){ $lay_class = 'col-md-4 col-sm-4 col-lg-4'; }else{ $lay_class = 'col-md-3 col-sm-6 col-lg-3'; }
		
		/* Footer Sidebar */
		register_sidebar( array(
			'name' => esc_html__( 'Footer', 'kriate' ),
			'id' => 'footer-sidebar',
			'description' => esc_html__( 'Add Widgets For Footer Section.', 'kriate' ),
			'before_widget' => '<div class="'.esc_attr__($lay_class).'"><div class="widget w-100 %2$s">',		
			'before_title'  => '<h3 class = "widget-title" itemprop="headline">',
			'after_title'   => '</h3>',
			'after_widget'  => '</div></div>',
		) );
		
		/* Default Sidebar */
		register_sidebar( array(
			'name' => esc_html__( 'Default Pages Sidebar', 'kriate' ),
			'id' => 'default-sidebar',
			'description' => esc_html__( 'Sidebar for Index, Search, Archive Pages.', 'kriate' ),
			'before_widget' => '<div class="widget2 brd-rd5 w-100 %2$s">',
			'before_title'  => '<h3 class = "widget-title2">',
			'after_title'   => '</h3>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 1 - Space 1 */
		register_sidebar( array(
			'name' => esc_html__( 'Footer - Space 1', 'kriate' ),
			'id' => 'footer-1-space-1',
			'description' => esc_html__( 'Use This To Place Widget - Location 1.', 'kriate' ),
			'before_widget' => '<div class="widget w-100 %2$s">',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 1 - Space 2 */
		register_sidebar( array(
			'name' => esc_html__( 'Footer - Space 2', 'kriate' ),
			'id' => 'footer-1-space-2',
			'description' => esc_html__( 'Use This To Place Widget - Location 2.', 'kriate' ),
			'before_widget' => '<div class="widget w-100 %2$s">',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 1 - Space 3 */
		register_sidebar( array(
			'name' => esc_html__( 'Footer - Space 3', 'kriate' ),
			'id' => 'footer-1-space-3',
			'description' => esc_html__( 'Use This To Place Widget - Location 3.', 'kriate' ),
			'before_widget' => '<div class="widget w-100 %2$s">',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 1 - Space 4 */
		register_sidebar( array(
			'name' => esc_html__( 'Footer - Space 4', 'kriate' ),
			'id' => 'footer-1-space-4',
			'description' => esc_html__( 'Use This To Place Widget - Location 4.', 'kriate' ),
			'before_widget' => '<div class="widget w-100 %2$s">',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>',
			'after_widget'  => '</div>',
		) );
		
		/* Footer 1 - Space 5 */
		register_sidebar( array(
			'name' => esc_html__( 'Footer - Space 5', 'kriate' ),
			'id' => 'footer-1-space-5',
			'description' => esc_html__( 'Use This To Place Widget - Location 5.', 'kriate' ),
			'before_widget' => '<div class="widget w-100 %2$s">',
			'before_title'  => '<h3>',
			'after_title'   => '</h3>',
			'after_widget'  => '</div>',
		) );
		

		/* Function For Generating Dynamic Sidebars */
		
		if (function_exists('register_sidebar')){	

			/* Fetch Value From Theme Options Panel */
			$unlimited_sidebars_var = array();
			$unlimited_sidebars_var = isset($kriate_options['multi-text']) ? $kriate_options['multi-text'] : array();
			

			if(is_array($unlimited_sidebars_var)){
				/* Loop For all added sidebars */
				foreach($unlimited_sidebars_var as $single_sidebars_var){
	
					if(!empty($single_sidebars_var)){

						static $counter = 0;
							/* Generate Sidebars Against Added names */
							register_sidebar(
								array(
									'name' => esc_attr($single_sidebars_var), /* Name Added By User In Options Panel */
									'id' => str_replace(' ', '-', strtolower($single_sidebars_var)),
									'description' => esc_html__( 'Place Your Widgets Here.' , 'kriate'),
									'before_widget' =>'<div class="widget-box widget style2 %2$s">',
									'before_title' => '<h5 class = "widget-title">',
									'after_title' => '</h5>',
									'after_widget' => '</div>'
								)
							);
						$counter++;
					}
				} /* end foreach */
			} /* endif */
		}/* endif */
	}/* end function */	

	
	/* 7. Default Fonts Enqueue
	* If Redux Not Installed Then Add Default Font From Here 
	*/
	if ( !class_exists( 'ReduxFramework' )){

		function kriate_default_font_default() {
			wp_enqueue_style( 'kriate_defaut_font_one', 'https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,400;0,600;0,700;0,800;1,400;1,600;1,700;1,800&display=swap', false );
			wp_enqueue_style( 'kriate_defaut_font_two', 'https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,400;0,500;0,600;0,700;0,800;0,900;1,400;1,500;1,600;1,700;1,800;1,900&display=swap', false ); 			
		}
		add_action( 'wp_enqueue_scripts', 'kriate_default_font_default' );
	}
	
	/* 8. Disable RevSlider/Visual Composer Update Notices */
	function kriate_disable_version(){
		/* Revolution Slider */
		if (function_exists('set_revslider_as_theme')) {
			set_revslider_as_theme();
		}
	}
	
	/* 9. Page/Post Secondary Header Control */
	function kriate_secondary_header($post_id = '', $title = ''){
		
		global $kriate_options, $post;
		
		$breadcrumbs = isset($kriate_options['breadcrumbs']) ? $kriate_options['breadcrumbs'] : 1;
		
		/* Secondary Header */
		$secondary_header = 'display';
		
		/* Header Background Image */		
		$inner_header_bg = isset($kriate_options['inner_header_bg']) ? $kriate_options['inner_header_bg'] : '';
		
		if(!empty($inner_header_bg['url'])){
			$header_img_url = $inner_header_bg['url'];
		}else{
			$header_img_url = '';
		}

		/* Header Check */
		if(is_search() || is_404() || is_archive() || is_single()){ 
			
			$secondary_header = 'display';
			
		}else{
			
			$secondary_header = get_post_meta( get_the_ID(), 'secondary_header', true );
		}
		
		// check if ingeniofy plugin is active or not
		if(in_array('ingeniofy/index.php', apply_filters('active_plugins', get_option('active_plugins')))){ 
			if(!is_search() && !is_404() && !is_archive()){  $secondary_header = get_post_meta( get_the_ID(), 'secondary_header', true ); 
			}else{
				$secondary_header = 'display';
			}
		}else{
			$secondary_header = 'display';
		}
		
		$selected_header = isset($kriate_options['select-header-layout']) ? $kriate_options['select-header-layout'] : '';
		
		if(!is_home() && $selected_header == 'header2'){ $css_class = 'pt-240';}else{ $css_class = 'pt-80'; }
		
		if(class_exists('woocommerce')){ if(is_shop() || is_checkout() || is_cart()){ $secondary_header = 'display'; } }

		/* Detail Pages Will Always Show Inner Header */
		if(is_single() || is_archive() || is_404() || is_search() || is_home()){ $secondary_header = 'display';} ?>
		
		<?php if($secondary_header == 'display'){ ?>
		
		<section>
			<div class="w-100 <?php echo esc_html($css_class); ?> black-layer pb-70 opc65 position-relative">
				<div class="fixed-bg" style="background-image: url(<?php echo esc_url($header_img_url);?>)"></div>
				<div class="container">
					<div class="page-title-wrap text-center w-100">
						<div class="page-title-inner d-inline-block">
						<?php  /* Only For Archives */
							if(is_archive()){
									if(class_exists('WooCommerce') && is_shop()){
										echo '<h2 itemprop="headline">'.esc_html__('Our Products','kriate').'</h2>';
									}else{
										the_archive_title( '<h2 itemprop="headline">', '</h2>');
									}
							}else{ /* for all pages */ 
								if(class_exists('WooCommerce') && is_product()){
										echo '<h2 itemprop="headline">'.esc_html__('Our Products','kriate').'</h2>'; 
									}else{ ?>
										<h2 class="mb-0" itemprop="headline"><?php printf( esc_html__( '%s', 'kriate' ), $title );?></h2>
							   <?php }
							} 
							/* Breadcrumbs */
							if($breadcrumbs == 1){  kriate_breadcrumbs(); }
						?>
						</div>
					</div><!-- Page Title Wrap -->
				</div>
			</div>
		</section>
		<?php }
	}
	/* 10. Page/Post Pagination Class Frontend */
	add_filter('next_posts_link_attributes', 'kriate_posts_link_attributes');
	add_filter('previous_posts_link_attributes', 'kriate_posts_link_attributes');

	function kriate_posts_link_attributes() {
		return 'class="page-link"';
	}
	
	/* 11. Add Boxed Class For Boxed Layout */
	add_filter( 'body_class','kriate_body_classes' );
	function kriate_body_classes( $classes ) {
		
		global $post;
		
		if(is_search() || is_404() || is_archive()){ $kriate_page_xml = '';}else{$kriate_page_xml = get_post_meta($post->ID, 'pagedetail_xml', true);}
		
		if(!empty($kriate_page_xml)){
		
			$kriate_pageset_xml = new DOMDocument ();
			$kriate_pageset_xml->loadXML ( $kriate_page_xml );
			/* Get That Secondary Header Setting */
			$boxed_layout = kriate_find_xml_value($kriate_pageset_xml->documentElement,'boxed_layout');
			/* Add Boxed Class if its enable */
			if($boxed_layout == 'enable'){
				$classes[] = 'boxed gray-layer opc8';
			}
		}
		 
		return $classes;
		 
	}
	/* 12. Remove Revolution Slider Meta Box Inside Page & Post */
	if ( is_admin() ) {

		function kriate_remove_revolution_slider_meta_boxes() {
			remove_meta_box( 'mymetabox_revslider_0', 'page', 'normal' );
			remove_meta_box( 'mymetabox_revslider_0', 'post', 'normal' );
		}

		add_action( 'do_meta_boxes', 'kriate_remove_revolution_slider_meta_boxes' );
		
	}
	

	/* 14. Author Intro Box */
	function kriate_author_intro_box(){
		
		global $post;
		
		/* Detect if it is a single post with a post author */
		if ( is_single() && isset( $post->post_author ) ) {
			
			/* Get author's display name  */
			$display_name = get_the_author_meta( 'display_name', $post->post_author );
			
			if ( empty( $display_name ) )
			$display_name = get_the_author_meta( 'nickname', $post->post_author );
			
			/* Get author's biographical information or description */
			$user_description = get_the_author_meta( 'user_description', $post->post_author );
			
			/* Get author's website URL  */
			$user_website = get_the_author_meta('url', $post->post_author);
			
			/* Get link to the author archive page */
			$user_posts = get_author_posts_url( get_the_author_meta( 'ID' , $post->post_author));
			
			/* Post Author ID */
			$author_id = $post->post_author;
			
			/* initialize Variable  */
			$return_content = '';
			
			if(!empty($user_description)){
				$return_content .= '
					<div class="pst-athr">
						'.get_avatar( $author_id, 160 , '', '', array('class' => 'brd-rd50')).'
						<div class="pst-athr-inf">
							<h6 itemprop="headline">'.esc_html__('AUTHOR MESSAGE:','kriate').'</h6>
							<div class="athr-scl">';
								if(get_the_author_meta('googleplus')) {
								$return_content .= '<a class="brd-rd50" href="'.esc_url(get_the_author_meta('googleplus')).'" title="'.esc_attr__('Google Plus','kriate').'" data-toggle="tooltip" data-placement="top" itemprop="url" target="_blank"><i class="fa fa-google-plus"></i></a>';
								}
								if(get_the_author_meta('twitter')) {
									$return_content .= '<a class="brd-rd50" href="'.esc_url(get_the_author_meta('twitter')).'" title="'.esc_attr__('Twitter','kriate').'" data-toggle="tooltip" data-placement="top" itemprop="url" target="_blank"><i class="fa fa-twitter"></i></a>';
								}
								if(get_the_author_meta('linkedin')) {
									$return_content .= '<a class="brd-rd50" href="'.esc_url(get_the_author_meta('linkedin')).'" title="'.esc_attr__('Linkedin','kriate').'" data-toggle="tooltip" data-placement="top" itemprop="url" target="_blank"><i class="fa fa-linkedin"></i></a>';
								}
								if(get_the_author_meta('facebook')) {
									$return_content .= '<a class="brd-rd50" href="'.esc_url(get_the_author_meta('facebook')).'" title="'.esc_attr__('Facebook','kriate').'" data-toggle="tooltip" data-placement="top" itemprop="url" target="_blank"><i class="fa fa-facebook"></i></a>';
								}
							$return_content .= '
							</div>';
							if(!empty($user_description)){ 
								$return_content .= '<p itemprop="description">'.strip_tags($user_description).'</p>';
							}
							$return_content .= '
						</div>
					</div>';
					
			} /* endif */
		}	
		
		return $return_content;
	}
	

	/* 15. Custom Comments Form */
	function kriate_comment_form_temp($kriate_commenter, $req, $aria_req ){
		
		global $post;
		
		$kriate_comment_form = array( 
			'fields' => apply_filters( 'comment_form_default_fields', array(
				'author' => '<div class="col-md-6 col-sm-12 col-lg-6"><div class ="field-wrap w-100">' .						
							'<input class="brd-rd5" id="author" name="author" placeholder="'.esc_attr__('Full Name *','kriate').'" type="text" value="' .
							esc_attr( $kriate_commenter['comment_author'] ) . '" size="30" tabindex="1" />' .						
							'</div></div>',
							
				'email'  => '<div class="col-md-6 col-sm-12 col-lg-6"><div class ="field-wrap w-100">' .
							'<input id="email" class="brd-rd5" name="email" placeholder="'.esc_attr__('Email *','kriate').'" type="text" value="' . esc_attr(  $kriate_commenter['comment_author_email'] ) . '" size="30" tabindex="2" />' .						
							'</div></div>',
							
				'subject'    => '<div class="col-md-12 col-sm-12 col-lg-12"><div class ="field-wrap w-100">' .
							'<input id="url" class="brd-rd5" placeholder="'.esc_attr__('Subject *','kriate').'" name="subject" type="text" value="' . esc_url( $kriate_commenter['comment_author_url'] ) . '" size="30" tabindex="3" />' .
							'</div></div>' ) ),
				'comment_field' => '' .
							'<div class="col-md-12 col-sm-12 col-lg-12"><div class ="field-wrap w-100">'.												
							'<textarea class="brd-rd5"  cols="60" rows="10" placeholder="'.esc_attr__('Comments *','kriate').'" id="comment" name="comment" aria-required="true"></textarea></div></div>' .
							'',
			'title_reply_before' => '<h3 itemprop="headline">',
			'title_reply' => esc_html__('Leave A Reply','kriate'),
			'title_reply_after' => '</h3>',
			'class_form' => 'row mrg5',
			'class_submit' => 'thm-btn thm-bg',
			
		);
		
		comment_form($kriate_comment_form, $post->ID);  
	}
	
/* 

	* ThemeForest Recommendation
	
	* "after_setup_theme" hook added
	
	* Calling required files/functions through setup function
	
	* Intialize Custom Functions On Theme Setup
	
	*/
		
		
	/**************  Declare WooCommerce Support  **************************/ 
	
	function kriate_wrapper_start() {
	
		global $post;
		
		/* Get Inner Header */ 
		if(function_exists('kriate_secondary_header')) {
			kriate_secondary_header($post->ID, get_the_title()); 
		}  ?>
		<section>
			<div class="spacing">
				<div class="container">
					<div class="product-detail-box">	
		<?php 
	}
		  
	function kriate_wrapper_end() {
		
			echo '</div>
				</div>
			</div>
		</section>';
	}
	
	/*  Reposition WooCommerce breadcrumb */
	function kriate_woocommerce_remove_breadcrumb(){
		remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
	}

	/*  Custom WooCommerce breadcrumb */
	function kriate_woocommerce_custom_breadcrumb(){
		woocommerce_breadcrumb();
	}
	/* Move Product Tag Above Title */
	function kriate_wc_single_product(){
		/* Product Tags */
		$product_cats = wp_get_post_terms( get_the_ID(), 'product_tag' );
		if ( $product_cats && ! is_wp_error ( $product_cats ) ){ ?>
		   <span class="tagged_as custom-block">
				<?php esc_html_e('Tags: ','kriate');
					foreach($product_cats as $single_cat){ ?>
						<a href="<?php echo esc_url(get_category_link($single_cat->term_id));?>" rel="tag"><?php echo esc_attr($single_cat->name); ?></a>
				<?php } ?>
			</span>
			<?php
		}
	}
	add_action( 'woocommerce_single_product_summary', 'kriate_wc_single_product', 2 );
	
	/* Social Shares of Product */
	add_action( 'woocommerce_share', 'kriate_woocommerce_social_share_icons', 10 );
	function kriate_woocommerce_social_share_icons() {
		if ( function_exists( 'kriate_post_social_shares' ) ) {
			global $product;
			$id = $product->get_id();
		
			echo '<div class="scl1"><span>'.esc_html__('Share This Post:','kriate').'</span>'; echo kriate_post_social_shares($id); echo '</div>';
		}
	}
	/* Change product title to h3 */
	remove_action('woocommerce_single_product_summary','woocommerce_template_single_title',5);
	add_action('woocommerce_single_product_summary', 'kriate_woocommerce_my_single_title',5);

	if ( ! function_exists( 'kriate_woocommerce_my_single_title' ) ) {
	   function kriate_woocommerce_my_single_title() {
	?>
				<h3 itemprop="name" class="product_title entry-title"><span><?php the_title(); ?></span></h3>
	<?php
		}
	}
	
	/* Change product columns to 4 */
    add_filter('loop_shop_columns', 'kriate_loop_columns');
    if (!function_exists('kriate_loop_columns')) {
    	function kriate_loop_columns() {
    		return 4; // 4 products per row
    	}
    }
	
	function kriate_background($image_name = ''){
		return 'background-image: url('.get_template_directory_uri().'/assets/images/'.$image_name.')';
	}
	
	/* custom css class to sub menu */
	add_action('nav_menu_submenu_css_class', 'kriate_submenu_css_class');
	function kriate_submenu_css_class() {
		return array('sub-menu', 'mb-0', 'list-unstyled');
	}
	
	/* function for split title */
	function kriate_split_title($title){
		
		$strings = preg_split ('/ /', $title, 3);
		$second=array_pop($strings);
		$first=implode(" ", $strings);
		
		return esc_html($first) .'<br />'. esc_html($second);
	}
?>