<?php

	/*	
	*	Comment File
	*	---------------------------------------------------------------------
	*	This file return the comment list to the selected post_type
	*	---------------------------------------------------------------------
	*/
	 
	function kriate_get_comment_list( $comment, $args, $depth ) {
	
		$GLOBALS['comment'] = $comment;
		
		switch ( $comment->comment_type ) :
			case 'pingback'  :
			case 'trackback' :
			?>
				<li class="post pingback">	
					<p>
						<?php esc_html_e( 'Pingback:', 'kriate'); ?>
						<?php comment_author_link(); ?>
						<?php edit_comment_link( esc_html_e('(Edit)', 'kriate'), ' ' ); ?>
					</p>
					</li>
			<?php
				break;
				
			default :
			?>
				<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
					<div class="thumb">
						<?php echo get_avatar( $comment, 60 ); ?>
					</div>
					<div class="text">
						<h4><?php echo get_comment_author_link(); ?></h4>
						<?php comment_text(); ?>
						<div class="post-time">
							<ul>
								<li><p><?php echo get_comment_time();?> - <?php echo get_comment_date();?></p></li>
								<li><?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?></li>
							</ul>
						</div>
					</div>
				
			<?php
				break;
		endswitch;
		
	}
	
	/* Customized Comment Layout */
	function kriate_comments($comment, $args, $depth) {
	
    if ( 'div' === $args['style'] ) {
        $tag       = 'div';
        $add_below = 'comment';
    } else {
        $tag       = 'li';
        $add_below = 'div-comment';
    }?>

    <<?php echo esc_html($tag); ?>><?php 
    if ( 'div' != $args['style'] ) { ?>
        <div id="div-comment-<?php comment_ID() ?>" class="comment w-100"><?php
    }  
	                                          
		echo '<div class="comment-img"><span class = "rounded-circle">';
        if ( $args['avatar_size'] != 0 ) { 
            $check_avatar = get_avatar( $comment, 36 , '', '', array('class' => 'img-fluid rounded-circle')); 
            if($check_avatar !== false){?>
                <?php  echo get_avatar( $comment, 36 , '', '', array('class' => 'img-fluid rounded-circle')); 
            }
    	} 
		echo '</span></div>';
		
        if ( $comment->comment_approved == '0' ) { ?>
            <em class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'kriate' ); ?></em><br/><?php 
        } ?>
		
		<div class="comment-detail">
			<h4 class="mb-0" itemprop="headline"><?php echo get_comment_author(); ?></h4>
			<small class="thm-clr">
			<?php /* translators: 1: date, 2: time */
                printf('%s', get_comment_date()); ?> <?php esc_html_e('AT ','kriate'); ?><?php echo get_comment_time( ); ?>
			</small>
			<?php comment_text(); ?>
			<?php
			comment_reply_link( 
				array_merge( 
					$args, 
					array( 
						'add_below' => $add_below, 
						'depth'     => $depth, 
						'max_depth' => $args['max_depth'],
						'reply_text' => __('Reply Comment <i class="fas fa-caret-right"></i>', 'kriate'),
					) 
				) 
			);
   
			if ( 'div' != $args['style'] ) :
				echo '</div>';
			endif;
		echo '</div>';
	}
?>
