<?php 
/*	
*	Pagination File
*	---------------------------------------------------------------------
*	This file return the Breadcrumbs to the selected post_type
*	---------------------------------------------------------------------
*/

	function kriate_breadcrumbs() {	
	 
	  $showOnHome = 1;
	  $delimiter = ''; 								/* delimiter between crumbs */
	  $home = esc_html__('Home','kriate'); 	/* text for the 'Home' link */
	  $showCurrent = 1; 							/* 1 - show current post/page title in breadcrumbs, 0 - don't show */
	  $before = '<li class="breadcrumb-item active">'; 			/* tag before the current crumb */
	  $after = '</li>'; 							/* tag after the current crumb */

	  global $post;
	  
	  $homeLink = esc_url(home_url('/'));
	 
	  if (is_home() || is_front_page()) {		  
		if ($showOnHome == 1) echo '<ol class="breadcrumb brd-rd30"><li class="breadcrumb-item"><a href="' . esc_url($homeLink) . '">'.esc_attr($home).'</a></li></ol>';
	 
	  } else {
		
		echo '<ol class="breadcrumb brd-rd30"><li class="breadcrumb-item"><a href="' . esc_url($homeLink) . '">'.esc_attr($home).'</a> ' . esc_attr($delimiter) . '</li> ';
	 
		if ( is_category() ) {
		  $thisCat = get_category(get_query_var('cat'), false);
		  if ($thisCat->parent != 0) echo get_category_parents($thisCat->parent, TRUE, ' ' . esc_attr($delimiter) . ' ');
		  echo wp_kses_post( $before ) . esc_html__('Posted In Category: ', 'kriate') . esc_html( single_cat_title('', false) ) . '' . $after;
	 
		} elseif ( is_search() ) {
		  echo wp_kses_post( $before ) . esc_html__('Search Results For: ', 'kriate') . esc_html( get_search_query() ) . '' . $after;
	 
		} elseif ( is_day() ) {
		  echo '<li class="breadcrumb-item"><a href="' . esc_url( get_year_link(get_the_time('Y')) ) . '">' . esc_html( get_the_time('Y') ) . '</a> ' . esc_attr($delimiter) . '</li> ';
		  echo '<li class="breadcrumb-item"><a href="' . esc_url( get_month_link(get_the_time('Y'),get_the_time('m')) ) . '">' . esc_html( get_the_time('F') ) . '</a> ' . esc_attr($delimiter) . '</li> ';
		  echo wp_kses_post( $before ) . esc_html( get_the_time('d') ) . $after;
	 
		} elseif ( is_month() ) {
		  echo '<li class="breadcrumb-item"><a href="' . esc_url( get_year_link(get_the_time('Y')) ) . '">' . esc_html( get_the_time('Y') ) . '</a> ' . esc_attr($delimiter) . ' </li>';
		  echo wp_kses_post( $before ) . esc_html( get_the_time('F') ) . $after;
	 
		} elseif ( is_year() ) {
		  echo wp_kses_post( $before ) . esc_html( get_the_time('Y') ) . $after;
	 
		} elseif ( is_single() && !is_attachment() ) {
		  if ( get_post_type() != 'post' ) {
			$post_type = get_post_type_object(get_post_type());
			$cat = array();
			
			if($post_type->name == 'event'){
				$categories = get_the_terms( $post->ID, 'event-categories' );
				if($categories <> ''){
					foreach ( $categories as $category ) {
						$cat[] = $category;
					}
				}
				if(isset($cat[0])){$cat = $cat[0];}
				
				if ($showCurrent == 1) echo wp_kses_post( $before ) . esc_html( get_the_title() ) . $after;	
			}else if($post_type->name == 'testimonial'){
				$categories = get_the_terms( $post->ID, 'testimonial-category' );
				if ( ! is_wp_error( $categories ) && ! empty( $categories ) ) {
					foreach ( $categories as $category ) {
						$cat[] = $category;
					}
				}
				if ( isset( $cat[0] ) ) { $cat = $cat[0]; }
				if ( is_object( $cat ) ) {
					$term_link = get_term_link( $cat->term_id, 'testimonial-category' );
					if ( ! is_wp_error( $term_link ) ) {
						echo '<li class="breadcrumb-item"><a href="' . esc_url( $term_link ) . '">' . esc_html( $cat->name ) . '</a></li>';
					}
				}
				if ($showCurrent == 1) echo wp_kses_post( $before ) . esc_html( get_the_title() ) . $after;	
			}else if($post_type->name == 'services'){
				$categories = get_the_terms( $post->ID, 'services-cat' );
				if ( ! is_wp_error( $categories ) && ! empty( $categories ) ) {
					foreach ( $categories as $category ) {
						$cat[] = $category;
					}
				}
				if ( isset( $cat[0] ) ) { $cat = $cat[0]; }
				if ( is_object( $cat ) ) {
					$term_link = get_term_link( $cat->term_id, 'services-cat' );
					if ( ! is_wp_error( $term_link ) ) {
						echo '<li class="breadcrumb-item"><a href="' . esc_url( $term_link ) . '">' . esc_html( $cat->name ) . '</a></li>';
					}
				}
				if ($showCurrent == 1) echo wp_kses_post( $before ) . esc_html( get_the_title() ) . $after;	
			}else if($post_type->name == 'projects'){
				$categories = get_the_terms( $post->ID, 'projects-category' );
				if ( ! is_wp_error( $categories ) && ! empty( $categories ) ) {
					foreach ( $categories as $category ) {
						$cat[] = $category;
					}
				}
				if ( isset( $cat[0] ) ) { $cat = $cat[0]; }
				if ( is_object( $cat ) ) {
					$term_link = get_term_link( $cat->term_id, 'projects-category' );
					if ( ! is_wp_error( $term_link ) ) {
						echo '<li class="breadcrumb-item"><a href="' . esc_url( $term_link ) . '">' . esc_html( $cat->name ) . '</a></li>';
					}
				}
				if ($showCurrent == 1) echo wp_kses_post( $before ) . esc_html( get_the_title() ) . $after;	
			}else{
				global $wp_query,$post;
				
				$post_type = get_post_type_object(get_post_type());
				$slug = $post_type->rewrite;
				echo '<li class="breadcrumb-item"><a href="' . esc_url($homeLink) . '/' . esc_attr($slug['slug']) . '/">' . esc_html( $post_type->labels->name ) . '</a>';
				if ($showCurrent == 1) echo ' ' . esc_attr($delimiter) . ' </li>' . wp_kses_post( $before ) . esc_html( get_the_title() ) . $after;
			}
		  }else{
			$cat = get_the_category(); 
			if ( ! empty( $cat ) ) {
			$cat = $cat[0];
			$cats = get_category_parents($cat, TRUE, ' ' . esc_attr($delimiter) . ' ');
			if ($showCurrent == 0) $cats = preg_replace("#^(.+)\s$delimiter\s$#", "$1", $cats);
			echo '<li class="breadcrumb-item">'.wp_kses_post( $cats ).'</li>';
			if ($showCurrent == 1) echo wp_kses_post( $before ) . esc_html( wp_trim_words( get_the_title(), 4, '...' ) ) . $after;
			}
		  }
	 
		}elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
			if(class_exists('WooCommerce') && is_shop()){
				echo wp_kses_post( $before ) . esc_html__('Our Products', 'kriate') . $after;
			}else{
				echo wp_kses_post( $before ) . esc_html__('Posted In Category: ', 'kriate') . esc_html( single_cat_title('', false) ) . '' . $after;
			}
		  
		} elseif ( is_attachment() ) {
		  $parent = get_post($post->post_parent);
		  if ( $parent ) {
			  echo '<li class="breadcrumb-item"><a href="' . esc_url(get_permalink($parent)) . '">' . esc_html($parent->post_title) . '</a>';
			  if ($showCurrent == 1) echo ' ' . esc_attr($delimiter) . ' </li>' . wp_kses_post( $before ) . esc_html( get_the_title() ) . $after;
		  }
	 
		} elseif ( is_page() && !$post->post_parent ) {
		  if ($showCurrent == 1) echo wp_kses_post( $before ) . esc_html( get_the_title() ) . $after;
	 
		} elseif ( is_page() && $post->post_parent ) {
		  $parent_id  = $post->post_parent;
		  $breadcrumbs = array();
		  while ($parent_id) {
			$page = get_post($parent_id);
			if ( ! $page ) break;
			$breadcrumbs[] = '<li class="breadcrumb-item"><a href="' . esc_url(get_permalink($page->ID)) . '">' . esc_html(get_the_title($page->ID)) . '</a></li>';
			$parent_id  = $page->post_parent;
		  }
		  $breadcrumbs = array_reverse($breadcrumbs);
		  for ($i = 0; $i < count($breadcrumbs); $i++) {
			echo wp_kses( $breadcrumbs[$i], array( 'li' => array( 'class' => array() ), 'a' => array( 'href' => array() ) ) );
			if ($i != count($breadcrumbs)-1) echo ' ' . esc_attr($delimiter) . ' ';
		  }
		  if ($showCurrent == 1) echo ' ' . esc_attr($delimiter) . ' ' . wp_kses_post( $before ) . esc_html( get_the_title() ) . $after;
	 
		} elseif ( is_tag() ) {
		  echo wp_kses_post( $before ) . esc_html__('Posts tagged: ','kriate').'"' . esc_html( single_tag_title('', false) ) . '"' . $after;
	 
		} elseif ( is_author() ) {
		   global $author;
		  $userdata = get_userdata($author);
		  echo wp_kses_post( $before ) . esc_html__('Posted by: ','kriate') . esc_html( $userdata->display_name ) . $after;
	 
		} elseif ( is_404() ) {
		  echo wp_kses_post( $before ) . esc_html__('Error 404','kriate') . $after;
		}
	 
		if ( get_query_var('paged') ) {
		  if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
		  if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
		}
	 
		echo '</ol>';
	 
	  }
	}
?>