<?php
/**
 * Kriate Theme - functions and definitions
 */
defined( 'ABSPATH' ) || exit;

/*	
	*	function.php
	*	---------------------------------------------------------------------
	*	This file contains all important functions and features of the theme.
	*	---------------------------------------------------------------------
	*/	
	
	/************** Frequently Used Image Sizes In The Theme *************/
	
		add_image_size('kriate-post-detail',770,470, true);			/* Post Detail Image ********(1) */
		add_image_size('kriate-project-detail',470,530, true);		/* Project Detail Image ********(2) */
		
	/************** include essential files to enhance framework functionality *************/
	
		include_once(get_template_directory().	'/includes/files-loader.php');		/* It includes all javacript and style in theme */	
		include_once(get_template_directory().	'/includes/plugins.php');			/* It all the plugins required for the theme */	
		include_once(get_template_directory().	'/includes/core-functions.php');	/* It includes all required functions of theme */
		include_once(get_template_directory().	'/includes/breadcrumbs.php');		/* It includes breadcrumbs of theme pages */
		include_once(get_template_directory().	'/includes/comment-layout.php');	/* It includes custom Comment Layout of theme */
		include_once(get_template_directory().	'/includes/pagination.php');		/* It includes pagination of theme */
		if ( class_exists( 'ReduxFramework' )){
			include_once(get_template_directory().	'/includes/loadstyle.php');			/* It includes default styles of theme */
		}
		/**
		 * Dummy File Load 
		*/
		require get_template_directory() . '/inc/dummy-data/dummy-file.php';
	
		/* Add Redux Framework - after_setup_theme'da yükle (kriate çeviri hatasını önlemek için) */
		add_action( 'after_setup_theme', function() {
			global $kriate_options;
			if ( ! isset( $kriate_options ) && file_exists( get_template_directory() . '/ReduxFramework/theme-options.php' ) ) {
				require_once( get_template_directory() . '/ReduxFramework/theme-options.php' );
			}
		}, 15 );
		
		include_once(get_template_directory().	'/includes/headers/headers.php');			/* Theme headers */	
		include_once(get_template_directory().	'/includes/footers/footers.php');			/* Theme footers */	
		
		/* Super Object */
		include_once(get_template_directory().	'/framework/extensions/super-object.php'); 	/* Super object function */

/* Theme statistics function */