<?php
if ( post_password_required() ) {
	return;
}

// You can start editing here -- including this comment!
if ( have_comments() ) : ?>
	
<div  id = "comments-thread-link" class="comments w-100">
		<h3 class="mb-0" itemprop="headline">
			<?php
			$comments_number = get_comments_number();
			if ( '1' === $comments_number ) {
				/* translators: %s: post title */
				printf( _x( 'One Comment', 'comments title', 'kriate' ), get_the_title() );
			} else {
				printf(
					/* translators: 1: number of comments, 2: post title */
					_nx(
						'%1$s Thoughts to %2$s',
						'%1$s Thoughts to %2$s',
						$comments_number,
						'comments title',
						'kriate'
					),
					number_format_i18n( $comments_number ),
					'<span class = "thm-clr">&#39;'.get_the_title().'&#39;</span>'
				);
			}
			?>
		</h3>

		<ul class="comments-thread mb-0 list-unstyled">
			<?php
				wp_list_comments( 'type=all&callback=kriate_comments' );
			?>
		</ul>
		
		<div class="comments-navigation">
			<div class="previous"> <?php previous_comments_link(esc_html__('Older Comments','kriate')); ?> </div>
			<div class="next"> <?php next_comments_link(esc_html__('Newer Comments','kriate')); ?> </div>
		</div>

	<?php

	// If comments are closed and there are comments, let's leave a little note, shall we?
	if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>

		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'kriate' ); ?></p>
	<?php
	endif;
	?>
</div><!-- #comments -->
<?php 
endif; // Check for have_comments().