<?php
    /**
     * ReduxFramework Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }


    /* This is your option name where all the Redux data is stored. */
    $opt_name = "kriate_options";

    /* This line is only for altering the demo. Can be easily removed. */
    $opt_name = apply_filters( 'kriate_options/opt_name', $opt_name );


    $theme = wp_get_theme(); /* For use with some settings. Not necessary. */

    $args = array(
        /* TYPICAL -> Change these values as you need/desire */
        'opt_name'             => $opt_name,
        /* This is where your data is stored in the database and also becomes your global variable name. */
        'display_name'         => $theme->get( 'Name' ),
        /* Name that appears at the top of your panel */
        'display_version'      => $theme->get( 'Version' ),
        /* Version that appears at the top of your panel */
        'menu_type'            => 'menu',
        /* Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only) */
        'allow_sub_menu'       => true,
       /* Show the sections below the admin menu item or not */
        'menu_title'           => esc_html__( 'Theme Options', 'kriate' ),
        'page_title'           => esc_html__( 'Theme Options', 'kriate' ),
        'google_api_key'       => '',
        /* Set it you want google fonts to update weekly. A google_api_key value is required. */
        'google_update_weekly' => false,
        /* Must be defined to add google fonts to the typography module */
        'async_typography'     => false,
        /* Use a asynchronous font on the front end or font string */
        'admin_bar'            => true,
        /* Show the panel pages on the admin bar */
        'admin_bar_icon'       => 'dashicons-portfolio',
        /* Choose an icon for the admin bar menu */
        'admin_bar_priority'   => 50,
        /* Choose an priority for the admin bar menu */
        'global_variable'      => '',
        /* Set a different name for your global variable other than the opt_name */
        'dev_mode'             => false,
        /* Show the time the page took to load, etc */
        'update_notice'        => false,
        /* If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo */
        'customizer'           => true,
        /* OPTIONAL -> Give you extra features */
        'page_priority'        => null,
        /* Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning. */
        'page_parent'          => 'themes.php',
        /* For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters */
        'page_permissions'     => 'manage_options',
        /* Permissions needed to access the options panel. */
        'menu_icon'            => '',
        /* Specify a custom URL to an icon */
        'last_tab'             => '',
        /* Force your panel to always open to a specific tab (by id) */
        'page_icon'            => 'icon-themes',
        /* Icon displayed in the admin panel next to your menu_title */
        'page_slug'            => '',
        /* Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided */
        'save_defaults'        => true,
        /* On load save the defaults to DB before user clicks save or not */
        'default_show'         => false,
        /* If true, shows the default value next to each field that is not the default value. */
        'default_mark'         => '',
        /* What to print by the field's title if the value shown is default. Suggested: */
        'show_import_export'   => true,
        /* Shows the Import/Export panel when not used as a field. */

        /* CAREFUL -> These options are for advanced use only */
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        /* Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output */
        'output_tag'           => true,
        /* Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head */
        /* FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk. */
        'database'             => '',
        /* possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning! */
        'use_cdn'              => true,
        /* If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code. */

        /* HINTS */
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    ); 

    /* ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items. */
    $args['admin_bar_links'][] = array(
        'id'    => 'demo',
        'href'  => '',
        'title' => esc_html__( 'demo', 'kriate' ),
    );

    /* SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons. */
   
    $args['share_icons'][] = array(
        'url'   => esc_url('https://www.facebook.com/company.themes/'),
        'title' => esc_html__('Like us on Facebook', 'kriate'),
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => esc_url('http://twitter.com/company'),
        'title' => esc_html__('Follow us on Twitter', 'kriate'),
        'icon'  => 'el el-twitter'
    );
    $args['share_icons'][] = array(
        'url'   => esc_url('http://www.linkedin.com/company/company-dot-com'),
        'title' => esc_html__('Find us on LinkedIn', 'kriate'),
        'icon'  => 'el el-linkedin'
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( esc_html__( 'Welcome To WordPress Theme Options Panel', 'kriate' ), $v );
    } else {
        $args['intro_text'] = esc_html__( 'Welcome To WordPress Theme Options Panel', 'kriate' );
    }

    // Add content after the form.
    $args['footer_text'] = esc_html__( ' ', 'kriate' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => esc_html__( 'Theme Information 1', 'kriate' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'kriate' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => esc_html__( 'Theme Information 2', 'kriate' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'kriate' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = esc_html__( '<p>This is the sidebar content, HTML is allowed.</p>', 'kriate' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    /*
    As of Redux 3.6+, there is an extensive API. This API can be used in a mix/match mode allowing for
    */
	// -> START General Settings 
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'General Settings', 'kriate' ),
        'id'               => 'basic-general',
		'icon'             => 'el el-cog',       
        'customizer_width' => '450px',
        'desc'=> esc_html__('Theme General Settings', 'kriate'),
        'fields'           => array(
            array(
				'id'=>'logo_image',
				'type' => 'media', 
				'url'=> true,
				'title' => esc_html__('Logo', 'kriate'),
				'compiler' => 'true',
				'desc'=> esc_html__('Upload your logo Recommended image size:150x55', 'kriate'),
				'subtitle' => esc_html__('Upload your logo', 'kriate'),
				'default'=>array('url'=>''),
			),
			
			array(
				'id'=>'logo_image_light',
				'type' => 'media', 
				'url'=> true,
				'title' => esc_html__('Logo Light', 'kriate'),
				'compiler' => 'true',
				'desc'=> esc_html__('Upload your light colored logo Recommended image size:150x55', 'kriate'),
				'subtitle' => esc_html__('Upload your light colored logo', 'kriate'),
				'default'=>array('url'=>''),
			),
			
			array(
				'id'=>'logo_image_dark',
				'type' => 'media', 
				'url'=> true,
				'title' => esc_html__('Mobile Logo', 'kriate'),
				'compiler' => 'true',
				'desc'=> esc_html__('Upload your logo Recommended image size:150x55', 'kriate'),
				'subtitle' => esc_html__('Upload your Mobile Device Logo', 'kriate'),
				'default'=>array('url'=>''),
			),
			
			array(
				'id'=>'logo_image_sticky',
				'type' => 'media', 
				'url'=> true,
				'title' => esc_html__('Sticy Menu Logo', 'kriate'),
				'compiler' => 'true',
				'desc'=> esc_html__('Upload your logo Recommended image size:150x55', 'kriate'),
				'subtitle' => esc_html__('Upload your Sticky Mobile Logo', 'kriate'),
				'default'=>array('url'=>''),
			),
			
			array(
				'id'=>'logo_width',
				'type' => 'text',
				'title' => esc_html__('Logo Width (In Pixels)', 'kriate'),
				'subtitle' => esc_html__('Add Logo Width In Pixels', 'kriate'),
				'desc' => esc_html__('Add Logo Width In Pixels Here, i.e 150', 'kriate'),
				'default' => ''
			),
			
			array(
				'id'=>'logo_height',
				'type' => 'text',
				'title' => esc_html__('Logo Height (In Pixels)', 'kriate'),
				'subtitle' => esc_html__('Add Logo Height In Pixels', 'kriate'),
				'desc' => esc_html__('Add Logo Height In Pixels Here, i.e 55', 'kriate'),
				'default' => ''
			),

        )
    ) );
    
	// -> START Header Settings 
	Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Header Settings', 'kriate' ),
        'id'               => 'homepagesections',
        'desc'             => esc_html__( 'Manage Header Sections!', 'kriate' ),
        'customizer_width' => '400px',
        'icon'             => 'el el-dashboard'
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Main Settings', 'kriate' ),
        'id'         => 'StaticBannersettings',
		'icon'             => 'el el-screen',
        'subsection' => true,
        'desc' => esc_html__('Main Settings of Header Section', 'kriate'), 
        'fields'     => array(
		
			/* Select Header Style */
			array(
				'id'       => 'select-header-layout',
				'type'     => 'image_select',
				'title'    => __('Header Style', 'kriate'), 
				'subtitle' => __('Select Header for search, blog posts, archive and post detail pages. (For pages, use header option inside pages)', 'kriate'),
				'options'  => array(
					
					'header1'      => array(
						'alt'   => esc_attr__('Header 1', 'kriate'),
						'img'   => get_template_directory_uri().'/assets/images/headers/header1.png'
					),
					'header2'      => array(
						'alt'   => esc_attr__('Header 2', 'kriate'),
						'img'   => get_template_directory_uri().'/assets/images/headers/header2.png'
					),
					'header3'      => array(
						'alt'   => esc_attr__('Header 3', 'kriate'),
						'img'   => get_template_directory_uri().'/assets/images/headers/header3.png'
					)
				),
				'default' => 'header1'
			),
			
			/*Turn On/Off Sticky Header */		
			array(
				'id' => 'header_stickyhead_switch',
				'type' => 'switch',
				'title' => esc_html__('Sticky Header', 'kriate'),
				'subtitle' => esc_html__('Turn on/off Sticky Header', 'kriate'),
				'default' => 0,
            ),

			
			/* Top Bar Switch Fields */		
			array(
				'id' => 'header_topbar_switch',
				'type' => 'switch',
				'title' => esc_html__('Header TopBar', 'kriate'),
				'subtitle' => esc_html__('Turn on/off Top Bar From Here', 'kriate'),
				'default' => 0,
            ),
			
			array(
				'id'=>'header_phone_caption',
				'type' => 'text',
				'title' => esc_html__('Phone Caption', 'kriate'),
				'subtitle' => esc_html__('Add Phone Caption Here.', 'kriate'),
				'desc' => esc_html__('Add Phone Caption Here e.g 24/7 Phone Services', 'kriate'),
				'default' => '24/7 Phone Services'
			),
			
			
			array(
				'id'=>'header_phone_no',
				'type' => 'text',
				'title' => esc_html__('Phone Number', 'kriate'),
				'subtitle' => esc_html__('Add Phone Number here.', 'kriate'),
				'desc' => esc_html__('Add Phone Number here e.g 555 666 999 00', 'kriate'),
				'default' => '555 666 999 00'
			),
			
			
			/* Header Cart */		
			array(
				'id' => 'header_cart',
				'type' => 'switch',
				'title' => esc_html__('Cart in Header', 'kriate'),
				'subtitle' => esc_html__('Turn on/off Cart From Header', 'kriate'),
				'default' => 0,
            ),
			

			array(
				'id'=>'signup_text',
				'type' => 'text',
				'title' => esc_html__('Header Button', 'kriate'),
				'subtitle' => esc_html__('Add Header Button Text', 'kriate'),
				'desc' => esc_html__('Add Header Button Text Here, e.g Wants To Visit ?', 'kriate'),
				'default' => esc_html__('Wants To Visit ?', 'kriate')
			),
			
			array(
				'id'=>'signup_url',
				'type' => 'text',
				'title' => esc_html__('Header Page URL', 'kriate'),
				'subtitle' => esc_html__('Add Header Page URL.', 'kriate'),
				'desc' => esc_html__('Add Header Page Address Here', 'kriate'),
				'default' => ''
			),
			
			array(
				'id' => 'header_social_switch',
				'type' => 'switch',
				'title' => esc_html__('Social Icons', 'kriate'),
				'subtitle' => esc_html__('Turn on/off Top Bar Social Icons From Here (For Header 1 & 3)', 'kriate'),
				'default' => 0,
            ),
			
			
			array(
				'id'=>'phone_number',
				'type' => 'text',
				'title' => esc_html__('Address', 'kriate'),
				'subtitle' => esc_html__('Add Address Here', 'kriate'),
				'desc' => esc_html__('Add location or Address Here, e.g 27 Division, Mirpur-12, Pallbi.', 'kriate'),
				'default' => esc_html__('27 Division, Mirpur-12, Pallbi.', 'kriate')
			),
			
			array(
				'id'=>'email_id',
				'type' => 'text',
				'title' => esc_html__('Email ID', 'kriate'),
				'subtitle' => esc_html__('Add Email ID For Header', 'kriate'),
				'desc' => esc_html__('Add Email Address Here', 'kriate'),
				'default' => esc_html__('info@example.com', 'kriate')
			),

		)
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Header Background', 'kriate' ),
        'id'         => 'call-to-section',
		'icon'             => 'el el-picture',
        'subsection' => true,
        'desc' => esc_html__('Upload Inner Header/Breadcrumb Background Image Here', 'kriate'), 
        'fields'     => array(	
		
			array(
				'id'=>'inner_header_bg',
				'type' => 'media', 
				'url'=> true,
				'title' => esc_html__('Header Background', 'kriate'),
				'compiler' => 'true',
				//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'=> esc_html__('Upload Inner Header Background Image', 'kriate'),
				'subtitle' => esc_html__('Upload Inner Header Background Image Here', 'kriate'),
				'default'=>array('url'=>''),
			),
			
			/* breadcrumbs */
			array(
				'id' => 'breadcrumbs',
				'type' => 'switch',
				'title' => esc_html__('Breadcrumbs', 'kriate'),
				'subtitle' => esc_html__('Turn on/off Breadcrumbs From Here', 'kriate'),
				'default' => 1,
            ),
			
		
		)
    ) );
	
	
	// -> START Color Selection
    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Color Selection', 'kriate' ),
        'id'    => 'color',
        'desc'  => esc_html__( 'Color Selection', 'kriate' ),
        'icon'  => 'el el-brush',
		'fields' => array(
			
			array(
				'id'       => 'color-primary',
				'type'     => 'color',
				'title'    => esc_html__('Primary Color', 'kriate'), 
				'subtitle' => esc_html__('Pick a Primary Color default: #0a993c', 'kriate'),
				'default'  => '#ff5e15',
				'validate' => 'color',
				'transparent' => false,
			),
			
			array(
				'id'       => 'color-secondary',
				'type'     => 'color',
				'title'    => esc_html__('Secondary Color', 'kriate'), 
				'subtitle' => esc_html__('Pick a Secondary Color default: #0a1024', 'kriate'),
				'default'  => '#0a1024',
				'validate' => 'color',
				'transparent' => false,
			),
			
			array(
				'id'       => 'select-bodybg-type',
				'type'     => 'select',
				'title'    => esc_html__('Select Background Type', 'kriate'), 
				'subtitle' => esc_html__('Background Type For Whole Site', 'kriate'),
				'desc'     => esc_html__('Please select background pattern or background color..', 'kriate'),
				// Must provide key => value pairs for select options
				'options'  => array(
					'color'		 => esc_html__('Color', 'kriate'),
					'pattren' 	 => esc_html__('Pattren', 'kriate'),
					'image' 	 => esc_html__('Image', 'kriate')
				),
				'default'  => 'color',
			),
			
			array(
				'id'       => 'body_color',
				'type'     => 'color',
				'title'    => esc_html__('Body Background', 'kriate'), 
				'subtitle' => esc_html__('Only Applicable If you selected Color from Background Type.', 'kriate'),
				'default'  => '#ffffff',
				'validate' => 'color',
				'transparent' => false,
			),
			
			array(
				'id'       => 'body_patterns',
				'type'     => 'image_select',
				'title'    => esc_html__('Body Pattern', 'kriate'), 
				'subtitle' => esc_html__('Only Applicable if you selected Pattern From Background Type.', 'kriate'),
				'options'  => array(
					'1'      => array(
						'alt'   => esc_attr__('Pattern 1','kriate'), 
						'img'   => get_template_directory_uri().'/assets/images/pattern/pattern-1.png'
					),
					'2'      => array(
						'alt'   => esc_attr__('Pattern 2','kriate'), 
						'img'   => get_template_directory_uri().'/assets/images/pattern/pattern-2.png'
					),
					'3'      => array(
						'alt'   => esc_attr__('Pattern 3','kriate'), 
						'img'   => get_template_directory_uri().'/assets/images/pattern/pattern-3.png'
					),
					'4'      => array(
						'alt'   => esc_attr__('Pattern 4','kriate'), 
						'img'   => get_template_directory_uri().'/assets/images/pattern/pattern-4.png'
					),
					'5'      => array(
						'alt'   => esc_attr__('Pattern 5','kriate'), 
						'img'   => get_template_directory_uri().'/assets/images/pattern/pattern-5.png'
					),
					'6'      => array(
						'alt'   => esc_attr__('Pattern 6','kriate'), 
						'img'   => get_template_directory_uri().'/assets/images/pattern/pattern-6.png'
					)
				),
				'default' => '2'
			),
			
			array(
				'id'=>'background_image',
				'type' => 'media', 
				'url'=> true,
				'title' => esc_html__('Background Image', 'kriate'),
				'compiler' => 'true',
				//'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'=> esc_html__('Upload Background Image For Body Background', 'kriate'),
				'subtitle' => esc_html__('Only Applicable if you selected Background Image From Background Type.', 'kriate'),
				'default'=>array('url'=>''),
			),
			
		)
    ) );
	

	// -> START Editors
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Footer Settings', 'kriate' ),
        'id'               => 'footer-settings',
        'customizer_width' => '500px',
        'icon'             => 'el el-pencil',
		'desc'  => esc_html__( 'You can find all your Footer Settings here.', 'kriate' ),
		'fields'     => array(
			array(
				'id'=>'footer_copy_right',
				'type' => 'textarea',
				'title' => esc_html__('CopyRight Text - HTML Validated', 'kriate'), 
				'subtitle' => esc_html__('Custom HTML Allowed (wp_kses)', 'kriate'),
				'desc' => esc_html__('You can have html in it as well. Allowed Tags Includes a, br, em, strong.', 'kriate'),
				'validate' => 'html_custom',
				'default' => esc_html__('Copyright 2021, ','kriate').' <a class="theme-clr" href="#" target="_blank">'.esc_html__('All Rights Reserved','kriate').'</a>',
				'allowed_html' => array(
					'a' => array(
						'href' => array(),
						'target' => array()
					),
					'br' => array(),
					'p' => array(),
					'em' => array(),
					'strong' => array()
				)
			),
			
			/* Select Footer Style */
			array(
				'id'       => 'select-footer-layout',
				'type'     => 'image_select',
				'title'    => __('Footer Style', 'kriate'), 
				'subtitle' => __('Select Footer for search, blog posts, archive and post detail pages. (For pages, use Footer option inside pages)', 'kriate'),
				'options'  => array(
					
					'footer1'      => array(
						'alt'   => esc_attr__('Footer 1', 'kriate'), 
						'img'   => get_template_directory_uri().'/assets/images/footers/footer1.png'
					),
					'footer2'      => array(
						'alt'   => esc_attr__('Footer 2', 'kriate'),
						'img'   => get_template_directory_uri().'/assets/images/footers/footer2.png'
					),
					'footer3'      => array(
						'alt'   => esc_attr__('Footer 3', 'kriate'),
						'img'   => get_template_directory_uri().'/assets/images/footers/footer3.png'
					)
				),
				'default' => 'footer1'
			),
			
			array(
				'id'       => 'default-footer-columns',
				'type'     => 'select',
				'title'    => __('Select Default Footer Layout', 'kriate'), 
				'subtitle' => __('Default Footer Layout, only for *Footer* Sidebar', 'kriate'),
				'desc'     => __('This will only work if Footer - Spaces-* are empty.', 'kriate'),
				// Must provide key => value pairs for select options
				'options'  => array(
					'2-col' => '2 Columns',
					'3-col' => '3 Columns',
					'4-col' => '4 Columns'
				),
				'default'  => '4-col',
			),



		)
    ) );
	
	 // -> START Design Fields
    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Sidebars', 'kriate' ),
        'id'    => 'unlimited-sidebars',
        'desc'  => esc_html__( 'You Can Add Unlimited Sidebars From Here.', 'kriate' ),
        'icon'  => 'el el-th-list',
		'fields' => array(
			array(
				'id'=>'multi-text',
				'type' => 'multi_text',
				'title' => esc_html__('Unlimited Sidebars', 'kriate'),
				'subtitle' => esc_html__('Add Sidebar Name Here, It will be added.', 'kriate'),
				'desc' => esc_html__('New Sidebar Will Appear In Appearence > Widgets Panel.', 'kriate'),
				'default' => array(),
			),
			
			$fields = array(
				'id'       => 'sidebar-layout',
				'type'     => 'image_select',
				'title'    => esc_html__('Default Page Layout', 'kriate'), 
				'subtitle' => esc_html__('Index, Search, Archive Layout. Default Sidebar Will Be Used', 'kriate'),
				'options'  => array(
					'left'      => array(
						'alt'   => esc_attr__('Left Sidebar', 'kriate'), 
						'img'   => esc_url(get_template_directory_uri().'/assets/images/sidebars/left-sidebar.jpg')
					),
					'wide'      => array(
						'alt'   => esc_attr__('No Sidebar', 'kriate'), 
						'img'   => esc_url(get_template_directory_uri().'/assets/images/sidebars/no-sidebar.jpg')
					),
					'right'      => array(
						'alt'   => esc_attr__('Right Sidebar', 'kriate'), 
						'img'  => esc_url(get_template_directory_uri().'/assets/images/sidebars/right-sidebar.jpg')
					),
				),
				'default' => 'right'
			),
		)	
    ) );
    
    // -> START Design Fields
    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Social Links', 'kriate' ),
        'id'    => 'social-links',
        'desc'  => esc_html__( 'Put Social Profile Links Here', 'kriate' ),
        'icon'  => 'el el-glasses',
		'fields' => array(

		array(
			'id'=>'twitter-link',
			'type' => 'text',
			'title' => esc_html__('Twitter Page URL', 'kriate'),
			'subtitle' => esc_html__('This must be a URL.', 'kriate'),
			'desc' => esc_html__('Twitter Profile Page URL', 'kriate'),
			'validate' => 'url',
			'default' => esc_url('http://twitter.com')
			),
			
		array(
			'id'=>'facebook-link',
			'type' => 'text',
			'title' => esc_html__('Facebook Page URL', 'kriate'),
			'subtitle' => esc_html__('This must be a URL.', 'kriate'),
			'desc' => esc_html__('Facebook Profile Page URL', 'kriate'),
			'validate' => 'url',
			'default' => esc_url('http://facebook.com')
			),
			
		array(
			'id'=>'instagram-link',
			'type' => 'text',
			'title' => esc_html__('Instagram Page URL', 'kriate'),
			'subtitle' => esc_html__('This must be a URL.', 'kriate'),
			'desc' => esc_html__('Instagram Profile Page URL', 'kriate'),
			'validate' => 'url',
			'default' => esc_url('https://Instagram.com/')
			),

		array(
			'id'=>'linkedin-link',
			'type' => 'text',
			'title' => esc_html__('LinkedIn Page URL', 'kriate'),
			'subtitle' => esc_html__('This must be a URL.', 'kriate'),
			'desc' => esc_html__('LinkedIn Profile Page URL', 'kriate'),
			'validate' => 'url',
			'default' => esc_url('http://www.linkedin.com/')
			),
		
		array(
			'id'=>'youtube-link',
			'type' => 'text',
			'title' => esc_html__('Youtube Page URL', 'kriate'),
			'subtitle' => esc_html__('This must be a URL.', 'kriate'),
			'desc' => esc_html__('Youtube Profile Page URL', 'kriate'),
			'validate' => 'url',
			'default' => esc_url('http://www.youtube.com/')
			),
		)
    ) );

    // -> START Fonts
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Fonts', 'kriate' ),
        'id'     => 'Fonts',
        'desc' => esc_html__('Select Fonts for your Website', 'kriate'),
        'icon'   => 'el el-font',
        'fields' => array(           
            array(
            'id' => 'heading1-font',
            'type' => 'typography',
            'title' => esc_html__('H1 Font', 'kriate'),
            'subtitle' => esc_html__('Specify the headings font properties.', 'kriate'),
            'google' => true,
			'text-align' => false,
			'line-height' => false,
			'subsets' => false,
			'units'       =>'px',
            'output' => array('body h1'),
            'default' => array(
                'color' => '#222',
                'font-size' => '70px',
                'font-family' => 'Poppins',
                'font-weight' => '600',
                ),
         	),

		array(
            'id' => 'heading2-font',
            'type' => 'typography',
            'title' => esc_html__('H2 Font', 'kriate'),
            'subtitle' => esc_html__('Specify the headings font properties.', 'kriate'),
            'google' => true,
			'text-align' => false,
			'line-height' => false,
			'subsets' => false,
            'output' => array('body h2'),
            'default' => array(
                'color' => '#222',
                'font-size' => '32px',
                'font-family' => 'Poppins',
                'font-weight' => '600',
                ),
         	),

		array(
            'id' => 'heading3-font',
            'type' => 'typography',
            'title' => esc_html__('H3 Font', 'kriate'),
            'subtitle' => esc_html__('Specify the headings font properties.', 'kriate'),
            'google' => true,
			'text-align' => false,
			'line-height' => false,
			'subsets' => false,
			'all_styles' => true, /* enqueue all fonts */
            'output' => array('body h3'),
            'default' => array(
				'color' => '#222',
                'font-size' => '28px',
                'font-family' => 'Poppins',
                'font-weight' => '600',
                ),
         	),

		array(
            'id' => 'heading4-font',
            'type' => 'typography',
            'title' => esc_html__('H4 Font', 'kriate'),
            'subtitle' => esc_html__('Specify the headings font properties.', 'kriate'),
            'google' => true,
			'text-align' => false,
			'line-height' => false,
			'subsets' => false,
            'output' => array('body h4'),
            'default' => array(
				'color' => '#222',
                'font-size' => '22px',
                'font-family' => 'Poppins',
                'font-weight' => '600',
                ),
         	),

		array(
            'id' => 'heading5-font',
            'type' => 'typography',
            'title' => esc_html__('H5 Font', 'kriate'),
            'subtitle' => esc_html__('Specify the headings font properties.', 'kriate'),
            'google' => true,
			'text-align' => false,
			'line-height' => false,
			'subsets' => false,
            'output' => array('body h5 '),
            'default' => array(
				'color' => '#222',
                'font-size' => '18px',
                'font-family' => 'Poppins',
                'font-weight' => '600',
                ),
         	),

		array(
            'id' => 'heading6-font',
            'type' => 'typography',
            'title' => esc_html__('H6 Font', 'kriate'),
            'subtitle' => esc_html__('Specify the headings font properties.', 'kriate'),
            'google' => true,
			'text-align' => false,
			'line-height' => false,
			'subsets' => false,
            'output' => array('body h6 '),
            'default' => array(
				'color' => '#222',
                'font-size' => '16px',
                'font-family' => 'Poppins',
                'font-weight' => '600',
                ),
         	),

		array(
            'id' => 'body-font',
            'type' => 'typography',
            'title' => esc_html__('Body Font', 'kriate'),
            'subtitle' => esc_html__('Specify the body font properties.', 'kriate'),
            'google' => true,
			'text-align' => false,
			'line-height' => false,
			'subsets' => false,
			'all_styles' => true,
            'output' => array('body .elementor-text-editor :not(p), .post-detail > p, .about-desc > p, .serv-box-inner p, .sec-title-inner p, .hotty .sec-title-inner2 > h2 + p, .solutions-list > li > h4 + p, .testi-info > h3 + p, .post-info > h3 + p, .about-widget > h4 + p'),
            'default' => array(
                'color' => '#555',
                'font-size' => '15px',
                'font-family' => 'Open Sans',
                'font-weight' => '400',
                ),
         	),
			
			array(
            'id' => 'nav-font',
            'type' => 'typography',
            'title' => esc_html__('Nav Menu Font', 'kriate'),
            'subtitle' => esc_html__('Specify the Navigantion Menu font properties.', 'kriate'),
            'google' => true,
			'text-align' => false,
			'line-height' => false,
			'subsets' => false,
            'output' => array('nav ul li a'),
            'default' => array(
                'color' => '#fff',
                'font-size' => '15px',
                'font-family' => 'Poppins',
                'font-weight' => '400',
                ),
         	),
        )
    ) );  
	
		
	// -> START Editors
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Misc Settings', 'kriate' ),
        'id'               => 'misc-settings',
        'customizer_width' => '500px',
        'icon'             => 'el el-pencil',
		'desc'  => esc_html__( 'You can find all your Miscellenous Settings here.', 'kriate' ),
		'fields'     => array(
			/*array(
				'id' => 'rtl_switch',
				'type' => 'switch',
				'title' => esc_html__('RTL Layout', 'kriate'),
				'subtitle' => esc_html__('Turn on/off RTL Display of Theme.', 'kriate'),
				'default' => 0,
            ),*/
			
			array(
				'id' => 'anime_switch',
				'type' => 'switch',
				'title' => esc_html__('Animation Effects', 'kriate'),
				'subtitle' => esc_html__('Turn on/off Animation Effects On Blocks.', 'kriate'),
				'default' => 0,
            ),
			
			array(
				'id'=>'google_map_apikey',
				'type' => 'text',
				'title' => esc_html__('Google Map API Key', 'kriate'),
				'subtitle' => esc_html__('Add Google Map API Key Here.', 'kriate'),
				'desc' => esc_html__('You can get API Key From https://developers.google.com/maps/documentation/javascript/get-api-key.', 'kriate'),
				'default' => ''
			),

		)
    ) );

    /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

    /*
    *
    * --> Action hook examples
    *
    */

    // If Redux is running as a plugin, this will remove the demo notice and links
    add_action( 'redux/loaded', 'remove_demo' );

    // Function to test the compiler hook and demo CSS output.
    // Above 10 is a priority, but 2 in necessary to include the dynamically generated CSS to be sent to the function.
    //add_filter('redux/options/' . $opt_name . '/compiler', 'compiler_action', 10, 3);

    // Change the arguments after they've been declared, but before the panel is created
    //add_filter('redux/options/' . $opt_name . '/forum-press', 'change_arguments' );

    // Change the default value of a field after it's been set, but before it's been useds
    //add_filter('redux/options/' . $opt_name . '/defaults', 'change_defaults' );

    // Dynamically add a section. Can be also used to modify sections/fields
    //add_filter('redux/options/' . $opt_name . '/sections', 'dynamic_section');

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>'.esc_html__('The compiler hook has run!', 'kriate').'</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $return['error'] = $field;
                $field['msg']    = esc_html__('your custom error message', 'kriate');
            }

            if ( $warning == true ) {
                $return['warning'] = $field;
                $field['msg']      = esc_html__('your custom warning message', 'kriate');
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => esc_html__( 'Section via hook', 'kriate' ),
                'desc'   => esc_html__( 'This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.', 'kriate' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = esc_html__('Testing filter hook!', 'kriate');

            return $defaults;
        }
    }

    /**
     * Removes the demo link and the notice of integrated demo from the redux-framework plugin
     */
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            
        }
    }