<?php
class UserCounter extends WP_Widget
{
	public function __construct() { 
	
		$widget_ops = array('classname' => '', 'description' => 'Add User/Visitor Counter' );
		parent::__construct('map_widget', '*Visitor Count', $widget_ops);
	
	}
	

  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title = $instance['title'];
	$text_1 = isset( $instance['text_1'] ) ? esc_attr( $instance['text_1'] ) : '';
	$counter_1 = isset( $instance['counter_1'] ) ? esc_attr( $instance['counter_1'] ) : '';
	$text_2 = isset( $instance['text_2'] ) ? esc_attr( $instance['text_2'] ) : '';
	$counter_2 = isset( $instance['counter_2'] ) ? esc_attr( $instance['counter_2'] ) : '';
?>
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
		 <?php esc_html_e('Title:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
	  </label>
	</p>

	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('text_1')); ?>">
		 <?php esc_html_e('Field 1 Text:','kriate');?> 
		  <input class="widefat" size="2" id="<?php echo esc_attr($this->get_field_id('text_1')); ?>" name="<?php echo esc_attr($this->get_field_name('text_1')); ?>" type="text" value="<?php echo esc_attr($text_1); ?>" />
	  </label>
	</p>	

	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('counter_1')); ?>">
		 <?php esc_html_e('Counter Number 1:','kriate');?> 
		  <input class="widefat" size="2" id="<?php echo esc_attr($this->get_field_id('counter_1')); ?>" name="<?php echo esc_attr($this->get_field_name('counter_1')); ?>" type="text" value="<?php echo esc_attr($counter_1); ?>" />
	  </label>
	</p>
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('text_2')); ?>">
		 <?php esc_html_e('Field 2 Text:','kriate');?> 
		  <input class="widefat" size="2" id="<?php echo esc_attr($this->get_field_id('text_2')); ?>" name="<?php echo esc_attr($this->get_field_name('text_2')); ?>" type="text" value="<?php echo esc_attr($text_2); ?>" />
	  </label>
	</p>	

	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('counter_2')); ?>">
		 <?php esc_html_e('Counter Number 2:','kriate');?> 
		  <input class="widefat" size="2" id="<?php echo esc_attr($this->get_field_id('counter_2')); ?>" name="<?php echo esc_attr($this->get_field_name('counter_2')); ?>" type="text" value="<?php echo esc_attr($counter_2); ?>" />
	  </label>
	</p>
<?php
  }
 
  function update($new_instance, $old_instance)
  {
  	$text_1 = isset( $instance['text_1'] ) ? esc_attr( $instance['text_1'] ) : '';
	$counter_1 = isset( $instance['counter_1'] ) ? esc_attr( $instance['counter_1'] ) : '';
	$text_2 = isset( $instance['text_2'] ) ? esc_attr( $instance['text_2'] ) : '';
	$counter_2 = isset( $instance['counter_2'] ) ? esc_attr( $instance['counter_2'] ) : '';
	
    $instance = $old_instance;
    $instance['text_1'] = $new_instance['text_1'];
    $instance['counter_1'] = $new_instance['counter_1'];
	$instance['text_2'] = $new_instance['text_2'];
	$instance['counter_2'] = $new_instance['counter_2'];
    return $instance;
  }
 
	function widget($args, $instance)
	{
		
		extract($args, EXTR_SKIP);
		$title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
		$text_1 = isset( $instance['text_1'] ) ? esc_attr( $instance['text_1'] ) : '';		
		$counter_1 = isset( $instance['counter_1'] ) ? esc_attr( $instance['counter_1'] ) : '';	
		$text_2 = isset( $instance['text_2'] ) ? esc_attr( $instance['text_2'] ) : '';		
		$counter_2 = isset( $instance['counter_2'] ) ? esc_attr( $instance['counter_2'] ) : '';	
	
	
		echo html_entity_decode($before_widget);	

		echo html_entity_decode($before_title);
		
		echo esc_attr($title);
		
		echo html_entity_decode($after_title);
		
		wp_enqueue_script( 'counterup-js', get_template_directory_uri() . '/assets/js/counterup.min.js', array('jquery'), '1.0.0', true );
		
		echo
		
		'<div class="visitor-stats w-100">
			<div class="visitor-stat-box w-100">
				<h4 class="mb-0 thm-clr counter">'.$counter_1.'</h4>
				<h5 class="mb-0">'.$text_1.'</h5>
			</div>
			<div class="visitor-stat-box w-100">
				<h4 class="mb-0 text-color4 counter">'.$counter_2.'</h4>
				<h5 class="mb-0">'.$text_2.'</h5>
			</div>
		</div>';

		echo html_entity_decode($after_widget);	
	}
}
	
if ( ! version_compare( PHP_VERSION, '5.3.0', '>=' ) ) {
   add_action( 'widgets_init', function() { register_widget( 'UserCounter' ); } );
}else{
    function UserCounter_widget_init (){
        return register_widget('UserCounter');
    }
    add_action ('widgets_init', 'UserCounter_widget_init');
}?>