<?php
class recent_posts_widget extends WP_Widget
{
	public function __construct() { 
	
		$widget_ops = array('classname' => 'widget style2', 'description' => 'Select Widget To Display Recent Posts' );
		parent::__construct('recent_posts_widget', '* Show Recent Posts', $widget_ops);
	
	}
 
 
  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title = $instance['title'];
	$get_cate_posts = isset( $instance['get_cate_posts'] ) ? esc_attr( $instance['get_cate_posts'] ) : '';
	$nop = isset( $instance['nop'] ) ? esc_attr( $instance['nop'] ) : '';
?>
  <p>
	  <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
		 <?php esc_html_e('Title:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
	  </label>
  </p>
  
  <p>
	  <label for="<?php echo esc_attr($this->get_field_id('nop')); ?>">
		 <?php esc_html_e('Number of Posts To Display:','kriate');?> 
		  <input class="widefat" size="2" id="<?php echo esc_attr($this->get_field_id('nop')); ?>" name="<?php echo esc_attr($this->get_field_name('nop')); ?>" type="text" value="<?php echo esc_attr($nop); ?>" />
	  </label>
  </p>
<?php
  }
 
  function update($new_instance, $old_instance)
  {
  
    $instance = $old_instance;
    $instance['title'] = $new_instance['title'];
    $instance['get_cate_posts'] = $new_instance['get_cate_posts'];	
	$instance['nop'] = $new_instance['nop'];
    return $instance;
  }
 
	function widget($args, $instance)
	{
		
		extract($args, EXTR_SKIP);
		$title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
		$get_cate_posts = isset( $instance['get_cate_posts'] ) ? esc_attr( $instance['get_cate_posts'] ) : '';		
		$nop = isset( $instance['nop'] ) ? esc_attr( $instance['nop'] ) : '';	
	
		if($nop == ""){$nop = '-1';}
		echo html_entity_decode($before_widget);	
		// WIDGET display CODE Start
		

		if (!empty($title))
			echo html_entity_decode($before_title);
			echo esc_attr($title);
			echo html_entity_decode($after_title);
		?>
		
	
			<div class="mini-posts-wrap w-100">
									
			<?php
				
				$category_array = get_term_by('id', esc_attr($get_cate_posts), 'category');
				
				$popularpost = new WP_Query( array( 'ignore_sticky_posts' => true,'posts_per_page' => $nop, 'post_type'=> 'post', 'orderby' => 'date', 'order' => 'DESC'  ) );
				
				
					while ( $popularpost->have_posts() ) : $popularpost->the_post(); global $post; 
					
					if(strlen(get_the_title()) > 35){
						$title = wp_trim_words( get_the_title(), 7, '...' );

					}else{
						$title = get_the_title();
					}
					
					$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 60, 60, 'bfi_thumb' => true )); ?>
					
					<div class="mini-post-box d-flex flex-wrap w-100">
						<a href="<?php echo get_the_permalink(); ?>" title="">
							<img class="img-fluid w-100" src="<?php echo esc_url($featured_image_url); ?>" alt="<?php esc_attr__('Featured Image','kriate'); ?>">
						</a>
						<div class="mini-post-info">
							<span class="d-block thm-clr"><?php echo get_the_date('M d, Y'); ?></span>
							<h4 class="mb-0"><a href="<?php echo get_the_permalink(); ?>" title=""><?php echo $title; ?></a></h4>
						</div>
					</div>

					<?php  endwhile; wp_reset_postdata(); ?>				
			
			</div>
		
<?php  	
	

	echo html_entity_decode($after_widget);
		}
	}
	
if ( ! version_compare( PHP_VERSION, '5.3.0', '>=' ) ) {
   add_action( 'widgets_init', function() { register_widget( 'recent_posts_widget' ); } );
}else{
    function recent_posts_widget_init (){
        return register_widget('recent_posts_widget');
    }
    add_action ('widgets_init', 'recent_posts_widget_init');
}

?>