<?php
class image_video_widget extends WP_Widget
{
  
	public function __construct() { 
	
		$widget_ops = array('classname' => 'p-0 video-widget', 'description' => 'Image & Video' );
		parent::__construct('image_video_widget', '*Image & Video Widget', $widget_ops);
	
	}
 
  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
	$title = $instance['title'];
	$kriate_desc = isset( $instance['desc'] ) ? esc_attr( $instance['desc'] ) : 'https://www.youtube.com/embed/6gUOzbhtVd4';
	$kriate_logo = isset( $instance['logo'] ) ? esc_attr( $instance['logo'] ) : get_template_directory_uri().'/assets/images/logo2.png';	?>
	
	<p>
		<label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
			<?php esc_html_e('Title:','kriate');?>  
			<input class="widefat"  id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</label>
	</p>

	<p>
		<label for="<?php echo esc_attr($this->get_field_id('desc')); ?>"></label>
		<?php esc_html_e('Video Embed URL:','kriate');?>  
        <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('desc')); ?>" name="<?php echo esc_attr($this->get_field_name('desc')); ?>"><?php echo esc_attr($kriate_desc); ?></textarea>
    </p>
	
	<p>
		<label for="<?php echo esc_attr($this->get_field_id('logo')); ?>">
			<?php esc_html_e('Image URL:','kriate');?>  
			<input class="widefat"  id="<?php echo esc_attr($this->get_field_id('logo')); ?>" name="<?php echo esc_attr($this->get_field_name('logo')); ?>" type="text" value="<?php echo esc_attr($kriate_logo); ?>" />
		</label>
	</p>

  
<?php
  
  }/* end of form function*/
 
  function update($new_instance, $old_instance)
  {
  
    $instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['desc'] = $new_instance['desc'];
		$instance['logo'] = $new_instance['logo'];
		
		return $instance;
  
  }/* end of update function */
 
	function widget($args, $instance)
	{
		
		extract($args, EXTR_SKIP);
		
		$kriate_title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$kriate_desc = isset( $instance['desc'] ) ? esc_attr( $instance['desc'] ) : '';
		$kriate_logo = isset( $instance['logo'] ) ? esc_attr( $instance['logo'] ) : '';
		
		echo html_entity_decode($before_widget); 
		
		$html = '<div class="widget-video-box w-100 position-relative">';
		$html .= '<img class="img-fluid w-100" src="'.$kriate_logo.'" alt="Widget Video Image">';
		$html .= '<a class="spinner" href="'.$kriate_desc.'" data-fancybox="" title=""><i class="fas fa-plus"></i></a>
		</div>';
		
		echo $html;
		
		/* WIDGET display CODE End*/
		echo html_entity_decode($after_widget);
		
		
	}/* end of widegat function */
	
}/* end of about_widget class */
	
if ( ! version_compare( PHP_VERSION, '5.3.0', '>=' ) ) {
   add_action( 'widgets_init', function() { register_widget( 'image_video_widget' ); } );
}else{
    function image_video_widget_init (){
        return register_widget('image_video_widget');
    }
    add_action ('widgets_init', 'image_video_widget_init');
}	
?>