<?php
class footer_nav_menu_widget extends WP_Widget
{
	public function __construct() { 
	
		$widget_ops = array('classname' => 'widget', 'description' => 'Select Nav Menu To Show Links' );
		parent::__construct('footer_nav_menu_widget', '*Show Nav Menu', $widget_ops);
	
	}
	

  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title = $instance['title'];
	$get_cate_posts = isset( $instance['get_cate_posts'] ) ? esc_attr( $instance['get_cate_posts'] ) : '';
	$nop = isset( $instance['nop'] ) ? esc_attr( $instance['nop'] ) : '';
?>
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
		 <?php esc_html_e('Title:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
	  </label>
	</p>   
  
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('get_cate_posts')); ?>">
		  <?php esc_html_e('Select Category:','kriate');?>
		  <select id="<?php echo esc_attr($this->get_field_id('get_cate_posts')); ?>" name="<?php echo esc_attr($this->get_field_name('get_cate_posts')); ?>" class="widefat">
			<?php
					foreach ( kriate_get_category_list_array('nav_menu') as $category){ ?>
						<option <?php if(esc_attr($get_cate_posts) == $category->slug){echo 'selected';}?> value="<?php echo esc_attr($category->slug);?>" >
							<?php echo substr($category->name, 0, 20);	if ( strlen($category->name) > 20 ) echo "...";?>
						</option>						
				<?php }?>
		  </select>
	  </label>
	 </p> 
	 
<?php
  }
 
  function update($new_instance, $old_instance)
  {
  
    $instance = $old_instance;
    $instance['title'] = $new_instance['title'];
    $instance['get_cate_posts'] = $new_instance['get_cate_posts'];	
	
    return $instance;
  }
  
	function widget($args, $instance)
	{  
		extract($args, EXTR_SKIP);
		$title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
		$get_cate_posts = isset( $instance['get_cate_posts'] ) ? esc_attr( $instance['get_cate_posts'] ) : '';		
		
		echo html_entity_decode($before_widget);	
	
			echo html_entity_decode($before_title);
			
			echo esc_attr($title);
			
			echo html_entity_decode($after_title);
			
			if($get_cate_posts){	
				
				static $counter = 0;

				$html = '
					<div class="row">';
						if($counter % 4 == 0){ 
							$html .= '
								<div class="col-md-6 col-sm-6 col-lg-6">
									<div class="widget w-100">
										<ul class="mb-0 list-unstyled w-100">';
						}

						foreach(wp_get_nav_menu_items($get_cate_posts) as $items){	
							$html[] = '<li><a href="about.html" title="">'.$items->title.'</a></li>';
						}
							
						if($counter % 4 == 3){ 
							$html .= '
								</ul>
							</div>
						</div>'; 
						}
						
						$counter++;
						
						$html .= '
					</div>';
	
			}else{
				$html = 'There is Problem With Your Selected Menu';
			}
			
			echo $html;

			echo html_entity_decode($after_widget);	
	}
}

if ( ! version_compare( PHP_VERSION, '5.3.0', '>=' ) ) {
   add_action( 'widgets_init', function() { register_widget( 'footer_nav_menu_widget' ); } );
}else{
    function footer_nav_menu_widget_init (){
        return register_widget('footer_nav_menu_widget');
    }
    add_action ('widgets_init', 'footer_nav_menu_widget_init');
}
?>