<?php
class follow_us_widget extends WP_Widget
{
  
	public function __construct() { 
	
		$widget_ops = array('classname' => 'widget style2', 'description' => 'Follow Us' );
		parent::__construct('follow_us_widget', ' *Social Media : Follow Us Widget', $widget_ops);
	
	}
 
  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title = $instance['title'];
	$widget_facebook = isset( $instance['facebook'] ) ? esc_url( $instance['facebook'] ) : '';
	$widget_twitter = isset( $instance['twitter'] ) ? esc_url( $instance['twitter'] ) : '';
	$widget_linkedin = isset( $instance['linkedin'] ) ? esc_url( $instance['linkedin'] ) : '';
	$widget_youtube = isset( $instance['youtube'] ) ? esc_url( $instance['youtube'] ) : '';
	$widget_insta = isset( $instance['insta'] ) ? esc_url( $instance['insta'] ) : '';
	
?>
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
		 <?php esc_html_e('Title:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
	  </label>
	</p>   
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('facebook')); ?>">
		 <?php esc_html_e('Facebook Link:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('facebook')); ?>" name="<?php echo esc_attr($this->get_field_name('facebook')); ?>" type="text" value="<?php echo esc_url($widget_facebook); ?>" />
	  </label>
	</p> 
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('twitter')); ?>">
		 <?php esc_html_e('Twitter Link:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('twitter')); ?>" name="<?php echo esc_attr($this->get_field_name('twitter')); ?>" type="text" value="<?php echo esc_url($widget_twitter); ?>" />
	  </label>
	</p> 
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('linkedin')); ?>">
		 <?php esc_html_e('LinkedIn Link:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('linkedin')); ?>" name="<?php echo esc_attr($this->get_field_name('linkedin')); ?>" type="text" value="<?php echo esc_url($widget_linkedin); ?>" />
	  </label>
	</p> 
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('youtube')); ?>">
		 <?php esc_html_e('Youtube Link:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('youtube')); ?>" name="<?php echo esc_attr($this->get_field_name('youtube')); ?>" type="text" value="<?php echo esc_url($widget_youtube); ?>" />
	  </label>
	</p>
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('insta')); ?>">
		 <?php esc_html_e('Instagram Link:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('insta')); ?>" name="<?php echo esc_attr($this->get_field_name('insta')); ?>" type="text" value="<?php echo esc_url($widget_insta); ?>" />
	  </label>
	</p>
	
<?php
  
  }/* end of form function*/
 
  function update($new_instance, $old_instance)
  {
  
    $instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		 $instance['facebook'] = $new_instance['facebook'];
		 $instance['twitter'] = $new_instance['twitter'];
		 $instance['linkedin'] = $new_instance['linkedin'];
		 $instance['youtube'] = $new_instance['youtube'];
		 $instance['insta'] = $new_instance['insta'];
		 

		return $instance;
  
  }/* end of update function */
 
	function widget($args, $instance)
	{
		
		extract($args, EXTR_SKIP);
		$title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
		 $visioncare_facebook = isset( $instance['facebook'] ) ? esc_attr( $instance['facebook'] ) : '';	
		 $visioncare_twitter = isset( $instance['twitter'] ) ? esc_attr( $instance['twitter'] ) : '';	
		 $visioncare_linkedin = isset( $instance['linkedin'] ) ? esc_attr( $instance['linkedin'] ) : '';	
		 $visioncare_yoututbe = isset( $instance['youtube'] ) ? esc_attr( $instance['youtube'] ) : '';	
		 $visioncare_insta = isset( $instance['insta'] ) ? esc_attr( $instance['insta'] ) : '';	
		
		echo html_entity_decode($before_widget);

		echo html_entity_decode($before_title);
		
		echo esc_attr($title);
		
		echo html_entity_decode($after_title);
                                 
		/* Widget HTML Markup */
		$widget_html = ' <div class="social-links3 d-flex flex-wrap w-100">';
		if($visioncare_facebook){
		$widget_html .= '<a href="'.esc_url($visioncare_facebook).'" title="'.esc_attr__('Facebook','kriate').'" target="_blank"><i class="fab fa-facebook-f"></i>'.esc_html__('facebook','kriate').'</a>';
		}
		if($visioncare_twitter){
		$widget_html .= '<a href="'.esc_url($visioncare_twitter).'" title="'.esc_attr__('Twitter','kriate').'" target="_blank"><i class="fab fa-twitter"></i>'.esc_html__('twitter','kriate').'</a>';
		}
		if($visioncare_linkedin){
		$widget_html .= '<a href="'.esc_url($visioncare_linkedin).'" title="'.esc_attr__('LinkedIn','kriate').'" target="_blank"><i class="fab fa-linkedin"></i>'.esc_html__('linkedin','kriate').'</a>';
		}
		if($visioncare_yoututbe){
		$widget_html .= '<a href="'.esc_url($visioncare_yoututbe).'" title="'.esc_attr__('Youtube','kriate').'" target="_blank"><i class="fab fa-youtube"></i>'.esc_html__('youtube','kriate').'</a>';
		}
		if($visioncare_insta){
		$widget_html .= '<a href="'.esc_url($visioncare_insta).'" title="'.esc_attr__('Instagram','kriate').'" target="_blank"><i class="fab fa-instagram"></i>'.esc_html__('instagram','kriate').'</a>';
		}
        $widget_html .= '</div>';

		echo $widget_html;
		
	/* WIDGET display CODE End*/
	echo html_entity_decode($after_widget);
		
		
	}/* end of widegat function */
	
}/* end of follow_us_widget class */

if ( ! version_compare( PHP_VERSION, '5.3.0', '>=' ) ) {
   add_action( 'widgets_init', function() { register_widget( 'follow_us_widget' ); } );
}else{
    function follow_us_widget_init (){
        return register_widget('follow_us_widget');
    }
    add_action ('widgets_init', 'follow_us_widget_init');
}?>