<?php
class about_widget extends WP_Widget
{
  
	public function __construct() { 
	
		$widget_ops = array('classname' => 'widget', 'description' => 'About Us Widget' );
		parent::__construct('about_widget', '*About Info', $widget_ops);
	
	}
 
  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
	$title = $instance['title'];
	$kriate_desc = isset( $instance['desc'] ) ? esc_attr( $instance['desc'] ) : '';
	$kriate_logo = isset( $instance['logo'] ) ? esc_attr( $instance['logo'] ) : get_template_directory_uri().'/assets/images/logo.png';	?>
	
	<p>
		<label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
			<?php esc_html_e('Title:','kriate');?>  
			<input class="widefat"  id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</label>
	</p>

	<p>
		<label for="<?php echo esc_attr($this->get_field_id('desc')); ?>"></label>
		<?php esc_html_e('Add Description:','kriate');?>  
        <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('desc')); ?>" name="<?php echo esc_attr($this->get_field_name('desc')); ?>"><?php echo esc_attr($kriate_desc); ?></textarea>
    </p>
	
	<p>
		<label for="<?php echo esc_attr($this->get_field_id('logo')); ?>">
			<?php esc_html_e('Logo URL:','kriate');?>  
			<input class="widefat"  id="<?php echo esc_attr($this->get_field_id('logo')); ?>" name="<?php echo esc_attr($this->get_field_name('logo')); ?>" type="text" value="<?php echo esc_attr($kriate_logo); ?>" />
		</label>
	</p>

  
<?php
  
  }/* end of form function*/
 
  function update($new_instance, $old_instance)
  {
  
    $instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['desc'] = $new_instance['desc'];
		$instance['logo'] = $new_instance['logo'];
		
		return $instance;
  
  }/* end of update function */
 
	function widget($args, $instance)
	{
		
		extract($args, EXTR_SKIP);
		
		$kriate_title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$kriate_desc = isset( $instance['desc'] ) ? esc_attr( $instance['desc'] ) : '';
		$kriate_logo = isset( $instance['logo'] ) ? esc_attr( $instance['logo'] ) : '';
		
		echo html_entity_decode($before_widget); 
		
		/* Get Option Value From Theme Options */
		global $kriate_options;
		
		$twitter_url = $kriate_options['twitter-link'];
		$facebook_url = $kriate_options['facebook-link'];
		$instagram_url = $kriate_options['instagram-link'];
		$linkedin_url = $kriate_options['linkedin-link']; 
		
		if($kriate_logo){
			$html = '
				<div class="logo w-100">
					<div class="mb-0">
						<a href="'.get_home_url('/').'" title="'.esc_attr__('Home','kriate').'">
							<img class="img-fluid" src="'.esc_url($kriate_logo).'" alt="'.esc_attr__('Logo','kriate').'" srcset="'.esc_url($kriate_logo).'">
						</a>
					</div>
				</div>';
		}
		
		if($kriate_desc){ $html .= '<p class="mb-0">'.$kriate_desc.'</p>'; }
		
		$html .= '
		<div class="social-links2 d-inline-block">';
			if($facebook_url){ $html .= '<a href="'.$facebook_url.'" title="Facebook" target="_blank"><i class="flaticon-facebook"></i></a>'; }
			if($twitter_url){ $html .= '<a href="'.$twitter_url.'" title="Twitter" target="_blank"><i class="flaticon-twitter"></i></a>'; }
			if($instagram_url){ $html .= '<a href="'.$instagram_url.'" title="Instagram" target="_blank"><i class="fab fa-instagram"></i></a>'; }
			if($linkedin_url){ $html .= '<a href="'.$linkedin_url.'" title="LinkedIn" target="_blank"><i class="fab fa-linkedin-in"></i></a>'; }
			$html .= '
		</div>';    

		echo $html;

		/* WIDGET display CODE End*/
		echo html_entity_decode($after_widget);
		
		
	}/* end of widegat function */
	
}/* end of about_widget class */
	
if ( ! version_compare( PHP_VERSION, '5.3.0', '>=' ) ) {
   add_action( 'widgets_init', function() { register_widget( 'about_widget' ); } );
}else{
    function about_widget_init (){
        return register_widget('about_widget');
    }
    add_action ('widgets_init', 'about_widget_init');
}	
?>