<?php
/***** Required Functions For testimonial Post Type *****/
if ( ! function_exists('prefix_post_type_testimonial') ) {

/* 1. Register CLASSES Post Type */
function prefix_post_type_testimonial() {

	$labels = array(
		'name'                  => _x( 'Testimonial', 'Post Type General Name', 'kriate' ),
		'singular_name'         => _x( 'Testimonial', 'Post Type Singular Name', 'kriate' ),
		'menu_name'             => __( 'Testimonial', 'kriate' ),
		'name_admin_bar'        => __( 'Testimonial', 'kriate' ),
		'archives'              => __( 'Item Archives', 'kriate' ),
		'attributes'            => __( 'Item Attributes', 'kriate' ),
		'parent_item_colon'     => __( 'Parent Item:', 'kriate' ),
		'all_items'             => __( 'All Items', 'kriate' ),
		'add_new_item'          => __( 'Add New Testimonial', 'kriate' ),
		'add_new'               => __( 'Add New Testimonial', 'kriate' ),
		'new_item'              => __( 'Add New Testimonial', 'kriate' ),
		'edit_item'             => __( 'Edit Testimonial', 'kriate' ),
		'update_item'           => __( 'Update Item', 'kriate' ),
		'view_item'             => __( 'View Item', 'kriate' ),
		'view_items'            => __( 'View Items', 'kriate' ),
		'search_items'          => __( 'Search Item', 'kriate' ),
		'not_found'             => __( 'Not found', 'kriate' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'kriate' ),
		'featured_image'        => __( 'Testimonial Featured Image', 'kriate' ),
		'set_featured_image'    => __( 'Set featured image', 'kriate' ),
		'remove_featured_image' => __( 'Remove featured image', 'kriate' ),
		'use_featured_image'    => __( 'Use as featured image', 'kriate' ),
		'insert_into_item'      => __( 'Insert into item', 'kriate' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'kriate' ),
		'items_list'            => __( 'Items list', 'kriate' ),
		'items_list_navigation' => __( 'Items list navigation', 'kriate' ),
		'filter_items_list'     => __( 'Filter items list', 'kriate' ),
	);
	$args = array(
		'label'                 => __( 'Testimonial', 'kriate' ),
		'description'           => __( 'Testimonial Posts Generated By Ingeniofy Plugin', 'kriate' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail' ),
		'hierarchical'          => true,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 20,
		'menu_icon'             => 'dashicons-id-alt',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => 'testimonial',
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'testimonial', $args );
	
	/* Add new taxonomy, make it hierarchical (like categories) */
	$cat_labels = array(
		'name'              => _x( 'Testimonial Categories', 'taxonomy general name', 'kriate' ),
		'singular_name'     => _x( 'Testimonial Category', 'taxonomy singular name', 'kriate' ),
		'search_items'      => __( 'Search Testimonial Category', 'kriate' ),
		'all_items'         => __( 'All Testimonial Categories', 'kriate' ),
		'parent_item'       => __( 'Parent Testimonial Category', 'kriate' ),
		'parent_item_colon' => __( 'Parent Testimonial Category:', 'kriate' ),
		'edit_item'         => __( 'Edit Testimonial Category', 'kriate' ),
		'update_item'       => __( 'Update Testimonial Category', 'kriate' ),
		'add_new_item'      => __( 'Add New Testimonial Category', 'kriate' ),
		'new_item_name'     => __( 'New Testimonial Category Name', 'kriate' ),
		'menu_name'         => __( 'Testimonial Categories', 'kriate' ),
	);

	$cat_args = array(
		'hierarchical'      => true,
		'labels'            => $cat_labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'testimonial-category' ),
	);

	register_taxonomy( 'testimonial-category', array( 'testimonial' ), $cat_args );

}

	/* Add Action For Generating Post Type */
	add_action( 'init', 'prefix_post_type_testimonial', 0 );
	
	/* Add Team Post Type Meta Boxes */
	add_action( 'cmb2_admin_init', 'kriate_testimonials_posttype_metaboxes' );

	function kriate_testimonials_posttype_metaboxes() {

		$cmb = new_cmb2_box( array(
			'id'            => 'testimonial_posttype_metabox',
			'title'         => __( 'Testimonial Options', 'kriate' ),
			'object_types'  => array( 'testimonial', ),
			'context'       => 'normal',
			'priority'      => 'high',
			'show_names'    => true,
		) );

		$cmb->add_field( array(
			'name'             => 'Stars Rating',
			'desc'             => 'Select an option',
			'id'               => 'testimonial_stars',
			'type'             => 'select',
			'show_option_none' => false,
			'default'          => 'five',
			'options'          => array(
				'1' => __( '1 Star', 'kriate' ),
				'2'   => __( '2 Stars', 'kriate' ),
				'3'     => __( '3 Stars', 'kriate' ),
				'4'     => __( '4 Stars', 'kriate' ),
				'5'     => __( '5 Stars', 'kriate' ),
			),
		) );
		
		$cmb->add_field( array(
			'name'    => 'Reviews Count',
			'desc'    => 'Add Reviews Count Here',
			'default' => '(07 Reviews)',
			'id'      => 'testimonial_reviews',
			'type'    => 'text',
		) );

	} /* Meta boxes Ends Here */

}