<?php
/***** Required Functions For Team Post Type *****/
if ( ! function_exists('prefix_post_type_team') ) {

	/* 1. Register CLASSES Post Type */
	function prefix_post_type_team() {

		$labels = array(
			'name'                  => _x( 'Team', 'Post Type General Name', 'kriate' ),
			'singular_name'         => _x( 'Team', 'Post Type Singular Name', 'kriate' ),
			'menu_name'             => __( 'Team', 'kriate' ),
			'name_admin_bar'        => __( 'Team', 'kriate' ),
			'archives'              => __( 'Team Archives', 'kriate' ),
			'attributes'            => __( 'Team Attributes', 'kriate' ),
			'parent_item_colon'     => __( 'Parent Team:', 'kriate' ),
			'all_items'             => __( 'All Team', 'kriate' ),
			'add_new_item'          => __( 'Add New Team', 'kriate' ),
			'add_new'               => __( 'Add New Team', 'kriate' ),
			'new_item'              => __( 'Add New Team', 'kriate' ),
			'edit_item'             => __( 'Edit Team', 'kriate' ),
			'update_item'           => __( 'Update Team', 'kriate' ),
			'view_item'             => __( 'View Team', 'kriate' ),
			'view_items'            => __( 'View Team', 'kriate' ),
			'search_items'          => __( 'Search Team', 'kriate' ),
			'not_found'             => __( 'Not found', 'kriate' ),
			'not_found_in_trash'    => __( 'Not found in Trash', 'kriate' ),
			'featured_image'        => __( 'Team Featured Image', 'kriate' ),
			'set_featured_image'    => __( 'Set featured image', 'kriate' ),
			'remove_featured_image' => __( 'Remove featured image', 'kriate' ),
			'use_featured_image'    => __( 'Use as featured image', 'kriate' ),
			'insert_into_item'      => __( 'Insert into Team', 'kriate' ),
			'uploaded_to_this_item' => __( 'Uploaded to this Team', 'kriate' ),
			'items_list'            => __( 'Team list', 'kriate' ),
			'items_list_navigation' => __( 'Team list navigation', 'kriate' ),
			'filter_items_list'     => __( 'Filter Team list', 'kriate' ),
		);
		$args = array(
			'label'                 => __( 'Team', 'kriate' ),
			'description'           => __( 'Team Posts Generated By Ingeniofy Plugin', 'kriate' ),
			'labels'                => $labels,
			'supports'              => array( 'title', 'thumbnail' ),
			'hierarchical'          => true,
			'public'                => true,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'menu_position'         => 20,
			'menu_icon'             => 'dashicons-id-alt',
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'can_export'            => true,
			'has_archive'           => 'team',
			'exclude_from_search'   => false,
			'publicly_queryable'    => true,
			'capability_type'       => 'page',
		);
		register_post_type( 'team', $args );
		
		/* Add new taxonomy, make it hierarchical (like categories) */
		$cat_labels = array(
			'name'              => _x( 'Team Categories', 'taxonomy general name', 'kriate' ),
			'singular_name'     => _x( 'Team Category', 'taxonomy singular name', 'kriate' ),
			'search_items'      => __( 'Search Team Category', 'kriate' ),
			'all_items'         => __( 'All Team Categories', 'kriate' ),
			'parent_item'       => __( 'Parent Team Category', 'kriate' ),
			'parent_item_colon' => __( 'Parent Team Category:', 'kriate' ),
			'edit_item'         => __( 'Edit Team Category', 'kriate' ),
			'update_item'       => __( 'Update Team Category', 'kriate' ),
			'add_new_item'      => __( 'Add New Team Category', 'kriate' ),
			'new_item_name'     => __( 'New Team Category Name', 'kriate' ),
			'menu_name'         => __( 'Team Categories', 'kriate' ),
		);

		$cat_args = array(
			'hierarchical'      => true,
			'labels'            => $cat_labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'team-category' ),
		);

		register_taxonomy( 'team-category', array( 'team' ), $cat_args );

	}

	/* Add Action For Generating Post Type */
	add_action( 'init', 'prefix_post_type_team', 0 );
	
	/* Add Team Post Type Meta Boxes */
	add_action( 'cmb2_admin_init', 'kriate_team_posttype_metaboxes' );

	function kriate_team_posttype_metaboxes() {

		$cmb = new_cmb2_box( array(
			'id'            => 'team_posttype_metabox',
			'title'         => __( 'Team Member Options', 'kriate' ),
			'object_types'  => array( 'team', ),
			'context'       => 'normal',
			'priority'      => 'high',
			'show_names'    => true,
		) );

		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Designation', 'kriate' ),
			'desc'       => __( 'Add Designation Text Here e.g CEO & FOUNDER', 'kriate' ),
			'id'         => 'team_designation',
			'type'       => 'text',
		) );
		
		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Facebook Profile', 'kriate' ),
			'desc'       => __( 'Add Facebook Profile Link Here e.g https://facebook.com', 'kriate' ),
			'id'         => 'team_facebook',
			'type'       => 'text',
		) );
		
	} /* Meta boxes Ends Here */

}