<?php 	
	/* Add Campaigns Meta Boxes */
	add_action( 'cmb2_admin_init', 'kriate_campaigns_posttype_metaboxes' );

	function kriate_campaigns_posttype_metaboxes() {

		$cmb = new_cmb2_box( array(
			'id'            => 'campaigns_metabox',
			'title'         => __( 'Campaigns Options', 'kriate' ),
			'object_types'  => array( 'campaign', ),
			'context'       => 'normal',
			'priority'      => 'high',
			'show_names'    => true,
		) );

		// List Campaigns field
		$cmb->add_field( array(
			'name' => __( 'Campaign Location', 'kriate' ),
			'desc' => __( 'Add Campaign Location Here i.e ', 'kriate' ),
			'id'   => 'campaign_location',
			'type' => 'text',
			'repeatable' => false,
		) );
		
		/* Display Sharing & Tags */
		$cmb->add_field( array(
			'name'    => 'Tags & Sharing Links',
			'id'      => 'campaign_tags_sharing',
			'type'    => 'radio_inline',
			'options' => array(
				'display' => __( 'Display', 'kriate' ),
				'hide'   => __( 'Hide', 'kriate' ),
			),
			'default' => 'display',
		) );
		
		/* Display Author Intro */
		$cmb->add_field( array(
			'name'    => 'Author Intro',
			'id'      => 'campaign_author_intro',
			'type'    => 'radio_inline',
			'options' => array(
				'display' => __( 'Display', 'kriate' ),
				'hide'   => __( 'Hide', 'kriate' ),
			),
			'default' => 'display',
		) );
		
		$cmb->add_field( array(
			'name'    => 'Sidebar Layout',
			'id'      => 'campaign_sidebar_layout',
			'type'    => 'radio_inline',
			'options' => array(
				'right' => __( 'Right SideBar', 'cmb2' ),
				'left'   => __( 'Left SideBar', 'cmb2' ),
				'no'     => __( 'No SideBar', 'cmb2' ),
			),
			'default' => 'right',
		) );
		
		$cmb->add_field( array(
			'name'             => 'Select SideBar',
			'desc'             => 'Select Your Desired SideBar',
			'id'               => 'campaign_sidebar_selected',
			'type'             => 'select',
			'show_option_none' => true,
			'default'          => '',
			'options_cb' => 'kriate_cmb2_get_all_sidebars',
		) );
		
		$cmb->add_field( array(
			'name'    => 'Author Intro Title',
			'desc'    => 'Add Author Box Intro Title Here',
			'default' => 'About Author:',
			'id'      => 'camp_author_intro_title',
			'type'    => 'text',
		) );
	} /* Meta boxes Ends Here */