<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class TestimonialSlider extends Widget_Base{

  public function get_name(){
    return 'testimonial-slider';
  }

  public function get_title(){
    return 'Testimonials';
  }

  public function get_icon(){
    return 'fa fa-cogs';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'testimonial',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'testimonial-category',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'kriate' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
		'chose_style',
		[
			'label'     => esc_html__( 'Chose Style', 'kriate' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => [
				'style-one'  => esc_html__( 'Dark Style', 'kriate' ),
				'style-two' => esc_html__( 'Light Style', 'kriate' ),
			],
			'default'   => 'style-one',
		]
	);
	
	$this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'WHAT CLIENTS SAYS?'
      ]
    );
	
	$this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Trusted By Worlds Best'
      ]
    );
	
	$this->add_control(
		'background-image',
		[
			'label' => __( 'Choose Background Image', 'kriate' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/pattern-bg2.jpg',
			],
		]
	);
	
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'kriate' ),
				'title' => __( 'Title', 'kriate' ),
				'name' => __( 'Name', 'kriate' ),
				'rand' => __( 'Random', 'kriate' ),
				'ID' => __( 'ID', 'kriate' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'kriate' ),
				'ASC' => __( 'ASCENDING', 'kriate' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Posts Count', 'kriate' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 40,
			'step' => 1,
			'default' => 4,
		]
    );
	
	$this->add_control(
      'words_count',
      [
        'label' => 'Words Count',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '15'
      ]
    );
	

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = kriate_get_post_query('testimonial', 'testimonial-category', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']); 
	
	wp_enqueue_style('slick-slider',get_template_directory_uri().'/assets/css/slick.css');
	wp_enqueue_script( 'slick-slider', get_template_directory_uri() . '/assets/js/slick.min.js', array('jquery'), '1.0.0', true ); 
	
	if($settings['chose_style'] == 'style-one'){ $padding_class = 'w-100 dark-layer2 pt-100 pb-100 opc1 overflow-hidden position-relative'; }else{ $padding_class = 'w-100 gray-layer pt-100 pb-100 opc1 overflow-hidden position-relative'; } ?>
	  
	<section>
		<div class="<?php echo esc_html($padding_class); ?>">
			<?php if($settings['chose_style'] == 'style-one'){ ?><div class="fixed-bg zoom-anim back-blend-screen h-tst patern-bg dark-bg" style="background-image: url(<?php echo esc_url($settings['background-image']['url']); ?> );"></div><?php }else{ ?>
				<div class="fixed-bg zoom-anim back-blend-screen patern-bg gray-bg" style="background-image: url(<?php echo esc_url($settings['background-image']['url']); ?>);"></div>
			<?php } ?>
			<div class="particles-js" id="prtcl3"></div>
			<div class="container">
				<?php if($settings['content_heading']){ ?>
					<div class="sec-title v2 text-center w-100 testi">
						<div class="sec-title-inner d-inline-block">
							<?php if($settings['content_caption']){ ?><span class="thm-clr d-block"><?php echo esc_html( __( $settings['content_caption'], 'kriate' ) ); ?></span><?php } ?>
							<?php if($settings['content_heading']){ ?><h3 class="mb-0 d-block"><?php echo esc_html( __( $settings['content_heading'], 'kriate' ) ); ?></h3><?php } ?>
						</div>
					</div>
				<?php } ?>
				<div class="testi-wrap position-relative w-100">
					<div class="testi-caro">
						<?php
						if ( have_posts() ) {
							
							while ( have_posts() ) { the_post(); global $post;
			
								static $counter = 1; 
								
								$testimonial_stars = 0; $testimonial_reviews = '';
								$testimonial_stars = get_post_meta( get_the_ID(), 'testimonial_stars', true );
								$testimonial_reviews = get_post_meta( get_the_ID(), 'testimonial_reviews', true );
								$testimonial_emptystars = 5 - $testimonial_stars;
								
								$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 170, 192, 'bfi_thumb' => true )); ?>
						
								<div class="testi-box-wrap">
									<div class="testi-box">
										<div class="testi-img">
											<img class="img-fluid" src="<?php echo esc_url($featured_image_url); ?>" alt="<?php esc_attr__('Team Image','kriate'); ?>">
										</div>
										<div class="testi-info">
											<h3 class="mb-0">“<?php echo get_the_title(); ?>”</h3>
											<p class="mb-0"><?php echo wp_trim_words( get_the_content(), $settings['words_count'], '...' ); ?></p>
											<span class="d-inline-block text-color3">
											<?php for($i = 1; $i<= intval($testimonial_stars); $i++){ ?>
												<i class="fas fa-star"></i>
											<?php } ?>
											<?php for($i = 1; $i<= intval($testimonial_emptystars); $i++){ ?>
												<i class="far fa-star"></i>
											<?php } ?>
												<span class="thm-clr"><?php echo esc_html($testimonial_reviews); ?></span>
											</span>
										</div>
									</div>
								</div>
							<?php 
							}
						} wp_reset_query(); ?>
					</div>
				</div><!-- Tesyimonials Wrap -->
			</div>
		</div>
	</section>
	
    <?php
  }
}