<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class TeamMembers extends Widget_Base{

  public function get_name(){
    return 'team-members';
  }

  public function get_title(){
    return 'Team Members';
  }

  public function get_icon(){
    return 'fa fa-user';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'team',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'team-category',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'kriate' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );


    $this->add_control(
      'content_subcaption',
      [
        'label' => 'Element Sub Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Our Standard Services'
      ]
    );
	
	$this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Al is no longer a futuristic notion, its here right now'
      ]
    );

    $this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Morem Gpsum is simply dummy text of the printing and typesetting industry.'
      ]
    );
	
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'kriate' ),
				'title' => __( 'Title', 'kriate' ),
				'name' => __( 'Name', 'kriate' ),
				'rand' => __( 'Random', 'kriate' ),
				'ID' => __( 'ID', 'kriate' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'kriate' ),
				'ASC' => __( 'ASCENDING', 'kriate' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Team Count', 'kriate' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 32,
			'step' => 1,
			'default' => 5,
		]
    );


    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = kriate_get_post_query('team', 'team-category', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']);
	
	
	$output = '
	
	<section>
		<div class="w-100 pt-100 pb-55 position-relative">
			<div class="container">';
				if(!empty($settings['content_heading'])){ 
				$output .= '
					<div class="sec-title v2 text-center w-100">
						<div class="sec-title-inner d-inline-block">
							<span class="thm-clr d-block">'.esc_html( __( $settings['content_subcaption'], 'kriate' ) ).'</span>
							<h2 class="mb-0">'.esc_html( __( $settings['content_heading'], 'kriate' ) ).'</h2>
							<p class="mb-0">'.esc_html( __( $settings['content_caption'], 'kriate' ) ).'</p>
						</div>
					</div>';
				}
				$output .= '
				<ul class="team-wrap d-flex flex-wrap justify-content-center w-100 list-unstyled mb-0">';
					
					if ( have_posts() ) {
									
						static $counter = 1;
						
						while ( have_posts() ) { the_post(); global $post;
						
							$team_designation = ''; $team_facebook = '';
							$team_designation = get_post_meta( get_the_ID(), 'team_designation', true );
							$team_facebook = get_post_meta( get_the_ID(), 'team_facebook', true );
							$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 195, 195, 'bfi_thumb' => true ));
							
							$output .= '
							
							<li class="team-box text-center mb-45 w-100">
								<div class="team-img rounded-circle position-relative overflow-hidden">
									<img class="rounded-circle img-fluid" src="'.$featured_image_url.'" alt="'.esc_attr__('Team Members','kriate').'">';
									if($team_facebook){ 
										$output .= '
											<div class="team-social position-absolute">
												<a class="rounded-circle" href="'.esc_url($team_facebook).'" title="'.esc_attr__('Facebook','kriate').'" target="_blank"><i class="fab fa-facebook-f"></i></a>
											</div>';
									}
									
									$output .= '
								</div>
								<div class="team-info w-100">
									<h3 class="mb-0">'.get_the_title().'</h3>';
									if($team_designation){
										$output .= '<span class="d-block">'.$team_designation.'</span>';
									}
									$output .= '
								</div>
							</li>';
						}
					}
					$output .= '
				</ul><!-- Team Wrap -->
			</div>
		</div>
	</section>';
	
	echo $output;
  }
}