<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class ProjectsSlider extends Widget_Base{

  public function get_name(){
    return 'projects_slider';
  }

  public function get_title(){
    return 'Projects Slider';
  }

  public function get_icon(){
    return 'fa fa-cogs';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'projects',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'projects-category',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'kriate' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
      'content_caption',
      [
        'label' => 'Sub Heading',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Development Works'
      ]
    );
	
	$this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Our Latest Projects'
      ]
    );	
	
	$this->add_control(
		'bg-image',
		[
			'label' => __( 'Choose Background Image', 'kriate' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/parallax1.jpg',
			],
		]
	);
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'kriate' ),
				'title' => __( 'Title', 'kriate' ),
				'name' => __( 'Name', 'kriate' ),
				'rand' => __( 'Random', 'kriate' ),
				'ID' => __( 'ID', 'kriate' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'kriate' ),
				'ASC' => __( 'ASCENDING', 'kriate' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Posts Count', 'kriate' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 40,
			'step' => 1,
			'default' => 5,
		]
    );
	

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = kriate_get_post_query('projects', 'projects-category', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']); 
	
	wp_enqueue_style('slick-slider',get_template_directory_uri().'/assets/css/slick.css');
	wp_enqueue_script( 'slick-slider', get_template_directory_uri() . '/assets/js/slick.min.js', array('jquery'), '1.0.0', true ); ?>
	
	
	<section>
		<div class="w-100 pt-100 paralx-70 blue-layer opc7 position-relative">
			<?php if($settings['bg-image']['url']){ ?><div class="fixed-bg" style="background-image: url(<?php echo esc_url($settings['bg-image']['url']);?>);"></div><?php } ?>
			<?php if($settings['content_caption'] || $settings['content_heading']){ ?>
				<div class="container">
					<div class="sec-title w-100">
						<div class="sec-title-inner d-inline-block">
							<?php if($settings['content_caption']){ ?><span class="d-block bg-subheading"><?php echo esc_html( __( $settings['content_caption'], 'kriate' ) ); ?></span><?php } ?>
							<?php if($settings['content_heading']){ ?><h3 class="mb-0"><?php echo esc_html( __( $settings['content_heading'], 'kriate' ) ); ?></h3><?php } ?>
						</div>
					</div>
				</div>
			<?php } ?>
			<div class="proj-wrap px-70 w-100">
				<div class="row proj-caro">
				<?php
				if ( have_posts() ) {
					
					while ( have_posts() ) { the_post(); global $post;
	
						static $counter = 1; 
						
						$projects_icon = '';
						$projects_icon = get_post_meta( get_the_ID(), 'projects_icon', true ); 
						
						$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 270, 300, 'bfi_thumb' => true )); ?>		
					
						<div class="col-md-4 col-sm-6 col-lg-3">
							<div class="proj-box position-relative w-100">
								<?php if($featured_image_url){ ?>
									<div class="proj-thumb overflow-hidden w-100">
										<a href="<?php echo get_the_permalink(); ?>" title="">
											<img class="img-fluid w-100" src="<?php echo esc_url($featured_image_url); ?>" alt="<?php esc_attr__('Project Image','kriate'); ?>">
										</a>
									</div>
								<?php } ?>
								<div class="proj-info position-absolute">
									<?php if($projects_icon){ ?><i class="<?php echo esc_html($projects_icon); ?>"></i><?php } ?>
									<h3 class="mb-0"><a href="<?php echo get_the_permalink(); ?>" title=""><?php echo get_the_title(); ?></a></h3>
								</div>
							</div>
						</div>
					<?php }
				} wp_reset_query(); ?>
				</div>
			</div><!-- Projects Wrap -->
		</div>
	</section>
	
    <?php
  }
}