<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class ProductsList extends Widget_Base{

  public function get_name(){
    return 'products_list';
  }

  public function get_title(){
    return 'Products List';
  }

  public function get_icon(){
    return 'fa fa-shopping-cart';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'product',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'product_cat',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'kriate' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );

    $this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Dont Miss Special Packages'
      ]
    ); 

    $this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Adipiscing elit duis volutpat ligula nulla dapibus.'
      ]
    );
	
	$this->add_control(
      'heading_icon',
      [
        'label' => 'Heading Icon',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'flaticon-rub-el-hizb'
      ]
    );
	
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'kriate' ),
				'title' => __( 'Title', 'kriate' ),
				'name' => __( 'Name', 'kriate' ),
				'rand' => __( 'Random', 'kriate' ),
				'ID' => __( 'ID', 'kriate' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'kriate' ),
				'ASC' => __( 'ASCENDING', 'kriate' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Posts Count', 'kriate' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 30,
			'step' => 1,
			'default' => 4,
		]
    );
	
	$this->add_control(
		'display_pagination',
		[
			'label' => __( 'Pagination', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'No',
			'options' => [
				'No'  => __( 'No', 'kriate' ),
				'Yes' => __( 'Yes', 'kriate' ),
			],
		]
    );

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = kriate_get_post_query('product', 'product_cat', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']);

		wp_enqueue_script( 'touchspin-woo', get_template_directory_uri() . '/assets/js/jquery.bootstrap-touchspin.min.js', array('jquery'), '1.0.0', true );
	
	$output = '
	
	<section>
		<div class="w-100 pt-50 pb-100 position-relative">
			<div class="container">
				<div class="shop-wrap w-100">
					<div class="row woocommerce">';
						if(have_posts()){
						
							while( have_posts() ){ the_post(); global $post;

								global $post,$product,$product_url,$woocommerce;
								
									$regular_price = get_post_meta($post->ID, '_regular_price', true);
									if($regular_price == ''){
										$regular_price = get_post_meta($post->ID, '_max_variation_regular_price', true);
									}
									$sale_price = get_post_meta($post->ID, '_sale_price', true);
									$sku_num = get_post_meta($post->ID, '_sku', true);
										
									if($sale_price == ''){
										$sale_price = get_post_meta($post->ID, '_min_variation_sale_price', true);
									}
									$currency = get_woocommerce_currency_symbol();
									
									$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 270, 270, 'bfi_thumb' => true ));
									
									$product = wc_get_product( $post->ID );
									
									$company = get_post_meta( get_the_ID(), 'product_company_name', true );
									
									$output .= '

									<div class="col-md-4 col-sm-6 col-lg-3">
										<div class="shop-box w-100">
											<div class="shop-img w-100 position-relative overflow-hidden">
												<img class="img-fluid w-100" src="'.esc_url($featured_image_url).'" alt="'.esc_attr__('Featured Image','kriate').'">
												<a href="'.get_the_permalink().'" title="">'.esc_html__('Add To Cart','kriate').'<i class="fas fa-shopping-basket"></i></a>
											</div>
											<div class="shop-info w-100">
												<h3 class="mb-0"><a href="'.get_the_permalink().'" title="">'.get_the_title().'</a></h3>
												<div class="shop-info-bottom d-flex flex-wrap justify-content-between w-100">
													<div class="rate-wrap rate d-block">'.add_stars_to_review_tab(get_the_title()).'</div>
													<span class="price"><ins>'.$currency.''.number_format((float)$regular_price, 2, '.', '').'</ins><del>'.$currency.''.number_format((float)$regular_price, 2, '.', '').'</del></span>
												</div>
											</div>
										</div>
									</div>';
							}
						} 
						$output .= '

					</div>
				</div>';
				if(function_exists('kriate_numeric_posts_nav')){
					
					$output .= '
					
					<div class="pagination-wrap mt-70 d-flex flex-wrap justify-content-center text-center w-100">
						<ul class="pagination mb-0">';
							$output .= kriate_numeric_posts_nav();
							$output .= '
						</ul>
					</div>';
				} wp_reset_query();
				
				$output .= '
			</div>
		</div>
	</section>';
	
	echo $output;
  }
}
