<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Partners extends Widget_Base{

  public function get_name(){
    return 'partners-list';
  }

  public function get_title(){
    return 'Partners Logo';
  }

  public function get_icon(){
    return 'fa fa-flag';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'kriate' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'partner-logo',
			[
				'label' => __( 'Choose Logo Image', 'kriate' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => '',
				],
			]
		);
		
		$repeater->add_control(
		  'logo_link',
		  [
			'label' => 'Add Link URL',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '#'
		  ]
		);

		$this->add_control(
			'list',
			[
				'label' => __( 'Logos List', 'kriate' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[			
						'partner-logo' => __( '', 'kriate' ),
						'logo_link' => __( '#', 'kriate' ),
					],
	
				],
				'title_field' => '{{{ logo_link }}}',
			]
		);

		$this->end_controls_section();

	}
  

	protected function render() {
		
		$settings = $this->get_settings_for_display();
		
			$output = '
			
			<section>
                <div class="w-100 pt-50 pb-50 position-relative">
                    <div class="container">
                        <div class="clients-wrap w-100">
                            <div class="row">';
                             
								if ( $settings['list'] ) {
												
									foreach (  $settings['list'] as $item ) {
											
										if($item['partner-logo']['url']){
									
										$output .= '
											<div class="col-md-4 col-sm-4 col-lg-2">
												<div class="client-box w-100">
													<a href="'.$item['logo_link'].'" title=""><img class="img-fluid" src="'.$item['partner-logo']['url'].'" alt="'.esc_attr__('Partners','kriate').'"></a>
												</div>
											</div>';
										}
									}
								}
								
                                $output .= '
                            </div>
                        </div><!-- Clients Wrap -->
                    </div>
                </div>
            </section>';

			echo $output;
		
	}
}
