<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class MainSlider extends Widget_Base{

  public function get_name(){
    return 'main_slider';
  }

  public function get_title(){
    return 'Main Slider';
  }

  public function get_icon(){
    return 'fa fa-handshake';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
		'chose_style',
		[
			'label'     => esc_html__( 'Chose Style', 'kriate' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => [
				'style-one'  => esc_html__( 'Style 1', 'kriate' ),
				'style-two' => esc_html__( 'Style 2', 'kriate' ),
			],
			'default'   => 'style-one',
		]
	);
	
	$repeater = new \Elementor\Repeater();
	
	$repeater->add_control(
		'slide_image',[
			'label' => __( 'Choose Background Image', 'kriate' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => \Elementor\Utils::get_placeholder_image_src(),
			],
		]
	);

	$repeater->add_control(
		'slide_heading', [
			'label' => __( 'Slide Title', 'kriate' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => __( 'Builders, Merchants Success Despite Recession' , 'kriate' ),
			'label_block' => true,
		]
	);
	
	$repeater->add_control(
		'colored_heading', [
			'label' => __( 'Colored Text', 'kriate' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => __( '- Our Company.' , 'kriate' ),
			'label_block' => true,
		]
	);
	
	$repeater->add_control(
		'slide_description', [
			'label' => __( 'Slide Caption', 'kriate' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => __( 'Consectetur adipiscing elit duis volutpat ligula nulla dapibus. But the ma Mority have suffered alteration in some form.' , 'kriate' ),
			'label_block' => true,
		]
	);
	
	$repeater->add_control(
		'slide_btn', [
			'label' => __( 'Slide Button', 'kriate' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => __( 'Learn More' , 'kriate' ),
			'label_block' => true,
		]
	);

	$repeater->add_control(
		'slide_url', [
			'label' => __( 'Slide Button Link', 'kriate' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => __( '#' , 'kriate' ),
			'label_block' => true,
		]
	);
	
	$repeater->add_control(
		'video_title', [
			'label' => __( 'Video Title', 'kriate' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => __( 'Intro Video.' , 'kriate' ),
			'label_block' => true,
		]
	);
	
	$repeater->add_control(
		'video_title2', [
			'label' => __( 'Video Title 2', 'kriate' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => __( 'Watch.' , 'kriate' ),
			'label_block' => true,
		]
	);
	
	$repeater->add_control(
		'video_link', [
			'label' => __( 'Video Link', 'kriate' ),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => __( 'https://www.youtube.com/embed/6gUOzbhtVd4' , 'kriate' ),
			'label_block' => true,
		]
	);


	$this->add_control(
		'list',
		[
			'label' => __( 'Slide List', 'kriate' ),
			'type' => \Elementor\Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls(),
			'default' => [
				[	
					'slide_image' => \Elementor\Utils::get_placeholder_image_src(),
					'slide_heading' => __( 'Builders, Merchants Success Despite Recession', 'kriate' ),
					'colored_heading' => __( '- Our Company.', 'kriate' ),
					'slide_description' => __( 'Consectetur adipiscing elit duis volutpat ligula nulla dapibus. But the ma Mority have suffered alteration in some form.', 'kriate' ),
					'slide_btn' => __( 'Learn More', 'kriate' ),
					'slide_url' => '#',
					'video_title' => __( 'Intro Video', 'kriate' ),
					'video_title2' => __( 'Watch', 'kriate' ),
					'video_link' => 'https://www.youtube.com/embed/6gUOzbhtVd4',
				]
			],
			'title_field' => '{{{ slide_heading }}}',
		]
	);
	

    $this->end_controls_section();
  }
  

	protected function render(){
		
		$settings = $this->get_settings_for_display();
	
		wp_enqueue_style('slick-slider', get_template_directory_uri().'/assets/css/slick.css', [], '1.0.0');
		wp_enqueue_script( 'slick-slider', get_template_directory_uri() . '/assets/js/slick.min.js', array('jquery'), '1.0.0', true );
		       	
		/* Style One */
		if($settings['chose_style'] == 'style-one'){ ?>
		
		<section>
			<div class="w-100 position-relative">
				<div class="feat-wrap position-relative w-100">
					<div class="feat-caro v2s">
					<?php /* List all slides */
						if ( $settings['list'] ) {
						  foreach (  $settings['list'] as $item ) { ?>
							<div class="feat-item">
								<?php 
								$slide_img = $item['slide_image']['url'] ?? ($item['slide_image'] ?? '');
								$slide_img = $slide_img ?: \Elementor\Utils::get_placeholder_image_src();
								$slide_img = str_replace(['https://www.ballielektrik.com','https://ballielektrik.com'], home_url(), $slide_img);
								?>
								<div class="feat-img position-absolute" style="background-image: url(<?php echo esc_url($slide_img); ?>);"></div>
								<div class="container">
									<div class="feat-cap">
										<?php if($item['colored_heading']){ ?>
											<h2 class="mb-0">
												<?php echo esc_html($item['slide_heading']); ?>
												<strong class="d-block thm-clr"><?php echo esc_html($item['colored_heading']); ?></strong>
											</h2>
										<?php } ?>
										<?php if($item['slide_description']){ ?>
											<p class="mb-0"><?php echo esc_html($item['slide_description']); ?></p>
										<?php } ?>
										<div class="feat-cap-innr">
											<?php if($item['slide_btn']){ ?>
												<a class="thm-btn thm-bg" href="<?php echo esc_url($item['slide_url']); ?>" title=""><?php echo esc_html($item['slide_btn']); ?><i class="flaticon-arrow-pointing-to-right"></i></a>
											<?php } ?>
											<?php if($item['video_link']){ ?>
												<a class="video-btn" href="<?php echo esc_url($item['video_link']); ?>" data-fancybox title=""><span class="spinner"><i class="flaticon-play"></i></span><?php echo esc_html($item['video_title']); ?><br> <?php echo esc_html($item['video_title2']); ?></a>
											<?php } ?>
										</div>
									</div>
								</div>
							</div>
						 <?php }
						} ?>
					</div>
				</div><!-- Featured Area Wrap -->
			</div>
		</section>
			
	
			<?php 
		} /* end of style one */
		
		/* Style Two */
		if($settings['chose_style'] == 'style-two'){ ?>
			
			<section>
				<div class="w-100 position-relative">
					<div class="feat-wrap style2 position-relative w-100">
						<div class="feat-caro">
						<?php /* List all slides */
							if ( $settings['list'] ) {
							  foreach (  $settings['list'] as $item ) { ?>
								<div class="feat-item text-center">
									<?php 
									$slide_img = $item['slide_image']['url'] ?? ($item['slide_image'] ?? '');
									$slide_img = $slide_img ?: \Elementor\Utils::get_placeholder_image_src();
									$slide_img = str_replace(['https://www.ballielektrik.com','https://ballielektrik.com'], home_url(), $slide_img);
									?>
									<div class="feat-img position-absolute" style="background-image: url(<?php echo esc_url($slide_img); ?>);"></div>
									<div class="container">
										<div class="feat-cap">
											<?php if($item['slide_heading']){ ?>
												<h1 class="mb-0">
													<?php echo esc_html($item['slide_heading']); ?>
													<strong class="d-inline-block thm-clr"><?php echo esc_html($item['colored_heading']); ?></strong>
												</h1>
											<?php } ?>
											<?php if($item['slide_description']){ ?> <p class="mb-0"><?php echo esc_html($item['slide_description']); ?></p> <?php }?>
											<div class="feat-cap-innr">
											<?php if($item['slide_btn']){ ?>	
												<a class="thm-btn thm-bg" href="<?php echo esc_url($item['slide_url']); ?>" title=""><?php echo esc_html($item['slide_btn']); ?><i class="flaticon-arrow-pointing-to-right"></i></a>
											<?php } ?>
											<?php if($item['video_link']){ ?>
												<a class="video-btn" href="<?php echo esc_url($item['video_link']); ?>" data-fancybox title=""><span class="spinner"><i class="flaticon-play"></i></span><?php echo esc_html($item['video_title']); ?><br> <?php echo esc_html($item['video_title2']); ?></a>
											<?php } ?>
											</div>
										</div>
									</div>
								</div>
							 <?php }
							} ?>
						</div>
					</div><!-- Featured Area Wrap -->
				</div>
			</section>
				
			<?php 
		} /* end of style two */

	}
}