<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class HotDeal extends Widget_Base{

  public function get_name(){
    return 'hot-deal';
  }

  public function get_title(){
    return 'Hot Deal';
  }

  public function get_icon(){
    return 'fa fa-flag';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'kriate' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
		  'heading_title',
		  [
			'label' => 'Heading Title',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Hot Deal: '
		  ]
		);
		
		$this->add_control(
		  'heading_subtitle',
		  [
			'label' => 'Heading Sub Title',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Yacht Build Package'
		  ]
		);
		
		$this->add_control(
		  'discount_value',
		  [
			'label' => 'Discount Value',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '15%'
		  ]
		);
		
		$this->add_control(
		  'discount_text',
		  [
			'label' => 'Discount Text',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Off'
		  ]
		);
		
		$this->add_control(
		  'heading_caption',
		  [
			'label' => 'Heading Caption',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'We are always ready to best solution for your problem.'
		  ]
		);
		
		$this->add_control(
		  'list_title',
		  [
			'label' => 'List Title',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Our Technical Solutions'
		  ]
		);
		
		$this->add_control(
			'deal-image',
			[
				'label' => __( 'Choose Media Image', 'kriate' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => get_template_directory_uri().'/assets/images/solutions-img.jpg',
				],
			]
		);
		
		$this->add_control(
		  'video_url',
		  [
			'label' => 'Video URL (Optional)',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'https://www.youtube.com/embed/6gUOzbhtVd4'
		  ]
		);


		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
		  'heading_text',
		  [
			'label' => 'Heading Text',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => '18 Years Experience In Field.'
		  ]
		);
		
		$repeater->add_control(
		  'heading_description',
		  [
			'label' => 'Heading Description',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration.'
		  ]
		);
		
		$repeater->add_control(
			'makeit_featured',
			[
				'label' => __( 'Make It Featured', 'kriate' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'your-plugin' ),
				'label_off' => __( 'No', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		$this->add_control(
			'list',
			[
				'label' => __( 'List', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'heading_text' => __( '18 Years Experience In Field.', 'plugin-domain' ),
						'heading_description' => __( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration.', 'plugin-domain' ),
						'makeit_featured' => __( 'yes', 'plugin-domain' ),
					],
					[
						'heading_text' => __( 'Extensive Period of Warranty.', 'plugin-domain' ),
						'heading_description' => __( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration.', 'plugin-domain' ),
						'makeit_featured' => __( 'no', 'plugin-domain' ),
					],
					[
						'heading_text' => __( '15% Discount on BuildUp.', 'plugin-domain' ),
						'heading_description' => __( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration.', 'plugin-domain' ),
						'makeit_featured' => __( 'no', 'plugin-domain' ),
					],
	
				],
				'title_field' => '{{{ heading_text }}}',
			]
		);

		$this->end_controls_section();

	}
  

	protected function render() {
		
		$settings = $this->get_settings_for_display();
		
			$output = '
			      
			<section>
                <div class="w-100 pt-130 pb-100 position-relative">
                    <div class="container">
                        <div class="sec-title2 w-100 hotty">
                            <div class="sec-title-inner2 d-inline-block">
                                <h2 class="mb-0">'.esc_html( __( $settings['heading_title'], 'kriate' ) ). esc_html( __( $settings['heading_subtitle'], 'kriate' ) ).'<i>'.esc_html($settings['discount_value']).' <br> '.esc_html( __( $settings['discount_text'], 'kriate' ) ).'</i></h2>
                                <p class="mb-0">'.esc_html( __( $settings['heading_caption'], 'kriate' ) ).'</p>
                            </div>
                        </div>
                        <div class="solutions-wrap w-100">
                            <div class="row align-items-center">
                                <div class="col-md-6 col-sm-12 col-lg-6 post-detail-gallery-video-box position-relative">
                                    <a class="rounded-circle spinner" href="'.$settings['video_url'].'" data-fancybox title=""><i class="flaticon-play"></i></a>
                                    <img class="img-fluid w-100 brd-rd5" src="'.$settings['deal-image']['url'].'" alt="'.esc_attr__('Project Image','kriate').'">
                                </div>
                                <div class="col-md-6 col-sm-12 col-lg-6">
                                    <div class="solutions-content-wrap w-100">
                                        <h2 class="mb-0">'.esc_html( __( $settings['list_title'], 'kriate' ) ).'</h2>
                                        <ul class="solutions-list mb-0 list-unstyled w-100">';
                                            if ( $settings['list'] ) {
												
												foreach (  $settings['list'] as $item ) { 
												
														
												if($item['makeit_featured'] == 'yes'){ $active_class = 'active'; }else{ $active_class = ''; }
											
												$output .= '
											
													<li class = "'.$active_class.'">
														<i class="">+</i>
														<h4 class="mb-0">'.esc_html( __( $item['heading_text'], 'kriate' ) ).'</h4>
														<p class="mb-0">'.esc_html( __( $item['heading_description'], 'kriate' ) ).'</p>
													</li>';
												}
											}
											$output .= '
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div><!-- Solutions Wrap -->
                    </div>
                </div>
            </section>';

			echo $output;
		
	}
}
