<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class FooterCTA extends Widget_Base{

  public function get_name(){
    return 'footer-cta';
  }

  public function get_title(){
    return 'Footer CTA';
  }

  public function get_icon(){
    return 'fa fa-exclamation-circle';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
      'heading_subcaption',
      [
        'label' => 'Heading Icon',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Ready to get started?'
      ]
    );

    $this->add_control(
      'element_title',
      [
        'label' => 'Element Heading',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Get in touch, or create an account.'
      ]
    );
	
	$this->add_control(
		'background-image',
		[
			'label' => __( 'Choose Background Image', 'kriate' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/parallax2.jpg',
			],
		]
	);

	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Subscribe Now'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'kriate' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );
	

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : '';
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : '';  ?>
	
	<section>
		<div class="w-100 position-relative">
			<div class="container">
				<div class="getin-touch-wrap overlap-99 brd-rd5 style2 thm-layer opc8 w-100 overflow-hidden position-relative">
					<?php if($settings['background-image']['url']){ ?>
						<div class="fixed-bg" style="background-image: url(<?php echo esc_url($settings['background-image']['url']); ?>);"></div>
					<?php } ?>
					<div class="row align-items-center justify-content-between">
						<div class="col-md-7 col-sm-12 col-lg-5">
							<div class="getin-touch-title w-100">
								<?php if($settings['heading_subcaption']){ ?>
									<span class="text-color1 d-block"><?php echo esc_html( __( $settings['heading_subcaption'], 'kriate' ) ); ?></span>
								<?php } ?>
								<?php if($settings['element_title']){ ?><h2 class="mb-0"><?php echo esc_html( __( $settings['element_title'], 'kriate' ) ); ?></h2><?php } ?>
							</div>
						</div>
						<div class="col-md-5 col-sm-12 col-lg-4">
							<?php if($settings['button_text']){ ?>
								<div class="getin-touch-btn text-right">
									<a class="thm-btn bg-color1" href="<?php echo esc_url($settings['button_url']['url']); ?>" title=""><?php echo esc_html( __( $settings['button_text'], 'kriate' ) ); ?><i class="flaticon-arrow-pointing-to-right"></i></a>
								</div>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>

    <?php
  }
}
