<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class FAQsBlock extends Widget_Base{

  public function get_name(){
    return 'faqs-block';
  }

  public function get_title(){
    return 'FAQs';
  }

  public function get_icon(){
    return 'fa fa-flag';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'kriate' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
		  'heading_subtitle',
		  [
			'label' => 'Heading Sub Title',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Visit Our'
		  ]
		);
		
		$this->add_control(
		  'heading_title',
		  [
			'label' => 'Heading Title',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Frequently Asked Questions '
		  ]
		);
		
		$this->add_control(
			'bg-image',
			[
				'label' => __( 'Choose Media Image', 'kriate' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => get_template_directory_uri().'/assets/images/faq-mockup.png',
				],
			]
		);


		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
		  'question',
		  [
			'label' => 'Question',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'How can we start a project?'
		  ]
		);
		
		$repeater->add_control(
		  'answer',
		  [
			'label' => 'Answer',
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.'
		  ]
		);
		
		$this->add_control(
			'list',
			[
				'label' => __( 'FAQs List', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'question' => __( 'How can we start a project?', 'plugin-domain' ),
						'answer' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.', 'plugin-domain' ),
					],
					[
						'question' => __( 'When to consult for our services?', 'plugin-domain' ),
						'answer' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.', 'plugin-domain' ),
					],
					[
						'question' => __( 'Is there any Free Consultancy Available?', 'plugin-domain' ),
						'answer' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.', 'plugin-domain' ),
					],
					[
						'question' => __( 'How to modify the binded contract in year 2021?', 'plugin-domain' ),
						'answer' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.', 'plugin-domain' ),
					],
					[
						'question' => __( 'Is ther any way we can architect our company?', 'plugin-domain' ),
						'answer' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.', 'plugin-domain' ),
					],
	
				],
				'title_field' => '{{{ question }}}',
			]
		);

		$this->end_controls_section();

	}
  

	protected function render() {
		
		$settings = $this->get_settings_for_display();
		
			$output = '
			
			<section>
                <div class="w-100 pt-100 pb-100 position-relative">
                    <div class="container">';
						if($settings['heading_title'] || $settings['heading_subtitle']){ 
						   $output .= '
								<div class="sec-title w-100 faqs">
									<div class="sec-title-inner d-inline-block">
										<span class="d-block thm-clr">'.$settings['heading_subtitle'].'</span>
										<h3 class="mb-0">'.$settings['heading_title'].'</h3>
									</div>
								</div>';
						}
						$output .= '
                        <div class="faq-wrap w-100">
                            <div class="row">';
							if($settings['bg-image']['url']){	
								$output .= '
									<div class="col-md-6 col-sm-12 col-lg-6 order-md-1">
										<img class="img-fluid" src="'.$settings['bg-image']['url'].'" alt="'.esc_attr__('FAQ Image','kriate').'">
									</div>';
							}	
							$output .= '
                                <div class="col-md-6 col-sm-12 col-lg-6">
                                    <div class="toggle w-100" id="toggle">';
                                        if ( $settings['list'] ){
												
												foreach (  $settings['list'] as $item ) { 
												
													static $counter = 1;
													
													$output .= '
														<div class="toggle-item w-100">
															<h4 class="mb-0"><span>0'.$counter.'.</span>'.$item['question'].'</h4>
															<div class="toggle-content w-100"><p class="mb-0">'.$item['answer'].'</p></div>
														</div>';
													
													$counter++;
												}
										}
										 
                                        $output .= '
                                    </div>
                                </div>
                            </div>
                        </div><!-- Faq Wrap -->
                    </div>
                </div>
            </section>';
			
			echo $output;
		
	}
}
