<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class FactsCount extends Widget_Base{

  public function get_name(){
    return 'facts-count';
  }

  public function get_title(){
    return 'Facts Count';
  }

  public function get_icon(){
    return 'fa fa-cogs';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	 
    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );

	
	$this->add_control(
		'fact-bg-image',
		[
			'label' => __( 'Choose Facts Background Image', 'kriate' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/pattern-bg1.png',
			],
		]
	);
	
	$repeater = new \Elementor\Repeater();
	
    $repeater->add_control(
      'fact_count',
      [
        'label' => 'Fact Count',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '18'
      ]
    );
	
	$repeater->add_control(
      'fact_suffix',
      [
        'label' => 'Fact Suffix',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '+'
      ]
    );

	$repeater->add_control(
      'fact_text',
      [
        'label' => 'Fact Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Experience'
      ]
    );

		   
	$this->add_control(
		'list',
			[
			'label' => __( 'Fact Counts', 'plugin-domain' ),
			'type' => \Elementor\Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls(),
			'default' => [
				[		
					'fact_count' => __( '18', 'plugin-domain' ),
					'fact_suffix' => __( '+', 'plugin-domain' ),
					'fact_text' => __( 'Experience', 'plugin-domain' ),
				],
				[		
					'fact_count' => __( '502', 'plugin-domain' ),
					'fact_suffix' => __( '+', 'plugin-domain' ),
					'fact_text' => __( 'Completed Projects', 'plugin-domain' ),
				],
				[		
					'fact_count' => __( '120', 'plugin-domain' ),
					'fact_suffix' => __( '+', 'plugin-domain' ),
					'fact_text' => __( 'Constructions', 'plugin-domain' ),
				],
				[		
					'fact_count' => __( '12', 'plugin-domain' ),
					'fact_suffix' => __( '+', 'plugin-domain' ),
					'fact_text' => __( 'Running Projects', 'plugin-domain' ),
				],
			],
			'title_field' => '{{{ fact_text }}}',
			]
		);
	

    $this->end_controls_section();
  }
  

  protected function render(){
    
	$settings = $this->get_settings_for_display(); 
	
	wp_enqueue_script( 'counterup-js', get_template_directory_uri() . '/assets/js/counterup.min.js', array('jquery'), '1.0.0', true ); ?>
	
	<section>
		<div class="w-100 thm-layer opc1 overflow-hidden position-relative">
			<?php if($settings['fact-bg-image']['url']){ ?>
				<div class="parallax-bg zoom-anim back-blend-multiply patern-bg thm-bg" style="background-image: url(<?php echo esc_url($settings['fact-bg-image']['url']); ?>);"></div>
			<?php } ?>
			<div class="container">
				<div class="facts-wrap shadow-none text-center w-100">
					<div class="row">
						<?php 
						if ( $settings['list'] ) {
										
							foreach (  $settings['list'] as $item ) { ?>
								
								<div class="col-md-3 col-sm-6 col-lg-3">
									<div class="fact-box w-100">
										<?php if($item['fact_count']){ ?>
											<h2 class="mb-0"><span class="counter"><?php echo esc_html( $item['fact_count'] ); ?></span><sup><?php echo esc_html( $item['fact_suffix'] ); ?></sup></h2>
										<?php } ?>
										<?php if($item['fact_text']){ ?>
										<h4 class="mb-0"><?php echo $item['fact_text']; ?></h4>
										<?php } ?>
									</div>
								</div>
							<?php }
						} ?>
					</div><!-- Facts Wrap -->
				</div>
			</div>
		</div>
	</section>

    <?php
  }
}