<?php
/**
 * Performans optimizasyonu - titreme önleme, stabil ve hızlı yükleme
 */
add_action('wp_head', function() {
    echo '<link rel="preconnect" href="https://fonts.googleapis.com">' . "\n";
    echo '<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>' . "\n";
}, 1);

// Elementor görsel optimizasyonu - buffer titremesine neden olabilir
add_filter('option_elementor_optimized_image_loading', '__return_zero');

// Slick slider CSS'i head'de erken yükle - titreme önleme (Elementor render wp_head'den sonra çalışır)
add_action('wp_enqueue_scripts', function() {
    if (is_front_page() || is_home() || is_page()) {
        wp_enqueue_style('slick-slider', get_template_directory_uri() . '/assets/css/slick.css', [], '1.0.0');
    }
}, 5);
