<?php
/**
 * Local geliştirme - Tüm ballielektrik.com linklerini localhost'a yönlendir
 * Sadece localhost'ta çalışır. Canlıya geçince bu dosyayı silin.
 */
$site = home_url();
if ( strpos( $site, 'localhost' ) === false && strpos( $site, '127.0.0.1' ) === false ) {
    return;
}

$local_url = home_url();
$old_urls = [
    'https://www.ballielektrik.com',
    'https://ballielektrik.com',
    'http://www.ballielektrik.com',
    'http://ballielektrik.com',
    'https://www.www.ballielektrik.com',
];

add_filter( 'content_url', function( $url ) use ( $old_urls, $local_url ) {
    foreach ( $old_urls as $old ) {
        $url = str_replace( $old, $local_url, $url );
    }
    return $url;
}, 1 );

add_filter( 'home_url', function( $url, $path, $scheme ) use ( $old_urls, $local_url ) {
    foreach ( $old_urls as $old ) {
        $url = str_replace( $old, $local_url, $url );
    }
    return $url;
}, 1, 3 );

add_filter( 'site_url', function( $url, $path, $scheme ) use ( $old_urls, $local_url ) {
    foreach ( $old_urls as $old ) {
        $url = str_replace( $old, $local_url, $url );
    }
    return $url;
}, 1, 3 );

add_filter( 'the_content', function( $content ) use ( $old_urls, $local_url ) {
    foreach ( $old_urls as $old ) {
        $content = str_replace( $old, $local_url, $content );
    }
    return $content;
}, 1 );

add_filter( 'post_link', function( $url ) use ( $old_urls, $local_url ) {
    foreach ( $old_urls as $old ) {
        $url = str_replace( $old, $local_url, $url );
    }
    return $url;
}, 1 );

add_filter( 'page_link', function( $url ) use ( $old_urls, $local_url ) {
    foreach ( $old_urls as $old ) {
        $url = str_replace( $old, $local_url, $url );
    }
    return $url;
}, 1 );

add_filter( 'nav_menu_link_attributes', function( $atts, $item ) use ( $old_urls, $local_url ) {
    if ( ! empty( $atts['href'] ) ) {
        foreach ( $old_urls as $old ) {
            $atts['href'] = str_replace( $old, $local_url, $atts['href'] );
        }
    }
    return $atts;
}, 1, 2 );

add_filter( 'wp_nav_menu_items', function( $items ) use ( $old_urls, $local_url ) {
    foreach ( $old_urls as $old ) {
        $items = str_replace( $old, $local_url, $items );
    }
    return $items;
}, 1 );

add_filter( 'option_home', function( $value ) use ( $local_url ) {
    return $local_url;
}, 1 );

add_filter( 'option_siteurl', function( $value ) use ( $local_url ) {
    return $local_url;
}, 1 );
