<?php
/**
 * Plugin Name: Hide Elementor Editor Popup
 * Description: Elementor "The Editor has a new home" ve tüm tanıtım popup'larını kalıcı kapatır
 * Version: 2.0
 */

defined( 'ABSPATH' ) || exit;

// Tüm bilinen Elementor popup anahtarlarını işaretle
add_action( 'admin_init', function() {
	$user_id = get_current_user_id();
	if ( ! $user_id ) return;

	$intro_meta = get_user_meta( $user_id, 'elementor_introduction', true );
	if ( ! is_array( $intro_meta ) ) {
		$intro_meta = [];
	}
	
	$keys_to_dismiss = [
		'e-editor-one-notice-pointer',  // "The Editor has a new home"
		'e-apps',
		'ai-get-started-announcement',
		'editor-v4-alpha',
		'editor_v4_welcome',
	];
	
	foreach ( $keys_to_dismiss as $key ) {
		$intro_meta[ $key ] = true;
	}
	
	update_user_meta( $user_id, 'elementor_introduction', $intro_meta );
}, 1 );

// Popup overlay ve modal'ı CSS ile gizle
add_action( 'admin_head', function() {
	?>
	<style id="hide-elementor-popup">
	.elementor-onboarding, .e-onboarding, .elementor-introduction-modal,
	[class*="editor-v4"][class*="modal"], [data-id="e-editor-one-notice"],
	body.elementor-modal-open .elementor-common-dialog { display:none !important; }
	body.elementor-modal-open { overflow:auto !important; }
	</style>
	<?php
}, 1 );

// Popup DOM'dan kaldır - "Anladım/Gizle" çalışmazsa
add_action( 'admin_footer', function() {
	?>
	<script>
	(function() {
		function hideElementorPopups() {
			var s = '.elementor-onboarding, .e-onboarding, .elementor-introduction-modal, .e-app__onboarding, [class*="e-editor-one"]';
			document.querySelectorAll(s).forEach(function(el){ el.remove(); });
			document.body.classList.remove('elementor-modal-open');
		}
		document.addEventListener('DOMContentLoaded', hideElementorPopups);
		setTimeout(hideElementorPopups, 300);
		setTimeout(hideElementorPopups, 1500);
	})();
	</script>
	<?php
}, 999 );
