<?php
/**
 * Plugin Name: Fix Ingeniofy Deprecated (Tek Seferlik)
 * Description: Ingeniofy CMB2 ve uCal deprecated hatalarını düzeltir. Çalıştıktan sonra bu dosyayı silebilirsiniz.
 * Version: 1.0
 *
 * Kullanım: wp-admin'a ?fix_ingeniofy=1 ile giriş yapın (admin olarak)
 */

defined( 'ABSPATH' ) || exit;

add_action( 'admin_init', function() {
	if ( ! current_user_can( 'activate_plugins' ) || ! isset( $_GET['fix_ingeniofy'] ) || '1' !== $_GET['fix_ingeniofy'] ) {
		return;
	}

	$base = WP_PLUGIN_DIR . '/ingeniofy';
	if ( ! is_dir( $base ) ) {
		wp_die( 'Ingeniofy eklentisi bulunamadı: ' . $base );
	}

	$fixed = array();

	// 1. CMB2_REST.php
	$cmb2_file = $base . '/cmb2/includes/rest-api/CMB2_REST.php';
	if ( file_exists( $cmb2_file ) ) {
		$content = file_get_contents( $cmb2_file );
		$orig = $content;
		$content = preg_replace(
			'/protected function field_can\(\s*\$type\s*,\s*\$field_id\s*,\s*\$return_object\s*=\s*false\s*\)/',
			'protected function field_can( $field_id, $type, $return_object = false )',
			$content
		);
		$content = str_replace( "field_can( 'read_fields', \$field_id,", "field_can( \$field_id, 'read_fields',", $content );
		$content = str_replace( "field_can( 'edit_fields', \$field_id,", "field_can( \$field_id, 'edit_fields',", $content );
		if ( $content !== $orig ) {
			file_put_contents( $cmb2_file, $content );
			$fixed[] = 'CMB2_REST.php';
		}
	}

	// 2. uCal.php
	$ucal_file = $base . '/salat-times/uCal.php';
	if ( file_exists( $ucal_file ) ) {
		$content = file_get_contents( $ucal_file );
		$orig = $content;
		// Opsiyonel parametreleri zorunlu parametreden sonraya taşı
		$content = preg_replace(
			'/function\s+(\w+)\s*\(\s*\$hour\s*=\s*0\s*,\s*\$minute\s*=\s*0\s*,\s*\$second\s*=\s*0\s*,\s*\$year\s*\)/',
			'function $1( $year, $hour = 0, $minute = 0, $second = 0 )',
			$content
		);
		if ( $content !== $orig ) {
			file_put_contents( $ucal_file, $content );
			$fixed[] = 'uCal.php';
		}
	}

	if ( empty( $fixed ) ) {
		wp_die( 'Düzeltilecek hata bulunamadı veya dosyalar zaten güncel.' );
	}

	wp_redirect( add_query_arg( array( 'ingeniofy_fixed' => implode( ',', $fixed ), 'fix_ingeniofy' => null ), admin_url() ) );
	exit;
});

add_action( 'admin_notices', function() {
	if ( isset( $_GET['ingeniofy_fixed'] ) ) {
		echo '<div class="notice notice-success"><p>Ingeniofy düzeltmeleri uygulandı: ' . esc_html( $_GET['ingeniofy_fixed'] ) . '. Artık fix-ingeniofy-deprecated.php dosyasını silebilirsiniz.</p></div>';
	}
});
