/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-02-23 10:57:05 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `nqcpo_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_aiowps_audit_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `network_id` bigint NOT NULL DEFAULT '0',
  `site_id` bigint NOT NULL DEFAULT '0',
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ip` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `level` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `event_type` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `details` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `stacktrace` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created` int unsigned DEFAULT NULL,
  `country_code` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `username` (`username`),
  KEY `ip` (`ip`),
  KEY `level` (`level`),
  KEY `event_type` (`event_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `nqcpo_aiowps_debug_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `logtime` int unsigned DEFAULT NULL,
  `level` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `network_id` bigint NOT NULL DEFAULT '0',
  `site_id` bigint NOT NULL DEFAULT '0',
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `nqcpo_aiowps_events` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int unsigned DEFAULT NULL,
  `ip_or_host` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `referer_info` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country_code` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `event_data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `nqcpo_aiowps_global_meta` (
  `meta_id` bigint NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int unsigned DEFAULT NULL,
  `meta_key1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value2` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value3` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value4` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value5` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `nqcpo_aiowps_logged_in_users` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint NOT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `site_id` bigint NOT NULL,
  `created` int unsigned DEFAULT NULL,
  `expires` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_id` (`user_id`),
  KEY `created` (`created`),
  KEY `expires` (`expires`),
  KEY `user_id` (`user_id`),
  KEY `site_id` (`site_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `nqcpo_aiowps_login_lockdown` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int unsigned DEFAULT NULL,
  `release_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `released` int unsigned DEFAULT NULL,
  `failed_login_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `lock_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `unlock_key` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `is_lockout_email_sent` tinyint(1) NOT NULL DEFAULT '1',
  `backtrace_log` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ip_lookup_result` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `failed_login_ip` (`failed_login_ip`),
  KEY `is_lockout_email_sent` (`is_lockout_email_sent`),
  KEY `unlock_key` (`unlock_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `nqcpo_aiowps_message_store` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `message_key` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message_value` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `nqcpo_aiowps_permanent_block` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `block_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `country_origin` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int unsigned DEFAULT NULL,
  `unblock` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `blocked_ip` (`blocked_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `nqcpo_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=297 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=124 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `nqcpo_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_ip_tracking` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_litespeed_avatar` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `md5` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `dateline` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `md5` (`md5`),
  KEY `dateline` (`dateline`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `nqcpo_litespeed_url` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `url` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cache_tags` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=InnoDB AUTO_INCREMENT=22922 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_litespeed_url_file` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `url_id` bigint NOT NULL,
  `vary` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `expired` int NOT NULL DEFAULT '0',
  `mobile` tinyint NOT NULL COMMENT 'mobile=1',
  `webp` tinyint NOT NULL COMMENT 'webp=1',
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=InnoDB AUTO_INCREMENT=49360 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=198686 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=31862 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=34603 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_site_mail_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `api_id` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `to` text COLLATE utf8mb4_unicode_520_ci,
  `subject` varchar(768) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `headers` text COLLATE utf8mb4_unicode_520_ci,
  `message` text COLLATE utf8mb4_unicode_520_ci,
  `activity` text COLLATE utf8mb4_unicode_520_ci,
  `source` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `opened` tinyint(1) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `api_id` (`api_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `nqcpo_site_mail_statuses` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `log_id` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(3) COLLATE utf8mb4_unicode_520_ci DEFAULT 'to' COMMENT 'to|cc|bcc',
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT 'pending' COMMENT 'pending|accepted|processed|delivered|bounce|dropped|deferred|not sent|rate limit|not valid|unsubscribed',
  `opened` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `log_id` (`log_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `nqcpo_site_mail_suppressions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `reason` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'unsubscribed | manual | bounced | blocked',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `nqcpo_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=4656 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4656 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=234 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1156 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_wfauditevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `request_id` bigint unsigned NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int unsigned NOT NULL DEFAULT '0',
  `unixday` int unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfblocks7` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` int unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int unsigned DEFAULT '0',
  `blockedHits` int unsigned DEFAULT '0',
  `expiration` bigint unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfhits` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint DEFAULT '0',
  `statusCode` int NOT NULL DEFAULT '200',
  `isGoogle` tinyint NOT NULL,
  `userID` int unsigned NOT NULL,
  `newVisit` tinyint unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfhoover` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfknownfilelist` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int unsigned NOT NULL,
  `failed` tinyint unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wflogins` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfls_2fa_secrets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int unsigned NOT NULL,
  `vtime` int unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int NOT NULL DEFAULT '1000',
  `ctime` int unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfpendingissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfsecurityevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfsnipcache` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int unsigned NOT NULL DEFAULT '0',
  `type` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfstatus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wftrafficrates` (
  `eMin` int unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_wfwaffailures` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `nqcpo_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `nqcpo_wpfm_backup` (
  `id` int NOT NULL AUTO_INCREMENT,
  `backup_name` text COLLATE utf8mb4_unicode_520_ci,
  `backup_date` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: nqcpo_actionscheduler_groups */
INSERT INTO `nqcpo_actionscheduler_groups` VALUES("1", "action-scheduler-migration");

/* INSERT TABLE DATA: nqcpo_duplicator_packages */
INSERT INTO `nqcpo_duplicator_packages` VALUES("1", "20260223_ankaraballielektrik", "70c09943487b12464040_20260223105606", "21", "2026-02-23 10:57:05", "Ballielektrik", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2026-02-23 10:56:06\";s:7:\"Version\";s:6:\"1.5.15\";s:9:\"VersionWP\";s:5:\"6.9.1\";s:9:\"VersionDB\";s:6:\"8.0.44\";s:10:\"VersionPHP\";s:6:\"8.3.28\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:1;s:4:\"Name\";s:28:\"20260223_ankaraballielektrik\";s:4:\"Hash\";s:35:\"70c09943487b12464040_20260223105606\";s:8:\"NameHash\";s:64:\"20260223_ankaraballielektrik_70c09943487b12464040_20260223105606\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:74:\"20260223_ankaraballielektrik_70c09943487b12464040_20260223105606_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.6\";s:6:\"WPUser\";s:13:\"Ballielektrik\";s:7:\"Archive\";O:11:\"DUP_Archive\":27:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:76:\"20260223_ankaraballielektrik_70c09943487b12464040_20260223105606_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:39:\"/Applications/MAMP/htdocs/ballielektrik\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1707;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:10441;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2026-02-23 10:56:06\";s:7:\"Version\";s:6:\"1.5.15\";s:9:\"VersionWP\";s:5:\"6.9.1\";s:9:\"VersionDB\";s:6:\"8.0.44\";s:10:\"VersionPHP\";s:6:\"8.3.28\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:28:\"20260223_ankaraballielektrik\";s:4:\"Hash\";s:35:\"70c09943487b12464040_20260223105606\";s:8:\"NameHash\";s:64:\"20260223_ankaraballielektrik_70c09943487b12464040_20260223105606\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:82:\"20260223_ankaraballielektrik_70c09943487b12464040_20260223105606_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:66;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:53:\"/Applications/MAMP/htdocs/ballielektrik/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:77:\"20260223_ankaraballielektrik_70c09943487b12464040_20260223105606_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:149:\"/Applications/MAMP/htdocs/ballielektrik/wp-content/backups-dup-lite/tmp/20260223_ankaraballielektrik_70c09943487b12464040_20260223105606_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:66;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:48:\"/Applications/MAMP/htdocs/ballielektrik/wp-admin\";i:1;s:51:\"/Applications/MAMP/htdocs/ballielektrik/wp-includes\";i:2;s:60:\"/Applications/MAMP/htdocs/ballielektrik/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:39:\"/Applications/MAMP/htdocs/ballielektrik\";i:1;s:39:\"/Applications/MAMP/htdocs/ballielektrik\";i:2;s:50:\"/Applications/MAMP/htdocs/ballielektrik/wp-content\";i:3;s:58:\"/Applications/MAMP/htdocs/ballielektrik/wp-content/uploads\";i:4;s:58:\"/Applications/MAMP/htdocs/ballielektrik/wp-content/plugins\";i:5;s:61:\"/Applications/MAMP/htdocs/ballielektrik/wp-content/mu-plugins\";i:6;s:57:\"/Applications/MAMP/htdocs/ballielektrik/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:3:{i:0;s:71:\"/Applications/MAMP/htdocs/ballielektrik/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";i:2;s:18:\"duplicator-backups\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;s:38:\"\0DUP_Archive\0wpContentDirNormalizePath\";N;}s:9:\"Installer\";r:87;s:8:\"Database\";r:106;s:13:\"BuildProgress\";r:145;}");

/* INSERT TABLE DATA: nqcpo_litespeed_avatar */
INSERT INTO `nqcpo_litespeed_avatar` VALUES("1", "https://secure.gravatar.com/avatar/?s=32&d=mm&r=g", "681c8afaf173814c21bcf077c1826a28", "1771801246");
INSERT INTO `nqcpo_litespeed_avatar` VALUES("2", "https://secure.gravatar.com/avatar/?s=170&d=mm&r=g", "62fe055587463f4b73c108263754667a", "1771801246");
INSERT INTO `nqcpo_litespeed_avatar` VALUES("3", "https://secure.gravatar.com/avatar/c8e05b2a52c299eaef4e8ecf05dddb4a9168d36f50db89fe41b0bea1cfa3a114?s=32&d=mm&r=g", "6966482e82a52cd4b1886dae3ad38b93", "1771801246");
INSERT INTO `nqcpo_litespeed_avatar` VALUES("4", "https://secure.gravatar.com/avatar/c8e05b2a52c299eaef4e8ecf05dddb4a9168d36f50db89fe41b0bea1cfa3a114?s=170&d=mm&r=g", "acf71fe8469c8f21e3ad52d126d4a425", "1771801245");

/* INSERT TABLE DATA: nqcpo_litespeed_url */
INSERT INTO `nqcpo_litespeed_url` VALUES("22921", "http://localhost:8888/ballielektrik/", "");

/* INSERT TABLE DATA: nqcpo_litespeed_url_file */
INSERT INTO `nqcpo_litespeed_url_file` VALUES("49358", "22921", "", "520ff5ced7e69a0735ad15de3b9d4791", "1", "0", "0", "0");
INSERT INTO `nqcpo_litespeed_url_file` VALUES("49359", "22921", "", "9781ec83b32a9cbdedee200f316934df", "2", "0", "0", "0");

/* INSERT TABLE DATA: nqcpo_options */
INSERT INTO `nqcpo_options` VALUES("1", "siteurl", "http://localhost:8888/ballielektrik", "off");
INSERT INTO `nqcpo_options` VALUES("2", "home", "http://localhost:8888/ballielektrik", "off");
INSERT INTO `nqcpo_options` VALUES("3", "blogname", "Ankara Ballı Elektrik", "yes");
INSERT INTO `nqcpo_options` VALUES("4", "blogdescription", "Resmi Web Sitesi", "yes");
INSERT INTO `nqcpo_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `nqcpo_options` VALUES("6", "admin_email", "info@ballielektrik.com", "yes");
INSERT INTO `nqcpo_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `nqcpo_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("10", "require_name_email", "", "yes");
INSERT INTO `nqcpo_options` VALUES("11", "comments_notify", "", "yes");
INSERT INTO `nqcpo_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `nqcpo_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `nqcpo_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `nqcpo_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `nqcpo_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `nqcpo_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `nqcpo_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("19", "default_comment_status", "", "yes");
INSERT INTO `nqcpo_options` VALUES("20", "default_ping_status", "", "yes");
INSERT INTO `nqcpo_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `nqcpo_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `nqcpo_options` VALUES("23", "date_format", "d/m/Y", "yes");
INSERT INTO `nqcpo_options` VALUES("24", "time_format", "H:i", "yes");
INSERT INTO `nqcpo_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `nqcpo_options` VALUES("26", "comment_moderation", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("27", "moderation_notify", "", "yes");
INSERT INTO `nqcpo_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `nqcpo_options` VALUES("29", "rewrite_rules", "a:197:{s:11:\"services/?$\";s:28:\"index.php?post_type=services\";s:41:\"services/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=services&feed=$matches[1]\";s:36:\"services/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=services&feed=$matches[1]\";s:28:\"services/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=services&paged=$matches[1]\";s:7:\"team/?$\";s:24:\"index.php?post_type=team\";s:37:\"team/feed/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=team&feed=$matches[1]\";s:32:\"team/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=team&feed=$matches[1]\";s:24:\"team/page/([0-9]{1,})/?$\";s:42:\"index.php?post_type=team&paged=$matches[1]\";s:11:\"projects/?$\";s:28:\"index.php?post_type=projects\";s:41:\"projects/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=projects&feed=$matches[1]\";s:36:\"projects/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=projects&feed=$matches[1]\";s:28:\"projects/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=projects&paged=$matches[1]\";s:14:\"testimonial/?$\";s:31:\"index.php?post_type=testimonial\";s:44:\"testimonial/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=testimonial&feed=$matches[1]\";s:39:\"testimonial/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=testimonial&feed=$matches[1]\";s:31:\"testimonial/page/([0-9]{1,})/?$\";s:49:\"index.php?post_type=testimonial&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:47:\"elementor_component/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"elementor_component/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"elementor_component/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"elementor_component/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"elementor_component/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"elementor_component/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"elementor_component/([^/]+)/embed/?$\";s:52:\"index.php?elementor_component=$matches[1]&embed=true\";s:40:\"elementor_component/([^/]+)/trackback/?$\";s:46:\"index.php?elementor_component=$matches[1]&tb=1\";s:48:\"elementor_component/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?elementor_component=$matches[1]&paged=$matches[2]\";s:55:\"elementor_component/([^/]+)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?elementor_component=$matches[1]&cpage=$matches[2]\";s:44:\"elementor_component/([^/]+)(?:/([0-9]+))?/?$\";s:58:\"index.php?elementor_component=$matches[1]&page=$matches[2]\";s:36:\"elementor_component/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"elementor_component/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"elementor_component/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"elementor_component/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"elementor_component/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"elementor_component/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"services/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"services/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"services/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"services/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"services/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"services/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"services/(.+?)/embed/?$\";s:41:\"index.php?services=$matches[1]&embed=true\";s:27:\"services/(.+?)/trackback/?$\";s:35:\"index.php?services=$matches[1]&tb=1\";s:47:\"services/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?services=$matches[1]&feed=$matches[2]\";s:42:\"services/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?services=$matches[1]&feed=$matches[2]\";s:35:\"services/(.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?services=$matches[1]&paged=$matches[2]\";s:42:\"services/(.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?services=$matches[1]&cpage=$matches[2]\";s:31:\"services/(.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?services=$matches[1]&page=$matches[2]\";s:58:\"services-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?services-cat=$matches[1]&feed=$matches[2]\";s:53:\"services-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?services-cat=$matches[1]&feed=$matches[2]\";s:34:\"services-category/([^/]+)/embed/?$\";s:45:\"index.php?services-cat=$matches[1]&embed=true\";s:46:\"services-category/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?services-cat=$matches[1]&paged=$matches[2]\";s:28:\"services-category/([^/]+)/?$\";s:34:\"index.php?services-cat=$matches[1]\";s:30:\"team/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"team/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"team/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"team/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"team/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"team/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:19:\"team/(.+?)/embed/?$\";s:37:\"index.php?team=$matches[1]&embed=true\";s:23:\"team/(.+?)/trackback/?$\";s:31:\"index.php?team=$matches[1]&tb=1\";s:43:\"team/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?team=$matches[1]&feed=$matches[2]\";s:38:\"team/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?team=$matches[1]&feed=$matches[2]\";s:31:\"team/(.+?)/page/?([0-9]{1,})/?$\";s:44:\"index.php?team=$matches[1]&paged=$matches[2]\";s:38:\"team/(.+?)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?team=$matches[1]&cpage=$matches[2]\";s:27:\"team/(.+?)(?:/([0-9]+))?/?$\";s:43:\"index.php?team=$matches[1]&page=$matches[2]\";s:54:\"team-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?team-category=$matches[1]&feed=$matches[2]\";s:49:\"team-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?team-category=$matches[1]&feed=$matches[2]\";s:30:\"team-category/([^/]+)/embed/?$\";s:46:\"index.php?team-category=$matches[1]&embed=true\";s:42:\"team-category/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?team-category=$matches[1]&paged=$matches[2]\";s:24:\"team-category/([^/]+)/?$\";s:35:\"index.php?team-category=$matches[1]\";s:34:\"projects/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"projects/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"projects/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"projects/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"projects/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"projects/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"projects/(.+?)/embed/?$\";s:41:\"index.php?projects=$matches[1]&embed=true\";s:27:\"projects/(.+?)/trackback/?$\";s:35:\"index.php?projects=$matches[1]&tb=1\";s:47:\"projects/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?projects=$matches[1]&feed=$matches[2]\";s:42:\"projects/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?projects=$matches[1]&feed=$matches[2]\";s:35:\"projects/(.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?projects=$matches[1]&paged=$matches[2]\";s:42:\"projects/(.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?projects=$matches[1]&cpage=$matches[2]\";s:31:\"projects/(.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?projects=$matches[1]&page=$matches[2]\";s:58:\"projects-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?projects-category=$matches[1]&feed=$matches[2]\";s:53:\"projects-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?projects-category=$matches[1]&feed=$matches[2]\";s:34:\"projects-category/([^/]+)/embed/?$\";s:50:\"index.php?projects-category=$matches[1]&embed=true\";s:46:\"projects-category/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?projects-category=$matches[1]&paged=$matches[2]\";s:28:\"projects-category/([^/]+)/?$\";s:39:\"index.php?projects-category=$matches[1]\";s:37:\"testimonial/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"testimonial/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"testimonial/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"testimonial/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"testimonial/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"testimonial/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"testimonial/(.+?)/embed/?$\";s:44:\"index.php?testimonial=$matches[1]&embed=true\";s:30:\"testimonial/(.+?)/trackback/?$\";s:38:\"index.php?testimonial=$matches[1]&tb=1\";s:50:\"testimonial/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?testimonial=$matches[1]&feed=$matches[2]\";s:45:\"testimonial/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?testimonial=$matches[1]&feed=$matches[2]\";s:38:\"testimonial/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&paged=$matches[2]\";s:45:\"testimonial/(.+?)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&cpage=$matches[2]\";s:34:\"testimonial/(.+?)(?:/([0-9]+))?/?$\";s:50:\"index.php?testimonial=$matches[1]&page=$matches[2]\";s:61:\"testimonial-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?testimonial-category=$matches[1]&feed=$matches[2]\";s:56:\"testimonial-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?testimonial-category=$matches[1]&feed=$matches[2]\";s:37:\"testimonial-category/([^/]+)/embed/?$\";s:53:\"index.php?testimonial-category=$matches[1]&embed=true\";s:49:\"testimonial-category/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?testimonial-category=$matches[1]&paged=$matches[2]\";s:31:\"testimonial-category/([^/]+)/?$\";s:42:\"index.php?testimonial-category=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=1169&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `nqcpo_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `nqcpo_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `nqcpo_options` VALUES("33", "active_plugins", "a:9:{i:0;s:35:\"redux-framework/redux-framework.php\";i:1;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:2;s:33:\"classic-editor/classic-editor.php\";i:3;s:35:\"classic-widgets/classic-widgets.php\";i:4;s:36:\"contact-form-7/wp-contact-form-7.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:23:\"elementor/elementor.php\";i:7;s:19:\"ingeniofy/index.php\";i:8;s:23:\"loco-translate/loco.php\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `nqcpo_options` VALUES("35", "ping_sites", "https://rpc.pingomatic.com/", "yes");
INSERT INTO `nqcpo_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `nqcpo_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `nqcpo_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("39", "recently_edited", "a:5:{i:0;s:93:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/themes/kriate/functions.php\";i:2;s:103:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/slider-1756999364/ads-txt.php\";i:3;s:89:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/themes/kriate/style.css\";i:4;s:115:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/wordpress-importer/wordpress-importer.php\";i:5;s:117:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/themes/kriate/assets/js/theia-sticky-sidebar.min.js\";}", "no");
INSERT INTO `nqcpo_options` VALUES("40", "template", "kriate", "yes");
INSERT INTO `nqcpo_options` VALUES("41", "stylesheet", "kriate", "yes");
INSERT INTO `nqcpo_options` VALUES("42", "comment_registration", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `nqcpo_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `nqcpo_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `nqcpo_options` VALUES("46", "db_version", "60717", "yes");
INSERT INTO `nqcpo_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `nqcpo_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `nqcpo_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `nqcpo_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `nqcpo_options` VALUES("53", "show_avatars", "", "yes");
INSERT INTO `nqcpo_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `nqcpo_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `nqcpo_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `nqcpo_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `nqcpo_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `nqcpo_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `nqcpo_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `nqcpo_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `nqcpo_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `nqcpo_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `nqcpo_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `nqcpo_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `nqcpo_options` VALUES("67", "close_comments_for_old_posts", "", "yes");
INSERT INTO `nqcpo_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `nqcpo_options` VALUES("69", "thread_comments", "", "yes");
INSERT INTO `nqcpo_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `nqcpo_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `nqcpo_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `nqcpo_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `nqcpo_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `nqcpo_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("77", "widget_text", "a:4:{i:1;a:0:{}i:2;a:4:{s:5:\"title\";s:23:\"İletişim Bilgilerimiz\";s:4:\"text\";s:275:\"<span style=\"color: #ffffff;\"><strong>Adres:</strong> Eserte Mah. 312. Sok. 16/2 Keçiören/ANKARA</span>\r\n\r\n<span style=\"color: #ffffff;\"><strong>Telefon:</strong> 0541 560 89 18</span>\r\n\r\n<span style=\"color: #ffffff;\"><strong>E-Posta: </strong>info@ballielektrik.com</span>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:3;a:4:{s:5:\"title\";s:13:\"Hizmetlerimiz\";s:4:\"text\";s:208:\"<ul>\r\n 	<li>Kamera Kurulum</li>\r\n 	<li>Telefon Ankastre</li>\r\n 	<li>Elektrik Pano Montaj</li>\r\n 	<li>Elektrik Arıza Tespiti</li>\r\n 	<li>Uydu Anten Kurulumu</li>\r\n 	<li>İnşaat Elektrik Projeleri</li>\r\n</ul>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("79", "uninstall_plugins", "a:5:{s:23:\"loginizer/loginizer.php\";s:22:\"loginizer_deactivation\";s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";s:20:\"worker/functions.php\";s:13:\"mwp_uninstall\";s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";a:2:{i:0;s:15:\"AIO_WP_Security\";i:1;s:17:\"uninstall_handler\";}}", "no");
INSERT INTO `nqcpo_options` VALUES("80", "timezone_string", "Europe/Istanbul", "yes");
INSERT INTO `nqcpo_options` VALUES("81", "page_for_posts", "9", "yes");
INSERT INTO `nqcpo_options` VALUES("82", "page_on_front", "1169", "yes");
INSERT INTO `nqcpo_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `nqcpo_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `nqcpo_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("86", "site_icon", "12", "yes");
INSERT INTO `nqcpo_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `nqcpo_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `nqcpo_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `nqcpo_options` VALUES("90", "show_comments_cookies_opt_in", "", "yes");
INSERT INTO `nqcpo_options` VALUES("91", "admin_email_lifespan", "1772059357", "yes");
INSERT INTO `nqcpo_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `nqcpo_options` VALUES("93", "comment_previously_approved", "", "yes");
INSERT INTO `nqcpo_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `nqcpo_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `nqcpo_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `nqcpo_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `nqcpo_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `nqcpo_options` VALUES("99", "initial_db_version", "49752", "yes");
INSERT INTO `nqcpo_options` VALUES("100", "nqcpo_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:118:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:10:\"loco_admin\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}}", "yes");
INSERT INTO `nqcpo_options` VALUES("101", "fresh_site", "0", "off");
INSERT INTO `nqcpo_options` VALUES("102", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("103", "sidebars_widgets", "a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:14:\"footer-sidebar\";a:0:{}s:15:\"default-sidebar\";a:0:{}s:16:\"footer-1-space-1\";a:0:{}s:16:\"footer-1-space-2\";a:1:{i:0;s:10:\"nav_menu-1\";}s:16:\"footer-1-space-3\";a:1:{i:0;s:6:\"text-3\";}s:16:\"footer-1-space-4\";a:0:{}s:16:\"footer-1-space-5\";a:1:{i:0;s:6:\"text-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `nqcpo_options` VALUES("104", "cron", "a:25:{i:1771844510;a:1:{s:26:\"aios_15_minutes_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"aios-every-15-minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1771845598;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1771846576;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1771846581;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1771847210;a:1:{s:24:\"aiowps_hourly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1771847537;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1771857181;a:1:{s:10:\"_cron_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771864333;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1771881591;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771883327;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771887133;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1771887152;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771891200;a:1:{s:17:\"daily_remove_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771891859;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771896571;a:1:{s:22:\"mwp_update_public_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771901040;a:1:{s:25:\"litespeed_task_guest_sync\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771929381;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771930010;a:2:{s:23:\"aiowps_daily_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:23:\"aiowps_clean_old_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1772022313;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1772405533;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1772448410;a:1:{s:24:\"aiowps_weekly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1772449200;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1772456400;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1772731678;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `nqcpo_options` VALUES("105", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("106", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("107", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("108", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("109", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("110", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("111", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("112", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("113", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("114", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("115", "widget_nav_menu", "a:2:{i:1;a:2:{s:5:\"title\";s:13:\"Hızlı Menü\";s:8:\"nav_menu\";i:59;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("116", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("118", "recovery_keys", "a:1:{s:22:\"yKPoIeoq27VY54zW2WTFG3\";a:2:{s:10:\"hashed_key\";s:49:\"$generic$ub48qGlKQXfCOGAAhYL5PZ_cAsQoKoK-PMpKPVSq\";s:10:\"created_at\";i:1771802915;}}", "off");
INSERT INTO `nqcpo_options` VALUES("119", "theme_mods_twentytwentyone", "a:3:{s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:2;s:6:\"footer\";i:3;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1628457018;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "no");
INSERT INTO `nqcpo_options` VALUES("120", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `nqcpo_options` VALUES("126", "loginizer_2fa_whitelist", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("127", "loginizer_ins_time", "1627771937", "yes");
INSERT INTO `nqcpo_options` VALUES("128", "loginizer_promo_time", "1627771937", "yes");
INSERT INTO `nqcpo_options` VALUES("133", "WPLANG", "tr_TR", "yes");
INSERT INTO `nqcpo_options` VALUES("165", "new_admin_email", "info@ballielektrik.com", "yes");
INSERT INTO `nqcpo_options` VALUES("172", "finished_updating_comment_type", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("177", "recently_activated", "a:2:{s:23:\"elementor/elementor.php\";i:1771805410;s:27:\"site-mailer/site-mailer.php\";i:1771804508;}", "off");
INSERT INTO `nqcpo_options` VALUES("181", "widget_recent-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("182", "widget_recent-comments", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("183", "nav_menu_options", "a:1:{s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `nqcpo_options` VALUES("191", "litespeed.cloud._summary", "{\"curr_request.wp\\/ver\":0,\"last_request.wp\\/ver\":1628043606,\"news.utime\":1771801245,\"curr_request.wp\\/news\":0,\"last_request.wp\\/news\":1628457580,\"curr_request.ver\":0,\"last_request.ver\":1714108430,\"curr_request.news\":0,\"last_request.news\":1771801245,\"ips_ts\":1771803143,\"ips_ts_runner\":1771803143,\"ips\":[\"102.221.36.98\",\"103.106.229.82\",\"103.106.229.94\",\"103.146.63.42\",\"103.152.118.219\",\"103.152.118.72\",\"103.164.203.163\",\"103.167.151.84\",\"103.72.163.222\",\"103.75.117.169\",\"104.244.77.37\",\"108.61.158.223\",\"108.61.200.94\",\"109.248.43.195\",\"135.125.104.145\",\"136.243.106.228\",\"139.84.230.39\",\"141.164.38.65\",\"141.227.158.131\",\"144.202.90.7\",\"146.88.239.197\",\"147.78.0.165\",\"147.78.3.161\",\"149.28.136.245\",\"149.28.47.113\",\"149.28.85.239\",\"15.204.106.41\",\"15.204.231.24\",\"15.235.180.91\",\"15.235.181.227\",\"152.53.162.246\",\"152.53.167.143\",\"152.53.168.39\",\"152.53.169.106\",\"152.53.36.14\",\"152.53.38.14\",\"154.205.144.192\",\"155.138.221.81\",\"156.67.218.140\",\"158.51.123.249\",\"162.254.117.80\",\"162.254.118.29\",\"163.182.174.161\",\"163.47.21.168\",\"164.52.202.100\",\"167.71.185.204\",\"167.88.61.211\",\"170.249.218.98\",\"173.234.26.74\",\"176.9.114.118\",\"178.17.171.177\",\"178.22.124.251\",\"178.255.220.12\",\"18.192.146.200\",\"185.116.60.231\",\"185.116.60.232\",\"185.126.237.51\",\"185.212.169.91\",\"185.228.26.40\",\"185.231.233.130\",\"185.53.57.40\",\"185.53.57.89\",\"188.172.228.182\",\"188.172.229.113\",\"188.64.184.71\",\"190.92.176.5\",\"191.96.101.140\",\"192.248.156.201\",\"192.248.191.135\",\"192.99.38.117\",\"193.203.191.189\",\"194.36.144.221\",\"195.137.220.243\",\"195.231.17.141\",\"199.247.28.91\",\"199.59.247.242\",\"201.182.97.70\",\"209.124.84.191\",\"209.208.26.218\",\"211.23.143.87\",\"213.159.1.75\",\"213.183.48.170\",\"213.184.85.245\",\"216.128.179.195\",\"216.238.104.48\",\"216.238.71.13\",\"23.160.56.125\",\"23.95.72.16\",\"31.131.4.244\",\"31.22.115.186\",\"31.40.212.152\",\"37.120.163.165\",\"38.114.121.40\",\"38.54.30.228\",\"38.54.79.187\",\"38.60.253.237\",\"40.160.225.31\",\"40.160.241.195\",\"41.185.29.210\",\"41.223.52.170\",\"45.124.65.86\",\"45.248.77.61\",\"45.32.123.201\",\"45.32.183.112\",\"45.32.203.144\",\"45.32.67.144\",\"45.32.77.223\",\"45.63.67.181\",\"45.76.252.131\",\"45.77.148.74\",\"45.77.165.216\",\"45.77.51.171\",\"46.250.220.133\",\"49.12.102.29\",\"5.134.119.103\",\"51.158.202.109\",\"51.161.196.212\",\"51.68.143.214\",\"51.81.33.156\",\"51.89.11.45\",\"54.36.103.97\",\"57.129.146.219\",\"57.131.30.109\",\"61.219.247.87\",\"61.219.247.90\",\"64.176.165.8\",\"64.176.4.251\",\"64.227.16.93\",\"65.108.104.232\",\"65.109.39.175\",\"65.20.76.133\",\"65.21.81.51\",\"66.42.124.101\",\"66.42.75.121\",\"67.219.99.102\",\"69.50.95.250\",\"70.34.206.56\",\"74.91.25.147\",\"79.172.239.249\",\"81.31.156.245\",\"81.31.156.246\",\"83.138.12.246\",\"86.105.14.231\",\"86.105.14.232\",\"89.147.110.130\",\"89.58.38.4\",\"91.148.135.53\",\"91.201.67.121\",\"91.228.7.67\",\"92.118.205.75\",\"94.75.232.90\",\"95.179.145.87\",\"95.179.245.162\",\"95.216.116.209\"],\"curr_request.ver_check\":0,\"last_request.ver_check\":1771801243,\"curr_request.d\\/dash\":0,\"mini_html\":{\"news_dash_guest\":\"\",\"ttl.news_dash_guest\":1771947132,\"promo_mini\":\"\",\"ttl.promo_mini\":1771889532},\"last_request.d\\/dash\":1771803132,\"pk_b64\":\"mGvR4rd3ORBgNtODRE2fMX6Z\\/zFyNtNcXmRDoulT9I0=\",\"sk_b64\":\"0KoTadmyqMfHM3FHmyyqQ2SeFycYTrlUgXfKw+VmQTGYa9Hit3c5EGA204NETZ8xfpn\\/MXI201xeZEOi6VP0jQ==\",\"curr_request.tool\\/wp_rest_echo\":0,\"last_request.tool\\/wp_rest_echo\":1771803138}", "yes");
INSERT INTO `nqcpo_options` VALUES("193", "litespeed.conf.hash", "6KUCM8wmzVZpim3VeywxAUl0kY98B0Oi", "yes");
INSERT INTO `nqcpo_options` VALUES("194", "litespeed.conf.auto_upgrade", "", "yes");
INSERT INTO `nqcpo_options` VALUES("195", "litespeed.conf.api_key", "", "yes");
INSERT INTO `nqcpo_options` VALUES("196", "litespeed.conf.server_ip", "", "yes");
INSERT INTO `nqcpo_options` VALUES("197", "litespeed.conf.news", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("198", "litespeed.conf.cache", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("199", "litespeed.conf.cache-priv", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("200", "litespeed.conf.cache-commenter", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("201", "litespeed.conf.cache-rest", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("202", "litespeed.conf.cache-page_login", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("203", "litespeed.conf.cache-favicon", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("204", "litespeed.conf.cache-resources", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("205", "litespeed.conf.cache-mobile", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("206", "litespeed.conf.cache-mobile_rules", "a:7:{i:0;s:6:\"Mobile\";i:1;s:7:\"Android\";i:2;s:5:\"Silk/\";i:3;s:6:\"Kindle\";i:4;s:10:\"BlackBerry\";i:5;s:10:\"Opera Mini\";i:6;s:10:\"Opera Mobi\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("207", "litespeed.conf.cache-browser", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("208", "litespeed.conf.cache-exc_useragents", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("209", "litespeed.conf.cache-exc_cookies", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("210", "litespeed.conf.cache-exc_qs", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("211", "litespeed.conf.cache-exc_cat", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("212", "litespeed.conf.cache-exc_tag", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("213", "litespeed.conf.cache-force_uri", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("214", "litespeed.conf.cache-force_pub_uri", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("215", "litespeed.conf.cache-priv_uri", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("216", "litespeed.conf.cache-exc", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("217", "litespeed.conf.cache-exc_roles", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("218", "litespeed.conf.cache-drop_qs", "a:4:{i:0;s:6:\"fbclid\";i:1;s:5:\"gclid\";i:2;s:4:\"utm*\";i:3;s:3:\"_ga\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("219", "litespeed.conf.cache-ttl_pub", "604800", "yes");
INSERT INTO `nqcpo_options` VALUES("220", "litespeed.conf.cache-ttl_priv", "1800", "yes");
INSERT INTO `nqcpo_options` VALUES("221", "litespeed.conf.cache-ttl_frontpage", "604800", "yes");
INSERT INTO `nqcpo_options` VALUES("222", "litespeed.conf.cache-ttl_feed", "604800", "yes");
INSERT INTO `nqcpo_options` VALUES("223", "litespeed.conf.cache-ttl_rest", "604800", "yes");
INSERT INTO `nqcpo_options` VALUES("224", "litespeed.conf.cache-ttl_browser", "31557600", "yes");
INSERT INTO `nqcpo_options` VALUES("225", "litespeed.conf.cache-ttl_status", "a:3:{i:0;s:8:\"403 3600\";i:1;s:8:\"404 3600\";i:2;s:8:\"500 3600\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("226", "litespeed.conf.cache-login_cookie", "", "yes");
INSERT INTO `nqcpo_options` VALUES("227", "litespeed.conf.cache-vary_group", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("228", "litespeed.conf.purge-upgrade", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("229", "litespeed.conf.purge-stale", "", "yes");
INSERT INTO `nqcpo_options` VALUES("230", "litespeed.conf.purge-post_all", "", "yes");
INSERT INTO `nqcpo_options` VALUES("231", "litespeed.conf.purge-post_f", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("232", "litespeed.conf.purge-post_h", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("233", "litespeed.conf.purge-post_p", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("234", "litespeed.conf.purge-post_pwrp", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("235", "litespeed.conf.purge-post_a", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("236", "litespeed.conf.purge-post_y", "", "yes");
INSERT INTO `nqcpo_options` VALUES("237", "litespeed.conf.purge-post_m", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("238", "litespeed.conf.purge-post_d", "", "yes");
INSERT INTO `nqcpo_options` VALUES("239", "litespeed.conf.purge-post_t", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("240", "litespeed.conf.purge-post_pt", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("241", "litespeed.conf.purge-timed_urls", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("242", "litespeed.conf.purge-timed_urls_time", "", "yes");
INSERT INTO `nqcpo_options` VALUES("243", "litespeed.conf.purge-hook_all", "a:10:{i:0;s:12:\"switch_theme\";i:1;s:18:\"wp_create_nav_menu\";i:2;s:18:\"wp_update_nav_menu\";i:3;s:18:\"wp_delete_nav_menu\";i:4;s:11:\"create_term\";i:5;s:10:\"edit_terms\";i:6;s:11:\"delete_term\";i:7;s:8:\"add_link\";i:8;s:9:\"edit_link\";i:9;s:11:\"delete_link\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("244", "litespeed.conf.esi", "", "yes");
INSERT INTO `nqcpo_options` VALUES("245", "litespeed.conf.esi-cache_admbar", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("246", "litespeed.conf.esi-cache_commform", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("247", "litespeed.conf.esi-nonce", "a:2:{i:0;s:11:\"stats_nonce\";i:1;s:15:\"subscribe_nonce\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("248", "litespeed.conf.util-instant_click", "", "yes");
INSERT INTO `nqcpo_options` VALUES("249", "litespeed.conf.util-no_https_vary", "", "yes");
INSERT INTO `nqcpo_options` VALUES("250", "litespeed.conf.debug-disable_all", "", "yes");
INSERT INTO `nqcpo_options` VALUES("251", "litespeed.conf.debug", "", "yes");
INSERT INTO `nqcpo_options` VALUES("252", "litespeed.conf.debug-ips", "a:1:{i:0;s:9:\"127.0.0.1\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("253", "litespeed.conf.debug-level", "", "yes");
INSERT INTO `nqcpo_options` VALUES("254", "litespeed.conf.debug-filesize", "3", "yes");
INSERT INTO `nqcpo_options` VALUES("255", "litespeed.conf.debug-cookie", "", "yes");
INSERT INTO `nqcpo_options` VALUES("256", "litespeed.conf.debug-collaps_qs", "", "yes");
INSERT INTO `nqcpo_options` VALUES("257", "litespeed.conf.debug-inc", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("258", "litespeed.conf.debug-exc", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("259", "litespeed.conf.db_optm-revisions_max", "0", "yes");
INSERT INTO `nqcpo_options` VALUES("260", "litespeed.conf.db_optm-revisions_age", "0", "yes");
INSERT INTO `nqcpo_options` VALUES("261", "litespeed.conf.optm-css_min", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("262", "litespeed.conf.optm-css_comb", "", "yes");
INSERT INTO `nqcpo_options` VALUES("263", "litespeed.conf.optm-css_comb_ext_inl", "", "yes");
INSERT INTO `nqcpo_options` VALUES("264", "litespeed.conf.optm-ucss", "", "yes");
INSERT INTO `nqcpo_options` VALUES("265", "litespeed.conf.optm-ucss_async", "", "yes");
INSERT INTO `nqcpo_options` VALUES("266", "litespeed.conf.optm-css_http2", "", "yes");
INSERT INTO `nqcpo_options` VALUES("267", "litespeed.conf.optm-css_exc", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("268", "litespeed.conf.optm-js_min", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("269", "litespeed.conf.optm-js_comb", "", "yes");
INSERT INTO `nqcpo_options` VALUES("270", "litespeed.conf.optm-js_comb_ext_inl", "", "yes");
INSERT INTO `nqcpo_options` VALUES("271", "litespeed.conf.optm-js_http2", "", "yes");
INSERT INTO `nqcpo_options` VALUES("272", "litespeed.conf.optm-js_exc", "a:2:{i:0;s:9:\"jquery.js\";i:1;s:13:\"jquery.min.js\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("273", "litespeed.conf.optm-ttl", "604800", "yes");
INSERT INTO `nqcpo_options` VALUES("274", "litespeed.conf.optm-html_min", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("275", "litespeed.conf.optm-qs_rm", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("276", "litespeed.conf.optm-ggfonts_rm", "", "yes");
INSERT INTO `nqcpo_options` VALUES("277", "litespeed.conf.optm-css_async", "", "yes");
INSERT INTO `nqcpo_options` VALUES("278", "litespeed.conf.optm-ccss_gen", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("279", "litespeed.conf.optm-ccss_async", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("280", "litespeed.conf.optm-css_async_inline", "", "yes");
INSERT INTO `nqcpo_options` VALUES("281", "litespeed.conf.optm-css_font_display", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("282", "litespeed.conf.optm-js_defer", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("283", "litespeed.conf.optm-js_inline_defer", "", "yes");
INSERT INTO `nqcpo_options` VALUES("284", "litespeed.conf.optm-emoji_rm", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("285", "litespeed.conf.optm-noscript_rm", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("286", "litespeed.conf.optm-ggfonts_async", "", "yes");
INSERT INTO `nqcpo_options` VALUES("287", "litespeed.conf.optm-exc_roles", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("288", "litespeed.conf.optm-ccss_con", "", "yes");
INSERT INTO `nqcpo_options` VALUES("289", "litespeed.conf.optm-js_defer_exc", "a:2:{i:0;s:9:\"jquery.js\";i:1;s:13:\"jquery.min.js\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("290", "litespeed.conf.optm-dns_prefetch", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("291", "litespeed.conf.optm-dns_prefetch_ctrl", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("292", "litespeed.conf.optm-exc", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("293", "litespeed.conf.optm-ccss_sep_posttype", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("294", "litespeed.conf.optm-ccss_sep_uri", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("295", "litespeed.conf.object", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("296", "litespeed.conf.object-kind", "", "yes");
INSERT INTO `nqcpo_options` VALUES("297", "litespeed.conf.object-host", "::1", "yes");
INSERT INTO `nqcpo_options` VALUES("298", "litespeed.conf.object-port", "11211", "yes");
INSERT INTO `nqcpo_options` VALUES("299", "litespeed.conf.object-life", "360", "yes");
INSERT INTO `nqcpo_options` VALUES("300", "litespeed.conf.object-persistent", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("301", "litespeed.conf.object-admin", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("302", "litespeed.conf.object-transients", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("303", "litespeed.conf.object-db_id", "0", "yes");
INSERT INTO `nqcpo_options` VALUES("304", "litespeed.conf.object-user", "", "yes");
INSERT INTO `nqcpo_options` VALUES("305", "litespeed.conf.object-pswd", "", "yes");
INSERT INTO `nqcpo_options` VALUES("306", "litespeed.conf.object-global_groups", "a:12:{i:0;s:5:\"users\";i:1;s:10:\"userlogins\";i:2;s:8:\"usermeta\";i:3;s:9:\"user_meta\";i:4;s:14:\"site-transient\";i:5;s:12:\"site-options\";i:6;s:11:\"site-lookup\";i:7;s:11:\"blog-lookup\";i:8;s:12:\"blog-details\";i:9;s:3:\"rss\";i:10;s:12:\"global-posts\";i:11;s:13:\"blog-id-cache\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("307", "litespeed.conf.object-non_persistent_groups", "a:4:{i:0;s:7:\"comment\";i:1;s:6:\"counts\";i:2;s:7:\"plugins\";i:3;s:13:\"wc_session_id\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("308", "litespeed.conf.discuss-avatar_cache", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("309", "litespeed.conf.discuss-avatar_cron", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("310", "litespeed.conf.discuss-avatar_cache_ttl", "604800", "yes");
INSERT INTO `nqcpo_options` VALUES("311", "litespeed.conf.optm-localize", "", "yes");
INSERT INTO `nqcpo_options` VALUES("312", "litespeed.conf.optm-localize_domains", "a:7:{i:0;s:23:\"### Popular scripts ###\";i:1;s:39:\"https://platform.twitter.com/widgets.js\";i:2;s:39:\"https://www.google.com/recaptcha/api.js\";i:3;s:45:\"https://www.google-analytics.com/analytics.js\";i:4;s:39:\"https://www.googletagmanager.com/gtm.js\";i:5;s:47:\"https://www.googletagservices.com/tag/js/gpt.js\";i:6;s:46:\"https://connect.facebook.net/en_US/fbevents.js\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("313", "litespeed.conf.media-lazy", "", "yes");
INSERT INTO `nqcpo_options` VALUES("314", "litespeed.conf.media-lazy_placeholder", "", "yes");
INSERT INTO `nqcpo_options` VALUES("315", "litespeed.conf.media-placeholder_resp", "", "yes");
INSERT INTO `nqcpo_options` VALUES("316", "litespeed.conf.media-placeholder_resp_color", "#cfd4db", "yes");
INSERT INTO `nqcpo_options` VALUES("317", "litespeed.conf.media-placeholder_resp_svg", "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"{width}\" height=\"{height}\" viewBox=\"0 0 {width} {height}\"><rect width=\"100%\" height=\"100%\" fill=\"{color}\"/></svg>", "yes");
INSERT INTO `nqcpo_options` VALUES("318", "litespeed.conf.media-lqip", "", "yes");
INSERT INTO `nqcpo_options` VALUES("319", "litespeed.conf.media-lqip_qual", "4", "yes");
INSERT INTO `nqcpo_options` VALUES("320", "litespeed.conf.media-lqip_min_w", "150", "yes");
INSERT INTO `nqcpo_options` VALUES("321", "litespeed.conf.media-lqip_min_h", "150", "yes");
INSERT INTO `nqcpo_options` VALUES("322", "litespeed.conf.media-placeholder_resp_async", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("323", "litespeed.conf.media-iframe_lazy", "", "yes");
INSERT INTO `nqcpo_options` VALUES("324", "litespeed.conf.media-lazyjs_inline", "", "yes");
INSERT INTO `nqcpo_options` VALUES("325", "litespeed.conf.media-lazy_exc", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("326", "litespeed.conf.media-lazy_cls_exc", "a:1:{i:0;s:15:\"wmu-preview-img\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("327", "litespeed.conf.media-lazy_parent_cls_exc", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("328", "litespeed.conf.media-iframe_lazy_cls_exc", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("329", "litespeed.conf.media-iframe_lazy_parent_cls_exc", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("330", "litespeed.conf.media-lazy_uri_exc", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("331", "litespeed.conf.media-lqip_exc", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("332", "litespeed.conf.img_optm-auto", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("333", "litespeed.conf.img_optm-cron", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("334", "litespeed.conf.img_optm-ori", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("335", "litespeed.conf.img_optm-rm_bkup", "", "yes");
INSERT INTO `nqcpo_options` VALUES("336", "litespeed.conf.img_optm-webp", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("337", "litespeed.conf.img_optm-lossless", "", "yes");
INSERT INTO `nqcpo_options` VALUES("338", "litespeed.conf.img_optm-exif", "", "yes");
INSERT INTO `nqcpo_options` VALUES("339", "litespeed.conf.img_optm-webp_replace", "", "yes");
INSERT INTO `nqcpo_options` VALUES("340", "litespeed.conf.img_optm-webp_attr", "a:7:{i:0;s:7:\"img.src\";i:1;s:14:\"div.data-thumb\";i:2;s:12:\"img.data-src\";i:3;s:20:\"div.data-large_image\";i:4;s:19:\"img.retina_logo_url\";i:5;s:23:\"div.data-parallax-image\";i:6;s:12:\"video.poster\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("341", "litespeed.conf.img_optm-webp_replace_srcset", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("342", "litespeed.conf.img_optm-jpg_quality", "82", "yes");
INSERT INTO `nqcpo_options` VALUES("343", "litespeed.conf.crawler", "", "yes");
INSERT INTO `nqcpo_options` VALUES("344", "litespeed.conf.crawler-usleep", "500", "yes");
INSERT INTO `nqcpo_options` VALUES("345", "litespeed.conf.crawler-run_duration", "400", "yes");
INSERT INTO `nqcpo_options` VALUES("346", "litespeed.conf.crawler-run_interval", "600", "yes");
INSERT INTO `nqcpo_options` VALUES("347", "litespeed.conf.crawler-crawl_interval", "302400", "yes");
INSERT INTO `nqcpo_options` VALUES("348", "litespeed.conf.crawler-threads", "3", "yes");
INSERT INTO `nqcpo_options` VALUES("349", "litespeed.conf.crawler-timeout", "30", "yes");
INSERT INTO `nqcpo_options` VALUES("350", "litespeed.conf.crawler-load_limit", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("351", "litespeed.conf.crawler-sitemap", "", "yes");
INSERT INTO `nqcpo_options` VALUES("352", "litespeed.conf.crawler-drop_domain", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("353", "litespeed.conf.crawler-map_timeout", "120", "yes");
INSERT INTO `nqcpo_options` VALUES("354", "litespeed.conf.crawler-roles", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("355", "litespeed.conf.crawler-cookies", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("356", "litespeed.conf.misc-htaccess_front", "", "yes");
INSERT INTO `nqcpo_options` VALUES("357", "litespeed.conf.misc-htaccess_back", "", "yes");
INSERT INTO `nqcpo_options` VALUES("358", "litespeed.conf.misc-heartbeat_front", "", "yes");
INSERT INTO `nqcpo_options` VALUES("359", "litespeed.conf.misc-heartbeat_front_ttl", "60", "yes");
INSERT INTO `nqcpo_options` VALUES("360", "litespeed.conf.misc-heartbeat_back", "", "yes");
INSERT INTO `nqcpo_options` VALUES("361", "litespeed.conf.misc-heartbeat_back_ttl", "60", "yes");
INSERT INTO `nqcpo_options` VALUES("362", "litespeed.conf.misc-heartbeat_editor", "", "yes");
INSERT INTO `nqcpo_options` VALUES("363", "litespeed.conf.misc-heartbeat_editor_ttl", "15", "yes");
INSERT INTO `nqcpo_options` VALUES("364", "litespeed.conf.cdn", "", "yes");
INSERT INTO `nqcpo_options` VALUES("365", "litespeed.conf.cdn-ori", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("366", "litespeed.conf.cdn-ori_dir", "a:2:{i:0;s:10:\"wp-content\";i:1;s:11:\"wp-includes\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("367", "litespeed.conf.cdn-exc", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("368", "litespeed.conf.cdn-quic", "", "yes");
INSERT INTO `nqcpo_options` VALUES("369", "litespeed.conf.cdn-cloudflare", "", "yes");
INSERT INTO `nqcpo_options` VALUES("370", "litespeed.conf.cdn-cloudflare_email", "", "yes");
INSERT INTO `nqcpo_options` VALUES("371", "litespeed.conf.cdn-cloudflare_key", "", "yes");
INSERT INTO `nqcpo_options` VALUES("372", "litespeed.conf.cdn-cloudflare_name", "", "yes");
INSERT INTO `nqcpo_options` VALUES("373", "litespeed.conf.cdn-cloudflare_zone", "", "yes");
INSERT INTO `nqcpo_options` VALUES("374", "litespeed.conf.cdn-mapping", "a:1:{i:0;a:5:{s:3:\"url\";b:0;s:7:\"inc_img\";s:1:\"1\";s:7:\"inc_css\";s:1:\"1\";s:6:\"inc_js\";s:1:\"1\";s:8:\"filetype\";a:17:{i:0;s:4:\".aac\";i:1;s:4:\".css\";i:2;s:4:\".eot\";i:3;s:4:\".gif\";i:4;s:5:\".jpeg\";i:5;s:3:\".js\";i:6;s:4:\".jpg\";i:7;s:5:\".less\";i:8;s:4:\".mp3\";i:9;s:4:\".mp4\";i:10;s:4:\".ogg\";i:11;s:4:\".otf\";i:12;s:4:\".pdf\";i:13;s:4:\".png\";i:14;s:4:\".svg\";i:15;s:4:\".ttf\";i:16;s:5:\".woff\";}}}", "yes");
INSERT INTO `nqcpo_options` VALUES("375", "litespeed.conf.cdn-attr", "a:5:{i:0;s:4:\".src\";i:1;s:9:\".data-src\";i:2;s:5:\".href\";i:3;s:7:\".poster\";i:4;s:13:\"source.srcset\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("425", "litespeed.gui._summary", "{\"new_version\":1628126872,\"score\":1628472472,\"new_version.last_check\":1734380013,\"new_version.v\":\"6.5.3\"}", "yes");
INSERT INTO `nqcpo_options` VALUES("444", "litespeed.optimize.timestamp_purge_css", "1771805524", "yes");
INSERT INTO `nqcpo_options` VALUES("449", "mwp_service_key", "1eed86d1-0047-4a54-8959-d088bdc5887a", "yes");
INSERT INTO `nqcpo_options` VALUES("452", "mwp_openssl_parameters", "a:2:{s:4:\"time\";i:1757337845;s:7:\"working\";b:1;}", "on");
INSERT INTO `nqcpo_options` VALUES("453", "mwp_incremental_update_active", "", "yes");
INSERT INTO `nqcpo_options` VALUES("460", "worker_migration_version", "2", "yes");
INSERT INTO `nqcpo_options` VALUES("465", "mwp_public_keys_refresh_time", "1757382363", "on");
INSERT INTO `nqcpo_options` VALUES("466", "mwp_public_keys", "a:13:{i:0;a:6:{s:2:\"id\";s:19:\"managewp_1754013902\";s:7:\"service\";s:8:\"managewp\";s:9:\"validFrom\";s:19:\"2025-08-16 01:26:15\";s:7:\"validTo\";s:19:\"2025-09-17 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEApyxjIsF0PlgkdezCywBD\nejVEijUvOoAg3jVo7/+Bxyh0NsIOqOP8bz0zFTsIC1kfhwm/kKbzlpdOzhWK/Gcf\n3A0GjpbNng1v/2KKFdSdud6NspGyLPm2mDN5+93o/5f4+Mkm4fdf6rsOxvKPMhn6\nd9KPSd0crgRRGr92dmy0DVGipOFpklnh1vNQS61DSzJP6LotmzP88p/g5KrVYOFK\nsp7hP6E7yTNFuYr15uS1ZQRuhxMqzQV9C+/AqtR5XuBdJCu9aydkeZmgKtCEuC66\nu9vNkUFNz9F4RwOtQxNzgfSUfbfM8Kyis2tlcBhYg3uHkXX2GaiVgDfH6rk/UQ6d\noQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:0;}i:1;a:6:{s:2:\"id\";s:19:\"managewp_1756605902\";s:7:\"service\";s:8:\"managewp\";s:9:\"validFrom\";s:19:\"2025-09-15 01:26:15\";s:7:\"validTo\";s:19:\"2025-10-17 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAw/q+/aD7XItQgDxCNSll\npOmmOI7M9I0GFWYNucLohfd3p6pANg5bc2Q+z1dPTvnD6VFV+IkbVoLLFkQWD+eG\nrl4JiL/5IFMgQDPeGo6RUvQGslsBCA7WplMZYSWbiBY0pSGm9bEOOVcuV3l8tvJr\nvRlvpGYh7evOkbkQw6p7I3pAo011YXSMaM+eV9V6J1sPuhc4bASEq86u2K/M2fY1\nDz92N9QwmRlFr7uApgqpUI59nJPOIj3OdcIlVohle3pkCpGQd9N4AJFnDo6eaFDF\nw/cpls61Jq8KSiqfk/35zurOUmztTiyqqDQlTcnSvZGehtx2qS/yPNSP0wHsnXyh\nFwIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:0;}i:2;a:6:{s:2:\"id\";s:23:\"managewp_dev_1754013902\";s:7:\"service\";s:12:\"managewp_dev\";s:9:\"validFrom\";s:19:\"2025-08-16 01:26:15\";s:7:\"validTo\";s:19:\"2025-09-17 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwwSffnvKW9r+T6Ur1qjt\nrnh7O5sdZlisYKEzkX0T4h1unxtpCiONQ3Mz9W5+YkieOp3TQaXP1NKFFYv5pdlV\nECaVTyfghin8ChtBO3YUDPuMMtZyJZlPzYXmPwUhrOe2qxfcdRXJuIg4n7D7+pjt\nxOgogVriNWfKkgdRNMrYQxSmfPj+gBW39xp9RbuqRB0Df4dY0mxB4H3zoQ7G0sXj\nXkhZtnCZLU0Xc7ynFbhyAE5gQfdEXJ87savl1p3N3kZpvHRfmlvcQp6YwuHYFRlw\ncN0C+wLWkXziTkfxQcHccJHYkrWyHslV2OK2eiKZ5uu3ra6w8gjFl/nCghLTLmaA\n3QIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:0;}i:3;a:6:{s:2:\"id\";s:23:\"managewp_dev_1756605902\";s:7:\"service\";s:12:\"managewp_dev\";s:9:\"validFrom\";s:19:\"2025-09-15 01:26:15\";s:7:\"validTo\";s:19:\"2025-10-17 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEApzKEB/NdS2PcyQZ63eyx\n/NiVPNeZZTslJ/5E1NJ1xmPteQTXrL/s/5ni8wnp0irhieVt/qnnQJLUQSOyEhcK\n1d0qgW/s6AvqmnXQFS9RNyAx0YKl0vbUFZmh17SKJIDx19LWzr55fYqKNvHR/hkP\n6k75PPtXZc16BvTAbzL2WWQa3eOqBfycoTwiyq4ZbtlWIUPOPXxW77i8CJFDwRKW\n3tGW4i0Sgd5hUzRPYkNfA6Wku21fBn0XYKMo8kn/GJtATDcxzyGbEdR9HAEv+J43\n2WH2O4n1lVBwFWLCsBvOzgWqZhZN1yLdqgi6zSbTOXzKqeaVCZruAeRWkw8mxG8b\n3QIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:0;}i:4;a:6:{s:2:\"id\";s:16:\"mwp20_1754013902\";s:7:\"service\";s:5:\"mwp20\";s:9:\"validFrom\";s:19:\"2025-08-16 01:26:15\";s:7:\"validTo\";s:19:\"2025-09-17 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAycz0HF2BrXQLQ2gpXAkA\nKJ7XkINBwG/tVhBQVhgBJOQ2LC2fCdPi65I1W8I81P6GOtg+f4SsM3x4S5GtV5oo\nE0Ginmq0K82OUkE5x/gpHkIUtAky4FK7hWdeN/opZwuMG3qD7tpjx9Rnl+H/mOSf\naWluRTQ22WCaXSM+8IQ/YVobWITkpDFyA+EPgNPwhA32IMFjpQa7j39qzMZmnSX6\npMmDanAhmMF4wOnaMbgFfuuqjI+IjBBTUJNjxZkIBHa4HdqfgtAoQwkYPH+375dh\nqxoFX4pw2x5gZeEj22BC19UIVL69jihr3aoTGVzuTRmizKBhE+K4OJxlPtfjXQgX\n/wIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:5;a:6:{s:2:\"id\";s:16:\"mwp20_1756605902\";s:7:\"service\";s:5:\"mwp20\";s:9:\"validFrom\";s:19:\"2025-09-15 01:26:15\";s:7:\"validTo\";s:19:\"2025-10-17 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxtuL11mK1lx5hbIS+OaS\nHf0afpzAkYn6t8Up1tZtQAxjfTIbcBQbEzHUL/7UKtKF86+2lqJ1amBuTuznYxbH\ncVkfn+UAnBqW7UeE+5AIaZqHJxF3PggcANjvZYHItU2C3tgI68NVjYuFLBlIDBHa\nQn4980n9i3jKtpwqLG7vkqvYhKTG9ikoAAMk4YZPai2O8rEVGWSp1Uygt0EWNmyp\n5EtXXpD1NsFDOITQjldhGhiipbii9+WC33B+0TgrvOEqaok5ksCQVrqdJ40jBtKY\niue2SiCcRtMYNOzDW7t+kaOwswLBEi5O746eDKhS5mACvTMZhvQK65L4WDy+CkkZ\n4wIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:6;a:6:{s:2:\"id\";s:15:\"wpps_1753621502\";s:7:\"service\";s:4:\"wpps\";s:9:\"validFrom\";s:19:\"2025-08-11 13:05:01\";s:7:\"validTo\";s:19:\"2025-09-12 13:05:01\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAr6kvNq47bIAGxMVoC9Hh\nBhG30+nu2d2ym0ICS4IR0MRqIh79fdJab2XpMpvV/jutsWc62ZT0T1i4KhAwkQqP\nF80Rqw+/dQ+G1Poah1h0O9PBx9LraadxcxwHWW5swUM/lj/G5udsxSN3mOy4RHYA\ngAgP8DQOPpMQj3fClnMBnT3pUVOzIlSJiqe9IoeSAC1ULkhEXOvALZviqW73qImQ\nhXsmLT4GHkcDDqmp2P1SXahknHWsetSk51vkGhmbCMjjfelEB9wVN7ms/RuJLDCj\nP3/ZJKcZmU+099wklSc5cwgBrgpbPunq27yEy6BdR5fMD5q5pEFEIyIr/Gdl3w+e\ncQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:7;a:6:{s:2:\"id\";s:15:\"wpps_1756213502\";s:7:\"service\";s:4:\"wpps\";s:9:\"validFrom\";s:19:\"2025-09-10 13:05:01\";s:7:\"validTo\";s:19:\"2025-10-12 13:05:01\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzA8U7U2FihPLPfBVyS1d\n1Fc3sY/XW8JOeUHs4NNwp3BMPFnTJkYrxH7MplhvDE0tAV6ppSY4f5SEr36xTD7g\nHLfKTA1DioC7LPmOb+FanhVUh4ZtbsV/P+1w5iFNXkA8a2U7gzZZm8JUHXvz6bF5\nQ77x4rbj4WEea6r//lxctIuQkafKXMhk2yq+uSCO86QN3EoUQF0TKZRbOerjuivx\ncX0P9wc8Y8ZfwOajH7Ba4k60atTxTrIFeiDth7PYTKI/ATwM/e5APVoAVYx+25BP\nNQcrK5gxxul8CLgmiZ5ec9x9craZ5SYION7d7iatKSnhL+Hlbp7Cozl9YviEVaaE\nPQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:8;a:6:{s:2:\"id\";s:25:\"cookie_service_1754845502\";s:7:\"service\";s:14:\"cookie_service\";s:9:\"validFrom\";s:19:\"2025-08-25 16:27:25\";s:7:\"validTo\";s:19:\"2025-09-26 16:27:25\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA35BFdePa2iOgmP2ZrEY5\nIB14cpqlzTpBVBHBSn034LxHOWmTlPxhUH6GEHxVmzonf2N5gY3CiuB+s0DfK5Cj\nSD5Yo7wmEFWcGg/uB+Nl0L8jvXggfoofLCF/ybuzXDLgBi23l943zEK38+4sC7lF\n6a/xPM1K1NEGxLcEBo6K2F/slfBZJFxAcxO4ELBrDRLplIPyBnyrMN03tL2M80nH\n873UOp0pXOYG5Xbc/mtOPey60u2Z7eJ9Hg8fRU3rVzYbV61jarKkZ/kYkj8CbgRK\nS0IIysx0j5d902BEFNkil6pZWB+VffFgfVwAZb3xjKtMGFWz49ppCDpukLd92atf\n0QIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:9;a:6:{s:2:\"id\";s:15:\"mwp1_1753711501\";s:7:\"service\";s:4:\"mwp1\";s:9:\"validFrom\";s:19:\"2025-08-12 14:05:01\";s:7:\"validTo\";s:19:\"2025-09-13 14:05:01\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzhfV4ge4894ZjbnQob+u\nB33SyVyWZ39lbPdIWWD1GuctbARJiIOPgEULpUzJ16Vx5R9+0mONFuHlwoN7FxTV\nf/r6SjopDT3K60vyEioDx0Vi4HBPjUnu/86hpsPcywoESmznIPmDFwF3tJz/NbHv\nYrJpLK+yIbWw0OTHeODegWX+rG3D7W8iQeb4V5XSYMffnIPhgu6FBDBSRkJZXezi\ncClWsp9qNRNOSoY6DVhi6oolgKzVpxiU0Rhcfk9WxSpvmFyAnWoqRRbhPFZA+3Wg\nvNGB4s19JEQbH/oNV8BJdd5ECYtEhyL4SJNi+/3f1YlcYBzwZZgxAPAG3aw6NQ1W\nNQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:10;a:6:{s:2:\"id\";s:15:\"mwp1_1756303502\";s:7:\"service\";s:4:\"mwp1\";s:9:\"validFrom\";s:19:\"2025-09-11 14:05:01\";s:7:\"validTo\";s:19:\"2025-10-13 14:05:01\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAs8aeZm2fnP/n59d773hH\n1rXiu8LJbdIbc6vg/H9tGDuW/k9Vjo8yIrYOnH1QZlO+IRdbaR4Nh4lXg7kwKtba\nP39dnOpuKTc3/vaq62VrgkdtLZaL0zX5XZRyU6LEL6Ubm7ZQ2DnBPHd+QqLs4T9q\nfqc47ks0us20JNia8OHnKmJLxC3yi4GjR3G4LioRjG++0BrSEpyGOKIsc4tZQRSJ\n9hHdtKsBBRde8IRcAXAavOBhwwBrNGEy6RwwjhzYHUqfysC1iBo5H3XKGVG8n4id\nCJcwKYL3wQ7ctdbTlAqrXB8Quihaekfx+kZhrTRLcoOGzxUOgAQc1pHEs2/zANS3\nAQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:11;a:6:{s:2:\"id\";s:20:\"migration_1753967102\";s:7:\"service\";s:9:\"migration\";s:9:\"validFrom\";s:19:\"2025-08-15 13:05:02\";s:7:\"validTo\";s:19:\"2025-09-16 13:05:02\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAq7uaPn4TrPXmSLmD0TFt\n6IsXN/D2DeCW1ubvTJxUkQ+fqLTxl9O50tFz9AGOlC9pHTaX4Er54kWbp2SB/tLG\nvK1eSLxpklVhGrPgRipLqITGOOXFRKUptO8U6Sb/JRCB1BrBTnOi1gPYQUO17dmi\neeVWcxz4D8ilLXmSOhoOtnUugTpA+Q3Qwm1awfQIAdZkGpac5ebvSoS2I/hyKGof\n9Ci2NYogb/5RHUHbvpRjSsFaS2384E/q31kmbIQgliyqiuwMxmXGrEhEDZ2dpFSe\n2GZiLyeQQQTLw0jYRW9UzoTpZa27VW1ixsi0aNlTOZrzotBjZEgUHnsOoYIAMQij\neQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:12;a:6:{s:2:\"id\";s:20:\"migration_1756559102\";s:7:\"service\";s:9:\"migration\";s:9:\"validFrom\";s:19:\"2025-09-14 13:05:02\";s:7:\"validTo\";s:19:\"2025-10-16 13:05:02\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAz5UleOD/VHhk319mgDPj\nIV/BWs5gDSF2+ecpTC1VqUnWsuzq3p6fFYmr8KHNEpWWaM2k4NxS5QjrcNSE/t4w\n+eW19C+E6hhSTSjb7OqeW/UHNjuv3HuILbz9VnMO2frUS/0jYOyHk6PD2E33WuBK\nxKYdgEg0PQbW1E89l2MnPZEN4XYQh6NBZEeF1LTilahbQFsgF4+ZowFmJ69rmimT\nG3ymBQQeLFBTkNYHo1uhkl9TAKBUjWGJl0BGe8+lyPp4yEvlMBAbp1em9Aad9kVG\n7E7sryLPN1tHgJLxWf5ncdmpZJAZglY1CRiQ4wRsDa6HEx2QlcFDgLPzXZB8uMUw\njQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}}", "on");
INSERT INTO `nqcpo_options` VALUES("469", "mwp_communication_keys", "a:1:{i:8927504;a:2:{s:3:\"key\";s:36:\"2b29ec53-cde6-4513-936e-3ec172833316\";s:5:\"added\";i:1628040577;}}", "yes");
INSERT INTO `nqcpo_options` VALUES("470", "mwp_key_last_used_2b29ec53-cde6-4513-936e-3ec172833316", "1628040577", "yes");
INSERT INTO `nqcpo_options` VALUES("471", "mmb_stats_filter", "a:1:{s:7:\"plugins\";a:1:{s:7:\"cleanup\";a:1:{s:9:\"revisions\";a:1:{s:11:\"num_to_keep\";i:5;}}}}", "yes");
INSERT INTO `nqcpo_options` VALUES("472", "mwp_potential_key", "7358aa13-90cc-4835-a189-532abd09f874", "on");
INSERT INTO `nqcpo_options` VALUES("473", "mwp_potential_key_time", "1757337845", "on");
INSERT INTO `nqcpo_options` VALUES("474", "mwp_key_last_used_8927504", "1757247398", "on");
INSERT INTO `nqcpo_options` VALUES("475", "mwp_new_communication_established", "1", "on");
INSERT INTO `nqcpo_options` VALUES("485", "user_hit_count", "a:60:{s:10:\"2025-06-26\";i:79;s:10:\"2025-06-27\";i:186;s:10:\"2025-06-28\";i:228;s:10:\"2025-06-29\";i:82;s:10:\"2025-06-30\";i:82;s:10:\"2025-07-01\";i:341;s:10:\"2025-07-02\";i:105;s:10:\"2025-07-03\";i:47;s:10:\"2025-07-04\";i:45;s:10:\"2025-07-05\";i:887;s:10:\"2025-07-06\";i:54;s:10:\"2025-07-07\";i:36;s:10:\"2025-07-08\";i:88;s:10:\"2025-07-09\";i:41;s:10:\"2025-07-10\";i:260;s:10:\"2025-07-11\";i:128;s:10:\"2025-07-12\";i:54;s:10:\"2025-07-13\";i:39;s:10:\"2025-07-14\";i:57;s:10:\"2025-07-15\";i:69;s:10:\"2025-07-16\";i:66;s:10:\"2025-07-17\";i:153;s:10:\"2025-07-18\";i:248;s:10:\"2025-07-19\";i:460;s:10:\"2025-07-20\";i:270;s:10:\"2025-07-21\";i:884;s:10:\"2025-07-22\";i:711;s:10:\"2025-07-23\";i:737;s:10:\"2025-07-24\";i:404;s:10:\"2025-07-25\";i:99;s:10:\"2025-07-26\";i:87;s:10:\"2025-07-27\";i:165;s:10:\"2025-07-28\";i:78;s:10:\"2025-07-29\";i:207;s:10:\"2025-07-30\";i:333;s:10:\"2025-07-31\";i:56;s:10:\"2025-08-01\";i:134;s:10:\"2025-08-02\";i:204;s:10:\"2025-08-03\";i:268;s:10:\"2025-08-04\";i:228;s:10:\"2025-08-05\";i:228;s:10:\"2025-08-06\";i:1502;s:10:\"2025-08-07\";i:1623;s:10:\"2025-08-08\";i:933;s:10:\"2025-08-09\";i:548;s:10:\"2025-08-10\";i:840;s:10:\"2025-08-11\";i:560;s:10:\"2025-08-12\";i:454;s:10:\"2025-08-13\";i:774;s:10:\"2025-08-14\";i:808;s:10:\"2025-08-15\";i:917;s:10:\"2025-08-16\";i:533;s:10:\"2025-08-17\";i:1458;s:10:\"2025-08-18\";i:695;s:10:\"2025-08-19\";i:411;s:10:\"2025-08-20\";i:1168;s:10:\"2025-08-21\";i:1208;s:10:\"2025-08-22\";i:911;s:10:\"2025-08-23\";i:994;s:10:\"2025-08-24\";i:92;}", "on");
INSERT INTO `nqcpo_options` VALUES("910", "current_theme", "Kriate", "yes");
INSERT INTO `nqcpo_options` VALUES("911", "theme_mods_twentynineteen", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:6:\"footer\";i:3;s:6:\"menu-1\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1628457025;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "no");
INSERT INTO `nqcpo_options` VALUES("912", "theme_switched", "", "yes");
INSERT INTO `nqcpo_options` VALUES("915", "theme_mods_kriate", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:3:{s:11:\"header-menu\";i:59;s:11:\"topbar-menu\";i:59;s:11:\"footer-menu\";i:59;}}", "auto");
INSERT INTO `nqcpo_options` VALUES("932", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.1.5\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1696884381;s:7:\"version\";s:5:\"5.8.1\";s:11:\"count_valid\";i:2;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `nqcpo_options` VALUES("933", "elementor_active_kit", "32", "yes");
INSERT INTO `nqcpo_options` VALUES("936", "action_scheduler_hybrid_store_demarkation", "33", "yes");
INSERT INTO `nqcpo_options` VALUES("937", "schema-ActionScheduler_StoreSchema", "4.0.1628457588", "yes");
INSERT INTO `nqcpo_options` VALUES("938", "schema-ActionScheduler_LoggerSchema", "2.0.1628457588", "yes");
INSERT INTO `nqcpo_options` VALUES("941", "woocommerce_schema_version", "430", "yes");
INSERT INTO `nqcpo_options` VALUES("942", "woocommerce_store_address", "", "yes");
INSERT INTO `nqcpo_options` VALUES("943", "woocommerce_store_address_2", "", "yes");
INSERT INTO `nqcpo_options` VALUES("944", "woocommerce_store_city", "", "yes");
INSERT INTO `nqcpo_options` VALUES("945", "woocommerce_default_country", "US:CA", "yes");
INSERT INTO `nqcpo_options` VALUES("946", "woocommerce_store_postcode", "", "yes");
INSERT INTO `nqcpo_options` VALUES("947", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `nqcpo_options` VALUES("948", "woocommerce_all_except_countries", "", "yes");
INSERT INTO `nqcpo_options` VALUES("949", "woocommerce_specific_allowed_countries", "", "yes");
INSERT INTO `nqcpo_options` VALUES("950", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `nqcpo_options` VALUES("951", "woocommerce_specific_ship_to_countries", "", "yes");
INSERT INTO `nqcpo_options` VALUES("952", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `nqcpo_options` VALUES("953", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `nqcpo_options` VALUES("954", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `nqcpo_options` VALUES("955", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `nqcpo_options` VALUES("956", "woocommerce_currency", "USD", "yes");
INSERT INTO `nqcpo_options` VALUES("957", "woocommerce_currency_pos", "left", "yes");
INSERT INTO `nqcpo_options` VALUES("958", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `nqcpo_options` VALUES("959", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `nqcpo_options` VALUES("960", "woocommerce_price_num_decimals", "2", "yes");
INSERT INTO `nqcpo_options` VALUES("961", "woocommerce_shop_page_id", "34", "yes");
INSERT INTO `nqcpo_options` VALUES("962", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `nqcpo_options` VALUES("963", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `nqcpo_options` VALUES("964", "woocommerce_placeholder_image", "33", "yes");
INSERT INTO `nqcpo_options` VALUES("965", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `nqcpo_options` VALUES("966", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `nqcpo_options` VALUES("967", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `nqcpo_options` VALUES("968", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `nqcpo_options` VALUES("969", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `nqcpo_options` VALUES("970", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `nqcpo_options` VALUES("971", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `nqcpo_options` VALUES("972", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `nqcpo_options` VALUES("973", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `nqcpo_options` VALUES("974", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `nqcpo_options` VALUES("975", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `nqcpo_options` VALUES("976", "woocommerce_stock_email_recipient", "info@ballielektrik.com", "no");
INSERT INTO `nqcpo_options` VALUES("977", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `nqcpo_options` VALUES("978", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `nqcpo_options` VALUES("979", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `nqcpo_options` VALUES("980", "woocommerce_stock_format", "", "yes");
INSERT INTO `nqcpo_options` VALUES("981", "woocommerce_file_download_method", "force", "no");
INSERT INTO `nqcpo_options` VALUES("982", "woocommerce_downloads_redirect_fallback_allowed", "no", "no");
INSERT INTO `nqcpo_options` VALUES("983", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `nqcpo_options` VALUES("984", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `nqcpo_options` VALUES("985", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `nqcpo_options` VALUES("986", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `nqcpo_options` VALUES("987", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `nqcpo_options` VALUES("988", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `nqcpo_options` VALUES("989", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `nqcpo_options` VALUES("990", "woocommerce_tax_classes", "", "yes");
INSERT INTO `nqcpo_options` VALUES("991", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `nqcpo_options` VALUES("992", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `nqcpo_options` VALUES("993", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `nqcpo_options` VALUES("994", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `nqcpo_options` VALUES("995", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `nqcpo_options` VALUES("996", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `nqcpo_options` VALUES("997", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `nqcpo_options` VALUES("998", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `nqcpo_options` VALUES("999", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `nqcpo_options` VALUES("1000", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `nqcpo_options` VALUES("1001", "woocommerce_enable_signup_and_login_from_checkout", "no", "no");
INSERT INTO `nqcpo_options` VALUES("1002", "woocommerce_enable_myaccount_registration", "no", "no");
INSERT INTO `nqcpo_options` VALUES("1003", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `nqcpo_options` VALUES("1004", "woocommerce_registration_generate_password", "yes", "no");
INSERT INTO `nqcpo_options` VALUES("1005", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `nqcpo_options` VALUES("1006", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `nqcpo_options` VALUES("1007", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `nqcpo_options` VALUES("1008", "woocommerce_registration_privacy_policy_text", "Kişisel verileriniz bu web sitesindeki deneyiminizi desteklemek, hesabınıza erişimi yönetmek ve [privacy_policy] sayfamızda açıklanan diğer amaçlar için kullanılacaktır.", "yes");
INSERT INTO `nqcpo_options` VALUES("1009", "woocommerce_checkout_privacy_policy_text", "Kişisel verileriniz siparişinizi işleme almak, bu web sitesindeki deneyimlerinizi desteklemek ve [privacy_policy] sayfamızda açıklanan diğer amaçlar için kullanılacaktır.", "yes");
INSERT INTO `nqcpo_options` VALUES("1010", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `nqcpo_options` VALUES("1011", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `nqcpo_options` VALUES("1012", "woocommerce_trash_failed_orders", "", "no");
INSERT INTO `nqcpo_options` VALUES("1013", "woocommerce_trash_cancelled_orders", "", "no");
INSERT INTO `nqcpo_options` VALUES("1014", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `nqcpo_options` VALUES("1015", "woocommerce_email_from_name", "Ballı Elektrik", "no");
INSERT INTO `nqcpo_options` VALUES("1016", "woocommerce_email_from_address", "info@ballielektrik.com", "no");
INSERT INTO `nqcpo_options` VALUES("1017", "woocommerce_email_header_image", "", "no");
INSERT INTO `nqcpo_options` VALUES("1018", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `nqcpo_options` VALUES("1019", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `nqcpo_options` VALUES("1020", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `nqcpo_options` VALUES("1021", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `nqcpo_options` VALUES("1022", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `nqcpo_options` VALUES("1023", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `nqcpo_options` VALUES("1024", "woocommerce_cart_page_id", "35", "no");
INSERT INTO `nqcpo_options` VALUES("1025", "woocommerce_checkout_page_id", "36", "no");
INSERT INTO `nqcpo_options` VALUES("1026", "woocommerce_myaccount_page_id", "37", "no");
INSERT INTO `nqcpo_options` VALUES("1027", "woocommerce_terms_page_id", "", "no");
INSERT INTO `nqcpo_options` VALUES("1028", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `nqcpo_options` VALUES("1029", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `nqcpo_options` VALUES("1030", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `nqcpo_options` VALUES("1031", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `nqcpo_options` VALUES("1032", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `nqcpo_options` VALUES("1033", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `nqcpo_options` VALUES("1034", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `nqcpo_options` VALUES("1035", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `nqcpo_options` VALUES("1036", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `nqcpo_options` VALUES("1037", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `nqcpo_options` VALUES("1038", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `nqcpo_options` VALUES("1039", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `nqcpo_options` VALUES("1040", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `nqcpo_options` VALUES("1041", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `nqcpo_options` VALUES("1042", "woocommerce_allow_tracking", "no", "no");
INSERT INTO `nqcpo_options` VALUES("1043", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `nqcpo_options` VALUES("1044", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `nqcpo_options` VALUES("1045", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `nqcpo_options` VALUES("1046", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `nqcpo_options` VALUES("1047", "woocommerce_demo_store", "no", "no");
INSERT INTO `nqcpo_options` VALUES("1048", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:4:\"urun\";s:13:\"category_base\";s:13:\"urun-kategori\";s:8:\"tag_base\";s:12:\"urun-etiketi\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1049", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `nqcpo_options` VALUES("1050", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `nqcpo_options` VALUES("1054", "default_product_cat", "17", "yes");
INSERT INTO `nqcpo_options` VALUES("1057", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:102:\"PayPal aracılığıyla ödemede PayPal hesabınız yoksa bile kredi kartı ile ödeme yapabilirsiniz.\";s:5:\"email\";s:22:\"info@ballielektrik.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:22:\"info@ballielektrik.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("1058", "woocommerce_version", "5.5.2", "yes");
INSERT INTO `nqcpo_options` VALUES("1059", "woocommerce_db_version", "5.5.2", "yes");
INSERT INTO `nqcpo_options` VALUES("1060", "woocommerce_inbox_variant_assignment", "11", "yes");
INSERT INTO `nqcpo_options` VALUES("1065", "action_scheduler_lock_async-request-runner", "1628461450", "yes");
INSERT INTO `nqcpo_options` VALUES("1066", "woocommerce_admin_notices", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("1067", "elementor_version", "3.35.5", "yes");
INSERT INTO `nqcpo_options` VALUES("1068", "elementor_install_history", "a:13:{s:5:\"3.3.1\";i:1628457590;s:5:\"3.4.0\";i:1629234031;s:5:\"3.4.1\";i:1629313568;s:5:\"3.4.2\";i:1630014350;s:5:\"3.5.3\";i:1641420825;s:5:\"3.5.4\";i:1642979702;s:6:\"3.16.5\";i:1696884385;s:6:\"3.16.6\";i:1697570195;s:6:\"3.26.0\";i:1734380066;s:6:\"3.26.2\";i:1734802072;s:6:\"3.27.6\";i:1741352446;s:6:\"3.28.3\";i:1743596412;s:6:\"3.35.5\";i:1771802011;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1069", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"CqCMjcEhaiLbZGoc6CAjNZQmSZSnjlvr\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("1071", "widget_kriate_quick_links_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1072", "widget_categories_custom", "a:2:{i:1;a:4:{s:5:\"title\";s:8:\"Category\";s:5:\"count\";i:1;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1073", "widget_about_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `nqcpo_options` VALUES("1074", "widget_footer_payment_gateway", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1075", "widget_follow_us_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1076", "widget_bio_desc_widget", "a:2:{i:1;a:5:{s:5:\"title\";s:8:\"About Me\";s:4:\"desc\";s:98:\"Praesent scelerisque, odio eu fermentum malesuada, nisi arcu volutpat nisl, sit amet convallis nun\";s:4:\"logo\";s:79:\"https://nauthemes.com/wp/kriate/wp-content/uploads/2020/11/about-widget-img.jpg\";s:11:\"author_name\";s:14:\"Mr. Nelson Doe\";s:6:\"fb_url\";s:20:\"https://facebook.com\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1077", "widget_image_video_widget", "a:2:{i:1;a:3:{s:5:\"title\";s:0:\"\";s:4:\"desc\";s:41:\"https://www.youtube.com/embed/6gUOzbhtVd4\";s:4:\"logo\";s:70:\"https://nauthemes.com/wp/kriate/wp-content/uploads/2020/12/370x570.png\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1078", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1079", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1080", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1081", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1082", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1083", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1084", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1085", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1086", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1087", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1088", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1089", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1092", "woocommerce_admin_version", "2.4.4", "yes");
INSERT INTO `nqcpo_options` VALUES("1093", "woocommerce_admin_install_timestamp", "1628457591", "yes");
INSERT INTO `nqcpo_options` VALUES("1094", "wc_remote_inbox_notifications_wca_updated", "", "no");
INSERT INTO `nqcpo_options` VALUES("1095", "wc_remote_inbox_notifications_specs", "a:33:{s:16:\"wayflyer_q3_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:16:\"wayflyer_q3_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"Grow your revenue with Wayflyer financing and analytics\";s:7:\"content\";s:322:\"Flexible financing tailored to your needs by <a href=\"https://woocommerce.com/products/wayflyer/\">Wayflyer</a> – one fee, no interest rates, penalties, equity, or personal guarantees. Based on your store\'s performance, Wayflyer can provide the financing you need to grow and the analytical insights to help you spend it.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:16:\"wayflyer_q3_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Get funded\";}}s:3:\"url\";s:42:\"https://woocommerce.com/products/wayflyer/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-07-19 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-07-31 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\"<=\";s:5:\"value\";s:3:\"200\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";s:3:\"100\";}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AU\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"BE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IE\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NL\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"UK\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}}}s:19:\"eu_vat_changes_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"eu_vat_changes_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:54:\"Get your business ready for the new EU tax regulations\";s:7:\"content\";s:617:\"On July 1, 2021, new taxation rules will come into play when the <a href=\"https://ec.europa.eu/taxation_customs/business/vat/modernising-vat-cross-border-ecommerce_en\">European Union (EU) Value-Added Tax (VAT) eCommerce package</a> takes effect.<br/><br/>The new regulations will impact virtually every B2C business involved in cross-border eCommerce trade with the EU.<br/><br/>We therefore recommend <a href=\"https://woocommerce.com/posts/new-eu-vat-regulations\">familiarizing yourself with the new updates</a>, and consult with a tax professional to ensure your business is following regulations and best practice.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:19:\"eu_vat_changes_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:39:\"Learn more about the EU tax regulations\";}}s:3:\"url\";s:52:\"https://woocommerce.com/posts/new-eu-vat-regulations\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-24 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-07-11 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:29:\"woocommerce_allowed_countries\";s:5:\"value\";s:3:\"all\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:1;a:2:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:29:\"woocommerce_allowed_countries\";s:5:\"value\";s:10:\"all_except\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:27:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"BE\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"BG\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"CZ\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"DK\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"DE\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"EE\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"IE\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"EL\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"ES\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"FR\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"HR\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"IT\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"CY\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"LV\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"LT\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"LU\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"HU\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"MT\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"NL\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"AT\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"PL\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"PT\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"RO\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"SI\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"SK\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"FI\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:32:\"woocommerce_all_except_countries\";s:5:\"value\";s:2:\"SE\";s:7:\"default\";a:0:{}s:9:\"operation\";s:9:\"!contains\";}}}}i:2;a:3:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:29:\"woocommerce_allowed_countries\";s:5:\"value\";s:3:\"all\";s:7:\"default\";b:0;s:9:\"operation\";s:2:\"!=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:29:\"woocommerce_allowed_countries\";s:5:\"value\";s:10:\"all_except\";s:7:\"default\";b:0;s:9:\"operation\";s:2:\"!=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:27:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"BE\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"BG\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"CZ\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"DK\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"DE\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"EE\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"IE\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"EL\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"ES\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"FR\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"HR\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"IT\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"CY\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"LV\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"LT\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"LU\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"HU\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"MT\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"NL\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"AT\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"PL\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"PT\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"RO\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"SI\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"SK\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"FI\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:38:\"woocommerce_specific_allowed_countries\";s:5:\"value\";s:2:\"SE\";s:7:\"default\";a:0:{}s:9:\"operation\";s:8:\"contains\";}}}}}}}}s:20:\"paypal_ppcp_gtm_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:20:\"paypal_ppcp_gtm_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:38:\"Offer more options with the new PayPal\";s:7:\"content\";s:113:\"Get the latest PayPal extension for a full suite of payment methods with extensive currency and country coverage.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:36:\"open_wc_paypal_payments_product_page\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:61:\"https://woocommerce.com/products/woocommerce-paypal-payments/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-04-05 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-04-21 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:30:\"woocommerce-gateway-paypal-pro\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:37:\"woocommerce-gateway-paypal-pro-hosted\";}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:35:\"woocommerce-gateway-paypal-advanced\";}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:40:\"woocommerce-gateway-paypal-digital-goods\";}}i:5;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:31:\"woocommerce-paypal-here-gateway\";}}i:6;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:44:\"woocommerce-gateway-paypal-adaptive-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:27:\"woocommerce-paypal-payments\";s:7:\"version\";s:5:\"1.2.1\";s:8:\"operator\";s:1:\"<\";}}}}}s:23:\"facebook_pixel_api_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:23:\"facebook_pixel_api_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:44:\"Improve the performance of your Facebook ads\";s:7:\"content\";s:152:\"Enable Facebook Pixel and Conversions API through the latest version of Facebook for WooCommerce for improved measurement and ad targeting capabilities.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"upgrade_now_facebook_pixel_api\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Upgrade now\";}}s:3:\"url\";s:67:\"plugin-install.php?tab=plugin-information&plugin=&section=changelog\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-05-17 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-06-14 00:00:00\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"facebook-for-woocommerce\";s:7:\"version\";s:5:\"2.4.0\";s:8:\"operator\";s:2:\"<=\";}}}s:16:\"facebook_ec_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:16:\"facebook_ec_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:59:\"Sync your product catalog with Facebook to help boost sales\";s:7:\"content\";s:170:\"A single click adds all products to your Facebook Business Page shop. Product changes are automatically synced, with the flexibility to control which products are listed.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:22:\"learn_more_facebook_ec\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:42:\"https://woocommerce.com/products/facebook/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-03-01 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-03-15 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:24:\"facebook-for-woocommerce\";}}}}s:37:\"ecomm-need-help-setting-up-your-store\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"ecomm-need-help-setting-up-your-store\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:32:\"Need help setting up your Store?\";s:7:\"content\";s:350:\"Schedule a free 30-min <a href=\"https://wordpress.com/support/concierge-support/\">quick start session</a> and get help from our specialists. We’re happy to walk through setup steps, show you around the WordPress.com dashboard, troubleshoot any issues you may have, and help you the find the features you need to accomplish your goals for your site.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:16:\"set-up-concierge\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Schedule free session\";}}s:3:\"url\";s:34:\"https://wordpress.com/me/concierge\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}}}s:20:\"woocommerce-services\";O:8:\"stdClass\":8:{s:4:\"slug\";s:20:\"woocommerce-services\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:26:\"WooCommerce Shipping & Tax\";s:7:\"content\";s:255:\"WooCommerce Shipping & Tax helps get your store “ready to sell” as quickly as possible. You create your products. We take care of tax calculation, payment processing, and shipping label printing! Learn more about the extension that you just installed.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:84:\"https://docs.woocommerce.com/document/woocommerce-shipping-and-tax/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:32:\"ecomm-unique-shopping-experience\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"ecomm-unique-shopping-experience\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"For a shopping experience as unique as your customers\";s:7:\"content\";s:274:\"Product Add-Ons allow your customers to personalize products while they’re shopping on your online store. No more follow-up email requests—customers get what they want, before they’re done checking out. Learn more about this extension that comes included in your plan.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:43:\"learn-more-ecomm-unique-shopping-experience\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:71:\"https://docs.woocommerce.com/document/product-add-ons/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:37:\"wc-admin-getting-started-in-ecommerce\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-getting-started-in-ecommerce\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:38:\"Getting Started in eCommerce - webinar\";s:7:\"content\";s:174:\"We want to make eCommerce and this process of getting started as easy as possible for you. Watch this webinar to get tips on how to have our store up and running in a breeze.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"watch-the-webinar\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:17:\"Watch the webinar\";}}s:3:\"url\";s:28:\"https://youtu.be/V_2XtCOyZ7o\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:12:\"setup_client\";s:9:\"operation\";s:2:\"!=\";s:5:\"value\";b:1;}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_count\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:4:\"none\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:10:\"up-to-2500\";}}}}}s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:461:\"That\'s huge! You\'re well on your way to building a successful online store — now it’s time to think about how you\'ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:82:\"https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";s:7:\"default\";a:0:{}}}}s:31:\"wc-square-apple-pay-boost-sales\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"wc-square-apple-pay-boost-sales\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:26:\"Boost sales with Apple Pay\";s:7:\"content\";s:191:\"Now that you accept Apple Pay® with Square you can increase conversion rates by letting your customers know that Apple Pay® is available. Here’s a marketing guide to help you get started.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:27:\"boost-sales-marketing-guide\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"See marketing guide\";}}s:3:\"url\";s:97:\"https://developer.apple.com/apple-pay/marketing/?utm_source=inbox&utm_campaign=square-boost-sales\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:9:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.8\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:18:\"woocommerce-square\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"2.3\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:27:\"wc_square_apple_pay_enabled\";s:5:\"value\";i:1;s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:38:\"wc-square-apple-pay-grow-your-business\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:38:\"wc-square-apple-pay-grow-your-business\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:27:\"wcpay-apple-pay-boost-sales\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:27:\"wcpay-apple-pay-boost-sales\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:34:\"wcpay-apple-pay-grow-your-business\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:34:\"wcpay-apple-pay-grow-your-business\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}}}s:38:\"wc-square-apple-pay-grow-your-business\";O:8:\"stdClass\":8:{s:4:\"slug\";s:38:\"wc-square-apple-pay-grow-your-business\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:45:\"Grow your business with Square and Apple Pay \";s:7:\"content\";s:178:\"Now more than ever, shoppers want a fast, simple, and secure online checkout experience. Increase conversion rates by letting your customers know that you now accept Apple Pay®.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"grow-your-business-marketing-guide\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"See marketing guide\";}}s:3:\"url\";s:104:\"https://developer.apple.com/apple-pay/marketing/?utm_source=inbox&utm_campaign=square-grow-your-business\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:9:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.8\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:18:\"woocommerce-square\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"2.3\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:27:\"wc_square_apple_pay_enabled\";s:5:\"value\";i:2;s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:31:\"wc-square-apple-pay-boost-sales\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:31:\"wc-square-apple-pay-boost-sales\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:27:\"wcpay-apple-pay-boost-sales\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:27:\"wcpay-apple-pay-boost-sales\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:34:\"wcpay-apple-pay-grow-your-business\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:34:\"wcpay-apple-pay-grow-your-business\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}}}s:32:\"wcpay-apple-pay-is-now-available\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wcpay-apple-pay-is-now-available\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"Apple Pay is now available with WooCommerce Payments!\";s:7:\"content\";s:397:\"Increase your conversion rate by offering a fast and secure checkout with <a href=\"https://woocommerce.com/apple-pay/?utm_source=inbox&utm_medium=product&utm_campaign=wcpay_applepay\" target=\"_blank\">Apple Pay</a>®. It’s free to get started with <a href=\"https://woocommerce.com/payments/?utm_source=inbox&utm_medium=product&utm_campaign=wcpay_applepay\" target=\"_blank\">WooCommerce Payments</a>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:13:\"add-apple-pay\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Add Apple Pay\";}}s:3:\"url\";s:69:\"/admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:121:\"https://docs.woocommerce.com/document/payments/apple-pay/?utm_source=inbox&utm_medium=product&utm_campaign=wcpay_applepay\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.8\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"2.3.0\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:26:\"wcpay_is_apple_pay_enabled\";s:5:\"value\";b:0;s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}}}s:27:\"wcpay-apple-pay-boost-sales\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"wcpay-apple-pay-boost-sales\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:26:\"Boost sales with Apple Pay\";s:7:\"content\";s:205:\"Now that you accept Apple Pay® with WooCommerce Payments you can increase conversion rates by letting your customers know that Apple Pay® is available. Here’s a marketing guide to help you get started.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:27:\"boost-sales-marketing-guide\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"See marketing guide\";}}s:3:\"url\";s:96:\"https://developer.apple.com/apple-pay/marketing/?utm_source=inbox&utm_campaign=wcpay-boost-sales\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.8\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:26:\"wcpay_is_apple_pay_enabled\";s:5:\"value\";i:1;s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:34:\"wcpay-apple-pay-grow-your-business\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:34:\"wcpay-apple-pay-grow-your-business\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}}}s:34:\"wcpay-apple-pay-grow-your-business\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"wcpay-apple-pay-grow-your-business\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:58:\"Grow your business with WooCommerce Payments and Apple Pay\";s:7:\"content\";s:178:\"Now more than ever, shoppers want a fast, simple, and secure online checkout experience. Increase conversion rates by letting your customers know that you now accept Apple Pay®.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"grow-your-business-marketing-guide\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"See marketing guide\";}}s:3:\"url\";s:103:\"https://developer.apple.com/apple-pay/marketing/?utm_source=inbox&utm_campaign=wcpay-grow-your-business\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.8\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:26:\"wcpay_is_apple_pay_enabled\";s:5:\"value\";i:2;s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:27:\"wcpay-apple-pay-boost-sales\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:27:\"wcpay-apple-pay-boost-sales\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:171:\"It\'s crucial to get your store\'s checkout as smooth as possible to avoid losing sales. Let\'s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:78:\"https://woocommerce.com/posts/optimizing-woocommerce-checkout?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";s:7:\"default\";a:0:{}}}}s:39:\"wc-admin-first-five-things-to-customize\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-admin-first-five-things-to-customize\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:45:\"The first 5 things to customize in your store\";s:7:\"content\";s:173:\"Deciding what to start with first is tricky. To help you properly prioritize, we\'ve put together this short list of the first few things you should customize in WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:82:\"https://woocommerce.com/posts/first-things-customize-woocommerce/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:2;}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:5:\"value\";s:9:\"NOT EMPTY\";s:7:\"default\";s:9:\"NOT EMPTY\";s:9:\"operation\";s:2:\"!=\";}}}s:32:\"wc-payments-qualitative-feedback\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wc-payments-qualitative-feedback\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Payments setup - let us know what you think\";s:7:\"content\";s:146:\"Congrats on enabling WooCommerce Payments for your store. Please share your feedback in this 2 minute survey to help us improve the setup process.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"qualitative-feedback-from-new-users\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:39:\"https://automattic.survey.fm/wc-pay-new\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:20:\"woocommerce-payments\";s:7:\"default\";a:0:{}}}}s:29:\"share-your-feedback-on-paypal\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"share-your-feedback-on-paypal\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:29:\"Share your feedback on PayPal\";s:7:\"content\";s:127:\"Share your feedback in this 2 minute survey about how we can make the process of accepting payments more useful for your store.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:43:\"http://automattic.survey.fm/paypal-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}}}s:31:\"wcpay_instant_deposits_gtm_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"wcpay_instant_deposits_gtm_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:69:\"Get paid within minutes – Instant Deposits for WooCommerce Payments\";s:7:\"content\";s:384:\"Stay flexible with immediate access to your funds when you need them – including nights, weekends, and holidays. With <a href=\"https://woocommerce.com/products/woocommerce-payments/?utm_source=inbox&utm_medium=product&utm_campaign=wcpay_instant_deposits\">WooCommerce Payments\'</a> new Instant Deposits feature, you’re able to transfer your earnings to a debit card within minutes.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:40:\"Learn about Instant Deposits eligibility\";}}s:3:\"url\";s:136:\"https://docs.woocommerce.com/document/payments/instant-deposits/?utm_source=inbox&utm_medium=product&utm_campaign=wcpay_instant_deposits\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-05-18 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-06-01 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}s:31:\"google_listings_and_ads_install\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"google_listings_and_ads_install\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Drive traffic and sales with Google\";s:7:\"content\";s:123:\"Reach online shoppers to drive traffic and sales for your store by showcasing products across Google, for free or with ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"get-started\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Get started\";}}s:3:\"url\";s:56:\"https://woocommerce.com/products/google-listings-and-ads\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-09 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google_listings_and_ads\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:10;}}}s:39:\"wc-subscriptions-security-update-3-0-15\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-subscriptions-security-update-3-0-15\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:42:\"WooCommerce Subscriptions security update!\";s:7:\"content\";s:736:\"We recently released an important security update to WooCommerce Subscriptions. To ensure your site\'s data is protected, please upgrade <strong>WooCommerce Subscriptions to version 3.0.15</strong> or later.<br/><br/>Click the button below to view and update to the latest Subscriptions version, or log in to <a href=\"https://woocommerce.com/my-dashboard\">WooCommerce.com Dashboard</a> and navigate to your <strong>Downloads</strong> page.<br/><br/>We recommend always using the latest version of WooCommerce Subscriptions, and other software running on your site, to ensure maximum security.<br/><br/>If you have any questions we are here to help — just <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">open a ticket</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"update-wc-subscriptions-3-0-15\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"View latest version\";}}s:3:\"url\";s:30:\"&page=wc-addons&section=helper\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:6:\"3.0.15\";}}}s:29:\"woocommerce-core-update-5-4-0\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"woocommerce-core-update-5-4-0\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Update to WooCommerce 5.4.1 now\";s:7:\"content\";s:140:\"WooCommerce 5.4.1 addresses a checkout issue discovered in WooCommerce 5.4. We recommend upgrading to WooCommerce 5.4.1 as soon as possible.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"update-wc-core-5-4-0\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:25:\"How to update WooCommerce\";}}s:3:\"url\";s:64:\"https://docs.woocommerce.com/document/how-to-update-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.0\";}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":7:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-11\";s:7:\"content\";s:19:\"wcpay-promo-2020-11\";}}s:5:\"rules\";a:0:{}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":7:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-12\";s:7:\"content\";s:19:\"wcpay-promo-2020-12\";}}s:5:\"rules\";a:0:{}}s:30:\"wcpay-promo-2021-6-incentive-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"wcpay-promo-2021-6-incentive-1\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:82:\"Simplify the payments process for you and your customers with WooCommerce Payments\";s:7:\"content\";s:704:\"With <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">WooCommerce Payments</a>, you can securely accept all major cards, Apple Pay®, and recurring revenue in over 100 currencies. \n				Built into your store’s WooCommerce dashboard, track cash flow and manage all of your transactions in one place – with no setup costs or monthly fees.\n				<br/><br/>\n				By clicking \"Get WooCommerce Payments,\" you agree to the <a href=\"https://wordpress.com/tos/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">Terms of Service</a> \n				and acknowledge you have read the <a href=\"https://automattic.com/privacy/\">Privacy Policy</a>.\n				\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:25:\"get-woo-commerce-payments\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Payments\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:12:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:6:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"1\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"3\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"5\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"7\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"9\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:2:\"11\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:4:{i:0;s:17:\"crowdsignal-forms\";i:1;s:11:\"layout-grid\";i:2;s:17:\"full-site-editing\";i:3;s:13:\"page-optimize\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:26:\"woocommerce_allow_tracking\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:2:\">=\";s:4:\"days\";i:31;}i:5;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.0\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:10:\"db_version\";s:5:\"value\";s:5:\"45805\";s:7:\"default\";i:0;s:9:\"operation\";s:2:\">=\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}}}s:30:\"wcpay-promo-2021-6-incentive-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"wcpay-promo-2021-6-incentive-2\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:82:\"Simplify the payments process for you and your customers with WooCommerce Payments\";s:7:\"content\";s:704:\"With <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">WooCommerce Payments</a>, you can securely accept all major cards, Apple Pay®, and recurring revenue in over 100 currencies. \n				Built into your store’s WooCommerce dashboard, track cash flow and manage all of your transactions in one place – with no setup costs or monthly fees.\n				<br/><br/>\n				By clicking \"Get WooCommerce Payments,\" you agree to the <a href=\"https://wordpress.com/tos/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">Terms of Service</a> \n				and acknowledge you have read the <a href=\"https://automattic.com/privacy/\">Privacy Policy</a>.\n				\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"get-woocommerce-payments\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Payments\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:12:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:6:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"2\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"4\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"6\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"8\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:2:\"10\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:2:\"12\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:4:{i:0;s:17:\"crowdsignal-forms\";i:1;s:11:\"layout-grid\";i:2;s:17:\"full-site-editing\";i:3;s:13:\"page-optimize\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:26:\"woocommerce_allow_tracking\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:2:\">=\";s:4:\"days\";i:31;}i:5;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.0\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:10:\"db_version\";s:5:\"value\";s:5:\"45805\";s:7:\"default\";i:0;s:9:\"operation\";s:2:\">=\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-1\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Get the latest PayPal extension for WooCommerce\";s:7:\"content\";s:440:\"Heads up! There\'s a new PayPal on the block!<br/><br/>Now is a great time to upgrade to our latest <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension</a> to continue to receive support and updates with PayPal.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, and pay later options with the all-new PayPal extension for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:2:\"!=\";s:5:\"value\";b:0;s:7:\"default\";b:0;}}}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:7;s:7:\"default\";i:1;s:9:\"operation\";s:1:\"<\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-2\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Upgrade your PayPal experience!\";s:7:\"content\";s:513:\"We\'ve developed a whole new <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension for WooCommerce</a> that combines the best features of our many PayPal extensions into just one extension.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, offer subscription and recurring payments, and the new PayPal pay later options.<br/><br/>Start using our latest PayPal today to continue to receive support and updates.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-2\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:2:\"!=\";s:5:\"value\";b:0;s:7:\"default\";b:0;}}}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:6;s:7:\"default\";i:1;s:9:\"operation\";s:1:\">\";}}}s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Critical vulnerabilities in WooCommerce\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:23:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Critical vulnerabilities in WooCommerce Blocks\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:45:\"woocommerce-core-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woocommerce-core-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"Solved: Critical vulnerabilities patched in WooCommerce\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:23:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.1\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Solved: Critical vulnerabilities patched in WooCommerce Blocks\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}}", "no");
INSERT INTO `nqcpo_options` VALUES("1096", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}", "no");
INSERT INTO `nqcpo_options` VALUES("1106", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `nqcpo_options` VALUES("1107", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:59:\"The atomic foundation of version 4 is ready for real sites!\";s:7:\"excerpt\";s:296:\"The alpha phase is complete. Version 4 is now in beta, and the atomic foundation is ready to be used on real sites! This is the final step before the official release of version 4.0, activating the new features automatically on new sites, and becoming the default editing experience in Elementor.\";s:7:\"created\";i:1770651621;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:113:\"https://elementor.com/blog/editor-4-beta/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:79:\"Introducing Elementor 3.33: Variables Manager, Custom CSS, Blend Modes, & more!\";s:7:\"excerpt\";s:340:\"Elementor 3.33 builds on the foundation of Editor V4, continuing our mission to create a faster, more scalable, and more intuitive design experience for Web Creators. With the addition of the Variables Manager, element-level Custom CSS, Background Clipping, and Blend Modes, designers have more creative precision and consistency than ever.\";s:7:\"created\";i:1762944115;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:145:\"https://elementor.com/blog/elementor-333-v4-variables-manager-custom-css/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `nqcpo_options` VALUES("1110", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `nqcpo_options` VALUES("1111", "kriate_options", "a:46:{s:8:\"last_tab\";s:0:\"\";s:10:\"logo_image\";a:5:{s:3:\"url\";s:91:\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/logo-balli-elektrik-logo.png\";s:2:\"id\";s:2:\"25\";s:6:\"height\";s:3:\"361\";s:5:\"width\";s:4:\"1080\";s:9:\"thumbnail\";s:99:\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/logo-balli-elektrik-logo-150x150.png\";}s:16:\"logo_image_light\";a:5:{s:3:\"url\";s:77:\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/logo-beyaz.png\";s:2:\"id\";s:2:\"27\";s:6:\"height\";s:3:\"361\";s:5:\"width\";s:4:\"1080\";s:9:\"thumbnail\";s:85:\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/logo-beyaz-150x150.png\";}s:15:\"logo_image_dark\";a:5:{s:3:\"url\";s:91:\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/logo-balli-elektrik-logo.png\";s:2:\"id\";s:2:\"25\";s:6:\"height\";s:3:\"361\";s:5:\"width\";s:4:\"1080\";s:9:\"thumbnail\";s:99:\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/logo-balli-elektrik-logo-150x150.png\";}s:17:\"logo_image_sticky\";a:5:{s:3:\"url\";s:91:\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/logo-balli-elektrik-logo.png\";s:2:\"id\";s:2:\"25\";s:6:\"height\";s:3:\"361\";s:5:\"width\";s:4:\"1080\";s:9:\"thumbnail\";s:99:\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/logo-balli-elektrik-logo-150x150.png\";}s:10:\"logo_width\";s:3:\"150\";s:11:\"logo_height\";s:2:\"55\";s:20:\"select-header-layout\";s:7:\"header1\";s:24:\"header_stickyhead_switch\";s:1:\"1\";s:20:\"header_topbar_switch\";s:1:\"1\";s:20:\"header_phone_caption\";s:22:\"7/24 İletişim Hattı\";s:15:\"header_phone_no\";s:14:\"0541 560 89 18\";s:11:\"header_cart\";s:1:\"1\";s:11:\"signup_text\";s:8:\"Whatsapp\";s:10:\"signup_url\";s:26:\"https://wa.me/905415608918\";s:20:\"header_social_switch\";s:1:\"1\";s:12:\"phone_number\";s:44:\"Eserte Mah. 312. Sok. 16/2 Keçiören/ANKARA\";s:8:\"email_id\";s:26:\"info@www.ballielektrik.com\";s:15:\"inner_header_bg\";a:5:{s:3:\"url\";s:100:\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/bigstock-Lightbulb-6256753-scaled.jpg\";s:2:\"id\";s:4:\"1339\";s:6:\"height\";s:4:\"1920\";s:5:\"width\";s:4:\"2560\";s:9:\"thumbnail\";s:101:\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/bigstock-Lightbulb-6256753-150x150.jpg\";}s:11:\"breadcrumbs\";s:1:\"1\";s:13:\"color-primary\";s:7:\"#FF5E15\";s:15:\"color-secondary\";s:7:\"#0A1024\";s:18:\"select-bodybg-type\";s:5:\"color\";s:10:\"body_color\";s:7:\"#FFFFFF\";s:13:\"body_patterns\";s:1:\"2\";s:16:\"background_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:17:\"footer_copy_right\";s:278:\"<p><a href=\"http://localhost:8888/ballielektrik/\" target=\"_blank\">Ankara Ballı Elektrik</a> &copy; 2021. T&uuml;m Hakları Saklıdır.</p>\r\n<p>Bu Web Sitesi <a href=\"https:precadmedya.com.tr\" target=\"_blank\">Precad Medya ve Tasarım Ajansı</a> Tarafından Yapılmıştır.</p>\";s:20:\"select-footer-layout\";s:7:\"footer1\";s:22:\"default-footer-columns\";s:5:\"4-col\";s:14:\"sidebar-layout\";s:5:\"right\";s:12:\"twitter-link\";s:18:\"http://twitter.com\";s:13:\"facebook-link\";s:19:\"http://facebook.com\";s:14:\"instagram-link\";s:22:\"https://Instagram.com/\";s:13:\"linkedin-link\";s:24:\"http://www.linkedin.com/\";s:12:\"youtube-link\";s:0:\"\";s:13:\"heading1-font\";a:7:{s:11:\"font-family\";s:7:\"Poppins\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"70px\";s:5:\"color\";s:4:\"#222\";}s:13:\"heading2-font\";a:7:{s:11:\"font-family\";s:7:\"Poppins\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"32px\";s:5:\"color\";s:4:\"#222\";}s:13:\"heading3-font\";a:7:{s:11:\"font-family\";s:7:\"Poppins\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"28px\";s:5:\"color\";s:4:\"#222\";}s:13:\"heading4-font\";a:7:{s:11:\"font-family\";s:7:\"Poppins\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"22px\";s:5:\"color\";s:4:\"#222\";}s:13:\"heading5-font\";a:7:{s:11:\"font-family\";s:7:\"Poppins\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"18px\";s:5:\"color\";s:4:\"#222\";}s:13:\"heading6-font\";a:7:{s:11:\"font-family\";s:7:\"Poppins\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"16px\";s:5:\"color\";s:4:\"#222\";}s:9:\"body-font\";a:7:{s:11:\"font-family\";s:9:\"Open Sans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"15px\";s:5:\"color\";s:4:\"#555\";}s:8:\"nav-font\";a:7:{s:11:\"font-family\";s:7:\"Poppins\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:9:\"font-size\";s:4:\"15px\";s:5:\"color\";s:4:\"#fff\";}s:12:\"anime_switch\";s:1:\"0\";s:17:\"google_map_apikey\";s:0:\"\";s:10:\"multi-text\";a:0:{}}", "yes");
INSERT INTO `nqcpo_options` VALUES("1112", "kriate_options-transients", "a:5:{s:14:\"changed_values\";a:1:{s:15:\"inner_header_bg\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:9:\"last_save\";i:1771814646;s:13:\"last_compiler\";i:1629240760;s:11:\"last_import\";i:1629240760;s:7:\"notices\";a:2:{s:6:\"errors\";a:0:{}s:8:\"sanitize\";a:0:{}}}", "yes");
INSERT INTO `nqcpo_options` VALUES("1113", "_elementor_installed_time", "1628457594", "yes");
INSERT INTO `nqcpo_options` VALUES("1114", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("1126", "elementor_library_category_children", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("1127", "services-cat_children", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("1128", "team-category_children", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("1129", "projects-category_children", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("1130", "testimonial-category_children", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("1131", "product_cat_children", "a:1:{i:32;a:3:{i:0;i:37;i:1;i:50;i:2;i:53;}}", "yes");
INSERT INTO `nqcpo_options` VALUES("1132", "pa_color_children", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("1133", "pa_size_children", "a:0:{}", "yes");
INSERT INTO `nqcpo_options` VALUES("1144", "woocommerce_maybe_regenerate_images_hash", "991b1ca641921cf0f5baf7a2fe85861b", "yes");
INSERT INTO `nqcpo_options` VALUES("1206", "elementor_scheme_color", "a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("1207", "elementor_scheme_typography", "a:4:{i:1;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"600\";}i:2;a:2:{s:11:\"font_family\";s:11:\"Roboto Slab\";s:11:\"font_weight\";s:3:\"400\";}i:3;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"400\";}i:4;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"500\";}}", "yes");
INSERT INTO `nqcpo_options` VALUES("1208", "elementor_scheme_color-picker", "a:8:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";i:5;s:7:\"#4054b2\";i:6;s:7:\"#23a455\";i:7;s:4:\"#000\";i:8;s:4:\"#fff\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("1404", "litespeed.conf.guest", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("1405", "litespeed.conf.guest_optm", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("1406", "litespeed.conf.guest_uas", "[\"Lighthouse\",\"GTmetrix\",\"Google\",\"Pingdom\",\"bot\",\"PTST\",\"HeadlessChrome\"]", "yes");
INSERT INTO `nqcpo_options` VALUES("1407", "litespeed.conf.guest_ips", "[\"208.70.247.157\",\"172.255.48.130\",\"172.255.48.131\",\"172.255.48.132\",\"172.255.48.133\",\"172.255.48.134\",\"172.255.48.135\",\"172.255.48.136\",\"172.255.48.137\",\"172.255.48.138\",\"172.255.48.139\",\"172.255.48.140\",\"172.255.48.141\",\"172.255.48.142\",\"172.255.48.143\",\"172.255.48.144\",\"172.255.48.145\",\"172.255.48.146\",\"172.255.48.147\",\"52.229.122.240\",\"104.214.72.101\",\"13.66.7.11\",\"13.85.24.83\",\"13.85.24.90\",\"13.85.82.26\",\"40.74.242.253\",\"40.74.243.13\",\"40.74.243.176\",\"104.214.48.247\",\"157.55.189.189\",\"104.214.110.135\",\"70.37.83.240\",\"65.52.36.250\",\"13.78.216.56\",\"52.162.212.163\",\"23.96.34.105\",\"65.52.113.236\",\"172.255.61.34\",\"172.255.61.35\",\"172.255.61.36\",\"172.255.61.37\",\"172.255.61.38\",\"172.255.61.39\",\"172.255.61.40\",\"104.41.2.19\",\"191.235.98.164\",\"191.235.99.221\",\"191.232.194.51\",\"52.237.235.185\",\"52.237.250.73\",\"52.237.236.145\",\"104.211.143.8\",\"104.211.165.53\",\"52.172.14.87\",\"40.83.89.214\",\"52.175.57.81\",\"20.188.63.151\",\"20.52.36.49\",\"52.246.165.153\",\"51.144.102.233\",\"13.76.97.224\",\"102.133.169.66\",\"52.231.199.170\",\"13.53.162.7\",\"40.123.218.94\"]", "yes");
INSERT INTO `nqcpo_options` VALUES("1408", "litespeed.conf.optm-ucss_whitelist", "[]", "yes");
INSERT INTO `nqcpo_options` VALUES("1409", "litespeed.conf.optm-html_lazy", "[]", "yes");
INSERT INTO `nqcpo_options` VALUES("1410", "litespeed.conf.optm-ccss_per_url", "", "yes");
INSERT INTO `nqcpo_options` VALUES("1411", "litespeed.conf.optm-gm_js_exc", "[]", "yes");
INSERT INTO `nqcpo_options` VALUES("1412", "litespeed.conf.optm-guest_only", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("1413", "litespeed.conf.media-add_missing_sizes", "", "yes");
INSERT INTO `nqcpo_options` VALUES("1507", "litespeed.admin_display._summary", "{\"new_version\":1628126872,\"score\":1628472472,\"new_version.last_check\":1629282156,\"new_version.v\":\"4.3\"}", "yes");
INSERT INTO `nqcpo_options` VALUES("1618", "elementor_log", "a:43:{s:32:\"fe545210e7980e5385c92174626fdff0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-01-24 02:15:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-01-24 02:15:02\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"0210975eaa5658ed3d77cf51aa4bb0db\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-01-24 02:15:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.5.3\";s:2:\"to\";s:5:\"3.5.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-01-24 02:15:02\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.5.3\";s:2:\"to\";s:5:\"3.5.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"02ebe3ef12d4820ce2657a403ed3d483\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-01-24 02:15:04\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.5.3\";s:2:\"to\";s:5:\"3.5.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-01-24 02:15:04\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.5.3\";s:2:\"to\";s:5:\"3.5.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"de37ef35317ebd119cfa952311f9f251\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2022-03-23 09:56:36\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:59:\"The $control_id argument is deprecated since version 3.5.0!\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:2596;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2023-02-05 03:21:02\";i:1;s:19:\"2023-02-05 16:49:13\";i:2;s:19:\"2023-02-06 10:08:22\";i:3;s:19:\"2023-02-07 07:49:36\";i:4;s:19:\"2023-02-07 19:39:04\";i:5;s:19:\"2023-02-07 23:36:25\";i:6;s:19:\"2023-02-08 19:31:16\";i:7;s:19:\"2023-02-08 19:32:43\";i:8;s:19:\"2023-02-08 21:17:54\";i:9;s:19:\"2023-02-09 00:27:54\";i:10;s:19:\"2023-02-09 07:32:00\";i:11;s:19:\"2023-02-09 18:51:19\";i:12;s:19:\"2023-02-10 10:40:52\";i:13;s:19:\"2023-02-10 12:11:51\";i:14;s:19:\"2023-02-10 13:12:52\";i:15;s:19:\"2023-02-11 10:24:14\";i:16;s:19:\"2023-02-11 18:22:36\";i:17;s:19:\"2023-02-11 21:45:37\";i:18;s:19:\"2023-02-11 21:45:39\";i:19;s:19:\"2023-02-11 21:45:43\";i:20;s:19:\"2023-02-11 22:34:10\";i:21;s:19:\"2023-02-11 22:34:26\";i:22;s:19:\"2023-02-12 07:16:18\";i:23;s:19:\"2023-02-12 09:46:12\";i:24;s:19:\"2023-02-12 12:07:57\";i:25;s:19:\"2023-02-12 12:22:51\";i:26;s:19:\"2023-02-12 16:43:03\";i:27;s:19:\"2023-02-12 19:36:39\";i:28;s:19:\"2023-02-13 01:15:25\";i:29;s:19:\"2023-02-13 04:57:52\";i:30;s:19:\"2023-02-13 05:09:43\";i:31;s:19:\"2023-02-13 05:53:25\";i:32;s:19:\"2023-02-13 06:47:15\";i:33;s:19:\"2023-02-13 07:27:47\";i:34;s:19:\"2023-02-13 08:16:10\";i:35;s:19:\"2023-02-13 10:08:59\";i:36;s:19:\"2023-02-13 10:10:03\";i:37;s:19:\"2023-02-13 10:11:17\";i:38;s:19:\"2023-02-13 11:03:35\";i:39;s:19:\"2023-02-13 11:10:29\";i:40;s:19:\"2023-02-13 11:41:42\";i:41;s:19:\"2023-02-13 11:51:06\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:59:\"The $control_id argument is deprecated since version 3.5.0!\";s:4:\"file\";s:94:\"/home/ballielektrik/public_html/wp-content/plugins/elementor/modules/dev-tools/deprecation.php\";s:4:\"line\";i:301;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:94:\"/home/ballielektrik/public_html/wp-content/plugins/elementor/modules/dev-tools/deprecation.php\";s:7:\"\0*\0line\";i:301;}s:32:\"6e7f9f93bf721c626ef56984fb11d704\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-09 23:46:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-09 23:46:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"95e56569be08f8bfdcb70924ec08d250\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-09 23:46:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-09 23:46:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"a12d68edfc21e9da3e177c0f0e025504\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-09 23:46:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-09 23:46:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"77b6662effa53a0db4b854864766f5be\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-09 23:46:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.5.4\";s:2:\"to\";s:6:\"3.16.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-09 23:46:25\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.5.4\";s:2:\"to\";s:6:\"3.16.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"3de8a6b6f315be0fd0f30c010da17213\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-17 22:16:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.16.5\";s:2:\"to\";s:6:\"3.16.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-17 22:16:35\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.16.5\";s:2:\"to\";s:6:\"3.16.6\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"a922be7adf3ad954edd877b40621feaf\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-17 22:16:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-17 22:16:35\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"047e08bd7c248aba3849d3b700178e3c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-17 22:16:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-17 22:16:35\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"b66fd0b63b437a75240803ba0a904fc1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-17 22:16:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-17 22:16:35\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"f303a605af1c6bb0c4595796d1a72a08\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-17 22:16:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:59:\"Elementor/Upgrades - _v_3_17_0_site_settings_updates Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-17 22:16:35\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:59:\"Elementor/Upgrades - _v_3_17_0_site_settings_updates Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"db5b0c187984d6c8ee17f674cf56947e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-17 22:16:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:61:\"Elementor/Upgrades - _v_3_17_0_site_settings_updates Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-17 22:16:35\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:61:\"Elementor/Upgrades - _v_3_17_0_site_settings_updates Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"b1bd629d56633f6dbcce45e8c969c9ef\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-17 22:16:35\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.16.5\";s:2:\"to\";s:6:\"3.16.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-17 22:16:35\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.16.5\";s:2:\"to\";s:6:\"3.16.6\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"5c6d67fb1be2c9984cf04e19efda1b4c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-10-17 22:16:36\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.16.5\";s:2:\"to\";s:6:\"3.16.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-10-17 22:16:36\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.16.5\";s:2:\"to\";s:6:\"3.16.6\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"b1f31fc8d394351f48b795e54d2e8119\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-16 23:14:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-16 23:14:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"79cf6aebf719d0792d7809b134c42cea\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-16 23:14:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-16 23:14:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"c2eb28c349ed0e1f822a661294606375\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-16 23:14:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-16 23:14:26\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"a3c5b3f300c277bcd7056dd08fbc88ac\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-16 23:14:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:59:\"Elementor/Upgrades - _v_3_17_0_site_settings_updates Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-16 23:14:26\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:59:\"Elementor/Upgrades - _v_3_17_0_site_settings_updates Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"6512da719a32ed1a855f4024323cb696\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-16 23:14:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:61:\"Elementor/Upgrades - _v_3_17_0_site_settings_updates Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-16 23:14:26\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:61:\"Elementor/Upgrades - _v_3_17_0_site_settings_updates Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"b558eb07e071dbd29508687b99757fa4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-16 23:14:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.16.6\";s:2:\"to\";s:6:\"3.26.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-16 23:14:26\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.16.6\";s:2:\"to\";s:6:\"3.26.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ba4e0475ab0c787aa57a66fe6e19610c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-19 15:05:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.26.0\";s:2:\"to\";s:6:\"3.26.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-19 15:05:09\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.26.0\";s:2:\"to\";s:6:\"3.26.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"bb8d1a2b1545c97d8b5cf2558f77c582\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-21 20:27:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-21 20:27:52\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"9465ea089f5fdec7fafd7ca9bb9d113c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-21 20:27:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-21 20:27:52\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"01ecda065e2c3d5aa3fa3d0d8d525eed\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-21 20:27:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-21 20:27:52\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"0c35a6a3e1396cec413dfdbf6380d83c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-21 20:27:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.26.0\";s:2:\"to\";s:6:\"3.26.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-21 20:27:52\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.26.0\";s:2:\"to\";s:6:\"3.26.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"9ca042c0a67a92e8699dd8f3f24fb809\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2024-12-22 16:53:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.26.2\";s:2:\"to\";s:6:\"3.26.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2024-12-22 16:53:45\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.26.2\";s:2:\"to\";s:6:\"3.26.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"15fb59696d204893a2414cfd0c7d4ae2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-07 16:00:46\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-07 16:00:46\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"fa4d28e5e0e659ab12d0d54411430c66\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-07 16:00:46\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-07 16:00:46\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"8135e16eea42149d70fb6c162cf1c89c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-07 16:00:46\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-07 16:00:46\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"f2aa29707a345981971e4b01b2cdae24\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-07 16:00:46\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.26.2\";s:2:\"to\";s:6:\"3.27.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-07 16:00:46\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.26.2\";s:2:\"to\";s:6:\"3.27.6\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"48a47c134ddcace67b2bfb54f7ecc240\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-14 02:28:08\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.27.7\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-14 02:28:08\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.27.7\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"156a9c5f5d1a902fb3055325bfa5e102\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-02 15:20:12\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-02 15:20:12\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"6c3ad3dcd71aac83b306d48c3c1208e6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-02 15:20:12\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-02 15:20:12\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"8ab90d08b045d2794ce22a0832554678\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-02 15:20:12\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-02 15:20:12\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"9982cfb41b17c661dc0e09d5170d271d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-02 15:20:12\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-02 15:20:12\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"b56f284f375c2f2d465c965565304e51\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-22 16:18:49\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.28.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-22 16:18:49\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.28.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"8fc007c8e6d7ca8609547e70ee59a26a\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-07-31 12:06:35\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:19:\"Undefined index: id\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-07-31 12:06:35\";i:1;s:19:\"2025-08-22 13:19:33\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:19:\"Undefined index: id\";s:4:\"file\";s:116:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:2488;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:116:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:7:\"\0*\0line\";i:2488;}s:32:\"64bf0d7849fc26a34dfa0fd83f8a3b36\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-23 02:13:31\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-23 02:13:31\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"25c11cb37f6e209e16bc5f2dab04e758\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-23 02:13:31\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-23 02:13:31\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"756a840f18f21da96ec56467d524fa8f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-23 02:13:31\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-23 02:13:31\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"dfb8e81479c2282de03197cf1e417bd5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2026-02-23 02:13:31\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.35.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2026-02-23 02:13:31\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.35.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}}", "off");
INSERT INTO `nqcpo_options` VALUES("1819", "mtswpt_translations", "a:3:{s:6:\"themes\";a:1:{s:19:\"mtswpt_theme_kriate\";a:2:{s:8:\"opt_name\";s:19:\"mtswpt_theme_kriate\";s:4:\"name\";s:6:\"Kriate\";}}s:7:\"plugins\";a:0:{}s:16:\"strings_per_page\";i:20;}", "yes");
INSERT INTO `nqcpo_options` VALUES("1820", "mtswpt_domains", "a:32:{s:11:\"maintenance\";s:62:\"/home/ballielektrik/public_html/wp-content/plugins/maintenance\";s:15:\"litespeed-cache\";s:87:\"/home/ballielektrik/public_html/wp-content/plugins/litespeed-cache/lang/litespeed-cache\";s:15:\"my-wp-translate\";s:92:\"/home/ballielektrik/public_html/wp-content/plugins/my-wp-translate/languages/my-wp-translate\";s:15:\"redux-framework\";s:103:\"/home/ballielektrik/public_html/wp-content/plugins/redux-framework/redux-core/languages/redux-framework\";s:5:\"tgmpa\";s:72:\"/home/ballielektrik/public_html/wp-content/themes/kriate/languages/tgmpa\";s:33:\"file-select-control-for-elementor\";s:84:\"/home/ballielektrik/public_html/wp-content/plugins/file-select-control-for-elementor\";s:6:\"kriate\";s:74:\"/home/ballielektrik/public_html/wp-content/themes/kriate/languages//kriate\";s:4:\"cmb2\";s:65:\"/home/ballielektrik/public_html/wp-content/plugins/languages/cmb2\";s:6:\"worker\";s:57:\"/home/ballielektrik/public_html/wp-content/plugins/worker\";s:21:\"one-click-demo-import\";s:104:\"/home/ballielektrik/public_html/wp-content/plugins/one-click-demo-import/languages/one-click-demo-import\";s:15:\"classic-widgets\";s:92:\"/home/ballielektrik/public_html/wp-content/plugins/classic-widgets/languages/classic-widgets\";s:9:\"ingeniofy\";s:70:\"/home/ballielektrik/public_html/wp-content/plugins/ingeniofy/ingeniofy\";s:13:\"extendify-sdk\";s:154:\"/home/ballielektrik/public_html/wp-content/plugins/home/ballielektrik/public_html/wp-content/plugins/redux-framework/extendify-sdk/languages/extendify-sdk\";s:9:\"extendify\";s:150:\"/home/ballielektrik/public_html/wp-content/plugins/home/ballielektrik/public_html/wp-content/plugins/redux-framework/extendify-sdk/languages/extendify\";s:15:\"twentytwentytwo\";s:91:\"/home/ballielektrik/public_html/wp-content/themes/twentytwentytwo/languages/twentytwentytwo\";s:11:\"js_composer\";s:81:\"/home/ballielektrik/public_html/wp-content/plugins/js_composer/locale/js_composer\";s:9:\"elementor\";s:97:\"/home/u838283570/domains/www.ballielektrik.com/public_html/wp-content/plugins/elementor/elementor\";s:18:\"woocommerce_inputs\";s:111:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/woocommerce_inputs/woocommerce_inputs\";s:21:\"wp-wiener-informatics\";s:117:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/wp-wiener-informatics/wp-wiener-informatics\";s:17:\"wp-network-bailey\";s:109:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/wp-network-bailey/wp-network-bailey\";s:14:\"contact-form-7\";s:103:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/contact-form-7/contact-form-7\";s:15:\"wp-file-manager\";s:105:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/wp-file-manager/wp-file-manager\";s:13:\"wp-kernel-app\";s:101:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/wp-kernel-app/wp-kernel-app\";s:21:\"wp-maintenance-plexus\";s:117:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/wp-maintenance-plexus/wp-maintenance-plexus\";s:20:\"wp-cybersociology-or\";s:115:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/wp-cybersociology-or/wp-cybersociology-or\";s:15:\"guilty-platypus\";s:105:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/guilty_platypus/guilty-platypus\";s:25:\"wordpress-image-optimizer\";s:123:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/wordpressimageoptimizer/wordpress-image-optimizer\";s:9:\"wp-compat\";s:93:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/wp-compat/wp-compat\";s:16:\"wp-s-image-cache\";s:105:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/wpsimagescache/wp-s-image-cache\";s:19:\"wp-nervous-guidance\";s:113:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/wp-nervous-guidance/wp-nervous-guidance\";s:16:\"microsoft-custom\";s:107:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/microsoft-custom/microsoft-custom\";s:7:\"ads-txt\";s:99:\"/home/u838283570/domains/ballielektrik.com/public_html/wp-content/plugins/slider-1756999364/ads-txt\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("1821", "mtswpt_theme_kriate", "a:1:{s:9:\"translate\";s:1:\"1\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("1822", "mtswpt_theme_kriate_strings", "a:7:{s:4:\"Home\";s:8:\"Anasayfa\";s:9:\"Posted By\";s:5:\"Yazar\";s:20:\"Articles Posted by, \";s:34:\"Tarafından gönderilen makaleler,\";s:10:\"Comments *\";s:10:\"Yorumlar *\";s:19:\"Leave Your Comments\";s:26:\"Yorumlarınızı bırakın\";s:20:\"Comments are closed.\";s:15:\"Yoruma kapalı.\";s:14:\"Newer Comments\";s:18:\"daha yeni yorumlar\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("1960", "redux-framework_allow_tracking", "no", "yes");
INSERT INTO `nqcpo_options` VALUES("1961", "redux-framework_tracking_notice", "hide", "yes");
INSERT INTO `nqcpo_options` VALUES("1962", "redux-framework_tracking_skipped", "yes", "yes");
INSERT INTO `nqcpo_options` VALUES("1963", "elementor_allow_tracking", "no", "yes");
INSERT INTO `nqcpo_options` VALUES("1964", "elementor_tracker_notice", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("2170", "elementor_controls_usage", "a:2:{s:4:\"page\";a:13:{s:5:\"image\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:3:{s:5:\"image\";i:4;s:10:\"image_size\";i:3;s:5:\"align\";i:3;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:3:{s:5:\"width\";i:3;s:5:\"space\";i:3;s:6:\"height\";i:3;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:31;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:6:\"layout\";a:1:{s:12:\"_inline_size\";i:31;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:22;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:17:\"section_structure\";a:1:{s:9:\"structure\";i:5;}s:14:\"section_layout\";a:4:{s:6:\"layout\";i:13;s:3:\"gap\";i:13;s:15:\"stretch_section\";i:13;s:6:\"_title\";i:13;}}s:5:\"style\";a:1:{s:18:\"section_background\";a:2:{s:21:\"background_background\";i:4;s:16:\"background_color\";i:4;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:1:{s:6:\"margin\";i:4;}}}}s:7:\"heading\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_title\";a:1:{s:5:\"title\";i:2;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:4:{s:11:\"title_color\";i:2;s:21:\"typography_typography\";i:2;s:22:\"typography_font_family\";i:2;s:22:\"typography_font_weight\";i:2;}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:2:{s:6:\"editor\";i:2;s:10:\"column_gap\";i:1;}}}}s:6:\"spacer\";a:2:{s:5:\"count\";i:6;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_spacer\";a:1:{s:5:\"space\";i:5;}}}}s:11:\"facts-count\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:4:\"list\";i:3;}}}}s:11:\"main_slider\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:2:{s:4:\"list\";i:2;s:11:\"chose_style\";i:2;}}}}s:14:\"about_us_intro\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:13:{s:11:\"chose_style\";i:2;s:15:\"content_caption\";i:2;s:15:\"content_heading\";i:2;s:19:\"content_description\";i:2;s:13:\"colored_title\";i:2;s:7:\"orderby\";i:2;s:11:\"words_count\";i:2;s:10:\"fact_count\";i:2;s:11:\"fact_suffix\";i:2;s:10:\"fact_title\";i:2;s:10:\"main_image\";i:2;s:16:\"item_description\";i:2;s:15:\"select_category\";i:2;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:2;}}}}s:13:\"services_grid\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:10:{s:18:\"content_subcaption\";i:2;s:15:\"content_heading\";i:2;s:15:\"content_caption\";i:2;s:16:\"background-image\";i:2;s:15:\"select_category\";i:2;s:7:\"orderby\";i:2;s:11:\"words_count\";i:2;s:10:\"show_facts\";i:2;s:4:\"list\";i:2;s:11:\"chose_style\";i:2;}}s:8:\"advanced\";a:1:{s:19:\"_section_background\";a:2:{s:22:\"_background_background\";i:2;s:17:\"_background_color\";i:2;}}}}s:9:\"image-box\";a:2:{s:5:\"count\";i:12;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:5:{s:5:\"image\";i:12;s:14:\"thumbnail_size\";i:12;s:26:\"thumbnail_custom_dimension\";i:4;s:10:\"title_text\";i:12;s:16:\"description_text\";i:12;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:2:{s:11:\"image_space\";i:12;s:10:\"image_size\";i:12;}}}}s:10:\"cta-simple\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:5:{s:13:\"element_title\";i:1;s:15:\"element_caption\";i:1;s:11:\"button_text\";i:1;s:10:\"button_url\";i:1;s:16:\"background-image\";i:1;}}}}s:9:\"blog_grid\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:7:{s:15:\"content_caption\";i:2;s:15:\"content_heading\";i:2;s:11:\"words_count\";i:2;s:11:\"button_text\";i:2;s:15:\"select_category\";i:2;s:11:\"posts_count\";i:2;s:10:\"button_url\";i:2;}}}}}s:7:\"wp-page\";a:15:{s:9:\"infoboxes\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:4:\"list\";i:1;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:33;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:6:\"layout\";a:1:{s:12:\"_inline_size\";i:33;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:23;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:4:{s:6:\"layout\";i:14;s:3:\"gap\";i:14;s:15:\"stretch_section\";i:14;s:6:\"_title\";i:11;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:6;}}s:5:\"style\";a:1:{s:18:\"section_background\";a:2:{s:21:\"background_background\";i:4;s:16:\"background_color\";i:4;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:1:{s:6:\"margin\";i:4;}}}}s:16:\"contact_form_map\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:7:{s:12:\"location_lat\";i:1;s:13:\"location_long\";i:1;s:10:\"form_title\";i:1;s:12:\"form_caption\";i:1;s:12:\"social_title\";i:1;s:4:\"list\";i:1;s:14:\"form_shortcode\";i:1;}}}}s:10:\"faqs-block\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"content_section\";a:4:{s:16:\"heading_subtitle\";i:1;s:13:\"heading_title\";i:1;s:4:\"list\";i:1;s:8:\"bg-image\";i:1;}}}}s:13:\"services_grid\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:10:{s:18:\"content_subcaption\";i:2;s:15:\"content_heading\";i:2;s:15:\"content_caption\";i:2;s:16:\"background-image\";i:2;s:15:\"select_category\";i:2;s:7:\"orderby\";i:2;s:11:\"words_count\";i:2;s:10:\"show_facts\";i:2;s:4:\"list\";i:2;s:11:\"chose_style\";i:2;}}s:8:\"advanced\";a:1:{s:19:\"_section_background\";a:2:{s:22:\"_background_background\";i:2;s:17:\"_background_color\";i:2;}}}}s:9:\"image-box\";a:2:{s:5:\"count\";i:12;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:5:{s:5:\"image\";i:12;s:14:\"thumbnail_size\";i:12;s:26:\"thumbnail_custom_dimension\";i:4;s:10:\"title_text\";i:12;s:16:\"description_text\";i:12;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:2:{s:11:\"image_space\";i:12;s:10:\"image_size\";i:12;}}}}s:6:\"spacer\";a:2:{s:5:\"count\";i:6;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_spacer\";a:1:{s:5:\"space\";i:4;}}}}s:11:\"facts-count\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:4:\"list\";i:3;}}}}s:10:\"cta-simple\";a:2:{s:5:\"count\";i:2;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:5:{s:13:\"element_title\";i:2;s:15:\"element_caption\";i:2;s:11:\"button_text\";i:2;s:10:\"button_url\";i:2;s:16:\"background-image\";i:2;}}}}s:5:\"image\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:3:{s:5:\"image\";i:4;s:10:\"image_size\";i:2;s:5:\"align\";i:2;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:3:{s:5:\"width\";i:2;s:5:\"space\";i:2;s:6:\"height\";i:2;}}}}s:7:\"heading\";a:2:{s:5:\"count\";i:4;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_title\";a:1:{s:5:\"title\";i:4;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:4:{s:11:\"title_color\";i:4;s:21:\"typography_typography\";i:4;s:22:\"typography_font_family\";i:4;s:22:\"typography_font_weight\";i:4;}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:2:{s:6:\"editor\";i:3;s:10:\"column_gap\";i:2;}}}}s:11:\"main_slider\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:2:{s:4:\"list\";i:1;s:11:\"chose_style\";i:1;}}}}s:9:\"blog_grid\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:7:{s:15:\"content_caption\";i:1;s:15:\"content_heading\";i:1;s:11:\"words_count\";i:1;s:11:\"button_text\";i:1;s:15:\"select_category\";i:1;s:11:\"posts_count\";i:1;s:10:\"button_url\";i:1;}}}}}}", "no");
INSERT INTO `nqcpo_options` VALUES("2176", "auto_update_plugins", "a:11:{i:0;s:35:\"classic-widgets/classic-widgets.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:23:\"elementor/elementor.php\";i:3;s:19:\"ingeniofy/index.php\";i:4;s:33:\"classic-editor/classic-editor.php\";i:5;s:35:\"litespeed-cache/litespeed-cache.php\";i:6;s:23:\"loco-translate/loco.php\";i:7;s:15:\"worker/init.php\";i:8;s:35:\"my-wp-translate/my-wp-translate.php\";i:9;s:47:\"one-click-demo-import/one-click-demo-import.php\";i:10;s:35:\"redux-framework/redux-framework.php\";}", "no");
INSERT INTO `nqcpo_options` VALUES("2444", "litespeed.conf.optm-ucss_inline", "", "yes");
INSERT INTO `nqcpo_options` VALUES("2445", "litespeed.conf.optm-ucss_exc", "[]", "yes");
INSERT INTO `nqcpo_options` VALUES("2453", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:22:\"info@ballielektrik.com\";s:7:\"version\";s:5:\"6.9.1\";s:9:\"timestamp\";i:1771714372;}", "off");
INSERT INTO `nqcpo_options` VALUES("2626", "litespeed.admin_display.messages", "-1", "yes");
INSERT INTO `nqcpo_options` VALUES("3563", "litespeed.conf.__activation", "-1", "yes");
INSERT INTO `nqcpo_options` VALUES("3564", "litespeed.purge.queue", "-1", "yes");
INSERT INTO `nqcpo_options` VALUES("3565", "litespeed.purge.queue2", "-1", "yes");
INSERT INTO `nqcpo_options` VALUES("3594", "litespeed.data.upgrading", "-1", "yes");
INSERT INTO `nqcpo_options` VALUES("4338", "recovery_mode_email_last_sent", "1771802915", "yes");
INSERT INTO `nqcpo_options` VALUES("4908", "litespeed.gui.lscwp_whm_install", "-1", "yes");
INSERT INTO `nqcpo_options` VALUES("4909", "litespeed.gui.dismiss", "-1", "yes");
INSERT INTO `nqcpo_options` VALUES("4910", "litespeed.admin_display.msg_pin", "-1", "yes");
INSERT INTO `nqcpo_options` VALUES("5457", "db_upgraded", "", "on");
INSERT INTO `nqcpo_options` VALUES("7628", "elementor_events_db_version", "1.0.0", "no");
INSERT INTO `nqcpo_options` VALUES("11284", "secret_key", "Ar,EKNx/QWG~NSBVncG<xVDnJp.3MW:-LZoUoDTAH jl?[)rJ@K>^Gi~p=D%.>@ ", "no");
INSERT INTO `nqcpo_options` VALUES("11945", "user_count", "12", "off");
INSERT INTO `nqcpo_options` VALUES("12725", "litespeed.conf.debug-exc_strings", "[]", "yes");
INSERT INTO `nqcpo_options` VALUES("12726", "litespeed.conf.media-vpi", "", "yes");
INSERT INTO `nqcpo_options` VALUES("12727", "litespeed.conf.media-vpi_cron", "", "yes");
INSERT INTO `nqcpo_options` VALUES("12728", "litespeed.conf.qc-token", "", "yes");
INSERT INTO `nqcpo_options` VALUES("12729", "litespeed.conf.qc-nameservers", "", "yes");
INSERT INTO `nqcpo_options` VALUES("14825", "extendify_active_tests", "a:2:{s:22:\"remove-dont-see-inputs\";s:1:\"A\";s:19:\"launch-site-vs-next\";s:1:\"A\";}", "yes");
INSERT INTO `nqcpo_options` VALUES("16328", "litespeed.conf.optm-ucss_file_exc_inline", "[]", "yes");
INSERT INTO `nqcpo_options` VALUES("16514", "extendify_first_installed_version", "1.0.1", "yes");
INSERT INTO `nqcpo_options` VALUES("16515", "extendify_site_id", "86fd7c4b-093a-41a1-9a34-29d9ada57ee4", "yes");
INSERT INTO `nqcpo_options` VALUES("28318", "litespeed.conf.optm-js_delay_inc", "[]", "yes");
INSERT INTO `nqcpo_options` VALUES("29961", "litespeed.conf.optm-dns_preconnect", "[]", "yes");
INSERT INTO `nqcpo_options` VALUES("30735", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `nqcpo_options` VALUES("31914", "litespeed.conf.cache-vary_cookies", "[]", "yes");
INSERT INTO `nqcpo_options` VALUES("31915", "litespeed.conf.media-preload_featured", "", "yes");
INSERT INTO `nqcpo_options` VALUES("39469", "litespeed.conf.cache-ajax_ttl", "[]", "auto");
INSERT INTO `nqcpo_options` VALUES("39470", "litespeed.conf.debug-collapse_qs", "", "auto");
INSERT INTO `nqcpo_options` VALUES("39471", "litespeed.conf.optm-html_skip_comment", "[]", "auto");
INSERT INTO `nqcpo_options` VALUES("45975", "elementor_checklist", "{\"last_opened_timestamp\":-1,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"editor_visit_count\":0,\"should_open_in_editor\":false}", "auto");
INSERT INTO `nqcpo_options` VALUES("49925", "elementor_connect_site_key", "25cd8e78f4ee9b292ace8417ad9d3de0", "auto");
INSERT INTO `nqcpo_options` VALUES("56450", "vc_version", "8.2", "auto");
INSERT INTO `nqcpo_options` VALUES("57714", "wpb_js_composer_license_activation_notified", "yes", "auto");
INSERT INTO `nqcpo_options` VALUES("57718", "wpb_license_errors", "a:0:{}", "auto");
INSERT INTO `nqcpo_options` VALUES("59180", "elementor_landing_pages_activation", "0", "auto");
INSERT INTO `nqcpo_options` VALUES("59184", "_elementor_local_google_fonts", "a:4:{i:0;b:0;s:6:\"roboto\";a:2:{s:3:\"url\";s:92:\"http://localhost:8888/ballielektrik/wp-content/uploads/elementor/google-fonts/css/roboto.css\";s:7:\"version\";i:1771814832;}s:7:\"poppins\";a:2:{s:3:\"url\";s:93:\"http://localhost:8888/ballielektrik/wp-content/uploads/elementor/google-fonts/css/poppins.css\";s:7:\"version\";i:1771814856;}s:10:\"robotoslab\";a:2:{s:3:\"url\";s:96:\"http://localhost:8888/ballielektrik/wp-content/uploads/elementor/google-fonts/css/robotoslab.css\";s:7:\"version\";i:1771814905;}}", "auto");
INSERT INTO `nqcpo_options` VALUES("60155", "litespeed.conf.qc-cname", "", "auto");
INSERT INTO `nqcpo_options` VALUES("61399", "litespeed.crawler.bypass_list", "[]", "auto");
INSERT INTO `nqcpo_options` VALUES("61400", "litespeed.preset._summary", "{\"preset\":\"advanced\",\"preset_timestamp\":1743676661}", "auto");
INSERT INTO `nqcpo_options` VALUES("61402", "litespeed.img_optm._summary", "{\"next_post_id\":0,\"is_running\":0}", "auto");
INSERT INTO `nqcpo_options` VALUES("61432", "litespeed.avatar._summary", "{\"curr_request\":0,\"last_spent\":0,\"last_request\":1771801246}", "auto");
INSERT INTO `nqcpo_options` VALUES("62156", "litespeed.css._summary", "[]", "auto");
INSERT INTO `nqcpo_options` VALUES("64755", "litespeed.conf.optm-ccss_whitelist", "[]", "auto");
INSERT INTO `nqcpo_options` VALUES("69398", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `nqcpo_options` VALUES("70581", "custom_redirect_install_date", "1748583342", "auto");
INSERT INTO `nqcpo_options` VALUES("90104", "litespeed.conf.cdn-cloudflare_clear", "", "auto");
INSERT INTO `nqcpo_options` VALUES("93044", "fm_key", "VBr0hAmX5tnI7xU1veHWDaYMw", "auto");
INSERT INTO `nqcpo_options` VALUES("93048", "filemanager_email_verified_1", "yes", "auto");
INSERT INTO `nqcpo_options` VALUES("93052", "18d6f11cf1ac875023c5cfa9a7928e98", "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", "yes");
INSERT INTO `nqcpo_options` VALUES("93053", "7c1a86cab2f0095620df8a67cf75af5f", "0fbadbe30bfc6cf852680a70e6b0403b", "yes");
INSERT INTO `nqcpo_options` VALUES("93061", "wp_debug_data", "a:6:{i:0;s:104:\"10DifferentTextBlocks page mode block num - 9 permalink - http://localhost:8888/ballielektrik/official-site-2/\";i:1;s:50:\"1750674681||www.ballielektrik.com||header position\";i:2;s:123:\"1750761081||www.ballielektrik.com||10DifferentTextBlocks page mode block num - 4 permalink - http://localhost:8888/ballielektrik/\";i:3;s:50:\"1750761081||www.ballielektrik.com||header position\";i:4;s:123:\"1750761233||www.ballielektrik.com||10DifferentTextBlocks page mode block num - 4 permalink - http://localhost:8888/ballielektrik/\";i:5;s:50:\"1750761233||www.ballielektrik.com||header position\";}", "off");
INSERT INTO `nqcpo_options` VALUES("93063", "wp_custom_range", "a:2:{s:6:\"ranges\";a:103:{i:0;s:10:\"8.8.4.0/24\";i:1;s:10:\"8.8.8.0/24\";i:2;s:13:\"8.34.208.0/20\";i:3;s:13:\"8.35.192.0/20\";i:4;s:14:\"23.236.48.0/20\";i:5;s:15:\"23.251.128.0/19\";i:6;s:11:\"34.0.0.0/15\";i:7;s:11:\"34.2.0.0/16\";i:8;s:11:\"34.3.0.0/23\";i:9;s:11:\"34.3.3.0/24\";i:10;s:11:\"34.3.4.0/24\";i:11;s:11:\"34.3.8.0/21\";i:12;s:12:\"34.3.16.0/20\";i:13;s:12:\"34.3.32.0/19\";i:14;s:12:\"34.3.64.0/18\";i:15;s:11:\"34.4.0.0/14\";i:16;s:11:\"34.8.0.0/13\";i:17;s:12:\"34.16.0.0/12\";i:18;s:12:\"34.32.0.0/11\";i:19;s:12:\"34.64.0.0/10\";i:20;s:13:\"34.128.0.0/10\";i:21;s:13:\"35.184.0.0/13\";i:22;s:13:\"35.192.0.0/14\";i:23;s:13:\"35.196.0.0/15\";i:24;s:13:\"35.198.0.0/16\";i:25;s:13:\"35.199.0.0/17\";i:26;s:15:\"35.199.128.0/18\";i:27;s:13:\"35.200.0.0/13\";i:28;s:13:\"35.208.0.0/12\";i:29;s:13:\"35.224.0.0/12\";i:30;s:13:\"35.240.0.0/13\";i:31;s:15:\"57.140.192.0/18\";i:32;s:14:\"64.15.112.0/20\";i:33;s:15:\"64.233.160.0/19\";i:34;s:14:\"66.22.228.0/23\";i:35;s:13:\"66.102.0.0/20\";i:36;s:14:\"66.249.64.0/19\";i:37;s:14:\"70.32.128.0/19\";i:38;s:14:\"72.14.192.0/18\";i:39;s:14:\"74.114.24.0/21\";i:40;s:13:\"74.125.0.0/16\";i:41;s:14:\"104.154.0.0/15\";i:42;s:14:\"104.196.0.0/14\";i:43;s:16:\"104.237.160.0/19\";i:44;s:16:\"107.167.160.0/19\";i:45;s:16:\"107.178.192.0/18\";i:46;s:14:\"108.59.80.0/20\";i:47;s:16:\"108.170.192.0/18\";i:48;s:14:\"108.177.0.0/17\";i:49;s:14:\"130.211.0.0/16\";i:50;s:15:\"136.22.160.0/20\";i:51;s:15:\"136.22.176.0/21\";i:52;s:15:\"136.22.184.0/23\";i:53;s:15:\"136.22.186.0/24\";i:54;s:14:\"136.124.0.0/15\";i:55;s:14:\"142.250.0.0/15\";i:56;s:14:\"146.148.0.0/17\";i:57;s:15:\"152.65.208.0/22\";i:58;s:15:\"152.65.214.0/23\";i:59;s:15:\"152.65.218.0/23\";i:60;s:15:\"152.65.222.0/23\";i:61;s:15:\"152.65.224.0/19\";i:62;s:16:\"162.120.128.0/17\";i:63;s:16:\"162.216.148.0/22\";i:64;s:16:\"162.222.176.0/21\";i:65;s:15:\"172.110.32.0/21\";i:66;s:14:\"172.217.0.0/16\";i:67;s:14:\"172.253.0.0/16\";i:68;s:14:\"173.194.0.0/16\";i:69;s:16:\"173.255.112.0/20\";i:70;s:16:\"192.104.160.0/23\";i:71;s:15:\"192.158.28.0/22\";i:72;s:14:\"192.178.0.0/15\";i:73;s:14:\"193.186.4.0/24\";i:74;s:15:\"199.36.154.0/23\";i:75;s:15:\"199.36.156.0/24\";i:76;s:16:\"199.192.112.0/22\";i:77;s:16:\"199.223.232.0/21\";i:78;s:16:\"207.223.160.0/20\";i:79;s:15:\"208.65.152.0/22\";i:80;s:15:\"208.68.108.0/22\";i:81;s:15:\"208.81.188.0/22\";i:82;s:16:\"208.117.224.0/19\";i:83;s:15:\"209.85.128.0/17\";i:84;s:15:\"216.58.192.0/19\";i:85;s:14:\"216.73.80.0/20\";i:86;s:15:\"216.239.32.0/19\";i:87;s:16:\"216.252.220.0/22\";i:88;s:14:\"2001:4860::/32\";i:89;s:14:\"2404:6800::/32\";i:90;s:14:\"2404:f340::/32\";i:91;s:14:\"2600:1900::/28\";i:92;s:14:\"2605:ef80::/32\";i:93;s:12:\"2606:40::/32\";i:94;s:14:\"2606:73c0::/32\";i:95;s:20:\"2607:1c0:241:40::/60\";i:96;s:17:\"2607:1c0:300::/40\";i:97;s:14:\"2607:f8b0::/32\";i:98;s:18:\"2620:11a:a000::/40\";i:99;s:18:\"2620:120:e000::/40\";i:100;s:13:\"2800:3f0::/32\";i:101;s:14:\"2a00:1450::/32\";i:102;s:14:\"2c0f:fb50::/32\";}s:9:\"timestamp\";i:1750761087;}", "on");
INSERT INTO `nqcpo_options` VALUES("93583", "tie_token_19659555", "***********************************", "auto");
INSERT INTO `nqcpo_options` VALUES("93584", "tie_jannah_custom_code", "***********************************", "auto");
INSERT INTO `nqcpo_options` VALUES("104751", "e_editor_counter", "12", "auto");
INSERT INTO `nqcpo_options` VALUES("104752", "_elementor_free_to_pro_upsell", "a:2:{s:7:\"timeout\";i:1771820752;s:5:\"value\";s:723:\"[{\"id\":\"animated_headline\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/animated_headline.jpg\"},{\"id\":\"video_playlist\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/video_playlist.jpg\"},{\"id\":\"cta\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/cta.jpg\"},{\"id\":\"testimonial_widget\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/testimonial_widget.jpg\"},{\"id\":\"image_carousel\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/image_carousel.jpg\"},{\"id\":\"connect-pro-upgrade\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/connect-pro-upgrade.jpg\"}]\";}", "off");
INSERT INTO `nqcpo_options` VALUES("104753", "_elementor_notifications_data", "a:2:{s:7:\"timeout\";i:1771820752;s:5:\"value\";s:12452:\"[{\"id\":\"components-3.35\",\"title\":\"Components\",\"description\":\"Build modular, reusable sections that update everywhere and decide how much control to give away to your team or clients.\",\"topic\":\"Version 4 beta\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/components-3-35.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-components-3.35-blog\",\"readMoreText\":\"Learn More\"},{\"id\":\"one-launch\",\"title\":\"Introducing Elementor One\",\"description\":\"The complete website building experience. All the tools to create, optimize, and manage websites, unified under one roof.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/one-launch.png\",\"chipTags\":[\"New Launch\"],\"cta\":\"Explore Elementor One\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/launch-whats-new\"},{\"id\":\"atomic-tabs-3.34\",\"title\":\"Atomic Tabs\",\"description\":\"Nest any type of content inside tab triggers or content panels, unlocking a truly atomic way of design.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/tabs-3.34.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.34-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"interactions-3.34\",\"title\":\"Entrance Interactions\",\"description\":\"Add subtle, performance\\u2011minded Fade, Scale or Slide effects to your elements from the new Interaction panel.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/interactions-3.34.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.34-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"variables-manager-3.33\",\"title\":\"Variables Manager\",\"description\":\"Centralize and control all your color, typography, and size tokens for consistent, scalable design systems.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-variables-manager.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"custom-css-3.33\",\"title\":\"Custom CSS\",\"description\":\"Write isolated, responsive, and state-based CSS directly inside atomic elements for pixel-perfect control.\",\"topic\":\"Elementor Pro 3.33\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-custom-css.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"custom-css-3.33\",\"title\":\"Custom CSS\",\"description\":\"Write isolated, responsive, and state-based CSS directly inside atomic elements for pixel-perfect control.\",\"topic\":\"Elementor Pro 3.33\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-custom-css.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-custom-css\\/\"},{\"id\":\"blend-mode-3.33\",\"title\":\"Blend Mode\",\"description\":\"Layer and blend visuals to create depth, contrast, and cinematic design effects.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.33-blend.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.33-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"transform-3.32\",\"title\":\"Design with depth using Transform\",\"description\":\"Move, scale, rotate, and skew any element with ease. Transform controls add depth, stacked effects, and seamless States for hover, focus, and active micro-interactions.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transform.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-size-variable\\/\"},{\"id\":\"transitions-3.32\",\"title\":\"Smooth interactions with Transitions\",\"description\":\"Bring polish to every interaction. Transitions let you animate style changes smoothly between states. In Pro, layer multiple transitions by property for refined, modern micro-animations.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transition.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"variables-3.31\",\"title\":\"Scalable design with Variables\",\"description\":\"Define once, reuse everywhere. Color & Font Variables help you build consistent, scalable design systems that update globally and are perfect for large sites or teams.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-variables.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"filters-3.31\",\"title\":\"Visual effects with Filters and Backdrop Filters\",\"description\":\"Apply multiple Filters like blur, brightness, and contrast. Stack, reorder, and preview in real time without writing a line of code.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-filters.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-assistant\",\"title\":\"New! Fix accessibility issues with Ally Assistant\",\"description\":\"Scan any page for accessibility issues and fix them in one click. From color contrast to missing alt text, Ally Assistant provides guided steps or AI-powered fixes to make your site more inclusive.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-assistant.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Scan for free\",\"ctaLink\":\"http:\\/\\/go.elementor.com\\/acc-assistant-launch-whats-new\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"classes-3.31\",\"title\":\"Smarter Class Manager tools\",\"description\":\"Quickly locate and manage Global Classes with usage counts, a new locator panel, and full class search. Perfect for scaling and refactoring complex design systems.\",\"topic\":\"Editor V4\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-attributes\\/\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}", "off");
INSERT INTO `nqcpo_options` VALUES("113822", "_pre_user_id", "O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:16:\"empty_user_login\";a:1:{i:0;s:58:\"Boş oturum açma adı ile bir kullanıcı oluşturulamaz.\";}}s:10:\"error_data\";a:0:{}s:18:\"\0*\0additional_data\";a:0:{}}", "auto");
INSERT INTO `nqcpo_options` VALUES("125863", "_elementor_element_cache_unique_id", "23310f780a7433516f570b30846f2967", "auto");
INSERT INTO `nqcpo_options` VALUES("168611", "litespeed.conf.media-auto_rescale_ori", "", "auto");
INSERT INTO `nqcpo_options` VALUES("168612", "litespeed.conf.debug-disable_tmp", "0", "auto");
INSERT INTO `nqcpo_options` VALUES("178489", "wp_tc_xegegon_punesapa", "L3RtcC9wcl9udTRpU20=", "auto");
INSERT INTO `nqcpo_options` VALUES("181396", "wp_zb_kabuju_nygaxesh", "L3RtcC9wcl9QZ1lvTGc=", "auto");
INSERT INTO `nqcpo_options` VALUES("186337", "widget_pca_recent_posts_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `nqcpo_options` VALUES("191282", "wp_notes_notify", "1", "on");
INSERT INTO `nqcpo_options` VALUES("192257", "using_application_passwords", "1", "off");
INSERT INTO `nqcpo_options` VALUES("198423", "can_compress_scripts", "1", "on");
INSERT INTO `nqcpo_options` VALUES("198433", "litespeed.conf._version", "7.7", "auto");
INSERT INTO `nqcpo_options` VALUES("198434", "litespeed.conf.img_optm-sizes_skipped", "[]", "auto");
INSERT INTO `nqcpo_options` VALUES("198448", "theme_mods_twentytwentythree", "a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:19:\"wp_classic_sidebars\";a:7:{s:14:\"footer-sidebar\";a:11:{s:4:\"name\";s:6:\"Footer\";s:2:\"id\";s:14:\"footer-sidebar\";s:11:\"description\";s:31:\"Add Widgets For Footer Section.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:71:\"<div class=\"col-md-3 col-sm-6 col-lg-3\"><div class=\"widget w-100 %2$s\">\";s:12:\"after_widget\";s:12:\"</div></div>\";s:12:\"before_title\";s:47:\"<h3 class = \"widget-title\" itemprop=\"headline\">\";s:11:\"after_title\";s:5:\"</h3>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}s:15:\"default-sidebar\";a:11:{s:4:\"name\";s:21:\"Default Pages Sidebar\";s:2:\"id\";s:15:\"default-sidebar\";s:11:\"description\";s:41:\"Sidebar for Index, Search, Archive Pages.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:40:\"<div class=\"widget2 brd-rd5 w-100 %2$s\">\";s:12:\"after_widget\";s:6:\"</div>\";s:12:\"before_title\";s:28:\"<h3 class = \"widget-title2\">\";s:11:\"after_title\";s:5:\"</h3>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}s:16:\"footer-1-space-1\";a:11:{s:4:\"name\";s:16:\"Footer - Space 1\";s:2:\"id\";s:16:\"footer-1-space-1\";s:11:\"description\";s:38:\"Use This To Place Widget - Location 1.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:31:\"<div class=\"widget w-100 %2$s\">\";s:12:\"after_widget\";s:6:\"</div>\";s:12:\"before_title\";s:4:\"<h3>\";s:11:\"after_title\";s:5:\"</h3>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}s:16:\"footer-1-space-2\";a:11:{s:4:\"name\";s:16:\"Footer - Space 2\";s:2:\"id\";s:16:\"footer-1-space-2\";s:11:\"description\";s:38:\"Use This To Place Widget - Location 2.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:31:\"<div class=\"widget w-100 %2$s\">\";s:12:\"after_widget\";s:6:\"</div>\";s:12:\"before_title\";s:4:\"<h3>\";s:11:\"after_title\";s:5:\"</h3>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}s:16:\"footer-1-space-3\";a:11:{s:4:\"name\";s:16:\"Footer - Space 3\";s:2:\"id\";s:16:\"footer-1-space-3\";s:11:\"description\";s:38:\"Use This To Place Widget - Location 3.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:31:\"<div class=\"widget w-100 %2$s\">\";s:12:\"after_widget\";s:6:\"</div>\";s:12:\"before_title\";s:4:\"<h3>\";s:11:\"after_title\";s:5:\"</h3>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}s:16:\"footer-1-space-4\";a:11:{s:4:\"name\";s:16:\"Footer - Space 4\";s:2:\"id\";s:16:\"footer-1-space-4\";s:11:\"description\";s:38:\"Use This To Place Widget - Location 4.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:31:\"<div class=\"widget w-100 %2$s\">\";s:12:\"after_widget\";s:6:\"</div>\";s:12:\"before_title\";s:4:\"<h3>\";s:11:\"after_title\";s:5:\"</h3>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}s:16:\"footer-1-space-5\";a:11:{s:4:\"name\";s:16:\"Footer - Space 5\";s:2:\"id\";s:16:\"footer-1-space-5\";s:11:\"description\";s:38:\"Use This To Place Widget - Location 5.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:31:\"<div class=\"widget w-100 %2$s\">\";s:12:\"after_widget\";s:6:\"</div>\";s:12:\"before_title\";s:4:\"<h3>\";s:11:\"after_title\";s:5:\"</h3>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1771802766;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:14:\"footer-sidebar\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:15:\"default-sidebar\";a:4:{i:0;s:17:\"bio_desc_widget-1\";i:1;s:8:\"search-1\";i:2;s:19:\"categories_custom-1\";i:3;s:20:\"image_video_widget-1\";}s:16:\"footer-1-space-1\";a:1:{i:0;s:14:\"about_widget-1\";}s:16:\"footer-1-space-2\";a:1:{i:0;s:10:\"nav_menu-1\";}s:16:\"footer-1-space-3\";a:1:{i:0;s:6:\"text-3\";}s:16:\"footer-1-space-4\";a:0:{}s:16:\"footer-1-space-5\";a:1:{i:0;s:6:\"text-2\";}}}}", "off");
INSERT INTO `nqcpo_options` VALUES("198508", "_elementor_home_screen_data", "a:2:{s:7:\"timeout\";i:1771817996;s:5:\"value\";s:12470:\"{\"top_with_licences\":[{\"license\":[\"free\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Start building your website with Elementor\'s no code drag & drop editor.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=le72grP_Q6k&t=1s\",\"youtube_embed_id\":\"le72grP_Q6k?si=g2akyWNODL6usu6u\"},{\"license\":[\"pro\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Now you\'ve got all the tools to start creating professional, high-performing websites - and that journey begins by creating your first page.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=QdkDGrS8ZZs\",\"youtube_embed_id\":\"QdkDGrS8ZZs?si=s_VjZCQR6Fh1jgB5\"},{\"license\":[\"one\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Now you\'ve got all the tools to start creating professional, high-performing websites - and that journey begins by creating your first page.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=QdkDGrS8ZZs\",\"youtube_embed_id\":\"QdkDGrS8ZZs?si=s_VjZCQR6Fh1jgB5\"}],\"get_started\":[{\"license\":[\"free\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&page=popup_templates\",\"is_relative_url\":true,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\",\"title_small_color\":\"text.tertiary\"}]},{\"license\":[\"pro\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&tabs_group=popup&elementor_library_type=popup\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\"}]},{\"license\":[\"one\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&tabs_group=popup&elementor_library_type=popup\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\"}]}],\"add_ons\":{\"hide_section\":[\"free\",\"essential\",\"pro\",\"one\"],\"header\":{\"title\":\"Expand your design toolkit\",\"description\":\"These plugins, add-ons, and tools, have been selected to streamline your workflow and maximize your creativity.\"},\"repeater\":[{\"file_path\":\"pojo-accessibility\\/pojo-accessibility.php\",\"title\":\"Ally - Web Accessibility. Simplified.\",\"url\":\"\",\"description\":\"Make your website more accessible with powerful tools to detect and fix issues, enhance usability, and create a better experience for all visitors.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/ally_logo.svg\",\"type\":\"wporg\"},{\"file_path\":\"site-mailer\\/site-mailer.php\",\"title\":\"Site Mailer\",\"url\":\"\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-mailer.svg\",\"type\":\"wporg\"},{\"file_path\":\"image-optimization\\/image-optimization.php\",\"title\":\"Image Optimizer\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-io\\/\",\"description\":\"Check out this incredibly useful plugin that will compress and optimize your images, giving you leaner, faster websites.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/image-optimizer.svg\",\"type\":\"wporg\"},{\"title\":\"Elementor AI\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-ai\\/\",\"description\":\"Boost creativity with Elementor AI. Craft & enhance copy, create custom CSS & Code, and generate images to elevate your website.\",\"button_label\":\"Let\'s go\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/elementor.svg\",\"type\":\"link\",\"condition\":{\"key\":\"introduction_meta\",\"value\":\"ai_get_started\"}}],\"footer\":{\"label\":\"Explore more add-ons\",\"file_path\":\"wp-admin\\/admin.php?page=elementor-apps\"}},\"sidebar_promotion_variants\":[{\"license\":[\"essential\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/essential-upgrade.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-advanced-home-sidebar-upgrade\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/upgrade-free.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\"}},{\"license\":[\"expired\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/upgrade-free.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-expired\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\'s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}},{\"license\":[\"pro\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\'s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}},{\"license\":[\"one\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\'s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}}],\"external_links\":[{\"label\":\"Help Center\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-question-mark.svg\",\"url\":\"https:\\/\\/elementor.com\\/help\\/\"},{\"label\":\"Youtube\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-youtube.svg\",\"url\":\"https:\\/\\/www.youtube.com\\/@Elementor\"},{\"label\":\"Facebook Community\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-community.svg\",\"url\":\"https:\\/\\/www.facebook.com\\/groups\\/Elementors\"},{\"label\":\"Blog\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-academic-hat.svg\",\"url\":\"https:\\/\\/elementor.com\\/blog\\/\"}]}\";}", "off");
INSERT INTO `nqcpo_options` VALUES("198512", "site_mail_logs_db_version", "5", "off");
INSERT INTO `nqcpo_options` VALUES("198513", "site_mailer_suppressions_db_version", "1", "off");
INSERT INTO `nqcpo_options` VALUES("198514", "site_mailer_statuses_db_version", "2", "off");
INSERT INTO `nqcpo_options` VALUES("198515", "site_mailer_review_data", "a:8:{s:10:\"dismissals\";i:0;s:13:\"hide_for_days\";i:0;s:12:\"last_dismiss\";N;s:6:\"rating\";N;s:8:\"feedback\";N;s:8:\"added_on\";s:19:\"2026-02-22 23:40:12\";s:9:\"submitted\";b:0;s:19:\"repo_review_clicked\";b:0;}", "off");
INSERT INTO `nqcpo_options` VALUES("198519", "_elementor_settings_update_time", "1771804115", "auto");
INSERT INTO `nqcpo_options` VALUES("198520", "elementor_cpt_support", "a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}", "auto");
INSERT INTO `nqcpo_options` VALUES("198521", "elementor_disable_color_schemes", "", "auto");
INSERT INTO `nqcpo_options` VALUES("198522", "elementor_disable_typography_schemes", "", "auto");
INSERT INTO `nqcpo_options` VALUES("198523", "elementor_allow_tracking_last_update", "1771804115", "auto");
INSERT INTO `nqcpo_options` VALUES("198524", "elementor_google_maps_api_key", "", "auto");
INSERT INTO `nqcpo_options` VALUES("198525", "elementor_editor_break_lines", "", "auto");
INSERT INTO `nqcpo_options` VALUES("198526", "elementor_unfiltered_files_upload", "", "auto");
INSERT INTO `nqcpo_options` VALUES("198527", "elementor_google_font", "1", "auto");
INSERT INTO `nqcpo_options` VALUES("198528", "elementor_font_display", "auto", "auto");
INSERT INTO `nqcpo_options` VALUES("198529", "elementor_load_fa4_shim", "", "auto");
INSERT INTO `nqcpo_options` VALUES("198530", "elementor_meta_generator_tag", "", "auto");
INSERT INTO `nqcpo_options` VALUES("198531", "elementor_css_print_method", "external", "auto");
INSERT INTO `nqcpo_options` VALUES("198532", "elementor_optimized_image_loading", "1", "auto");
INSERT INTO `nqcpo_options` VALUES("198533", "elementor_optimized_gutenberg_loading", "1", "auto");
INSERT INTO `nqcpo_options` VALUES("198534", "elementor_lazy_load_background_images", "1", "auto");
INSERT INTO `nqcpo_options` VALUES("198535", "elementor_local_google_fonts", "1", "auto");
INSERT INTO `nqcpo_options` VALUES("198536", "elementor_element_cache_ttl", "24", "auto");
INSERT INTO `nqcpo_options` VALUES("198537", "elementor_no_features", "", "auto");
INSERT INTO `nqcpo_options` VALUES("198538", "elementor_experiment-e_font_icon_svg", "default", "auto");
INSERT INTO `nqcpo_options` VALUES("198539", "elementor_experiment-additional_custom_breakpoints", "default", "auto");
INSERT INTO `nqcpo_options` VALUES("198540", "elementor_experiment-container", "default", "auto");
INSERT INTO `nqcpo_options` VALUES("198541", "elementor_experiment-e_optimized_markup", "default", "auto");
INSERT INTO `nqcpo_options` VALUES("198542", "elementor_experiment-nested-elements", "default", "auto");
INSERT INTO `nqcpo_options` VALUES("198573", "theme_mods_hello-elementor", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:6:\"menu-1\";i:59;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1771814645;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:9:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";i:5;s:8:\"search-1\";i:6;s:10:\"nav_menu-1\";i:7;s:6:\"text-3\";i:8;s:6:\"text-2\";}}}}", "off");
INSERT INTO `nqcpo_options` VALUES("198574", "hello_theme_version", "3.4.6", "auto");
INSERT INTO `nqcpo_options` VALUES("198577", "_hello-elementor_notifications", "a:2:{s:7:\"timeout\";i:1771857845;s:5:\"value\";s:8157:\"[{\"id\":\"hello-theme-3.4.6\",\"title\":\"3.4.6 - 2026-01-21\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Updated Elementor assets<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.5\",\"title\":\"3.4.5 - 2025-10-27\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>New: Add theme home to Finder<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Improve banner behavior after clicking on action button<\\/li>\\n\\t\\t\\t\\t<li>Fix: Load styles correctly in Gutenberg pages<\\/li>\\n\\t\\t\\t\\t<li>Fix: Do not change menu name after Elementor activation<\\/li>\\n\\t\\t\\t\\t<li>Fix: Ensure quicklinks works correctly from home page<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.4\",\"title\":\"3.4.4 - 2025-06-08\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Improve Header\\/Footer edit access from theme Home<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.3\",\"title\":\"3.4.3 - 2025-05-26\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Fix: Settings page empty after 3.4.0 in translated sites<\\/li>\\n\\t\\t\\t\\t<li>Fix: PHP 8.4 deprecation notice<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.2\",\"title\":\"3.4.2 - 2025-05-19\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Set Home links font weight to regular<\\/li>\\n  \\t\\t        <li>Tweak: Dart SASS 3.0.0 - resolve scss deprecated warnings<\\/li>\\n    \\t\\t    <li>Fix: Settings page empty after 3.4.0<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.0\",\"title\":\"3.4.0 - 2025-05-05\",\"description\":\"\\n            <ul>\\n                <li>New: Added Theme Home<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update theme settings page style<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update tested up to version 6.8<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.3.0\",\"title\":\"3.3.0 - 2025-01-21\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Added changelog link in theme settings<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n  \\t\\t        <li>Tweak: Update autoprefixer to latest versions<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.1\",\"title\":\"3.2.1 - 2024-12-16\",\"description\":\"\\n            <ul>\\n                <li>\\n                    Fix: Gutenberg editor expanded disproportionately after adding support for <code>theme.json<\\/code>\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/430\\\" target=\\\"_blank\\\">#430<\\/a>)\\n                <\\/li>\\n                <li>Fix: Use CSS logical properties in the theme<\\/li>\\n                <li>Fix: Add ARIA attributes to header nav menu<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.0\",\"title\":\"3.2.0 - 2024-12-15\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Convert classic to hybrid theme with block-editor support<\\/li>\\n                <li>Tweak: Added new design options to header\\/footer<\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.7<\\/code><\\/li>\\n                <li>\\n                    Fix: Minify JS files\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/419\\\" target=\\\"_blank\\\">#419<\\/a>)\\n                <\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.1\",\"title\":\"3.1.1 - 2024-07-30\",\"description\":\"\\n            <ul>\\n                <li>Fix: Use consistent <code>&lt;h2&gt;<\\/code> for comments title and comment form<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.0\",\"title\":\"3.1.0 - 2024-06-19\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Update <code>Requires PHP 7.4<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.5<\\/code><\\/li>\\n                <li>Tweak: Add the ability to style the brand layout<\\/li>\\n                <li>Tweak: Remove deprecated Elementor code<\\/li>\\n                <li>Tweak: Restore default focus styling inside the theme<\\/li>\\n                <li>Tweak: Add <code>aria-label<\\/code> attribute to various <code>&lt;nav&gt;<\\/code> elements<\\/li>\\n                <li>Tweak: Improve mobile menu keyboard accessibility<\\/li>\\n                <li>Tweak: Semantic mobile menu toggle button<\\/li>\\n                <li>Fix: The header renders redundant <code>&lt;p&gt;<\\/code> when tagline is empty<\\/li>\\n                <li>Fix: Single post renders redundant wrapping <code>&lt;div&gt;<\\/code> when it has no tags<\\/li>\\n                <li>Fix: Remove redundant wrapping <code>&lt;div&gt;<\\/code> from <code>wp_nav_menu()<\\/code> output<\\/li>\\n                <li>Fix: Wrap page <code>&lt;h1&gt;<\\/code> with <code>&lt;div&gt;<\\/code>, not <code>&lt;header&gt;<\\/code><\\/li>\\n                <li>Fix: Use consistent <code>&lt;h3&gt;<\\/code> for comments title and comment form<\\/li>\\n                <li>Fix: Remove heading tags from dynamic header\\/footer<\\/li>\\n                <li>\\n                    Fix: Mobile Menu hamburger is not visible for logged-out users in some cases\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/369\\\" target=\\\"_blank\\\">#369<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove duplicate ID attributes in the header mobile menu<\\/li>\\n                <li>\\n                    Fix: Remove redundant table styles\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/311\\\" target=\\\"_blank\\\">#311<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove redundant space below Site Logo in the header\\/footer<\\/li>\\n                <li>Fix: Remove redundant CSS from dynamic header\\/footer layout<\\/li>\\n                <li>\\n                    Fix: Separate post tags in single post\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/304\\\" target=\\\"_blank\\\">#304<\\/a>)\\n                <\\/li>\\n                <li>Fix: Display <code>the_tags()<\\/code> after <code>wp_link_pages()<\\/code><\\/li>\\n                <li>Fix: Remove page break navigation from archives when using <code>&lt;!--nextpage--&gt;<\\/code><\\/li>\\n                <li>Fix: Style posts pagination component layout<\\/li>\\n                <li>Fix: Add RTL support to pagination arrows in archive pages<\\/li>\\n                <li>\\n                    Fix: Update pagination prev\\/next labels and positions\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/404\\\" target=\\\"_blank\\\">#404<\\/a>)\\n                <\\/li>\\n                <li>Fix: Check if Elementor is loaded when using dynamic header & footer<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.2\",\"title\":\"3.0.2 - 2024-05-28\",\"description\":\"\\n            <ul>\\n                <li>Internal: Version bump release to refresh WordPress repository<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.1\",\"title\":\"3.0.1 - 2024-01-24\",\"description\":\"\\n            <ul>\\n                <li>Fix: Harden security for admin notice dismiss button<\\/li>\\n                <li>Fix: Add <code>alt<\\/code> attribute to all the images in the dashboard<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.0\",\"title\":\"3.0.0 - 2023-12-26\",\"description\":\"\\n            <ul>\\n                <li>New: Option to disable cross-site header & footer<\\/li>\\n                <li>Tweak: Update <code>Requires PHP 7.3<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.4<\\/code><\\/li>\\n                <li>Tweak: Move cross-site header & footer styles to a separate CSS file<\\/li>\\n                <li>Tweak: Don\'t load <code>header-footer.min.css<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Don\'t load <code>hello-frontend.min.js<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in the frontend<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in WordPress admin<\\/li>\\n                <li>Tweak: Remove unused JS code from the frontend<\\/li>\\n                <li>Tweak: Remove unused CSS code from the editor<\\/li>\\n                <li>Tweak: Remove unnecessary <code>role<\\/code> attributes from HTML landmark elements<\\/li>\\n                <li>Tweak: Link from Elementor Site Settings to Hello Theme Settings<\\/li>\\n                <li>Fix: Dynamic script version for better caching<\\/li>\\n            <\\/ul>\"}]\";}", "off");
INSERT INTO `nqcpo_options` VALUES("198591", "_elementor_v4_promotions", "a:2:{s:7:\"timeout\";i:1771820753;s:5:\"value\";s:862:\"[{\"customCss\":{\"title\":\"Custom CSS\",\"content\":\"Add custom CSS to refine and enrich the appearance of any element on your site.\",\"ctaUrl\":\"https:\\/\\/go.elementor.com\\/go-pro-style-custom-css\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/packages\\/v1\\/images\\/custom_css_promotion.png\"},\"displayConditions\":{\"title\":\"Display conditions\",\"content\":\"Control when and where elements are shown across your site.\",\"ctaUrl\":\"https:\\/\\/go.elementor.com\\/go-pro-display-conditions-modal\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/packages\\/v1\\/images\\/display_conditions_promotion.png\"},\"attributes\":{\"title\":\"Attributes\",\"content\":\"Add custom attributes when you need deeper customization and better accessibility.\",\"ctaUrl\":\"https:\\/\\/go.elementor.com\\/go-pro-attributes-modal\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/packages\\/v1\\/images\\/attributes_promotion.png\"}}]\";}", "off");
INSERT INTO `nqcpo_options` VALUES("198598", "duplicator_version_plugin", "1.5.15", "auto");
INSERT INTO `nqcpo_options` VALUES("198601", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `nqcpo_options` VALUES("198602", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `nqcpo_options` VALUES("198603", "duplicator_settings", "a:20:{s:7:\"version\";s:6:\"1.5.15\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:1;s:14:\"usage_tracking\";b:0;i:0;b:0;}", "auto");
INSERT INTO `nqcpo_options` VALUES("198604", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"0PUB0Tbp8+g2,F;X&lC56wxQ2d6lL;7tP&wdqjZXXw=M\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 203.97,\n    \"siteNumFiles\": 12148,\n    \"siteDbSizeMB\": 6.84,\n    \"siteDbNumTables\": 86\n}", "auto");
INSERT INTO `nqcpo_options` VALUES("198605", "duplicator_notifications", "a:4:{s:6:\"update\";i:1771806444;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `nqcpo_options` VALUES("198606", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2026-02-23 10:56:06\";s:7:\"Version\";s:6:\"1.5.15\";s:9:\"VersionWP\";s:5:\"6.9.1\";s:9:\"VersionDB\";s:6:\"8.0.44\";s:10:\"VersionPHP\";s:6:\"8.3.28\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:28:\"20260223_ankaraballielektrik\";s:4:\"Hash\";s:35:\"70c09943487b12464040_20260223105606\";s:8:\"NameHash\";s:64:\"20260223_ankaraballielektrik_70c09943487b12464040_20260223105606\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:74:\"20260223_ankaraballielektrik_70c09943487b12464040_20260223105606_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":27:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:39:\"/Applications/MAMP/htdocs/ballielektrik\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1707;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:10441;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2026-02-23 10:56:06\";s:7:\"Version\";s:6:\"1.5.15\";s:9:\"VersionWP\";s:5:\"6.9.1\";s:9:\"VersionDB\";s:6:\"8.0.44\";s:10:\"VersionPHP\";s:6:\"8.3.28\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:28:\"20260223_ankaraballielektrik\";s:4:\"Hash\";s:35:\"70c09943487b12464040_20260223105606\";s:8:\"NameHash\";s:64:\"20260223_ankaraballielektrik_70c09943487b12464040_20260223105606\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:66;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:53:\"/Applications/MAMP/htdocs/ballielektrik/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:66;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:66;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:48:\"/Applications/MAMP/htdocs/ballielektrik/wp-admin\";i:1;s:51:\"/Applications/MAMP/htdocs/ballielektrik/wp-includes\";i:2;s:60:\"/Applications/MAMP/htdocs/ballielektrik/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:39:\"/Applications/MAMP/htdocs/ballielektrik\";i:1;s:39:\"/Applications/MAMP/htdocs/ballielektrik\";i:2;s:50:\"/Applications/MAMP/htdocs/ballielektrik/wp-content\";i:3;s:58:\"/Applications/MAMP/htdocs/ballielektrik/wp-content/uploads\";i:4;s:58:\"/Applications/MAMP/htdocs/ballielektrik/wp-content/plugins\";i:5;s:61:\"/Applications/MAMP/htdocs/ballielektrik/wp-content/mu-plugins\";i:6;s:57:\"/Applications/MAMP/htdocs/ballielektrik/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:3:{i:0;s:71:\"/Applications/MAMP/htdocs/ballielektrik/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";i:2;s:18:\"duplicator-backups\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;s:38:\"\0DUP_Archive\0wpContentDirNormalizePath\";N;}s:9:\"Installer\";r:87;s:8:\"Database\";r:106;s:13:\"BuildProgress\";r:145;}", "auto");
INSERT INTO `nqcpo_options` VALUES("198628", "category_children", "a:0:{}", "auto");
INSERT INTO `nqcpo_options` VALUES("198642", "wordfence_ls_version", "1.1.15", "auto");
INSERT INTO `nqcpo_options` VALUES("198643", "wfls_last_role_change", "1771842966", "off");
INSERT INTO `nqcpo_options` VALUES("198644", "wordfence_version", "8.1.4", "auto");
INSERT INTO `nqcpo_options` VALUES("198645", "wordfence_case", "1", "auto");
INSERT INTO `nqcpo_options` VALUES("198646", "wordfence_installed", "1", "auto");
INSERT INTO `nqcpo_options` VALUES("198647", "wordfenceActivated", "1", "auto");
INSERT INTO `nqcpo_options` VALUES("198648", "wf_plugin_act_error", "", "auto");
INSERT INTO `nqcpo_options` VALUES("198657", "duplicator_install_info", "a:3:{s:7:\"version\";s:6:\"1.5.15\";s:4:\"time\";i:1771806443;s:10:\"updateTime\";i:1771843560;}", "off");
INSERT INTO `nqcpo_options` VALUES("198662", "aio_wp_security_configs", "a:117:{s:19:\"aiowps_enable_debug\";s:0:\"\";s:36:\"aiowps_enable_php_backtrace_in_email\";s:0:\"\";s:36:\"aiowps_remove_wp_generator_meta_info\";s:0:\"\";s:25:\"aiowps_prevent_hotlinking\";s:0:\"\";s:28:\"aiowps_enable_login_lockdown\";s:1:\"1\";s:28:\"aiowps_allow_unlock_requests\";s:1:\"1\";s:25:\"aiowps_max_login_attempts\";s:1:\"3\";s:24:\"aiowps_retry_time_period\";s:1:\"5\";s:26:\"aiowps_lockout_time_length\";s:1:\"5\";s:30:\"aiowps_max_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_set_generic_login_msg\";s:0:\"\";s:26:\"aiowps_enable_email_notify\";s:0:\"\";s:20:\"aiowps_email_address\";s:22:\"info@ballielektrik.com\";s:27:\"aiowps_enable_forced_logout\";s:1:\"1\";s:25:\"aiowps_logout_time_period\";i:60;s:39:\"aiowps_enable_invalid_username_lockdown\";s:0:\"\";s:43:\"aiowps_instantly_lockout_specific_usernames\";a:0:{}s:32:\"aiowps_unlock_request_secret_key\";s:20:\"c0hxjv8dm3waemw79pxw\";s:35:\"aiowps_lockdown_enable_whitelisting\";s:0:\"\";s:36:\"aiowps_lockdown_allowed_ip_addresses\";s:0:\"\";s:32:\"aiowps_http_authentication_admin\";s:0:\"\";s:35:\"aiowps_http_authentication_frontend\";s:0:\"\";s:35:\"aiowps_http_authentication_username\";s:4:\"root\";s:35:\"aiowps_http_authentication_password\";s:8:\"password\";s:42:\"aiowps_http_authentication_failure_message\";s:21:\"<h1>Unauthorized</h1>\";s:26:\"aiowps_enable_whitelisting\";s:0:\"\";s:27:\"aiowps_allowed_ip_addresses\";s:0:\"\";s:22:\"aiowps_default_captcha\";s:4:\"none\";s:27:\"aiowps_enable_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_custom_login_captcha\";s:0:\"\";s:40:\"aiowps_enable_password_protected_captcha\";s:0:\"\";s:31:\"aiowps_enable_woo_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_woo_register_captcha\";s:0:\"\";s:34:\"aiowps_enable_woo_checkout_captcha\";s:0:\"\";s:38:\"aiowps_enable_woo_lostpassword_captcha\";s:0:\"\";s:36:\"aiowps_enable_contact_form_7_captcha\";s:0:\"\";s:25:\"aiowps_captcha_secret_key\";s:20:\"qevjtzjm7pxjt2mbuync\";s:42:\"aiowps_enable_manual_registration_approval\";s:0:\"\";s:39:\"aiowps_enable_registration_page_captcha\";s:0:\"\";s:35:\"aiowps_enable_registration_honeypot\";s:0:\"\";s:30:\"aiowps_enforce_strong_password\";s:0:\"\";s:27:\"aiowps_enable_random_prefix\";s:0:\"\";s:27:\"aiowps_disable_file_editing\";s:1:\"1\";s:37:\"aiowps_prevent_default_wp_file_access\";s:0:\"\";s:35:\"aiowps_auto_delete_default_wp_files\";s:0:\"\";s:22:\"aiowps_system_log_file\";s:9:\"error_log\";s:26:\"aiowps_enable_blacklisting\";s:0:\"\";s:26:\"aiowps_banned_ip_addresses\";s:0:\"\";s:28:\"aiowps_enable_basic_firewall\";s:1:\"1\";s:27:\"aiowps_max_file_upload_size\";i:100;s:38:\"aiowps_disable_xmlrpc_pingback_methods\";s:0:\"\";s:33:\"aiowps_disable_rss_and_atom_feeds\";s:0:\"\";s:34:\"aiowps_block_debug_log_file_access\";s:1:\"1\";s:26:\"aiowps_disable_index_views\";s:1:\"1\";s:30:\"aiowps_disable_trace_and_track\";s:0:\"\";s:25:\"aiowps_enable_5g_firewall\";s:0:\"\";s:25:\"aiowps_enable_6g_firewall\";s:1:\"1\";s:26:\"aiowps_enable_custom_rules\";s:0:\"\";s:32:\"aiowps_place_custom_rules_at_top\";s:0:\"\";s:19:\"aiowps_custom_rules\";s:0:\"\";s:32:\"aiowps_upgrade_unsafe_http_calls\";s:0:\"\";s:47:\"aiowps_upgrade_unsafe_http_calls_url_exceptions\";s:0:\"\";s:25:\"aiowps_enable_404_logging\";s:0:\"\";s:28:\"aiowps_enable_404_IP_lockout\";s:0:\"\";s:30:\"aiowps_404_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_404_lock_redirect_url\";s:16:\"http://127.0.0.1\";s:31:\"aiowps_enable_rename_login_page\";s:0:\"\";s:28:\"aiowps_enable_login_honeypot\";s:0:\"\";s:35:\"aiowps_disable_application_password\";s:0:\"\";s:43:\"aiowps_enable_brute_force_attack_prevention\";s:0:\"\";s:30:\"aiowps_brute_force_secret_word\";s:0:\"\";s:24:\"aiowps_cookie_brute_test\";s:0:\"\";s:44:\"aiowps_cookie_based_brute_force_redirect_url\";s:16:\"http://127.0.0.1\";s:59:\"aiowps_brute_force_attack_prevention_pw_protected_exception\";s:0:\"\";s:51:\"aiowps_brute_force_attack_prevention_ajax_exception\";s:0:\"\";s:19:\"aiowps_site_lockout\";s:0:\"\";s:23:\"aiowps_site_lockout_msg\";s:0:\"\";s:30:\"aiowps_enable_spambot_blocking\";s:0:\"\";s:29:\"aiowps_enable_comment_captcha\";s:0:\"\";s:33:\"aiowps_spam_ip_min_comments_block\";i:3;s:33:\"aiowps_enable_bp_register_captcha\";s:0:\"\";s:35:\"aiowps_enable_bbp_new_topic_captcha\";s:0:\"\";s:31:\"aiowps_enable_spambot_detecting\";s:1:\"1\";s:32:\"aiowps_spambot_detect_usecookies\";s:0:\"\";s:27:\"aiowps_spam_comments_should\";s:1:\"1\";s:33:\"aiowps_enable_trash_spam_comments\";s:0:\"\";s:37:\"aiowps_trash_spam_comments_after_days\";s:2:\"14\";s:32:\"aiowps_enable_automated_fcd_scan\";s:0:\"\";s:25:\"aiowps_fcd_scan_frequency\";s:1:\"4\";s:24:\"aiowps_fcd_scan_interval\";s:1:\"2\";s:28:\"aiowps_fcd_exclude_filetypes\";s:0:\"\";s:24:\"aiowps_fcd_exclude_files\";s:0:\"\";s:26:\"aiowps_send_fcd_scan_email\";s:0:\"\";s:29:\"aiowps_fcd_scan_email_address\";s:22:\"info@ballielektrik.com\";s:27:\"aiowps_fcds_change_detected\";b:0;s:22:\"aiowps_copy_protection\";s:1:\"1\";s:40:\"aiowps_prevent_site_display_inside_frame\";s:1:\"1\";s:32:\"aiowps_prevent_users_enumeration\";s:1:\"1\";s:42:\"aiowps_disallow_unauthorized_rest_requests\";s:0:\"\";s:35:\"aios_roles_disallowed_rest_requests\";a:0:{}s:28:\"aios_whitelisted_rest_routes\";a:0:{}s:25:\"aiowps_turnstile_site_key\";s:0:\"\";s:27:\"aiowps_turnstile_secret_key\";s:0:\"\";s:25:\"aiowps_recaptcha_site_key\";s:0:\"\";s:27:\"aiowps_recaptcha_secret_key\";s:0:\"\";s:24:\"aiowps_default_recaptcha\";s:0:\"\";s:36:\"aiowps_on_uninstall_delete_db_tables\";s:1:\"1\";s:34:\"aiowps_on_uninstall_delete_configs\";s:1:\"1\";s:12:\"installed-at\";i:1771843610;s:31:\"aiowps_enable_pingback_firewall\";s:1:\"0\";s:28:\"aiowps_forbid_proxy_comments\";s:1:\"0\";s:29:\"aiowps_deny_bad_query_strings\";s:1:\"0\";s:34:\"aiowps_advanced_char_string_filter\";s:1:\"0\";s:31:\"aiowps_enable_autoblock_spam_ip\";s:1:\"1\";s:25:\"aiowps_ip_retrieve_method\";i:0;s:19:\"aiowps_fcd_filename\";s:26:\"aiowps_fcd_data_526zj7qiwt\";s:21:\"aiowps_last_scan_time\";i:1771843707;}", "auto");
INSERT INTO `nqcpo_options` VALUES("198663", "aios_antibot_key_map_info", "a:3:{i:0;a:3:{i:0;a:2:{i:0;s:8:\"bbhw8vth\";i:1;s:12:\"7nzjh57dmvxp\";}i:1;a:2:{i:0;s:8:\"2f8nqhh4\";i:1;s:12:\"s6dsv8sywko5\";}i:2;a:2:{i:0;s:8:\"i20s5552\";i:1;s:12:\"3z6zp4vupl4c\";}}i:1;a:3:{i:0;a:2:{i:0;s:8:\"p1w6q0zo\";i:1;s:12:\"cmaxj0v08ppe\";}i:1;a:2:{i:0;s:8:\"17hc5zw6\";i:1;s:12:\"vy6ot644ae02\";}i:2;a:2:{i:0;s:8:\"g0ren5nv\";i:1;s:12:\"x23kbxvauvpl\";}}i:2;i:1772236800;}", "off");
INSERT INTO `nqcpo_options` VALUES("198664", "aiowpsec_db_version", "2.1.4", "auto");
INSERT INTO `nqcpo_options` VALUES("198668", "aiowpsec_firewall_version", "1.0.8", "auto");
INSERT INTO `nqcpo_options` VALUES("198669", "updraft_lock_aios_15_minutes_cron_event", "0", "no");
INSERT INTO `nqcpo_options` VALUES("198670", "simba_tfa_priv_key_format", "1", "off");
INSERT INTO `nqcpo_options` VALUES("198674", "_site_transient_timeout_wp_theme_files_patterns-f086d41de24fd96006b661f62229c124", "1771845820", "off");
INSERT INTO `nqcpo_options` VALUES("198675", "_site_transient_wp_theme_files_patterns-f086d41de24fd96006b661f62229c124", "a:2:{s:7:\"version\";s:3:\"1.0\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `nqcpo_options` VALUES("198677", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/tr_TR/wordpress-6.9.1.zip\";s:6:\"locale\";s:5:\"tr_TR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/tr_TR/wordpress-6.9.1.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.9.1\";s:7:\"version\";s:5:\"6.9.1\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1771844022;s:15:\"version_checked\";s:5:\"6.9.1\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `nqcpo_options` VALUES("198678", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1771844023;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:9:{s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:49:\"w.org/plugins/all-in-one-wp-security-and-firewall\";s:4:\"slug\";s:35:\"all-in-one-wp-security-and-firewall\";s:6:\"plugin\";s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";s:11:\"new_version\";s:5:\"5.4.6\";s:3:\"url\";s:66:\"https://wordpress.org/plugins/all-in-one-wp-security-and-firewall/\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/plugin/all-in-one-wp-security-and-firewall.5.4.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:88:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/icon-256x256.png?rev=2798307\";s:2:\"1x\";s:88:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/icon-128x128.png?rev=2798307\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:91:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/banner-1544x500.png?rev=2798307\";s:2:\"1x\";s:90:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/banner-772x250.png?rev=2798307\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";}s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:5:\"1.6.7\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/classic-editor.1.6.7.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1998671\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1998671\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1998671\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1998676\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:35:\"classic-widgets/classic-widgets.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/classic-widgets\";s:4:\"slug\";s:15:\"classic-widgets\";s:6:\"plugin\";s:35:\"classic-widgets/classic-widgets.php\";s:11:\"new_version\";s:3:\"0.3\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/classic-widgets/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/classic-widgets.0.3.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:59:\"https://s.w.org/plugins/geopattern-icon/classic-widgets.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"6.1.5\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.1.5.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.7\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.5.15\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.5.15.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}s:23:\"elementor/elementor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:6:\"3.35.5\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.35.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3444228\";s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3444228\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3443226\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3443226\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}s:35:\"litespeed-cache/litespeed-cache.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/litespeed-cache\";s:4:\"slug\";s:15:\"litespeed-cache\";s:6:\"plugin\";s:35:\"litespeed-cache/litespeed-cache.php\";s:11:\"new_version\";s:3:\"7.7\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/litespeed-cache/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/litespeed-cache.7.7.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/litespeed-cache/assets/icon-256x256.png?rev=2554181\";s:2:\"1x\";s:68:\"https://ps.w.org/litespeed-cache/assets/icon-128x128.png?rev=2554181\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/litespeed-cache/assets/banner-1544x500.png?rev=2554181\";s:2:\"1x\";s:70:\"https://ps.w.org/litespeed-cache/assets/banner-772x250.png?rev=2554181\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}s:23:\"loco-translate/loco.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/loco-translate\";s:4:\"slug\";s:14:\"loco-translate\";s:6:\"plugin\";s:23:\"loco-translate/loco.php\";s:11:\"new_version\";s:5:\"2.8.1\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/loco-translate/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/loco-translate.2.8.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/loco-translate/assets/icon-256x256.png?rev=1000676\";s:2:\"1x\";s:67:\"https://ps.w.org/loco-translate/assets/icon-128x128.png?rev=1000676\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:68:\"https://ps.w.org/loco-translate/assets/banner-772x250.jpg?rev=745046\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}s:35:\"redux-framework/redux-framework.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/redux-framework\";s:4:\"slug\";s:15:\"redux-framework\";s:6:\"plugin\";s:35:\"redux-framework/redux-framework.php\";s:11:\"new_version\";s:6:\"4.5.10\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/redux-framework/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/redux-framework.4.5.10.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:60:\"https://ps.w.org/redux-framework/assets/icon.svg?rev=2889347\";s:3:\"svg\";s:60:\"https://ps.w.org/redux-framework/assets/icon.svg?rev=2889347\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:70:\"https://ps.w.org/redux-framework/assets/banner-772x250.png?rev=2889347\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";}}s:7:\"checked\";a:10:{s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";s:5:\"5.4.6\";s:33:\"classic-editor/classic-editor.php\";s:5:\"1.6.7\";s:35:\"classic-widgets/classic-widgets.php\";s:3:\"0.3\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"6.1.5\";s:25:\"duplicator/duplicator.php\";s:6:\"1.5.15\";s:23:\"elementor/elementor.php\";s:6:\"3.35.5\";s:19:\"ingeniofy/index.php\";s:3:\"1.0\";s:35:\"litespeed-cache/litespeed-cache.php\";s:3:\"7.7\";s:23:\"loco-translate/loco.php\";s:5:\"2.8.1\";s:35:\"redux-framework/redux-framework.php\";s:6:\"4.5.10\";}}", "off");
INSERT INTO `nqcpo_options` VALUES("198679", "_site_transient_timeout_theme_roots", "1771845823", "off");
INSERT INTO `nqcpo_options` VALUES("198680", "_site_transient_theme_roots", "a:4:{s:15:\"hello-elementor\";s:7:\"/themes\";s:6:\"kriate\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";}", "off");
INSERT INTO `nqcpo_options` VALUES("198681", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1771844023;s:7:\"checked\";a:4:{s:15:\"hello-elementor\";s:5:\"3.4.6\";s:6:\"kriate\";s:3:\"1.0\";s:16:\"twentytwentyfour\";s:3:\"1.4\";s:17:\"twentytwentythree\";s:3:\"1.6\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:3:{s:15:\"hello-elementor\";a:6:{s:5:\"theme\";s:15:\"hello-elementor\";s:11:\"new_version\";s:5:\"3.4.6\";s:3:\"url\";s:45:\"https://wordpress.org/themes/hello-elementor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/hello-elementor.3.4.6.zip\";s:8:\"requires\";s:3:\"6.0\";s:12:\"requires_php\";s:3:\"7.4\";}s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.4.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `nqcpo_options` VALUES("198682", "_transient_timeout_elementor_remote_info_api_data_3.35.5", "1771887355", "off");
INSERT INTO `nqcpo_options` VALUES("198683", "_transient_elementor_remote_info_api_data_3.35.5", "a:4:{s:9:\"timestamp\";s:10:\"1771843431\";s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:82:{i:0;a:4:{s:4:\"name\";s:6:\"search\";s:5:\"title\";s:6:\"Search\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:3;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-2\";s:5:\"title\";s:7:\"Classic\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:4;a:4:{s:4:\"name\";s:9:\"mega-menu\";s:5:\"title\";s:4:\"Menu\";s:4:\"icon\";s:15:\"eicon-mega-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:5;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-3\";s:5:\"title\";s:8:\"Showcase\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:6;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-4\";s:5:\"title\";s:5:\"Links\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:8;a:4:{s:4:\"name\";s:9:\"loop-grid\";s:5:\"title\";s:9:\"Loop Grid\";s:4:\"icon\";s:18:\"eicon-loop-builder\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:9;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-5\";s:5:\"title\";s:8:\"Services\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:10;a:4:{s:4:\"name\";s:13:\"loop-carousel\";s:5:\"title\";s:13:\"Loop Carousel\";s:4:\"icon\";s:19:\"eicon-carousel-loop\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:11;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-6\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:12;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-7\";s:5:\"title\";s:13:\"Business Card\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:14;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:16;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:19;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:20;a:4:{s:4:\"name\";s:15:\"nested-carousel\";s:5:\"title\";s:8:\"Carousel\";s:4:\"icon\";s:21:\"eicon-nested-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:21;a:4:{s:4:\"name\";s:10:\"off-canvas\";s:5:\"title\";s:10:\"Off-Canvas\";s:4:\"icon\";s:16:\"eicon-off-canvas\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:22;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:23;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:24;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:25;a:4:{s:4:\"name\";s:6:\"lottie\";s:5:\"title\";s:6:\"Lottie\";s:4:\"icon\";s:12:\"eicon-lottie\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:26;a:4:{s:4:\"name\";s:7:\"hotspot\";s:5:\"title\";s:7:\"Hotspot\";s:4:\"icon\";s:19:\"eicon-image-hotspot\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:27;a:4:{s:4:\"name\";s:13:\"paypal-button\";s:5:\"title\";s:13:\"PayPal Button\";s:4:\"icon\";s:19:\"eicon-paypal-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:28;a:4:{s:4:\"name\";s:14:\"code-highlight\";s:5:\"title\";s:14:\"Code Highlight\";s:4:\"icon\";s:20:\"eicon-code-highlight\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:29;a:4:{s:4:\"name\";s:14:\"video-playlist\";s:5:\"title\";s:14:\"Video Playlist\";s:4:\"icon\";s:20:\"eicon-video-playlist\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:30;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:31;a:4:{s:4:\"name\";s:13:\"stripe-button\";s:5:\"title\";s:13:\"Stripe Button\";s:4:\"icon\";s:19:\"eicon-stripe-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:32;a:4:{s:4:\"name\";s:16:\"progress-tracker\";s:5:\"title\";s:16:\"Progress Tracker\";s:4:\"icon\";s:22:\"eicon-progress-tracker\";s:10:\"categories\";s:40:\"[\"pro-elements\",\"theme-elements-single\"]\";}i:33;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:34;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:35;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:36;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:37;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:38;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:39;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:40;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:41;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:42;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:43;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:44;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:45;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:46;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:47;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:48;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:49;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:50;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:51;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:52;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:53;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:54;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:55;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:56;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:57;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:58;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:59;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:60;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:61;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:62;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:63;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:64;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:65;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:66;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:67;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:68;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:69;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:70;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:71;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:72;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:73;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:74;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:75;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:76;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:77;a:4:{s:4:\"name\";s:25:\"woocommerce-checkout-page\";s:5:\"title\";s:8:\"Checkout\";s:4:\"icon\";s:14:\"eicon-checkout\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:78;a:4:{s:4:\"name\";s:16:\"woocommerce-cart\";s:5:\"title\";s:4:\"Cart\";s:4:\"icon\";s:14:\"eicon-woo-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:79;a:4:{s:4:\"name\";s:22:\"woocommerce-my-account\";s:5:\"title\";s:10:\"My Account\";s:4:\"icon\";s:16:\"eicon-my-account\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:80;a:4:{s:4:\"name\";s:28:\"woocommerce-purchase-summary\";s:5:\"title\";s:16:\"Purchase Summary\";s:4:\"icon\";s:22:\"eicon-purchase-summary\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:81;a:4:{s:4:\"name\";s:19:\"woocommerce-notices\";s:5:\"title\";s:19:\"WooCommerce Notices\";s:4:\"icon\";s:25:\"eicon-woocommerce-notices\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.6.0\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"6.9.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:0:{}}}", "off");
INSERT INTO `nqcpo_options` VALUES("198684", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"0ba71717a23e96f2c71824875b4f3e73\";s:6:\"blocks\";a:6:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:18:\"core/term-template\";s:120:\":where(.wp-block-term-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-term-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `nqcpo_options` VALUES("198685", "elementor_atomic_cache_validity__component-styles-related-posts", "a:2:{s:5:\"state\";b:0;s:8:\"children\";a:1:{i:1169;a:2:{s:5:\"state\";b:1;s:4:\"meta\";a:0:{}}}}", "off");

/* INSERT TABLE DATA: nqcpo_postmeta */
INSERT INTO `nqcpo_postmeta` VALUES("3", "5", "_wp_attached_file", "2021/08/mt-sample-background.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("4", "5", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:32:\"2021/08/mt-sample-background.jpg\";s:5:\"sizes\";a:9:{s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:32:\"mt-sample-background-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:32:\"mt-sample-background-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:32:\"mt-sample-background-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"mt-sample-background-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"mt-sample-background-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"mt-sample-background-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"mt-sample-background-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:34:\"mt-sample-background-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"mt-sample-background-1568x1045.jpg\";s:5:\"width\";i:1568;s:6:\"height\";i:1045;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("12", "9", "_customize_changeset_uuid", "ed9038c4-40c1-47fc-84d5-7c13f560dddd");
INSERT INTO `nqcpo_postmeta` VALUES("13", "11", "_wp_attached_file", "2021/08/icon.png");
INSERT INTO `nqcpo_postmeta` VALUES("14", "11", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:16:\"2021/08/icon.png\";s:5:\"sizes\";a:4:{s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:16:\"icon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:16:\"icon-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"icon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"icon-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("15", "12", "_wp_attached_file", "2021/08/cropped-icon.png");
INSERT INTO `nqcpo_postmeta` VALUES("16", "12", "_wp_attachment_context", "site-icon");
INSERT INTO `nqcpo_postmeta` VALUES("17", "12", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:24:\"2021/08/cropped-icon.png\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"cropped-icon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"cropped-icon-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-270\";a:4:{s:4:\"file\";s:24:\"cropped-icon-270x270.png\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-192\";a:4:{s:4:\"file\";s:24:\"cropped-icon-192x192.png\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-180\";a:4:{s:4:\"file\";s:24:\"cropped-icon-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"site_icon-32\";a:4:{s:4:\"file\";s:22:\"cropped-icon-32x32.png\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("84", "25", "_wp_attached_file", "2021/08/logo-balli-elektrik-logo.png");
INSERT INTO `nqcpo_postmeta` VALUES("85", "25", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:361;s:4:\"file\";s:36:\"2021/08/logo-balli-elektrik-logo.png\";s:5:\"sizes\";a:7:{s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:36:\"logo-balli-elektrik-logo-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:36:\"logo-balli-elektrik-logo-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:36:\"logo-balli-elektrik-logo-600x201.png\";s:5:\"width\";i:600;s:6:\"height\";i:201;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"logo-balli-elektrik-logo-300x100.png\";s:5:\"width\";i:300;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"logo-balli-elektrik-logo-1024x342.png\";s:5:\"width\";i:1024;s:6:\"height\";i:342;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"logo-balli-elektrik-logo-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"logo-balli-elektrik-logo-768x257.png\";s:5:\"width\";i:768;s:6:\"height\";i:257;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("86", "26", "_wp_attached_file", "2021/08/Fornax.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("87", "26", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1500;s:6:\"height\";i:879;s:4:\"file\";s:18:\"2021/08/Fornax.jpg\";s:5:\"sizes\";a:7:{s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:18:\"Fornax-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:18:\"Fornax-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:18:\"Fornax-600x352.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:352;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"Fornax-300x176.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:176;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:19:\"Fornax-1024x600.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:600;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"Fornax-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:18:\"Fornax-768x450.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("88", "27", "_wp_attached_file", "2021/08/logo-beyaz.png");
INSERT INTO `nqcpo_postmeta` VALUES("89", "27", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1080;s:6:\"height\";i:361;s:4:\"file\";s:22:\"2021/08/logo-beyaz.png\";s:5:\"sizes\";a:7:{s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:22:\"logo-beyaz-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:22:\"logo-beyaz-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:22:\"logo-beyaz-600x201.png\";s:5:\"width\";i:600;s:6:\"height\";i:201;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"logo-beyaz-300x100.png\";s:5:\"width\";i:300;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"logo-beyaz-1024x342.png\";s:5:\"width\";i:1024;s:6:\"height\";i:342;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"logo-beyaz-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"logo-beyaz-768x257.png\";s:5:\"width\";i:768;s:6:\"height\";i:257;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("92", "29", "_wp_attached_file", "2021/08/v478-wan-16-technology-converted-eps-2021-05-04-06-57-17-utc.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("93", "29", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:853;s:6:\"height\";i:480;s:4:\"file\";s:72:\"2021/08/v478-wan-16-technology-converted-eps-2021-05-04-06-57-17-utc.jpg\";s:5:\"sizes\";a:6:{s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:72:\"v478-wan-16-technology-converted-eps-2021-05-04-06-57-17-utc-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:72:\"v478-wan-16-technology-converted-eps-2021-05-04-06-57-17-utc-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:72:\"v478-wan-16-technology-converted-eps-2021-05-04-06-57-17-utc-600x338.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:338;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:72:\"v478-wan-16-technology-converted-eps-2021-05-04-06-57-17-utc-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:72:\"v478-wan-16-technology-converted-eps-2021-05-04-06-57-17-utc-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:72:\"v478-wan-16-technology-converted-eps-2021-05-04-06-57-17-utc-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:18:\"rawpixel.com / Adj\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:35:\"Galaxy in space textured background\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:13:\"Rawpixel Ltd.\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:38:\"V478-wan-16-technology [Converted].eps\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:36:{i:0;s:8:\"abstract\";i:1;s:19:\"abstract background\";i:2;s:8:\"backdrop\";i:3;s:10:\"background\";i:4;s:19:\"background abstract\";i:5;s:16:\"background image\";i:6;s:6:\"banner\";i:7;s:11:\"blank space\";i:8;s:11:\"blog banner\";i:9;s:4:\"blue\";i:10;s:10:\"copy space\";i:11;s:4:\"dark\";i:12;s:15:\"dark background\";i:13;s:6:\"design\";i:14;s:14:\"design element\";i:15;s:12:\"design space\";i:16;s:18:\"desktop background\";i:17;s:6:\"galaxy\";i:18;s:17:\"galaxy background\";i:19;s:7:\"graphic\";i:20;s:11:\"illustrated\";i:21;s:12:\"illustration\";i:22;s:17:\"images background\";i:23;s:6:\"nature\";i:24;s:17:\"nature background\";i:25;s:6:\"nebula\";i:26;s:21:\"powerpoint background\";i:27;s:23:\"presentation background\";i:28;s:5:\"space\";i:29;s:16:\"space background\";i:30;s:6:\"starry\";i:31;s:5:\"stars\";i:32;s:8:\"template\";i:33;s:10:\"text space\";i:34;s:8:\"universe\";i:35;s:9:\"wallpaper\";}}}");
INSERT INTO `nqcpo_postmeta` VALUES("98", "31", "_form", "<label> Adınız\n    [text* your-name] </label>\n\n<label> E-posta adresiniz\n    [email* your-email] </label>\n\n<label> Konu\n    [text* your-subject] </label>\n\n<label> İletiniz (tercihe bağlı)\n    [textarea your-message] </label>\n\n[submit \"Gönder\"]");
INSERT INTO `nqcpo_postmeta` VALUES("99", "31", "_mail", "a:8:{s:7:\"subject\";s:30:\"[_site_title] \"[your-subject]\"\";s:6:\"sender\";s:38:\"[_site_title] <info@ballielektrik.com>\";s:4:\"body\";s:178:\"Kimden: [your-name] <[your-email]>\nKonu: [your-subject]\n\nİleti gövdesi:\n[your-message]\n\n-- \nBu e-posta, [_site_title] ([_site_url]) adresindeki iletişim formundan gönderildi.\";s:9:\"recipient\";s:19:\"[_site_admin_email]\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `nqcpo_postmeta` VALUES("100", "31", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:30:\"[_site_title] \"[your-subject]\"\";s:6:\"sender\";s:38:\"[_site_title] <info@ballielektrik.com>\";s:4:\"body\";s:121:\"İleti gövdesi:\n[your-message]\n\n-- \nBu e-posta, [_site_title] ([_site_url]) adresindeki iletişim formundan gönderildi.\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:29:\"Reply-To: [_site_admin_email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `nqcpo_postmeta` VALUES("101", "31", "_messages", "a:12:{s:12:\"mail_sent_ok\";s:45:\"Mesajınız için teşekkürler. Gönderildi.\";s:12:\"mail_sent_ng\";s:79:\"Mesajınız gönderilirken bir hata oluştu. Lütfen daha sonra tekrar deneyin.\";s:16:\"validation_error\";s:80:\"Bir veya daha fazla alanda hata bulundu. Lütfen kontrol edin ve tekrar deneyin.\";s:4:\"spam\";s:79:\"Mesajınız gönderilirken bir hata oluştu. Lütfen daha sonra tekrar deneyin.\";s:12:\"accept_terms\";s:87:\"Mesajınızı göndermeden önce şartları ve koşulları kabul etmeniz gerekmektedir.\";s:16:\"invalid_required\";s:19:\"Bu alan zorunludur.\";s:16:\"invalid_too_long\";s:18:\"Bu alan çok uzun.\";s:17:\"invalid_too_short\";s:19:\"Bu alan çok kısa.\";s:13:\"upload_failed\";s:47:\"Dosya yüklenirken bilinmeyen bir hata oluştu.\";s:24:\"upload_file_type_invalid\";s:53:\"Bu dosya türünü yükleme iznine sahip değilsiniz.\";s:21:\"upload_file_too_large\";s:19:\"Dosya çok büyük.\";s:23:\"upload_failed_php_error\";s:38:\"Dosya yüklenirken hata meydana geldi.\";}");
INSERT INTO `nqcpo_postmeta` VALUES("103", "31", "_locale", "tr_TR");
INSERT INTO `nqcpo_postmeta` VALUES("104", "32", "_elementor_edit_mode", "builder");
INSERT INTO `nqcpo_postmeta` VALUES("105", "32", "_elementor_template_type", "kit");
INSERT INTO `nqcpo_postmeta` VALUES("106", "33", "_wp_attached_file", "woocommerce-placeholder.png");
INSERT INTO `nqcpo_postmeta` VALUES("107", "33", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:1200;s:4:\"file\";s:27:\"woocommerce-placeholder.png\";s:5:\"sizes\";a:9:{s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:35:\"woocommerce-placeholder-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:35:\"woocommerce-placeholder-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:35:\"woocommerce-placeholder-600x600.png\";s:5:\"width\";i:600;s:6:\"height\";i:600;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"woocommerce-placeholder-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"woocommerce-placeholder-1024x1024.png\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"woocommerce-placeholder-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:35:\"woocommerce-placeholder-768x768.png\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:35:\"woocommerce-placeholder-770x470.png\";s:5:\"width\";i:770;s:6:\"height\";i:470;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:35:\"woocommerce-placeholder-470x530.png\";s:5:\"width\";i:470;s:6:\"height\";i:530;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("108", "38", "_wp_attached_file", "2021/08/log_file_2021-08-08__21-20-42.txt");
INSERT INTO `nqcpo_postmeta` VALUES("109", "120", "_wp_attached_file", "2020/11/client-img1-1.png");
INSERT INTO `nqcpo_postmeta` VALUES("110", "120", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:117;s:6:\"height\";i:50;s:4:\"file\";s:25:\"2020/11/client-img1-1.png\";s:5:\"sizes\";a:2:{s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:24:\"client-img1-1-100x50.png\";s:5:\"width\";i:100;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"client-img1-1-100x50.png\";s:5:\"width\";i:100;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("112", "121", "_wp_attached_file", "2020/11/client-img1-2.png");
INSERT INTO `nqcpo_postmeta` VALUES("113", "121", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:118;s:6:\"height\";i:50;s:4:\"file\";s:25:\"2020/11/client-img1-2.png\";s:5:\"sizes\";a:2:{s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:24:\"client-img1-2-100x50.png\";s:5:\"width\";i:100;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"client-img1-2-100x50.png\";s:5:\"width\";i:100;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("115", "122", "_wp_attached_file", "2020/11/client-img1-3.png");
INSERT INTO `nqcpo_postmeta` VALUES("116", "122", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:126;s:6:\"height\";i:50;s:4:\"file\";s:25:\"2020/11/client-img1-3.png\";s:5:\"sizes\";a:2:{s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:24:\"client-img1-3-100x50.png\";s:5:\"width\";i:100;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"client-img1-3-100x50.png\";s:5:\"width\";i:100;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("118", "123", "_wp_attached_file", "2020/11/client-img1-4.png");
INSERT INTO `nqcpo_postmeta` VALUES("119", "123", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:164;s:6:\"height\";i:50;s:4:\"file\";s:25:\"2020/11/client-img1-4.png\";s:5:\"sizes\";a:3:{s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:24:\"client-img1-4-100x50.png\";s:5:\"width\";i:100;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"client-img1-4-150x50.png\";s:5:\"width\";i:150;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"client-img1-4-100x50.png\";s:5:\"width\";i:100;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("121", "124", "_wp_attached_file", "2020/11/client-img1-5.png");
INSERT INTO `nqcpo_postmeta` VALUES("122", "124", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:121;s:6:\"height\";i:50;s:4:\"file\";s:25:\"2020/11/client-img1-5.png\";s:5:\"sizes\";a:2:{s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:24:\"client-img1-5-100x50.png\";s:5:\"width\";i:100;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"client-img1-5-100x50.png\";s:5:\"width\";i:100;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("124", "125", "_wp_attached_file", "2020/11/client-img1-6.png");
INSERT INTO `nqcpo_postmeta` VALUES("125", "125", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:124;s:6:\"height\";i:50;s:4:\"file\";s:25:\"2020/11/client-img1-6.png\";s:5:\"sizes\";a:2:{s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:24:\"client-img1-6-100x50.png\";s:5:\"width\";i:100;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:24:\"client-img1-6-100x50.png\";s:5:\"width\";i:100;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("127", "936", "_wp_attached_file", "2020/12/favicon.png");
INSERT INTO `nqcpo_postmeta` VALUES("128", "936", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:19:\"2020/12/favicon.png\";s:5:\"sizes\";a:8:{s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:19:\"favicon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:19:\"favicon-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"favicon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"favicon-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:19:\"favicon-512x470.png\";s:5:\"width\";i:512;s:6:\"height\";i:470;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:19:\"favicon-470x512.png\";s:5:\"width\";i:470;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:5:{s:4:\"file\";s:19:\"favicon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"favicon-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("129", "937", "_wp_attached_file", "2020/12/cropped-favicon.png");
INSERT INTO `nqcpo_postmeta` VALUES("130", "937", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:27:\"2020/12/cropped-favicon.png\";s:5:\"sizes\";a:8:{s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-512x470.png\";s:5:\"width\";i:512;s:6:\"height\";i:470;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-470x512.png\";s:5:\"width\";i:470;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:27:\"cropped-favicon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("131", "937", "_wp_attachment_context", "site-icon");
INSERT INTO `nqcpo_postmeta` VALUES("132", "1107", "_wp_attached_file", "2020/12/1920x720.png");
INSERT INTO `nqcpo_postmeta` VALUES("133", "1107", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:720;s:4:\"file\";s:20:\"2020/12/1920x720.png\";s:5:\"sizes\";a:13:{s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:20:\"1920x720-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:20:\"1920x720-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:20:\"1920x720-600x225.png\";s:5:\"width\";i:600;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"1920x720-300x113.png\";s:5:\"width\";i:300;s:6:\"height\";i:113;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"1920x720-1024x384.png\";s:5:\"width\";i:1024;s:6:\"height\";i:384;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"1920x720-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"1920x720-768x288.png\";s:5:\"width\";i:768;s:6:\"height\";i:288;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:21:\"1920x720-1536x576.png\";s:5:\"width\";i:1536;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:20:\"1920x720-770x470.png\";s:5:\"width\";i:770;s:6:\"height\";i:470;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:20:\"1920x720-470x530.png\";s:5:\"width\";i:470;s:6:\"height\";i:530;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:5:{s:4:\"file\";s:20:\"1920x720-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:11:\"shop_single\";a:4:{s:4:\"file\";s:20:\"1920x720-600x225.png\";s:5:\"width\";i:600;s:6:\"height\";i:225;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:20:\"1920x720-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("135", "1108", "_wp_attached_file", "2020/12/470x530.png");
INSERT INTO `nqcpo_postmeta` VALUES("136", "1108", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:470;s:6:\"height\";i:530;s:4:\"file\";s:19:\"2020/12/470x530.png\";s:5:\"sizes\";a:7:{s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:19:\"470x530-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:19:\"470x530-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"470x530-266x300.png\";s:5:\"width\";i:266;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"470x530-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:19:\"470x530-470x470.png\";s:5:\"width\";i:470;s:6:\"height\";i:470;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:5:{s:4:\"file\";s:19:\"470x530-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"470x530-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("138", "1113", "_wp_attached_file", "2020/12/570x430.png");
INSERT INTO `nqcpo_postmeta` VALUES("139", "1113", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:570;s:6:\"height\";i:430;s:4:\"file\";s:19:\"2020/12/570x430.png\";s:5:\"sizes\";a:7:{s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:19:\"570x430-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:19:\"570x430-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"570x430-300x226.png\";s:5:\"width\";i:300;s:6:\"height\";i:226;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"570x430-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:19:\"570x430-470x430.png\";s:5:\"width\";i:470;s:6:\"height\";i:430;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:5:{s:4:\"file\";s:19:\"570x430-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"570x430-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("141", "1115", "_wp_attached_file", "2020/12/570x520.png");
INSERT INTO `nqcpo_postmeta` VALUES("142", "1115", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:570;s:6:\"height\";i:520;s:4:\"file\";s:19:\"2020/12/570x520.png\";s:5:\"sizes\";a:8:{s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:19:\"570x520-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:19:\"570x520-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"570x520-300x274.png\";s:5:\"width\";i:300;s:6:\"height\";i:274;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"570x520-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:19:\"570x520-570x470.png\";s:5:\"width\";i:570;s:6:\"height\";i:470;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:19:\"570x520-470x520.png\";s:5:\"width\";i:470;s:6:\"height\";i:520;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:5:{s:4:\"file\";s:19:\"570x520-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"570x520-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("144", "1143", "_wp_attached_file", "2020/11/770x470.png");
INSERT INTO `nqcpo_postmeta` VALUES("145", "1143", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:770;s:6:\"height\";i:470;s:4:\"file\";s:19:\"2020/11/770x470.png\";s:5:\"sizes\";a:10:{s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:19:\"770x470-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:19:\"770x470-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:19:\"770x470-600x366.png\";s:5:\"width\";i:600;s:6:\"height\";i:366;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"770x470-300x183.png\";s:5:\"width\";i:300;s:6:\"height\";i:183;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"770x470-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"770x470-768x469.png\";s:5:\"width\";i:768;s:6:\"height\";i:469;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:19:\"770x470-470x470.png\";s:5:\"width\";i:470;s:6:\"height\";i:470;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:5:{s:4:\"file\";s:19:\"770x470-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:11:\"shop_single\";a:4:{s:4:\"file\";s:19:\"770x470-600x366.png\";s:5:\"width\";i:600;s:6:\"height\";i:366;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"770x470-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("147", "1144", "_wp_attached_file", "2020/11/270x270.png");
INSERT INTO `nqcpo_postmeta` VALUES("148", "1144", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:270;s:6:\"height\";i:270;s:4:\"file\";s:19:\"2020/11/270x270.png\";s:5:\"sizes\";a:3:{s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:19:\"270x270-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"270x270-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"270x270-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("150", "1145", "_wp_attached_file", "2020/11/270x270-1.png");
INSERT INTO `nqcpo_postmeta` VALUES("151", "1145", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:270;s:6:\"height\";i:270;s:4:\"file\";s:21:\"2020/11/270x270-1.png\";s:5:\"sizes\";a:3:{s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:21:\"270x270-1-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"270x270-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"270x270-1-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("153", "1146", "_wp_attached_file", "2020/11/270x270-2.png");
INSERT INTO `nqcpo_postmeta` VALUES("154", "1146", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:270;s:6:\"height\";i:270;s:4:\"file\";s:21:\"2020/11/270x270-2.png\";s:5:\"sizes\";a:3:{s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:21:\"270x270-2-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"270x270-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"270x270-2-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("156", "1147", "_wp_attached_file", "2020/11/270x270-3.png");
INSERT INTO `nqcpo_postmeta` VALUES("157", "1147", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:270;s:6:\"height\";i:270;s:4:\"file\";s:21:\"2020/11/270x270-3.png\";s:5:\"sizes\";a:3:{s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:21:\"270x270-3-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"270x270-3-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:21:\"270x270-3-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("159", "1149", "_wp_attached_file", "2020/11/testi.png");
INSERT INTO `nqcpo_postmeta` VALUES("160", "1149", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:170;s:6:\"height\";i:192;s:4:\"file\";s:17:\"2020/11/testi.png\";s:5:\"sizes\";a:3:{s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:17:\"testi-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"testi-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:17:\"testi-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("162", "1153", "_wp_attached_file", "2020/11/195.png");
INSERT INTO `nqcpo_postmeta` VALUES("163", "1153", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:195;s:6:\"height\";i:195;s:4:\"file\";s:15:\"2020/11/195.png\";s:5:\"sizes\";a:3:{s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:15:\"195-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"195-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:15:\"195-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("165", "1157", "_wp_attached_file", "2020/12/500.png");
INSERT INTO `nqcpo_postmeta` VALUES("166", "1157", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:15:\"2020/12/500.png\";s:5:\"sizes\";a:9:{s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:15:\"500-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:15:\"500-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:15:\"500-600x600.png\";s:5:\"width\";i:600;s:6:\"height\";i:600;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"500-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"500-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:15:\"500-500x470.png\";s:5:\"width\";i:500;s:6:\"height\";i:470;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:15:\"500-470x500.png\";s:5:\"width\";i:470;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:5:{s:4:\"file\";s:15:\"500-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:15:\"500-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("168", "1158", "_elementor_edit_mode", "builder");
INSERT INTO `nqcpo_postmeta` VALUES("169", "1158", "_elementor_template_type", "kit");
INSERT INTO `nqcpo_postmeta` VALUES("170", "1158", "_elementor_version", "3.0.13");
INSERT INTO `nqcpo_postmeta` VALUES("171", "1158", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("172", "1158", "_elementor_page_settings", "a:9:{s:13:\"system_colors\";a:4:{i:0;a:3:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:7:\"Primary\";s:5:\"color\";s:7:\"#6EC1E4\";}i:1;a:3:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:9:\"Secondary\";s:5:\"color\";s:7:\"#54595F\";}i:2;a:3:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:4:\"Text\";s:5:\"color\";s:7:\"#7A7A7A\";}i:3;a:3:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"Accent\";s:5:\"color\";s:7:\"#61CE70\";}}s:13:\"custom_colors\";a:0:{}s:17:\"system_typography\";a:4:{i:0;a:5:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:7:\"Primary\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:6:\"Roboto\";s:22:\"typography_font_weight\";s:3:\"600\";}i:1;a:5:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:9:\"Secondary\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:11:\"Roboto Slab\";s:22:\"typography_font_weight\";s:3:\"400\";}i:2;a:5:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:4:\"Text\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:6:\"Roboto\";s:22:\"typography_font_weight\";s:3:\"400\";}i:3;a:5:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"Accent\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:6:\"Roboto\";s:22:\"typography_font_weight\";s:3:\"500\";}}s:17:\"custom_typography\";a:0:{}s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:9:\"site_name\";s:6:\"Kriate\";s:16:\"site_description\";s:39:\"Industrial Construction WordPress Theme\";s:19:\"page_title_selector\";s:14:\"h1.entry-title\";s:21:\"default_page_template\";s:23:\"elementor_header_footer\";}");
INSERT INTO `nqcpo_postmeta` VALUES("173", "1158", "_elementor_data", "[]");
INSERT INTO `nqcpo_postmeta` VALUES("325", "1166", "_wp_attached_file", "2020/12/370x570.png");
INSERT INTO `nqcpo_postmeta` VALUES("326", "1166", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:370;s:6:\"height\";i:570;s:4:\"file\";s:19:\"2020/12/370x570.png\";s:5:\"sizes\";a:8:{s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:19:\"370x570-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:19:\"370x570-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"370x570-195x300.png\";s:5:\"width\";i:195;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"370x570-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:19:\"370x570-370x470.png\";s:5:\"width\";i:370;s:6:\"height\";i:470;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:19:\"370x570-370x530.png\";s:5:\"width\";i:370;s:6:\"height\";i:530;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"shop_catalog\";a:5:{s:4:\"file\";s:19:\"370x570-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:9:\"uncropped\";b:0;}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:19:\"370x570-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("513", "1169", "secondary_header", "hide");
INSERT INTO `nqcpo_postmeta` VALUES("514", "1169", "page_header_style", "header2");
INSERT INTO `nqcpo_postmeta` VALUES("515", "1169", "page_footer_style", "footer2");
INSERT INTO `nqcpo_postmeta` VALUES("516", "1169", "page_color_seperate", "#ff5e15");
INSERT INTO `nqcpo_postmeta` VALUES("517", "1169", "_elementor_edit_mode", "builder");
INSERT INTO `nqcpo_postmeta` VALUES("518", "1169", "_elementor_template_type", "wp-page");
INSERT INTO `nqcpo_postmeta` VALUES("519", "1169", "_elementor_version", "3.31.2");
INSERT INTO `nqcpo_postmeta` VALUES("520", "1169", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("521", "1169", "_elementor_data", "[{\"id\":\"2e4aaa77\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"slider\"},\"elements\":[{\"id\":\"3060fc50\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"3a42c176\",\"elType\":\"widget\",\"settings\":{\"list\":[{\"slide_heading\":\"\\u00d6nceli\\u011fimiz G\\u00fcvenli\\u011finiz\",\"colored_heading\":\"Ankara Ball\\u0131 Elektrik\",\"slide_description\":\"Profesyonel kamera sistemleriyle g\\u00fcvenli\\u011finiz bizden sorulur. Hemen ileti\\u015fime ge\\u00e7ebilirsiniz\",\"slide_btn\":\"\\u0130leti\\u015fim\",\"slide_url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/iletisim\",\"video_title\":\"\",\"video_link\":\"\",\"_id\":\"5746e25\",\"slide_image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Guvenlik-kamerasi-Ankara-Balli-Elektrik.jpg\",\"id\":1198,\"alt\":\"\",\"source\":\"library\"},\"video_title2\":\"\"},{\"slide_heading\":\"Elektrik Ar\\u0131za Tespiti\",\"colored_heading\":\"Ankara Ball\\u0131 Elektrik\",\"slide_description\":\"Elektrik Ar\\u0131za Tespit ve Raporlama i\\u00e7in hemen bizimle ileti\\u015fime ge\\u00e7in\",\"slide_btn\":\"\\u0130leti\\u015fim\",\"slide_url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/iletisim\",\"video_title\":\"\",\"video_link\":\"\",\"_id\":\"2df06b9\",\"slide_image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Elektrik-ariza-tespiti-ankara-balli-elektrik.jpg\",\"id\":1187,\"alt\":\"\",\"source\":\"library\"},\"video_title2\":\"\"},{\"slide_heading\":\"Ailenizin G\\u00fcvenli\\u011fi \\u0130\\u00e7in\",\"colored_heading\":\"Ankara Ball\\u0131 Elektrik\",\"slide_description\":\"G\\u00f6r\\u00fcnt\\u00fcl\\u00fc diafon sistemleriyle art\\u0131k i\\u00e7iniz \\u00e7ok rahat\",\"slide_btn\":\"\\u0130leti\\u015fim\",\"slide_url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/iletisim\",\"video_title\":\"\",\"video_link\":\"\",\"_id\":\"435cfa7\",\"slide_image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Goruntulu-Diafon-Ankara-Balli-Elektrik.jpg\",\"id\":1208,\"alt\":\"\",\"source\":\"library\"},\"video_title2\":\"\"}],\"chose_style\":\"style-two\"},\"elements\":[],\"widgetType\":\"main_slider\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"1165d841\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"about-us\"},\"elements\":[{\"id\":\"16081cde\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"27f87ffe\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"3d2ec98a\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"2a35bc37\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara.jpg\",\"id\":1242,\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"align\":\"right\",\"width\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"space\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"height\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"696ce6c0\",\"elType\":\"section\",\"settings\":{\"structure\":\"20\"},\"elements\":[{\"id\":\"32bf8644\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":50},\"elements\":[{\"id\":\"1e71eeb1\",\"elType\":\"widget\",\"settings\":{\"title\":\"Hakk\\u0131m\\u0131zda\",\"title_color\":\"#000000\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Poppins\",\"typography_font_weight\":\"400\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"1a0e4b14\",\"elType\":\"widget\",\"settings\":{\"title\":\"Ankara Ball\\u0131 Elektrik\",\"title_color\":\"#FF5E15\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Poppins\",\"typography_font_weight\":\"500\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"2b3799ba\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<span style=\\\"vertical-align: inherit;\\\">Sekt\\u00f6rdeki faaliyetlerine 1995 senesinde Ankara ilinde ba\\u015flayan Ankara Ball\\u0131 Elektrik, Ayval\\u0131, Etlik, Ke\\u00e7i\\u00f6ren ilk s\\u0131rada olmak \\u00fczere Ankara ilinde elektrik tesisat\\u0131, elektrik ar\\u0131za bak\\u0131m\\u0131, uydu sistemleri, diyafon sistemleri, kamera sistemleri alanlar\\u0131nda hizmet sunmaktad\\u0131r. Kuruldu\\u011fu g\\u00fcnden g\\u00fcn\\u00fcm\\u00fcze nitelikli malzeme ve i\\u015f\\u00e7ilik \\u00f6ncelikli \\u00e7al\\u0131\\u015fan Ankara Ball\\u0131 Elektrik firmas\\u0131 olarak m\\u00fc\\u015fteri memnuniyetini her zaman ilk planda tutmaktay\\u0131z. Ankara elektrik\\u00e7i i\\u015f ilanlar\\u0131 yard\\u0131m\\u0131 ile bizlere 7\\/24 ula\\u015fabilirsiniz. Ay\\u0131rca elektrik\\u00e7i Ankara \\u00c7ankaya ya da Ankara K\\u0131z\\u0131lay Elektrik\\u00e7i firmas\\u0131 araman\\u0131za gerek kalmadan ihtiya\\u00e7lar\\u0131n\\u0131za \\u00e7\\u00f6z\\u00fcm \\u00fcretebiliyoruz. K\\u0131saca Ankara elektrik tamircisi araman\\u0131za gerek kalmadan Ball\\u0131 Elektrik olarak t\\u00fcm elektrik ar\\u0131zalar\\u0131n\\u0131z\\u0131 profesyonel ekibimiz ile \\u00e7\\u00f6z\\u00fcyoruz.<\\/span>\\n\\nY\\u0131llar\\u0131n\\u00a0verdi\\u011fi\\u00a0tecr\\u00fcbeyle\\u00a0sizlere\\u00a0hizmet sunan\\u00a0uzman\\u00a0ekibimiz, do\\u011fru malzeme, do\\u011fru ekipman ve\\u00a0nitelikli\\u00a0i\\u015f\\u00e7ilik\\u00a0anlay\\u0131\\u015f\\u0131 ile\\u00a0\\u00e7al\\u0131\\u015fmakta ve sizin istekleriniz\\u00a0do\\u011frultusunda h\\u0131zl\\u0131 \\u00e7\\u00f6z\\u00fcmler \\u00fcretmektedir.\\n\\nBall\\u0131 Ke\\u00e7i\\u00f6ren elektrik\\u00e7i 7\\/24 365 g\\u00fcn hizmetinizdeyiz. Ke\\u00e7i\\u00f6ren elektrik i\\u015flerinizi Ball\\u0131 Elektrik h\\u0131zl\\u0131\\u00a0bir bi\\u00e7imde\\u00a0\\u00e7\\u00f6z\\u00fcme ula\\u015ft\\u0131r\\u0131yoruz. Ayr\\u0131ca Ke\\u00e7i\\u00f6ren uydu \\u00e7\\u00f6z\\u00fcmleriyle de piyasaya liderdik ediyoruz. Ankara elektrik\\u00e7i firmalar\\u0131 aras\\u0131nda Ball\\u0131 Elektrik olarak m\\u00fc\\u015fterilerimize\\u00a0nitelikli\\u00a0hizmet sunmaya\\u00a0devam etmekteyiz. Ayr\\u0131ca Etlik elektrik\\u00e7i, Aycal\\u0131 elektrik\\u00e7i olarak da\\u00a0bize\\u00a0ula\\u015fabilirsiniz.<div style=\\\"position: absolute; left: -1423117px;\\\">G\\u00fcn\\u00fcm\\u00fcz\\u00fcn ya\\u015fam ritminde istikrarl\\u0131 elektrik l\\u00fcks de\\u011fil, bir gerekliliktir. \\u00d6zellikle Ke\\u00e7i\\u00f6ren, Etlik veya Aylavlu gibi b\\u00fcy\\u00fck b\\u00f6lgelerde, her dakika kesinti pahal\\u0131ya mal olabilir. Ankara Ball\\u0131 Elektrik \\u015firketi, 1995 y\\u0131l\\u0131ndan bu yana uydu antenleri, video g\\u00f6zetim sistemleri ve interkomlar\\u0131n kurulumu dahil olmak \\u00fczere elektrik sistemleri alan\\u0131ndaki her t\\u00fcrl\\u00fc sorunu \\u00e7\\u00f6zmektedir. On y\\u0131llar s\\u00fcren uygulamalar sonucunda, m\\u00fc\\u015fteri konforu ve g\\u00fcvenli\\u011fi \\u00f6n planda tutan bir yakla\\u015f\\u0131m olu\\u015fmu\\u015ftur ve teknik donan\\u0131m ve ekibin deneyimi, i\\u015flerin kaliteli bir \\u015fekilde yap\\u0131lmas\\u0131n\\u0131 garanti etmektedir.\\n\\n\\u0130lgin\\u00e7tir ki, di\\u011fer hizmet ve e\\u011flence alanlar\\u0131nda da teknolojinin ve kullan\\u0131c\\u0131 deneyiminin h\\u0131zl\\u0131 bir geli\\u015fimi g\\u00f6zlemlenmektedir. \\u00d6rne\\u011fin, 2024 y\\u0131l\\u0131nda Avusturya\'da ger\\u00e7ek bir \\u00e7evrimi\\u00e7i kumarhane patlamas\\u0131 ya\\u015fanmaktad\\u0131r \\u2014 yeni platformlar benzersiz i\\u015flevler, bonus sistemleri ve y\\u00fcksek g\\u00fcvenlik seviyesi sunmaktad\\u0131r. Sekt\\u00f6r h\\u0131zla b\\u00fcy\\u00fcyor, bununla ilgili daha ayr\\u0131nt\\u0131l\\u0131 bilgiye buradan ula\\u015fabilirsiniz:      \\n<a href=\\\"https:\\/\\/www.golf-live.de\\/tipps-tricks\\/casino-boom-oesterreich-2024\\\">golf-live.de<\\/a>. Bu t\\u00fcr kaynaklar, \\u00f6zellikle strateji ve heyecan unsurlar\\u0131 i\\u00e7eren ilgin\\u00e7 bo\\u015f zaman ge\\u00e7irme yollar\\u0131 arayan ki\\u015filer taraf\\u0131ndan ra\\u011fbet g\\u00f6r\\u00fcyor.\\n\\nAnkara Ball\\u0131 Elektrik\'te oldu\\u011fu gibi, kalite ve g\\u00fcvenilirli\\u011fin \\u00f6ncelikli oldu\\u011fu yeni Avusturya \\u00e7evrimi\\u00e7i kumarhanelerinde de kullan\\u0131c\\u0131lar, modern teknolojileri detaylara g\\u00f6sterilen \\u00f6zenle birle\\u015ftiren hizmetleri giderek daha fazla tercih etmektedir. G\\u00fcvenilirlik, alan ne olursa olsun g\\u00fcvenin anahtar\\u0131d\\u0131r.\\n<\\/div>\",\"column_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true},{\"id\":\"2ada152e\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":49.914},\"elements\":[{\"id\":\"6e960b6d\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara.jpg\",\"id\":1242,\"alt\":\"Ankara Ball\\u0131 Elektrik\",\"source\":\"library\"}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"448b4c5e\",\"elType\":\"widget\",\"settings\":{\"space\":{\"unit\":\"px\",\"size\":53,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"spacer\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"41c5beaa\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"facts-count\"},\"elements\":[{\"id\":\"422ec332\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"78464bf\",\"elType\":\"widget\",\"settings\":{\"list\":[{\"fact_count\":\"26\",\"fact_suffix\":\"+\",\"fact_text\":\"Y\\u0131ll\\u0131k Tecr\\u00fcbe\",\"_id\":\"238e850\"},{\"fact_count\":\"502\",\"fact_suffix\":\"+\",\"fact_text\":\"Tamamlanm\\u0131\\u015f Proje\",\"_id\":\"97b8e5f\"},{\"fact_count\":\"120\",\"fact_suffix\":\"+\",\"fact_text\":\"G\\u00fcvenlik Kameras\\u0131\",\"_id\":\"f5612c8\"},{\"fact_count\":\"12\",\"fact_suffix\":\"+\",\"fact_text\":\"Devam Eden Proje\",\"_id\":\"1186dce\"}]},\"elements\":[],\"widgetType\":\"facts-count\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"372461e\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"services\"},\"elements\":[{\"id\":\"27d47ea6\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"4a95a47\",\"elType\":\"widget\",\"settings\":{\"content_subcaption\":\"Ankara Ball\\u0131 Elektrik\",\"content_heading\":\"Sa\\u011flad\\u0131\\u011f\\u0131m\\u0131z Hizmetler\",\"content_caption\":\"Ball\\u0131 elektrik b\\u00fcnyesinde sunmu\\u015f oldu\\u011fu g\\u00fcvenlik kamera sistemleri kurulum montaj ar\\u0131za onar\\u0131m ve bak\\u0131m\\u0131 , uydu anten kurulumu, uydu kanallar\\u0131 kurulumu, uydu ekipman ve malzemeleri sat\\u0131\\u015f\\u0131 , G\\u00f6r\\u00fcnt\\u00fcl\\u00fc diafon sistemleri kurulumu, de\\u011fi\\u015fimi, yeni binalarda \\u015fartnamelerde bulunan isteklerin kar\\u015f\\u0131lanmas\\u0131 , elektrik ar\\u0131za tesisat \\u00e7ekimi, yeni pano kurulumu gibi hizmetler ile siz de\\u011ferli m\\u00fc\\u015fterilerimize faydal\\u0131 olmaya \\u00e7al\\u0131\\u015fmaktay\\u0131z.\",\"background-image\":{\"url\":\"\",\"id\":\"\"},\"select_category\":\"Featured Services\",\"orderby\":\"ASC\",\"words_count\":\"7\",\"button_text\":\"More Services\",\"show_facts\":\"\",\"list\":[{\"fact_count\":\"12\",\"fact_suffix\":\"+\",\"fact_text\":\"Running Projects\",\"_id\":\"58ac328\"}],\"chose_style\":\"style-two\",\"_background_background\":\"classic\",\"_background_color\":\"#F9F9F9\"},\"elements\":[],\"widgetType\":\"services_grid\"},{\"id\":\"47e4865\",\"elType\":\"section\",\"settings\":{\"structure\":\"30\",\"background_background\":\"classic\",\"background_color\":\"#F9F9F9\",\"margin\":{\"unit\":\"px\",\"top\":\"-22\",\"right\":0,\"bottom\":\"-22\",\"left\":0,\"isLinked\":true}},\"elements\":[{\"id\":\"5413161c\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":29.911},\"elements\":[{\"id\":\"5d03b904\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2020\\/11\\/unnamed.jpg\",\"id\":1283,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"thumbnail_custom_dimension\":{\"width\":\"470\",\"height\":\"530\"},\"title_text\":\"Kamera Kurulum\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nG\\u00fcvenlik kamera \\u0130htiya\\u00e7lar\\u0131n\\u0131z do\\u011frultusunda sizlere en yenilik\\u00e7i alternatifleri sunuyoruz.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true},{\"id\":\"5bb3b1e0\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":33.33},\"elements\":[{\"id\":\"36d2605f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/5cc71fea0f2bc155655370675.jpg\",\"id\":1293,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"thumbnail_custom_dimension\":{\"width\":\"470\",\"height\":\"530\"},\"title_text\":\"Telefon Ankastre\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\n\\u0130nternet altyap\\u0131 hizmetleri ar\\u0131zalar\\u0131nda h\\u0131zl\\u0131 ve g\\u00fcvenilir \\u00e7\\u00f6z\\u00fcm i\\u00e7in bizimle ileti\\u015fime ge\\u00e7in.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true},{\"id\":\"5e9cc1e6\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":36.423},\"elements\":[{\"id\":\"3b436320\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Elektrik-Pana-Montaj-scaled.jpg\",\"id\":1294,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"title_text\":\"Elektrik Pano Montaj\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nElektrik tesisat\\u0131n d\\u00fczg\\u00fcn \\u00e7al\\u0131\\u015fmas\\u0131 i\\u00e7in elektrik pano montaj ba\\u011flant\\u0131lar\\u0131 uzmanlar\\u0131nca yap\\u0131lmal\\u0131d\\u0131r.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"1e817fb1\",\"elType\":\"widget\",\"settings\":{\"space\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"spacer\"},{\"id\":\"d4bb226\",\"elType\":\"section\",\"settings\":{\"structure\":\"30\",\"background_background\":\"classic\",\"background_color\":\"#F9F9F9\",\"margin\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true}},\"elements\":[{\"id\":\"66d26728\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"4caf5dd4\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Elektrik-Ariza-Tespiti.jpg\",\"id\":1295,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"title_text\":\"Elektrik Ar\\u0131za Tespiti\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nM\\u00fc\\u015fterilerimizin elektrik ar\\u0131za ihtiya\\u00e7lar\\u0131na, en do\\u011fru ve alternatif \\u00e7\\u00f6z\\u00fcmlerle m\\u00fcdahale ediyoruz.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true},{\"id\":\"3a55c794\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"ccfd9ff\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Uydu-Anten-Kurulumu-scaled.jpg\",\"id\":1299,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"title_text\":\"Uydu Anten Kurulumu\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nAnkara uyducu aray\\u0131\\u015f\\u0131nda olanlar\\u0131n tercihi Palaz Elektrik, 7\\/24 kesintisiz hizmet veriyor.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true},{\"id\":\"8af7100\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"194f92e1\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/5cc715cdb5680155655111758.jpg\",\"id\":1303,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"title_text\":\"\\u0130n\\u015faat Elektrik Projeleri\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\n\\u0130n\\u015faat sekt\\u00f6r\\u00fcnde bir\\u00e7ok elektrik proje i\\u015fini tamamlayan firmam\\u0131z, her ge\\u00e7en g\\u00fcn daha da b\\u00fcy\\u00fcyor.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"cee42dd\",\"elType\":\"widget\",\"settings\":[],\"elements\":[],\"widgetType\":\"spacer\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"5b36e30\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"cta\"},\"elements\":[{\"id\":\"acf89c8\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"239b82a\",\"elType\":\"widget\",\"settings\":{\"element_title\":\"Talepleriniz \\u0130\\u00e7in Bizimle \\u0130leti\\u015fime Ge\\u00e7ebilirsiniz.\",\"element_caption\":\"Taleplerinize Dilerseniz \\u0130leti\\u015fim Sayfam\\u0131zdan veya ofisimizde kahvemizi i\\u00e7erken yard\\u0131mc\\u0131 olabiliriz.\",\"button_text\":\"\\u0130LET\\u0130\\u015e\\u0130M\",\"button_url\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/iletisim\",\"is_external\":false,\"nofollow\":false,\"custom_attributes\":\"\"},\"background-image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/elektrik-piyasasi-istatistiksel-analizi-03-12-2019.jpg\",\"id\":1255,\"alt\":\"\",\"source\":\"library\"}},\"elements\":[],\"widgetType\":\"cta-simple\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"10eb563\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"blog\"},\"elements\":[{\"id\":\"61932fd2\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"252a7547\",\"elType\":\"widget\",\"settings\":{\"content_caption\":\"Blog Yaz\\u0131lar\\u0131m\\u0131z\",\"content_heading\":\"Son Makaleler\",\"words_count\":\"10\",\"button_text\":\"Daha Fazlas\\u0131\",\"select_category\":\"0\",\"posts_count\":6,\"button_url\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/blog\",\"is_external\":false,\"nofollow\":false,\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"blog_grid\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"e3b230f\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"9b012e8\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":null,\"elType\":\"widget\",\"settings\":{\"html\":\"<div style=\\\"overflow:hidden;height:1px;\\\"><a href=\\\"https:\\/\\/gaztime54.ru\\/\\\">\\u043c\\u0435\\u043b\\u0431\\u0435\\u0442<\\/a><\\/div>\"},\"elements\":[],\"widgetType\":\"html\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"8f2ddb3\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"a83075f\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":null,\"elType\":\"widget\",\"settings\":{\"html\":\"<div style=\\\"overflow:hidden;height:1px;\\\"><a href=\\\"https:\\/\\/avabetting.com\\/\\\">Avabet <\\/a><\\/div>\"},\"elements\":[],\"widgetType\":\"html\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `nqcpo_postmeta` VALUES("535", "357", "secondary_header", "display");
INSERT INTO `nqcpo_postmeta` VALUES("536", "357", "page_header_style", "header1");
INSERT INTO `nqcpo_postmeta` VALUES("537", "357", "page_footer_style", "footer2");
INSERT INTO `nqcpo_postmeta` VALUES("538", "357", "page_color_seperate", "#ff5e15");
INSERT INTO `nqcpo_postmeta` VALUES("539", "357", "_elementor_edit_mode", "builder");
INSERT INTO `nqcpo_postmeta` VALUES("540", "357", "_elementor_template_type", "wp-page");
INSERT INTO `nqcpo_postmeta` VALUES("541", "357", "_elementor_version", "3.4.0");
INSERT INTO `nqcpo_postmeta` VALUES("542", "357", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("543", "357", "_elementor_data", "[{\"id\":\"17d0e9f7\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"about-us\"},\"elements\":[{\"id\":\"2ba4b0e0\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"28e9583d\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"6b2868d6\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"4e4189a7\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara.jpg\",\"id\":1242,\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"align\":\"right\",\"width\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"space\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"height\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"3c54a48\",\"elType\":\"section\",\"settings\":{\"structure\":\"20\"},\"elements\":[{\"id\":\"2706e15\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":50},\"elements\":[{\"id\":\"4dfb7a5\",\"elType\":\"widget\",\"settings\":{\"title\":\"Hakk\\u0131m\\u0131zda\",\"title_color\":\"#000000\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Poppins\",\"typography_font_weight\":\"400\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"427c350\",\"elType\":\"widget\",\"settings\":{\"title\":\"Ankara Ball\\u0131 Elektrik\",\"title_color\":\"#FF5E15\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Poppins\",\"typography_font_weight\":\"500\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"c925db5\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p><span style=\\\"vertical-align: inherit;\\\">Sekt\\u00f6rdeki faaliyetlerine 1995 senesinde Ankara ilinde ba\\u015flayan Ankara Ball\\u0131 Elektrik, Ayval\\u0131, Etlik, Ke\\u00e7i\\u00f6ren ilk s\\u0131rada olmak \\u00fczere Ankara ilinde elektrik tesisat\\u0131, elektrik ar\\u0131za bak\\u0131m\\u0131, uydu sistemleri, diyafon sistemleri, kamera sistemleri alanlar\\u0131nda hizmet sunmaktad\\u0131r. Kuruldu\\u011fu g\\u00fcnden g\\u00fcn\\u00fcm\\u00fcze nitelikli malzeme ve i\\u015f\\u00e7ilik \\u00f6ncelikli \\u00e7al\\u0131\\u015fan Ankara Ball\\u0131 Elektrik firmas\\u0131 olarak m\\u00fc\\u015fteri memnuniyetini her zaman ilk planda tutmaktay\\u0131z. Ankara elektrik\\u00e7i i\\u015f ilanlar\\u0131 yard\\u0131m\\u0131 ile bizlere 7\\/24 ula\\u015fabilirsiniz. Ay\\u0131rca elektrik\\u00e7i Ankara \\u00c7ankaya ya da Ankara K\\u0131z\\u0131lay Elektrik\\u00e7i firmas\\u0131 araman\\u0131za gerek kalmadan ihtiya\\u00e7lar\\u0131n\\u0131za \\u00e7\\u00f6z\\u00fcm \\u00fcretebiliyoruz. K\\u0131saca Ankara elektrik tamircisi araman\\u0131za gerek kalmadan Ball\\u0131 Elektrik olarak t\\u00fcm elektrik ar\\u0131zalar\\u0131n\\u0131z\\u0131 profesyonel ekibimiz ile \\u00e7\\u00f6z\\u00fcyoruz.<\\/span><\\/p><p>Y\\u0131llar\\u0131n\\u00a0verdi\\u011fi\\u00a0tecr\\u00fcbeyle\\u00a0sizlere\\u00a0hizmet sunan\\u00a0uzman\\u00a0ekibimiz, do\\u011fru malzeme, do\\u011fru ekipman ve\\u00a0nitelikli\\u00a0i\\u015f\\u00e7ilik\\u00a0anlay\\u0131\\u015f\\u0131 ile\\u00a0\\u00e7al\\u0131\\u015fmakta ve sizin istekleriniz\\u00a0do\\u011frultusunda h\\u0131zl\\u0131 \\u00e7\\u00f6z\\u00fcmler \\u00fcretmektedir.<br \\/><br \\/>Ball\\u0131 Ke\\u00e7i\\u00f6ren elektrik\\u00e7i 7\\/24 365 g\\u00fcn hizmetinizdeyiz. Ke\\u00e7i\\u00f6ren elektrik i\\u015flerinizi Ball\\u0131 Elektrik h\\u0131zl\\u0131\\u00a0bir bi\\u00e7imde\\u00a0\\u00e7\\u00f6z\\u00fcme ula\\u015ft\\u0131r\\u0131yoruz. Ayr\\u0131ca Ke\\u00e7i\\u00f6ren uydu \\u00e7\\u00f6z\\u00fcmleriyle de piyasaya liderdik ediyoruz. Ankara elektrik\\u00e7i firmalar\\u0131 aras\\u0131nda Ball\\u0131 Elektrik olarak m\\u00fc\\u015fterilerimize\\u00a0nitelikli\\u00a0hizmet sunmaya\\u00a0devam etmekteyiz. Ayr\\u0131ca Etlik elektrik\\u00e7i, Aycal\\u0131 elektrik\\u00e7i olarak da\\u00a0bize\\u00a0ula\\u015fabilirsiniz.\\u00a0<\\/p>\",\"column_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true},{\"id\":\"ef5e0be\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":49.9140000000000014779288903810083866119384765625},\"elements\":[{\"id\":\"1556c0e\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara.jpg\",\"id\":1242,\"alt\":\"Ankara Ball\\u0131 Elektrik\",\"source\":\"library\"}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"4ab7268\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"4ccb1ea\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"fb62b5d\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Ankara b\\u00f6lgesinde t\\u00fcm il\\u00e7elere\\u00a0hizmet vermekteyiz. Uygun fiyata hizmet sunarak m\\u00fc\\u015fterilerimizi memnun ediyoruz. Her zaman\\u00a0m\\u00fc\\u015fteri merkezli\\u00a0hizmet vermekteyiz. Ayval\\u0131 Mahallesi Ayval\\u0131 caddesi\\u00a0\\u00fcst\\u00fcnde\\u00a0bulunan firmam\\u0131za gelerek elektrik i\\u015fleriniz i\\u00e7in teklif alabilir ve\\u00a0piyasada bulunan\\u00a0di\\u011fer elektrik\\u00e7i\\u00a0\\u015firketleri ile\\u00a0k\\u0131yaslama yapabilirsiniz. B\\u00f6ylece kalitemizden ve\\u00a0uygun maliyetli\\u00a0elektrik, uydu, diafon, diyafon gibi hizmetlerimizden emin olabilirsiniz.<br \\/><br \\/>Sa\\u011flad\\u0131\\u011f\\u0131m\\u0131z hizmetlerden baz\\u0131lar\\u0131 ;<br \\/><br \\/>- Elektrik ve elektronik malzeme sat\\u0131\\u015f\\u0131,<br \\/><br \\/>- Uydu anten kurulumu,<br \\/><br \\/>- Elektrik tesisat\\u0131,<br \\/><br \\/>- G\\u00f6r\\u00fcnt\\u00fcl\\u00fc Diafon sistemleri,<br \\/><br \\/>- G\\u00fcvenlik Kamera Sitemleri<br \\/><br \\/>kurulum, montaj , bak\\u0131m ve ar\\u0131zalar\\u0131d\\u0131r.<br \\/><br \\/>En \\u00e7ok hizmet\\u00a0vermi\\u015f oldu\\u011fumuz\\u00a0b\\u00f6lgeler: Ankara Elektrik\\u00e7i, Ke\\u00e7i\\u00f6ren Elektrik\\u00e7i, Etlik Elektrik\\u00e7i, Esertepe Elektrik\\u00e7i, \\u0130ncirli Elektrik\\u00e7i, En yak\\u0131n elektrik\\u00e7i, \\u00c7ankaya Elektrik\\u00e7i, Sancaktepe Elektrik\\u00e7i, Yayla Mahallesi Elektrik\\u00e7i, Y\\u00fckseltepe Elektrik\\u00e7i, Ufuktepe Elektrik\\u00e7i, \\u015eenlik Mahallesi Elektrik\\u00e7i, Ovac\\u0131k Elektrik\\u00e7i, Kar\\u015f\\u0131yaka Elektrik\\u00e7i, Atapark Elektrik\\u00e7i, Ye\\u015filtepe Elektrik\\u00e7i, Yakac\\u0131k Mahallesi Elektrik\\u00e7i, Tepeba\\u015f\\u0131 Elektrik\\u00e7i, \\u015eehit Kubilay Elektrik\\u00e7i, Bas\\u0131nevler Elektrik\\u00e7i, Bademlik Elektrik\\u00e7i, A\\u015fa\\u011f\\u0131 E\\u011flence Elektrik\\u00e7i, Uyan\\u0131\\u015f Mahallesi Elektrik\\u00e7i, \\u015eenyuva Elektrik\\u00e7i, P\\u0131narba\\u015f\\u0131 Elektrik\\u00e7i, Ku\\u015fca\\u011f\\u0131z Elektrik\\u00e7i, Ba\\u011flum Elektrik\\u00e7i, Pursaklar Elektrik\\u00e7i, Bah\\u00e7elievler Elektrik\\u00e7i, K\\u0131z\\u0131lay Elektrik\\u00e7i, Elektrik\\u00e7i Etimesgut, S\\u0131hh\\u0131ye Elektrik\\u00e7i, Ulus Elektrik\\u00e7i, Mamak Elektirk\\u00e7i, Sincan Elektirik\\u00e7i, Yenimahalle Elektrik\\u00e7i<\\/p>\"},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"694d92c1\",\"elType\":\"widget\",\"settings\":{\"space\":{\"unit\":\"px\",\"size\":53,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"spacer\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"7d003626\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"facts-count\"},\"elements\":[{\"id\":\"16cf707b\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"7a06f54d\",\"elType\":\"widget\",\"settings\":{\"list\":[{\"fact_count\":\"26\",\"fact_suffix\":\"+\",\"fact_text\":\"Y\\u0131ll\\u0131k Tecr\\u00fcbe\",\"_id\":\"238e850\"},{\"fact_count\":\"502\",\"fact_suffix\":\"+\",\"fact_text\":\"Tamamlanm\\u0131\\u015f Proje\",\"_id\":\"97b8e5f\"},{\"fact_count\":\"120\",\"fact_suffix\":\"+\",\"fact_text\":\"G\\u00fcvenlik Kameras\\u0131\",\"_id\":\"f5612c8\"},{\"fact_count\":\"12\",\"fact_suffix\":\"+\",\"fact_text\":\"Devam Eden Proje\",\"_id\":\"1186dce\"}]},\"elements\":[],\"widgetType\":\"facts-count\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `nqcpo_postmeta` VALUES("557", "395", "secondary_header", "display");
INSERT INTO `nqcpo_postmeta` VALUES("558", "395", "page_header_style", "header1");
INSERT INTO `nqcpo_postmeta` VALUES("559", "395", "page_footer_style", "footer2");
INSERT INTO `nqcpo_postmeta` VALUES("560", "395", "page_color_seperate", "#ff5e15");
INSERT INTO `nqcpo_postmeta` VALUES("561", "395", "_elementor_edit_mode", "builder");
INSERT INTO `nqcpo_postmeta` VALUES("562", "395", "_elementor_template_type", "wp-page");
INSERT INTO `nqcpo_postmeta` VALUES("563", "395", "_elementor_version", "3.4.0");
INSERT INTO `nqcpo_postmeta` VALUES("564", "395", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("565", "395", "_elementor_data", "[{\"id\":\"7a6ba34c\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"services\"},\"elements\":[{\"id\":\"3122b3ce\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"5142a03f\",\"elType\":\"widget\",\"settings\":{\"content_subcaption\":\"Ankara Ball\\u0131 Elektrik\",\"content_heading\":\"Sa\\u011flad\\u0131\\u011f\\u0131m\\u0131z Hizmetler\",\"content_caption\":\"Ball\\u0131 elektrik b\\u00fcnyesinde sunmu\\u015f oldu\\u011fu g\\u00fcvenlik kamera sistemleri kurulum montaj ar\\u0131za onar\\u0131m ve bak\\u0131m\\u0131 , uydu anten kurulumu, uydu kanallar\\u0131 kurulumu, uydu ekipman ve malzemeleri sat\\u0131\\u015f\\u0131 , G\\u00f6r\\u00fcnt\\u00fcl\\u00fc diafon sistemleri kurulumu, de\\u011fi\\u015fimi, yeni binalarda \\u015fartnamelerde bulunan isteklerin kar\\u015f\\u0131lanmas\\u0131 , elektrik ar\\u0131za tesisat \\u00e7ekimi, yeni pano kurulumu gibi hizmetler ile siz de\\u011ferli m\\u00fc\\u015fterilerimize faydal\\u0131 olmaya \\u00e7al\\u0131\\u015fmaktay\\u0131z.\",\"background-image\":{\"url\":\"\",\"id\":\"\"},\"select_category\":\"Featured Services\",\"orderby\":\"ASC\",\"words_count\":\"7\",\"button_text\":\"More Services\",\"show_facts\":\"\",\"list\":[{\"fact_count\":\"12\",\"fact_suffix\":\"+\",\"fact_text\":\"Running Projects\",\"_id\":\"58ac328\"}],\"chose_style\":\"style-two\",\"_background_background\":\"classic\",\"_background_color\":\"#F9F9F9\"},\"elements\":[],\"widgetType\":\"services_grid\"},{\"id\":\"c1e4d5\",\"elType\":\"section\",\"settings\":{\"structure\":\"30\",\"background_background\":\"classic\",\"background_color\":\"#F9F9F9\",\"margin\":{\"unit\":\"px\",\"top\":\"-22\",\"right\":0,\"bottom\":\"-22\",\"left\":0,\"isLinked\":true}},\"elements\":[{\"id\":\"5d4f6738\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":29.91100000000000136424205265939235687255859375},\"elements\":[{\"id\":\"6c9e2e6f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2020\\/11\\/unnamed.jpg\",\"id\":1283,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"thumbnail_custom_dimension\":{\"width\":\"470\",\"height\":\"530\"},\"title_text\":\"Kamera Kurulum\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nG\\u00fcvenlik kamera \\u0130htiya\\u00e7lar\\u0131n\\u0131z do\\u011frultusunda sizlere en yenilik\\u00e7i alternatifleri sunuyoruz.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true},{\"id\":\"58457490\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":33.3299999999999982946974341757595539093017578125},\"elements\":[{\"id\":\"697bb3e1\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/5cc71fea0f2bc155655370675.jpg\",\"id\":1293,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"thumbnail_custom_dimension\":{\"width\":\"470\",\"height\":\"530\"},\"title_text\":\"Telefon Ankastre\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\n\\u0130nternet altyap\\u0131 hizmetleri ar\\u0131zalar\\u0131nda h\\u0131zl\\u0131 ve g\\u00fcvenilir \\u00e7\\u00f6z\\u00fcm i\\u00e7in bizimle ileti\\u015fime ge\\u00e7in.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true},{\"id\":\"1e245265\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":36.423000000000001818989403545856475830078125},\"elements\":[{\"id\":\"1196e926\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Elektrik-Pana-Montaj-scaled.jpg\",\"id\":1294,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"title_text\":\"Elektrik Pano Montaj\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nElektrik tesisat\\u0131n d\\u00fczg\\u00fcn \\u00e7al\\u0131\\u015fmas\\u0131 i\\u00e7in elektrik pano montaj ba\\u011flant\\u0131lar\\u0131 uzmanlar\\u0131nca yap\\u0131lmal\\u0131d\\u0131r.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"54a1e2d4\",\"elType\":\"widget\",\"settings\":{\"space\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"spacer\"},{\"id\":\"446cc592\",\"elType\":\"section\",\"settings\":{\"structure\":\"30\",\"background_background\":\"classic\",\"background_color\":\"#F9F9F9\",\"margin\":{\"unit\":\"px\",\"top\":\"-10\",\"right\":0,\"bottom\":\"0\",\"left\":0,\"isLinked\":false}},\"elements\":[{\"id\":\"228e9779\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"329be770\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Elektrik-Ariza-Tespiti.jpg\",\"id\":1295,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"title_text\":\"Elektrik Ar\\u0131za Tespiti\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nM\\u00fc\\u015fterilerimizin elektrik ar\\u0131za ihtiya\\u00e7lar\\u0131na, en do\\u011fru ve alternatif \\u00e7\\u00f6z\\u00fcmlerle m\\u00fcdahale ediyoruz.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true},{\"id\":\"a405a35\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"42c52031\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Uydu-Anten-Kurulumu-scaled.jpg\",\"id\":1299,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"title_text\":\"Uydu Anten Kurulumu\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nAnkara uyducu aray\\u0131\\u015f\\u0131nda olanlar\\u0131n tercihi Palaz Elektrik, 7\\/24 kesintisiz hizmet veriyor.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true},{\"id\":\"45c1face\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"7fb092d2\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/5cc715cdb5680155655111758.jpg\",\"id\":1303,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"title_text\":\"\\u0130n\\u015faat Elektrik Projeleri\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\n\\u0130n\\u015faat sekt\\u00f6r\\u00fcnde bir\\u00e7ok elektrik proje i\\u015fini tamamlayan firmam\\u0131z, her ge\\u00e7en g\\u00fcn daha da b\\u00fcy\\u00fcyor.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"78b47af4\",\"elType\":\"widget\",\"settings\":[],\"elements\":[],\"widgetType\":\"spacer\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"e529bb6\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"facts-count\"},\"elements\":[{\"id\":\"4aa2b85\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"7bc29ee6\",\"elType\":\"widget\",\"settings\":{\"list\":[{\"fact_count\":\"26\",\"fact_suffix\":\"+\",\"fact_text\":\"Y\\u0131ll\\u0131k Tecr\\u00fcbe\",\"_id\":\"238e850\"},{\"fact_count\":\"502\",\"fact_suffix\":\"+\",\"fact_text\":\"Tamamlanm\\u0131\\u015f Proje\",\"_id\":\"97b8e5f\"},{\"fact_count\":\"120\",\"fact_suffix\":\"+\",\"fact_text\":\"G\\u00fcvenlik Kameras\\u0131\",\"_id\":\"f5612c8\"},{\"fact_count\":\"12\",\"fact_suffix\":\"+\",\"fact_text\":\"Devam Eden Proje\",\"_id\":\"1186dce\"}]},\"elements\":[],\"widgetType\":\"facts-count\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"26d634fe\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"cta\"},\"elements\":[{\"id\":\"4be3c6ba\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"61a9967d\",\"elType\":\"widget\",\"settings\":{\"element_title\":\"Talepleriniz \\u0130\\u00e7in Bizimle \\u0130leti\\u015fime Ge\\u00e7ebilirsiniz.\",\"element_caption\":\"Taleplerinize Dilerseniz \\u0130leti\\u015fim Sayfam\\u0131zdan veya ofisimizde kahvemizi i\\u00e7erken yard\\u0131mc\\u0131 olabiliriz.\",\"button_text\":\"\\u0130LET\\u0130\\u015e\\u0130M\",\"button_url\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/iletisim\",\"is_external\":false,\"nofollow\":false,\"custom_attributes\":\"\"},\"background-image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/elektrik-piyasasi-istatistiksel-analizi-03-12-2019.jpg\",\"id\":1255,\"alt\":\"\",\"source\":\"library\"}},\"elements\":[],\"widgetType\":\"cta-simple\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `nqcpo_postmeta` VALUES("579", "413", "secondary_header", "display");
INSERT INTO `nqcpo_postmeta` VALUES("580", "413", "page_header_style", "header1");
INSERT INTO `nqcpo_postmeta` VALUES("581", "413", "page_footer_style", "footer2");
INSERT INTO `nqcpo_postmeta` VALUES("582", "413", "page_color_seperate", "#ff5e15");
INSERT INTO `nqcpo_postmeta` VALUES("583", "413", "_elementor_edit_mode", "builder");
INSERT INTO `nqcpo_postmeta` VALUES("584", "413", "_elementor_template_type", "wp-page");
INSERT INTO `nqcpo_postmeta` VALUES("585", "413", "_elementor_version", "3.4.0");
INSERT INTO `nqcpo_postmeta` VALUES("586", "413", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("587", "413", "_elementor_data", "[{\"id\":\"ac39505\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\"},\"elements\":[{\"id\":\"4a4a73f\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"55615b6\",\"elType\":\"widget\",\"settings\":{\"heading_subtitle\":\"Ankara Ball\\u0131 Elektrik\",\"heading_title\":\"S\\u0131k\\u00e7a Sorulan Sorular\",\"list\":[{\"question\":\"Hangi B\\u00f6lgelere Hizmet Veriyorsunuz?\",\"answer\":\"Ankara\'n\\u0131n t\\u00fcm il\\u00e7e ve semtlerine hizmetimiz vard\\u0131r.\",\"_id\":\"b60ef55\"},{\"question\":\"Elektrik Sigortam S\\u00fcrekli At\\u0131yor Ne Yapmal\\u0131y\\u0131m?\",\"answer\":\"Sigortan\\u0131n besledi\\u011fi devreden ge\\u00e7en ak\\u0131m belli bir de\\u011ferin \\u00fczerine \\u00e7\\u0131kt\\u0131\\u011f\\u0131nda devreye ba\\u011fl\\u0131 al\\u0131c\\u0131lar\\u0131n zarar g\\u00f6rmesini engellemek i\\u00e7in elektrik sigortas\\u0131 atar ve bu sayede olu\\u015fabilecek yang\\u0131n, kaza ve ar\\u0131zalar\\u0131n \\u00f6n\\u00fcne ge\\u00e7ilmi\\u015f olur. Elektrik olan hemen her yerde kullan\\u0131lan sigorta g\\u00fcvenlik ve emniyet a\\u00e7\\u0131s\\u0131ndan hayati \\u00f6neme sahiptir. E\\u011fer sigortan\\u0131z s\\u00fcrekli at\\u0131yorsa \\u00f6ncelikle ilgili mahalde tak\\u0131l\\u0131 bulunan t\\u00fcm fi\\u015fleri prizden \\u00e7ekin ve sigortay\\u0131 tekrar kald\\u0131rmay\\u0131 deneyin. E\\u011fer d\\u00fczelmediyse hatt\\u0131n\\u0131zda veya sigortan\\u0131zda ar\\u0131za meydana gelmi\\u015f olabilir. Bu konuda uzman ekibizden destek alabilirsiniz.\",\"_id\":\"759eb32\"},{\"question\":\"Mesai Saatleri D\\u0131\\u015f\\u0131nda veya Acil Durumlar Gibi Durumlarda Servisiniz Var M\\u0131?\",\"answer\":\"Ya\\u015fanabilecek ar\\u0131zalara kar\\u015f\\u0131 mesai saatleri d\\u0131\\u015f\\u0131nda ve acil durumlarda servis hizmeti sunuyoruz. \",\"_id\":\"1bf865b\"},{\"question\":\"Yapt\\u0131\\u011f\\u0131n\\u0131z \\u0130\\u015flere Garanti Veriyor Musunuz?\",\"answer\":\"\\u0130mzam\\u0131z\\u0131n bulundu\\u011fu k\\u00fc\\u00e7\\u00fck b\\u00fcy\\u00fck t\\u00fcm projelerimize i\\u015f\\u00e7ilik garantisi veriyoruz. M\\u00fc\\u015fterilerimizin merdiven alt\\u0131 diye tabir edilen yerlerde \\u00fcretilen malzeme tercihlerine kar\\u015f\\u0131n herhangi bir garanti vermemekteyiz. \",\"_id\":\"ba51e9a\"},{\"question\":\"Elektrik \\u00c7arpmas\\u0131na Ne Neden Olur?\",\"answer\":\"\\u00c7\\u0131plak teller, yanl\\u0131\\u015f onar\\u0131m ve hatta ar\\u0131zal\\u0131 cihazlar \\u00e7arp\\u0131lmalara neden olabilir. Tesisat\\u0131n\\u0131z hakk\\u0131nda endi\\u015feleriniz varsa, herhangi bir sorunu \\u00f6nlemek ve tesisat\\u0131n\\u0131z\\u0131 incelemek i\\u00e7in bir profesyonel aray\\u0131n.  \",\"_id\":\"1fb1137\"}],\"bg-image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara.jpg\",\"id\":1242,\"alt\":\"Ankara Ball\\u0131 Elektrik\",\"source\":\"library\"}},\"elements\":[],\"widgetType\":\"faqs-block\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `nqcpo_postmeta` VALUES("601", "436", "secondary_header", "display");
INSERT INTO `nqcpo_postmeta` VALUES("602", "436", "page_header_style", "header1");
INSERT INTO `nqcpo_postmeta` VALUES("603", "436", "page_footer_style", "footer2");
INSERT INTO `nqcpo_postmeta` VALUES("604", "436", "page_color_seperate", "#ff5e15");
INSERT INTO `nqcpo_postmeta` VALUES("605", "436", "_elementor_edit_mode", "builder");
INSERT INTO `nqcpo_postmeta` VALUES("606", "436", "_elementor_template_type", "wp-page");
INSERT INTO `nqcpo_postmeta` VALUES("607", "436", "_elementor_version", "3.4.1");
INSERT INTO `nqcpo_postmeta` VALUES("608", "436", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("609", "436", "_elementor_data", "[{\"id\":\"cf72398\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\"},\"elements\":[{\"id\":\"e511d69\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"56aff8f\",\"elType\":\"widget\",\"settings\":{\"list\":[{\"list_title\":\"Telefon\",\"list_caption\":\"0541 560 89 18\",\"list_caption2\":\"\",\"list_icon\":\"flaticon-phone-call\",\"list_fontAwesome\":\"\",\"_id\":\"e48c58a\"},{\"list_title\":\"E-Posta\",\"list_caption\":\" Email: info@ballielektrik.com\",\"list_caption2\":\"\",\"list_icon\":\"flaticon-mail\",\"list_fontAwesome\":\"\",\"_id\":\"95cf404\"},{\"list_title\":\"Adres\",\"list_caption\":\"Eserte Mah. 312. Sok. 16\\/2 Ke\\u00e7i\\u00f6ren\\/ANKARA\",\"list_caption2\":\"\",\"list_icon\":\"flaticon-placeholder\",\"list_fontAwesome\":\"\",\"_id\":\"f225c70\"}]},\"elements\":[],\"widgetType\":\"infoboxes\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"5ea468b\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\"},\"elements\":[{\"id\":\"811811e\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"dd94a18\",\"elType\":\"widget\",\"settings\":{\"location_lat\":\"\",\"location_long\":\"\",\"form_title\":\"Ankara Ball\\u0131 Elektrik\",\"form_caption\":\"Ankara Ball\\u0131 Elektrik\",\"social_title\":\"Yukar\\u0131daki ileti\\u015fim bilgilerimizi veya alttaki ileti\\u015fim formunu kullanarak bizlere ula\\u015fabilirsiniz.\",\"list\":[{\"profile_link\":\"#\",\"social_title\":\"facebook\",\"_id\":\"b0ad5cc\"},{\"profile_link\":\"#\",\"social_title\":\"twitter\",\"_id\":\"f75d913\",\"social_icon_field\":{\"value\":\"fab fa-twitter\",\"library\":\"fa-brands\"}},{\"profile_link\":\"#\",\"social_title\":\"google\",\"_id\":\"7762c86\",\"social_icon_field\":{\"value\":\"fab fa-google-plus-g\",\"library\":\"fa-brands\"}},{\"profile_link\":\"#\",\"social_title\":\"linkedin\",\"_id\":\"141f692\",\"social_icon_field\":{\"value\":\"fab fa-linkedin-in\",\"library\":\"fa-brands\"}}],\"form_shortcode\":\"<p>[contact-form-7 id=\\\"5\\\" title=\\\"Contact form 1\\\"]<\\/p>\"},\"elements\":[],\"widgetType\":\"contact_form_map\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `nqcpo_postmeta` VALUES("674", "206", "post_secondary_text", "Lorem Ipsum");
INSERT INTO `nqcpo_postmeta` VALUES("675", "206", "post_sidebar_layout", "right");
INSERT INTO `nqcpo_postmeta` VALUES("676", "206", "post_meta_views", "display");
INSERT INTO `nqcpo_postmeta` VALUES("677", "206", "post_tags_sharing", "display");
INSERT INTO `nqcpo_postmeta` VALUES("678", "206", "post_author_intro", "display");
INSERT INTO `nqcpo_postmeta` VALUES("679", "206", "author_intro_title", "About Author:");
INSERT INTO `nqcpo_postmeta` VALUES("680", "206", "popular_post_views_count", "398");
INSERT INTO `nqcpo_postmeta` VALUES("681", "206", "post_views_count", "15");
INSERT INTO `nqcpo_postmeta` VALUES("682", "206", "_thumbnail_id", "1198");
INSERT INTO `nqcpo_postmeta` VALUES("683", "206", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("684", "206", "_wp_old_date", "2020-11-14");
INSERT INTO `nqcpo_postmeta` VALUES("685", "206", "post_sidebar_selected", "default-sidebar");
INSERT INTO `nqcpo_postmeta` VALUES("764", "218", "post_secondary_text", "Lorem Ipsum");
INSERT INTO `nqcpo_postmeta` VALUES("765", "218", "post_sidebar_layout", "right");
INSERT INTO `nqcpo_postmeta` VALUES("766", "218", "post_meta_views", "display");
INSERT INTO `nqcpo_postmeta` VALUES("767", "218", "post_tags_sharing", "display");
INSERT INTO `nqcpo_postmeta` VALUES("768", "218", "post_author_intro", "display");
INSERT INTO `nqcpo_postmeta` VALUES("769", "218", "author_intro_title", "About Author:");
INSERT INTO `nqcpo_postmeta` VALUES("770", "218", "popular_post_views_count", "354");
INSERT INTO `nqcpo_postmeta` VALUES("771", "218", "post_views_count", "27");
INSERT INTO `nqcpo_postmeta` VALUES("772", "218", "_thumbnail_id", "1348");
INSERT INTO `nqcpo_postmeta` VALUES("773", "218", "post_sidebar_selected", "default-sidebar");
INSERT INTO `nqcpo_postmeta` VALUES("774", "218", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("775", "218", "_wp_old_slug", "models-oem-solution-simul-corporation-copy-copy-copy-copy-copy-copy");
INSERT INTO `nqcpo_postmeta` VALUES("776", "218", "_wp_old_date", "2020-11-14");
INSERT INTO `nqcpo_postmeta` VALUES("777", "218", "_wp_old_date", "2020-11-16");
INSERT INTO `nqcpo_postmeta` VALUES("780", "219", "post_secondary_text", "Lorem Ipsum");
INSERT INTO `nqcpo_postmeta` VALUES("781", "219", "post_sidebar_layout", "right");
INSERT INTO `nqcpo_postmeta` VALUES("782", "219", "post_meta_views", "display");
INSERT INTO `nqcpo_postmeta` VALUES("783", "219", "post_tags_sharing", "display");
INSERT INTO `nqcpo_postmeta` VALUES("784", "219", "post_author_intro", "display");
INSERT INTO `nqcpo_postmeta` VALUES("785", "219", "author_intro_title", "About Author:");
INSERT INTO `nqcpo_postmeta` VALUES("786", "219", "popular_post_views_count", "466");
INSERT INTO `nqcpo_postmeta` VALUES("787", "219", "post_views_count", "161");
INSERT INTO `nqcpo_postmeta` VALUES("788", "219", "_thumbnail_id", "1346");
INSERT INTO `nqcpo_postmeta` VALUES("789", "219", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("790", "219", "post_sidebar_selected", "default-sidebar");
INSERT INTO `nqcpo_postmeta` VALUES("791", "219", "_wp_old_slug", "models-oem-solution-simul-corporation-copy-copy-copy-copy-copy-copy-copy");
INSERT INTO `nqcpo_postmeta` VALUES("792", "523", "_sku", "woo-vneck-tee");
INSERT INTO `nqcpo_postmeta` VALUES("793", "523", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("794", "523", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("795", "523", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("796", "523", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("797", "523", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("798", "523", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("799", "523", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("800", "523", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("801", "523", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("802", "523", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("803", "523", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("804", "523", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("805", "523", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("806", "523", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("807", "523", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("808", "523", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("809", "523", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("810", "523", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("811", "523", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("812", "523", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("813", "523", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("814", "523", "_stock", "500");
INSERT INTO `nqcpo_postmeta` VALUES("815", "523", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("816", "523", "_wc_average_rating", "4.00");
INSERT INTO `nqcpo_postmeta` VALUES("817", "523", "_wc_rating_count", "a:1:{i:4;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("818", "523", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("819", "523", "_downloadable_files", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("820", "523", "_product_attributes", "a:2:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:1;s:11:\"is_taxonomy\";i:1;}s:7:\"pa_size\";a:6:{s:4:\"name\";s:7:\"pa_size\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:1;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:1;s:11:\"is_taxonomy\";i:1;}}");
INSERT INTO `nqcpo_postmeta` VALUES("821", "523", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("822", "523", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("823", "523", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("824", "523", "_wp_old_slug", "v-neck-t-shirt");
INSERT INTO `nqcpo_postmeta` VALUES("825", "523", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("826", "523", "popular_post_views_count", "129");
INSERT INTO `nqcpo_postmeta` VALUES("827", "523", "_regular_price", "25.75");
INSERT INTO `nqcpo_postmeta` VALUES("828", "523", "_sale_price", "20.50");
INSERT INTO `nqcpo_postmeta` VALUES("829", "523", "_price", "20.50");
INSERT INTO `nqcpo_postmeta` VALUES("830", "524", "_sku", "woo-hoodie");
INSERT INTO `nqcpo_postmeta` VALUES("831", "524", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("832", "524", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("833", "524", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("834", "524", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("835", "524", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("836", "524", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("837", "524", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("838", "524", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("839", "524", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("840", "524", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("841", "524", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("842", "524", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("843", "524", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("844", "524", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("845", "524", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("846", "524", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("847", "524", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("848", "524", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("849", "524", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("850", "524", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("851", "524", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("852", "524", "_stock", "500");
INSERT INTO `nqcpo_postmeta` VALUES("853", "524", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("854", "524", "_wc_average_rating", "3.00");
INSERT INTO `nqcpo_postmeta` VALUES("855", "524", "_wc_rating_count", "a:1:{i:3;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("856", "524", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("857", "524", "_downloadable_files", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("858", "524", "_product_attributes", "a:2:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:1;s:11:\"is_taxonomy\";i:1;}s:4:\"logo\";a:6:{s:4:\"name\";s:4:\"Logo\";s:5:\"value\";s:8:\"Yes | No\";s:8:\"position\";i:1;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:1;s:11:\"is_taxonomy\";i:0;}}");
INSERT INTO `nqcpo_postmeta` VALUES("859", "524", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("860", "524", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("861", "524", "_price", "20.52");
INSERT INTO `nqcpo_postmeta` VALUES("862", "524", "_price", "20.52");
INSERT INTO `nqcpo_postmeta` VALUES("863", "524", "_regular_price", "35.40");
INSERT INTO `nqcpo_postmeta` VALUES("864", "524", "_sale_price", "20.52");
INSERT INTO `nqcpo_postmeta` VALUES("865", "524", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("866", "524", "_wp_old_slug", "hoodie");
INSERT INTO `nqcpo_postmeta` VALUES("867", "524", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("868", "524", "popular_post_views_count", "4");
INSERT INTO `nqcpo_postmeta` VALUES("869", "524", "_wp_old_slug", "worker-helmet");
INSERT INTO `nqcpo_postmeta` VALUES("870", "525", "_sku", "woo-hoodie-with-logo");
INSERT INTO `nqcpo_postmeta` VALUES("871", "525", "_regular_price", "45.90");
INSERT INTO `nqcpo_postmeta` VALUES("872", "525", "_sale_price", "35.60");
INSERT INTO `nqcpo_postmeta` VALUES("873", "525", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("874", "525", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("875", "525", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("876", "525", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("877", "525", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("878", "525", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("879", "525", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("880", "525", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("881", "525", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("882", "525", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("883", "525", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("884", "525", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("885", "525", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("886", "525", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("887", "525", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("888", "525", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("889", "525", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("890", "525", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("891", "525", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("892", "525", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("893", "525", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("894", "525", "_stock", "600");
INSERT INTO `nqcpo_postmeta` VALUES("895", "525", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("896", "525", "_wc_average_rating", "4.00");
INSERT INTO `nqcpo_postmeta` VALUES("897", "525", "_wc_rating_count", "a:1:{i:4;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("898", "525", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("899", "525", "_downloadable_files", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("900", "525", "_product_attributes", "a:1:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:0;s:11:\"is_taxonomy\";i:1;}}");
INSERT INTO `nqcpo_postmeta` VALUES("901", "525", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("902", "525", "_price", "35.60");
INSERT INTO `nqcpo_postmeta` VALUES("903", "525", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("904", "525", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("905", "525", "_wp_old_slug", "hoodie-with-logo");
INSERT INTO `nqcpo_postmeta` VALUES("906", "525", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("907", "525", "popular_post_views_count", "6");
INSERT INTO `nqcpo_postmeta` VALUES("908", "526", "_sku", "woo-tshirt");
INSERT INTO `nqcpo_postmeta` VALUES("909", "526", "_regular_price", "18.90");
INSERT INTO `nqcpo_postmeta` VALUES("910", "526", "_sale_price", "17.50");
INSERT INTO `nqcpo_postmeta` VALUES("911", "526", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("912", "526", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("913", "526", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("914", "526", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("915", "526", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("916", "526", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("917", "526", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("918", "526", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("919", "526", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("920", "526", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("921", "526", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("922", "526", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("923", "526", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("924", "526", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("925", "526", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("926", "526", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("927", "526", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("928", "526", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("929", "526", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("930", "526", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("931", "526", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("932", "526", "_stock", "500");
INSERT INTO `nqcpo_postmeta` VALUES("933", "526", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("934", "526", "_wc_average_rating", "5.00");
INSERT INTO `nqcpo_postmeta` VALUES("935", "526", "_wc_rating_count", "a:1:{i:5;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("936", "526", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("937", "526", "_downloadable_files", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("938", "526", "_product_attributes", "a:1:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:0;s:11:\"is_taxonomy\";i:1;}}");
INSERT INTO `nqcpo_postmeta` VALUES("939", "526", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("940", "526", "_price", "17.50");
INSERT INTO `nqcpo_postmeta` VALUES("941", "526", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("942", "526", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("943", "526", "_wp_old_slug", "t-shirt");
INSERT INTO `nqcpo_postmeta` VALUES("944", "526", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("945", "526", "popular_post_views_count", "11");
INSERT INTO `nqcpo_postmeta` VALUES("946", "526", "_wp_old_slug", "heavy-roller-2");
INSERT INTO `nqcpo_postmeta` VALUES("947", "527", "_sku", "woo-beanie");
INSERT INTO `nqcpo_postmeta` VALUES("948", "527", "_regular_price", "20.50");
INSERT INTO `nqcpo_postmeta` VALUES("949", "527", "_sale_price", "18.50");
INSERT INTO `nqcpo_postmeta` VALUES("950", "527", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("951", "527", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("952", "527", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("953", "527", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("954", "527", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("955", "527", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("956", "527", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("957", "527", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("958", "527", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("959", "527", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("960", "527", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("961", "527", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("962", "527", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("963", "527", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("964", "527", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("965", "527", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("966", "527", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("967", "527", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("968", "527", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("969", "527", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("970", "527", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("971", "527", "_stock", "750");
INSERT INTO `nqcpo_postmeta` VALUES("972", "527", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("973", "527", "_wc_average_rating", "3.00");
INSERT INTO `nqcpo_postmeta` VALUES("974", "527", "_wc_rating_count", "a:1:{i:3;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("975", "527", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("976", "527", "_downloadable_files", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("977", "527", "_product_attributes", "a:1:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:0;s:11:\"is_taxonomy\";i:1;}}");
INSERT INTO `nqcpo_postmeta` VALUES("978", "527", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("979", "527", "_price", "18.50");
INSERT INTO `nqcpo_postmeta` VALUES("980", "527", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("981", "527", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("982", "527", "_wp_old_slug", "beanie");
INSERT INTO `nqcpo_postmeta` VALUES("983", "527", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("984", "527", "popular_post_views_count", "4");
INSERT INTO `nqcpo_postmeta` VALUES("985", "528", "_sku", "woo-belt");
INSERT INTO `nqcpo_postmeta` VALUES("986", "528", "_regular_price", "65.25");
INSERT INTO `nqcpo_postmeta` VALUES("987", "528", "_sale_price", "55.65");
INSERT INTO `nqcpo_postmeta` VALUES("988", "528", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("989", "528", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("990", "528", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("991", "528", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("992", "528", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("993", "528", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("994", "528", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("995", "528", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("996", "528", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("997", "528", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("998", "528", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("999", "528", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("1000", "528", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("1001", "528", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1002", "528", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1003", "528", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("1004", "528", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1005", "528", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1006", "528", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1007", "528", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1008", "528", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1009", "528", "_stock", "950");
INSERT INTO `nqcpo_postmeta` VALUES("1010", "528", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1011", "528", "_wc_average_rating", "4.00");
INSERT INTO `nqcpo_postmeta` VALUES("1012", "528", "_wc_rating_count", "a:1:{i:4;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1013", "528", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1014", "528", "_downloadable_files", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1015", "528", "_product_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1016", "528", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1017", "528", "_price", "55.65");
INSERT INTO `nqcpo_postmeta` VALUES("1018", "528", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1019", "528", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1020", "528", "_wp_old_slug", "belt");
INSERT INTO `nqcpo_postmeta` VALUES("1021", "528", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1022", "528", "popular_post_views_count", "4");
INSERT INTO `nqcpo_postmeta` VALUES("1023", "528", "_wp_old_slug", "architect-maps");
INSERT INTO `nqcpo_postmeta` VALUES("1024", "529", "_sku", "woo-cap");
INSERT INTO `nqcpo_postmeta` VALUES("1025", "529", "_regular_price", "18");
INSERT INTO `nqcpo_postmeta` VALUES("1026", "529", "_sale_price", "16");
INSERT INTO `nqcpo_postmeta` VALUES("1027", "529", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("1028", "529", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("1029", "529", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1030", "529", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1031", "529", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1032", "529", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1033", "529", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1034", "529", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("1035", "529", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1036", "529", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("1037", "529", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("1038", "529", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("1039", "529", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("1040", "529", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1041", "529", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1042", "529", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("1043", "529", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1044", "529", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1045", "529", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1046", "529", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1047", "529", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1048", "529", "_stock", "400");
INSERT INTO `nqcpo_postmeta` VALUES("1049", "529", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1050", "529", "_wc_average_rating", "2.00");
INSERT INTO `nqcpo_postmeta` VALUES("1051", "529", "_wc_rating_count", "a:1:{i:2;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1052", "529", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1053", "529", "_downloadable_files", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1054", "529", "_product_attributes", "a:1:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:0;s:11:\"is_taxonomy\";i:1;}}");
INSERT INTO `nqcpo_postmeta` VALUES("1055", "529", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1056", "529", "_price", "16");
INSERT INTO `nqcpo_postmeta` VALUES("1057", "529", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1058", "529", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1059", "529", "_wp_old_slug", "cap");
INSERT INTO `nqcpo_postmeta` VALUES("1060", "529", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1061", "529", "popular_post_views_count", "4");
INSERT INTO `nqcpo_postmeta` VALUES("1062", "529", "_wp_old_slug", "cement-bucket");
INSERT INTO `nqcpo_postmeta` VALUES("1063", "530", "_sku", "woo-sunglasses");
INSERT INTO `nqcpo_postmeta` VALUES("1064", "530", "_regular_price", "90.60");
INSERT INTO `nqcpo_postmeta` VALUES("1065", "530", "_sale_price", "75.80");
INSERT INTO `nqcpo_postmeta` VALUES("1066", "530", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("1067", "530", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("1068", "530", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1069", "530", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1070", "530", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1071", "530", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1072", "530", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1073", "530", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("1074", "530", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1075", "530", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("1076", "530", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("1077", "530", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("1078", "530", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("1079", "530", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1080", "530", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1081", "530", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("1082", "530", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1083", "530", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1084", "530", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1085", "530", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1086", "530", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1087", "530", "_stock", "600");
INSERT INTO `nqcpo_postmeta` VALUES("1088", "530", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1089", "530", "_wc_average_rating", "5.00");
INSERT INTO `nqcpo_postmeta` VALUES("1090", "530", "_wc_rating_count", "a:1:{i:5;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1091", "530", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1092", "530", "_downloadable_files", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1093", "530", "_product_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1094", "530", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1095", "530", "_price", "75.80");
INSERT INTO `nqcpo_postmeta` VALUES("1096", "530", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1097", "530", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1098", "530", "_wp_old_slug", "sunglasses");
INSERT INTO `nqcpo_postmeta` VALUES("1099", "530", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1100", "530", "popular_post_views_count", "8");
INSERT INTO `nqcpo_postmeta` VALUES("1101", "531", "_sku", "woo-hoodie-with-pocket");
INSERT INTO `nqcpo_postmeta` VALUES("1102", "531", "_regular_price", "45");
INSERT INTO `nqcpo_postmeta` VALUES("1103", "531", "_sale_price", "35");
INSERT INTO `nqcpo_postmeta` VALUES("1104", "531", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("1105", "531", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("1106", "531", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1107", "531", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1108", "531", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1109", "531", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1110", "531", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1111", "531", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("1112", "531", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1113", "531", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("1114", "531", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("1115", "531", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("1116", "531", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("1117", "531", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1118", "531", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1119", "531", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("1120", "531", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1121", "531", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1122", "531", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1123", "531", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1124", "531", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1125", "531", "_stock", "60");
INSERT INTO `nqcpo_postmeta` VALUES("1126", "531", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1127", "531", "_wc_average_rating", "4.00");
INSERT INTO `nqcpo_postmeta` VALUES("1128", "531", "_wc_rating_count", "a:1:{i:4;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1129", "531", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1130", "531", "_downloadable_files", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1131", "531", "_product_attributes", "a:1:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:0;s:11:\"is_taxonomy\";i:1;}}");
INSERT INTO `nqcpo_postmeta` VALUES("1132", "531", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1133", "531", "_price", "35");
INSERT INTO `nqcpo_postmeta` VALUES("1134", "531", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1135", "531", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1136", "531", "_wp_old_slug", "hoodie-with-pocket");
INSERT INTO `nqcpo_postmeta` VALUES("1137", "531", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1138", "531", "popular_post_views_count", "3");
INSERT INTO `nqcpo_postmeta` VALUES("1150", "1171", "_sku", "woo-album");
INSERT INTO `nqcpo_postmeta` VALUES("1151", "1171", "_regular_price", "15");
INSERT INTO `nqcpo_postmeta` VALUES("1152", "1171", "_sale_price", "13.5");
INSERT INTO `nqcpo_postmeta` VALUES("1153", "1171", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("1154", "1171", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("1155", "1171", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1156", "1171", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1157", "1171", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1158", "1171", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1159", "1171", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1160", "1171", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("1161", "1171", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1162", "1171", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("1163", "1171", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("1164", "1171", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("1165", "1171", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("1166", "1171", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1167", "1171", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1168", "1171", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("1169", "1171", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1170", "1171", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1171", "1171", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1172", "1171", "_download_limit", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1173", "1171", "_download_expiry", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1174", "1171", "_stock", "500");
INSERT INTO `nqcpo_postmeta` VALUES("1175", "1171", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1176", "1171", "_wc_average_rating", "5.00");
INSERT INTO `nqcpo_postmeta` VALUES("1177", "1171", "_wc_rating_count", "a:1:{i:5;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1178", "1171", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1179", "1171", "_product_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1180", "1171", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1181", "1171", "_price", "13.5");
INSERT INTO `nqcpo_postmeta` VALUES("1182", "1171", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1183", "1171", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1184", "1171", "_wp_old_slug", "album");
INSERT INTO `nqcpo_postmeta` VALUES("1185", "1171", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1186", "1171", "popular_post_views_count", "4");
INSERT INTO `nqcpo_postmeta` VALUES("1187", "532", "_sku", "woo-hoodie-with-zipper");
INSERT INTO `nqcpo_postmeta` VALUES("1188", "532", "_regular_price", "45.0");
INSERT INTO `nqcpo_postmeta` VALUES("1189", "532", "_sale_price", "35.5");
INSERT INTO `nqcpo_postmeta` VALUES("1190", "532", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("1191", "532", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("1192", "532", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1193", "532", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1194", "532", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1195", "532", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1196", "532", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1197", "532", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("1198", "532", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1199", "532", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("1200", "532", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("1201", "532", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("1202", "532", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("1203", "532", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1204", "532", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1205", "532", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("1206", "532", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1207", "532", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1208", "532", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1209", "532", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1210", "532", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1211", "532", "_stock", "25");
INSERT INTO `nqcpo_postmeta` VALUES("1212", "532", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1213", "532", "_wc_average_rating", "4.00");
INSERT INTO `nqcpo_postmeta` VALUES("1214", "532", "_wc_rating_count", "a:1:{i:4;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1215", "532", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1216", "532", "_downloadable_files", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1217", "532", "_product_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1218", "532", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1219", "532", "_price", "35.5");
INSERT INTO `nqcpo_postmeta` VALUES("1220", "532", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1221", "532", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1222", "532", "_wp_old_slug", "hoodie-with-zipper");
INSERT INTO `nqcpo_postmeta` VALUES("1223", "532", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1224", "532", "popular_post_views_count", "3");
INSERT INTO `nqcpo_postmeta` VALUES("1225", "532", "_wp_old_slug", "heavy-roller");
INSERT INTO `nqcpo_postmeta` VALUES("1226", "533", "_sku", "woo-long-sleeve-tee");
INSERT INTO `nqcpo_postmeta` VALUES("1227", "533", "_regular_price", "25.0");
INSERT INTO `nqcpo_postmeta` VALUES("1228", "533", "_sale_price", "22.25");
INSERT INTO `nqcpo_postmeta` VALUES("1229", "533", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("1230", "533", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("1231", "533", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1232", "533", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1233", "533", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1234", "533", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1235", "533", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1236", "533", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("1237", "533", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1238", "533", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("1239", "533", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("1240", "533", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("1241", "533", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("1242", "533", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1243", "533", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1244", "533", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("1245", "533", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1246", "533", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1247", "533", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1248", "533", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1249", "533", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1250", "533", "_stock", "750");
INSERT INTO `nqcpo_postmeta` VALUES("1251", "533", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1252", "533", "_wc_average_rating", "5.00");
INSERT INTO `nqcpo_postmeta` VALUES("1253", "533", "_wc_rating_count", "a:1:{i:5;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1254", "533", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1255", "533", "_downloadable_files", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1256", "533", "_product_attributes", "a:1:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:0;s:11:\"is_taxonomy\";i:1;}}");
INSERT INTO `nqcpo_postmeta` VALUES("1257", "533", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1258", "533", "_price", "22.25");
INSERT INTO `nqcpo_postmeta` VALUES("1259", "533", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1260", "533", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1261", "533", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1262", "533", "popular_post_views_count", "6");
INSERT INTO `nqcpo_postmeta` VALUES("1263", "533", "_wp_old_slug", "long-sleeve-tee");
INSERT INTO `nqcpo_postmeta` VALUES("1264", "534", "_sku", "woo-polo");
INSERT INTO `nqcpo_postmeta` VALUES("1265", "534", "_regular_price", "20");
INSERT INTO `nqcpo_postmeta` VALUES("1266", "534", "_sale_price", "15");
INSERT INTO `nqcpo_postmeta` VALUES("1267", "534", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("1268", "534", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("1269", "534", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1270", "534", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1271", "534", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1272", "534", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1273", "534", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1274", "534", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("1275", "534", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1276", "534", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("1277", "534", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("1278", "534", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("1279", "534", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("1280", "534", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1281", "534", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1282", "534", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("1283", "534", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1284", "534", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1285", "534", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1286", "534", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1287", "534", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1288", "534", "_stock", "600");
INSERT INTO `nqcpo_postmeta` VALUES("1289", "534", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1290", "534", "_wc_average_rating", "3.00");
INSERT INTO `nqcpo_postmeta` VALUES("1291", "534", "_wc_rating_count", "a:1:{i:3;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1292", "534", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1293", "534", "_downloadable_files", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1294", "534", "_product_attributes", "a:1:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:0;s:11:\"is_taxonomy\";i:1;}}");
INSERT INTO `nqcpo_postmeta` VALUES("1295", "534", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1296", "534", "_price", "15");
INSERT INTO `nqcpo_postmeta` VALUES("1297", "534", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1298", "534", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1299", "534", "_wp_old_slug", "polo");
INSERT INTO `nqcpo_postmeta` VALUES("1300", "534", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1301", "534", "popular_post_views_count", "5");
INSERT INTO `nqcpo_postmeta` VALUES("1302", "534", "_wp_old_slug", "heavy-crane");
INSERT INTO `nqcpo_postmeta` VALUES("1303", "535", "_sku", "woo-single");
INSERT INTO `nqcpo_postmeta` VALUES("1304", "535", "_regular_price", "3.25");
INSERT INTO `nqcpo_postmeta` VALUES("1305", "535", "_sale_price", "2.50");
INSERT INTO `nqcpo_postmeta` VALUES("1306", "535", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("1307", "535", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("1308", "535", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1309", "535", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1310", "535", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1311", "535", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1312", "535", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1313", "535", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("1314", "535", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1315", "535", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("1316", "535", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("1317", "535", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("1318", "535", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("1319", "535", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1320", "535", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1321", "535", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("1322", "535", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1323", "535", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1324", "535", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1325", "535", "_download_limit", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1326", "535", "_download_expiry", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1327", "535", "_stock", "900");
INSERT INTO `nqcpo_postmeta` VALUES("1328", "535", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1329", "535", "_wc_average_rating", "3.00");
INSERT INTO `nqcpo_postmeta` VALUES("1330", "535", "_wc_rating_count", "a:1:{i:3;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1331", "535", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1332", "535", "_downloadable_files", "a:1:{s:36:\"a0fdda89-5f0e-440d-93f5-188e12c910d1\";a:3:{s:2:\"id\";s:36:\"a0fdda89-5f0e-440d-93f5-188e12c910d1\";s:4:\"name\";s:6:\"Single\";s:4:\"file\";s:85:\"https://demo.woothemes.com/woocommerce/wp-content/uploads/sites/56/2017/08/single.jpg\";}}");
INSERT INTO `nqcpo_postmeta` VALUES("1333", "535", "_product_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1334", "535", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1335", "535", "_price", "2.50");
INSERT INTO `nqcpo_postmeta` VALUES("1336", "535", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1337", "535", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1338", "535", "_wp_old_slug", "single");
INSERT INTO `nqcpo_postmeta` VALUES("1339", "535", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1340", "535", "popular_post_views_count", "7");
INSERT INTO `nqcpo_postmeta` VALUES("1341", "541", "_sku", "Woo-tshirt-logo");
INSERT INTO `nqcpo_postmeta` VALUES("1342", "541", "_regular_price", "18.0");
INSERT INTO `nqcpo_postmeta` VALUES("1343", "541", "_sale_price", "16.25");
INSERT INTO `nqcpo_postmeta` VALUES("1344", "541", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("1345", "541", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("1346", "541", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1347", "541", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1348", "541", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1349", "541", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1350", "541", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1351", "541", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("1352", "541", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1353", "541", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("1354", "541", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("1355", "541", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("1356", "541", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("1357", "541", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1358", "541", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1359", "541", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("1360", "541", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1361", "541", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1362", "541", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1363", "541", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1364", "541", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1365", "541", "_stock", "450");
INSERT INTO `nqcpo_postmeta` VALUES("1366", "541", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1367", "541", "_wc_average_rating", "5.00");
INSERT INTO `nqcpo_postmeta` VALUES("1368", "541", "_wc_rating_count", "a:1:{i:5;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1369", "541", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1370", "541", "_downloadable_files", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1371", "541", "_product_attributes", "a:1:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:0;s:11:\"is_taxonomy\";i:1;}}");
INSERT INTO `nqcpo_postmeta` VALUES("1372", "541", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1373", "541", "_price", "16.25");
INSERT INTO `nqcpo_postmeta` VALUES("1374", "541", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1375", "541", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1376", "541", "_wp_old_slug", "t-shirt-with-logo");
INSERT INTO `nqcpo_postmeta` VALUES("1377", "541", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1378", "541", "popular_post_views_count", "4");
INSERT INTO `nqcpo_postmeta` VALUES("1379", "542", "_sku", "Woo-beanie-logo");
INSERT INTO `nqcpo_postmeta` VALUES("1380", "542", "_regular_price", "20");
INSERT INTO `nqcpo_postmeta` VALUES("1381", "542", "_sale_price", "18");
INSERT INTO `nqcpo_postmeta` VALUES("1382", "542", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("1383", "542", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("1384", "542", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1385", "542", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1386", "542", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1387", "542", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1388", "542", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1389", "542", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("1390", "542", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1391", "542", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("1392", "542", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("1393", "542", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("1394", "542", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("1395", "542", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1396", "542", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1397", "542", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("1398", "542", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1399", "542", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1400", "542", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1401", "542", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1402", "542", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1403", "542", "_stock", "900");
INSERT INTO `nqcpo_postmeta` VALUES("1404", "542", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1405", "542", "_wc_average_rating", "4.00");
INSERT INTO `nqcpo_postmeta` VALUES("1406", "542", "_wc_rating_count", "a:1:{i:4;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1407", "542", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1408", "542", "_downloadable_files", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1409", "542", "_product_attributes", "a:1:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:0;s:11:\"is_taxonomy\";i:1;}}");
INSERT INTO `nqcpo_postmeta` VALUES("1410", "542", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1411", "542", "_price", "18");
INSERT INTO `nqcpo_postmeta` VALUES("1412", "542", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1413", "542", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1414", "542", "_wp_old_slug", "beanie-with-logo");
INSERT INTO `nqcpo_postmeta` VALUES("1415", "542", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1416", "542", "popular_post_views_count", "4");
INSERT INTO `nqcpo_postmeta` VALUES("1417", "543", "_sku", "logo-collection");
INSERT INTO `nqcpo_postmeta` VALUES("1418", "543", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("1419", "543", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("1420", "543", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1421", "543", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1422", "543", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1423", "543", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1424", "543", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1425", "543", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("1426", "543", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1427", "543", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("1428", "543", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("1429", "543", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("1430", "543", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("1431", "543", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1432", "543", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1433", "543", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("1434", "543", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1435", "543", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1436", "543", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1437", "543", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1438", "543", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1439", "543", "_stock", "20");
INSERT INTO `nqcpo_postmeta` VALUES("1440", "543", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1441", "543", "_wc_average_rating", "4.00");
INSERT INTO `nqcpo_postmeta` VALUES("1442", "543", "_wc_rating_count", "a:1:{i:4;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1443", "543", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1444", "543", "_downloadable_files", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1445", "543", "_product_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1446", "543", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1447", "543", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1448", "543", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1449", "543", "_wp_old_slug", "logo-collection");
INSERT INTO `nqcpo_postmeta` VALUES("1450", "543", "_children", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1451", "543", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1452", "543", "popular_post_views_count", "5");
INSERT INTO `nqcpo_postmeta` VALUES("1453", "543", "_wp_old_slug", "yellow-cap");
INSERT INTO `nqcpo_postmeta` VALUES("1454", "543", "_regular_price", "950");
INSERT INTO `nqcpo_postmeta` VALUES("1455", "543", "_sale_price", "780");
INSERT INTO `nqcpo_postmeta` VALUES("1456", "543", "_price", "780");
INSERT INTO `nqcpo_postmeta` VALUES("1457", "544", "_sku", "wp-pennant");
INSERT INTO `nqcpo_postmeta` VALUES("1458", "544", "_regular_price", "1250");
INSERT INTO `nqcpo_postmeta` VALUES("1459", "544", "_sale_price", "950");
INSERT INTO `nqcpo_postmeta` VALUES("1460", "544", "_sale_price_dates_from", "");
INSERT INTO `nqcpo_postmeta` VALUES("1461", "544", "_sale_price_dates_to", "");
INSERT INTO `nqcpo_postmeta` VALUES("1462", "544", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1463", "544", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1464", "544", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1465", "544", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1466", "544", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1467", "544", "_low_stock_amount", "");
INSERT INTO `nqcpo_postmeta` VALUES("1468", "544", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1469", "544", "_weight", "");
INSERT INTO `nqcpo_postmeta` VALUES("1470", "544", "_length", "");
INSERT INTO `nqcpo_postmeta` VALUES("1471", "544", "_width", "");
INSERT INTO `nqcpo_postmeta` VALUES("1472", "544", "_height", "");
INSERT INTO `nqcpo_postmeta` VALUES("1473", "544", "_upsell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1474", "544", "_crosssell_ids", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1475", "544", "_purchase_note", "");
INSERT INTO `nqcpo_postmeta` VALUES("1476", "544", "_default_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1477", "544", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1478", "544", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1479", "544", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1480", "544", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1481", "544", "_stock", "5");
INSERT INTO `nqcpo_postmeta` VALUES("1482", "544", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1483", "544", "_wc_average_rating", "5.00");
INSERT INTO `nqcpo_postmeta` VALUES("1484", "544", "_wc_rating_count", "a:1:{i:5;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1485", "544", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1486", "544", "_downloadable_files", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1487", "544", "_product_attributes", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1488", "544", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1489", "544", "_price", "950");
INSERT INTO `nqcpo_postmeta` VALUES("1490", "544", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1491", "544", "_product_url", "https://mercantile.wordpress.org/product/wordpress-pennant/");
INSERT INTO `nqcpo_postmeta` VALUES("1492", "544", "_button_text", "Buy on the WordPress swag store!");
INSERT INTO `nqcpo_postmeta` VALUES("1493", "544", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1494", "544", "_wp_old_slug", "wordpress-pennant");
INSERT INTO `nqcpo_postmeta` VALUES("1495", "544", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1496", "544", "popular_post_views_count", "4");
INSERT INTO `nqcpo_postmeta` VALUES("1497", "1043", "_sku", "woo-hoodie-with-logo-1");
INSERT INTO `nqcpo_postmeta` VALUES("1498", "1043", "_regular_price", "45");
INSERT INTO `nqcpo_postmeta` VALUES("1499", "1043", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1500", "1043", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1501", "1043", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1502", "1043", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1503", "1043", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1504", "1043", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1505", "1043", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1506", "1043", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1507", "1043", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1508", "1043", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1509", "1043", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1510", "1043", "_stock", "1000");
INSERT INTO `nqcpo_postmeta` VALUES("1511", "1043", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1512", "1043", "_wc_average_rating", "5.00");
INSERT INTO `nqcpo_postmeta` VALUES("1513", "1043", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1514", "1043", "_product_attributes", "a:1:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:0;s:11:\"is_taxonomy\";i:1;}}");
INSERT INTO `nqcpo_postmeta` VALUES("1515", "1043", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1516", "1043", "_price", "35");
INSERT INTO `nqcpo_postmeta` VALUES("1517", "1043", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1518", "1043", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1519", "1043", "popular_post_views_count", "6");
INSERT INTO `nqcpo_postmeta` VALUES("1520", "1043", "_sale_price", "35");
INSERT INTO `nqcpo_postmeta` VALUES("1521", "1043", "_wc_rating_count", "a:1:{i:5;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1522", "1047", "_sku", "woo-vneck-tee-1");
INSERT INTO `nqcpo_postmeta` VALUES("1523", "1047", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1524", "1047", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1525", "1047", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1526", "1047", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1527", "1047", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1528", "1047", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1529", "1047", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1530", "1047", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1531", "1047", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1532", "1047", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1533", "1047", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1534", "1047", "_stock", "600");
INSERT INTO `nqcpo_postmeta` VALUES("1535", "1047", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1536", "1047", "_wc_average_rating", "4.00");
INSERT INTO `nqcpo_postmeta` VALUES("1537", "1047", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1538", "1047", "_product_attributes", "a:2:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:1;s:11:\"is_taxonomy\";i:1;}s:7:\"pa_size\";a:6:{s:4:\"name\";s:7:\"pa_size\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:1;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:1;s:11:\"is_taxonomy\";i:1;}}");
INSERT INTO `nqcpo_postmeta` VALUES("1539", "1047", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1540", "1047", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1541", "1047", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1542", "1047", "popular_post_views_count", "16");
INSERT INTO `nqcpo_postmeta` VALUES("1543", "1047", "_price", "27.0");
INSERT INTO `nqcpo_postmeta` VALUES("1544", "1047", "_price", "27.0");
INSERT INTO `nqcpo_postmeta` VALUES("1545", "1047", "_regular_price", "29.5");
INSERT INTO `nqcpo_postmeta` VALUES("1546", "1047", "_sale_price", "27.0");
INSERT INTO `nqcpo_postmeta` VALUES("1547", "1047", "_wc_rating_count", "a:1:{i:4;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1548", "1051", "_sku", "woo-hoodie-with-pocket-1");
INSERT INTO `nqcpo_postmeta` VALUES("1549", "1051", "_regular_price", "45");
INSERT INTO `nqcpo_postmeta` VALUES("1550", "1051", "_sale_price", "35");
INSERT INTO `nqcpo_postmeta` VALUES("1551", "1051", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1552", "1051", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1553", "1051", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1554", "1051", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1555", "1051", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1556", "1051", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1557", "1051", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1558", "1051", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1559", "1051", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1560", "1051", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1561", "1051", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1562", "1051", "_stock", "300");
INSERT INTO `nqcpo_postmeta` VALUES("1563", "1051", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1564", "1051", "_wc_average_rating", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1565", "1051", "_wc_review_count", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1566", "1051", "_product_attributes", "a:1:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:0;s:11:\"is_taxonomy\";i:1;}}");
INSERT INTO `nqcpo_postmeta` VALUES("1567", "1051", "_product_version", "4.8.0");
INSERT INTO `nqcpo_postmeta` VALUES("1568", "1051", "_price", "35");
INSERT INTO `nqcpo_postmeta` VALUES("1569", "1051", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1570", "1051", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1571", "1051", "popular_post_views_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1572", "1051", "_wp_old_slug", "zinery-crane");
INSERT INTO `nqcpo_postmeta` VALUES("1573", "1052", "_sku", "woo-album-1");
INSERT INTO `nqcpo_postmeta` VALUES("1574", "1052", "_regular_price", "15");
INSERT INTO `nqcpo_postmeta` VALUES("1575", "1052", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1576", "1052", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1577", "1052", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1578", "1052", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1579", "1052", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1580", "1052", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1581", "1052", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1582", "1052", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1583", "1052", "_download_limit", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1584", "1052", "_download_expiry", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1585", "1052", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1586", "1052", "_stock", "500");
INSERT INTO `nqcpo_postmeta` VALUES("1587", "1052", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1588", "1052", "_wc_average_rating", "5.00");
INSERT INTO `nqcpo_postmeta` VALUES("1589", "1052", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1590", "1052", "_downloadable_files", "a:2:{s:36:\"356506a5-cc15-41b9-801b-9104dda1702c\";a:3:{s:2:\"id\";s:36:\"356506a5-cc15-41b9-801b-9104dda1702c\";s:4:\"name\";s:8:\"Single 1\";s:4:\"file\";s:85:\"https://demo.woothemes.com/woocommerce/wp-content/uploads/sites/56/2017/08/single.jpg\";}s:36:\"18e70c59-59f3-43a3-8525-ce1ea0c12943\";a:3:{s:2:\"id\";s:36:\"18e70c59-59f3-43a3-8525-ce1ea0c12943\";s:4:\"name\";s:8:\"Single 2\";s:4:\"file\";s:84:\"https://demo.woothemes.com/woocommerce/wp-content/uploads/sites/56/2017/08/album.jpg\";}}");
INSERT INTO `nqcpo_postmeta` VALUES("1591", "1052", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1592", "1052", "_price", "13");
INSERT INTO `nqcpo_postmeta` VALUES("1593", "1052", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1594", "1052", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1595", "1052", "popular_post_views_count", "7");
INSERT INTO `nqcpo_postmeta` VALUES("1596", "1052", "_wp_old_slug", "power-cool-fan");
INSERT INTO `nqcpo_postmeta` VALUES("1597", "1052", "_sale_price", "13");
INSERT INTO `nqcpo_postmeta` VALUES("1598", "1052", "_wc_rating_count", "a:1:{i:5;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1599", "1053", "_sku", "woo-cap-1");
INSERT INTO `nqcpo_postmeta` VALUES("1600", "1053", "_regular_price", "18");
INSERT INTO `nqcpo_postmeta` VALUES("1601", "1053", "_sale_price", "16");
INSERT INTO `nqcpo_postmeta` VALUES("1602", "1053", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1603", "1053", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1604", "1053", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1605", "1053", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1606", "1053", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1607", "1053", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1608", "1053", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1609", "1053", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1610", "1053", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1611", "1053", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1612", "1053", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1613", "1053", "_stock", "50");
INSERT INTO `nqcpo_postmeta` VALUES("1614", "1053", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1615", "1053", "_wc_average_rating", "4.00");
INSERT INTO `nqcpo_postmeta` VALUES("1616", "1053", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1617", "1053", "_product_attributes", "a:1:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:0;s:11:\"is_taxonomy\";i:1;}}");
INSERT INTO `nqcpo_postmeta` VALUES("1618", "1053", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1619", "1053", "_price", "16");
INSERT INTO `nqcpo_postmeta` VALUES("1620", "1053", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1621", "1053", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1622", "1053", "popular_post_views_count", "5");
INSERT INTO `nqcpo_postmeta` VALUES("1623", "1053", "_wc_rating_count", "a:1:{i:4;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1624", "1054", "_sku", "heavy-machine-254");
INSERT INTO `nqcpo_postmeta` VALUES("1625", "1054", "_regular_price", "12");
INSERT INTO `nqcpo_postmeta` VALUES("1626", "1054", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1627", "1054", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1628", "1054", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1629", "1054", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1630", "1054", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1631", "1054", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1632", "1054", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1633", "1054", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1634", "1054", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1635", "1054", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1636", "1054", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1637", "1054", "_stock", "20");
INSERT INTO `nqcpo_postmeta` VALUES("1638", "1054", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1639", "1054", "_wc_average_rating", "3.00");
INSERT INTO `nqcpo_postmeta` VALUES("1640", "1054", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1641", "1054", "_product_attributes", "a:1:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:0;s:11:\"is_taxonomy\";i:1;}}");
INSERT INTO `nqcpo_postmeta` VALUES("1642", "1054", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1643", "1054", "_price", "11");
INSERT INTO `nqcpo_postmeta` VALUES("1644", "1054", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1645", "1054", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1646", "1054", "popular_post_views_count", "6");
INSERT INTO `nqcpo_postmeta` VALUES("1647", "1054", "_sale_price", "11");
INSERT INTO `nqcpo_postmeta` VALUES("1648", "1054", "_wc_rating_count", "a:1:{i:3;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1649", "1055", "_sku", "woo-belt-1");
INSERT INTO `nqcpo_postmeta` VALUES("1650", "1055", "_regular_price", "65");
INSERT INTO `nqcpo_postmeta` VALUES("1651", "1055", "_sale_price", "55");
INSERT INTO `nqcpo_postmeta` VALUES("1652", "1055", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1653", "1055", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1654", "1055", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1655", "1055", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1656", "1055", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1657", "1055", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1658", "1055", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1659", "1055", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1660", "1055", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1661", "1055", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1662", "1055", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1663", "1055", "_stock", "200");
INSERT INTO `nqcpo_postmeta` VALUES("1664", "1055", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1665", "1055", "_wc_average_rating", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1666", "1055", "_wc_review_count", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1667", "1055", "_product_version", "4.8.0");
INSERT INTO `nqcpo_postmeta` VALUES("1668", "1055", "_price", "55");
INSERT INTO `nqcpo_postmeta` VALUES("1669", "1055", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1670", "1055", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1671", "1055", "popular_post_views_count", "4");
INSERT INTO `nqcpo_postmeta` VALUES("1672", "1055", "_wp_old_slug", "paper-maps");
INSERT INTO `nqcpo_postmeta` VALUES("1673", "1056", "_sku", "Woo-tshirt-logo-1");
INSERT INTO `nqcpo_postmeta` VALUES("1674", "1056", "_regular_price", "18");
INSERT INTO `nqcpo_postmeta` VALUES("1675", "1056", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1676", "1056", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1677", "1056", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1678", "1056", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1679", "1056", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1680", "1056", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1681", "1056", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1682", "1056", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1683", "1056", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1684", "1056", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1685", "1056", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1686", "1056", "_stock", "500");
INSERT INTO `nqcpo_postmeta` VALUES("1687", "1056", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1688", "1056", "_wc_average_rating", "4.00");
INSERT INTO `nqcpo_postmeta` VALUES("1689", "1056", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1690", "1056", "_product_attributes", "a:1:{s:8:\"pa_color\";a:6:{s:4:\"name\";s:8:\"pa_color\";s:5:\"value\";s:0:\"\";s:8:\"position\";i:0;s:10:\"is_visible\";i:1;s:12:\"is_variation\";i:0;s:11:\"is_taxonomy\";i:1;}}");
INSERT INTO `nqcpo_postmeta` VALUES("1691", "1056", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1692", "1056", "_price", "17");
INSERT INTO `nqcpo_postmeta` VALUES("1693", "1056", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1694", "1056", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1695", "1056", "popular_post_views_count", "12");
INSERT INTO `nqcpo_postmeta` VALUES("1696", "1056", "_sale_price", "17");
INSERT INTO `nqcpo_postmeta` VALUES("1697", "1056", "_wc_rating_count", "a:1:{i:4;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1698", "1057", "_sku", "logo-collection-1");
INSERT INTO `nqcpo_postmeta` VALUES("1699", "1057", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1700", "1057", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1701", "1057", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1702", "1057", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1703", "1057", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1704", "1057", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1705", "1057", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1706", "1057", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1707", "1057", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1708", "1057", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1709", "1057", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1710", "1057", "_stock", "500");
INSERT INTO `nqcpo_postmeta` VALUES("1711", "1057", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1712", "1057", "_wc_average_rating", "4.00");
INSERT INTO `nqcpo_postmeta` VALUES("1713", "1057", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1714", "1057", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1715", "1057", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1716", "1057", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1717", "1057", "popular_post_views_count", "10");
INSERT INTO `nqcpo_postmeta` VALUES("1718", "1057", "_children", "a:0:{}");
INSERT INTO `nqcpo_postmeta` VALUES("1719", "1057", "_regular_price", "250");
INSERT INTO `nqcpo_postmeta` VALUES("1720", "1057", "_sale_price", "240");
INSERT INTO `nqcpo_postmeta` VALUES("1721", "1057", "_price", "240");
INSERT INTO `nqcpo_postmeta` VALUES("1722", "1057", "_wc_rating_count", "a:1:{i:4;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1723", "1059", "_sku", "wp-pennant-1");
INSERT INTO `nqcpo_postmeta` VALUES("1724", "1059", "_regular_price", "11.05");
INSERT INTO `nqcpo_postmeta` VALUES("1725", "1059", "total_sales", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1726", "1059", "_tax_status", "taxable");
INSERT INTO `nqcpo_postmeta` VALUES("1727", "1059", "_tax_class", "");
INSERT INTO `nqcpo_postmeta` VALUES("1728", "1059", "_manage_stock", "yes");
INSERT INTO `nqcpo_postmeta` VALUES("1729", "1059", "_backorders", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1730", "1059", "_sold_individually", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1731", "1059", "_virtual", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1732", "1059", "_downloadable", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1733", "1059", "_download_limit", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1734", "1059", "_download_expiry", "0");
INSERT INTO `nqcpo_postmeta` VALUES("1735", "1059", "_thumbnail_id", "1157");
INSERT INTO `nqcpo_postmeta` VALUES("1736", "1059", "_stock", "500");
INSERT INTO `nqcpo_postmeta` VALUES("1737", "1059", "_stock_status", "instock");
INSERT INTO `nqcpo_postmeta` VALUES("1738", "1059", "_wc_average_rating", "5.00");
INSERT INTO `nqcpo_postmeta` VALUES("1739", "1059", "_wc_review_count", "1");
INSERT INTO `nqcpo_postmeta` VALUES("1740", "1059", "_product_url", "https://mercantile.wordpress.org/product/wordpress-pennant/");
INSERT INTO `nqcpo_postmeta` VALUES("1741", "1059", "_button_text", "Buy on the WordPress swag store!");
INSERT INTO `nqcpo_postmeta` VALUES("1742", "1059", "_product_version", "5.5.2");
INSERT INTO `nqcpo_postmeta` VALUES("1743", "1059", "_price", "10.25");
INSERT INTO `nqcpo_postmeta` VALUES("1744", "1059", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1745", "1059", "product_company_name", "Audible Studios");
INSERT INTO `nqcpo_postmeta` VALUES("1746", "1059", "popular_post_views_count", "13");
INSERT INTO `nqcpo_postmeta` VALUES("1747", "1059", "_wp_old_slug", "technician-screen");
INSERT INTO `nqcpo_postmeta` VALUES("1748", "1059", "_sale_price", "10.25");
INSERT INTO `nqcpo_postmeta` VALUES("1749", "1059", "_wc_rating_count", "a:1:{i:5;i:1;}");
INSERT INTO `nqcpo_postmeta` VALUES("1792", "90", "_thumbnail_id", "1283");
INSERT INTO `nqcpo_postmeta` VALUES("1793", "90", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1795", "90", "popular_post_views_count", "72");
INSERT INTO `nqcpo_postmeta` VALUES("1798", "91", "_thumbnail_id", "1108");
INSERT INTO `nqcpo_postmeta` VALUES("1799", "91", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1800", "91", "service_icon", "flaticon-helmet");
INSERT INTO `nqcpo_postmeta` VALUES("1801", "91", "popular_post_views_count", "6");
INSERT INTO `nqcpo_postmeta` VALUES("1802", "91", "service_caption", "Builders Merchant Sales");
INSERT INTO `nqcpo_postmeta` VALUES("1803", "91", "service_list", "a:8:{i:0;s:33:\"Recognition, drive special offers\";i:1;s:35:\"Launch a new product or communicate\";i:2;s:27:\"Message and generate action\";i:3;s:29:\"Campaign to powerfully convey\";i:4;s:39:\"Outdoor media, PR and digital marketing\";i:5;s:49:\"Recognition, drive special offers + Digital Media\";i:6;s:35:\"Launch a new product or communicate\";i:7;s:29:\"Campaign to powerfully convey\";}");
INSERT INTO `nqcpo_postmeta` VALUES("1804", "95", "_thumbnail_id", "1108");
INSERT INTO `nqcpo_postmeta` VALUES("1805", "95", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1806", "95", "service_icon", "flaticon-wheel-saw");
INSERT INTO `nqcpo_postmeta` VALUES("1807", "95", "popular_post_views_count", "80");
INSERT INTO `nqcpo_postmeta` VALUES("1808", "95", "service_caption", "Asia Pacific Winner");
INSERT INTO `nqcpo_postmeta` VALUES("1809", "95", "service_list", "a:8:{i:0;s:33:\"Recognition, drive special offers\";i:1;s:35:\"Launch a new product or communicate\";i:2;s:27:\"Message and generate action\";i:3;s:29:\"Campaign to powerfully convey\";i:4;s:39:\"Outdoor media, PR and digital marketing\";i:5;s:49:\"Recognition, drive special offers + Digital Media\";i:6;s:35:\"Launch a new product or communicate\";i:7;s:29:\"Campaign to powerfully convey\";}");
INSERT INTO `nqcpo_postmeta` VALUES("1810", "96", "_thumbnail_id", "1108");
INSERT INTO `nqcpo_postmeta` VALUES("1811", "96", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1812", "96", "service_icon", "flaticon-carpenter");
INSERT INTO `nqcpo_postmeta` VALUES("1813", "96", "popular_post_views_count", "19");
INSERT INTO `nqcpo_postmeta` VALUES("1814", "96", "service_caption", "1st In Metallurgy");
INSERT INTO `nqcpo_postmeta` VALUES("1815", "96", "service_list", "a:8:{i:0;s:33:\"Recognition, drive special offers\";i:1;s:35:\"Launch a new product or communicate\";i:2;s:27:\"Message and generate action\";i:3;s:29:\"Campaign to powerfully convey\";i:4;s:39:\"Outdoor media, PR and digital marketing\";i:5;s:49:\"Recognition, drive special offers + Digital Media\";i:6;s:35:\"Launch a new product or communicate\";i:7;s:29:\"Campaign to powerfully convey\";}");
INSERT INTO `nqcpo_postmeta` VALUES("1816", "97", "_thumbnail_id", "1108");
INSERT INTO `nqcpo_postmeta` VALUES("1817", "97", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1818", "97", "service_icon", "flaticon-jigsaw");
INSERT INTO `nqcpo_postmeta` VALUES("1819", "97", "popular_post_views_count", "34");
INSERT INTO `nqcpo_postmeta` VALUES("1820", "97", "service_caption", "6 Million Barrel");
INSERT INTO `nqcpo_postmeta` VALUES("1821", "97", "service_list", "a:8:{i:0;s:33:\"Recognition, drive special offers\";i:1;s:35:\"Launch a new product or communicate\";i:2;s:27:\"Message and generate action\";i:3;s:29:\"Campaign to powerfully convey\";i:4;s:39:\"Outdoor media, PR and digital marketing\";i:5;s:49:\"Recognition, drive special offers + Digital Media\";i:6;s:35:\"Launch a new product or communicate\";i:7;s:29:\"Campaign to powerfully convey\";}");
INSERT INTO `nqcpo_postmeta` VALUES("1822", "141", "_thumbnail_id", "1143");
INSERT INTO `nqcpo_postmeta` VALUES("1823", "141", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1824", "141", "service_icon", "flaticon-helmet");
INSERT INTO `nqcpo_postmeta` VALUES("1825", "141", "projects_icon", "flaticon-worker");
INSERT INTO `nqcpo_postmeta` VALUES("1826", "141", "popular_post_views_count", "116");
INSERT INTO `nqcpo_postmeta` VALUES("1827", "141", "projects_sidebar_layout", "right");
INSERT INTO `nqcpo_postmeta` VALUES("1828", "141", "projects_sidebar_selected", "default-sidebar");
INSERT INTO `nqcpo_postmeta` VALUES("1829", "143", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1830", "143", "service_icon", "flaticon-electric-tower");
INSERT INTO `nqcpo_postmeta` VALUES("1831", "143", "_thumbnail_id", "1143");
INSERT INTO `nqcpo_postmeta` VALUES("1832", "143", "projects_icon", "flaticon-electric-tower");
INSERT INTO `nqcpo_postmeta` VALUES("1833", "143", "popular_post_views_count", "112");
INSERT INTO `nqcpo_postmeta` VALUES("1834", "143", "projects_sidebar_layout", "right");
INSERT INTO `nqcpo_postmeta` VALUES("1835", "143", "projects_sidebar_selected", "default-sidebar");
INSERT INTO `nqcpo_postmeta` VALUES("1836", "145", "_thumbnail_id", "1283");
INSERT INTO `nqcpo_postmeta` VALUES("1837", "145", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1838", "145", "service_icon", "flaticon-file");
INSERT INTO `nqcpo_postmeta` VALUES("1839", "145", "projects_icon", "flaticon-file");
INSERT INTO `nqcpo_postmeta` VALUES("1840", "145", "popular_post_views_count", "117");
INSERT INTO `nqcpo_postmeta` VALUES("1841", "145", "projects_sidebar_layout", "right");
INSERT INTO `nqcpo_postmeta` VALUES("1842", "145", "projects_sidebar_selected", "default-sidebar");
INSERT INTO `nqcpo_postmeta` VALUES("1843", "146", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1844", "146", "service_icon", "flaticon-engineer-2");
INSERT INTO `nqcpo_postmeta` VALUES("1845", "146", "projects_icon", "flaticon-engineer-2");
INSERT INTO `nqcpo_postmeta` VALUES("1846", "146", "popular_post_views_count", "261");
INSERT INTO `nqcpo_postmeta` VALUES("1847", "146", "post_views_count", "3");
INSERT INTO `nqcpo_postmeta` VALUES("1848", "146", "projects_sidebar_layout", "right");
INSERT INTO `nqcpo_postmeta` VALUES("1849", "146", "projects_sidebar_selected", "default-sidebar");
INSERT INTO `nqcpo_postmeta` VALUES("1850", "146", "_thumbnail_id", "1143");
INSERT INTO `nqcpo_postmeta` VALUES("1851", "147", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1852", "147", "_thumbnail_id", "1143");
INSERT INTO `nqcpo_postmeta` VALUES("1853", "147", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1854", "147", "service_icon", "flaticon-worker");
INSERT INTO `nqcpo_postmeta` VALUES("1855", "147", "projects_icon", "flaticon-worker-1");
INSERT INTO `nqcpo_postmeta` VALUES("1856", "147", "popular_post_views_count", "100");
INSERT INTO `nqcpo_postmeta` VALUES("1857", "147", "projects_sidebar_layout", "right");
INSERT INTO `nqcpo_postmeta` VALUES("1858", "147", "projects_sidebar_selected", "default-sidebar");
INSERT INTO `nqcpo_postmeta` VALUES("1859", "148", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1860", "148", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1861", "148", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1862", "148", "_thumbnail_id", "1143");
INSERT INTO `nqcpo_postmeta` VALUES("1863", "148", "service_icon", "flaticon-lighthouse");
INSERT INTO `nqcpo_postmeta` VALUES("1864", "148", "projects_icon", "flaticon-lighthouse");
INSERT INTO `nqcpo_postmeta` VALUES("1865", "148", "popular_post_views_count", "101");
INSERT INTO `nqcpo_postmeta` VALUES("1866", "148", "projects_sidebar_layout", "right");
INSERT INTO `nqcpo_postmeta` VALUES("1867", "148", "projects_sidebar_selected", "default-sidebar");
INSERT INTO `nqcpo_postmeta` VALUES("1868", "149", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1869", "149", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1870", "149", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1871", "149", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1872", "149", "_thumbnail_id", "1143");
INSERT INTO `nqcpo_postmeta` VALUES("1873", "149", "service_icon", "flaticon-worker-1");
INSERT INTO `nqcpo_postmeta` VALUES("1874", "149", "projects_icon", "flaticon-helmet");
INSERT INTO `nqcpo_postmeta` VALUES("1875", "149", "popular_post_views_count", "100");
INSERT INTO `nqcpo_postmeta` VALUES("1876", "149", "projects_sidebar_layout", "right");
INSERT INTO `nqcpo_postmeta` VALUES("1877", "149", "projects_sidebar_selected", "default-sidebar");
INSERT INTO `nqcpo_postmeta` VALUES("1878", "150", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1879", "150", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1880", "150", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1881", "150", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1882", "150", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1883", "150", "_thumbnail_id", "1283");
INSERT INTO `nqcpo_postmeta` VALUES("1884", "150", "service_icon", "flaticon-construction");
INSERT INTO `nqcpo_postmeta` VALUES("1885", "150", "projects_icon", "flaticon-construction");
INSERT INTO `nqcpo_postmeta` VALUES("1886", "150", "popular_post_views_count", "79");
INSERT INTO `nqcpo_postmeta` VALUES("1887", "150", "projects_sidebar_layout", "no");
INSERT INTO `nqcpo_postmeta` VALUES("1888", "150", "projects_sidebar_selected", "default-sidebar");
INSERT INTO `nqcpo_postmeta` VALUES("1889", "474", "_thumbnail_id", "1153");
INSERT INTO `nqcpo_postmeta` VALUES("1890", "474", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1891", "474", "team_designation", "CEO & Founder");
INSERT INTO `nqcpo_postmeta` VALUES("1892", "474", "team_facebook", "https://facebook.com");
INSERT INTO `nqcpo_postmeta` VALUES("1893", "476", "_thumbnail_id", "1153");
INSERT INTO `nqcpo_postmeta` VALUES("1894", "476", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1895", "476", "team_designation", "AI Expert");
INSERT INTO `nqcpo_postmeta` VALUES("1896", "476", "team_facebook", "https://facebook.com");
INSERT INTO `nqcpo_postmeta` VALUES("1897", "477", "_thumbnail_id", "1153");
INSERT INTO `nqcpo_postmeta` VALUES("1898", "477", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1899", "477", "team_designation", "Manufacturer");
INSERT INTO `nqcpo_postmeta` VALUES("1900", "477", "team_facebook", "https://facebook.com");
INSERT INTO `nqcpo_postmeta` VALUES("1901", "478", "_thumbnail_id", "1153");
INSERT INTO `nqcpo_postmeta` VALUES("1902", "478", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1903", "478", "team_designation", "CTO Director");
INSERT INTO `nqcpo_postmeta` VALUES("1904", "478", "team_facebook", "https://facebook.com");
INSERT INTO `nqcpo_postmeta` VALUES("1905", "479", "_thumbnail_id", "1153");
INSERT INTO `nqcpo_postmeta` VALUES("1906", "479", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1907", "479", "team_designation", "Mine Corer");
INSERT INTO `nqcpo_postmeta` VALUES("1908", "479", "team_facebook", "https://facebook.com");
INSERT INTO `nqcpo_postmeta` VALUES("1909", "480", "_thumbnail_id", "1153");
INSERT INTO `nqcpo_postmeta` VALUES("1910", "480", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1911", "480", "team_designation", "Port Manager");
INSERT INTO `nqcpo_postmeta` VALUES("1912", "480", "team_facebook", "https://facebook.com");
INSERT INTO `nqcpo_postmeta` VALUES("1913", "481", "_thumbnail_id", "1153");
INSERT INTO `nqcpo_postmeta` VALUES("1914", "481", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1915", "481", "team_designation", "Ship Yard Sec");
INSERT INTO `nqcpo_postmeta` VALUES("1916", "481", "team_facebook", "https://facebook.com");
INSERT INTO `nqcpo_postmeta` VALUES("1917", "1172", "_form", "<div class = \"row\">\n<div class=\"col-md-12 col-sm-12 col-lg-12\">[text* text-46 placeholder \"Adınız Soyadınız\"]</div>\n<div class=\"col-md-6 col-sm-6 col-lg-6\">[email* email-205 placeholder \"E-Posta Adresiniz\"]</div>\n<div class=\"col-md-6 col-sm-6 col-lg-6\">[tel* tel-510 placeholder \"Telefon Numaranız\"]</div>\n<div class=\"col-md-12 col-sm-12 col-lg-12\">[textarea textarea-810 placeholder \"Mesajınız\"]</div>\n<div class=\"col-md-12 col-sm-12 col-lg-12\">[submit class:thm-btn class:thm-bg class:text-center \"Gönder\"]</div>\n</div>");
INSERT INTO `nqcpo_postmeta` VALUES("1918", "1172", "_mail", "a:9:{s:6:\"active\";b:1;s:7:\"subject\";s:26:\"[_site_title] \"Yeni Mesaj\"\";s:6:\"sender\";s:38:\"[_site_title] <info@ballielektrik.com>\";s:9:\"recipient\";s:19:\"[_site_admin_email]\";s:4:\"body\";s:83:\"Kimden: [text-46] <[email-205]>\nTelefon Numarası: [tel-510]\n\nMesaj:\n[textarea-810]\";s:18:\"additional_headers\";s:0:\"\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `nqcpo_postmeta` VALUES("1919", "1172", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:30:\"[_site_title] \"[your-subject]\"\";s:6:\"sender\";s:35:\"[_site_title] <nauthemes@gmail.com>\";s:9:\"recipient\";s:12:\"[your-email]\";s:4:\"body\";s:105:\"Message Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on [_site_title] ([_site_url])\";s:18:\"additional_headers\";s:29:\"Reply-To: [_site_admin_email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `nqcpo_postmeta` VALUES("1920", "1172", "_messages", "a:22:{s:12:\"mail_sent_ok\";s:50:\"Gönderenin iletisi başarılı olarak gönderildi\";s:12:\"mail_sent_ng\";s:54:\"Gönderenin iletisinin gönderilmesi başarısız oldu\";s:16:\"validation_error\";s:32:\"Onaylama hataları meydana geldi\";s:4:\"spam\";s:42:\"Sunuş istenmeyen ileti olarak gönderildi\";s:12:\"accept_terms\";s:53:\"Gönderenin kabul etmek zorunda olduğu koşullar var\";s:16:\"invalid_required\";s:50:\"Gönderenin doldurmak zorunda olduğu bir alan var\";s:16:\"invalid_too_long\";s:81:\"Kullanıcı girdisinin en fazla izin verildiği uzunluktan daha uzun bir alan var\";s:17:\"invalid_too_short\";s:79:\"Kullanıcı girdisinin en az izin verildiği uzunluktan daha kısa bir alan var\";s:13:\"upload_failed\";s:53:\"Dosyayı gönderme herhangi bir nedenden başarısız\";s:24:\"upload_file_type_invalid\";s:55:\"Yüklenen dosya izin verilmeyen dosya biçimi içeriyor\";s:21:\"upload_file_too_large\";s:30:\"Gönderilen dosya çok büyük\";s:23:\"upload_failed_php_error\";s:55:\"Dosyayı gönderme PHP hatasından dolayı başarısız\";s:12:\"invalid_date\";s:44:\"Gönderenin girdiği tarih biçimi geçersiz\";s:14:\"date_too_early\";s:34:\"Tarih, en az sınırdan daha erken\";s:13:\"date_too_late\";s:36:\"Tarih, en fazla sınırdan daha geç\";s:14:\"invalid_number\";s:44:\"Gönderenin girdiği sayı biçimi geçersiz\";s:16:\"number_too_small\";s:37:\"Sayı, en az sınırdan daha küçük\";s:16:\"number_too_large\";s:39:\"Sayı, en fazla sınırdan daha büyük\";s:23:\"quiz_answer_not_correct\";s:40:\"Gönderen soruya doğru yanıtı girmedi\";s:13:\"invalid_email\";s:44:\"Gönderenin girdiği eposta adresi geçersiz\";s:11:\"invalid_url\";s:34:\"Gönderenin girdiği URL geçersiz\";s:11:\"invalid_tel\";s:48:\"Gönderenin girdiği telefon numarası geçersiz\";}");
INSERT INTO `nqcpo_postmeta` VALUES("1921", "1172", "_additional_settings", "");
INSERT INTO `nqcpo_postmeta` VALUES("1922", "1172", "_locale", "en_US");
INSERT INTO `nqcpo_postmeta` VALUES("1924", "173", "_thumbnail_id", "1149");
INSERT INTO `nqcpo_postmeta` VALUES("1925", "173", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1926", "173", "testimonial_stars", "4");
INSERT INTO `nqcpo_postmeta` VALUES("1927", "173", "testimonial_reviews", "(07 Reviews)");
INSERT INTO `nqcpo_postmeta` VALUES("1928", "177", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1929", "177", "_thumbnail_id", "1149");
INSERT INTO `nqcpo_postmeta` VALUES("1930", "177", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1931", "177", "testimonial_stars", "3");
INSERT INTO `nqcpo_postmeta` VALUES("1932", "177", "testimonial_reviews", "(03 Reviews)");
INSERT INTO `nqcpo_postmeta` VALUES("1933", "178", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1934", "178", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1935", "178", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1936", "178", "_thumbnail_id", "1149");
INSERT INTO `nqcpo_postmeta` VALUES("1937", "178", "testimonial_stars", "5");
INSERT INTO `nqcpo_postmeta` VALUES("1938", "178", "testimonial_reviews", "(08 Reviews)");
INSERT INTO `nqcpo_postmeta` VALUES("1939", "482", "_thumbnail_id", "1153");
INSERT INTO `nqcpo_postmeta` VALUES("1940", "482", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1941", "482", "team_designation", "Machine Ops");
INSERT INTO `nqcpo_postmeta` VALUES("1942", "482", "team_facebook", "https://facebook.com");
INSERT INTO `nqcpo_postmeta` VALUES("1943", "483", "_thumbnail_id", "1153");
INSERT INTO `nqcpo_postmeta` VALUES("1944", "483", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1945", "483", "team_designation", "Secretary");
INSERT INTO `nqcpo_postmeta` VALUES("1946", "483", "team_facebook", "https://facebook.com");
INSERT INTO `nqcpo_postmeta` VALUES("1947", "484", "_thumbnail_id", "1153");
INSERT INTO `nqcpo_postmeta` VALUES("1948", "484", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("1949", "484", "team_designation", "Field Controller");
INSERT INTO `nqcpo_postmeta` VALUES("1950", "484", "team_facebook", "https://facebook.com");
INSERT INTO `nqcpo_postmeta` VALUES("2028", "32", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("2029", "32", "_elementor_page_settings", "a:1:{s:9:\"site_name\";s:22:\"Ankara Ballı Elektrik\";}");
INSERT INTO `nqcpo_postmeta` VALUES("2032", "1169", "_edit_lock", "1760341017:1");
INSERT INTO `nqcpo_postmeta` VALUES("2033", "1187", "_wp_attached_file", "2021/08/Elektrik-ariza-tespiti-ankara-balli-elektrik.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("2034", "1187", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:56:\"2021/08/Elektrik-ariza-tespiti-ankara-balli-elektrik.jpg\";s:5:\"sizes\";a:13:{s:6:\"medium\";a:4:{s:4:\"file\";s:56:\"Elektrik-ariza-tespiti-ankara-balli-elektrik-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:57:\"Elektrik-ariza-tespiti-ankara-balli-elektrik-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:56:\"Elektrik-ariza-tespiti-ankara-balli-elektrik-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:56:\"Elektrik-ariza-tespiti-ankara-balli-elektrik-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:58:\"Elektrik-ariza-tespiti-ankara-balli-elektrik-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:56:\"Elektrik-ariza-tespiti-ankara-balli-elektrik-770x470.jpg\";s:5:\"width\";i:770;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:56:\"Elektrik-ariza-tespiti-ankara-balli-elektrik-470x530.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:530;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:56:\"Elektrik-ariza-tespiti-ankara-balli-elektrik-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:56:\"Elektrik-ariza-tespiti-ankara-balli-elektrik-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:56:\"Elektrik-ariza-tespiti-ankara-balli-elektrik-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:56:\"Elektrik-ariza-tespiti-ankara-balli-elektrik-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:56:\"Elektrik-ariza-tespiti-ankara-balli-elektrik-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:56:\"Elektrik-ariza-tespiti-ankara-balli-elektrik-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("2103", "1198", "_wp_attached_file", "2021/08/Guvenlik-kamerasi-Ankara-Balli-Elektrik.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("2104", "1198", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:51:\"2021/08/Guvenlik-kamerasi-Ankara-Balli-Elektrik.jpg\";s:5:\"sizes\";a:13:{s:6:\"medium\";a:4:{s:4:\"file\";s:51:\"Guvenlik-kamerasi-Ankara-Balli-Elektrik-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:52:\"Guvenlik-kamerasi-Ankara-Balli-Elektrik-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:51:\"Guvenlik-kamerasi-Ankara-Balli-Elektrik-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:51:\"Guvenlik-kamerasi-Ankara-Balli-Elektrik-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:53:\"Guvenlik-kamerasi-Ankara-Balli-Elektrik-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:51:\"Guvenlik-kamerasi-Ankara-Balli-Elektrik-770x470.jpg\";s:5:\"width\";i:770;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:51:\"Guvenlik-kamerasi-Ankara-Balli-Elektrik-470x530.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:530;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:51:\"Guvenlik-kamerasi-Ankara-Balli-Elektrik-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:51:\"Guvenlik-kamerasi-Ankara-Balli-Elektrik-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:51:\"Guvenlik-kamerasi-Ankara-Balli-Elektrik-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:51:\"Guvenlik-kamerasi-Ankara-Balli-Elektrik-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:51:\"Guvenlik-kamerasi-Ankara-Balli-Elektrik-600x400.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:51:\"Guvenlik-kamerasi-Ankara-Balli-Elektrik-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("2174", "1208", "_wp_attached_file", "2021/08/Goruntulu-Diafon-Ankara-Balli-Elektrik.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("2175", "1208", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:4:\"file\";s:50:\"2021/08/Goruntulu-Diafon-Ankara-Balli-Elektrik.jpg\";s:5:\"sizes\";a:13:{s:6:\"medium\";a:4:{s:4:\"file\";s:50:\"Goruntulu-Diafon-Ankara-Balli-Elektrik-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:51:\"Goruntulu-Diafon-Ankara-Balli-Elektrik-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:50:\"Goruntulu-Diafon-Ankara-Balli-Elektrik-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:50:\"Goruntulu-Diafon-Ankara-Balli-Elektrik-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:51:\"Goruntulu-Diafon-Ankara-Balli-Elektrik-1536x864.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:50:\"Goruntulu-Diafon-Ankara-Balli-Elektrik-770x470.jpg\";s:5:\"width\";i:770;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:50:\"Goruntulu-Diafon-Ankara-Balli-Elektrik-470x530.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:530;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"woocommerce_thumbnail\";a:5:{s:4:\"file\";s:50:\"Goruntulu-Diafon-Ankara-Balli-Elektrik-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:4:{s:4:\"file\";s:50:\"Goruntulu-Diafon-Ankara-Balli-Elektrik-600x338.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:338;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:29:\"woocommerce_gallery_thumbnail\";a:4:{s:4:\"file\";s:50:\"Goruntulu-Diafon-Ankara-Balli-Elektrik-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"shop_catalog\";a:4:{s:4:\"file\";s:50:\"Goruntulu-Diafon-Ankara-Balli-Elektrik-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"shop_single\";a:4:{s:4:\"file\";s:50:\"Goruntulu-Diafon-Ankara-Balli-Elektrik-600x338.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:338;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"shop_thumbnail\";a:4:{s:4:\"file\";s:50:\"Goruntulu-Diafon-Ankara-Balli-Elektrik-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("2207", "357", "_edit_last", "1");
INSERT INTO `nqcpo_postmeta` VALUES("2215", "357", "_edit_lock", "1629282710:1");
INSERT INTO `nqcpo_postmeta` VALUES("2216", "436", "_edit_last", "1");
INSERT INTO `nqcpo_postmeta` VALUES("2224", "436", "_edit_lock", "1629314313:1");
INSERT INTO `nqcpo_postmeta` VALUES("2225", "413", "_edit_last", "1");
INSERT INTO `nqcpo_postmeta` VALUES("2232", "413", "_edit_lock", "1629241340:1");
INSERT INTO `nqcpo_postmeta` VALUES("2233", "1169", "_edit_last", "1");
INSERT INTO `nqcpo_postmeta` VALUES("2243", "395", "_edit_last", "1");
INSERT INTO `nqcpo_postmeta` VALUES("2251", "395", "_edit_lock", "1629238436:1");
INSERT INTO `nqcpo_postmeta` VALUES("2346", "32", "popular_post_views_count", "0");
INSERT INTO `nqcpo_postmeta` VALUES("2348", "1158", "popular_post_views_count", "0");
INSERT INTO `nqcpo_postmeta` VALUES("2349", "1235", "_menu_item_type", "post_type");
INSERT INTO `nqcpo_postmeta` VALUES("2350", "1235", "_menu_item_menu_item_parent", "0");
INSERT INTO `nqcpo_postmeta` VALUES("2351", "1235", "_menu_item_object_id", "1169");
INSERT INTO `nqcpo_postmeta` VALUES("2352", "1235", "_menu_item_object", "page");
INSERT INTO `nqcpo_postmeta` VALUES("2353", "1235", "_menu_item_target", "");
INSERT INTO `nqcpo_postmeta` VALUES("2354", "1235", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `nqcpo_postmeta` VALUES("2355", "1235", "_menu_item_xfn", "");
INSERT INTO `nqcpo_postmeta` VALUES("2356", "1235", "_menu_item_url", "");
INSERT INTO `nqcpo_postmeta` VALUES("2358", "1236", "_menu_item_type", "post_type");
INSERT INTO `nqcpo_postmeta` VALUES("2359", "1236", "_menu_item_menu_item_parent", "0");
INSERT INTO `nqcpo_postmeta` VALUES("2360", "1236", "_menu_item_object_id", "9");
INSERT INTO `nqcpo_postmeta` VALUES("2361", "1236", "_menu_item_object", "page");
INSERT INTO `nqcpo_postmeta` VALUES("2362", "1236", "_menu_item_target", "");
INSERT INTO `nqcpo_postmeta` VALUES("2363", "1236", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `nqcpo_postmeta` VALUES("2364", "1236", "_menu_item_xfn", "");
INSERT INTO `nqcpo_postmeta` VALUES("2365", "1236", "_menu_item_url", "");
INSERT INTO `nqcpo_postmeta` VALUES("2367", "1237", "_menu_item_type", "post_type");
INSERT INTO `nqcpo_postmeta` VALUES("2368", "1237", "_menu_item_menu_item_parent", "0");
INSERT INTO `nqcpo_postmeta` VALUES("2369", "1237", "_menu_item_object_id", "395");
INSERT INTO `nqcpo_postmeta` VALUES("2370", "1237", "_menu_item_object", "page");
INSERT INTO `nqcpo_postmeta` VALUES("2371", "1237", "_menu_item_target", "");
INSERT INTO `nqcpo_postmeta` VALUES("2372", "1237", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `nqcpo_postmeta` VALUES("2373", "1237", "_menu_item_xfn", "");
INSERT INTO `nqcpo_postmeta` VALUES("2374", "1237", "_menu_item_url", "");
INSERT INTO `nqcpo_postmeta` VALUES("2385", "1239", "_menu_item_type", "post_type");
INSERT INTO `nqcpo_postmeta` VALUES("2386", "1239", "_menu_item_menu_item_parent", "0");
INSERT INTO `nqcpo_postmeta` VALUES("2387", "1239", "_menu_item_object_id", "413");
INSERT INTO `nqcpo_postmeta` VALUES("2388", "1239", "_menu_item_object", "page");
INSERT INTO `nqcpo_postmeta` VALUES("2389", "1239", "_menu_item_target", "");
INSERT INTO `nqcpo_postmeta` VALUES("2390", "1239", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `nqcpo_postmeta` VALUES("2391", "1239", "_menu_item_xfn", "");
INSERT INTO `nqcpo_postmeta` VALUES("2392", "1239", "_menu_item_url", "");
INSERT INTO `nqcpo_postmeta` VALUES("2394", "1240", "_menu_item_type", "post_type");
INSERT INTO `nqcpo_postmeta` VALUES("2395", "1240", "_menu_item_menu_item_parent", "0");
INSERT INTO `nqcpo_postmeta` VALUES("2396", "1240", "_menu_item_object_id", "357");
INSERT INTO `nqcpo_postmeta` VALUES("2397", "1240", "_menu_item_object", "page");
INSERT INTO `nqcpo_postmeta` VALUES("2398", "1240", "_menu_item_target", "");
INSERT INTO `nqcpo_postmeta` VALUES("2399", "1240", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `nqcpo_postmeta` VALUES("2400", "1240", "_menu_item_xfn", "");
INSERT INTO `nqcpo_postmeta` VALUES("2401", "1240", "_menu_item_url", "");
INSERT INTO `nqcpo_postmeta` VALUES("2403", "1241", "_menu_item_type", "post_type");
INSERT INTO `nqcpo_postmeta` VALUES("2404", "1241", "_menu_item_menu_item_parent", "0");
INSERT INTO `nqcpo_postmeta` VALUES("2405", "1241", "_menu_item_object_id", "436");
INSERT INTO `nqcpo_postmeta` VALUES("2406", "1241", "_menu_item_object", "page");
INSERT INTO `nqcpo_postmeta` VALUES("2407", "1241", "_menu_item_target", "");
INSERT INTO `nqcpo_postmeta` VALUES("2408", "1241", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `nqcpo_postmeta` VALUES("2409", "1241", "_menu_item_xfn", "");
INSERT INTO `nqcpo_postmeta` VALUES("2410", "1241", "_menu_item_url", "");
INSERT INTO `nqcpo_postmeta` VALUES("2412", "1242", "_wp_attached_file", "2021/08/Balli-Elektrik-Ankara.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("2413", "1242", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:610;s:4:\"file\";s:33:\"2021/08/Balli-Elektrik-Ankara.jpg\";s:5:\"sizes\";a:4:{s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"Balli-Elektrik-Ankara-236x300.jpg\";s:5:\"width\";i:236;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"Balli-Elektrik-Ankara-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:33:\"Balli-Elektrik-Ankara-480x470.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:33:\"Balli-Elektrik-Ankara-470x530.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:530;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("2501", "1255", "_wp_attached_file", "2021/08/elektrik-piyasasi-istatistiksel-analizi-03-12-2019.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("2502", "1255", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:853;s:4:\"file\";s:62:\"2021/08/elektrik-piyasasi-istatistiksel-analizi-03-12-2019.jpg\";s:5:\"sizes\";a:6:{s:6:\"medium\";a:4:{s:4:\"file\";s:62:\"elektrik-piyasasi-istatistiksel-analizi-03-12-2019-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:63:\"elektrik-piyasasi-istatistiksel-analizi-03-12-2019-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:62:\"elektrik-piyasasi-istatistiksel-analizi-03-12-2019-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:62:\"elektrik-piyasasi-istatistiksel-analizi-03-12-2019-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:62:\"elektrik-piyasasi-istatistiksel-analizi-03-12-2019-770x470.jpg\";s:5:\"width\";i:770;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:62:\"elektrik-piyasasi-istatistiksel-analizi-03-12-2019-470x530.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:530;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("2688", "90", "_edit_lock", "1629233859:1");
INSERT INTO `nqcpo_postmeta` VALUES("2689", "1283", "_wp_attached_file", "2020/11/unnamed.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("2690", "1283", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:375;s:4:\"file\";s:19:\"2020/11/unnamed.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"unnamed-300x220.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"unnamed-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:19:\"unnamed-470x375.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("2691", "90", "_edit_last", "1");
INSERT INTO `nqcpo_postmeta` VALUES("2707", "145", "_edit_lock", "1629233473:1");
INSERT INTO `nqcpo_postmeta` VALUES("2716", "145", "_edit_last", "1");
INSERT INTO `nqcpo_postmeta` VALUES("2741", "150", "_edit_lock", "1629234172:1");
INSERT INTO `nqcpo_postmeta` VALUES("2742", "150", "_edit_last", "1");
INSERT INTO `nqcpo_postmeta` VALUES("2778", "1293", "_wp_attached_file", "2021/08/5cc71fea0f2bc155655370675.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("2779", "1293", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:334;s:4:\"file\";s:37:\"2021/08/5cc71fea0f2bc155655370675.jpg\";s:5:\"sizes\";a:3:{s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"5cc71fea0f2bc155655370675-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"5cc71fea0f2bc155655370675-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:37:\"5cc71fea0f2bc155655370675-470x334.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:334;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("2780", "1242", "_wp_attachment_image_alt", "Ankara Ballı Elektrik");
INSERT INTO `nqcpo_postmeta` VALUES("2781", "1294", "_wp_attached_file", "2021/08/Elektrik-Pana-Montaj-scaled.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("2782", "1294", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:39:\"2021/08/Elektrik-Pana-Montaj-scaled.jpg\";s:5:\"sizes\";a:8:{s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"Elektrik-Pana-Montaj-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"Elektrik-Pana-Montaj-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Elektrik-Pana-Montaj-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"Elektrik-Pana-Montaj-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:34:\"Elektrik-Pana-Montaj-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:34:\"Elektrik-Pana-Montaj-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:32:\"Elektrik-Pana-Montaj-770x470.jpg\";s:5:\"width\";i:770;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:32:\"Elektrik-Pana-Montaj-470x530.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:530;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"6.3\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark II\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1315421663\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"50\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:6:\"0.0125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:24:\"Elektrik-Pana-Montaj.jpg\";}");
INSERT INTO `nqcpo_postmeta` VALUES("2783", "1295", "_wp_attached_file", "2021/08/Elektrik-Ariza-Tespiti.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("2784", "1295", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:849;s:6:\"height\";i:565;s:4:\"file\";s:34:\"2021/08/Elektrik-Ariza-Tespiti.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"Elektrik-Ariza-Tespiti-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"Elektrik-Ariza-Tespiti-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:34:\"Elektrik-Ariza-Tespiti-768x511.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:511;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:34:\"Elektrik-Ariza-Tespiti-770x470.jpg\";s:5:\"width\";i:770;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:34:\"Elektrik-Ariza-Tespiti-470x530.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:530;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:2:\"10\";s:6:\"credit\";s:13:\"Mou Francesco\";s:6:\"camera\";s:10:\"NIKON D700\";s:7:\"caption\";s:143:\"Electrician technician working on a residential electrical panel, measures the voltage on the terminals of the thermal magnetic circuit breaker\";s:17:\"created_timestamp\";s:10:\"1523112028\";s:9:\"copyright\";s:16:\"Mou Francesco 64\";s:12:\"focal_length\";s:2:\"70\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:7:\"0.00625\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("2804", "1299", "_wp_attached_file", "2021/08/Uydu-Anten-Kurulumu-scaled.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("2805", "1299", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1716;s:4:\"file\";s:38:\"2021/08/Uydu-Anten-Kurulumu-scaled.jpg\";s:5:\"sizes\";a:8:{s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"Uydu-Anten-Kurulumu-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"Uydu-Anten-Kurulumu-1024x686.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:686;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"Uydu-Anten-Kurulumu-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"Uydu-Anten-Kurulumu-768x515.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:515;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:33:\"Uydu-Anten-Kurulumu-1536x1030.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1030;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:33:\"Uydu-Anten-Kurulumu-2048x1373.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1373;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:31:\"Uydu-Anten-Kurulumu-770x470.jpg\";s:5:\"width\";i:770;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:31:\"Uydu-Anten-Kurulumu-470x530.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:530;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:17:\"NIKOLA_NIKOLOVSKI\";s:6:\"camera\";s:10:\"PENTAX K-3\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1426965933\";s:9:\"copyright\";s:17:\"NIKOLA_NIKOLOVSKI\";s:12:\"focal_length\";s:2:\"50\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:2:\"25\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:23:\"Uydu-Anten-Kurulumu.jpg\";}");
INSERT INTO `nqcpo_postmeta` VALUES("2825", "1303", "_wp_attached_file", "2021/08/5cc715cdb5680155655111758.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("2826", "1303", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:4:\"file\";s:37:\"2021/08/5cc715cdb5680155655111758.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"5cc715cdb5680155655111758-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:38:\"5cc715cdb5680155655111758-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"5cc715cdb5680155655111758-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"5cc715cdb5680155655111758-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:39:\"5cc715cdb5680155655111758-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:37:\"5cc715cdb5680155655111758-770x470.jpg\";s:5:\"width\";i:770;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:37:\"5cc715cdb5680155655111758-470x530.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:530;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("2893", "1313", "_elementor_edit_mode", "builder");
INSERT INTO `nqcpo_postmeta` VALUES("2894", "1313", "_elementor_template_type", "page");
INSERT INTO `nqcpo_postmeta` VALUES("2895", "1313", "_elementor_version", "3.4.0");
INSERT INTO `nqcpo_postmeta` VALUES("2899", "1313", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("2900", "1313", "_elementor_data", "[{\"id\":\"2a39b188\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"slider\"},\"elements\":[{\"id\":\"1183336c\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"34ba12b2\",\"elType\":\"widget\",\"settings\":{\"list\":[{\"slide_heading\":\"Elektrik Ar\\u0131za Tespiti\",\"colored_heading\":\"Ankara Ball\\u0131 Elektrik\",\"slide_description\":\"Elektrik Ar\\u0131za Tespit ve Raporlama i\\u00e7in hemen bizimle ileti\\u015fime ge\\u00e7in\",\"slide_btn\":\"\\u0130leti\\u015fim\",\"slide_url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/iletisim\",\"video_title\":\"\",\"video_link\":\"\",\"_id\":\"2df06b9\",\"slide_image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Elektrik-ariza-tespiti-ankara-balli-elektrik.jpg\",\"id\":1187,\"alt\":\"\",\"source\":\"library\"},\"video_title2\":\"\"},{\"slide_heading\":\"\\u00d6nceli\\u011fimiz G\\u00fcvenli\\u011finiz\",\"colored_heading\":\"Ankara Ball\\u0131 Elektrik\",\"slide_description\":\"Profesyonel kamera sistemleriyle g\\u00fcvenli\\u011finiz bizden sorulur. Hemen ileti\\u015fime ge\\u00e7ebilirsiniz\",\"slide_btn\":\"\\u0130leti\\u015fim\",\"slide_url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/iletisim\",\"video_title\":\"\",\"video_link\":\"\",\"_id\":\"5746e25\",\"slide_image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Guvenlik-kamerasi-Ankara-Balli-Elektrik.jpg\",\"id\":1198,\"alt\":\"\",\"source\":\"library\"},\"video_title2\":\"\"},{\"slide_heading\":\"Ailenizin G\\u00fcvenli\\u011fi \\u0130\\u00e7in\",\"colored_heading\":\"Ankara Ball\\u0131 Elektrik\",\"slide_description\":\"G\\u00f6r\\u00fcnt\\u00fcl\\u00fc diafon sistemleriyle art\\u0131k i\\u00e7iniz \\u00e7ok rahat\",\"slide_btn\":\"\\u0130leti\\u015fim\",\"slide_url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/iletisim\",\"video_title\":\"\",\"video_link\":\"\",\"_id\":\"435cfa7\",\"slide_image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Goruntulu-Diafon-Ankara-Balli-Elektrik.jpg\",\"id\":1208,\"alt\":\"\",\"source\":\"library\"},\"video_title2\":\"\"}],\"chose_style\":\"style-two\"},\"elements\":[],\"widgetType\":\"main_slider\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"13ab0fdb\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"about-us\"},\"elements\":[{\"id\":\"be06b03\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"518845b3\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"4e4488c0\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"71eaa0e5\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara.jpg\",\"id\":1242,\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"align\":\"right\",\"width\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"space\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"height\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"13eb2b8d\",\"elType\":\"widget\",\"settings\":{\"chose_style\":\"style-two\",\"content_caption\":\"Hakk\\u0131m\\u0131zda\",\"content_heading\":\"Ankara Ball\\u0131 Elektrik\",\"content_description\":\"Hakk\\u0131m\\u0131zda\",\"colored_title\":\"Ankara Ball\\u0131 Elektrik\",\"orderby\":\"ASC\",\"words_count\":\"7\",\"fact_count\":\"\",\"fact_suffix\":\"\",\"fact_title\":\"\",\"main_image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara.jpg\",\"id\":1242,\"alt\":\"\",\"source\":\"library\"},\"item_description\":\"<p><span style=\\\"vertical-align: inherit;\\\"><span style=\\\"vertical-align: inherit;\\\"><span style=\\\"vertical-align: inherit;\\\"><span style=\\\"vertical-align: inherit;\\\">Sekt\\u00f6rdeki faaliyetlerine 1995 senesinde Ankara ilinde ba\\u015flayan Ankara Ball\\u0131 Elektrik, Ayval\\u0131, Etlik, Ke\\u00e7i\\u00f6ren ilk s\\u0131rada olmak \\u00fczere Ankara ilinde elektrik tesisat\\u0131, elektrik ar\\u0131za bak\\u0131m\\u0131, uydu sistemleri, diyafon sistemleri, kamera sistemleri alanlar\\u0131nda hizmet sunmaktad\\u0131r. Kuruldu\\u011fu g\\u00fcnden g\\u00fcn\\u00fcm\\u00fcze nitelikli malzeme ve i\\u015f\\u00e7ilik \\u00f6ncelikli \\u00e7al\\u0131\\u015fan Ankara Palaz Elektrik firmas\\u0131 olarak m\\u00fc\\u015fteri memnuniyetini her zaman ilk planda tutmaktay\\u0131z. Ankara elektrik\\u00e7i i\\u015f ilanlar\\u0131 yard\\u0131m\\u0131 ile bizlere 7\\/24 ula\\u015fabilirsiniz. Ay\\u0131rca elektirik\\u00e7i Ankara \\u00c7ankaya ya da Ankara K\\u0131z\\u0131lay Elektirik\\u00e7i firmas\\u0131 araman\\u0131za gerek kalmadan ihtiya\\u00e7lar\\u0131n\\u0131za \\u00e7\\u00f6z\\u00fcm \\u00fcretebiliyoruz. K\\u0131saca Ankara elektrik tamircisi araman\\u0131za gerek kalmadan Ball\\u0131 Elektrik olarak t\\u00fcm elektrik ar\\u0131zalar\\u0131n\\u0131z\\u0131 profesyonel ekibimiz ile \\u00e7\\u00f6z\\u00fcyoruz.<\\/span><\\/span><\\/span><\\/span><\\/p>\",\"select_category\":\"0\",\"_margin\":{\"unit\":\"px\",\"top\":\"-95\",\"right\":\"-95\",\"bottom\":\"-95\",\"left\":\"-95\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"about_us_intro\"},{\"id\":\"7d6459c5\",\"elType\":\"widget\",\"settings\":{\"space\":{\"unit\":\"px\",\"size\":53,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"spacer\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"3e1900eb\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"facts-count\"},\"elements\":[{\"id\":\"63e5ce7b\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"4273c03a\",\"elType\":\"widget\",\"settings\":{\"list\":[{\"fact_count\":\"26\",\"fact_suffix\":\"+\",\"fact_text\":\"Y\\u0131ll\\u0131k Tecr\\u00fcbe\",\"_id\":\"238e850\"},{\"fact_count\":\"502\",\"fact_suffix\":\"+\",\"fact_text\":\"Tamamlanm\\u0131\\u015f Proje\",\"_id\":\"97b8e5f\"},{\"fact_count\":\"120\",\"fact_suffix\":\"+\",\"fact_text\":\"G\\u00fcvenlik Kameras\\u0131\",\"_id\":\"f5612c8\"},{\"fact_count\":\"12\",\"fact_suffix\":\"+\",\"fact_text\":\"Devam Eden Proje\",\"_id\":\"1186dce\"}]},\"elements\":[],\"widgetType\":\"facts-count\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"599c0e60\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"services\"},\"elements\":[{\"id\":\"75d887c5\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"3e1c4a3b\",\"elType\":\"widget\",\"settings\":{\"content_subcaption\":\"Ankara Ball\\u0131 Elektrik\",\"content_heading\":\"Sa\\u011flad\\u0131\\u011f\\u0131m\\u0131z Hizmetler\",\"content_caption\":\"Ball\\u0131 elektrik b\\u00fcnyesinde sunmu\\u015f oldu\\u011fu g\\u00fcvenlik kamera sistemleri kurulum montaj ar\\u0131za onar\\u0131m ve bak\\u0131m\\u0131 , uydu anten kurulumu, uydu kanallar\\u0131 kurulumu, uydu ekipman ve malzemeleri sat\\u0131\\u015f\\u0131 , G\\u00f6r\\u00fcnt\\u00fcl\\u00fc diafon sistemleri kurulumu, de\\u011fi\\u015fimi, yeni binalarda \\u015fartnamelerde bulunan isteklerin kar\\u015f\\u0131lanmas\\u0131 , elektrik ar\\u0131za tesisat \\u00e7ekimi, yeni pano kurulumu gibi hizmetler ile siz de\\u011ferli m\\u00fc\\u015fterilerimize faydal\\u0131 olmaya \\u00e7al\\u0131\\u015fmaktay\\u0131z.\",\"background-image\":{\"url\":\"\",\"id\":\"\"},\"select_category\":\"Featured Services\",\"orderby\":\"ASC\",\"words_count\":\"7\",\"button_text\":\"More Services\",\"show_facts\":\"\",\"list\":[{\"fact_count\":\"12\",\"fact_suffix\":\"+\",\"fact_text\":\"Running Projects\",\"_id\":\"58ac328\"}],\"chose_style\":\"style-two\",\"_background_background\":\"classic\",\"_background_color\":\"#F9F9F9\"},\"elements\":[],\"widgetType\":\"services_grid\"},{\"id\":\"d0e52fc\",\"elType\":\"section\",\"settings\":{\"structure\":\"30\",\"background_background\":\"classic\",\"background_color\":\"#F9F9F9\",\"margin\":{\"unit\":\"px\",\"top\":\"-22\",\"right\":0,\"bottom\":\"-22\",\"left\":0,\"isLinked\":true}},\"elements\":[{\"id\":\"14c808da\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":29.91100000000000136424205265939235687255859375},\"elements\":[{\"id\":\"a489ca3\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2020\\/11\\/unnamed.jpg\",\"id\":1283,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"thumbnail_custom_dimension\":{\"width\":\"470\",\"height\":\"530\"},\"title_text\":\"Kamera Kurulum\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nG\\u00fcvenlik kamera \\u0130htiya\\u00e7lar\\u0131n\\u0131z do\\u011frultusunda sizlere en yenilik\\u00e7i alternatifleri sunuyoruz.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true},{\"id\":\"efe35fd\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":33.3299999999999982946974341757595539093017578125},\"elements\":[{\"id\":\"14558e1f\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/5cc71fea0f2bc155655370675.jpg\",\"id\":1293,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"thumbnail_custom_dimension\":{\"width\":\"470\",\"height\":\"530\"},\"title_text\":\"Telefon Ankastre\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\n\\u0130nternet altyap\\u0131 hizmetleri ar\\u0131zalar\\u0131nda h\\u0131zl\\u0131 ve g\\u00fcvenilir \\u00e7\\u00f6z\\u00fcm i\\u00e7in bizimle ileti\\u015fime ge\\u00e7in.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true},{\"id\":\"7d929abb\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":36.423000000000001818989403545856475830078125},\"elements\":[{\"id\":\"69845df6\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Elektrik-Pana-Montaj-scaled.jpg\",\"id\":1294,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"title_text\":\"Elektrik Pano Montaj\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nElektrik tesisat\\u0131n d\\u00fczg\\u00fcn \\u00e7al\\u0131\\u015fmas\\u0131 i\\u00e7in elektrik pano montaj ba\\u011flant\\u0131lar\\u0131 uzmanlar\\u0131nca yap\\u0131lmal\\u0131d\\u0131r.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"103fb82f\",\"elType\":\"widget\",\"settings\":{\"space\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"spacer\"},{\"id\":\"591a0f7f\",\"elType\":\"section\",\"settings\":{\"structure\":\"30\",\"background_background\":\"classic\",\"background_color\":\"#F9F9F9\",\"margin\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true}},\"elements\":[{\"id\":\"5c8139a\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"2d6f8d6b\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Elektrik-Ariza-Tespiti.jpg\",\"id\":1295,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"title_text\":\"Elektrik Ar\\u0131za Tespiti\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nM\\u00fc\\u015fterilerimizin elektrik ar\\u0131za ihtiya\\u00e7lar\\u0131na, en do\\u011fru ve alternatif \\u00e7\\u00f6z\\u00fcmlerle m\\u00fcdahale ediyoruz.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true},{\"id\":\"54a4c438\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"364ced65\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Uydu-Anten-Kurulumu-scaled.jpg\",\"id\":1299,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"title_text\":\"Uydu Anten Kurulumu\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nAnkara uyducu aray\\u0131\\u015f\\u0131nda olanlar\\u0131n tercihi Palaz Elektrik, 7\\/24 kesintisiz hizmet veriyor.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true},{\"id\":\"4c052b44\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"4dcdbb3\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/5cc715cdb5680155655111758.jpg\",\"id\":1303,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"title_text\":\"\\u0130n\\u015faat Elektrik Projeleri\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\n\\u0130n\\u015faat sekt\\u00f6r\\u00fcnde bir\\u00e7ok elektrik proje i\\u015fini tamamlayan firmam\\u0131z, her ge\\u00e7en g\\u00fcn daha da b\\u00fcy\\u00fcyor.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false}],\"isInner\":false},{\"id\":\"13c6bea4\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"blog\"},\"elements\":[{\"id\":\"71c12812\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"889e9ac\",\"elType\":\"widget\",\"settings\":{\"content_caption\":\"Blog Yaz\\u0131lar\\u0131m\\u0131z\",\"content_heading\":\"Son Makaleler\",\"words_count\":\"10\",\"button_text\":\"Daha Fazlas\\u0131\",\"select_category\":\"0\",\"posts_count\":6,\"button_url\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/blog\",\"is_external\":false,\"nofollow\":false,\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"blog_grid\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `nqcpo_postmeta` VALUES("2907", "1313", "_elementor_controls_usage", "a:10:{s:11:\"main_slider\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:2:{s:4:\"list\";i:1;s:11:\"chose_style\";i:1;}}}}s:6:\"column\";a:3:{s:5:\"count\";i:12;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:6:\"layout\";a:1:{s:12:\"_inline_size\";i:12;}}}}s:7:\"section\";a:3:{s:5:\"count\";i:8;s:15:\"control_percent\";i:1;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:4:{s:6:\"layout\";i:5;s:3:\"gap\";i:5;s:15:\"stretch_section\";i:5;s:6:\"_title\";i:5;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:2;}}s:5:\"style\";a:1:{s:18:\"section_background\";a:2:{s:21:\"background_background\";i:2;s:16:\"background_color\";i:2;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:1:{s:6:\"margin\";i:2;}}}}s:5:\"image\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:3:{s:5:\"image\";i:1;s:10:\"image_size\";i:1;s:5:\"align\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:3:{s:5:\"width\";i:1;s:5:\"space\";i:1;s:6:\"height\";i:1;}}}}s:14:\"about_us_intro\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:6;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:13:{s:11:\"chose_style\";i:1;s:15:\"content_caption\";i:1;s:15:\"content_heading\";i:1;s:19:\"content_description\";i:1;s:13:\"colored_title\";i:1;s:7:\"orderby\";i:1;s:11:\"words_count\";i:1;s:10:\"fact_count\";i:1;s:11:\"fact_suffix\";i:1;s:10:\"fact_title\";i:1;s:10:\"main_image\";i:1;s:16:\"item_description\";i:1;s:15:\"select_category\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:1;}}}}s:6:\"spacer\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_spacer\";a:1:{s:5:\"space\";i:2;}}}}s:11:\"facts-count\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:4:\"list\";i:1;}}}}s:13:\"services_grid\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:5;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:10:{s:18:\"content_subcaption\";i:1;s:15:\"content_heading\";i:1;s:15:\"content_caption\";i:1;s:16:\"background-image\";i:1;s:15:\"select_category\";i:1;s:7:\"orderby\";i:1;s:11:\"words_count\";i:1;s:10:\"show_facts\";i:1;s:4:\"list\";i:1;s:11:\"chose_style\";i:1;}}s:8:\"advanced\";a:1:{s:19:\"_section_background\";a:2:{s:22:\"_background_background\";i:1;s:17:\"_background_color\";i:1;}}}}s:9:\"image-box\";a:3:{s:5:\"count\";i:6;s:15:\"control_percent\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:5:{s:5:\"image\";i:6;s:14:\"thumbnail_size\";i:6;s:26:\"thumbnail_custom_dimension\";i:2;s:10:\"title_text\";i:6;s:16:\"description_text\";i:6;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:2:{s:11:\"image_space\";i:6;s:10:\"image_size\";i:6;}}}}s:9:\"blog_grid\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:3;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:7:{s:15:\"content_caption\";i:1;s:15:\"content_heading\";i:1;s:11:\"words_count\";i:1;s:11:\"button_text\";i:1;s:15:\"select_category\";i:1;s:11:\"posts_count\";i:1;s:10:\"button_url\";i:1;}}}}}");
INSERT INTO `nqcpo_postmeta` VALUES("2984", "357", "_elementor_controls_usage", "a:7:{s:5:\"image\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:0;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:3:{s:5:\"image\";i:2;s:10:\"image_size\";i:1;s:5:\"align\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:3:{s:5:\"width\";i:1;s:5:\"space\";i:1;s:6:\"height\";i:1;}}}}s:6:\"column\";a:3:{s:5:\"count\";i:6;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:6:\"layout\";a:1:{s:12:\"_inline_size\";i:6;}}}}s:7:\"section\";a:3:{s:5:\"count\";i:5;s:15:\"control_percent\";i:1;s:8:\"controls\";a:1:{s:6:\"layout\";a:2:{s:17:\"section_structure\";a:1:{s:9:\"structure\";i:1;}s:14:\"section_layout\";a:4:{s:6:\"layout\";i:2;s:3:\"gap\";i:2;s:15:\"stretch_section\";i:2;s:6:\"_title\";i:2;}}}}s:7:\"heading\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_title\";a:1:{s:5:\"title\";i:2;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:4:{s:11:\"title_color\";i:2;s:21:\"typography_typography\";i:2;s:22:\"typography_font_family\";i:2;s:22:\"typography_font_weight\";i:2;}}}}s:11:\"text-editor\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:2:{s:6:\"editor\";i:2;s:10:\"column_gap\";i:1;}}}}s:6:\"spacer\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_spacer\";a:1:{s:5:\"space\";i:1;}}}}s:11:\"facts-count\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:4:\"list\";i:1;}}}}}");
INSERT INTO `nqcpo_postmeta` VALUES("2994", "1328", "_elementor_edit_mode", "builder");
INSERT INTO `nqcpo_postmeta` VALUES("2995", "1328", "_elementor_template_type", "page");
INSERT INTO `nqcpo_postmeta` VALUES("2996", "1328", "_elementor_version", "3.4.0");
INSERT INTO `nqcpo_postmeta` VALUES("3000", "1328", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("3001", "1328", "_elementor_data", "[{\"id\":\"3dec85db\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"slider\"},\"elements\":[{\"id\":\"297fc7bb\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"22b71bba\",\"elType\":\"widget\",\"settings\":{\"list\":[{\"slide_heading\":\"Elektrik Ar\\u0131za Tespiti\",\"colored_heading\":\"Ankara Ball\\u0131 Elektrik\",\"slide_description\":\"Elektrik Ar\\u0131za Tespit ve Raporlama i\\u00e7in hemen bizimle ileti\\u015fime ge\\u00e7in\",\"slide_btn\":\"\\u0130leti\\u015fim\",\"slide_url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/iletisim\",\"video_title\":\"\",\"video_link\":\"\",\"_id\":\"2df06b9\",\"slide_image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Elektrik-ariza-tespiti-ankara-balli-elektrik.jpg\",\"id\":1187,\"alt\":\"\",\"source\":\"library\"},\"video_title2\":\"\"},{\"slide_heading\":\"\\u00d6nceli\\u011fimiz G\\u00fcvenli\\u011finiz\",\"colored_heading\":\"Ankara Ball\\u0131 Elektrik\",\"slide_description\":\"Profesyonel kamera sistemleriyle g\\u00fcvenli\\u011finiz bizden sorulur. Hemen ileti\\u015fime ge\\u00e7ebilirsiniz\",\"slide_btn\":\"\\u0130leti\\u015fim\",\"slide_url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/iletisim\",\"video_title\":\"\",\"video_link\":\"\",\"_id\":\"5746e25\",\"slide_image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Guvenlik-kamerasi-Ankara-Balli-Elektrik.jpg\",\"id\":1198,\"alt\":\"\",\"source\":\"library\"},\"video_title2\":\"\"},{\"slide_heading\":\"Ailenizin G\\u00fcvenli\\u011fi \\u0130\\u00e7in\",\"colored_heading\":\"Ankara Ball\\u0131 Elektrik\",\"slide_description\":\"G\\u00f6r\\u00fcnt\\u00fcl\\u00fc diafon sistemleriyle art\\u0131k i\\u00e7iniz \\u00e7ok rahat\",\"slide_btn\":\"\\u0130leti\\u015fim\",\"slide_url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/iletisim\",\"video_title\":\"\",\"video_link\":\"\",\"_id\":\"435cfa7\",\"slide_image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Goruntulu-Diafon-Ankara-Balli-Elektrik.jpg\",\"id\":1208,\"alt\":\"\",\"source\":\"library\"},\"video_title2\":\"\"}],\"chose_style\":\"style-two\"},\"elements\":[],\"widgetType\":\"main_slider\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"4bfb75af\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"about-us\"},\"elements\":[{\"id\":\"6c35a8b5\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"77c86b90\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"1a3c8d45\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"73e4c303\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara.jpg\",\"id\":1242,\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"align\":\"right\",\"width\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"space\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"height\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"435943a0\",\"elType\":\"widget\",\"settings\":{\"chose_style\":\"style-two\",\"content_caption\":\"Hakk\\u0131m\\u0131zda\",\"content_heading\":\"Ankara Ball\\u0131 Elektrik\",\"content_description\":\"Hakk\\u0131m\\u0131zda\",\"colored_title\":\"Ankara Ball\\u0131 Elektrik\",\"orderby\":\"ASC\",\"words_count\":\"7\",\"fact_count\":\"\",\"fact_suffix\":\"\",\"fact_title\":\"\",\"main_image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara.jpg\",\"id\":1242,\"alt\":\"\",\"source\":\"library\"},\"item_description\":\"<p><span style=\\\"vertical-align: inherit;\\\"><span style=\\\"vertical-align: inherit;\\\"><span style=\\\"vertical-align: inherit;\\\"><span style=\\\"vertical-align: inherit;\\\">Sekt\\u00f6rdeki faaliyetlerine 1995 senesinde Ankara ilinde ba\\u015flayan Ankara Ball\\u0131 Elektrik, Ayval\\u0131, Etlik, Ke\\u00e7i\\u00f6ren ilk s\\u0131rada olmak \\u00fczere Ankara ilinde elektrik tesisat\\u0131, elektrik ar\\u0131za bak\\u0131m\\u0131, uydu sistemleri, diyafon sistemleri, kamera sistemleri alanlar\\u0131nda hizmet sunmaktad\\u0131r. Kuruldu\\u011fu g\\u00fcnden g\\u00fcn\\u00fcm\\u00fcze nitelikli malzeme ve i\\u015f\\u00e7ilik \\u00f6ncelikli \\u00e7al\\u0131\\u015fan Ankara Palaz Elektrik firmas\\u0131 olarak m\\u00fc\\u015fteri memnuniyetini her zaman ilk planda tutmaktay\\u0131z. Ankara elektrik\\u00e7i i\\u015f ilanlar\\u0131 yard\\u0131m\\u0131 ile bizlere 7\\/24 ula\\u015fabilirsiniz. Ay\\u0131rca elektirik\\u00e7i Ankara \\u00c7ankaya ya da Ankara K\\u0131z\\u0131lay Elektirik\\u00e7i firmas\\u0131 araman\\u0131za gerek kalmadan ihtiya\\u00e7lar\\u0131n\\u0131za \\u00e7\\u00f6z\\u00fcm \\u00fcretebiliyoruz. K\\u0131saca Ankara elektrik tamircisi araman\\u0131za gerek kalmadan Ball\\u0131 Elektrik olarak t\\u00fcm elektrik ar\\u0131zalar\\u0131n\\u0131z\\u0131 profesyonel ekibimiz ile \\u00e7\\u00f6z\\u00fcyoruz.<\\/span><\\/span><\\/span><\\/span><\\/p>\",\"select_category\":\"0\",\"_margin\":{\"unit\":\"px\",\"top\":\"-95\",\"right\":\"-95\",\"bottom\":\"-95\",\"left\":\"-95\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"about_us_intro\"},{\"id\":\"1b391915\",\"elType\":\"widget\",\"settings\":{\"space\":{\"unit\":\"px\",\"size\":53,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"spacer\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"368d72a2\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"facts-count\"},\"elements\":[{\"id\":\"6bcd7501\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"7bc42715\",\"elType\":\"widget\",\"settings\":{\"list\":[{\"fact_count\":\"26\",\"fact_suffix\":\"+\",\"fact_text\":\"Y\\u0131ll\\u0131k Tecr\\u00fcbe\",\"_id\":\"238e850\"},{\"fact_count\":\"502\",\"fact_suffix\":\"+\",\"fact_text\":\"Tamamlanm\\u0131\\u015f Proje\",\"_id\":\"97b8e5f\"},{\"fact_count\":\"120\",\"fact_suffix\":\"+\",\"fact_text\":\"G\\u00fcvenlik Kameras\\u0131\",\"_id\":\"f5612c8\"},{\"fact_count\":\"12\",\"fact_suffix\":\"+\",\"fact_text\":\"Devam Eden Proje\",\"_id\":\"1186dce\"}]},\"elements\":[],\"widgetType\":\"facts-count\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"406a1d78\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"services\"},\"elements\":[{\"id\":\"2eae4372\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"5d85986f\",\"elType\":\"widget\",\"settings\":{\"content_subcaption\":\"Ankara Ball\\u0131 Elektrik\",\"content_heading\":\"Sa\\u011flad\\u0131\\u011f\\u0131m\\u0131z Hizmetler\",\"content_caption\":\"Ball\\u0131 elektrik b\\u00fcnyesinde sunmu\\u015f oldu\\u011fu g\\u00fcvenlik kamera sistemleri kurulum montaj ar\\u0131za onar\\u0131m ve bak\\u0131m\\u0131 , uydu anten kurulumu, uydu kanallar\\u0131 kurulumu, uydu ekipman ve malzemeleri sat\\u0131\\u015f\\u0131 , G\\u00f6r\\u00fcnt\\u00fcl\\u00fc diafon sistemleri kurulumu, de\\u011fi\\u015fimi, yeni binalarda \\u015fartnamelerde bulunan isteklerin kar\\u015f\\u0131lanmas\\u0131 , elektrik ar\\u0131za tesisat \\u00e7ekimi, yeni pano kurulumu gibi hizmetler ile siz de\\u011ferli m\\u00fc\\u015fterilerimize faydal\\u0131 olmaya \\u00e7al\\u0131\\u015fmaktay\\u0131z.\",\"background-image\":{\"url\":\"\",\"id\":\"\"},\"select_category\":\"Featured Services\",\"orderby\":\"ASC\",\"words_count\":\"7\",\"button_text\":\"More Services\",\"show_facts\":\"\",\"list\":[{\"fact_count\":\"12\",\"fact_suffix\":\"+\",\"fact_text\":\"Running Projects\",\"_id\":\"58ac328\"}],\"chose_style\":\"style-two\",\"_background_background\":\"classic\",\"_background_color\":\"#F9F9F9\"},\"elements\":[],\"widgetType\":\"services_grid\"},{\"id\":\"1f6e711a\",\"elType\":\"section\",\"settings\":{\"structure\":\"30\",\"background_background\":\"classic\",\"background_color\":\"#F9F9F9\",\"margin\":{\"unit\":\"px\",\"top\":\"-22\",\"right\":0,\"bottom\":\"-22\",\"left\":0,\"isLinked\":true}},\"elements\":[{\"id\":\"4112c43\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":29.91100000000000136424205265939235687255859375},\"elements\":[{\"id\":\"47d2f9b7\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2020\\/11\\/unnamed.jpg\",\"id\":1283,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"thumbnail_custom_dimension\":{\"width\":\"470\",\"height\":\"530\"},\"title_text\":\"Kamera Kurulum\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nG\\u00fcvenlik kamera \\u0130htiya\\u00e7lar\\u0131n\\u0131z do\\u011frultusunda sizlere en yenilik\\u00e7i alternatifleri sunuyoruz.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true},{\"id\":\"1037b4b1\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":33.3299999999999982946974341757595539093017578125},\"elements\":[{\"id\":\"56ca07f1\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/5cc71fea0f2bc155655370675.jpg\",\"id\":1293,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"thumbnail_custom_dimension\":{\"width\":\"470\",\"height\":\"530\"},\"title_text\":\"Telefon Ankastre\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\n\\u0130nternet altyap\\u0131 hizmetleri ar\\u0131zalar\\u0131nda h\\u0131zl\\u0131 ve g\\u00fcvenilir \\u00e7\\u00f6z\\u00fcm i\\u00e7in bizimle ileti\\u015fime ge\\u00e7in.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true},{\"id\":\"18d90f08\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":36.423000000000001818989403545856475830078125},\"elements\":[{\"id\":\"5e848ac8\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Elektrik-Pana-Montaj-scaled.jpg\",\"id\":1294,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"title_text\":\"Elektrik Pano Montaj\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nElektrik tesisat\\u0131n d\\u00fczg\\u00fcn \\u00e7al\\u0131\\u015fmas\\u0131 i\\u00e7in elektrik pano montaj ba\\u011flant\\u0131lar\\u0131 uzmanlar\\u0131nca yap\\u0131lmal\\u0131d\\u0131r.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"92ea3a9\",\"elType\":\"widget\",\"settings\":{\"space\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"spacer\"},{\"id\":\"71f200ea\",\"elType\":\"section\",\"settings\":{\"structure\":\"30\",\"background_background\":\"classic\",\"background_color\":\"#F9F9F9\",\"margin\":{\"unit\":\"px\",\"top\":\"\",\"right\":0,\"bottom\":\"\",\"left\":0,\"isLinked\":true}},\"elements\":[{\"id\":\"323affa3\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"1edc2859\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Elektrik-Ariza-Tespiti.jpg\",\"id\":1295,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"title_text\":\"Elektrik Ar\\u0131za Tespiti\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nM\\u00fc\\u015fterilerimizin elektrik ar\\u0131za ihtiya\\u00e7lar\\u0131na, en do\\u011fru ve alternatif \\u00e7\\u00f6z\\u00fcmlerle m\\u00fcdahale ediyoruz.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true},{\"id\":\"70cc9ab0\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"c9a4ed7\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Uydu-Anten-Kurulumu-scaled.jpg\",\"id\":1299,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"title_text\":\"Uydu Anten Kurulumu\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nAnkara uyducu aray\\u0131\\u015f\\u0131nda olanlar\\u0131n tercihi Palaz Elektrik, 7\\/24 kesintisiz hizmet veriyor.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true},{\"id\":\"808a27f\",\"elType\":\"column\",\"settings\":{\"_column_size\":33,\"_inline_size\":null},\"elements\":[{\"id\":\"1a76e3d5\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/5cc715cdb5680155655111758.jpg\",\"id\":1303,\"alt\":\"\",\"source\":\"library\"},\"thumbnail_size\":\"large\",\"title_text\":\"\\u0130n\\u015faat Elektrik Projeleri\",\"description_text\":\"<a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\n\\u0130n\\u015faat sekt\\u00f6r\\u00fcnde bir\\u00e7ok elektrik proje i\\u015fini tamamlayan firmam\\u0131z, her ge\\u00e7en g\\u00fcn daha da b\\u00fcy\\u00fcyor.\",\"image_space\":{\"unit\":\"px\",\"size\":17,\"sizes\":[]},\"image_size\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image-box\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"4800898d\",\"elType\":\"widget\",\"settings\":[],\"elements\":[],\"widgetType\":\"spacer\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"45d519f\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"cta\"},\"elements\":[{\"id\":\"4dc2a41d\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"76b0c340\",\"elType\":\"widget\",\"settings\":{\"element_title\":\"Talepleriniz \\u0130\\u00e7in Bizimle \\u0130leti\\u015fime Ge\\u00e7ebilirsiniz.\",\"element_caption\":\"Taleplerinize Dilerseniz \\u0130leti\\u015fim Sayfam\\u0131zdan veya ofisimizde kahvemizi i\\u00e7erken yard\\u0131mc\\u0131 olabiliriz.\",\"button_text\":\"\\u0130LET\\u0130\\u015e\\u0130M\",\"button_url\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/iletisim\",\"is_external\":false,\"nofollow\":false,\"custom_attributes\":\"\"},\"background-image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/elektrik-piyasasi-istatistiksel-analizi-03-12-2019.jpg\",\"id\":1255,\"alt\":\"\",\"source\":\"library\"}},\"elements\":[],\"widgetType\":\"cta-simple\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"62b10c9c\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"blog\"},\"elements\":[{\"id\":\"42c847c1\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"1f7f7f10\",\"elType\":\"widget\",\"settings\":{\"content_caption\":\"Blog Yaz\\u0131lar\\u0131m\\u0131z\",\"content_heading\":\"Son Makaleler\",\"words_count\":\"10\",\"button_text\":\"Daha Fazlas\\u0131\",\"select_category\":\"0\",\"posts_count\":6,\"button_url\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/blog\",\"is_external\":false,\"nofollow\":false,\"custom_attributes\":\"\"}},\"elements\":[],\"widgetType\":\"blog_grid\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `nqcpo_postmeta` VALUES("3008", "1328", "_elementor_controls_usage", "a:11:{s:11:\"main_slider\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:2:{s:4:\"list\";i:1;s:11:\"chose_style\";i:1;}}}}s:6:\"column\";a:3:{s:5:\"count\";i:13;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:6:\"layout\";a:1:{s:12:\"_inline_size\";i:13;}}}}s:7:\"section\";a:3:{s:5:\"count\";i:9;s:15:\"control_percent\";i:1;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:4:{s:6:\"layout\";i:6;s:3:\"gap\";i:6;s:15:\"stretch_section\";i:6;s:6:\"_title\";i:6;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:2;}}s:5:\"style\";a:1:{s:18:\"section_background\";a:2:{s:21:\"background_background\";i:2;s:16:\"background_color\";i:2;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:1:{s:6:\"margin\";i:2;}}}}s:5:\"image\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:3:{s:5:\"image\";i:1;s:10:\"image_size\";i:1;s:5:\"align\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:3:{s:5:\"width\";i:1;s:5:\"space\";i:1;s:6:\"height\";i:1;}}}}s:14:\"about_us_intro\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:6;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:13:{s:11:\"chose_style\";i:1;s:15:\"content_caption\";i:1;s:15:\"content_heading\";i:1;s:19:\"content_description\";i:1;s:13:\"colored_title\";i:1;s:7:\"orderby\";i:1;s:11:\"words_count\";i:1;s:10:\"fact_count\";i:1;s:11:\"fact_suffix\";i:1;s:10:\"fact_title\";i:1;s:10:\"main_image\";i:1;s:16:\"item_description\";i:1;s:15:\"select_category\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:1;}}}}s:6:\"spacer\";a:3:{s:5:\"count\";i:3;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_spacer\";a:1:{s:5:\"space\";i:2;}}}}s:11:\"facts-count\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:4:\"list\";i:1;}}}}s:13:\"services_grid\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:5;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:10:{s:18:\"content_subcaption\";i:1;s:15:\"content_heading\";i:1;s:15:\"content_caption\";i:1;s:16:\"background-image\";i:1;s:15:\"select_category\";i:1;s:7:\"orderby\";i:1;s:11:\"words_count\";i:1;s:10:\"show_facts\";i:1;s:4:\"list\";i:1;s:11:\"chose_style\";i:1;}}s:8:\"advanced\";a:1:{s:19:\"_section_background\";a:2:{s:22:\"_background_background\";i:1;s:17:\"_background_color\";i:1;}}}}s:9:\"image-box\";a:3:{s:5:\"count\";i:6;s:15:\"control_percent\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:5:{s:5:\"image\";i:6;s:14:\"thumbnail_size\";i:6;s:26:\"thumbnail_custom_dimension\";i:2;s:10:\"title_text\";i:6;s:16:\"description_text\";i:6;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:2:{s:11:\"image_space\";i:6;s:10:\"image_size\";i:6;}}}}s:10:\"cta-simple\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:2;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:5:{s:13:\"element_title\";i:1;s:15:\"element_caption\";i:1;s:11:\"button_text\";i:1;s:10:\"button_url\";i:1;s:16:\"background-image\";i:1;}}}}s:9:\"blog_grid\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:3;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:7:{s:15:\"content_caption\";i:1;s:15:\"content_heading\";i:1;s:11:\"words_count\";i:1;s:11:\"button_text\";i:1;s:15:\"select_category\";i:1;s:11:\"posts_count\";i:1;s:10:\"button_url\";i:1;}}}}}");
INSERT INTO `nqcpo_postmeta` VALUES("3025", "395", "_elementor_controls_usage", "a:7:{s:13:\"services_grid\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:5;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:10:{s:18:\"content_subcaption\";i:1;s:15:\"content_heading\";i:1;s:15:\"content_caption\";i:1;s:16:\"background-image\";i:1;s:15:\"select_category\";i:1;s:7:\"orderby\";i:1;s:11:\"words_count\";i:1;s:10:\"show_facts\";i:1;s:4:\"list\";i:1;s:11:\"chose_style\";i:1;}}s:8:\"advanced\";a:1:{s:19:\"_section_background\";a:2:{s:22:\"_background_background\";i:1;s:17:\"_background_color\";i:1;}}}}s:9:\"image-box\";a:3:{s:5:\"count\";i:6;s:15:\"control_percent\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:5:{s:5:\"image\";i:6;s:14:\"thumbnail_size\";i:6;s:26:\"thumbnail_custom_dimension\";i:2;s:10:\"title_text\";i:6;s:16:\"description_text\";i:6;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:2:{s:11:\"image_space\";i:6;s:10:\"image_size\";i:6;}}}}s:6:\"column\";a:3:{s:5:\"count\";i:9;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:6:\"layout\";a:1:{s:12:\"_inline_size\";i:9;}}}}s:7:\"section\";a:3:{s:5:\"count\";i:5;s:15:\"control_percent\";i:1;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:17:\"section_structure\";a:1:{s:9:\"structure\";i:2;}s:14:\"section_layout\";a:4:{s:6:\"layout\";i:3;s:3:\"gap\";i:3;s:15:\"stretch_section\";i:3;s:6:\"_title\";i:3;}}s:5:\"style\";a:1:{s:18:\"section_background\";a:2:{s:21:\"background_background\";i:2;s:16:\"background_color\";i:2;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:1:{s:6:\"margin\";i:2;}}}}s:6:\"spacer\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_spacer\";a:1:{s:5:\"space\";i:1;}}}}s:11:\"facts-count\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:4:\"list\";i:1;}}}}s:10:\"cta-simple\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:2;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:5:{s:13:\"element_title\";i:1;s:15:\"element_caption\";i:1;s:11:\"button_text\";i:1;s:10:\"button_url\";i:1;s:16:\"background-image\";i:1;}}}}}");
INSERT INTO `nqcpo_postmeta` VALUES("3028", "1335", "_wp_attached_file", "2021/08/balli-Elektrik-logo-footer.png");
INSERT INTO `nqcpo_postmeta` VALUES("3029", "1335", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1886;s:6:\"height\";i:527;s:4:\"file\";s:38:\"2021/08/balli-Elektrik-logo-footer.png\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"balli-Elektrik-logo-footer-300x84.png\";s:5:\"width\";i:300;s:6:\"height\";i:84;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"balli-Elektrik-logo-footer-1024x286.png\";s:5:\"width\";i:1024;s:6:\"height\";i:286;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"balli-Elektrik-logo-footer-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:38:\"balli-Elektrik-logo-footer-768x215.png\";s:5:\"width\";i:768;s:6:\"height\";i:215;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:39:\"balli-Elektrik-logo-footer-1536x429.png\";s:5:\"width\";i:1536;s:6:\"height\";i:429;s:9:\"mime-type\";s:9:\"image/png\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:38:\"balli-Elektrik-logo-footer-770x470.png\";s:5:\"width\";i:770;s:6:\"height\";i:470;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:38:\"balli-Elektrik-logo-footer-470x527.png\";s:5:\"width\";i:470;s:6:\"height\";i:527;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("3053", "1339", "_wp_attached_file", "2021/08/bigstock-Lightbulb-6256753-scaled.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("3054", "1339", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1920;s:4:\"file\";s:45:\"2021/08/bigstock-Lightbulb-6256753-scaled.jpg\";s:5:\"sizes\";a:8:{s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"bigstock-Lightbulb-6256753-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"bigstock-Lightbulb-6256753-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"bigstock-Lightbulb-6256753-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:38:\"bigstock-Lightbulb-6256753-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:40:\"bigstock-Lightbulb-6256753-1536x1152.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1152;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:40:\"bigstock-Lightbulb-6256753-2048x1536.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:38:\"bigstock-Lightbulb-6256753-770x470.jpg\";s:5:\"width\";i:770;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:38:\"bigstock-Lightbulb-6256753-470x530.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:530;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:30:\"bigstock-Lightbulb-6256753.jpg\";}");
INSERT INTO `nqcpo_postmeta` VALUES("3079", "413", "_elementor_controls_usage", "a:3:{s:10:\"faqs-block\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:2;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"content_section\";a:4:{s:16:\"heading_subtitle\";i:1;s:13:\"heading_title\";i:1;s:4:\"list\";i:1;s:8:\"bg-image\";i:1;}}}}s:6:\"column\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:6:\"layout\";a:1:{s:12:\"_inline_size\";i:1;}}}}s:7:\"section\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:1;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:14:\"section_layout\";a:3:{s:6:\"layout\";i:1;s:3:\"gap\";i:1;s:15:\"stretch_section\";i:1;}}}}}");
INSERT INTO `nqcpo_postmeta` VALUES("3080", "219", "_edit_lock", "1771817481:1");
INSERT INTO `nqcpo_postmeta` VALUES("3081", "219", "_edit_last", "1");
INSERT INTO `nqcpo_postmeta` VALUES("3084", "219", "_wp_old_slug", "models-oem-solution-simul-corporation-2020");
INSERT INTO `nqcpo_postmeta` VALUES("3085", "1346", "_wp_attached_file", "2020/11/5ccf0d116956f155707316957.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("3086", "1346", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1600;s:6:\"height\";i:900;s:4:\"file\";s:37:\"2020/11/5ccf0d116956f155707316957.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"5ccf0d116956f155707316957-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:38:\"5ccf0d116956f155707316957-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"5ccf0d116956f155707316957-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"5ccf0d116956f155707316957-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:38:\"5ccf0d116956f155707316957-1536x864.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:37:\"5ccf0d116956f155707316957-770x470.jpg\";s:5:\"width\";i:770;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:37:\"5ccf0d116956f155707316957-470x530.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:530;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("3087", "1346", "_wp_attachment_image_alt", "Elektrik Nedir?");
INSERT INTO `nqcpo_postmeta` VALUES("3090", "218", "_edit_lock", "1629242037:1");
INSERT INTO `nqcpo_postmeta` VALUES("3091", "218", "_edit_last", "1");
INSERT INTO `nqcpo_postmeta` VALUES("3094", "218", "_wp_old_slug", "models-oem-solution-simul-corporation-2021");
INSERT INTO `nqcpo_postmeta` VALUES("3095", "1348", "_wp_attached_file", "2020/11/Elektrik-Nasil-Olusur-ve-Uretilir.jpg");
INSERT INTO `nqcpo_postmeta` VALUES("3096", "1348", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:810;s:6:\"height\";i:458;s:4:\"file\";s:45:\"2020/11/Elektrik-Nasil-Olusur-ve-Uretilir.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:45:\"Elektrik-Nasil-Olusur-ve-Uretilir-300x170.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:45:\"Elektrik-Nasil-Olusur-ve-Uretilir-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:45:\"Elektrik-Nasil-Olusur-ve-Uretilir-768x434.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:434;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"kriate-post-detail\";a:4:{s:4:\"file\";s:45:\"Elektrik-Nasil-Olusur-ve-Uretilir-770x458.jpg\";s:5:\"width\";i:770;s:6:\"height\";i:458;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"kriate-project-detail\";a:4:{s:4:\"file\";s:45:\"Elektrik-Nasil-Olusur-ve-Uretilir-470x458.jpg\";s:5:\"width\";i:470;s:6:\"height\";i:458;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("3099", "206", "_edit_lock", "1629242058:1");
INSERT INTO `nqcpo_postmeta` VALUES("3100", "206", "_edit_last", "1");
INSERT INTO `nqcpo_postmeta` VALUES("3103", "206", "_wp_old_slug", "models-oem-solution-simul-corporation");
INSERT INTO `nqcpo_postmeta` VALUES("3134", "1356", "_elementor_edit_mode", "builder");
INSERT INTO `nqcpo_postmeta` VALUES("3135", "1356", "_elementor_template_type", "page");
INSERT INTO `nqcpo_postmeta` VALUES("3136", "1356", "_elementor_version", "3.4.0");
INSERT INTO `nqcpo_postmeta` VALUES("3140", "1356", "_wp_page_template", "default");
INSERT INTO `nqcpo_postmeta` VALUES("3141", "1356", "_elementor_data", "[{\"id\":\"5bcbe2f8\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"about-us\"},\"elements\":[{\"id\":\"743170ea\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"1059760\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"e8d2654\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"384f9e08\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara.jpg\",\"id\":1242,\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"align\":\"right\",\"width\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"space\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"height\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"64229941\",\"elType\":\"section\",\"settings\":{\"structure\":\"20\"},\"elements\":[{\"id\":\"55dcda42\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":50},\"elements\":[{\"id\":\"69b3919a\",\"elType\":\"widget\",\"settings\":{\"title\":\"Hakk\\u0131m\\u0131zda\",\"title_color\":\"#000000\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Poppins\",\"typography_font_weight\":\"400\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"29f1b9a5\",\"elType\":\"widget\",\"settings\":{\"title\":\"Ankara Ball\\u0131 Elektrik\",\"title_color\":\"#FF5E15\",\"typography_typography\":\"custom\",\"typography_font_family\":\"Poppins\",\"typography_font_weight\":\"500\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"4f37221b\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p><span style=\\\"vertical-align: inherit;\\\">Sekt\\u00f6rdeki faaliyetlerine 1995 senesinde Ankara ilinde ba\\u015flayan Ankara Ball\\u0131 Elektrik, Ayval\\u0131, Etlik, Ke\\u00e7i\\u00f6ren ilk s\\u0131rada olmak \\u00fczere Ankara ilinde elektrik tesisat\\u0131, elektrik ar\\u0131za bak\\u0131m\\u0131, uydu sistemleri, diyafon sistemleri, kamera sistemleri alanlar\\u0131nda hizmet sunmaktad\\u0131r. Kuruldu\\u011fu g\\u00fcnden g\\u00fcn\\u00fcm\\u00fcze nitelikli malzeme ve i\\u015f\\u00e7ilik \\u00f6ncelikli \\u00e7al\\u0131\\u015fan Ankara Ball\\u0131 Elektrik firmas\\u0131 olarak m\\u00fc\\u015fteri memnuniyetini her zaman ilk planda tutmaktay\\u0131z. Ankara elektrik\\u00e7i i\\u015f ilanlar\\u0131 yard\\u0131m\\u0131 ile bizlere 7\\/24 ula\\u015fabilirsiniz. Ay\\u0131rca elektrik\\u00e7i Ankara \\u00c7ankaya ya da Ankara K\\u0131z\\u0131lay Elektrik\\u00e7i firmas\\u0131 araman\\u0131za gerek kalmadan ihtiya\\u00e7lar\\u0131n\\u0131za \\u00e7\\u00f6z\\u00fcm \\u00fcretebiliyoruz. K\\u0131saca Ankara elektrik tamircisi araman\\u0131za gerek kalmadan Ball\\u0131 Elektrik olarak t\\u00fcm elektrik ar\\u0131zalar\\u0131n\\u0131z\\u0131 profesyonel ekibimiz ile \\u00e7\\u00f6z\\u00fcyoruz.<\\/span><\\/p><p>Y\\u0131llar\\u0131n\\u00a0verdi\\u011fi\\u00a0tecr\\u00fcbeyle\\u00a0sizlere\\u00a0hizmet sunan\\u00a0uzman\\u00a0ekibimiz, do\\u011fru malzeme, do\\u011fru ekipman ve\\u00a0nitelikli\\u00a0i\\u015f\\u00e7ilik\\u00a0anlay\\u0131\\u015f\\u0131 ile\\u00a0\\u00e7al\\u0131\\u015fmakta ve sizin istekleriniz\\u00a0do\\u011frultusunda h\\u0131zl\\u0131 \\u00e7\\u00f6z\\u00fcmler \\u00fcretmektedir.<br \\/><br \\/>Ball\\u0131 Ke\\u00e7i\\u00f6ren elektrik\\u00e7i 7\\/24 365 g\\u00fcn hizmetinizdeyiz. Ke\\u00e7i\\u00f6ren elektrik i\\u015flerinizi Ball\\u0131 Elektrik h\\u0131zl\\u0131\\u00a0bir bi\\u00e7imde\\u00a0\\u00e7\\u00f6z\\u00fcme ula\\u015ft\\u0131r\\u0131yoruz. Ayr\\u0131ca Ke\\u00e7i\\u00f6ren uydu \\u00e7\\u00f6z\\u00fcmleriyle de piyasaya liderdik ediyoruz. Ankara elektrik\\u00e7i firmalar\\u0131 aras\\u0131nda Ball\\u0131 Elektrik olarak m\\u00fc\\u015fterilerimize\\u00a0nitelikli\\u00a0hizmet sunmaya\\u00a0devam etmekteyiz. Ayr\\u0131ca Etlik elektrik\\u00e7i, Aycal\\u0131 elektrik\\u00e7i olarak da\\u00a0bize\\u00a0ula\\u015fabilirsiniz.\\u00a0<\\/p>\",\"column_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true},{\"id\":\"d20be30\",\"elType\":\"column\",\"settings\":{\"_column_size\":50,\"_inline_size\":49.9140000000000014779288903810083866119384765625},\"elements\":[{\"id\":\"113c3c9d\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara.jpg\",\"id\":1242,\"alt\":\"Ankara Ball\\u0131 Elektrik\",\"source\":\"library\"}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"571727fa\",\"elType\":\"section\",\"settings\":[],\"elements\":[{\"id\":\"6365aaeb\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"7d90cc18\",\"elType\":\"widget\",\"settings\":{\"editor\":\"<p>Ankara b\\u00f6lgesinde t\\u00fcm il\\u00e7elere\\u00a0hizmet vermekteyiz. Uygun fiyata hizmet sunarak m\\u00fc\\u015fterilerimizi memnun ediyoruz. Her zaman\\u00a0m\\u00fc\\u015fteri merkezli\\u00a0hizmet vermekteyiz. Ayval\\u0131 Mahallesi Ayval\\u0131 caddesi\\u00a0\\u00fcst\\u00fcnde\\u00a0bulunan firmam\\u0131za gelerek elektrik i\\u015fleriniz i\\u00e7in teklif alabilir ve\\u00a0piyasada bulunan\\u00a0di\\u011fer elektrik\\u00e7i\\u00a0\\u015firketleri ile\\u00a0k\\u0131yaslama yapabilirsiniz. B\\u00f6ylece kalitemizden ve\\u00a0uygun maliyetli\\u00a0elektrik, uydu, diafon, diyafon gibi hizmetlerimizden emin olabilirsiniz.<br \\/><br \\/>Sa\\u011flad\\u0131\\u011f\\u0131m\\u0131z hizmetlerden baz\\u0131lar\\u0131 ;<br \\/><br \\/>- Elektrik ve elektronik malzeme sat\\u0131\\u015f\\u0131,<br \\/><br \\/>- Uydu anten kurulumu,<br \\/><br \\/>- Elektrik tesisat\\u0131,<br \\/><br \\/>- G\\u00f6r\\u00fcnt\\u00fcl\\u00fc Diafon sistemleri,<br \\/><br \\/>- G\\u00fcvenlik Kamera Sitemleri<br \\/><br \\/>kurulum, montaj , bak\\u0131m ve ar\\u0131zalar\\u0131d\\u0131r.<br \\/><br \\/>En \\u00e7ok hizmet\\u00a0vermi\\u015f oldu\\u011fumuz\\u00a0b\\u00f6lgeler: Ankara Elektrik\\u00e7i, Ke\\u00e7i\\u00f6ren Elektrik\\u00e7i, Etlik Elektrik\\u00e7i, Esertepe Elektrik\\u00e7i, \\u0130ncirli Elektrik\\u00e7i, En yak\\u0131n elektrik\\u00e7i, \\u00c7ankaya Elektrik\\u00e7i, Sancaktepe Elektrik\\u00e7i, Yayla Mahallesi Elektrik\\u00e7i, Y\\u00fckseltepe Elektrik\\u00e7i, Ufuktepe Elektrik\\u00e7i, \\u015eenlik Mahallesi Elektrik\\u00e7i, Ovac\\u0131k Elektrik\\u00e7i, Kar\\u015f\\u0131yaka Elektrik\\u00e7i, Atapark Elektrik\\u00e7i, Ye\\u015filtepe Elektrik\\u00e7i, Yakac\\u0131k Mahallesi Elektrik\\u00e7i, Tepeba\\u015f\\u0131 Elektrik\\u00e7i, \\u015eehit Kubilay Elektrik\\u00e7i, Bas\\u0131nevler Elektrik\\u00e7i, Bademlik Elektrik\\u00e7i, A\\u015fa\\u011f\\u0131 E\\u011flence Elektrik\\u00e7i, Uyan\\u0131\\u015f Mahallesi Elektrik\\u00e7i, \\u015eenyuva Elektrik\\u00e7i, P\\u0131narba\\u015f\\u0131 Elektrik\\u00e7i, Ku\\u015fca\\u011f\\u0131z Elektrik\\u00e7i, Ba\\u011flum Elektrik\\u00e7i, Pursaklar Elektrik\\u00e7i, Bah\\u00e7elievler Elektrik\\u00e7i, K\\u0131z\\u0131lay Elektrik\\u00e7i, Elektrik\\u00e7i Etimesgut, S\\u0131hh\\u0131ye Elektrik\\u00e7i, Ulus Elektrik\\u00e7i, Mamak Elektirk\\u00e7i, Sincan Elektirik\\u00e7i, Yenimahalle Elektrik\\u00e7i<\\/p>\"},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"130354d6\",\"elType\":\"widget\",\"settings\":{\"space\":{\"unit\":\"px\",\"size\":53,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"spacer\"}],\"isInner\":false}],\"isInner\":false},{\"id\":\"1ae917c0\",\"elType\":\"section\",\"settings\":{\"layout\":\"full_width\",\"gap\":\"no\",\"stretch_section\":\"section-stretched\",\"_title\":\"facts-count\"},\"elements\":[{\"id\":\"630ea213\",\"elType\":\"column\",\"settings\":{\"_column_size\":100,\"_inline_size\":null},\"elements\":[{\"id\":\"139ab4c9\",\"elType\":\"widget\",\"settings\":{\"list\":[{\"fact_count\":\"26\",\"fact_suffix\":\"+\",\"fact_text\":\"Y\\u0131ll\\u0131k Tecr\\u00fcbe\",\"_id\":\"238e850\"},{\"fact_count\":\"502\",\"fact_suffix\":\"+\",\"fact_text\":\"Tamamlanm\\u0131\\u015f Proje\",\"_id\":\"97b8e5f\"},{\"fact_count\":\"120\",\"fact_suffix\":\"+\",\"fact_text\":\"G\\u00fcvenlik Kameras\\u0131\",\"_id\":\"f5612c8\"},{\"fact_count\":\"12\",\"fact_suffix\":\"+\",\"fact_text\":\"Devam Eden Proje\",\"_id\":\"1186dce\"}]},\"elements\":[],\"widgetType\":\"facts-count\"}],\"isInner\":false}],\"isInner\":false}]");
INSERT INTO `nqcpo_postmeta` VALUES("3148", "1356", "_elementor_controls_usage", "a:7:{s:5:\"image\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:0;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:3:{s:5:\"image\";i:2;s:10:\"image_size\";i:1;s:5:\"align\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:3:{s:5:\"width\";i:1;s:5:\"space\";i:1;s:6:\"height\";i:1;}}}}s:6:\"column\";a:3:{s:5:\"count\";i:6;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:6:\"layout\";a:1:{s:12:\"_inline_size\";i:6;}}}}s:7:\"section\";a:3:{s:5:\"count\";i:5;s:15:\"control_percent\";i:1;s:8:\"controls\";a:1:{s:6:\"layout\";a:2:{s:17:\"section_structure\";a:1:{s:9:\"structure\";i:1;}s:14:\"section_layout\";a:4:{s:6:\"layout\";i:2;s:3:\"gap\";i:2;s:15:\"stretch_section\";i:2;s:6:\"_title\";i:2;}}}}s:7:\"heading\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_title\";a:1:{s:5:\"title\";i:2;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:4:{s:11:\"title_color\";i:2;s:21:\"typography_typography\";i:2;s:22:\"typography_font_family\";i:2;s:22:\"typography_font_weight\";i:2;}}}}s:11:\"text-editor\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:2:{s:6:\"editor\";i:2;s:10:\"column_gap\";i:1;}}}}s:6:\"spacer\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_spacer\";a:1:{s:5:\"space\";i:1;}}}}s:11:\"facts-count\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:4:\"list\";i:1;}}}}}");
INSERT INTO `nqcpo_postmeta` VALUES("3200", "1169", "_elementor_controls_usage", "a:12:{s:11:\"main_slider\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:2:{s:4:\"list\";i:1;s:11:\"chose_style\";i:1;}}}}s:6:\"column\";a:3:{s:5:\"count\";i:15;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:6:\"layout\";a:1:{s:12:\"_inline_size\";i:15;}}}}s:7:\"section\";a:3:{s:5:\"count\";i:10;s:15:\"control_percent\";i:1;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:4:{s:6:\"layout\";i:6;s:3:\"gap\";i:6;s:15:\"stretch_section\";i:6;s:6:\"_title\";i:6;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:3;}}s:5:\"style\";a:1:{s:18:\"section_background\";a:2:{s:21:\"background_background\";i:2;s:16:\"background_color\";i:2;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:1:{s:6:\"margin\";i:2;}}}}s:5:\"image\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:0;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:3:{s:5:\"image\";i:2;s:10:\"image_size\";i:1;s:5:\"align\";i:1;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:3:{s:5:\"width\";i:1;s:5:\"space\";i:1;s:6:\"height\";i:1;}}}}s:7:\"heading\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_title\";a:1:{s:5:\"title\";i:2;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:4:{s:11:\"title_color\";i:2;s:21:\"typography_typography\";i:2;s:22:\"typography_font_family\";i:2;s:22:\"typography_font_weight\";i:2;}}}}s:11:\"text-editor\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:2:{s:6:\"editor\";i:1;s:10:\"column_gap\";i:1;}}}}s:6:\"spacer\";a:3:{s:5:\"count\";i:3;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_spacer\";a:1:{s:5:\"space\";i:2;}}}}s:11:\"facts-count\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:4:\"list\";i:1;}}}}s:13:\"services_grid\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:5;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:15:\"section_content\";a:10:{s:18:\"content_subcaption\";i:1;s:15:\"content_heading\";i:1;s:15:\"content_caption\";i:1;s:16:\"background-image\";i:1;s:15:\"select_category\";i:1;s:7:\"orderby\";i:1;s:11:\"words_count\";i:1;s:10:\"show_facts\";i:1;s:4:\"list\";i:1;s:11:\"chose_style\";i:1;}}s:8:\"advanced\";a:1:{s:19:\"_section_background\";a:2:{s:22:\"_background_background\";i:1;s:17:\"_background_color\";i:1;}}}}s:9:\"image-box\";a:3:{s:5:\"count\";i:6;s:15:\"control_percent\";i:2;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:5:{s:5:\"image\";i:6;s:14:\"thumbnail_size\";i:6;s:26:\"thumbnail_custom_dimension\";i:2;s:10:\"title_text\";i:6;s:16:\"description_text\";i:6;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:2:{s:11:\"image_space\";i:6;s:10:\"image_size\";i:6;}}}}s:10:\"cta-simple\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:2;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:5:{s:13:\"element_title\";i:1;s:15:\"element_caption\";i:1;s:11:\"button_text\";i:1;s:10:\"button_url\";i:1;s:16:\"background-image\";i:1;}}}}s:9:\"blog_grid\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:3;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:7:{s:15:\"content_caption\";i:1;s:15:\"content_heading\";i:1;s:11:\"words_count\";i:1;s:11:\"button_text\";i:1;s:15:\"select_category\";i:1;s:11:\"posts_count\";i:1;s:10:\"button_url\";i:1;}}}}}");
INSERT INTO `nqcpo_postmeta` VALUES("3227", "436", "_elementor_controls_usage", "a:4:{s:9:\"infoboxes\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:1:{s:4:\"list\";i:1;}}}}s:6:\"column\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:0;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:6:\"layout\";a:1:{s:12:\"_inline_size\";i:2;}}}}s:7:\"section\";a:3:{s:5:\"count\";i:2;s:15:\"control_percent\";i:1;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:14:\"section_layout\";a:3:{s:6:\"layout\";i:2;s:3:\"gap\";i:2;s:15:\"stretch_section\";i:2;}}}}s:16:\"contact_form_map\";a:3:{s:5:\"count\";i:1;s:15:\"control_percent\";i:3;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"section_content\";a:7:{s:12:\"location_lat\";i:1;s:13:\"location_long\";i:1;s:10:\"form_title\";i:1;s:12:\"form_caption\";i:1;s:12:\"social_title\";i:1;s:4:\"list\";i:1;s:14:\"form_shortcode\";i:1;}}}}}");
INSERT INTO `nqcpo_postmeta` VALUES("3236", "476", "popular_post_views_count", "87");
INSERT INTO `nqcpo_postmeta` VALUES("3237", "482", "popular_post_views_count", "71");
INSERT INTO `nqcpo_postmeta` VALUES("3238", "483", "popular_post_views_count", "81");
INSERT INTO `nqcpo_postmeta` VALUES("3239", "479", "popular_post_views_count", "83");
INSERT INTO `nqcpo_postmeta` VALUES("3240", "484", "popular_post_views_count", "83");
INSERT INTO `nqcpo_postmeta` VALUES("3241", "478", "popular_post_views_count", "82");
INSERT INTO `nqcpo_postmeta` VALUES("3242", "474", "popular_post_views_count", "89");
INSERT INTO `nqcpo_postmeta` VALUES("3243", "477", "popular_post_views_count", "81");
INSERT INTO `nqcpo_postmeta` VALUES("3244", "481", "popular_post_views_count", "74");
INSERT INTO `nqcpo_postmeta` VALUES("3257", "173", "popular_post_views_count", "81");
INSERT INTO `nqcpo_postmeta` VALUES("3258", "177", "popular_post_views_count", "77");
INSERT INTO `nqcpo_postmeta` VALUES("3259", "480", "popular_post_views_count", "82");
INSERT INTO `nqcpo_postmeta` VALUES("3260", "178", "popular_post_views_count", "73");
INSERT INTO `nqcpo_postmeta` VALUES("3261", "31", "_hash", "31584e4c8d2f0de1a5a60eb9569b341440c8ff65");
INSERT INTO `nqcpo_postmeta` VALUES("3262", "1172", "_hash", "548f129a586c2f1d30adb5b1a7f235273d6b1836");
INSERT INTO `nqcpo_postmeta` VALUES("12941", "18164", "_wp_attached_file", "2025/07/onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_2.webp");
INSERT INTO `nqcpo_postmeta` VALUES("12942", "18164", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:630;s:4:\"file\";s:56:\"2025/07/onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_2.webp\";s:8:\"filesize\";i:46278;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:56:\"onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_2-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:17886;}s:5:\"large\";a:5:{s:4:\"file\";s:58:\"onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_2-1024x1024.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:84220;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:56:\"onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_2-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7214;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:56:\"onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_2-768x403.webp\";s:5:\"width\";i:768;s:6:\"height\";i:403;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:44104;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:58:\"onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_2-1536x1536.webp\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:146238;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:58:\"onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_2-2048x2048.webp\";s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:209774;}s:18:\"kriate-post-detail\";a:5:{s:4:\"file\";s:56:\"onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_2-770x470.webp\";s:5:\"width\";i:770;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:48412;}s:21:\"kriate-project-detail\";a:5:{s:4:\"file\";s:56:\"onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_2-470x530.webp\";s:5:\"width\";i:470;s:6:\"height\";i:530;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:32794;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("12943", "18165", "_wp_attached_file", "2025/07/onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_1.webp");
INSERT INTO `nqcpo_postmeta` VALUES("12944", "18165", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1024;s:6:\"height\";i:501;s:4:\"file\";s:56:\"2025/07/onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_1.webp\";s:8:\"filesize\";i:65248;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:56:\"onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_1-300x300.webp\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:19346;}s:5:\"large\";a:5:{s:4:\"file\";s:58:\"onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_1-1024x1024.webp\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:93136;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:56:\"onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_1-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:7458;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:56:\"onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_1-768x375.webp\";s:5:\"width\";i:768;s:6:\"height\";i:375;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:47746;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:58:\"onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_1-1536x1536.webp\";s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:157048;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:58:\"onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_1-2048x2048.webp\";s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:221336;}s:18:\"kriate-post-detail\";a:5:{s:4:\"file\";s:56:\"onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_1-770x470.webp\";s:5:\"width\";i:770;s:6:\"height\";i:470;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:58142;}s:21:\"kriate-project-detail\";a:5:{s:4:\"file\";s:56:\"onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_1-470x530.webp\";s:5:\"width\";i:470;s:6:\"height\";i:530;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:35600;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `nqcpo_postmeta` VALUES("19772", "24053", "_wp_attached_file", "2025/08/woocommerce_inputs_plugin.zip");
INSERT INTO `nqcpo_postmeta` VALUES("19773", "24053", "_wp_attachment_context", "upgrader");
INSERT INTO `nqcpo_postmeta` VALUES("24727", "30545", "_wp_attached_file", "2025/09/one_images_user.zip");
INSERT INTO `nqcpo_postmeta` VALUES("24728", "30545", "_wp_attachment_context", "upgrader");
INSERT INTO `nqcpo_postmeta` VALUES("31848", "1235", "_wp_old_date", "2021-08-09");
INSERT INTO `nqcpo_postmeta` VALUES("31849", "1240", "_wp_old_date", "2021-08-09");
INSERT INTO `nqcpo_postmeta` VALUES("31850", "1237", "_wp_old_date", "2021-08-09");
INSERT INTO `nqcpo_postmeta` VALUES("31851", "1236", "_wp_old_date", "2021-08-09");
INSERT INTO `nqcpo_postmeta` VALUES("31852", "1239", "_wp_old_date", "2021-08-09");
INSERT INTO `nqcpo_postmeta` VALUES("31853", "1241", "_wp_old_date", "2021-08-09");
INSERT INTO `nqcpo_postmeta` VALUES("31858", "32", "_elementor_css", "a:6:{s:4:\"time\";i:1771844155;s:5:\"fonts\";a:2:{i:0;s:6:\"Roboto\";i:1;s:11:\"Roboto Slab\";}s:5:\"icons\";a:0:{}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;s:0:\"\";}");
INSERT INTO `nqcpo_postmeta` VALUES("31859", "1169", "_elementor_page_assets", "a:2:{s:7:\"scripts\";a:1:{i:0;s:18:\"elementor-frontend\";}s:6:\"styles\";a:4:{i:0;s:12:\"widget-image\";i:1;s:14:\"widget-heading\";i:2;s:13:\"widget-spacer\";i:3;s:16:\"widget-image-box\";}}");
INSERT INTO `nqcpo_postmeta` VALUES("31860", "1169", "_elementor_css", "a:6:{s:4:\"time\";i:1771844155;s:5:\"fonts\";a:1:{i:0;s:7:\"Poppins\";}s:5:\"icons\";a:0:{}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;s:0:\"\";}");
INSERT INTO `nqcpo_postmeta` VALUES("31861", "1169", "_elementor_element_cache", "{\"timeout\":1771941355,\"value\":{\"content\":\"\\t\\t<section class=\\\"elementor-section elementor-top-section elementor-element elementor-element-2e4aaa77 elementor-section-full_width elementor-section-stretched elementor-section-height-default elementor-section-height-default\\\" data-id=\\\"2e4aaa77\\\" data-element_type=\\\"section\\\" data-e-type=\\\"section\\\" data-settings=\\\"{&quot;stretch_section&quot;:&quot;section-stretched&quot;}\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-container elementor-column-gap-no\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-100 elementor-top-column elementor-element elementor-element-3060fc50\\\" data-id=\\\"3060fc50\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t[elementor-element k=\\\"23310f780a7433516f570b30846f2967\\\" data=\\\"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\\\"]\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/section>\\n\\t\\t\\t\\t<section class=\\\"elementor-section elementor-top-section elementor-element elementor-element-1165d841 elementor-section-full_width elementor-section-stretched elementor-section-height-default elementor-section-height-default\\\" data-id=\\\"1165d841\\\" data-element_type=\\\"section\\\" data-e-type=\\\"section\\\" data-settings=\\\"{&quot;stretch_section&quot;:&quot;section-stretched&quot;}\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-container elementor-column-gap-no\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-100 elementor-top-column elementor-element elementor-element-16081cde\\\" data-id=\\\"16081cde\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t\\t\\t<section class=\\\"elementor-section elementor-inner-section elementor-element elementor-element-27f87ffe elementor-section-boxed elementor-section-height-default elementor-section-height-default\\\" data-id=\\\"27f87ffe\\\" data-element_type=\\\"section\\\" data-e-type=\\\"section\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-container elementor-column-gap-default\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-100 elementor-inner-column elementor-element elementor-element-3d2ec98a\\\" data-id=\\\"3d2ec98a\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-element elementor-element-2a35bc37 elementor-widget elementor-widget-image\\\" data-id=\\\"2a35bc37\\\" data-element_type=\\\"widget\\\" data-e-type=\\\"widget\\\" data-widget_type=\\\"image.default\\\">\\n\\t\\t\\t\\t<div class=\\\"elementor-widget-container\\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<img width=\\\"480\\\" height=\\\"610\\\" src=\\\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara.jpg\\\" class=\\\"attachment-full size-full wp-image-1242\\\" alt=\\\"Ankara Ball\\u0131 Elektrik\\\" srcset=\\\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara.jpg 480w, http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara-236x300.jpg 236w\\\" sizes=\\\"(max-width: 480px) 100vw, 480px\\\" \\/>\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/section>\\n\\t\\t\\t\\t<section class=\\\"elementor-section elementor-inner-section elementor-element elementor-element-696ce6c0 elementor-section-boxed elementor-section-height-default elementor-section-height-default\\\" data-id=\\\"696ce6c0\\\" data-element_type=\\\"section\\\" data-e-type=\\\"section\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-container elementor-column-gap-default\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-50 elementor-inner-column elementor-element elementor-element-32bf8644\\\" data-id=\\\"32bf8644\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-element elementor-element-1e71eeb1 elementor-widget elementor-widget-heading\\\" data-id=\\\"1e71eeb1\\\" data-element_type=\\\"widget\\\" data-e-type=\\\"widget\\\" data-widget_type=\\\"heading.default\\\">\\n\\t\\t\\t\\t<div class=\\\"elementor-widget-container\\\">\\n\\t\\t\\t\\t\\t<h2 class=\\\"elementor-heading-title elementor-size-default\\\">Hakk\\u0131m\\u0131zda<\\/h2>\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<div class=\\\"elementor-element elementor-element-1a0e4b14 elementor-widget elementor-widget-heading\\\" data-id=\\\"1a0e4b14\\\" data-element_type=\\\"widget\\\" data-e-type=\\\"widget\\\" data-widget_type=\\\"heading.default\\\">\\n\\t\\t\\t\\t<div class=\\\"elementor-widget-container\\\">\\n\\t\\t\\t\\t\\t<h2 class=\\\"elementor-heading-title elementor-size-default\\\">Ankara Ball\\u0131 Elektrik<\\/h2>\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t[elementor-element k=\\\"23310f780a7433516f570b30846f2967\\\" data=\\\"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\\\"]\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-50 elementor-inner-column elementor-element elementor-element-2ada152e\\\" data-id=\\\"2ada152e\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-element elementor-element-6e960b6d elementor-widget elementor-widget-image\\\" data-id=\\\"6e960b6d\\\" data-element_type=\\\"widget\\\" data-e-type=\\\"widget\\\" data-widget_type=\\\"image.default\\\">\\n\\t\\t\\t\\t<div class=\\\"elementor-widget-container\\\">\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<img width=\\\"480\\\" height=\\\"610\\\" src=\\\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara.jpg\\\" class=\\\"attachment-large size-large wp-image-1242\\\" alt=\\\"Ankara Ball\\u0131 Elektrik\\\" srcset=\\\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara.jpg 480w, http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Balli-Elektrik-Ankara-236x300.jpg 236w\\\" sizes=\\\"(max-width: 480px) 100vw, 480px\\\" \\/>\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/section>\\n\\t\\t\\t\\t<div class=\\\"elementor-element elementor-element-448b4c5e elementor-widget elementor-widget-spacer\\\" data-id=\\\"448b4c5e\\\" data-element_type=\\\"widget\\\" data-e-type=\\\"widget\\\" data-widget_type=\\\"spacer.default\\\">\\n\\t\\t\\t\\t<div class=\\\"elementor-widget-container\\\">\\n\\t\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-spacer\\\">\\n\\t\\t\\t<div class=\\\"elementor-spacer-inner\\\"><\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/section>\\n\\t\\t\\t\\t<section class=\\\"elementor-section elementor-top-section elementor-element elementor-element-41c5beaa elementor-section-full_width elementor-section-stretched elementor-section-height-default elementor-section-height-default\\\" data-id=\\\"41c5beaa\\\" data-element_type=\\\"section\\\" data-e-type=\\\"section\\\" data-settings=\\\"{&quot;stretch_section&quot;:&quot;section-stretched&quot;}\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-container elementor-column-gap-no\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-100 elementor-top-column elementor-element elementor-element-422ec332\\\" data-id=\\\"422ec332\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t[elementor-element k=\\\"23310f780a7433516f570b30846f2967\\\" data=\\\"eyJpZCI6Ijc4NDY0YmYiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJsaXN0IjpbeyJmYWN0X2NvdW50IjoiMjYiLCJmYWN0X3N1ZmZpeCI6IisiLCJmYWN0X3RleHQiOiJZXHUwMTMxbGxcdTAxMzFrIFRlY3JcdTAwZmNiZSIsIl9pZCI6IjIzOGU4NTAifSx7ImZhY3RfY291bnQiOiI1MDIiLCJmYWN0X3N1ZmZpeCI6IisiLCJmYWN0X3RleHQiOiJUYW1hbWxhbm1cdTAxMzFcdTAxNWYgUHJvamUiLCJfaWQiOiI5N2I4ZTVmIn0seyJmYWN0X2NvdW50IjoiMTIwIiwiZmFjdF9zdWZmaXgiOiIrIiwiZmFjdF90ZXh0IjoiR1x1MDBmY3ZlbmxpayBLYW1lcmFzXHUwMTMxIiwiX2lkIjoiZjU2MTJjOCJ9LHsiZmFjdF9jb3VudCI6IjEyIiwiZmFjdF9zdWZmaXgiOiIrIiwiZmFjdF90ZXh0IjoiRGV2YW0gRWRlbiBQcm9qZSIsIl9pZCI6IjExODZkY2UifV19LCJlbGVtZW50cyI6W10sIndpZGdldFR5cGUiOiJmYWN0cy1jb3VudCJ9\\\"]\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/section>\\n\\t\\t\\t\\t<section class=\\\"elementor-section elementor-top-section elementor-element elementor-element-372461e elementor-section-full_width elementor-section-stretched elementor-section-height-default elementor-section-height-default\\\" data-id=\\\"372461e\\\" data-element_type=\\\"section\\\" data-e-type=\\\"section\\\" data-settings=\\\"{&quot;stretch_section&quot;:&quot;section-stretched&quot;}\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-container elementor-column-gap-no\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-100 elementor-top-column elementor-element elementor-element-27d47ea6\\\" data-id=\\\"27d47ea6\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t[elementor-element k=\\\"23310f780a7433516f570b30846f2967\\\" data=\\\"eyJpZCI6IjRhOTVhNDciLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJjb250ZW50X3N1YmNhcHRpb24iOiJBbmthcmEgQmFsbFx1MDEzMSBFbGVrdHJpayIsImNvbnRlbnRfaGVhZGluZyI6IlNhXHUwMTFmbGFkXHUwMTMxXHUwMTFmXHUwMTMxbVx1MDEzMXogSGl6bWV0bGVyIiwiY29udGVudF9jYXB0aW9uIjoiQmFsbFx1MDEzMSBlbGVrdHJpayBiXHUwMGZjbnllc2luZGUgc3VubXVcdTAxNWYgb2xkdVx1MDExZnUgZ1x1MDBmY3ZlbmxpayBrYW1lcmEgc2lzdGVtbGVyaSBrdXJ1bHVtIG1vbnRhaiBhclx1MDEzMXphIG9uYXJcdTAxMzFtIHZlIGJha1x1MDEzMW1cdTAxMzEgLCB1eWR1IGFudGVuIGt1cnVsdW11LCB1eWR1IGthbmFsbGFyXHUwMTMxIGt1cnVsdW11LCB1eWR1IGVraXBtYW4gdmUgbWFsemVtZWxlcmkgc2F0XHUwMTMxXHUwMTVmXHUwMTMxICwgR1x1MDBmNnJcdTAwZmNudFx1MDBmY2xcdTAwZmMgZGlhZm9uIHNpc3RlbWxlcmkga3VydWx1bXUsIGRlXHUwMTFmaVx1MDE1ZmltaSwgeWVuaSBiaW5hbGFyZGEgXHUwMTVmYXJ0bmFtZWxlcmRlIGJ1bHVuYW4gaXN0ZWtsZXJpbiBrYXJcdTAxNWZcdTAxMzFsYW5tYXNcdTAxMzEgLCBlbGVrdHJpayBhclx1MDEzMXphIHRlc2lzYXQgXHUwMGU3ZWtpbWksIHllbmkgcGFubyBrdXJ1bHVtdSBnaWJpIGhpem1ldGxlciBpbGUgc2l6IGRlXHUwMTFmZXJsaSBtXHUwMGZjXHUwMTVmdGVyaWxlcmltaXplIGZheWRhbFx1MDEzMSBvbG1heWEgXHUwMGU3YWxcdTAxMzFcdTAxNWZtYWt0YXlcdTAxMzF6LiIsImJhY2tncm91bmQtaW1hZ2UiOnsidXJsIjoiIiwiaWQiOiIifSwic2VsZWN0X2NhdGVnb3J5IjoiRmVhdHVyZWQgU2VydmljZXMiLCJvcmRlcmJ5IjoiQVNDIiwid29yZHNfY291bnQiOiI3IiwiYnV0dG9uX3RleHQiOiJNb3JlIFNlcnZpY2VzIiwic2hvd19mYWN0cyI6IiIsImxpc3QiOlt7ImZhY3RfY291bnQiOiIxMiIsImZhY3Rfc3VmZml4IjoiKyIsImZhY3RfdGV4dCI6IlJ1bm5pbmcgUHJvamVjdHMiLCJfaWQiOiI1OGFjMzI4In1dLCJjaG9zZV9zdHlsZSI6InN0eWxlLXR3byIsIl9iYWNrZ3JvdW5kX2JhY2tncm91bmQiOiJjbGFzc2ljIiwiX2JhY2tncm91bmRfY29sb3IiOiIjRjlGOUY5In0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6InNlcnZpY2VzX2dyaWQifQ==\\\"]\\t\\t<section class=\\\"elementor-section elementor-inner-section elementor-element elementor-element-47e4865 elementor-section-boxed elementor-section-height-default elementor-section-height-default\\\" data-id=\\\"47e4865\\\" data-element_type=\\\"section\\\" data-e-type=\\\"section\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-container elementor-column-gap-default\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-33 elementor-inner-column elementor-element elementor-element-5413161c\\\" data-id=\\\"5413161c\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-element elementor-element-5d03b904 elementor-position-top elementor-widget elementor-widget-image-box\\\" data-id=\\\"5d03b904\\\" data-element_type=\\\"widget\\\" data-e-type=\\\"widget\\\" data-widget_type=\\\"image-box.default\\\">\\n\\t\\t\\t\\t<div class=\\\"elementor-widget-container\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-image-box-wrapper\\\"><figure class=\\\"elementor-image-box-img\\\"><img width=\\\"512\\\" height=\\\"375\\\" src=\\\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2020\\/11\\/unnamed.jpg\\\" class=\\\"attachment-large size-large wp-image-1283\\\" alt=\\\"\\\" \\/><\\/figure><div class=\\\"elementor-image-box-content\\\"><h3 class=\\\"elementor-image-box-title\\\">Kamera Kurulum<\\/h3><p class=\\\"elementor-image-box-description\\\"><a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nG\\u00fcvenlik kamera \\u0130htiya\\u00e7lar\\u0131n\\u0131z do\\u011frultusunda sizlere en yenilik\\u00e7i alternatifleri sunuyoruz.<\\/p><\\/div><\\/div>\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-33 elementor-inner-column elementor-element elementor-element-5bb3b1e0\\\" data-id=\\\"5bb3b1e0\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-element elementor-element-36d2605f elementor-position-top elementor-widget elementor-widget-image-box\\\" data-id=\\\"36d2605f\\\" data-element_type=\\\"widget\\\" data-e-type=\\\"widget\\\" data-widget_type=\\\"image-box.default\\\">\\n\\t\\t\\t\\t<div class=\\\"elementor-widget-container\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-image-box-wrapper\\\"><figure class=\\\"elementor-image-box-img\\\"><img width=\\\"500\\\" height=\\\"334\\\" src=\\\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/5cc71fea0f2bc155655370675.jpg\\\" class=\\\"attachment-large size-large wp-image-1293\\\" alt=\\\"\\\" \\/><\\/figure><div class=\\\"elementor-image-box-content\\\"><h3 class=\\\"elementor-image-box-title\\\">Telefon Ankastre<\\/h3><p class=\\\"elementor-image-box-description\\\"><a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\n\\u0130nternet altyap\\u0131 hizmetleri ar\\u0131zalar\\u0131nda h\\u0131zl\\u0131 ve g\\u00fcvenilir \\u00e7\\u00f6z\\u00fcm i\\u00e7in bizimle ileti\\u015fime ge\\u00e7in.<\\/p><\\/div><\\/div>\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-33 elementor-inner-column elementor-element elementor-element-5e9cc1e6\\\" data-id=\\\"5e9cc1e6\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-element elementor-element-3b436320 elementor-position-top elementor-widget elementor-widget-image-box\\\" data-id=\\\"3b436320\\\" data-element_type=\\\"widget\\\" data-e-type=\\\"widget\\\" data-widget_type=\\\"image-box.default\\\">\\n\\t\\t\\t\\t<div class=\\\"elementor-widget-container\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-image-box-wrapper\\\"><figure class=\\\"elementor-image-box-img\\\"><img width=\\\"1024\\\" height=\\\"683\\\" src=\\\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Elektrik-Pana-Montaj-1024x683.jpg\\\" class=\\\"attachment-large size-large wp-image-1294\\\" alt=\\\"\\\" \\/><\\/figure><div class=\\\"elementor-image-box-content\\\"><h3 class=\\\"elementor-image-box-title\\\">Elektrik Pano Montaj<\\/h3><p class=\\\"elementor-image-box-description\\\"><a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nElektrik tesisat\\u0131n d\\u00fczg\\u00fcn \\u00e7al\\u0131\\u015fmas\\u0131 i\\u00e7in elektrik pano montaj ba\\u011flant\\u0131lar\\u0131 uzmanlar\\u0131nca yap\\u0131lmal\\u0131d\\u0131r.<\\/p><\\/div><\\/div>\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/section>\\n\\t\\t\\t\\t<div class=\\\"elementor-element elementor-element-1e817fb1 elementor-widget elementor-widget-spacer\\\" data-id=\\\"1e817fb1\\\" data-element_type=\\\"widget\\\" data-e-type=\\\"widget\\\" data-widget_type=\\\"spacer.default\\\">\\n\\t\\t\\t\\t<div class=\\\"elementor-widget-container\\\">\\n\\t\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-spacer\\\">\\n\\t\\t\\t<div class=\\\"elementor-spacer-inner\\\"><\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<section class=\\\"elementor-section elementor-inner-section elementor-element elementor-element-d4bb226 elementor-section-boxed elementor-section-height-default elementor-section-height-default\\\" data-id=\\\"d4bb226\\\" data-element_type=\\\"section\\\" data-e-type=\\\"section\\\" data-settings=\\\"{&quot;background_background&quot;:&quot;classic&quot;}\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-container elementor-column-gap-default\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-33 elementor-inner-column elementor-element elementor-element-66d26728\\\" data-id=\\\"66d26728\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-element elementor-element-4caf5dd4 elementor-position-top elementor-widget elementor-widget-image-box\\\" data-id=\\\"4caf5dd4\\\" data-element_type=\\\"widget\\\" data-e-type=\\\"widget\\\" data-widget_type=\\\"image-box.default\\\">\\n\\t\\t\\t\\t<div class=\\\"elementor-widget-container\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-image-box-wrapper\\\"><figure class=\\\"elementor-image-box-img\\\"><img width=\\\"849\\\" height=\\\"565\\\" src=\\\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Elektrik-Ariza-Tespiti.jpg\\\" class=\\\"attachment-large size-large wp-image-1295\\\" alt=\\\"\\\" \\/><\\/figure><div class=\\\"elementor-image-box-content\\\"><h3 class=\\\"elementor-image-box-title\\\">Elektrik Ar\\u0131za Tespiti<\\/h3><p class=\\\"elementor-image-box-description\\\"><a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nM\\u00fc\\u015fterilerimizin elektrik ar\\u0131za ihtiya\\u00e7lar\\u0131na, en do\\u011fru ve alternatif \\u00e7\\u00f6z\\u00fcmlerle m\\u00fcdahale ediyoruz.<\\/p><\\/div><\\/div>\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-33 elementor-inner-column elementor-element elementor-element-3a55c794\\\" data-id=\\\"3a55c794\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-element elementor-element-ccfd9ff elementor-position-top elementor-widget elementor-widget-image-box\\\" data-id=\\\"ccfd9ff\\\" data-element_type=\\\"widget\\\" data-e-type=\\\"widget\\\" data-widget_type=\\\"image-box.default\\\">\\n\\t\\t\\t\\t<div class=\\\"elementor-widget-container\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-image-box-wrapper\\\"><figure class=\\\"elementor-image-box-img\\\"><img width=\\\"1024\\\" height=\\\"686\\\" src=\\\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/Uydu-Anten-Kurulumu-1024x686.jpg\\\" class=\\\"attachment-large size-large wp-image-1299\\\" alt=\\\"\\\" \\/><\\/figure><div class=\\\"elementor-image-box-content\\\"><h3 class=\\\"elementor-image-box-title\\\">Uydu Anten Kurulumu<\\/h3><p class=\\\"elementor-image-box-description\\\"><a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\nAnkara uyducu aray\\u0131\\u015f\\u0131nda olanlar\\u0131n tercihi Palaz Elektrik, 7\\/24 kesintisiz hizmet veriyor.<\\/p><\\/div><\\/div>\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-33 elementor-inner-column elementor-element elementor-element-8af7100\\\" data-id=\\\"8af7100\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-element elementor-element-194f92e1 elementor-position-top elementor-widget elementor-widget-image-box\\\" data-id=\\\"194f92e1\\\" data-element_type=\\\"widget\\\" data-e-type=\\\"widget\\\" data-widget_type=\\\"image-box.default\\\">\\n\\t\\t\\t\\t<div class=\\\"elementor-widget-container\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-image-box-wrapper\\\"><figure class=\\\"elementor-image-box-img\\\"><img width=\\\"1024\\\" height=\\\"683\\\" src=\\\"http:\\/\\/localhost:8888\\/ballielektrik\\/wp-content\\/uploads\\/2021\\/08\\/5cc715cdb5680155655111758-1024x683.jpg\\\" class=\\\"attachment-large size-large wp-image-1303\\\" alt=\\\"\\\" \\/><\\/figure><div class=\\\"elementor-image-box-content\\\"><h3 class=\\\"elementor-image-box-title\\\">\\u0130n\\u015faat Elektrik Projeleri<\\/h3><p class=\\\"elementor-image-box-description\\\"><a title=\\\"Telefon\\\" href=\\\"tel:05415608918\\\"><h6>0541 560 89 18<\\/h6><\\/a>\\n\\n\\u0130n\\u015faat sekt\\u00f6r\\u00fcnde bir\\u00e7ok elektrik proje i\\u015fini tamamlayan firmam\\u0131z, her ge\\u00e7en g\\u00fcn daha da b\\u00fcy\\u00fcyor.<\\/p><\\/div><\\/div>\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/section>\\n\\t\\t\\t\\t<div class=\\\"elementor-element elementor-element-cee42dd elementor-widget elementor-widget-spacer\\\" data-id=\\\"cee42dd\\\" data-element_type=\\\"widget\\\" data-e-type=\\\"widget\\\" data-widget_type=\\\"spacer.default\\\">\\n\\t\\t\\t\\t<div class=\\\"elementor-widget-container\\\">\\n\\t\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-spacer\\\">\\n\\t\\t\\t<div class=\\\"elementor-spacer-inner\\\"><\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/section>\\n\\t\\t\\t\\t<section class=\\\"elementor-section elementor-top-section elementor-element elementor-element-5b36e30 elementor-section-full_width elementor-section-stretched elementor-section-height-default elementor-section-height-default\\\" data-id=\\\"5b36e30\\\" data-element_type=\\\"section\\\" data-e-type=\\\"section\\\" data-settings=\\\"{&quot;stretch_section&quot;:&quot;section-stretched&quot;}\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-container elementor-column-gap-no\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-100 elementor-top-column elementor-element elementor-element-acf89c8\\\" data-id=\\\"acf89c8\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t[elementor-element k=\\\"23310f780a7433516f570b30846f2967\\\" data=\\\"eyJpZCI6IjIzOWI4MmEiLCJlbFR5cGUiOiJ3aWRnZXQiLCJzZXR0aW5ncyI6eyJlbGVtZW50X3RpdGxlIjoiVGFsZXBsZXJpbml6IFx1MDEzMFx1MDBlN2luIEJpemltbGUgXHUwMTMwbGV0aVx1MDE1ZmltZSBHZVx1MDBlN2ViaWxpcnNpbml6LiIsImVsZW1lbnRfY2FwdGlvbiI6IlRhbGVwbGVyaW5pemUgRGlsZXJzZW5peiBcdTAxMzBsZXRpXHUwMTVmaW0gU2F5ZmFtXHUwMTMxemRhbiB2ZXlhIG9maXNpbWl6ZGUga2FodmVtaXppIGlcdTAwZTdlcmtlbiB5YXJkXHUwMTMxbWNcdTAxMzEgb2xhYmlsaXJpei4iLCJidXR0b25fdGV4dCI6Ilx1MDEzMExFVFx1MDEzMFx1MDE1ZVx1MDEzME0iLCJidXR0b25fdXJsIjp7InVybCI6Imh0dHA6XC9cL2xvY2FsaG9zdDo4ODg4XC9iYWxsaWVsZWt0cmlrXC9pbGV0aXNpbSIsImlzX2V4dGVybmFsIjpmYWxzZSwibm9mb2xsb3ciOmZhbHNlLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9LCJiYWNrZ3JvdW5kLWltYWdlIjp7InVybCI6Imh0dHA6XC9cL2xvY2FsaG9zdDo4ODg4XC9iYWxsaWVsZWt0cmlrXC93cC1jb250ZW50XC91cGxvYWRzXC8yMDIxXC8wOFwvZWxla3RyaWstcGl5YXNhc2ktaXN0YXRpc3Rpa3NlbC1hbmFsaXppLTAzLTEyLTIwMTkuanBnIiwiaWQiOjEyNTUsImFsdCI6IiIsInNvdXJjZSI6ImxpYnJhcnkifX0sImVsZW1lbnRzIjpbXSwid2lkZ2V0VHlwZSI6ImN0YS1zaW1wbGUifQ==\\\"]\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/section>\\n\\t\\t\\t\\t<section class=\\\"elementor-section elementor-top-section elementor-element elementor-element-10eb563 elementor-section-full_width elementor-section-stretched elementor-section-height-default elementor-section-height-default\\\" data-id=\\\"10eb563\\\" data-element_type=\\\"section\\\" data-e-type=\\\"section\\\" data-settings=\\\"{&quot;stretch_section&quot;:&quot;section-stretched&quot;}\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-container elementor-column-gap-no\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-100 elementor-top-column elementor-element elementor-element-61932fd2\\\" data-id=\\\"61932fd2\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t[elementor-element k=\\\"23310f780a7433516f570b30846f2967\\\" data=\\\"eyJpZCI6IjI1MmE3NTQ3IiwiZWxUeXBlIjoid2lkZ2V0Iiwic2V0dGluZ3MiOnsiY29udGVudF9jYXB0aW9uIjoiQmxvZyBZYXpcdTAxMzFsYXJcdTAxMzFtXHUwMTMxeiIsImNvbnRlbnRfaGVhZGluZyI6IlNvbiBNYWthbGVsZXIiLCJ3b3Jkc19jb3VudCI6IjEwIiwiYnV0dG9uX3RleHQiOiJEYWhhIEZhemxhc1x1MDEzMSIsInNlbGVjdF9jYXRlZ29yeSI6IjAiLCJwb3N0c19jb3VudCI6NiwiYnV0dG9uX3VybCI6eyJ1cmwiOiJodHRwOlwvXC9sb2NhbGhvc3Q6ODg4OFwvYmFsbGllbGVrdHJpa1wvYmxvZyIsImlzX2V4dGVybmFsIjpmYWxzZSwibm9mb2xsb3ciOmZhbHNlLCJjdXN0b21fYXR0cmlidXRlcyI6IiJ9fSwiZWxlbWVudHMiOltdLCJ3aWRnZXRUeXBlIjoiYmxvZ19ncmlkIn0=\\\"]\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/section>\\n\\t\\t\\t\\t<section class=\\\"elementor-section elementor-top-section elementor-element elementor-element-e3b230f elementor-section-boxed elementor-section-height-default elementor-section-height-default\\\" data-id=\\\"e3b230f\\\" data-element_type=\\\"section\\\" data-e-type=\\\"section\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-container elementor-column-gap-default\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-100 elementor-top-column elementor-element elementor-element-9b012e8\\\" data-id=\\\"9b012e8\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-element elementor-element- elementor-widget elementor-widget-html\\\" data-id=\\\"\\\" data-element_type=\\\"widget\\\" data-e-type=\\\"widget\\\" data-widget_type=\\\"html.default\\\">\\n\\t\\t\\t\\t<div class=\\\"elementor-widget-container\\\">\\n\\t\\t\\t\\t\\t<div style=\\\"overflow:hidden;height:1px;\\\"><a href=\\\"https:\\/\\/gaztime54.ru\\/\\\">\\u043c\\u0435\\u043b\\u0431\\u0435\\u0442<\\/a><\\/div>\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/section>\\n\\t\\t\\t\\t<section class=\\\"elementor-section elementor-top-section elementor-element elementor-element-8f2ddb3 elementor-section-boxed elementor-section-height-default elementor-section-height-default\\\" data-id=\\\"8f2ddb3\\\" data-element_type=\\\"section\\\" data-e-type=\\\"section\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-container elementor-column-gap-default\\\">\\n\\t\\t\\t\\t\\t<div class=\\\"elementor-column elementor-col-100 elementor-top-column elementor-element elementor-element-a83075f\\\" data-id=\\\"a83075f\\\" data-element_type=\\\"column\\\" data-e-type=\\\"column\\\">\\n\\t\\t\\t<div class=\\\"elementor-widget-wrap elementor-element-populated\\\">\\n\\t\\t\\t\\t\\t\\t<div class=\\\"elementor-element elementor-element- elementor-widget elementor-widget-html\\\" data-id=\\\"\\\" data-element_type=\\\"widget\\\" data-e-type=\\\"widget\\\" data-widget_type=\\\"html.default\\\">\\n\\t\\t\\t\\t<div class=\\\"elementor-widget-container\\\">\\n\\t\\t\\t\\t\\t<div style=\\\"overflow:hidden;height:1px;\\\"><a href=\\\"https:\\/\\/avabetting.com\\/\\\">Avabet <\\/a><\\/div>\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t\\t\\t\\t\\t<\\/div>\\n\\t\\t<\\/section>\\n\\t\\t\",\"scripts\":[],\"styles\":[]}}");

/* INSERT TABLE DATA: nqcpo_posts */
INSERT INTO `nqcpo_posts` VALUES("5", "1", "2021-08-01 02:02:55", "2021-07-31 23:02:55", "", "mt-sample-background", "", "inherit", "open", "closed", "", "mt-sample-background", "", "", "2021-08-01 02:02:55", "2021-07-31 23:02:55", "", "0", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/mt-sample-background.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("9", "1", "2021-08-01 02:05:03", "2021-07-31 23:05:03", "", "Blog", "", "publish", "closed", "open", "", "blog", "", "", "2021-08-01 02:05:03", "2021-07-31 23:05:03", "", "0", "http://localhost:8888/ballielektrik/?page_id=9", "0", "page", "", "0");
INSERT INTO `nqcpo_posts` VALUES("11", "1", "2021-08-01 02:04:49", "2021-07-31 23:04:49", "", "icon", "", "inherit", "open", "closed", "", "icon", "", "", "2021-08-01 02:04:49", "2021-07-31 23:04:49", "", "0", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/icon.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("12", "1", "2021-08-01 02:04:54", "2021-07-31 23:04:54", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/cropped-icon.png", "cropped-icon.png", "", "inherit", "open", "closed", "", "cropped-icon-png", "", "", "2021-08-01 02:04:54", "2021-07-31 23:04:54", "", "0", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/cropped-icon.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("25", "1", "2021-08-01 02:06:38", "2021-07-31 23:06:38", "", "logo-ballı-elektrik-logo", "", "inherit", "open", "closed", "", "logo-balli-elektrik-logo", "", "", "2021-08-01 02:06:38", "2021-07-31 23:06:38", "", "0", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/logo-balli-elektrik-logo.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("26", "1", "2021-08-01 02:10:02", "2021-07-31 23:10:02", "", "Fornax", "", "inherit", "open", "closed", "", "fornax", "", "", "2021-08-01 02:10:02", "2021-07-31 23:10:02", "", "0", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Fornax.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("27", "1", "2021-08-01 02:10:05", "2021-07-31 23:10:05", "", "logo-beyaz", "", "inherit", "open", "closed", "", "logo-beyaz", "", "", "2021-08-01 02:10:05", "2021-07-31 23:10:05", "", "0", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/logo-beyaz.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("29", "1", "2021-08-01 02:19:29", "2021-07-31 23:19:29", "", "V478-wan-16-technology [Converted].eps", "Galaxy in space textured background", "inherit", "open", "closed", "", "v478-wan-16-technology-converted-eps", "", "", "2021-08-01 02:19:29", "2021-07-31 23:19:29", "", "0", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/v478-wan-16-technology-converted-eps-2021-05-04-06-57-17-utc.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("31", "1", "2021-08-09 00:19:47", "2021-08-08 21:19:47", "<label> Adınız\n    [text* your-name] </label>\n\n<label> E-posta adresiniz\n    [email* your-email] </label>\n\n<label> Konu\n    [text* your-subject] </label>\n\n<label> İletiniz (tercihe bağlı)\n    [textarea your-message] </label>\n\n[submit \"Gönder\"]\n[_site_title] \"[your-subject]\"\n[_site_title] <info@ballielektrik.com>\nKimden: [your-name] <[your-email]>\nKonu: [your-subject]\n\nİleti gövdesi:\n[your-message]\n\n-- \nBu e-posta, [_site_title] ([_site_url]) adresindeki iletişim formundan gönderildi.\n[_site_admin_email]\nReply-To: [your-email]\n\n0\n0\n\n[_site_title] \"[your-subject]\"\n[_site_title] <info@ballielektrik.com>\nİleti gövdesi:\n[your-message]\n\n-- \nBu e-posta, [_site_title] ([_site_url]) adresindeki iletişim formundan gönderildi.\n[your-email]\nReply-To: [_site_admin_email]\n\n0\n0\nMesajınız için teşekkürler. Gönderildi.\nMesajınız gönderilirken bir hata oluştu. Lütfen daha sonra tekrar deneyin.\nBir veya daha fazla alanda hata bulundu. Lütfen kontrol edin ve tekrar deneyin.\nMesajınız gönderilirken bir hata oluştu. Lütfen daha sonra tekrar deneyin.\nMesajınızı göndermeden önce şartları ve koşulları kabul etmeniz gerekmektedir.\nBu alan zorunludur.\nBu alan çok uzun.\nBu alan çok kısa.\nDosya yüklenirken bilinmeyen bir hata oluştu.\nBu dosya türünü yükleme iznine sahip değilsiniz.\nDosya çok büyük.\nDosya yüklenirken hata meydana geldi.", "İletişim formu 1", "", "publish", "closed", "closed", "", "iletisim-formu-1", "", "", "2021-08-09 00:19:47", "2021-08-08 21:19:47", "", "0", "http://localhost:8888/ballielektrik/?post_type=wpcf7_contact_form&p=31", "0", "wpcf7_contact_form", "", "0");
INSERT INTO `nqcpo_posts` VALUES("32", "1", "2021-08-09 00:19:47", "2021-08-08 21:19:47", "", "Varsayılan Kit", "", "publish", "closed", "closed", "", "varsayilan-kit", "", "", "2021-08-09 00:25:05", "2021-08-08 21:25:05", "", "0", "http://localhost:8888/ballielektrik/?p=32", "0", "elementor_library", "", "0");
INSERT INTO `nqcpo_posts` VALUES("33", "1", "2021-08-09 00:19:48", "2021-08-08 21:19:48", "", "woocommerce-placeholder", "", "inherit", "open", "closed", "", "woocommerce-placeholder", "", "", "2021-08-09 00:19:48", "2021-08-08 21:19:48", "", "0", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/woocommerce-placeholder.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("38", "1", "2021-08-09 00:20:42", "2021-08-08 21:20:42", "", "One Click Demo Import - log_file_2021-08-08__21-20-42", "", "inherit", "open", "closed", "", "one-click-demo-import-log_file_2021-08-08__21-20-42", "", "", "2021-08-09 00:20:42", "2021-08-08 21:20:42", "", "0", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/log_file_2021-08-08__21-20-42.txt", "0", "attachment", "text/plain", "0");
INSERT INTO `nqcpo_posts` VALUES("90", "1", "2020-11-13 12:54:05", "2020-11-13 12:54:05", "<strong>GÜVENLİK KAMERA SİSTEMLERİ</strong>\r\n\r\nGüvenlik kamera sistemleri herhangi bir alanda güvenlik tedbir alınması için kurulmuş olan görüntüleme sistemleridir.\r\n\r\nBu sistemler güvenlik kamerası, kayıt cihazları, kaydedilen görüntülerin izlenmesi için kullanılacak olan monitörlerden oluşur.\r\n\r\nBu sistemler sayesinde kurulum yapılan alanlarda, olup bitenler an be an izlenebilir, kaydedilir, gerektiği takdirde bir kez daha izlenebilir. Bir suçlunun yakalanmasında faydalanılabilen güvenlik kamera sistemleri evvela caydırıcılık amacı taşımaktadır.\r\n\r\nAynı zamanda çocuklarını bakıcıya bırakan anne babalar da çocuklarının güvenliğini bu sistemler kanalı ile sağlamaktadır. Ayrıca söz gelimi bir mağazada kasadaki para trafiğini kameralar ile gözlemek mümkündür.\r\n\r\nStadyumlarda taşkınlık yapan taraftarların bulunmasında da güvenlik kamera sistemlerinin rolü yadsınamaz.\r\n\r\nGeçtiğimiz senelerde analog kameralar ile kurulmuş olan bu sistemler, teknolojinin hızlı gelişmesi neticesinde büyük gelişim göstermiştir. Bu gelişim ile beraber, evler ya da herhangi bir alan 7/24, gece gündüz gözetim altında tutulabilmektedir.\r\n\r\nGüvenlik kamera sistemleri evler, işyerleri, fabrikalar, avm\'ler, kamu kurumları, oteller, spor merkezleri, çocuk parkları, otoparklar, sokaklar, caddeler vb. Yerlerde kullanılacak olan, daha genel bir ifade ile insanın olduğu her yerde kullanılması gerekli olan sistemlerdir. Böylece izlenmesi gerekli olan her yer daha kolay ve çok sayıda güvenlik görevlisine ihtiyaç olmadan izlenebilir.\r\n\r\nBilinçli her tüketicinin güvenlik sistemleri seçiminde bazı önemli noktaları iyi bilmesi ve seçim yaparken bu bilgileri dikkate alması gerekiyor. Bilinçsiz seçim ve kulaktan dolma bilgiler ile yapılacak seçimler düşük nitelikli sistemlerin alınmasına neden olabilir. Bu durumda kameralar istenen amaca hizmet etmeyecek, yalnızca görüntüden ibaret kalacaklardır.\r\n\r\nKamera sistemlerinde evvela yapılması gerekli olan işlem, kullanılacak alanın iyi bir biçimde analiz edilmesi, en doğru noktaların tespitinin yapılmasıdır. Burada yükseklik konusuna özellikle özen gösterilmelidir.. Çok aşağıda olan bir güvenlik kamerası, kolay ulaşılacağı için devreden çıkarılması da kolay olacaktır. Kameraların yükseğe konulması ulaşılmasını ve devreden çıkarılmasını nispeten zorlaştıracaktır.\r\n\r\nGüvenlik kamera sistemi kullanımında amaç en düşük maliyet ile en iyi görüntü alabilmektedir. Gerekli alanlarda dış ortam ya da iç ortam tercihleri yapılmalıdır.\r\n\r\nGüvenlik kamera sistemlerinin alarm sistemleriyle entegre bir biçimde kullanılması ise çok daha iyi bir koruma sağlayabilir.\r\n\r\n&nbsp;\r\n\r\n<strong>GÜVENLİK KAMERA SİSTEMLERİ NASIL ÇALIŞIR?</strong>\r\nGüvenlik kamera sistemlerinin çalışmasını temel mantığı video kaydıdır. Kameranın içerisinde bir mercek bulunur. Merceğin ön kısmında da koyucu bir cam vardır. Mercek gelen ışıkları sensöre toplar. Toplanan bu ışık bir ara birimine gönderilir. AFE adı verilen bu birim ışıkları dijital sinyale dönüştürür. Son olarak da sensörde toplanan ışık “Dijital sinyal işleme” merkezi “DSP”ye gönderilir ve görüntü işlenir. Güvenlik kamerası bu şekilde görüntüyü alır ve kaydeder. Kamera görüntüleri istendiği anda bir kez daha izlenebilir.\r\n\r\n&nbsp;\r\n\r\n<strong>GÜVENLİK KAMERASI ÇEŞİTLERİ</strong>\r\nGüvenlik kameralarının çeşitleri son zamanlarda ciddi bir artış göstermiştir. Kullanım alanına göre farklılaşan ve her ihtiyaca hitap edebilen bu kameralar daha önceleri yalnızca analogdu.\r\n\r\nFakat çağımızda yoğun olarak IP kameralar kullanılıyor. 360 derece hareket edebilen modelleriyle çevreyi tam manası ile “gözaltında” tutan kameraların beraberinde, gece görüş kameraları da karanlığı delerek gündüzmüşçesine kayıt yapabilmektedir. Aynı zamanda kablosuz kameralar da hem kurulum hem kullanılabilirlik sunmaktadırlar.\r\n\r\nGüvenlik kamerası çeşitlerini şöyle sıralamak mümkündür:\r\n\r\nKablolu ya da kablosuz analog kameralar\r\nKablolu ya da kablosuz IP kameralar\r\nGece görüş kameraları\r\nPTZ kameralar\r\nDome kameralar\r\nWifi kameralar\r\nTermal kameralar\r\nBullet kameralar\r\nEx-proof (Patlamaya dayanıklı kameralar)\r\nBalıkgözü güvenlik kameraları\r\nDış ortam kameraları\r\n\r\n&nbsp;\r\n\r\n<strong>IP GÜVENLİK KAMERASI</strong>\r\nIP güvenlik kamerası, bilgisayarlar gibi bir ağa bağlı olan kameralardır. Dijital de denen bu kameralarla görüntüler direk şekilde dijital ortama kaydedilir. Bu sebeple ayrıca bir kayıt cihazına (DVR) ihtiyaç olmaz. Her kamera direk olarak networke bağlı olduğu için kamera bir kayıt cihazına bağlanmaz.\r\n\r\nIP güvenlik kamerası bir çok açıdan analog kameralara göre daha avantajlıdır. Öncelikle yüksek görüntü kalitesi sunan bu kameralar, kolay ve güvenilir kurulum özelliğiyle ciddi avantaj sağlar. Kurulum sırasında daha ince ve esnek internet kablosu kullanılır, kamera ile en yakın network ağı arasında kablolama yapılır.\r\n\r\nUzaktan erişimin mümkün olduğu IP kameralarda esneklik ve maliyet unsuru da kullanıcın lehinedir. IP kameralarla çok yönlü gözlem yapılması da diğer bir avantajdır. Bu kameralar çeşitli boyutlara ve lens uzunluklarına sahiptir. Kullanılacağı yer ve uygulamaya göre doğru kamera seçiminin yapılması en doğru sonuçların alınmasını sağlayacaktır.\r\n\r\n&nbsp;\r\n\r\n<strong>GECE GÖRÜŞLÜ GÜVENLİK KAMERA</strong>\r\nGece görüşlü güvenlik kamera ile düşük aydınlatmalı veya karanlık ortamlarda görüntü alınabilir. Örneğin, penceresi ya da doğal ışık kaynağı olmayan perakende mağazaların ya da ofis yapılarının gece gözetimi bu kameralar yardımı ile yapılır.\r\n\r\nİnsan gözünün göremediğini görme işlevi olan gece kameralarıyla ortam zifiri karanlık bile olsa nitelikli görüntü alınır ve ev, işletmeler, avm\'ler gibi akla gelebilecek her yer hırsızlık vb. Gibi tehlikeli durumlarda karşı koruma altına alınır. Zira hem konutlarda hem de işyerlerindeki suçların büyük çoğunlu gece/ karanlıkta işlenmektedir.\r\n\r\n7/24 görüntü alan bu kameralar daha çok işletmeler, fabrikalar, endüstri tesisleri veya askeriye, emniyet, gözetim gibi stratejik önemi olan yerlerde kullanıldığı gibi ev güvenlik sistemi olarak da tercih edilebilir. Tavana, duvara veya düz bir zemine monte edilebilen gece görüşlü güvenlik kameralara kızıl ötesi kamera da denilmektedir. Çünkü bu kameralarda IR yani kızılötesi aydınlatma kullanılır. Kızılötesi ışık, gün ışığının veya ek aydınlatmaların olmadığı alanlarda siyah beyaz görüntüleme yapılmasını sağlar.\r\n\r\nYüksek görüntü ve ses kalitesi sunan bu kameralar hem iç hem dış mekanlarda kullanmak mümkündür. Bu kameraların montajının yapılması aşamasında karşıdan direkt bir ışık kaynağı olmamasına ve önünde bir nesne bulunmamsına özen gösterilmelidir.. Aksi takdirde kameranın odak noktası değişir.\r\n\r\nGece görüş kameralarının çalışma prensibi ise şöyledir:\r\n\r\nKameralar kızılötesi ışın yayarak kendi ışığını oluşturmaya çalışır. Ortamda bu kızılötesi ışınlar lens yardımı ile toplanır. Toplanan ışık, görüntü yoğunlaştırıcı tüpe gönderilir. Elektronlar tüp içinden geçerken delikli bir mikro levha kullanılarak salınan atomların çarpışmasıyla yeni elektronlar elde edilir. Görüntü yoğunlaştırıcı tüpün çıkışında elektronlar fosforlu bir yüzeye çarpar. Fotonlar geçerken kanala göre konumlarını koruyarak görüntü sağlar.\r\n\r\n&nbsp;\r\n\r\n<strong>EV, APARTMAN GÜVENLİK KAMERALARI</strong>\r\nEv, apartman kameraları özellikle büyük kentlerde temel gereksinimler arasında bulunmaktadır. Öyle ki büyük kentlerde hırsızlık ilk sırada olmak üzere artan suç oranları insanları güvenlik kamerası kurmaya mecburi duruma getirmiştir.\r\n\r\nEv, apartman güvenlik kameraları yapıların çepeçevre etrafına döşenebilir. Fakat yoğun olarak kapı girişleri, otopark veya bahçe kısmına yerleştirilen kameralar binanın çevresinde kuş uçsa bile kayıt altına alır ve bu şekilde güvenlik sağlanır.\r\n\r\nApartman dışına kurulacak kameralar ayrıca bina önüne park edilmiş araçların güvenliği bakımından önem arzeder.\r\n\r\nEv kameraları, evin içerisine konularak, ev içi gözlem ve güvenlik sağlanmış olur. Burada çocuk bakıcı takibi veya hasta takibi yapılabilir.\r\n\r\nAynı zamanda herhangi bir hırsızlık vakasında da ev kameraları çok önemli hizmetler görür.\r\n\r\nBu kameralar gece görüşlü kameralar olabilir, analog veya dijital olabilir, paslanmaya, neme, korozyona karşı korumalı olabilir. Fakat asıl olan artık muhakkak kullanılması gerektiğidir.\r\n\r\n&nbsp;\r\n\r\n<strong>KABLOSUZ GÜVENLİK KAMERA SİSTEMLERİ</strong>\r\nKablosuz güvenlik kamera sistemleri, radyo bandı aracılığı ile bir kablosuz alıcıya bir video ve ses sinyali ileten kapalı devre televizyon kameralarına denir. Herhangi bir bağlantı noktası olmayan ve bağımsız çalışan kameralardır.\r\n\r\nAnalog ve dijital dahil olmak üzere iki türü bulunan bu kameralar adı üstünde kablo içermemektedir. Bu sebeple de istenen yere yerleştirilme avantajı sağlarlar. Ayrıca ortada kablo olmaması kameranın görünürlüğünü de ortadan kaldırır. Bunun sayesinde kameralar daha gizli duruma gelir ve görevini daha kusursuz yerine getirir.\r\n\r\nKurulumu daha kolay kablosuz kameralar bilgisayar ve cep telefonu üstünden izlenebilmeleri itibariyle tercih edilmektedir. Sabit IP de gerektirmeyen bu kameralar videoyu dahili bir depolama cihazına veya buluta göndererek, sisteme bağlı alıcıya ulaştırır. Görüntülerin buluta gönderilmesi ise kayıt güvenliği bakımından önem arzeder.\r\n\r\n&nbsp;\r\n\r\n<strong>WİRELESS (WİFİ) GÜVENLİK KAMERA SİSTEMLERİ</strong>\r\nWireless (WİFİ) güvenlik kamera sistemleri esas olarak kablosuz güvenlik kamera sistemleridir. Bu kameralar dört adetten az kamera kullanımı olan alanlarda tercih edilirler. Kullanım amacı ise yoğun olarak bebek kamerası ya a asansör kamerası şeklindedir. Wifi kameralar metrekare olarak küçük işletme ve dükkanlarda daha kullanışlıdır.\r\n\r\nWireless güvelik kameraları ayrıca kiralık mekanlarda daha çok kullanılır. Çünkü kablo ihtiyacı olmadığı için esnek bir montaj sunar. Kiralama süresi bittiğinde alıp çantaya alıp gitmek bir hayli zor değildir.\r\n\r\n<strong>2 Lİ GÜVENLİK KAMERA SETİ</strong>\r\n2li güvenlik kamera setinde, tercihe bağlı şekilde 2 adet kamera ve güvenlik sistemi aparatları yer almaktadır. Kameraların biri iç mekan biri dış mekan içindir. Kameralar IP veya analog olabilir.\r\n\r\nBu set okul, ofis, bina, cami, gibi yerlerde, iç ve dış mekanlardaki güvenlik ihtiyacı için tercih edilir. Aparatlar arasında kayıt cihazı, harddiskler, adaptör, konektör ve ihtiyaç duyulması halinde kablolar vardır.\r\n\r\n<strong>3 LÜ GÜVENLİK KAMERA SETİ</strong>\r\n3lü güvenlik kamera setinde de 3 adet kamera ve kamera aparatları vardır. Eğer kameralar IP ise mevcut aparatlara internet switch de eklenir.\r\n\r\n<strong>4 LÜ GÜVENLİK KAMERA SETİ</strong>\r\n4lü güvenlik kamera setinde 4 adet kamera ve kamera aparatları yer almaktadır.\r\n\r\n<strong>16 LI GÜVENLİK KAMERA SETİ</strong>\r\n16lı güvenlik kamera setinde 16 adet güvenlik kamerası ve kamera aparatları yer alır.\r\n\r\nBu güvenlik kamera setleri arasından hangisinin seçileceği kullanılacağı yer ile alakalıdır. En doğru sonucu almak için doğru yere doğru kamera seçilmesi gerekir.\r\n\r\n<strong>GÜVENLİK KAMERA SİSTEMİ KURULUMU</strong>\r\nGüvenlik kamera sistem kurulumu, kameraların etkin ve verimli kullanılabilmesi açısından büyük önem arzeder. Kurulumun işinde uzman uzmanlar tarafından yapılması, kullanıcıların güvenliği bakımından da önemlidir.\r\n\r\nGüvenlik kamera sistemi kurulumu öncelikle kullanıcı gereksinimlerine bağlıdır fakat sistemin yapısı da kurulumu yakından ilgilendirir.\r\n\r\n<strong>GÜVENLİK KAMERA MONTAJI</strong>\r\nGüvenlik kamera montajı, güvenlik sistemlerinin en can alıcı bölümüdür. Zira yapılacak yanlışlar ciddi güvenlik açıklarına neden olabilir. Aynı zamanda doğru bir montaj güvenliği en üst düzeye çıkarabilir.\r\n\r\nBu noktada güvenlik kamerasının nerelere yerleştirileceği, kaç adet kamera kullanılacağı, iç ve dış mekanda kullanılacak kameraların özellikleri gibi unsurlar ön plana çıkar. Kablolu bir model kullanılıyorsa doğru kablolama yapılması da güvenlik kamera montajı açısından önemlidir.\r\n\r\nMontaj sırasında kameranın yerleştirileceği yere özen gösterilmelidir. Kamera ile görüntülenmek istenilen yer arasında engel olmamasına ve kameranın güneş ışınlarını direk olarak almamasına özen gösterilmelidir.. Bu noktada dijital kayıt cihazının konulacağı yer de önem kazanmaktadır. DVR’ın tercihen kameraya yakın olması gerekiyor. Bu aşamadan sonra sıra kablolamaya, kablolama işlemi sonrasında ise kamera montajına gelmektedir.\r\n\r\n<strong>GÜVENLİK KAMERASI FİYATLARI</strong>\r\nGüvenlik kamerası maliyetleri farklı faktörlerden etkilenir. Kameraların yapıldıkları malzeme, çözünürlük oranları, gece görüşü olup olmadığı, analog veya dijital olması, kablosuz olması gibi özelliklerin her biri güvenlik kamerası maliyetleri üstünde etkilidir.\r\n\r\nGüvenlik kamerası maliyetleri hakkında detaylı bilgi almak için lütfen bize ulaşın ve fiyat teklifi isteyin.\r\n\r\n<strong>DİJİTAL GÜVENLİK KAMERA FİYATLARI</strong>\r\nDijital güvenlik kamera maliyetleri etkileyen faktörler de analog kameralar için geçerli olanlarla hemen aynıdır. Dijital kameralar analog olanlara göre biraz daha yüksek fiyatlı olsalar da, kullanım verimliliği sayesinde bu fazlalık çok büyük bir maliyet unsuru olarak kabul edilmez.\r\n\r\n<strong>GÜVENLİK KAMERA SİSTEMLERİ FİYAT LİSTESİ</strong>\r\nGüvenlik kamerası fiyat listesi de farklı sebeplere göre farklılık gösterir. Kullanılacak malzemelerin niteliği, sistemin kullanılacağı yerin özellikleri, iç mekan, dış mekan kullanımı, sistemde kullanılacak kamera sayısı ve çözünürlükleri gibi özellikler güvenlik kamera sistemleri fiyat listesinde değişkenliğe olur.\r\n\r\nHem iç hem dış mekan kameralarını barındıran bir güvenlik kamera sistemi yalnızca iç mekanda kullanılacak sisteme göre daha pahalı olacaktır.\r\n\r\n2li güvenlik kamera seti kullanılacak olan bir müşteri, 16lı kamera seti kullanana göre daha düşük fiyatlarla karşılaşacaktır.\r\n\r\nGüvenlik kamera sistemleri fiyat listesindeki bu değişikliklerden çok fazla etkilenmemek için doğru seçimler yapılmalıdır. Bu sebeple lütfen bize ulaşın ve fiyat teklifi isteyin. İhtiyaçlarınız en iyi biçimde belirleyip, size en ideal güvenlik kamera sistemleri fiyat listesi ile satın alma yapmanızı sağlayalım.\r\n\r\n<strong>YERİNDE TESPİT</strong>\r\nGüvenlik kamera sistemleri kurulumu ve kameraların montajından önce, sistemi kuracak olanların yerinde tespit yapması yararlı olacaktır. Kameraların nereye kurulacağı veya kurulması gerektiği bu keşif işlemiyle belirlenmelidir.\r\n\r\nBu noktada yerinde tespit ve keşfin önemine de değinmek gerekir. Yapılan en büyük hatalardan biri güvenlik kamera sistemini satın aldıktan sonra kurulum planı yapmaktır. Bu durum vahim sonuçlar doğuracak hatalara neden olabilir. Yapılacak yerinde tespit ve keşif ise ihtiyaçları tam manası ile ortaya çıkartır. Kaç kameraya ihtiyaç duyulacağı, kameraların nerelere konuşlandırılması gerekli şekil de detaylar yerinde tespit ile anlaşılabilir.\r\n\r\nGüvenlik kamera sistem kurulumu istiyorsanız bizi arayın, önce yerinde tespit yaparak, ihtiyaçlarınızı rasyonel bir biçimde ortaya çıkaralım, kaç adet kameraya ihtiyacınız olduğunu, bu kameraların hangi noktalara kurulması gerektiğini belirleyelim, sonra sisteminizin kurulumunu gerçekleştirelim. Böylece güvenli günleriniz başlasın.\r\n\r\n&nbsp;", "Kamera Kurulumu", "Güvenlik kamera sistem kurulumu istiyorsanız bizi arayın, önce yerinde tespit yaparak, ihtiyaçlarınızı rasyonel bir biçimde ortaya çıkaralım, kaç adet kameraya ihtiyacınız olduğunu, bu kameraların hangi noktalara kurulması gerektiğini belirleyelim, sonra sisteminizin kurulumunu gerçekleştirelim. Böylece güvenli günleriniz başlasın.", "publish", "closed", "closed", "", "kamera-kurulumu", "", "", "2021-08-17 23:59:17", "2021-08-17 20:59:17", "", "0", "https://nauthemes.com/wp/kriate/?post_type=services&#038;p=90", "0", "services", "", "0");
INSERT INTO `nqcpo_posts` VALUES("91", "1", "2020-11-13 12:55:12", "2020-11-13 12:55:12", "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen vived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was pop 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. Lorem Ipsum is simply dummy text of the printing and typesetting industry.\r\n\r\n[gallery columns=\"4\" size=\"medium\" link=\"none\" ids=\"1147,1146,1145,1144\" orderby=\"rand\"]\r\n\r\n&nbsp;", "Owner\'s Representation", "Donec scelerisque dolor id nunc dictum, interdum gravida mauris rhoncus. Aliquam at ultrices nunc. In sem leo, fermentum at lorem in, porta finibus mauris. Aliquam consectetur, ex in gravida porttitor.", "draft", "closed", "closed", "", "owners-representation", "", "", "2021-08-17 23:57:41", "2021-08-17 20:57:41", "", "0", "https://nauthemes.com/wp/kriate/?post_type=services&#038;p=91", "0", "services", "", "0");
INSERT INTO `nqcpo_posts` VALUES("95", "1", "2020-11-13 13:06:12", "2020-11-13 13:06:12", "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen vived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was pop 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. Lorem Ipsum is simply dummy text of the printing and typesetting industry.\r\n\r\n[gallery columns=\"4\" size=\"medium\" link=\"none\" ids=\"1147,1146,1145,1144\" orderby=\"rand\"]\r\n\r\n&nbsp;", "Construction And Engineering", "Donec scelerisque dolor id nunc dictum, interdum gravida mauris rhoncus. Aliquam at ultrices nunc. In sem leo, fermentum at lorem in, porta finibus mauris. Aliquam consectetur, ex in gravida porttitor.", "draft", "closed", "closed", "", "construction-and-engineering", "", "", "2021-08-17 23:57:41", "2021-08-17 20:57:41", "", "0", "https://nauthemes.com/wp/kriate/?post_type=services&#038;p=95", "0", "services", "", "0");
INSERT INTO `nqcpo_posts` VALUES("96", "1", "2020-11-13 13:07:03", "2020-11-13 13:07:03", "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen vived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was pop 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. Lorem Ipsum is simply dummy text of the printing and typesetting industry.\r\n\r\n[gallery columns=\"4\" size=\"medium\" link=\"none\" ids=\"1147,1146,1145,1144\" orderby=\"rand\"]\r\n\r\n&nbsp;", "Industrial Safety Equipment\'s", "Donec scelerisque dolor id nunc dictum, interdum gravida mauris rhoncus. Aliquam at ultrices nunc. In sem leo, fermentum at lorem in, porta finibus mauris. Aliquam consectetur, ex in gravida porttitor.", "draft", "closed", "closed", "", "industrial-equipments", "", "", "2021-08-17 23:57:41", "2021-08-17 20:57:41", "", "0", "https://nauthemes.com/wp/kriate/?post_type=services&#038;p=96", "0", "services", "", "0");
INSERT INTO `nqcpo_posts` VALUES("97", "1", "2020-11-13 13:07:55", "2020-11-13 13:07:55", "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen vived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was pop 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. Lorem Ipsum is simply dummy text of the printing and typesetting industry.\r\n\r\n[gallery columns=\"4\" size=\"medium\" link=\"none\" ids=\"1147,1146,1145,1144\" orderby=\"rand\"]\r\n\r\n&nbsp;", "Petroleum Core Productions", "Donec scelerisque dolor id nunc dictum, interdum gravida mauris rhoncus. Aliquam at ultrices nunc. In sem leo, fermentum at lorem in, porta finibus mauris. Aliquam consectetur, ex in gravida porttitor.", "draft", "closed", "closed", "", "fuel-gas-productions", "", "", "2021-08-17 23:57:41", "2021-08-17 20:57:41", "", "0", "https://nauthemes.com/wp/kriate/?post_type=services&#038;p=97", "0", "services", "", "0");
INSERT INTO `nqcpo_posts` VALUES("120", "1", "2020-11-13 14:07:13", "2020-11-13 14:07:13", "", "client-img1-1", "", "inherit", "open", "closed", "", "client-img1-1", "", "", "2021-08-09 00:21:04", "2021-08-08 21:21:04", "", "0", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/11/client-img1-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("121", "1", "2020-11-13 14:07:14", "2020-11-13 14:07:14", "", "client-img1-2", "", "inherit", "open", "closed", "", "client-img1-2", "", "", "2021-08-09 00:21:04", "2021-08-08 21:21:04", "", "0", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/11/client-img1-2.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("122", "1", "2020-11-13 14:07:14", "2020-11-13 14:07:14", "", "client-img1-3", "", "inherit", "open", "closed", "", "client-img1-3", "", "", "2021-08-09 00:21:04", "2021-08-08 21:21:04", "", "0", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/11/client-img1-3.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("123", "1", "2020-11-13 14:07:15", "2020-11-13 14:07:15", "", "client-img1-4", "", "inherit", "open", "closed", "", "client-img1-4", "", "", "2021-08-09 00:21:04", "2021-08-08 21:21:04", "", "0", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/11/client-img1-4.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("124", "1", "2020-11-13 14:07:16", "2020-11-13 14:07:16", "", "client-img1-5", "", "inherit", "open", "closed", "", "client-img1-5", "", "", "2021-08-09 00:21:04", "2021-08-08 21:21:04", "", "0", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/11/client-img1-5.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("125", "1", "2020-11-13 14:07:16", "2020-11-13 14:07:16", "", "client-img1-6", "", "inherit", "open", "closed", "", "client-img1-6", "", "", "2021-08-09 00:21:04", "2021-08-08 21:21:04", "", "0", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/11/client-img1-6.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("141", "1", "2020-11-14 06:12:29", "2020-11-14 06:12:29", "<p class=\"mb-0\">Construction is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen vived not only five centuries, With the rise of technological advances, promotions can be done outside of local contexts and across geographic.</p>\r\n<p class=\"mb-0\">1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop<a href=\"https://nauthemes.com/wp/kriate/our-testimonials/\"><em> Aldus PageMaker including versions</em></a> of contexts and across geographic. Technological advances, is simply dummy text of the printing and typesetting industry publishing industry coming.</p>\r\n\r\n<blockquote>Construction got modernized so quickly, that’s its now really the time to match up the industrial modernization and upgrade for benefits keep coming this year</blockquote>\r\n<p class=\"mb-0\">Release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. <em><a href=\"http://facebook.com\">Facebook</a></em>, <em><a href=\"http://twitter.com\">Twitter</a></em>, and <em><a href=\"http://linkedin.com\">Linkedin</a></em> is simply dummy text of the printing and typesetting industry publishing industry coming ipsum.</p>\r\n[recent-posts image1=\"gal-1.jpg\" image2=\"gal-2.jpg\" image3=\"gal-3.jpg\"]\r\n<p class=\"mb-0\">1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen.</p>", "Constructional Engineering", "", "publish", "open", "closed", "", "construction-engineering", "", "", "2020-11-14 06:12:29", "2020-11-14 06:12:29", "", "0", "https://nauthemes.com/wp/kriate/?post_type=projects&amp;p=141", "0", "projects", "", "0");
INSERT INTO `nqcpo_posts` VALUES("143", "1", "2020-11-14 06:13:30", "2020-11-14 06:13:30", "<p class=\"mb-0\">Construction is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen vived not only five centuries, With the rise of technological advances, promotions can be done outside of local contexts and across geographic.</p>\r\n<p class=\"mb-0\">1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop<a href=\"https://nauthemes.com/wp/kriate/our-testimonials/\"><em> Aldus PageMaker including versions</em></a> of contexts and across geographic. Technological advances, is simply dummy text of the printing and typesetting industry publishing industry coming.</p>\r\n\r\n<blockquote>Construction got modernized so quickly, that’s its now really the time to match up the industrial modernization and upgrade for benefits keep coming this year</blockquote>\r\n<p class=\"mb-0\">Release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. <em><a href=\"http://facebook.com\">Facebook</a></em>, <em><a href=\"http://twitter.com\">Twitter</a></em>, and <em><a href=\"http://linkedin.com\">Linkedin</a></em> is simply dummy text of the printing and typesetting industry publishing industry coming ipsum.</p>\r\n[recent-posts image1=\"gal-1.jpg\" image2=\"gal-2.jpg\" image3=\"gal-3.jpg\"]\r\n<p class=\"mb-0\">1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen.</p>", "Industry & Power Electric Grid", "", "publish", "open", "closed", "", "industry-power-grid", "", "", "2020-11-14 06:13:30", "2020-11-14 06:13:30", "", "0", "https://nauthemes.com/wp/kriate/?post_type=projects&amp;p=143", "0", "projects", "", "0");
INSERT INTO `nqcpo_posts` VALUES("145", "1", "2020-11-14 06:14:37", "2020-11-14 06:14:37", "<p class=\"mb-0\">Construction is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen vived not only five centuries, With the rise of technological advances, promotions can be done outside of local contexts and across geographic.</p>\r\n<p class=\"mb-0\">1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop<a href=\"https://nauthemes.com/wp/kriate/our-testimonials/\"><em> Aldus PageMaker including versions</em></a> of contexts and across geographic. Technological advances, is simply dummy text of the printing and typesetting industry publishing industry coming.</p>\r\n\r\n<blockquote>Construction got modernized so quickly, that’s its now really the time to match up the industrial modernization and upgrade for benefits keep coming this year</blockquote>\r\n<p class=\"mb-0\">Release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. <em><a href=\"http://facebook.com\">Facebook</a></em>, <em><a href=\"http://twitter.com\">Twitter</a></em>, and <em><a href=\"http://linkedin.com\">Linkedin</a></em> is simply dummy text of the printing and typesetting industry publishing industry coming ipsum.</p>\r\n[recent-posts image1=\"gal-1.jpg\" image2=\"gal-2.jpg\" image3=\"gal-3.jpg\"]\r\n<p class=\"mb-0\">1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen.</p>", "Chemical & Research Center", "", "publish", "open", "closed", "", "chemical-research-center", "", "", "2021-08-17 23:52:56", "2021-08-17 20:52:56", "", "0", "https://nauthemes.com/wp/kriate/?post_type=projects&#038;p=145", "0", "projects", "", "0");
INSERT INTO `nqcpo_posts` VALUES("146", "1", "2020-11-14 06:15:27", "2020-11-14 06:15:27", "<p class=\"mb-0\">Construction is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen vived not only five centuries, With the rise of technological advances, promotions can be done outside of local contexts and across geographic.</p>\r\n<p class=\"mb-0\">1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop<a href=\"https://nauthemes.com/wp/kriate/our-testimonials/\"><em> Aldus PageMaker including versions</em></a> of contexts and across geographic. Technological advances, is simply dummy text of the printing and typesetting industry publishing industry coming.</p>\r\n\r\n<blockquote>Construction got modernized so quickly, that’s its now really the time to match up the industrial modernization and upgrade for benefits keep coming this year</blockquote>\r\n<p class=\"mb-0\">Release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. <em><a href=\"http://facebook.com\">Facebook</a></em>, <em><a href=\"http://twitter.com\">Twitter</a></em>, and <em><a href=\"http://linkedin.com\">Linkedin</a></em> is simply dummy text of the printing and typesetting industry publishing industry coming ipsum.</p>\r\n[recent-posts image1=\"gal-1.jpg\" image2=\"gal-2.jpg\" image3=\"gal-3.jpg\"]\r\n<p class=\"mb-0\">1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen.</p>", "Constructional Research", "", "publish", "open", "closed", "", "constructional-research", "", "", "2020-11-14 06:15:27", "2020-11-14 06:15:27", "", "0", "https://nauthemes.com/wp/kriate/?post_type=projects&amp;p=146", "0", "projects", "", "0");
INSERT INTO `nqcpo_posts` VALUES("147", "1", "2020-11-14 06:16:34", "2020-11-14 06:16:34", "<p class=\"mb-0\">Construction is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen vived not only five centuries, With the rise of technological advances, promotions can be done outside of local contexts and across geographic.</p>\r\n<p class=\"mb-0\">1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop<a href=\"https://nauthemes.com/wp/kriate/our-testimonials/\"><em> Aldus PageMaker including versions</em></a> of contexts and across geographic. Technological advances, is simply dummy text of the printing and typesetting industry publishing industry coming.</p>\r\n\r\n<blockquote>Construction got modernized so quickly, that’s its now really the time to match up the industrial modernization and upgrade for benefits keep coming this year</blockquote>\r\n<p class=\"mb-0\">Release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. <em><a href=\"http://facebook.com\">Facebook</a></em>, <em><a href=\"http://twitter.com\">Twitter</a></em>, and <em><a href=\"http://linkedin.com\">Linkedin</a></em> is simply dummy text of the printing and typesetting industry publishing industry coming ipsum.</p>\r\n[recent-posts image1=\"gal-1.jpg\" image2=\"gal-2.jpg\" image3=\"gal-3.jpg\"]\r\n<p class=\"mb-0\">1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen.</p>", "Industrial Construction", "", "publish", "open", "closed", "", "industrial-construction", "", "", "2020-11-14 06:16:34", "2020-11-14 06:16:34", "", "0", "https://nauthemes.com/wp/kriate/projects/chemical-research-center-copy/", "0", "projects", "", "0");
INSERT INTO `nqcpo_posts` VALUES("148", "1", "2020-11-14 06:17:35", "2020-11-14 06:17:35", "<p class=\"mb-0\">Construction is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen vived not only five centuries, With the rise of technological advances, promotions can be done outside of local contexts and across geographic.</p>\r\n<p class=\"mb-0\">1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop<a href=\"https://nauthemes.com/wp/kriate/our-testimonials/\"><em> Aldus PageMaker including versions</em></a> of contexts and across geographic. Technological advances, is simply dummy text of the printing and typesetting industry publishing industry coming.</p>\r\n\r\n<blockquote>Construction got modernized so quickly, that’s its now really the time to match up the industrial modernization and upgrade for benefits keep coming this year</blockquote>\r\n<p class=\"mb-0\">Release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. <em><a href=\"http://facebook.com\">Facebook</a></em>, <em><a href=\"http://twitter.com\">Twitter</a></em>, and <em><a href=\"http://linkedin.com\">Linkedin</a></em> is simply dummy text of the printing and typesetting industry publishing industry coming ipsum.</p>\r\n[recent-posts image1=\"gal-1.jpg\" image2=\"gal-2.jpg\" image3=\"gal-3.jpg\"]\r\n<p class=\"mb-0\">1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen.</p>", "Ship Building Industry", "", "publish", "open", "closed", "", "ship-building-industry", "", "", "2020-11-14 06:17:35", "2020-11-14 06:17:35", "", "0", "https://nauthemes.com/wp/kriate/projects/industrial-construction-copy/", "0", "projects", "", "0");
INSERT INTO `nqcpo_posts` VALUES("149", "1", "2020-11-14 06:18:43", "2020-11-14 06:18:43", "<p class=\"mb-0\">Construction is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen vived not only five centuries, With the rise of technological advances, promotions can be done outside of local contexts and across geographic.</p>\r\n<p class=\"mb-0\">1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop<a href=\"https://nauthemes.com/wp/kriate/our-testimonials/\"><em> Aldus PageMaker including versions</em></a> of contexts and across geographic. Technological advances, is simply dummy text of the printing and typesetting industry publishing industry coming.</p>\r\n\r\n<blockquote>Construction got modernized so quickly, that’s its now really the time to match up the industrial modernization and upgrade for benefits keep coming this year</blockquote>\r\n<p class=\"mb-0\">Release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. <em><a href=\"http://facebook.com\">Facebook</a></em>, <em><a href=\"http://twitter.com\">Twitter</a></em>, and <em><a href=\"http://linkedin.com\">Linkedin</a></em> is simply dummy text of the printing and typesetting industry publishing industry coming ipsum.</p>\r\n[recent-posts image1=\"gal-1.jpg\" image2=\"gal-2.jpg\" image3=\"gal-3.jpg\"]\r\n<p class=\"mb-0\">1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishin Aldus PageMaker including versions of Lorem Ipsum. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen.</p>", "Factory Construction", "", "publish", "open", "closed", "", "factory-construction", "", "", "2020-11-14 06:18:43", "2020-11-14 06:18:43", "", "0", "https://nauthemes.com/wp/kriate/projects/ship-building-industry-copy/", "0", "projects", "", "0");
INSERT INTO `nqcpo_posts` VALUES("150", "1", "2020-11-14 06:19:23", "2020-11-14 06:19:23", "<strong>GÜVENLİK KAMERA SİSTEMLERİ</strong>\r\n\r\nGüvenlik kamera sistemleri herhangi bir alanda güvenlik tedbir alınması için kurulmuş olan görüntüleme sistemleridir.\r\n\r\nBu sistemler güvenlik kamerası, kayıt cihazları, kaydedilen görüntülerin izlenmesi için kullanılacak olan monitörlerden oluşur.\r\n\r\nBu sistemler sayesinde kurulum yapılan alanlarda, olup bitenler an be an izlenebilir, kaydedilir, gerektiği takdirde bir kez daha izlenebilir. Bir suçlunun yakalanmasında faydalanılabilen güvenlik kamera sistemleri evvela caydırıcılık amacı taşımaktadır.\r\n\r\nAynı zamanda çocuklarını bakıcıya bırakan anne babalar da çocuklarının güvenliğini bu sistemler kanalı ile sağlamaktadır. Ayrıca söz gelimi bir mağazada kasadaki para trafiğini kameralar ile gözlemek mümkündür.\r\n\r\nStadyumlarda taşkınlık yapan taraftarların bulunmasında da güvenlik kamera sistemlerinin rolü yadsınamaz.\r\n\r\nGeçtiğimiz senelerde analog kameralar ile kurulmuş olan bu sistemler, teknolojinin hızlı gelişmesi neticesinde büyük gelişim göstermiştir. Bu gelişim ile beraber, evler ya da herhangi bir alan 7/24, gece gündüz gözetim altında tutulabilmektedir.\r\n\r\nGüvenlik kamera sistemleri evler, işyerleri, fabrikalar, avm’ler, kamu kurumları, oteller, spor merkezleri, çocuk parkları, otoparklar, sokaklar, caddeler vb. Yerlerde kullanılacak olan, daha genel bir ifade ile insanın olduğu her yerde kullanılması gerekli olan sistemlerdir. Böylece izlenmesi gerekli olan her yer daha kolay ve çok sayıda güvenlik görevlisine ihtiyaç olmadan izlenebilir.\r\n\r\nBilinçli her tüketicinin güvenlik sistemleri seçiminde bazı önemli noktaları iyi bilmesi ve seçim yaparken bu bilgileri dikkate alması gerekiyor. Bilinçsiz seçim ve kulaktan dolma bilgiler ile yapılacak seçimler düşük nitelikli sistemlerin alınmasına neden olabilir. Bu durumda kameralar istenen amaca hizmet etmeyecek, yalnızca görüntüden ibaret kalacaklardır.\r\n\r\nKamera sistemlerinde evvela yapılması gerekli olan işlem, kullanılacak alanın iyi bir biçimde analiz edilmesi, en doğru noktaların tespitinin yapılmasıdır. Burada yükseklik konusuna özellikle özen gösterilmelidir.. Çok aşağıda olan bir güvenlik kamerası, kolay ulaşılacağı için devreden çıkarılması da kolay olacaktır. Kameraların yükseğe konulması ulaşılmasını ve devreden çıkarılmasını nispeten zorlaştıracaktır.\r\n\r\nGüvenlik kamera sistemi kullanımında amaç en düşük maliyet ile en iyi görüntü alabilmektedir. Gerekli alanlarda dış ortam ya da iç ortam tercihleri yapılmalıdır.\r\n\r\nGüvenlik kamera sistemlerinin alarm sistemleriyle entegre bir biçimde kullanılması ise çok daha iyi bir koruma sağlayabilir.\r\n\r\n&nbsp;\r\n\r\n<strong>GÜVENLİK KAMERA SİSTEMLERİ NASIL ÇALIŞIR?</strong>\r\nGüvenlik kamera sistemlerinin çalışmasını temel mantığı video kaydıdır. Kameranın içerisinde bir mercek bulunur. Merceğin ön kısmında da koyucu bir cam vardır. Mercek gelen ışıkları sensöre toplar. Toplanan bu ışık bir ara birimine gönderilir. AFE adı verilen bu birim ışıkları dijital sinyale dönüştürür. Son olarak da sensörde toplanan ışık “Dijital sinyal işleme” merkezi “DSP”ye gönderilir ve görüntü işlenir. Güvenlik kamerası bu şekilde görüntüyü alır ve kaydeder. Kamera görüntüleri istendiği anda bir kez daha izlenebilir.\r\n\r\n&nbsp;\r\n\r\n<strong>GÜVENLİK KAMERASI ÇEŞİTLERİ</strong>\r\nGüvenlik kameralarının çeşitleri son zamanlarda ciddi bir artış göstermiştir. Kullanım alanına göre farklılaşan ve her ihtiyaca hitap edebilen bu kameralar daha önceleri yalnızca analogdu.\r\n\r\nFakat çağımızda yoğun olarak IP kameralar kullanılıyor. 360 derece hareket edebilen modelleriyle çevreyi tam manası ile “gözaltında” tutan kameraların beraberinde, gece görüş kameraları da karanlığı delerek gündüzmüşçesine kayıt yapabilmektedir. Aynı zamanda kablosuz kameralar da hem kurulum hem kullanılabilirlik sunmaktadırlar.\r\n\r\nGüvenlik kamerası çeşitlerini şöyle sıralamak mümkündür:\r\n\r\nKablolu ya da kablosuz analog kameralar\r\nKablolu ya da kablosuz IP kameralar\r\nGece görüş kameraları\r\nPTZ kameralar\r\nDome kameralar\r\nWifi kameralar\r\nTermal kameralar\r\nBullet kameralar\r\nEx-proof (Patlamaya dayanıklı kameralar)\r\nBalıkgözü güvenlik kameraları\r\nDış ortam kameraları\r\n\r\n&nbsp;\r\n\r\n<strong>IP GÜVENLİK KAMERASI</strong>\r\nIP güvenlik kamerası, bilgisayarlar gibi bir ağa bağlı olan kameralardır. Dijital de denen bu kameralarla görüntüler direk şekilde dijital ortama kaydedilir. Bu sebeple ayrıca bir kayıt cihazına (DVR) ihtiyaç olmaz. Her kamera direk olarak networke bağlı olduğu için kamera bir kayıt cihazına bağlanmaz.\r\n\r\nIP güvenlik kamerası bir çok açıdan analog kameralara göre daha avantajlıdır. Öncelikle yüksek görüntü kalitesi sunan bu kameralar, kolay ve güvenilir kurulum özelliğiyle ciddi avantaj sağlar. Kurulum sırasında daha ince ve esnek internet kablosu kullanılır, kamera ile en yakın network ağı arasında kablolama yapılır.\r\n\r\nUzaktan erişimin mümkün olduğu IP kameralarda esneklik ve maliyet unsuru da kullanıcın lehinedir. IP kameralarla çok yönlü gözlem yapılması da diğer bir avantajdır. Bu kameralar çeşitli boyutlara ve lens uzunluklarına sahiptir. Kullanılacağı yer ve uygulamaya göre doğru kamera seçiminin yapılması en doğru sonuçların alınmasını sağlayacaktır.\r\n\r\n&nbsp;\r\n\r\n<strong>GECE GÖRÜŞLÜ GÜVENLİK KAMERA</strong>\r\nGece görüşlü güvenlik kamera ile düşük aydınlatmalı veya karanlık ortamlarda görüntü alınabilir. Örneğin, penceresi ya da doğal ışık kaynağı olmayan perakende mağazaların ya da ofis yapılarının gece gözetimi bu kameralar yardımı ile yapılır.\r\n\r\nİnsan gözünün göremediğini görme işlevi olan gece kameralarıyla ortam zifiri karanlık bile olsa nitelikli görüntü alınır ve ev, işletmeler, avm’ler gibi akla gelebilecek her yer hırsızlık vb. Gibi tehlikeli durumlarda karşı koruma altına alınır. Zira hem konutlarda hem de işyerlerindeki suçların büyük çoğunlu gece/ karanlıkta işlenmektedir.\r\n\r\n7/24 görüntü alan bu kameralar daha çok işletmeler, fabrikalar, endüstri tesisleri veya askeriye, emniyet, gözetim gibi stratejik önemi olan yerlerde kullanıldığı gibi ev güvenlik sistemi olarak da tercih edilebilir. Tavana, duvara veya düz bir zemine monte edilebilen gece görüşlü güvenlik kameralara kızıl ötesi kamera da denilmektedir. Çünkü bu kameralarda IR yani kızılötesi aydınlatma kullanılır. Kızılötesi ışık, gün ışığının veya ek aydınlatmaların olmadığı alanlarda siyah beyaz görüntüleme yapılmasını sağlar.\r\n\r\nYüksek görüntü ve ses kalitesi sunan bu kameralar hem iç hem dış mekanlarda kullanmak mümkündür. Bu kameraların montajının yapılması aşamasında karşıdan direkt bir ışık kaynağı olmamasına ve önünde bir nesne bulunmamsına özen gösterilmelidir.. Aksi takdirde kameranın odak noktası değişir.\r\n\r\nGece görüş kameralarının çalışma prensibi ise şöyledir:\r\n\r\nKameralar kızılötesi ışın yayarak kendi ışığını oluşturmaya çalışır. Ortamda bu kızılötesi ışınlar lens yardımı ile toplanır. Toplanan ışık, görüntü yoğunlaştırıcı tüpe gönderilir. Elektronlar tüp içinden geçerken delikli bir mikro levha kullanılarak salınan atomların çarpışmasıyla yeni elektronlar elde edilir. Görüntü yoğunlaştırıcı tüpün çıkışında elektronlar fosforlu bir yüzeye çarpar. Fotonlar geçerken kanala göre konumlarını koruyarak görüntü sağlar.\r\n\r\n&nbsp;\r\n\r\n<strong>EV, APARTMAN GÜVENLİK KAMERALARI</strong>\r\nEv, apartman kameraları özellikle büyük kentlerde temel gereksinimler arasında bulunmaktadır. Öyle ki büyük kentlerde hırsızlık ilk sırada olmak üzere artan suç oranları insanları güvenlik kamerası kurmaya mecburi duruma getirmiştir.\r\n\r\nEv, apartman güvenlik kameraları yapıların çepeçevre etrafına döşenebilir. Fakat yoğun olarak kapı girişleri, otopark veya bahçe kısmına yerleştirilen kameralar binanın çevresinde kuş uçsa bile kayıt altına alır ve bu şekilde güvenlik sağlanır.\r\n\r\nApartman dışına kurulacak kameralar ayrıca bina önüne park edilmiş araçların güvenliği bakımından önem arzeder.\r\n\r\nEv kameraları, evin içerisine konularak, ev içi gözlem ve güvenlik sağlanmış olur. Burada çocuk bakıcı takibi veya hasta takibi yapılabilir.\r\n\r\nAynı zamanda herhangi bir hırsızlık vakasında da ev kameraları çok önemli hizmetler görür.\r\n\r\nBu kameralar gece görüşlü kameralar olabilir, analog veya dijital olabilir, paslanmaya, neme, korozyona karşı korumalı olabilir. Fakat asıl olan artık muhakkak kullanılması gerektiğidir.\r\n\r\n&nbsp;\r\n\r\n<strong>KABLOSUZ GÜVENLİK KAMERA SİSTEMLERİ</strong>\r\nKablosuz güvenlik kamera sistemleri, radyo bandı aracılığı ile bir kablosuz alıcıya bir video ve ses sinyali ileten kapalı devre televizyon kameralarına denir. Herhangi bir bağlantı noktası olmayan ve bağımsız çalışan kameralardır.\r\n\r\nAnalog ve dijital dahil olmak üzere iki türü bulunan bu kameralar adı üstünde kablo içermemektedir. Bu sebeple de istenen yere yerleştirilme avantajı sağlarlar. Ayrıca ortada kablo olmaması kameranın görünürlüğünü de ortadan kaldırır. Bunun sayesinde kameralar daha gizli duruma gelir ve görevini daha kusursuz yerine getirir.\r\n\r\nKurulumu daha kolay kablosuz kameralar bilgisayar ve cep telefonu üstünden izlenebilmeleri itibariyle tercih edilmektedir. Sabit IP de gerektirmeyen bu kameralar videoyu dahili bir depolama cihazına veya buluta göndererek, sisteme bağlı alıcıya ulaştırır. Görüntülerin buluta gönderilmesi ise kayıt güvenliği bakımından önem arzeder.\r\n\r\n&nbsp;\r\n\r\n<strong>WİRELESS (WİFİ) GÜVENLİK KAMERA SİSTEMLERİ</strong>\r\nWireless (WİFİ) güvenlik kamera sistemleri esas olarak kablosuz güvenlik kamera sistemleridir. Bu kameralar dört adetten az kamera kullanımı olan alanlarda tercih edilirler. Kullanım amacı ise yoğun olarak bebek kamerası ya a asansör kamerası şeklindedir. Wifi kameralar metrekare olarak küçük işletme ve dükkanlarda daha kullanışlıdır.\r\n\r\nWireless güvelik kameraları ayrıca kiralık mekanlarda daha çok kullanılır. Çünkü kablo ihtiyacı olmadığı için esnek bir montaj sunar. Kiralama süresi bittiğinde alıp çantaya alıp gitmek bir hayli zor değildir.\r\n\r\n<strong>2 Lİ GÜVENLİK KAMERA SETİ</strong>\r\n2li güvenlik kamera setinde, tercihe bağlı şekilde 2 adet kamera ve güvenlik sistemi aparatları yer almaktadır. Kameraların biri iç mekan biri dış mekan içindir. Kameralar IP veya analog olabilir.\r\n\r\nBu set okul, ofis, bina, cami, gibi yerlerde, iç ve dış mekanlardaki güvenlik ihtiyacı için tercih edilir. Aparatlar arasında kayıt cihazı, harddiskler, adaptör, konektör ve ihtiyaç duyulması halinde kablolar vardır.\r\n\r\n<strong>3 LÜ GÜVENLİK KAMERA SETİ</strong>\r\n3lü güvenlik kamera setinde de 3 adet kamera ve kamera aparatları vardır. Eğer kameralar IP ise mevcut aparatlara internet switch de eklenir.\r\n\r\n<strong>4 LÜ GÜVENLİK KAMERA SETİ</strong>\r\n4lü güvenlik kamera setinde 4 adet kamera ve kamera aparatları yer almaktadır.\r\n\r\n<strong>16 LI GÜVENLİK KAMERA SETİ</strong>\r\n16lı güvenlik kamera setinde 16 adet güvenlik kamerası ve kamera aparatları yer alır.\r\n\r\nBu güvenlik kamera setleri arasından hangisinin seçileceği kullanılacağı yer ile alakalıdır. En doğru sonucu almak için doğru yere doğru kamera seçilmesi gerekir.\r\n\r\n<strong>GÜVENLİK KAMERA SİSTEMİ KURULUMU</strong>\r\nGüvenlik kamera sistem kurulumu, kameraların etkin ve verimli kullanılabilmesi açısından büyük önem arzeder. Kurulumun işinde uzman uzmanlar tarafından yapılması, kullanıcıların güvenliği bakımından da önemlidir.\r\n\r\nGüvenlik kamera sistemi kurulumu öncelikle kullanıcı gereksinimlerine bağlıdır fakat sistemin yapısı da kurulumu yakından ilgilendirir.\r\n\r\n<strong>GÜVENLİK KAMERA MONTAJI</strong>\r\nGüvenlik kamera montajı, güvenlik sistemlerinin en can alıcı bölümüdür. Zira yapılacak yanlışlar ciddi güvenlik açıklarına neden olabilir. Aynı zamanda doğru bir montaj güvenliği en üst düzeye çıkarabilir.\r\n\r\nBu noktada güvenlik kamerasının nerelere yerleştirileceği, kaç adet kamera kullanılacağı, iç ve dış mekanda kullanılacak kameraların özellikleri gibi unsurlar ön plana çıkar. Kablolu bir model kullanılıyorsa doğru kablolama yapılması da güvenlik kamera montajı açısından önemlidir.\r\n\r\nMontaj sırasında kameranın yerleştirileceği yere özen gösterilmelidir. Kamera ile görüntülenmek istenilen yer arasında engel olmamasına ve kameranın güneş ışınlarını direk olarak almamasına özen gösterilmelidir.. Bu noktada dijital kayıt cihazının konulacağı yer de önem kazanmaktadır. DVR’ın tercihen kameraya yakın olması gerekiyor. Bu aşamadan sonra sıra kablolamaya, kablolama işlemi sonrasında ise kamera montajına gelmektedir.\r\n\r\n<strong>GÜVENLİK KAMERASI FİYATLARI</strong>\r\nGüvenlik kamerası maliyetleri farklı faktörlerden etkilenir. Kameraların yapıldıkları malzeme, çözünürlük oranları, gece görüşü olup olmadığı, analog veya dijital olması, kablosuz olması gibi özelliklerin her biri güvenlik kamerası maliyetleri üstünde etkilidir.\r\n\r\nGüvenlik kamerası maliyetleri hakkında detaylı bilgi almak için lütfen bize ulaşın ve fiyat teklifi isteyin.\r\n\r\n<strong>DİJİTAL GÜVENLİK KAMERA FİYATLARI</strong>\r\nDijital güvenlik kamera maliyetleri etkileyen faktörler de analog kameralar için geçerli olanlarla hemen aynıdır. Dijital kameralar analog olanlara göre biraz daha yüksek fiyatlı olsalar da, kullanım verimliliği sayesinde bu fazlalık çok büyük bir maliyet unsuru olarak kabul edilmez.\r\n\r\n<strong>GÜVENLİK KAMERA SİSTEMLERİ FİYAT LİSTESİ</strong>\r\nGüvenlik kamerası fiyat listesi de farklı sebeplere göre farklılık gösterir. Kullanılacak malzemelerin niteliği, sistemin kullanılacağı yerin özellikleri, iç mekan, dış mekan kullanımı, sistemde kullanılacak kamera sayısı ve çözünürlükleri gibi özellikler güvenlik kamera sistemleri fiyat listesinde değişkenliğe olur.\r\n\r\nHem iç hem dış mekan kameralarını barındıran bir güvenlik kamera sistemi yalnızca iç mekanda kullanılacak sisteme göre daha pahalı olacaktır.\r\n\r\n2li güvenlik kamera seti kullanılacak olan bir müşteri, 16lı kamera seti kullanana göre daha düşük fiyatlarla karşılaşacaktır.\r\n\r\nGüvenlik kamera sistemleri fiyat listesindeki bu değişikliklerden çok fazla etkilenmemek için doğru seçimler yapılmalıdır. Bu sebeple lütfen bize ulaşın ve fiyat teklifi isteyin. İhtiyaçlarınız en iyi biçimde belirleyip, size en ideal güvenlik kamera sistemleri fiyat listesi ile satın alma yapmanızı sağlayalım.\r\n\r\n<strong>YERİNDE TESPİT</strong>\r\nGüvenlik kamera sistemleri kurulumu ve kameraların montajından önce, sistemi kuracak olanların yerinde tespit yapması yararlı olacaktır. Kameraların nereye kurulacağı veya kurulması gerektiği bu keşif işlemiyle belirlenmelidir.\r\n\r\nBu noktada yerinde tespit ve keşfin önemine de değinmek gerekir. Yapılan en büyük hatalardan biri güvenlik kamera sistemini satın aldıktan sonra kurulum planı yapmaktır. Bu durum vahim sonuçlar doğuracak hatalara neden olabilir. Yapılacak yerinde tespit ve keşif ise ihtiyaçları tam manası ile ortaya çıkartır. Kaç kameraya ihtiyaç duyulacağı, kameraların nerelere konuşlandırılması gerekli şekil de detaylar yerinde tespit ile anlaşılabilir.\r\n\r\nGüvenlik kamera sistem kurulumu istiyorsanız bizi arayın, önce yerinde tespit yaparak, ihtiyaçlarınızı rasyonel bir biçimde ortaya çıkaralım, kaç adet kameraya ihtiyacınız olduğunu, bu kameraların hangi noktalara kurulması gerektiğini belirleyelim, sonra sisteminizin kurulumunu gerçekleştirelim. Böylece güvenli günleriniz başlasın.", "Kamera Kurulumu", "", "publish", "closed", "closed", "", "kamera-kurulumu", "", "", "2021-08-17 23:56:14", "2021-08-17 20:56:14", "", "0", "https://nauthemes.com/wp/kriate/projects/factory-construction-copy/", "0", "projects", "", "0");
INSERT INTO `nqcpo_posts` VALUES("173", "1", "2020-11-14 11:39:42", "2020-11-14 11:39:42", "Donec scelerisque dolor id nunc dictum, nterdum mauris rhoncus. Aliquam at ultrices nunc. In sem fermentum at lorem in, porta mauris.", "John Doe", "", "publish", "closed", "closed", "", "john-doe", "", "", "2020-11-14 11:39:42", "2020-11-14 11:39:42", "", "0", "https://nauthemes.com/wp/kriate/?post_type=testimonial&amp;p=173", "0", "testimonial", "", "0");
INSERT INTO `nqcpo_posts` VALUES("177", "1", "2020-11-14 11:39:44", "2020-11-14 11:39:44", "Donec scelerisque dolor id nunc dictum, nterdum mauris rhoncus. Aliquam at ultrices nunc. In sem fermentum at lorem in, porta mauris.", "Bethna Walsh", "", "publish", "closed", "closed", "", "john-doe-copy", "", "", "2020-11-14 11:39:44", "2020-11-14 11:39:44", "", "0", "https://nauthemes.com/wp/kriate/testimonial/john-doe-copy/", "0", "testimonial", "", "0");
INSERT INTO `nqcpo_posts` VALUES("178", "1", "2020-11-14 11:40:30", "2020-11-14 11:40:30", "Donec scelerisque dolor id nunc dictum, nterdum mauris rhoncus. Aliquam at ultrices nunc. In sem fermentum at lorem in, porta mauris.", "Smith Kliss", "", "publish", "closed", "closed", "", "smith-kliss", "", "", "2020-11-14 11:40:30", "2020-11-14 11:40:30", "", "0", "https://nauthemes.com/wp/kriate/testimonial/john-doe-copy-copy/", "0", "testimonial", "", "0");
INSERT INTO `nqcpo_posts` VALUES("206", "1", "2020-11-10 12:50:03", "2020-11-10 09:50:03", "<h1><strong>Ankara kamera ve alarm sistemleri</strong></h1>\r\nYaşadığımız çağda, geldiğimiz noktada ekonomik ve sosyal krizin etkisiyle yaşam alanlarımızda insanların birbirine güvenleri gittikçe azalmaya başladı.\r\n\r\nOrtaya çıkan güvensizlik tablosu içinde kurum ve aileler <strong>güvenlik sistemleri</strong> hizmetleri almaya başlamışlardır.\r\n\r\nÖnemi arttıkça, gelişen yeni teknolojilerle beraber yaşam alanlarınızı, çalışma ortamlarınızı, yakından ya da uzaktan takip ve kontrol edebilirsiniz.\r\n\r\nİşletmelerinizde çalışanlarınızın, yaşam alanlarınızda temizlikçi, hizmetli ya da çocuğunuzun bakıcılarının günlük, saatlik durumlarını rahatlıkla izleyerek, herhangi bir olumsuz durumda müdahale etme şansına sahip olabilmektesiniz.\r\n\r\n<strong>Ankara kamera sistemleri </strong>sektörüne öncülük eden bir firma olarak Ankara<strong> güvenlik sistemleri şirketleri </strong>arasında Ankara ve çevresinde <em>kamera güvenlik sistemleri</em>, <em>akıllı ev sistemleri</em>, <em>alarm takip merkezi</em>, <em>hırsız alarm sistemleri</em>, <em>trafo hırsız alarm sistemleri</em> ve <em>araç takip sistemleri (GPS)</em> hizmetlerini en iyi kalitede müşterilerine sunmaktadır.\r\n\r\nSürekli kendini yenileyen, geliştiren bir unsur olan teknolojinin beraberinde getirdiği her yenilik müşterilerimize en kısa sürede sunulmaktadır.\r\n\r\n<strong>Kamera sistemleri Ankara</strong> güvenlik sistemlerinin temelinde olan söylenilse de eyleme geçildiğinde tam olarak anlaşılan gizlilik politikamızla müşterilerimizin güvenliği ve memnuniyeti her zaman ilk sırada yer almaktadır.\r\n\r\nBünyemizde bulunan alanında uzman, tecrübeli ekibimiz, kaliteli ürünlerimizle en uygun Ankara<strong> kamera sistemleri fiyatları </strong>ve <strong>alarm sistemleri Ankara fiyatları </strong>ile en iyiyi hak eden müşterilerimize en iyi hizmeti sunmaktadır.\r\n\r\nBununla beraber<strong> kamera güvenlik sistemleri </strong>konusunda desteğe ihtiyaç duyduğunuzda – bu ilk defa ihtiyaç duyduğunuz anlamına da gelebilir ya da var olan güvenlik sisteminizi yenilemek anlamına da gelebilir – uzmanlığımız ve tecrübemiz ile fark yaratan firmamızdan gereken alan keşfi, proje ve iyileştirme aşamalarına dair verdiğimiz hizmetlerden yararlanabilirsiniz.\r\n\r\n&nbsp;\r\n<h2 id=\"toc-item-0\">Ankara\'da Kamera ve Alarm Sistemleri Alacaklara Tavsiyeler</h2>\r\nSiz değerli müşterilerimizden özellikle bir detayı rica ediyoruz. <strong>Güvenlik sistemleri şirketleri </strong>arasında bizim firmamız da dâhil almayı düşündüğünüz güvenlik sistemi hizmetlerinde gelecek olan sinyalleri doğru değerlendirip ilgili yönlendirmeleri yapabilecek kapasiteye sahip profesyoneller tarafından haftanın her günü ve her saati hizmet verebilen bir <strong>güvenlik sistemleri firması </strong>ile çalıştığınızdan emin olmalısınız.\r\n\r\n&nbsp;\r\n\r\n<strong>Ankara Güvenlik Sistemleri Şirketleri Arasından Sıyrılarak Farkımızı Hizmet Kalitemizle Gösteriyoruz</strong>\r\n\r\n&nbsp;\r\n<h2 id=\"toc-item-1\">Ankara Güvenlik Kamera Firmaları Araştırılırken Dikkat Edilmesi Gerekenler</h2>\r\nÇevremizden ve müşterilerimizden özellikle sıkça duyduğumuz konu, hizmetlerin satışından sonraki aşamalarda gereken satış sonrası destek, teknik hizmetlerde sorun yaşandığı, bunun da müşteri merkezli hizmet verme taahhüdünü yerine getiremeyen <strong>güvenlik sistemleri firmaları</strong> ile karşı karşıya kalındığı olmaktadır.\r\n\r\n<strong>Ankara kamera ve alarm sistemleri</strong> bünyemizde size sunmuş olduğumuz güvenlik sistemi ürünleri gibi global standartlara uygun ürün ve hizmet sunan firmalar ile işbirliği içerisinde olmak, kendinizi bir kat daha güvenceye almanızı sağlayacaktır.\r\n\r\n<strong>Alarm Sistemleri Ankara </strong>ve çevresinde sunulan ürün ve hizmetlerin yetkili servis gibi bakım-onarım garantisi olup olmadığına iyice bakılmalıdır.\r\n\r\nYaşam alanlarınızda kullanmak üzere hizmetini aldığınız alarm ya da diğer güvenlik sistemi ürünlerini, sensörleri mutlaka uzman bir yetkili eşliğinde oluşturarak kurulumunu gerçekleştirin.\r\n\r\nBunu yaparak hizmetini aldığınız <em>kamera güvenlik sistemleri</em>, <em>alarm güvenlik sistemleri</em> gibi ürünlerden en yüksek kalitede hizmet almış ve ileride oluşabilecek yanlış alarm durumlarını da minimuma indirmiş olacaksınız.\r\n\r\nNe kadar önemli bir unsurdan bahsettiğimizin farkında olduğunuzu düşünerek sensörlerin tasarım, montajı konusunda yetkili uzman ekipler tarafından oluşturulmuş olması <strong>Ankara güvenlik sistemleri şirketleri </strong>arasındaki rekabeti bitirerek en iyi <strong>güvenlik sistemleri</strong> firmasının aralarından sıyrılarak yükselmesini sağlayacaktır.\r\n\r\nBünyemizde sizlere sunmuş olduğumuz tüm güvenlik sistemleri ürün ve hizmetlerimizin kalitesinden hiçbir zaman şüphe duymamakla beraber, her zaman gelişen teknolojileri ürünlerimize, hizmetlerimize hemen adapte ederek en uygun <strong>Ankara kamera sistemleri fiyatları, alarm sistemleri Ankara fiyatları </strong>ile gönül rahatlığıyla sizlere sunmaktayız.", "Ankara kamera ve alarm sistemleri", "", "publish", "open", "open", "", "ankara-kamera-ve-alarm-sistemleri", "", "", "2021-08-18 02:14:18", "2021-08-17 23:14:18", "", "0", "https://nauthemes.com/wp/kriate/?p=206", "0", "post", "", "0");
INSERT INTO `nqcpo_posts` VALUES("218", "1", "2020-11-12 12:54:32", "2020-11-12 09:54:32", "<div class=\"rhd-all-article-detail \">\r\n\r\nGünümüzde çok farklı kaynaklar üzerinden elektrik üretimi sağlanmaktadır. Bu kaynaklar; hidro enerji, termik kaynaklar, nükleer kaynaklar ve yenilenebilir enerji kaynaklardır. Her biri kendi içerisinde geniş bir yelpazeye ayrılan bu kaynaklar içerisinde; doğalgaz, kömür, nükleer ve petrol en önemli enerji kaynakları arasında bulunmaktadır.\r\n\r\nElektrik, doğada bulunan elektrik yüklerinin birbiri ile kaynaşması sonucunda iç içe geçme ve birleşmesi ile oluşan enerjidir. İletken bir telin, manyetik alan içinde hareket ettirilmesi sureti ile elektrik üretimi gerçekleşmektedir. Elektrik akımının üretimi için ise elektrik jeneratörü kullanılmaktadır. Güçlü enerji üretimi sırasında etkin bir biçimde dönebilme için büyük çaplı güç santrallerine gerek duyulmakta olup bu santrallerin kullanımı tercih edilmektedir.\r\n\r\nGüç santralleri bünyesinde üretilen sıvılar, buharlaşma yolu ile ısı üreten bir mekanizmaya dönüşür. Oluşan ısı ile birlikte elektrik üretilebilmesi amacı ile elektrik jeneratörlerinin dönmesine olanak vermektedir. Bu büyük ölçekli işlem ile türbinlerin dönebilmesi için çok yüksek oranda buhar üzerinden ısı enerjisi oluşturulmaktadır. Böylelikle sağlıklı bir biçimde elektrik üretimi yapılmaktadır. Bununla birlikte özel sistemler dahilinde saklama olanağı bulunmaktadır.\r\n\r\n</div>\r\n<div id=\"taboola-below-article-thumbnails_desktop1_hurriyet\" class=\" trc_related_container trc_spotlight_widget trc_elastic trc_elastic_thumbnails-b \" data-placement-name=\"Below Article Thumbnails_desktop1_hurriyet\" data-tb-region=\"haber-taboola-1\">\r\n<div class=\"trc_rbox_container\">\r\n<div>\r\n<div id=\"trc_wrapper_66731\" class=\"trc_rbox thumbnails-b trc-content-sponsored \">\r\n<div id=\"trc_header_66731\" class=\"trc_rbox_header trc_rbox_border_elm\">\r\n<div class=\"trc_header_ext\"></div>\r\n</div>\r\n<div id=\"outer_66731\" class=\"trc_rbox_outer\">\r\n<div id=\"rbox-t2m\" class=\"trc_rbox_div trc_rbox_border_elm\">\r\n<div id=\"internal_trc_66731\">\r\n<div class=\"videoCube trc_spotlight_item origin-default thumbnail_top syndicatedItem textItem videoCube_1_child trc-first-recommendation trc-spotlight-first-recommendation trc_excludable \" data-item-id=\"~~V1~~45985389311215359~~uR1f9J1D7xCB0r_HF-IpyWzNpf95t7BPMfjEJ23inUkndpXq_nTToVci-tV_1bYyPVPbFHdycXfyr1VxmozLcV7JbGFbjtizQN29Zpin8p1JlawpbYFtoRw_FVSAoDPy8yoVX_ZV1DUzrU9mgEqIxVpt34vkyVLCqQj-j_6Ik-WFwt9_72reDSrMsTKuuUo5_hcb18JezUGJR5am0BfSbv9H1GVwszBKMBuJmbBovnXdWvxxDdLsBF9jVNZlLMHltNwfQBS8CEYHkmENTBJXujwBwbVzqx5qDQAj-sfT0DlpPYrMUEQhp9i8Smwq-Ic4\" data-item-title=\"Eğer bilgisayarın varsa bu oyunu denemelisin!\" data-item-thumb=\"https://gallery-pl.go-game.io/uploads/2020/05/RAD_AngerManagement_GameplayRecut_B81208_1000x600_NoOS_English&amp;IMG=1QNS.jpg\" data-item-syndicated=\"true\" data-tb-region-item=\"\">\r\n<div class=\"thumbBlock_holder\"></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>", "Elektrik Nasıl Oluşur ve Üretilir?", "", "publish", "closed", "closed", "", "elektrik-nasil-olusur-ve-uretilir", "", "", "2021-08-18 02:13:57", "2021-08-17 23:13:57", "", "0", "https://nauthemes.com/wp/kriate/2020/11/14/models-oem-solution-simul-corporation-copy-copy-copy-copy-copy-copy/", "0", "post", "", "0");
INSERT INTO `nqcpo_posts` VALUES("219", "1", "2020-11-14 12:54:37", "2020-11-14 09:54:37", "Bir akımın elektronlar sayesinde serbest bir ortam içerisinde çekim gücüyle belli bir noktaya doğru hareket etmesi ile oluşan enerjiye elektrik denilmektedir. Elektrikli makinelerin ve aletlerin çalışması, elektrik akımı ile voltaj oluşturulması ile gerçekleştirilmektedir. Cisimler, atom ve moleküllerden meydana gelen birimlerdir.\r\n\r\nBir cismin parçalara ayrılması neticesinde o cisme özelliğini veren en küçük birimin atom ile moleküllerden oluşması ortaya çıkmaktadır. Atomlar, merkezinde yer alan pozitif yüklü protonlar ve yüksüz nötronlardan oluşan çekirdek ile çevresindeki çok sayıda negatif yüklü elektron bulutundan meydan gelirler. Bu atomların dışında bulunan elektronlar; ısı, manyetik alan ve kimyasal bir takım reaksiyonlarla yörüngelerinden koparak serbest bir biçim alırlar. Serbest olan elektronlar sayesinde oluşan enerjinin hareket etmesi elektriği ortaya çıkarır.\r\n\r\nElektrik akımı, voltajı oluştururken serbest elektronlardan yararlanmaktadır. Elektrik, elektrik yüklerinin akışına dayanan bir dizi fiziksel olay olarak da adlandırılmaktadır. Elektrik kelime olarak Türkçeye Fransızcadan geçmiştir. Türkçe eş anlamlısı ise çıngı kelimesidir. Elektrik pek çok değişik türlerde var olabilmektedir. Örneğin durgun elektrik, yıldırımlar, elektrik akımı ve elektromanyetik indüksiyon gibidir. Ayrıca elektrik, elektromanyetik radyasyon, radyo dalgaları gibi durumların oluşumlarına da yol açmaktadır.\r\n\r\nAntik çağlardan bu yana elektrik olayı ilgi ve merakla araştırılmaktadır. Elektriğin teorik olarak anlaşılması, on yedinci ve on sekizinci yüzyıla kadar uzanmaktadır. Elektriğin endüstri başta olmak üzere yaygın bir kullanım ağı için uygun hale gelmesi ise on dokuzuncu yüzyılda gerçekleşmiştir. Elektrik zamanla ulaşım, sağlık, sanayi, endüstri, ısıtma, aydınlatma, turizm, iletişim ve teknolojik alet ve makinelerde elektrik geniş bir şekilde kullanılmaktadır.\r\n\r\nElektriği ilk bulan kişi, tarihi kaynaklara göre Thales\'dir. Thales, M.Ö. 624-546 yıllarında yaptığı çalışmalarda kehribarın yün ile sarıldığı zaman, ovulma ile birlikte eşyaların birbirini çektiğini ve kıvılcım çıkardığını gözlemlemiştir. Bilim ve teknolojik ilerlemeler ışığında elektrik, günlük yaşamın en mühim kaynakları arasına girmiştir.", "Elektrik Nedir?", "", "publish", "closed", "closed", "", "elektrik-nedir", "", "", "2026-02-23 06:33:41", "2026-02-23 03:33:41", "", "0", "https://nauthemes.com/wp/kriate/2020/11/14/models-oem-solution-simul-corporation-copy-copy-copy-copy-copy-copy-copy/", "0", "post", "", "0");
INSERT INTO `nqcpo_posts` VALUES("357", "1", "2020-11-27 09:54:10", "2020-11-27 06:54:10", "<img width=\"480\" height=\"610\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Balli-Elektrik-Ankara.jpg\" alt=\"Ankara Ballı Elektrik\" loading=\"lazy\" />															\n			<h2>Hakkımızda</h2>		\n			<h2>Ankara Ballı Elektrik</h2>		\n		<p>Sektördeki faaliyetlerine 1995 senesinde Ankara ilinde başlayan Ankara Ballı Elektrik, Ayvalı, Etlik, Keçiören ilk sırada olmak üzere Ankara ilinde elektrik tesisatı, elektrik arıza bakımı, uydu sistemleri, diyafon sistemleri, kamera sistemleri alanlarında hizmet sunmaktadır. Kurulduğu günden günümüze nitelikli malzeme ve işçilik öncelikli çalışan Ankara Ballı Elektrik firması olarak müşteri memnuniyetini her zaman ilk planda tutmaktayız. Ankara elektrikçi iş ilanları yardımı ile bizlere 7/24 ulaşabilirsiniz. Ayırca elektrikçi Ankara Çankaya ya da Ankara Kızılay Elektrikçi firması aramanıza gerek kalmadan ihtiyaçlarınıza çözüm üretebiliyoruz. Kısaca Ankara elektrik tamircisi aramanıza gerek kalmadan Ballı Elektrik olarak tüm elektrik arızalarınızı profesyonel ekibimiz ile çözüyoruz.</p><p>Yılların verdiği tecrübeyle sizlere hizmet sunan uzman ekibimiz, doğru malzeme, doğru ekipman ve nitelikli işçilik anlayışı ile çalışmakta ve sizin istekleriniz doğrultusunda hızlı çözümler üretmektedir.<br /><br />Ballı Keçiören elektrikçi 7/24 365 gün hizmetinizdeyiz. Keçiören elektrik işlerinizi Ballı Elektrik hızlı bir biçimde çözüme ulaştırıyoruz. Ayrıca Keçiören uydu çözümleriyle de piyasaya liderdik ediyoruz. Ankara elektrikçi firmaları arasında Ballı Elektrik olarak müşterilerimize nitelikli hizmet sunmaya devam etmekteyiz. Ayrıca Etlik elektrikçi, Aycalı elektrikçi olarak da bize ulaşabilirsiniz. </p>		\n															<img width=\"480\" height=\"610\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Balli-Elektrik-Ankara.jpg\" alt=\"Ankara Ballı Elektrik\" loading=\"lazy\" />															\n		<p>Ankara bölgesinde tüm ilçelere hizmet vermekteyiz. Uygun fiyata hizmet sunarak müşterilerimizi memnun ediyoruz. Her zaman müşteri merkezli hizmet vermekteyiz. Ayvalı Mahallesi Ayvalı caddesi üstünde bulunan firmamıza gelerek elektrik işleriniz için teklif alabilir ve piyasada bulunan diğer elektrikçi şirketleri ile kıyaslama yapabilirsiniz. Böylece kalitemizden ve uygun maliyetli elektrik, uydu, diafon, diyafon gibi hizmetlerimizden emin olabilirsiniz.<br /><br />Sağladığımız hizmetlerden bazıları ;<br /><br />- Elektrik ve elektronik malzeme satışı,<br /><br />- Uydu anten kurulumu,<br /><br />- Elektrik tesisatı,<br /><br />- Görüntülü Diafon sistemleri,<br /><br />- Güvenlik Kamera Sitemleri<br /><br />kurulum, montaj , bakım ve arızalarıdır.<br /><br />En çok hizmet vermiş olduğumuz bölgeler: Ankara Elektrikçi, Keçiören Elektrikçi, Etlik Elektrikçi, Esertepe Elektrikçi, İncirli Elektrikçi, En yakın elektrikçi, Çankaya Elektrikçi, Sancaktepe Elektrikçi, Yayla Mahallesi Elektrikçi, Yükseltepe Elektrikçi, Ufuktepe Elektrikçi, Şenlik Mahallesi Elektrikçi, Ovacık Elektrikçi, Karşıyaka Elektrikçi, Atapark Elektrikçi, Yeşiltepe Elektrikçi, Yakacık Mahallesi Elektrikçi, Tepebaşı Elektrikçi, Şehit Kubilay Elektrikçi, Basınevler Elektrikçi, Bademlik Elektrikçi, Aşağı Eğlence Elektrikçi, Uyanış Mahallesi Elektrikçi, Şenyuva Elektrikçi, Pınarbaşı Elektrikçi, Kuşcağız Elektrikçi, Bağlum Elektrikçi, Pursaklar Elektrikçi, Bahçelievler Elektrikçi, Kızılay Elektrikçi, Elektrikçi Etimesgut, Sıhhıye Elektrikçi, Ulus Elektrikçi, Mamak Elektirkçi, Sincan Elektirikçi, Yenimahalle Elektrikçi</p>		\n	<section>\n																					<h2>26<sup>+</sup></h2>\n																														<h4>Yıllık Tecrübe</h4>\n																					<h2>502<sup>+</sup></h2>\n																														<h4>Tamamlanmış Proje</h4>\n																					<h2>120<sup>+</sup></h2>\n																														<h4>Güvenlik Kamerası</h4>\n																					<h2>12<sup>+</sup></h2>\n																														<h4>Devam Eden Proje</h4>\n												<!-- Facts Wrap -->\n	</section>", "Hakkımızda", "", "publish", "closed", "closed", "", "hakkimizda", "", "", "2021-08-18 01:05:23", "2021-08-17 22:05:23", "", "0", "https://nauthemes.com/wp/kriate/?page_id=357", "0", "page", "", "0");
INSERT INTO `nqcpo_posts` VALUES("395", "1", "2020-11-27 10:25:26", "2020-11-27 07:25:26", "<section>\n						Ankara Ballı Elektrik						<h2>Sağladığımız Hizmetler</h2>						<p>Ballı elektrik bünyesinde sunmuş olduğu güvenlik kamera sistemleri kurulum montaj arıza onarım ve bakımı , uydu anten kurulumu, uydu kanalları kurulumu, uydu ekipman ve malzemeleri satışı , Görüntülü diafon sistemleri kurulumu, değişimi, yeni binalarda şartnamelerde bulunan isteklerin karşılanması , elektrik arıza tesisat çekimi, yeni pano kurulumu gibi hizmetler ile siz değerli müşterilerimize faydalı olmaya çalışmaktayız.</p>					\n				<!-- Services Wrap -->\n	</section>\n			<figure><img width=\"512\" height=\"375\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2020/11/unnamed.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>Kamera Kurulum</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nGüvenlik kamera İhtiyaçlarınız doğrultusunda sizlere en yenilikçi alternatifleri sunuyoruz.</p>		\n			<figure><img width=\"500\" height=\"334\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/5cc71fea0f2bc155655370675.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>Telefon Ankastre</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nİnternet altyapı hizmetleri arızalarında hızlı ve güvenilir çözüm için bizimle iletişime geçin.</p>		\n			<figure><img width=\"1024\" height=\"683\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Elektrik-Pana-Montaj-1024x683.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>Elektrik Pano Montaj</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nElektrik tesisatın düzgün çalışması için elektrik pano montaj bağlantıları uzmanlarınca yapılmalıdır.</p>		\n			<figure><img width=\"849\" height=\"565\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Elektrik-Ariza-Tespiti.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>Elektrik Arıza Tespiti</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nMüşterilerimizin elektrik arıza ihtiyaçlarına, en doğru ve alternatif çözümlerle müdahale ediyoruz.</p>		\n			<figure><img width=\"1024\" height=\"686\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Uydu-Anten-Kurulumu-1024x686.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>Uydu Anten Kurulumu</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nAnkara uyducu arayışında olanların tercihi Palaz Elektrik, 7/24 kesintisiz hizmet veriyor.</p>		\n			<figure><img width=\"1024\" height=\"683\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/5cc715cdb5680155655111758-1024x683.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>İnşaat Elektrik Projeleri</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nİnşaat sektöründe birçok elektrik proje işini tamamlayan firmamız, her geçen gün daha da büyüyor.</p>		\n	<section>\n																					<h2>26<sup>+</sup></h2>\n																														<h4>Yıllık Tecrübe</h4>\n																					<h2>502<sup>+</sup></h2>\n																														<h4>Tamamlanmış Proje</h4>\n																					<h2>120<sup>+</sup></h2>\n																														<h4>Güvenlik Kamerası</h4>\n																					<h2>12<sup>+</sup></h2>\n																														<h4>Devam Eden Proje</h4>\n												<!-- Facts Wrap -->\n	</section>\n		<section>\n						<h2>Talepleriniz İçin Bizimle İletişime Geçebilirsiniz.</h2>						<p>Taleplerinize Dilerseniz İletişim Sayfamızdan veya ofisimizde kahvemizi içerken yardımcı olabiliriz.</p>						<a href=\"http://localhost:8888/ballielektrik/iletisim\" title=\"\">İLETİŞİM</a>					\n				<!-- Banner Wrap -->\n	</section>", "Hizmetlerimiz", "", "publish", "closed", "closed", "", "hizmetlerimiz", "", "", "2021-08-18 01:11:50", "2021-08-17 22:11:50", "", "0", "https://nauthemes.com/wp/kriate/?page_id=395", "0", "page", "", "0");
INSERT INTO `nqcpo_posts` VALUES("413", "1", "2020-11-27 10:38:44", "2020-11-27 07:38:44", "<section>\n										Ankara Ballı Elektrik\n										<h3>Sıkça Sorulan Sorular</h3>\n										<img src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Balli-Elektrik-Ankara.jpg\" alt=\"FAQ Image\">\n															<h4>01.Hangi Bölgelere Hizmet Veriyorsunuz?</h4>\n															<p>Ankara\'nın tüm ilçe ve semtlerine hizmetimiz vardır.</p>\n															<h4>02.Elektrik Sigortam Sürekli Atıyor Ne Yapmalıyım?</h4>\n															<p>Sigortanın beslediği devreden geçen akım belli bir değerin üzerine çıktığında devreye bağlı alıcıların zarar görmesini engellemek için elektrik sigortası atar ve bu sayede oluşabilecek yangın, kaza ve arızaların önüne geçilmiş olur. Elektrik olan hemen her yerde kullanılan sigorta güvenlik ve emniyet açısından hayati öneme sahiptir. Eğer sigortanız sürekli atıyorsa öncelikle ilgili mahalde takılı bulunan tüm fişleri prizden çekin ve sigortayı tekrar kaldırmayı deneyin. Eğer düzelmediyse hattınızda veya sigortanızda arıza meydana gelmiş olabilir. Bu konuda uzman ekibizden destek alabilirsiniz.</p>\n															<h4>03.Mesai Saatleri Dışında veya Acil Durumlar Gibi Durumlarda Servisiniz Var Mı?</h4>\n															<p>Yaşanabilecek arızalara karşı mesai saatleri dışında ve acil durumlarda servis hizmeti sunuyoruz. </p>\n															<h4>04.Yaptığınız İşlere Garanti Veriyor Musunuz?</h4>\n															<p>İmzamızın bulunduğu küçük büyük tüm projelerimize işçilik garantisi veriyoruz. Müşterilerimizin merdiven altı diye tabir edilen yerlerde üretilen malzeme tercihlerine karşın herhangi bir garanti vermemekteyiz. </p>\n															<h4>05.Elektrik Çarpmasına Ne Neden Olur?</h4>\n															<p>Çıplak teller, yanlış onarım ve hatta arızalı cihazlar çarpılmalara neden olabilir. Tesisatınız hakkında endişeleriniz varsa, herhangi bir sorunu önlemek ve tesisatınızı incelemek için bir profesyonel arayın.  </p>\n                        <!-- Faq Wrap -->\n            </section>", "Sss", "", "publish", "closed", "closed", "", "sss", "", "", "2021-08-18 02:02:07", "2021-08-17 23:02:07", "", "0", "https://nauthemes.com/wp/kriate/?page_id=413", "0", "page", "", "0");
INSERT INTO `nqcpo_posts` VALUES("436", "1", "2020-11-28 09:11:18", "2020-11-28 06:11:18", "<section>\n											<h4>Telefon</h4><p>0541 560 89 18</p>\n											<h4>E-Posta</h4><p> Email: info@ballielektrik.com</p>\n											<h4>Adres</h4><p>Eserte Mah. 312. Sok. 16/2 Keçiören/ANKARA</p>\n	</section>		\n		<section>\n								Ankara Ballı Elektrik\n								<h2>Ankara Ballı Elektrik</h2>\n								<p>Yukarıdaki iletişim bilgilerimizi veya alttaki iletişim formunu kullanarak bizlere ulaşabilirsiniz.</p>\n											<p>\n<p role=\"status\" aria-live=\"polite\" aria-atomic=\"true\"></p> <ul></ul>\n<form action=\"/wp-admin/admin-ajax.php#wpcf7-f1172-o1\" method=\"post\" novalidate=\"novalidate\" data-status=\"init\">\n<input type=\"hidden\" name=\"_wpcf7\" value=\"1172\" />\n<input type=\"hidden\" name=\"_wpcf7_version\" value=\"5.4.2\" />\n<input type=\"hidden\" name=\"_wpcf7_locale\" value=\"en_US\" />\n<input type=\"hidden\" name=\"_wpcf7_unit_tag\" value=\"wpcf7-f1172-o1\" />\n<input type=\"hidden\" name=\"_wpcf7_container_post\" value=\"0\" />\n<input type=\"hidden\" name=\"_wpcf7_posted_data_hash\" value=\"\" />\n<input type=\"text\" name=\"text-46\" value=\"\" size=\"40\" aria-required=\"true\" aria-invalid=\"false\" placeholder=\"Adınız Soyadınız\" />\n<input type=\"email\" name=\"email-205\" value=\"\" size=\"40\" aria-required=\"true\" aria-invalid=\"false\" placeholder=\"E-Posta Adresiniz\" />\n<input type=\"tel\" name=\"tel-510\" value=\"\" size=\"40\" aria-required=\"true\" aria-invalid=\"false\" placeholder=\"Telefon Numaranız\" />\n<textarea name=\"textarea-810\" cols=\"40\" rows=\"10\" aria-invalid=\"false\" placeholder=\"Mesajınız\"></textarea>\n<input type=\"submit\" value=\"Gönder\" />\n</form></p>\n					<!-- Contact Wrap -->\n	</section>", "İletişim", "", "publish", "closed", "closed", "", "iletisim", "", "", "2021-08-18 22:17:32", "2021-08-18 19:17:32", "", "0", "https://nauthemes.com/wp/kriate/?page_id=436", "0", "page", "", "0");
INSERT INTO `nqcpo_posts` VALUES("474", "1", "2020-11-28 09:57:56", "2020-11-28 09:57:56", "", "Layla Gabriella", "", "publish", "closed", "closed", "", "layla-gabriella", "", "", "2020-11-28 09:57:56", "2020-11-28 09:57:56", "", "0", "https://nauthemes.com/wp/kriate/?post_type=team&amp;p=474", "0", "team", "", "0");
INSERT INTO `nqcpo_posts` VALUES("476", "1", "2020-11-28 09:58:45", "2020-11-28 09:58:45", "", "Kyle Johnson", "", "publish", "closed", "closed", "", "kyle-johnson", "", "", "2020-11-28 09:58:45", "2020-11-28 09:58:45", "", "0", "https://nauthemes.com/wp/kriate/?post_type=team&amp;p=476", "0", "team", "", "0");
INSERT INTO `nqcpo_posts` VALUES("477", "1", "2020-11-28 09:59:15", "2020-11-28 09:59:15", "", "Shiela Down", "", "publish", "closed", "closed", "", "shiela-down", "", "", "2020-11-28 09:59:15", "2020-11-28 09:59:15", "", "0", "https://nauthemes.com/wp/kriate/?post_type=team&amp;p=477", "0", "team", "", "0");
INSERT INTO `nqcpo_posts` VALUES("478", "1", "2020-11-28 09:59:48", "2020-11-28 09:59:48", "", "John Epic", "", "publish", "closed", "closed", "", "john-epic", "", "", "2020-11-28 09:59:48", "2020-11-28 09:59:48", "", "0", "https://nauthemes.com/wp/kriate/?post_type=team&amp;p=478", "0", "team", "", "0");
INSERT INTO `nqcpo_posts` VALUES("479", "1", "2020-11-28 10:00:17", "2020-11-28 10:00:17", "", "Niel Favors", "", "publish", "closed", "closed", "", "niel-favors", "", "", "2020-11-28 10:00:17", "2020-11-28 10:00:17", "", "0", "https://nauthemes.com/wp/kriate/?post_type=team&amp;p=479", "0", "team", "", "0");
INSERT INTO `nqcpo_posts` VALUES("480", "1", "2020-11-28 10:00:47", "2020-11-28 10:00:47", "", "Riffiy ElDoe", "", "publish", "closed", "closed", "", "riffiy-eldoe", "", "", "2020-11-28 10:00:47", "2020-11-28 10:00:47", "", "0", "https://nauthemes.com/wp/kriate/?post_type=team&amp;p=480", "0", "team", "", "0");
INSERT INTO `nqcpo_posts` VALUES("481", "1", "2020-11-28 10:01:29", "2020-11-28 10:01:29", "", "Miskin Shaw", "", "publish", "closed", "closed", "", "miskin-shaw", "", "", "2020-11-28 10:01:29", "2020-11-28 10:01:29", "", "0", "https://nauthemes.com/wp/kriate/?post_type=team&amp;p=481", "0", "team", "", "0");
INSERT INTO `nqcpo_posts` VALUES("482", "1", "2020-11-28 10:01:57", "2020-11-28 10:01:57", "", "Channing Hew", "", "publish", "closed", "closed", "", "channing-hew", "", "", "2020-11-28 10:01:57", "2020-11-28 10:01:57", "", "0", "https://nauthemes.com/wp/kriate/?post_type=team&amp;p=482", "0", "team", "", "0");
INSERT INTO `nqcpo_posts` VALUES("483", "1", "2020-11-28 10:02:40", "2020-11-28 10:02:40", "", "Fisher Strong", "", "publish", "closed", "closed", "", "fisher-strong", "", "", "2020-11-28 10:02:40", "2020-11-28 10:02:40", "", "0", "https://nauthemes.com/wp/kriate/?post_type=team&amp;p=483", "0", "team", "", "0");
INSERT INTO `nqcpo_posts` VALUES("484", "1", "2020-11-28 10:03:11", "2020-11-28 10:03:11", "", "Nelson Field", "", "publish", "closed", "closed", "", "nelson-field", "", "", "2020-11-28 10:03:11", "2020-11-28 10:03:11", "", "0", "https://nauthemes.com/wp/kriate/?post_type=team&amp;p=484", "0", "team", "", "0");
INSERT INTO `nqcpo_posts` VALUES("523", "1", "2019-01-16 13:01:52", "2019-01-16 13:01:52", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Wire Crusher", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "wire-crusher", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "0", "https://woocommercecore.mystagingwebsite.com/product/v-neck-t-shirt/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("524", "1", "2019-01-16 13:01:52", "2019-01-16 13:01:52", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Driller Machine", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "driller-machine", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "0", "https://woocommercecore.mystagingwebsite.com/product/hoodie/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("525", "1", "2019-01-16 13:01:52", "2019-01-16 13:01:52", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Screw Molder", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "screw-molder", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "0", "https://woocommercecore.mystagingwebsite.com/product/hoodie-with-logo/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("526", "1", "2019-01-16 13:01:52", "2019-01-16 13:01:52", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Wiring Tools", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "wiring-tools", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "0", "https://woocommercecore.mystagingwebsite.com/product/t-shirt/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("527", "1", "2019-01-16 13:01:52", "2019-01-16 13:01:52", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Electric Screwier", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "electric-screwier", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "0", "https://woocommercecore.mystagingwebsite.com/product/beanie/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("528", "1", "2019-01-16 13:01:52", "2019-01-16 13:01:52", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Gloves & Helmet", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "gloves-helmet", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "0", "https://woocommercecore.mystagingwebsite.com/product/belt/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("529", "1", "2019-01-16 13:01:53", "2019-01-16 13:01:53", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Heavy Duty Torch", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "heavy-duty-torch", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://woocommercecore.mystagingwebsite.com/product/cap/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("530", "1", "2019-01-16 13:01:53", "2019-01-16 13:01:53", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "AI Controller", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "ai-controller", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://woocommercecore.mystagingwebsite.com/product/sunglasses/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("531", "1", "2019-01-16 13:01:53", "2019-01-16 13:01:53", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Machinery Crane", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "machinery-crane", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://woocommercecore.mystagingwebsite.com/product/hoodie-with-pocket/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("532", "1", "2019-01-16 13:01:53", "2019-01-16 13:01:53", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Assorted Tool Kit", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "tool-kit", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://woocommercecore.mystagingwebsite.com/product/hoodie-with-zipper/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("533", "1", "2019-01-16 13:01:53", "2019-01-16 13:01:53", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Orange Pliers", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "orange-pliers", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://woocommercecore.mystagingwebsite.com/product/long-sleeve-tee/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("534", "1", "2019-01-16 13:01:53", "2019-01-16 13:01:53", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Long Power Cable", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "long-power-cable", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://woocommercecore.mystagingwebsite.com/product/polo/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("535", "1", "2019-01-16 13:01:54", "2019-01-16 13:01:54", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum sagittis orci ac odio dictum tincidunt. Donec ut metus leo. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed luctus, dui eu sagittis sodales, nulla nibh sagittis augue, vel porttitor diam enim non metus. Vestibulum aliquam augue neque. Phasellus tincidunt odio eget ullamcorper efficitur. Cras placerat ut turpis pellentesque vulputate. Nam sed consequat tortor. Curabitur finibus sapien dolor. Ut eleifend tellus nec erat pulvinar dignissim. Nam non arcu purus. Vivamus et massa massa.", "Wire Cutter", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "wire-cutter", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://woocommercecore.mystagingwebsite.com/product/single/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("541", "1", "2019-01-16 13:01:55", "2019-01-16 13:01:55", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Drill Machine", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "drill-machine", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://woocommercecore.mystagingwebsite.com/product/t-shirt-with-logo/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("542", "1", "2019-01-16 13:01:55", "2019-01-16 13:01:55", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Screw Pusher", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "screw-pusher", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://woocommercecore.mystagingwebsite.com/product/beanie-with-logo/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("543", "1", "2019-01-16 13:01:55", "2019-01-16 13:01:55", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Heavy Machine", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "heavy-machine", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://woocommercecore.mystagingwebsite.com/product/logo-collection/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("544", "1", "2019-01-16 13:01:55", "2019-01-16 13:01:55", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "AI Hardware", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "construction-hardware", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://woocommercecore.mystagingwebsite.com/product/wordpress-pennant/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("936", "1", "2020-12-06 12:13:38", "2020-12-06 12:13:38", "", "favicon", "", "inherit", "open", "closed", "", "favicon", "", "", "2020-12-06 12:13:38", "2020-12-06 12:13:38", "", "0", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/12/favicon.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("937", "1", "2020-12-06 12:13:46", "2020-12-06 12:13:46", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/12/cropped-favicon.png", "cropped-favicon.png", "", "inherit", "open", "closed", "", "cropped-favicon-png", "", "", "2020-12-06 12:13:46", "2020-12-06 12:13:46", "", "0", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/12/cropped-favicon.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("1043", "1", "2020-12-12 08:01:38", "2020-12-12 08:01:38", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Yellow Molder", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "yellow-molder", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://nauthemes.com/wp/kriate/?post_type=product&amp;p=1043", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1047", "1", "2020-12-12 08:03:55", "2020-12-12 08:03:55", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Xerox Cutter", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "xerox-cutter", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://nauthemes.com/wp/kriate/?post_type=product&amp;p=1047", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1051", "1", "2020-12-12 08:04:53", "2020-12-12 08:04:53", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Assorted Tools", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "assorted-tools", "", "", "2020-12-12 08:04:53", "2020-12-12 08:04:53", "", "0", "https://nauthemes.com/wp/kriate/?post_type=product&amp;p=1051", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1052", "1", "2020-12-12 08:05:53", "2020-12-12 08:05:53", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Yellow Pliers", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "yellow-pliers", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://nauthemes.com/wp/kriate/?post_type=product&amp;p=1052", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1053", "1", "2020-12-12 08:05:57", "2020-12-12 08:05:57", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Yellow Bucket", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "yellow-bucket", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://nauthemes.com/wp/kriate/?post_type=product&amp;p=1053", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1054", "1", "2020-12-12 08:06:02", "2020-12-12 08:06:02", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Next Heavy", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "next-heavy", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://nauthemes.com/wp/kriate/?post_type=product&amp;p=1054", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1055", "1", "2020-12-12 08:06:03", "2020-12-12 08:06:03", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Tool Box", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "tool-box", "", "", "2020-12-12 08:06:03", "2020-12-12 08:06:03", "", "0", "https://nauthemes.com/wp/kriate/?post_type=product&amp;p=1055", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1056", "1", "2020-12-12 08:06:11", "2020-12-12 08:06:11", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Silver Drill", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "silver-drill", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://nauthemes.com/wp/kriate/?post_type=product&amp;p=1056", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1057", "1", "2020-12-12 08:06:13", "2020-12-12 08:06:13", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Working Machine", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "working-machine", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://nauthemes.com/wp/kriate/?post_type=product&amp;p=1057", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1059", "1", "2020-12-12 08:08:40", "2020-12-12 08:08:40", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "Long Cable", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "long-cable", "", "", "2021-08-09 00:21:07", "2021-08-08 21:21:07", "", "0", "https://nauthemes.com/wp/kriate/?post_type=product&amp;p=1059", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1107", "1", "2020-12-19 10:13:49", "2020-12-19 10:13:49", "", "1920x720", "", "inherit", "open", "closed", "", "1920x720", "", "", "2021-08-09 00:21:04", "2021-08-08 21:21:04", "", "1169", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/12/1920x720.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("1108", "1", "2020-12-19 10:15:07", "2020-12-19 10:15:07", "", "470x530", "", "inherit", "open", "closed", "", "470x530", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "1169", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/12/470x530.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("1113", "1", "2020-12-19 10:37:55", "2020-12-19 10:37:55", "", "570x430", "", "inherit", "open", "closed", "", "570x430", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "1169", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/12/570x430.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("1115", "1", "2020-12-19 10:39:06", "2020-12-19 10:39:06", "", "570x520", "", "inherit", "open", "closed", "", "570x520", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "1169", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/12/570x520.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("1143", "1", "2020-12-19 10:51:47", "2020-12-19 10:51:47", "", "770x470", "", "inherit", "open", "closed", "", "770x470", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "145", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/11/770x470.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("1144", "1", "2020-12-19 10:56:05", "2020-12-19 10:56:05", "", "270x270", "", "inherit", "open", "closed", "", "270x270", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "90", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/11/270x270.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("1145", "1", "2020-12-19 10:56:19", "2020-12-19 10:56:19", "", "270x270", "", "inherit", "open", "closed", "", "270x270-2", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "90", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/11/270x270-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("1146", "1", "2020-12-19 10:56:25", "2020-12-19 10:56:25", "", "270x270", "", "inherit", "open", "closed", "", "270x270-3", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "90", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/11/270x270-2.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("1147", "1", "2020-12-19 10:56:30", "2020-12-19 10:56:30", "", "270x270", "", "inherit", "open", "closed", "", "270x270-4", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "90", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/11/270x270-3.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("1149", "1", "2020-12-19 11:03:08", "2020-12-19 11:03:08", "", "testi", "", "inherit", "open", "closed", "", "testi", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "177", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/11/testi.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("1153", "1", "2020-12-19 11:05:32", "2020-12-19 11:05:32", "", "195", "", "inherit", "open", "closed", "", "195", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "482", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/11/195.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("1157", "1", "2020-12-19 11:13:53", "2020-12-19 11:13:53", "", "500", "", "inherit", "open", "closed", "", "500", "", "", "2021-08-09 00:21:05", "2021-08-08 21:21:05", "", "1059", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/12/500.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("1158", "1", "2020-11-12 14:10:23", "2020-11-12 14:10:23", "", "Default Kit", "", "publish", "closed", "closed", "", "default-kit", "", "", "2020-11-12 14:10:23", "2020-11-12 14:10:23", "", "0", "https://nauthemes.com/wp/kriate/?elementor_library=default-kit", "0", "elementor_library", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1166", "1", "2020-12-19 11:28:37", "2020-12-19 11:28:37", "", "370x570", "", "inherit", "open", "closed", "", "370x570", "", "", "2020-12-19 11:28:37", "2020-12-19 11:28:37", "", "0", "https://nauthemes.com/wp/kriate/wp-content/uploads/2020/12/370x570.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("1169", "1", "2020-11-12 14:27:42", "2020-11-12 11:27:42", "<section>\n<h1>\n													Önceliğimiz Güvenliğiniz													<strong>Ankara Ballı Elektrik</strong><br />\n												</h1>\n<p>Profesyonel kamera sistemleriyle güvenliğiniz bizden sorulur. Hemen iletişime geçebilirsiniz</p>\n<p>												<a href=\"http://localhost:8888/ballielektrik/iletisim\" title=\"\">İletişim</a></p>\n<h1>\n													Elektrik Arıza Tespiti													<strong>Ankara Ballı Elektrik</strong><br />\n												</h1>\n<p>Elektrik Arıza Tespit ve Raporlama için hemen bizimle iletişime geçin</p>\n<p>												<a href=\"http://localhost:8888/ballielektrik/iletisim\" title=\"\">İletişim</a></p>\n<h1>\n													Ailenizin Güvenliği İçin													<strong>Ankara Ballı Elektrik</strong><br />\n												</h1>\n<p>Görüntülü diafon sistemleriyle artık içiniz çok rahat</p>\n<p>												<a href=\"http://localhost:8888/ballielektrik/iletisim\" title=\"\">İletişim</a><br />\n					<!-- Featured Area Wrap --><br />\n			</section>\n<p>															<img loading=\"lazy\" width=\"480\" height=\"610\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Balli-Elektrik-Ankara.jpg\" alt=\"Ankara Ballı Elektrik\" />															</p>\n<h2>Hakkımızda</h2>\n<h2>Ankara Ballı Elektrik</h2>\n<p>		Sektördeki faaliyetlerine 1995 senesinde Ankara ilinde başlayan Ankara Ballı Elektrik, Ayvalı, Etlik, Keçiören ilk sırada olmak üzere Ankara ilinde elektrik tesisatı, elektrik arıza bakımı, uydu sistemleri, diyafon sistemleri, kamera sistemleri alanlarında hizmet sunmaktadır. Kurulduğu günden günümüze nitelikli malzeme ve işçilik öncelikli çalışan Ankara Ballı Elektrik firması olarak müşteri memnuniyetini her zaman ilk planda tutmaktayız. Ankara elektrikçi iş ilanları yardımı ile bizlere 7/24 ulaşabilirsiniz. Ayırca elektrikçi Ankara Çankaya ya da Ankara Kızılay Elektrikçi firması aramanıza gerek kalmadan ihtiyaçlarınıza çözüm üretebiliyoruz. Kısaca Ankara elektrik tamircisi aramanıza gerek kalmadan Ballı Elektrik olarak tüm elektrik arızalarınızı profesyonel ekibimiz ile çözüyoruz.<br />\nYılların verdiği tecrübeyle sizlere hizmet sunan uzman ekibimiz, doğru malzeme, doğru ekipman ve nitelikli işçilik anlayışı ile çalışmakta ve sizin istekleriniz doğrultusunda hızlı çözümler üretmektedir.<br />\nBallı Keçiören elektrikçi 7/24 365 gün hizmetinizdeyiz. Keçiören elektrik işlerinizi Ballı Elektrik hızlı bir biçimde çözüme ulaştırıyoruz. Ayrıca Keçiören uydu çözümleriyle de piyasaya liderdik ediyoruz. Ankara elektrikçi firmaları arasında Ballı Elektrik olarak müşterilerimize nitelikli hizmet sunmaya devam etmekteyiz. Ayrıca Etlik elektrikçi, Aycalı elektrikçi olarak da bize ulaşabilirsiniz.Günümüzün yaşam ritminde istikrarlı elektrik lüks değil, bir gerekliliktir. Özellikle Keçiören, Etlik veya Aylavlu gibi büyük bölgelerde, her dakika kesinti pahalıya mal olabilir. Ankara Ballı Elektrik şirketi, 1995 yılından bu yana uydu antenleri, video gözetim sistemleri ve interkomların kurulumu dahil olmak üzere elektrik sistemleri alanındaki her türlü sorunu çözmektedir. On yıllar süren uygulamalar sonucunda, müşteri konforu ve güvenliği ön planda tutan bir yaklaşım oluşmuştur ve teknik donanım ve ekibin deneyimi, işlerin kaliteli bir şekilde yapılmasını garanti etmektedir.<br />\nİlginçtir ki, diğer hizmet ve eğlence alanlarında da teknolojinin ve kullanıcı deneyiminin hızlı bir gelişimi gözlemlenmektedir. Örneğin, 2024 yılında Avusturya&#8217;da gerçek bir çevrimiçi kumarhane patlaması yaşanmaktadır — yeni platformlar benzersiz işlevler, bonus sistemleri ve yüksek güvenlik seviyesi sunmaktadır. Sektör hızla büyüyor, bununla ilgili daha ayrıntılı bilgiye buradan ulaşabilirsiniz:<br />\n<a href=\"https://www.golf-live.de/tipps-tricks/casino-boom-oesterreich-2024\">golf-live.de</a>. Bu tür kaynaklar, özellikle strateji ve heyecan unsurları içeren ilginç boş zaman geçirme yolları arayan kişiler tarafından rağbet görüyor.<br />\nAnkara Ballı Elektrik&#8217;te olduğu gibi, kalite ve güvenilirliğin öncelikli olduğu yeni Avusturya çevrimiçi kumarhanelerinde de kullanıcılar, modern teknolojileri detaylara gösterilen özenle birleştiren hizmetleri giderek daha fazla tercih etmektedir. Güvenilirlik, alan ne olursa olsun güvenin anahtarıdır.<br />\n															<img loading=\"lazy\" width=\"480\" height=\"610\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Balli-Elektrik-Ankara.jpg\" alt=\"Ankara Ballı Elektrik\" />															</p>\n<section>\n<h2>26<sup>+</sup></h2>\n<h4>Yıllık Tecrübe</h4>\n<h2>502<sup>+</sup></h2>\n<h4>Tamamlanmış Proje</h4>\n<h2>120<sup>+</sup></h2>\n<h4>Güvenlik Kamerası</h4>\n<h2>12<sup>+</sup></h2>\n<h4>Devam Eden Proje</h4>\n<p>												<!-- Facts Wrap --><br />\n	</section>\n<section>\n						Ankara Ballı Elektrik						</p>\n<h2>Sağladığımız Hizmetler</h2>\n<p>Ballı elektrik bünyesinde sunmuş olduğu güvenlik kamera sistemleri kurulum montaj arıza onarım ve bakımı , uydu anten kurulumu, uydu kanalları kurulumu, uydu ekipman ve malzemeleri satışı , Görüntülü diafon sistemleri kurulumu, değişimi, yeni binalarda şartnamelerde bulunan isteklerin karşılanması , elektrik arıza tesisat çekimi, yeni pano kurulumu gibi hizmetler ile siz değerli müşterilerimize faydalı olmaya çalışmaktayız.</p>\n<p>				<!-- Services Wrap --><br />\n	</section>\n<figure><img loading=\"lazy\" width=\"512\" height=\"375\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2020/11/unnamed.jpg\" alt=\"\" /></figure>\n<h3>Kamera Kurulum</h3>\n<p><a title=\"Telefon\" href=\"tel:05415608918\"></p>\n<h6>0541 560 89 18</h6>\n<p></a><br />\nGüvenlik kamera İhtiyaçlarınız doğrultusunda sizlere en yenilikçi alternatifleri sunuyoruz.</p>\n<figure><img loading=\"lazy\" width=\"500\" height=\"334\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/5cc71fea0f2bc155655370675.jpg\" alt=\"\" /></figure>\n<h3>Telefon Ankastre</h3>\n<p><a title=\"Telefon\" href=\"tel:05415608918\"></p>\n<h6>0541 560 89 18</h6>\n<p></a><br />\nİnternet altyapı hizmetleri arızalarında hızlı ve güvenilir çözüm için bizimle iletişime geçin.</p>\n<figure><img loading=\"lazy\" width=\"1024\" height=\"683\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Elektrik-Pana-Montaj-1024x683.jpg\" alt=\"\" /></figure>\n<h3>Elektrik Pano Montaj</h3>\n<p><a title=\"Telefon\" href=\"tel:05415608918\"></p>\n<h6>0541 560 89 18</h6>\n<p></a><br />\nElektrik tesisatın düzgün çalışması için elektrik pano montaj bağlantıları uzmanlarınca yapılmalıdır.</p>\n<figure><img loading=\"lazy\" width=\"849\" height=\"565\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Elektrik-Ariza-Tespiti.jpg\" alt=\"\" /></figure>\n<h3>Elektrik Arıza Tespiti</h3>\n<p><a title=\"Telefon\" href=\"tel:05415608918\"></p>\n<h6>0541 560 89 18</h6>\n<p></a><br />\nMüşterilerimizin elektrik arıza ihtiyaçlarına, en doğru ve alternatif çözümlerle müdahale ediyoruz.</p>\n<figure><img loading=\"lazy\" width=\"1024\" height=\"686\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Uydu-Anten-Kurulumu-1024x686.jpg\" alt=\"\" /></figure>\n<h3>Uydu Anten Kurulumu</h3>\n<p><a title=\"Telefon\" href=\"tel:05415608918\"></p>\n<h6>0541 560 89 18</h6>\n<p></a><br />\nAnkara uyducu arayışında olanların tercihi Palaz Elektrik, 7/24 kesintisiz hizmet veriyor.</p>\n<figure><img loading=\"lazy\" width=\"1024\" height=\"683\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/5cc715cdb5680155655111758-1024x683.jpg\" alt=\"\" /></figure>\n<h3>İnşaat Elektrik Projeleri</h3>\n<p><a title=\"Telefon\" href=\"tel:05415608918\"></p>\n<h6>0541 560 89 18</h6>\n<p></a><br />\nİnşaat sektöründe birçok elektrik proje işini tamamlayan firmamız, her geçen gün daha da büyüyor.</p>\n<section>\n<h2>Talepleriniz İçin Bizimle İletişime Geçebilirsiniz.</h2>\n<p>Taleplerinize Dilerseniz İletişim Sayfamızdan veya ofisimizde kahvemizi içerken yardımcı olabiliriz.</p>\n<p>						<a href=\"http://localhost:8888/ballielektrik/iletisim\" title=\"\">İLETİŞİM</a><br />\n				<!-- Banner Wrap --><br />\n	</section>\n<section>\n						Blog Yazılarımız</p>\n<h3>Son Makaleler</h3>\n<ul>\n<li>Ağu 22, 2025</li>\n<li>0 Comments</li>\n</ul>\n<h3><a href=\"http://localhost:8888/ballielektrik/bet365-casino-app-321/\" title=\"\">Bet365 App » Download E Installazione Android E Ios</a></h3>\n<p>In Aggiunta al pallone, altre scommesse parecchio diffuse avvengono quelle&#8230;</p>\n<p>												<a href=\"http://localhost:8888/ballielektrik/author/ballielektrik/\" title=\"\">Posted By: Ballielektrik</a></p>\n<ul>\n<li>Ağu 22, 2025</li>\n<li>0 Comments</li>\n</ul>\n<h3><a href=\"http://localhost:8888/ballielektrik/bet365-app-mobile-504/\" title=\"\">Bet365 App Mobile A Causa Di Scommesse Sportive Download E Come Scaricare App</a></h3>\n<p>È alcuni strumento vantaggioso con lo scopo di restare informati&#8230;</p>\n<p>												<a href=\"http://localhost:8888/ballielektrik/author/ballielektrik/\" title=\"\">Posted By: Ballielektrik</a></p>\n<ul>\n<li>Ağu 22, 2025</li>\n<li>0 Comments</li>\n</ul>\n<h3><a href=\"http://localhost:8888/ballielektrik/bet365-app-download-963/\" title=\"\">App Bet365 Guida A Fine Di Scaricarla Con I Bonus Successo Benvenuto</a></h3>\n<p>Alcuni dei primarie vantaggi dell’app Bet365 è la possibilità successo&#8230;</p>\n<p>												<a href=\"http://localhost:8888/ballielektrik/author/ballielektrik/\" title=\"\">Posted By: Ballielektrik</a></p>\n<ul>\n<li>Ağu 22, 2025</li>\n<li>0 Comments</li>\n</ul>\n<h3><a href=\"http://localhost:8888/ballielektrik/arhitektura-soderzhanie-i-funktsii-glavnogo-vebresursa-internetkazino/\" title=\"\">Архитектура, содержание и функции главного веб-ресурса интернет-казино</a></h3>\n<p>Архитектура, содержание и функции главного веб-ресурса интернет-казино Основа каждого успешного&#8230;</p>\n<p>												<a href=\"http://localhost:8888/ballielektrik/author/ballielektrik/\" title=\"\">Posted By: Ballielektrik</a></p>\n<ul>\n<li>Ağu 22, 2025</li>\n<li>0 Comments</li>\n</ul>\n<h3><a href=\"http://localhost:8888/ballielektrik/igrovye-sloty-v-legalnyh-onlajnkazino-gama-kazino/\" title=\"\">Игровые слоты в легальных онлайн-казино гама казино</a></h3>\n<p>Игровые слоты в легальных онлайн-казино гама казино Автоматы слоты в&#8230;</p>\n<p>												<a href=\"http://localhost:8888/ballielektrik/author/ballielektrik/\" title=\"\">Posted By: Ballielektrik</a></p>\n<ul>\n<li>Ağu 22, 2025</li>\n<li>0 Comments</li>\n</ul>\n<h3><a href=\"http://localhost:8888/ballielektrik/1xbet-application-1xbet-mobile-get-1xbet-apk-intended-for-iphone-google-android-1xbet-com/\" title=\"\">1xbet Application 1xbet Mobile Get 1xbet Apk Intended For Iphone &#038; Google Android 1xbet Com</a></h3>\n<p>Betting Company ᐉ On The Web Sports Betting 1xbetContentDownload AppRegistering&#8230;</p>\n<p>												<a href=\"http://localhost:8888/ballielektrik/author/ballielektrik/\" title=\"\">Posted By: Ballielektrik</a><br />\n							<a href=\"http://localhost:8888/ballielektrik/blog\" title=\"\">Daha Fazlası</a><br />\n	</section>\n<p>					<a href=\"https://gaztime54.ru/\">мелбет</a><br />\n					<a href=\"https://avabetting.com/\">Avabet </a></p>\n<div style=\"overflow:hidden;height:1px\"><a href=\"https://cityofuz.com/uz/\">1xbet online</a></div>\n<div style=\"overflow:hidden;height:1px\"><a href=\"https://1xbetgirisaz.com/\">1x bet</a></div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://sponsor.pe/\">pin-up casino</a></p>\n</div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://sponsor.pe/\">pin up</a> casino</p>\n</div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://wwwglitchspin.com/da/\">glitchspin</a> er din nøgle til spænding og præmier!</p>\n</div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://sponsor.pe/\">pin up</a> casino</p>\n</div>\n<div style=\"overflow:hidden;height:1px\"><a href=\"https://eng-as-rus.ru\">пинко официальный сайт</a></div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://www.mpwhi.com/\">1win</a> casino</p>\n</div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://www.mpwhi.com/\">1win</a> casino</p>\n</div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://egyseb.net/\">1xbet</a> مشهور بين اللاعبين المصريين بخدماته الموثوقة.</p>\n</div>\n<div style=\"overflow:hidden;height:1px\"><a href=\"https://med-manual.ru/\">1xbet скачать</a></div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://shopnicholejacklyne.com/\">Mostbet</a> casino</p>\n</div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://egyseb.net/\">1xbet</a> يقدم خيارات واسعة لعشاق كرة القدم المصرية.</p>\n</div>\n<div style=\"overflow:hidden;height:1px\"><a href=\"https://chicken-road-slot.bet/\">chicken road game</a></div>\n<div style=\"overflow:hidden;height:1px\"><a href=\"https://candy-spin.com/\">Candy Spinz</a></div>\n<div style=\"overflow:hidden;height:1px\"><a href=\"https://www.handball19.com/casino/leonbet/\">Leonbet</a></div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://egyseb.net/\">1xbet</a> هو واحد من أكبر مواقع المراهنات في مصر.</p>\n</div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://egyseb.net/\">1xbet</a> هو واحد من أكبر مواقع المراهنات في مصر.</p>\n</div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://felixcontinentalcafe.com/\">Mostbet</a> Azərbaycanda istifadəçilər üçün etibarlı mərc imkanları təklif edir (34).</p>\n</div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://www.mpwhi.com/\">1win</a> casino</p>\n</div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://egyseb.net/\">1xbet</a> يحتوي على مجموعة كبيرة من ألعاب الكازينو.</p>\n</div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://freshmelt.com/\">pin-up casino</a> rəsmi saytı</p>\n</div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://www.mpwhi.com/\">1win</a> casino</p>\n</div>\n<div style=\"position: absolute;left: -9966px\">\n<p>Jonli kazino o&#8217;yinlari <a href=\"https://kartaistorii.ru/\">Mostbet UZ</a> sahifasida mavjud.</p>\n</div>\n<div style=\"overflow:hidden;height:1px\"><a href=\"https://expertshop.kz/onlajn-stavki-na-sport-v-kazahstane/\">https://expertshop.kz/onlajn-stavki-na-sport-v-kazahstane/</a></div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://shopnicholejacklyne.com/\">Mostbet</a> casino</p>\n</div>\n<div style=\"overflow:hidden;height:1px\"><a href=\"https://pinco-az.az/\">pinco az</a></div>\n<div style=\"overflow:hidden;height:1px\"><a href=\"https://mostbets-slot.kz/\">https://mostbets-slot.kz/</a></div>\n<div style=\"overflow:hidden;height:1px\"><a href=\"http://dolly-casino.co/\">Dollycasino</a></div>\n<div style=\"position: absolute;left: -9966px\">\n<p>Крупные турниры проходят в <a href=\"https://lip2.ru/sports/judo\">Кент казино</a></p>\n</div>\n<div style=\"position: absolute;left: -9966px\">\n<p><a href=\"https://www.compileroptimizations.com/\">Mostbet casino</a></p>\n</div>\n<div style=\"position: absolute;left: -9966px\">\n<p>Система бонусов делает <a href=\"https://cadry-opk.ru/sports/judo\">Кент казино</a> щедрым для новых игроков.</p>\n</div>\n\n\n<h3>Свежие материалы</h3>\n<!-- PCA_RECENT_POSTS -->\n<p><a href=\"http://localhost:8888/ballielektrik/pul-cixarmaq-ucun-bonusa-nec%c9%99-duzgun-m%c9%99rc-etm%c9%99k-olar/\">Pul çıxarmaq üçün bonusa necə düzgün mərc etmək olar</a> - 24/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/sol-casino-so-beschleunigen-sie-auszahlungen-aus-osterreich/\">Sol Casino: So beschleunigen Sie Auszahlungen aus Österreich</a> - 23/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/pin-up-casino-az-da-yeni-oyunlar/\">Pin Up Casino AZ-da yeni oyunlar</a> - 23/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/pin-up-casino-daxil-olmaqda-probleml%c9%99r-v%c9%99-onlarin-h%c9%99ll%c9%99ri/\">Pin-Up Casino daxil olmaqda problemlər və onların həlləri</a> - 21/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/pin-up-360-vs-r%c9%99qibl%c9%99r-hansinin-daha-yaxsi-sanslari-var/\">Pin Up 360 vs. Rəqiblər: Hansının daha yaxşı şansları var?</a> - 20/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/pin-up-360-istifad%c9%99-s%c9%99rtl%c9%99ri-v%c9%99-qaydalari/\">Pin Up 360: İstifadə Şərtləri və Qaydaları</a> - 20/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/pin-up-az-da-toplanmis-xallarin-ustunlukl%c9%99ri/\">Pin Up AZ-da toplanmış xalların üstünlükləri</a> - 18/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/pin-up-360-promosyonlari-turnirl%c9%99r-v%c9%99-mukafat-c%c9%99kilisi/\">Pin Up 360 Promosyonları: Turnirlər və Mükafat Çəkilişi</a> - 16/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/aviator-on-khelostar-secrets-to-a-stable-game/\">Aviator on Khelostar: Secrets to a Stable Game</a> - 15/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/log-masuk-1win-malaysia-log-masuk-pantas-dan-tanpa-ralat/\">Log Masuk 1Win Malaysia: Log Masuk Pantas dan Tanpa Ralat</a> - 14/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/10-nejlepsich-automatu-pro-hrace-nine-casino-v-ceskem-regionu/\">10 nejlepších automatů pro hráče Nine Casino v českém regionu</a> - 13/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/pin-up-yukl%c9%99-istifad%c9%99-ed%c9%99n-oyuncularin-r%c9%99yl%c9%99ri/\">Pin Up Yüklə istifadə edən oyunçuların rəyləri</a> - 13/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/como-funciona-el-casino-en-vivo-en-chile/\">¿Cómo funciona el casino en vivo en Chile?</a> - 11/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/iwild-casino-so-vermeiden-sie-sperrungen-und-technische-fehler-in-osterreich/\">iWild Casino: So vermeiden Sie Sperrungen und technische Fehler in Österreich</a> - 08/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/how-to-increase-your-chances-of-winning-at-1win-canada-live-casino/\">How to increase your chances of winning at 1win Canada live casino</a> - 07/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/playfrank-casino-uk-a-comparison-with-other-uk-casinos/\">PlayFrank Casino UK: A Comparison with Other UK Casinos</a> - 07/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/chipstars-casino-uk-vip-program-and-loyal-player-benefits/\">Chipstars Casino UK: VIP Program and Loyal Player Benefits</a> - 07/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/gaming-sessions-so-managen-sie-ihre-zeit-richtig/\">Gaming-Sessions: So managen Sie Ihre Zeit richtig</a> - 07/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/aviator-pin-up-aviator-rejimi-ucun-%c9%99n-yaxsi-strategiyalar-v%c9%99-m%c9%99sl%c9%99h%c9%99tl%c9%99r/\">Aviator Pin Up: Aviator rejimi üçün ən yaxşı strategiyalar və məsləhətlər</a> - 03/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/tipwin-casino-belgie-een-complete-gids-voor-nieuwe-spelers/\">Tipwin Casino België: Een complete gids voor nieuwe spelers</a> - 03/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/mines-india-a-selection-of-strategies-for-cautious-players/\">Mines India: A Selection of Strategies for Cautious Players</a> - 03/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/pinup-yenil%c9%99m%c9%99sini-yeni-versiyaya-endir/\">Pinup yeniləməsini yeni versiyaya endir</a> - 02/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/hoe-u-de-promoties-van-iwild-casino-in-belgie-kunt-volgen/\">Hoe u de promoties van iWild Casino in België kunt volgen</a> - 01/12/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/betify-casino-live-casino-tipps-fur-osterreichische-spieler-um-dealer-zu-schlagen/\">Betify Casino Live Casino: Tipps für österreichische Spieler, um Dealer zu schlagen</a> - 27/11/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/royspins-casino-zahlungsmethoden-welche-ist-in-osterreich-am-bequemsten/\">Royspins Casino Zahlungsmethoden: Welche ist in Österreich am bequemsten?</a> - 27/11/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/die-besten-neukundenboni-in-osterreich-und-bet-it-all-casino-angebote/\">Die besten Neukundenboni in Österreich und Bet It All Casino-Angebote</a> - 26/11/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/1win-uzbekistan-mobil-ilova-interfeysi-va-foydali-funksiyalari-haqida-umumiy-malumot/\">1Win Uzbekistan: Mobil ilova interfeysi va foydali funksiyalari haqida umumiy ma’lumot</a> - 26/11/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/yolo247-in-india-how-to-get-bonuses-and-promo-codes-for-newbies/\">Yolo247 in India: How to Get Bonuses and Promo Codes for Newbies</a> - 26/11/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/pin-up-yukl%c9%99-sistem-t%c9%99l%c9%99bl%c9%99rinin-icmali/\">Pin Up Yüklə sistem tələblərinin icmalı</a> - 21/11/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/sparkdex-an-overview-of-the-protocols-internal-algorithms/\">SparkDEX - An Overview of the Protocol&#039;s Internal Algorithms</a> - 20/11/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/pin-up-bonus-depozit-olmadan-%c9%99ld%c9%99-edil%c9%99-bil%c9%99r/\">Pin Up Bonus depozit olmadan əldə edilə bilər</a> - 20/11/2025</p>\n<p><a href=\"http://localhost:8888/ballielektrik/pin-up-az%c9%99rbaycan-sadiqlik-2-0-bolm%c9%99sind%c9%99ki-yeni-mukafatlar/\">Pin-Up Azərbaycan – “Sadiqlik 2.0” Bölməsindəki Yeni Mükafatlar</a> - 09/11/2025</p>", "Anasayfa", "", "publish", "closed", "closed", "", "anasayfa", "", "", "2025-12-24 20:35:34", "2025-12-24 17:35:34", "", "0", "https://nauthemes.com/wp/kriate/?page_id=10", "0", "page", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1171", "1", "2019-01-16 13:01:54", "2019-01-16 13:01:54", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum sagittis orci ac odio dictum tincidunt. Donec ut metus leo. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed luctus, dui eu sagittis sodales, nulla nibh sagittis augue, vel porttitor diam enim non metus. Vestibulum aliquam augue neque. Phasellus tincidunt odio eget ullamcorper efficitur. Cras placerat ut turpis pellentesque vulputate. Nam sed consequat tortor. Curabitur finibus sapien dolor. Ut eleifend tellus nec erat pulvinar dignissim. Nam non arcu purus. Vivamus et massa massa.", "Coal Dryer", "Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante.\r\n\r\nDonec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.", "publish", "open", "closed", "", "coal-dryer", "", "", "2021-08-09 00:21:06", "2021-08-08 21:21:06", "", "0", "https://woocommercecore.mystagingwebsite.com/product/album/", "0", "product", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1172", "1", "2020-11-12 14:10:05", "2020-11-12 14:10:05", "<div class = \"row\">\r\n<div class=\"col-md-12 col-sm-12 col-lg-12\">[text* text-46 placeholder \"Adınız Soyadınız\"]</div>\r\n<div class=\"col-md-6 col-sm-6 col-lg-6\">[email* email-205 placeholder \"E-Posta Adresiniz\"]</div>\r\n<div class=\"col-md-6 col-sm-6 col-lg-6\">[tel* tel-510 placeholder \"Telefon Numaranız\"]</div>\r\n<div class=\"col-md-12 col-sm-12 col-lg-12\">[textarea textarea-810 placeholder \"Mesajınız\"]</div>\r\n<div class=\"col-md-12 col-sm-12 col-lg-12\">[submit class:thm-btn class:thm-bg class:text-center \"Gönder\"]</div>\r\n</div>\n1\n[_site_title] \"Yeni Mesaj\"\n[_site_title] <info@ballielektrik.com>\n[_site_admin_email]\nKimden: [text-46] <[email-205]>\r\nTelefon Numarası: [tel-510]\r\n\r\nMesaj:\r\n[textarea-810]\n\n\n\n\n\n[_site_title] \"[your-subject]\"\n[_site_title] <nauthemes@gmail.com>\n[your-email]\nMessage Body:\r\n[your-message]\r\n\r\n-- \r\nThis e-mail was sent from a contact form on [_site_title] ([_site_url])\nReply-To: [_site_admin_email]\n\n\n\nGönderenin iletisi başarılı olarak gönderildi\nGönderenin iletisinin gönderilmesi başarısız oldu\nOnaylama hataları meydana geldi\nSunuş istenmeyen ileti olarak gönderildi\nGönderenin kabul etmek zorunda olduğu koşullar var\nGönderenin doldurmak zorunda olduğu bir alan var\nKullanıcı girdisinin en fazla izin verildiği uzunluktan daha uzun bir alan var\nKullanıcı girdisinin en az izin verildiği uzunluktan daha kısa bir alan var\nDosyayı gönderme herhangi bir nedenden başarısız\nYüklenen dosya izin verilmeyen dosya biçimi içeriyor\nGönderilen dosya çok büyük\nDosyayı gönderme PHP hatasından dolayı başarısız\nGönderenin girdiği tarih biçimi geçersiz\nTarih, en az sınırdan daha erken\nTarih, en fazla sınırdan daha geç\nGönderenin girdiği sayı biçimi geçersiz\nSayı, en az sınırdan daha küçük\nSayı, en fazla sınırdan daha büyük\nGönderen soruya doğru yanıtı girmedi\nGönderenin girdiği eposta adresi geçersiz\nGönderenin girdiği URL geçersiz\nGönderenin girdiği telefon numarası geçersiz", "Contact form 1", "", "publish", "closed", "closed", "", "contact-form-1", "", "", "2021-08-18 01:50:09", "2021-08-17 22:50:09", "", "0", "https://nauthemes.com/wp/kriate/?post_type=wpcf7_contact_form&#038;p=5", "0", "wpcf7_contact_form", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1187", "1", "2021-08-09 00:35:33", "2021-08-08 21:35:33", "", "Elektrik arıza tespiti - Ankara Ballı Elektrik", "", "inherit", "open", "closed", "", "elektrik-ariza-tespiti-ankara-balli-elektrik", "", "", "2021-08-18 00:14:43", "2021-08-17 21:14:43", "", "1169", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Elektrik-ariza-tespiti-ankara-balli-elektrik.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("1198", "1", "2021-08-09 00:49:28", "2021-08-08 21:49:28", "", "Güvenlik-kamerası---Ankara-Ballı-Elektrik", "", "inherit", "open", "closed", "", "guvenlik-kamerasi-ankara-balli-elektrik", "", "", "2021-08-09 00:49:28", "2021-08-08 21:49:28", "", "1169", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Guvenlik-kamerasi-Ankara-Balli-Elektrik.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("1208", "1", "2021-08-09 00:54:46", "2021-08-08 21:54:46", "", "Görüntülü Diafon - Ankara Ballı Elektrik", "", "inherit", "open", "closed", "", "goruntulu-diafon-ankara-balli-elektrik", "", "", "2021-08-09 00:54:46", "2021-08-08 21:54:46", "", "1169", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Goruntulu-Diafon-Ankara-Balli-Elektrik.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("1235", "1", "2026-02-23 06:45:30", "2021-08-08 22:21:57", " ", "", "", "publish", "closed", "closed", "", "1235", "", "", "2026-02-23 06:45:30", "2026-02-23 03:45:30", "", "0", "http://localhost:8888/ballielektrik/?p=1235", "1", "nav_menu_item", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1236", "1", "2026-02-23 06:45:30", "2021-08-08 22:21:57", " ", "", "", "publish", "closed", "closed", "", "1236", "", "", "2026-02-23 06:45:30", "2026-02-23 03:45:30", "", "0", "http://localhost:8888/ballielektrik/?p=1236", "4", "nav_menu_item", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1237", "1", "2026-02-23 06:45:30", "2021-08-08 22:21:57", " ", "", "", "publish", "closed", "closed", "", "1237", "", "", "2026-02-23 06:45:30", "2026-02-23 03:45:30", "", "0", "http://localhost:8888/ballielektrik/?p=1237", "3", "nav_menu_item", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1239", "1", "2026-02-23 06:45:30", "2021-08-08 22:21:57", " ", "", "", "publish", "closed", "closed", "", "1239", "", "", "2026-02-23 06:45:30", "2026-02-23 03:45:30", "", "0", "http://localhost:8888/ballielektrik/?p=1239", "5", "nav_menu_item", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1240", "1", "2026-02-23 06:45:30", "2021-08-08 22:21:57", " ", "", "", "publish", "closed", "closed", "", "1240", "", "", "2026-02-23 06:45:30", "2026-02-23 03:45:30", "", "0", "http://localhost:8888/ballielektrik/?p=1240", "2", "nav_menu_item", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1241", "1", "2026-02-23 06:45:30", "2021-08-08 22:26:22", " ", "", "", "publish", "closed", "closed", "", "1241", "", "", "2026-02-23 06:45:30", "2026-02-23 03:45:30", "", "0", "http://localhost:8888/ballielektrik/?p=1241", "6", "nav_menu_item", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1242", "1", "2021-08-09 01:52:34", "2021-08-08 22:52:34", "Ankara Ballı Elektrik", "Ballı Elektrik-Ankara", "Ankara Ballı Elektrik", "inherit", "open", "closed", "", "balli-elektrik-ankara", "", "", "2021-08-18 00:14:37", "2021-08-17 21:14:37", "", "1169", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Balli-Elektrik-Ankara.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("1255", "1", "2021-08-17 23:22:56", "2021-08-17 20:22:56", "", "Elektik Backround - Ankara Ballı Elektrik", "", "inherit", "open", "closed", "", "elektrik-piyasasi-istatistiksel-analizi-03-12-2019", "", "", "2021-08-18 00:14:23", "2021-08-17 21:14:23", "", "1169", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/elektrik-piyasasi-istatistiksel-analizi-03-12-2019.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("1283", "1", "2021-08-17 23:43:15", "2021-08-17 20:43:15", "", "Kamera Kurulum - Ankara Ballı Elektrik", "", "inherit", "open", "closed", "", "unnamed", "", "", "2021-08-18 00:14:21", "2021-08-17 21:14:21", "", "90", "http://localhost:8888/ballielektrik/wp-content/uploads/2020/11/unnamed.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("1293", "1", "2021-08-18 00:13:24", "2021-08-17 21:13:24", "", "Telefon Ankastre - Ankara Ballı Elektrik", "", "inherit", "open", "closed", "", "5cc71fea0f2bc155655370675", "", "", "2021-08-18 00:14:18", "2021-08-17 21:14:18", "", "1169", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/5cc71fea0f2bc155655370675.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("1294", "1", "2021-08-18 00:19:16", "2021-08-17 21:19:16", "", "Elektrik Pana Montaj - Ankara Ballı Elektrik", "", "inherit", "open", "closed", "", "elektrik-pana-montaj", "", "", "2021-08-18 00:28:27", "2021-08-17 21:28:27", "", "1169", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Elektrik-Pana-Montaj.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("1295", "1", "2021-08-18 00:24:02", "2021-08-17 21:24:02", "", "Elektrik Arıza Tespiti - Ankara Ballı Elektrik", "Electrician technician working on a residential electrical panel, measures the voltage on the terminals of the thermal magnetic circuit breaker", "inherit", "open", "closed", "", "elektrik-ariza-tespiti", "", "", "2021-08-18 00:28:23", "2021-08-17 21:28:23", "", "1169", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Elektrik-Ariza-Tespiti.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("1299", "1", "2021-08-18 00:26:11", "2021-08-17 21:26:11", "", "Uydu Anten Kurulumu - Ankara Ballı Elektrik", "", "inherit", "open", "closed", "", "uydu-anten-kurulumu", "", "", "2021-08-18 00:28:20", "2021-08-17 21:28:20", "", "1169", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Uydu-Anten-Kurulumu.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("1303", "1", "2021-08-18 00:28:02", "2021-08-17 21:28:02", "", "İnşaat Elektrik Projeleri - Ankara Ballı Elektrik", "", "inherit", "open", "closed", "", "5cc715cdb5680155655111758", "", "", "2021-08-18 00:28:19", "2021-08-17 21:28:19", "", "1169", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/5cc715cdb5680155655111758.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("1313", "1", "2021-08-18 00:36:28", "2021-08-17 21:36:28", "<section>\n																							<h1>\n													Elektrik Arıza Tespiti													<strong>Ankara Ballı Elektrik</strong>\n												</h1>\n																						 <p>Elektrik Arıza Tespit ve Raporlama için hemen bizimle iletişime geçin</p> 											\n												<a href=\"http://localhost:8888/ballielektrik/iletisim\" title=\"\">İletişim</a>\n																							<h1>\n													Önceliğimiz Güvenliğiniz													<strong>Ankara Ballı Elektrik</strong>\n												</h1>\n																						 <p>Profesyonel kamera sistemleriyle güvenliğiniz bizden sorulur. Hemen iletişime geçebilirsiniz</p> 											\n												<a href=\"http://localhost:8888/ballielektrik/iletisim\" title=\"\">İletişim</a>\n																							<h1>\n													Ailenizin Güvenliği İçin													<strong>Ankara Ballı Elektrik</strong>\n												</h1>\n																						 <p>Görüntülü diafon sistemleriyle artık içiniz çok rahat</p> 											\n												<a href=\"http://localhost:8888/ballielektrik/iletisim\" title=\"\">İletişim</a>\n					<!-- Featured Area Wrap -->\n			</section>\n															<img width=\"480\" height=\"610\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Balli-Elektrik-Ankara.jpg\" alt=\"Ankara Ballı Elektrik\" loading=\"lazy\" />															\n	<section>\n																<img src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Balli-Elektrik-Ankara.jpg\" alt=\"\">\n																			<h2>\n											Hakkımızda \n											<strong>Ankara Ballı Elektrik</strong>\n										</h2>\n									<p><p>Sektördeki faaliyetlerine 1995 senesinde Ankara ilinde başlayan Ankara Ballı Elektrik, Ayvalı, Etlik, Keçiören ilk sırada olmak üzere Ankara ilinde elektrik tesisatı, elektrik arıza bakımı, uydu sistemleri, diyafon sistemleri, kamera sistemleri alanlarında hizmet sunmaktadır. Kurulduğu günden günümüze nitelikli malzeme ve işçilik öncelikli çalışan Ankara Palaz Elektrik firması olarak müşteri memnuniyetini her zaman ilk planda tutmaktayız. Ankara elektrikçi iş ilanları yardımı ile bizlere 7/24 ulaşabilirsiniz. Ayırca elektirikçi Ankara Çankaya ya da Ankara Kızılay Elektirikçi firması aramanıza gerek kalmadan ihtiyaçlarınıza çözüm üretebiliyoruz. Kısaca Ankara elektrik tamircisi aramanıza gerek kalmadan Ballı Elektrik olarak tüm elektrik arızalarınızı profesyonel ekibimiz ile çözüyoruz.</p></p>								\n													<h3><a href=\"http://localhost:8888/ballielektrik/services/kamera-kurulumu/\" title=\"\">Kamera Kurulumu</a></h3>\n													<p>Güvenlik kamera sistem kurulumu istiyorsanız bizi arayın, önce...</p>\n							<!-- Services Wrap -->\n				<!-- About Wrap -->\n	</section>\n	<section>\n																					<h2>26<sup>+</sup></h2>\n																														<h4>Yıllık Tecrübe</h4>\n																					<h2>502<sup>+</sup></h2>\n																														<h4>Tamamlanmış Proje</h4>\n																					<h2>120<sup>+</sup></h2>\n																														<h4>Güvenlik Kamerası</h4>\n																					<h2>12<sup>+</sup></h2>\n																														<h4>Devam Eden Proje</h4>\n												<!-- Facts Wrap -->\n	</section>\n	<section>\n						Ankara Ballı Elektrik						<h2>Sağladığımız Hizmetler</h2>						<p>Ballı elektrik bünyesinde sunmuş olduğu güvenlik kamera sistemleri kurulum montaj arıza onarım ve bakımı , uydu anten kurulumu, uydu kanalları kurulumu, uydu ekipman ve malzemeleri satışı , Görüntülü diafon sistemleri kurulumu, değişimi, yeni binalarda şartnamelerde bulunan isteklerin karşılanması , elektrik arıza tesisat çekimi, yeni pano kurulumu gibi hizmetler ile siz değerli müşterilerimize faydalı olmaya çalışmaktayız.</p>					\n				<!-- Services Wrap -->\n	</section>\n			<figure><img width=\"512\" height=\"375\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2020/11/unnamed.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>Kamera Kurulum</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nGüvenlik kamera İhtiyaçlarınız doğrultusunda sizlere en yenilikçi alternatifleri sunuyoruz.</p>		\n			<figure><img width=\"500\" height=\"334\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/5cc71fea0f2bc155655370675.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>Telefon Ankastre</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nİnternet altyapı hizmetleri arızalarında hızlı ve güvenilir çözüm için bizimle iletişime geçin.</p>		\n			<figure><img width=\"1024\" height=\"683\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Elektrik-Pana-Montaj-1024x683.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>Elektrik Pano Montaj</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nElektrik tesisatın düzgün çalışması için elektrik pano montaj bağlantıları uzmanlarınca yapılmalıdır.</p>		\n			<figure><img width=\"849\" height=\"565\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Elektrik-Ariza-Tespiti.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>Elektrik Arıza Tespiti</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nMüşterilerimizin elektrik arıza ihtiyaçlarına, en doğru ve alternatif çözümlerle müdahale ediyoruz.</p>		\n			<figure><img width=\"1024\" height=\"686\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Uydu-Anten-Kurulumu-1024x686.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>Uydu Anten Kurulumu</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nAnkara uyducu arayışında olanların tercihi Palaz Elektrik, 7/24 kesintisiz hizmet veriyor.</p>		\n			<figure><img width=\"1024\" height=\"683\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/5cc715cdb5680155655111758-1024x683.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>İnşaat Elektrik Projeleri</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nİnşaat sektöründe birçok elektrik proje işini tamamlayan firmamız, her geçen gün daha da büyüyor.</p>		\n   <section>\n						Blog Yazılarımız\n						<h3>Son Makaleler</h3>\n											<a href=\"http://localhost:8888/ballielektrik/models-oem-solution-simul-corporation-2020/\" title=\"\">Construction<img src=\"http://localhost:8888/ballielektrik/wp-content/uploads/bfi_thumb/770x470-pbbxs3dabhofpexee71k4ds489axa1blqo0gxrnziw.png\" alt=\"Featured Image\">\n											</a>\n											<ul>\n												<li>Kas 14, 2020</li>\n												<li>1 Comments</li>\n											</ul>\n											<h3><a href=\"http://localhost:8888/ballielektrik/models-oem-solution-simul-corporation-2020/\" title=\"\">Construction Geniuses &#8211; Top 10 Architectures of 2020</a></h3>\n											<p>Construction is simply dummy text of the printing and typesetting...</p>\n												<a href=\"http://localhost:8888/ballielektrik/author/Ballielektrik/\" title=\"\">Posted By: Ballielektrik</a>\n											<a href=\"http://localhost:8888/ballielektrik/models-oem-solution-simul-corporation-2021/\" title=\"\">Architecture<img src=\"http://localhost:8888/ballielektrik/wp-content/uploads/bfi_thumb/770x470-pbbxs3dabhofpexee71k4ds489axa1blqo0gxrnziw.png\" alt=\"Featured Image\">\n											</a>\n											<ul>\n												<li>Kas 12, 2020</li>\n												<li>1 Comments</li>\n											</ul>\n											<h3><a href=\"http://localhost:8888/ballielektrik/models-oem-solution-simul-corporation-2021/\" title=\"\">OEM Solutions with Artificial Intelligence</a></h3>\n											<p>Construction is simply dummy text of the printing and typesetting...</p>\n												<a href=\"http://localhost:8888/ballielektrik/author/Ballielektrik/\" title=\"\">Posted By: Ballielektrik</a>\n											<a href=\"http://localhost:8888/ballielektrik/models-oem-solution-simul-corporation/\" title=\"\">Maufacturing<img src=\"http://localhost:8888/ballielektrik/wp-content/uploads/bfi_thumb/770x470-pbbxs3dabhofpexee71k4ds489axa1blqo0gxrnziw.png\" alt=\"Featured Image\">\n											</a>\n											<ul>\n												<li>Kas 10, 2020</li>\n												<li>1 Comments</li>\n											</ul>\n											<h3><a href=\"http://localhost:8888/ballielektrik/models-oem-solution-simul-corporation/\" title=\"\">Models &#038; OEM Solution &#8211; Simul Corporation</a></h3>\n											<p>Construction is simply dummy text of the printing and typesetting...</p>\n												<a href=\"http://localhost:8888/ballielektrik/author/Ballielektrik/\" title=\"\">Posted By: Ballielektrik</a>\n											<a href=\"http://localhost:8888/ballielektrik/modern-technology-and-advancement-in-prototype/\" title=\"\">Architecture<img src=\"http://localhost:8888/ballielektrik/wp-content/uploads/bfi_thumb/770x470-pbbxs3dabhofpexee71k4ds489axa1blqo0gxrnziw.png\" alt=\"Featured Image\">\n											</a>\n											<ul>\n												<li>Kas 08, 2020</li>\n												<li>1 Comments</li>\n											</ul>\n											<h3><a href=\"http://localhost:8888/ballielektrik/modern-technology-and-advancement-in-prototype/\" title=\"\">Modern Technology and Advancement in Prototype</a></h3>\n											<p>Construction is simply dummy text of the printing and typesetting...</p>\n												<a href=\"http://localhost:8888/ballielektrik/author/Ballielektrik/\" title=\"\">Posted By: Ballielektrik</a>\n											<a href=\"http://localhost:8888/ballielektrik/coming-regulations-for-safety-in-industrial-constructions/\" title=\"\">Architecture<img src=\"http://localhost:8888/ballielektrik/wp-content/uploads/bfi_thumb/770x470-pbbxs3dabhofpexee71k4ds489axa1blqo0gxrnziw.png\" alt=\"Featured Image\">\n											</a>\n											<ul>\n												<li>Kas 06, 2020</li>\n												<li>1 Comments</li>\n											</ul>\n											<h3><a href=\"http://localhost:8888/ballielektrik/coming-regulations-for-safety-in-industrial-constructions/\" title=\"\">Regulations for Safety in Industrial Constructions</a></h3>\n											<p>Construction is simply dummy text of the printing and typesetting...</p>\n												<a href=\"http://localhost:8888/ballielektrik/author/Ballielektrik/\" title=\"\">Posted By: Ballielektrik</a>\n											<a href=\"http://localhost:8888/ballielektrik/models-architecture-of-todays-new-york/\" title=\"\">Architecture<img src=\"http://localhost:8888/ballielektrik/wp-content/uploads/bfi_thumb/770x470-pbbxs3dabhofpexee71k4ds489axa1blqo0gxrnziw.png\" alt=\"Featured Image\">\n											</a>\n											<ul>\n												<li>Eki 28, 2020</li>\n												<li>1 Comments</li>\n											</ul>\n											<h3><a href=\"http://localhost:8888/ballielektrik/models-architecture-of-todays-new-york/\" title=\"\">Models &#038; Architecture of Todays New York</a></h3>\n											<p>Construction is simply dummy text of the printing and typesetting...</p>\n												<a href=\"http://localhost:8888/ballielektrik/author/Ballielektrik/\" title=\"\">Posted By: Ballielektrik</a>\n							<a href=\"http://localhost:8888/ballielektrik/blog\" title=\"\">Daha Fazlası</a>\n	</section>", "Anasayfa", "", "publish", "closed", "closed", "", "anasayfa", "", "", "2021-08-18 00:36:28", "2021-08-17 21:36:28", "", "0", "http://localhost:8888/ballielektrik/?elementor_library=anasayfa", "0", "elementor_library", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1328", "1", "2021-08-18 01:08:54", "2021-08-17 22:08:54", "<section>\n																							<h1>\n													Elektrik Arıza Tespiti													<strong>Ankara Ballı Elektrik</strong>\n												</h1>\n																						 <p>Elektrik Arıza Tespit ve Raporlama için hemen bizimle iletişime geçin</p> 											\n												<a href=\"http://localhost:8888/ballielektrik/iletisim\" title=\"\">İletişim</a>\n																							<h1>\n													Önceliğimiz Güvenliğiniz													<strong>Ankara Ballı Elektrik</strong>\n												</h1>\n																						 <p>Profesyonel kamera sistemleriyle güvenliğiniz bizden sorulur. Hemen iletişime geçebilirsiniz</p> 											\n												<a href=\"http://localhost:8888/ballielektrik/iletisim\" title=\"\">İletişim</a>\n																							<h1>\n													Ailenizin Güvenliği İçin													<strong>Ankara Ballı Elektrik</strong>\n												</h1>\n																						 <p>Görüntülü diafon sistemleriyle artık içiniz çok rahat</p> 											\n												<a href=\"http://localhost:8888/ballielektrik/iletisim\" title=\"\">İletişim</a>\n					<!-- Featured Area Wrap -->\n			</section>\n															<img width=\"480\" height=\"610\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Balli-Elektrik-Ankara.jpg\" alt=\"Ankara Ballı Elektrik\" loading=\"lazy\" />															\n	<section>\n																<img src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Balli-Elektrik-Ankara.jpg\" alt=\"\">\n																			<h2>\n											Hakkımızda \n											<strong>Ankara Ballı Elektrik</strong>\n										</h2>\n									<p><p>Sektördeki faaliyetlerine 1995 senesinde Ankara ilinde başlayan Ankara Ballı Elektrik, Ayvalı, Etlik, Keçiören ilk sırada olmak üzere Ankara ilinde elektrik tesisatı, elektrik arıza bakımı, uydu sistemleri, diyafon sistemleri, kamera sistemleri alanlarında hizmet sunmaktadır. Kurulduğu günden günümüze nitelikli malzeme ve işçilik öncelikli çalışan Ankara Palaz Elektrik firması olarak müşteri memnuniyetini her zaman ilk planda tutmaktayız. Ankara elektrikçi iş ilanları yardımı ile bizlere 7/24 ulaşabilirsiniz. Ayırca elektirikçi Ankara Çankaya ya da Ankara Kızılay Elektirikçi firması aramanıza gerek kalmadan ihtiyaçlarınıza çözüm üretebiliyoruz. Kısaca Ankara elektrik tamircisi aramanıza gerek kalmadan Ballı Elektrik olarak tüm elektrik arızalarınızı profesyonel ekibimiz ile çözüyoruz.</p></p>								\n													<h3><a href=\"http://localhost:8888/ballielektrik/services/kamera-kurulumu/\" title=\"\">Kamera Kurulumu</a></h3>\n													<p>Güvenlik kamera sistem kurulumu istiyorsanız bizi arayın, önce...</p>\n							<!-- Services Wrap -->\n				<!-- About Wrap -->\n	</section>\n	<section>\n																					<h2>26<sup>+</sup></h2>\n																														<h4>Yıllık Tecrübe</h4>\n																					<h2>502<sup>+</sup></h2>\n																														<h4>Tamamlanmış Proje</h4>\n																					<h2>120<sup>+</sup></h2>\n																														<h4>Güvenlik Kamerası</h4>\n																					<h2>12<sup>+</sup></h2>\n																														<h4>Devam Eden Proje</h4>\n												<!-- Facts Wrap -->\n	</section>\n	<section>\n						Ankara Ballı Elektrik						<h2>Sağladığımız Hizmetler</h2>						<p>Ballı elektrik bünyesinde sunmuş olduğu güvenlik kamera sistemleri kurulum montaj arıza onarım ve bakımı , uydu anten kurulumu, uydu kanalları kurulumu, uydu ekipman ve malzemeleri satışı , Görüntülü diafon sistemleri kurulumu, değişimi, yeni binalarda şartnamelerde bulunan isteklerin karşılanması , elektrik arıza tesisat çekimi, yeni pano kurulumu gibi hizmetler ile siz değerli müşterilerimize faydalı olmaya çalışmaktayız.</p>					\n				<!-- Services Wrap -->\n	</section>\n			<figure><img width=\"512\" height=\"375\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2020/11/unnamed.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>Kamera Kurulum</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nGüvenlik kamera İhtiyaçlarınız doğrultusunda sizlere en yenilikçi alternatifleri sunuyoruz.</p>		\n			<figure><img width=\"500\" height=\"334\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/5cc71fea0f2bc155655370675.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>Telefon Ankastre</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nİnternet altyapı hizmetleri arızalarında hızlı ve güvenilir çözüm için bizimle iletişime geçin.</p>		\n			<figure><img width=\"1024\" height=\"683\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Elektrik-Pana-Montaj-1024x683.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>Elektrik Pano Montaj</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nElektrik tesisatın düzgün çalışması için elektrik pano montaj bağlantıları uzmanlarınca yapılmalıdır.</p>		\n			<figure><img width=\"849\" height=\"565\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Elektrik-Ariza-Tespiti.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>Elektrik Arıza Tespiti</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nMüşterilerimizin elektrik arıza ihtiyaçlarına, en doğru ve alternatif çözümlerle müdahale ediyoruz.</p>		\n			<figure><img width=\"1024\" height=\"686\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Uydu-Anten-Kurulumu-1024x686.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>Uydu Anten Kurulumu</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nAnkara uyducu arayışında olanların tercihi Palaz Elektrik, 7/24 kesintisiz hizmet veriyor.</p>		\n			<figure><img width=\"1024\" height=\"683\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/5cc715cdb5680155655111758-1024x683.jpg\" alt=\"\" loading=\"lazy\" /></figure><h3>İnşaat Elektrik Projeleri</h3><p><a title=\"Telefon\" href=\"tel:05415608918\"><h6>0541 560 89 18</h6></a>\nİnşaat sektöründe birçok elektrik proje işini tamamlayan firmamız, her geçen gün daha da büyüyor.</p>		\n		<section>\n						<h2>Talepleriniz İçin Bizimle İletişime Geçebilirsiniz.</h2>						<p>Taleplerinize Dilerseniz İletişim Sayfamızdan veya ofisimizde kahvemizi içerken yardımcı olabiliriz.</p>						<a href=\"http://localhost:8888/ballielektrik/iletisim\" title=\"\">İLETİŞİM</a>					\n				<!-- Banner Wrap -->\n	</section>\n   <section>\n						Blog Yazılarımız\n						<h3>Son Makaleler</h3>\n											<a href=\"http://localhost:8888/ballielektrik/models-oem-solution-simul-corporation-2020/\" title=\"\">Construction<img src=\"http://localhost:8888/ballielektrik/wp-content/uploads/bfi_thumb/770x470-pbbxs3dabhofpexee71k4ds489axa1blqo0gxrnziw.png\" alt=\"Featured Image\">\n											</a>\n											<ul>\n												<li>Kas 14, 2020</li>\n												<li>1 Comments</li>\n											</ul>\n											<h3><a href=\"http://localhost:8888/ballielektrik/models-oem-solution-simul-corporation-2020/\" title=\"\">Construction Geniuses &#8211; Top 10 Architectures of 2020</a></h3>\n											<p>Construction is simply dummy text of the printing and typesetting...</p>\n												<a href=\"http://localhost:8888/ballielektrik/author/Ballielektrik/\" title=\"\">Posted By: Ballielektrik</a>\n											<a href=\"http://localhost:8888/ballielektrik/models-oem-solution-simul-corporation-2021/\" title=\"\">Architecture<img src=\"http://localhost:8888/ballielektrik/wp-content/uploads/bfi_thumb/770x470-pbbxs3dabhofpexee71k4ds489axa1blqo0gxrnziw.png\" alt=\"Featured Image\">\n											</a>\n											<ul>\n												<li>Kas 12, 2020</li>\n												<li>1 Comments</li>\n											</ul>\n											<h3><a href=\"http://localhost:8888/ballielektrik/models-oem-solution-simul-corporation-2021/\" title=\"\">OEM Solutions with Artificial Intelligence</a></h3>\n											<p>Construction is simply dummy text of the printing and typesetting...</p>\n												<a href=\"http://localhost:8888/ballielektrik/author/Ballielektrik/\" title=\"\">Posted By: Ballielektrik</a>\n											<a href=\"http://localhost:8888/ballielektrik/models-oem-solution-simul-corporation/\" title=\"\">Maufacturing<img src=\"http://localhost:8888/ballielektrik/wp-content/uploads/bfi_thumb/770x470-pbbxs3dabhofpexee71k4ds489axa1blqo0gxrnziw.png\" alt=\"Featured Image\">\n											</a>\n											<ul>\n												<li>Kas 10, 2020</li>\n												<li>1 Comments</li>\n											</ul>\n											<h3><a href=\"http://localhost:8888/ballielektrik/models-oem-solution-simul-corporation/\" title=\"\">Models &#038; OEM Solution &#8211; Simul Corporation</a></h3>\n											<p>Construction is simply dummy text of the printing and typesetting...</p>\n												<a href=\"http://localhost:8888/ballielektrik/author/Ballielektrik/\" title=\"\">Posted By: Ballielektrik</a>\n											<a href=\"http://localhost:8888/ballielektrik/modern-technology-and-advancement-in-prototype/\" title=\"\">Architecture<img src=\"http://localhost:8888/ballielektrik/wp-content/uploads/bfi_thumb/770x470-pbbxs3dabhofpexee71k4ds489axa1blqo0gxrnziw.png\" alt=\"Featured Image\">\n											</a>\n											<ul>\n												<li>Kas 08, 2020</li>\n												<li>1 Comments</li>\n											</ul>\n											<h3><a href=\"http://localhost:8888/ballielektrik/modern-technology-and-advancement-in-prototype/\" title=\"\">Modern Technology and Advancement in Prototype</a></h3>\n											<p>Construction is simply dummy text of the printing and typesetting...</p>\n												<a href=\"http://localhost:8888/ballielektrik/author/Ballielektrik/\" title=\"\">Posted By: Ballielektrik</a>\n											<a href=\"http://localhost:8888/ballielektrik/coming-regulations-for-safety-in-industrial-constructions/\" title=\"\">Architecture<img src=\"http://localhost:8888/ballielektrik/wp-content/uploads/bfi_thumb/770x470-pbbxs3dabhofpexee71k4ds489axa1blqo0gxrnziw.png\" alt=\"Featured Image\">\n											</a>\n											<ul>\n												<li>Kas 06, 2020</li>\n												<li>1 Comments</li>\n											</ul>\n											<h3><a href=\"http://localhost:8888/ballielektrik/coming-regulations-for-safety-in-industrial-constructions/\" title=\"\">Regulations for Safety in Industrial Constructions</a></h3>\n											<p>Construction is simply dummy text of the printing and typesetting...</p>\n												<a href=\"http://localhost:8888/ballielektrik/author/Ballielektrik/\" title=\"\">Posted By: Ballielektrik</a>\n											<a href=\"http://localhost:8888/ballielektrik/models-architecture-of-todays-new-york/\" title=\"\">Architecture<img src=\"http://localhost:8888/ballielektrik/wp-content/uploads/bfi_thumb/770x470-pbbxs3dabhofpexee71k4ds489axa1blqo0gxrnziw.png\" alt=\"Featured Image\">\n											</a>\n											<ul>\n												<li>Eki 28, 2020</li>\n												<li>1 Comments</li>\n											</ul>\n											<h3><a href=\"http://localhost:8888/ballielektrik/models-architecture-of-todays-new-york/\" title=\"\">Models &#038; Architecture of Todays New York</a></h3>\n											<p>Construction is simply dummy text of the printing and typesetting...</p>\n												<a href=\"http://localhost:8888/ballielektrik/author/Ballielektrik/\" title=\"\">Posted By: Ballielektrik</a>\n							<a href=\"http://localhost:8888/ballielektrik/blog\" title=\"\">Daha Fazlası</a>\n	</section>", "Anasayfa 2", "", "publish", "closed", "closed", "", "anasayfa-2", "", "", "2021-08-18 01:08:55", "2021-08-17 22:08:55", "", "0", "http://localhost:8888/ballielektrik/?elementor_library=anasayfa-2", "0", "elementor_library", "", "0");
INSERT INTO `nqcpo_posts` VALUES("1335", "1", "2021-08-18 01:25:39", "2021-08-17 22:25:39", "", "ballı Elektrik logo footer", "", "inherit", "open", "closed", "", "balli-elektrik-logo-footer", "", "", "2021-08-18 01:25:39", "2021-08-17 22:25:39", "", "0", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/balli-Elektrik-logo-footer.png", "0", "attachment", "image/png", "0");
INSERT INTO `nqcpo_posts` VALUES("1339", "1", "2021-08-18 01:52:26", "2021-08-17 22:52:26", "", "bigstock-Lightbulb-6256753", "", "inherit", "open", "closed", "", "bigstock-lightbulb-6256753", "", "", "2021-08-18 01:52:26", "2021-08-17 22:52:26", "", "0", "http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/bigstock-Lightbulb-6256753.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("1346", "1", "2021-08-18 02:05:50", "2021-08-17 23:05:50", "Elektrik Nedir?", "Elektrik Nedir?", "Elektrik Nedir?", "inherit", "open", "closed", "", "5ccf0d116956f155707316957", "", "", "2021-08-18 02:06:01", "2021-08-17 23:06:01", "", "219", "http://localhost:8888/ballielektrik/wp-content/uploads/2020/11/5ccf0d116956f155707316957.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("1348", "1", "2021-08-18 02:07:58", "2021-08-17 23:07:58", "", "Elektrik Nasıl Oluşur ve Üretilir", "", "inherit", "open", "closed", "", "elektrik-nasil-olusur-ve-uretilir-2", "", "", "2021-08-18 02:07:58", "2021-08-17 23:07:58", "", "218", "http://localhost:8888/ballielektrik/wp-content/uploads/2020/11/Elektrik-Nasil-Olusur-ve-Uretilir.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `nqcpo_posts` VALUES("1356", "1", "2021-08-18 13:23:14", "2021-08-18 10:23:14", "<img width=\"480\" height=\"610\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Balli-Elektrik-Ankara.jpg\" alt=\"Ankara Ballı Elektrik\" loading=\"lazy\" />															\n			<h2>Hakkımızda</h2>		\n			<h2>Ankara Ballı Elektrik</h2>		\n		<p>Sektördeki faaliyetlerine 1995 senesinde Ankara ilinde başlayan Ankara Ballı Elektrik, Ayvalı, Etlik, Keçiören ilk sırada olmak üzere Ankara ilinde elektrik tesisatı, elektrik arıza bakımı, uydu sistemleri, diyafon sistemleri, kamera sistemleri alanlarında hizmet sunmaktadır. Kurulduğu günden günümüze nitelikli malzeme ve işçilik öncelikli çalışan Ankara Ballı Elektrik firması olarak müşteri memnuniyetini her zaman ilk planda tutmaktayız. Ankara elektrikçi iş ilanları yardımı ile bizlere 7/24 ulaşabilirsiniz. Ayırca elektrikçi Ankara Çankaya ya da Ankara Kızılay Elektrikçi firması aramanıza gerek kalmadan ihtiyaçlarınıza çözüm üretebiliyoruz. Kısaca Ankara elektrik tamircisi aramanıza gerek kalmadan Ballı Elektrik olarak tüm elektrik arızalarınızı profesyonel ekibimiz ile çözüyoruz.</p><p>Yılların verdiği tecrübeyle sizlere hizmet sunan uzman ekibimiz, doğru malzeme, doğru ekipman ve nitelikli işçilik anlayışı ile çalışmakta ve sizin istekleriniz doğrultusunda hızlı çözümler üretmektedir.<br /><br />Ballı Keçiören elektrikçi 7/24 365 gün hizmetinizdeyiz. Keçiören elektrik işlerinizi Ballı Elektrik hızlı bir biçimde çözüme ulaştırıyoruz. Ayrıca Keçiören uydu çözümleriyle de piyasaya liderdik ediyoruz. Ankara elektrikçi firmaları arasında Ballı Elektrik olarak müşterilerimize nitelikli hizmet sunmaya devam etmekteyiz. Ayrıca Etlik elektrikçi, Aycalı elektrikçi olarak da bize ulaşabilirsiniz. </p>		\n															<img width=\"480\" height=\"610\" src=\"http://localhost:8888/ballielektrik/wp-content/uploads/2021/08/Balli-Elektrik-Ankara.jpg\" alt=\"Ankara Ballı Elektrik\" loading=\"lazy\" />															\n		<p>Ankara bölgesinde tüm ilçelere hizmet vermekteyiz. Uygun fiyata hizmet sunarak müşterilerimizi memnun ediyoruz. Her zaman müşteri merkezli hizmet vermekteyiz. Ayvalı Mahallesi Ayvalı caddesi üstünde bulunan firmamıza gelerek elektrik işleriniz için teklif alabilir ve piyasada bulunan diğer elektrikçi şirketleri ile kıyaslama yapabilirsiniz. Böylece kalitemizden ve uygun maliyetli elektrik, uydu, diafon, diyafon gibi hizmetlerimizden emin olabilirsiniz.<br /><br />Sağladığımız hizmetlerden bazıları ;<br /><br />- Elektrik ve elektronik malzeme satışı,<br /><br />- Uydu anten kurulumu,<br /><br />- Elektrik tesisatı,<br /><br />- Görüntülü Diafon sistemleri,<br /><br />- Güvenlik Kamera Sitemleri<br /><br />kurulum, montaj , bakım ve arızalarıdır.<br /><br />En çok hizmet vermiş olduğumuz bölgeler: Ankara Elektrikçi, Keçiören Elektrikçi, Etlik Elektrikçi, Esertepe Elektrikçi, İncirli Elektrikçi, En yakın elektrikçi, Çankaya Elektrikçi, Sancaktepe Elektrikçi, Yayla Mahallesi Elektrikçi, Yükseltepe Elektrikçi, Ufuktepe Elektrikçi, Şenlik Mahallesi Elektrikçi, Ovacık Elektrikçi, Karşıyaka Elektrikçi, Atapark Elektrikçi, Yeşiltepe Elektrikçi, Yakacık Mahallesi Elektrikçi, Tepebaşı Elektrikçi, Şehit Kubilay Elektrikçi, Basınevler Elektrikçi, Bademlik Elektrikçi, Aşağı Eğlence Elektrikçi, Uyanış Mahallesi Elektrikçi, Şenyuva Elektrikçi, Pınarbaşı Elektrikçi, Kuşcağız Elektrikçi, Bağlum Elektrikçi, Pursaklar Elektrikçi, Bahçelievler Elektrikçi, Kızılay Elektrikçi, Elektrikçi Etimesgut, Sıhhıye Elektrikçi, Ulus Elektrikçi, Mamak Elektirkçi, Sincan Elektirikçi, Yenimahalle Elektrikçi</p>		\n	<section>\n																					<h2>26<sup>+</sup></h2>\n																														<h4>Yıllık Tecrübe</h4>\n																					<h2>502<sup>+</sup></h2>\n																														<h4>Tamamlanmış Proje</h4>\n																					<h2>120<sup>+</sup></h2>\n																														<h4>Güvenlik Kamerası</h4>\n																					<h2>12<sup>+</sup></h2>\n																														<h4>Devam Eden Proje</h4>\n												<!-- Facts Wrap -->\n	</section>", "Hakkımızda", "", "publish", "closed", "closed", "", "hakkimizda", "", "", "2021-08-18 13:23:14", "2021-08-18 10:23:14", "", "0", "http://localhost:8888/ballielektrik/?elementor_library=hakkimizda", "0", "elementor_library", "", "0");
INSERT INTO `nqcpo_posts` VALUES("18164", "1", "2025-07-16 23:13:08", "2025-07-16 20:13:08", "", "onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_2.webp", "", "inherit", "", "closed", "", "onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_2-webp", "", "", "2025-07-16 23:13:08", "2025-07-16 20:13:08", "", "18166", "http://localhost:8888/ballielektrik/wp-content/uploads/2025/07/onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_2.webp", "0", "attachment", "image/webp", "0");
INSERT INTO `nqcpo_posts` VALUES("18165", "1", "2025-07-16 23:13:12", "2025-07-16 20:13:12", "", "onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_1.webp", "", "inherit", "", "closed", "", "onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_1-webp", "", "", "2025-07-16 23:13:12", "2025-07-16 20:13:12", "", "18166", "http://localhost:8888/ballielektrik/wp-content/uploads/2025/07/onlayn-kazinoda-uurunuzu-nec-artrmaq-olar_1.webp", "0", "attachment", "image/webp", "0");
INSERT INTO `nqcpo_posts` VALUES("24053", "1", "2025-08-24 03:47:42", "2025-08-24 00:47:42", "http://localhost:8888/ballielektrik/wp-content/uploads/2025/08/woocommerce_inputs_plugin.zip", "woocommerce_inputs_plugin.zip", "", "private", "", "closed", "", "woocommerce_inputs_plugin-zip", "", "", "2025-08-24 03:47:42", "2025-08-24 00:47:42", "", "0", "http://localhost:8888/ballielektrik/wp-content/uploads/2025/08/woocommerce_inputs_plugin.zip", "0", "attachment", "", "0");
INSERT INTO `nqcpo_posts` VALUES("30545", "1", "2025-09-21 09:50:31", "2025-09-21 06:50:31", "http://localhost:8888/ballielektrik/wp-content/uploads/2025/09/one_images_user.zip", "one_images_user.zip", "", "private", "", "closed", "", "one_images_user-zip", "", "", "2025-09-21 09:50:31", "2025-09-21 06:50:31", "", "0", "http://localhost:8888/ballielektrik/wp-content/uploads/2025/09/one_images_user.zip", "0", "attachment", "", "0");
INSERT INTO `nqcpo_posts` VALUES("34594", "1", "2026-02-23 02:02:00", "2026-02-22 23:02:00", "<!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page menu-item-home\",\"description\":\"\",\"id\":\"1169\",\"kind\":\"post-type\",\"label\":\"Anasayfa\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"357\",\"kind\":\"post-type\",\"label\":\"Hakkımızda\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/hakkimizda/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"395\",\"kind\":\"post-type\",\"label\":\"Hizmetlerimiz\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/hizmetlerimiz/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page current_page_parent\",\"description\":\"\",\"id\":\"9\",\"kind\":\"post-type\",\"label\":\"Blog\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/blog/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"413\",\"kind\":\"post-type\",\"label\":\"Sss\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/sss/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"436\",\"kind\":\"post-type\",\"label\":\"İletişim\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/iletisim/\"} /-->", "Anamenü", "", "publish", "closed", "closed", "", "anamenu", "", "", "2026-02-23 02:02:00", "2026-02-22 23:02:00", "", "0", "http://localhost:8888/ballielektrik/anamenu/", "0", "wp_navigation", "", "0");
INSERT INTO `nqcpo_posts` VALUES("34595", "1", "2026-02-23 02:02:00", "2026-02-22 23:02:00", "<!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page menu-item-home\",\"description\":\"\",\"id\":\"1169\",\"kind\":\"post-type\",\"label\":\"Anasayfa\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"357\",\"kind\":\"post-type\",\"label\":\"Hakkımızda\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/hakkimizda/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"395\",\"kind\":\"post-type\",\"label\":\"Hizmetlerimiz\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/hizmetlerimiz/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page current_page_parent\",\"description\":\"\",\"id\":\"9\",\"kind\":\"post-type\",\"label\":\"Blog\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/blog/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"413\",\"kind\":\"post-type\",\"label\":\"Sss\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/sss/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"436\",\"kind\":\"post-type\",\"label\":\"İletişim\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/iletisim/\"} /-->", "Anamenü", "", "publish", "closed", "closed", "", "anamenu", "", "", "2026-02-23 02:02:00", "2026-02-22 23:02:00", "", "0", "http://localhost:8888/ballielektrik/anamenu/", "0", "wp_navigation", "", "0");
INSERT INTO `nqcpo_posts` VALUES("34596", "1", "2026-02-23 02:02:00", "2026-02-22 23:02:00", "<!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page menu-item-home\",\"description\":\"\",\"id\":\"1169\",\"kind\":\"post-type\",\"label\":\"Anasayfa\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"357\",\"kind\":\"post-type\",\"label\":\"Hakkımızda\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/hakkimizda/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"395\",\"kind\":\"post-type\",\"label\":\"Hizmetlerimiz\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/hizmetlerimiz/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page current_page_parent\",\"description\":\"\",\"id\":\"9\",\"kind\":\"post-type\",\"label\":\"Blog\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/blog/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"413\",\"kind\":\"post-type\",\"label\":\"Sss\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/sss/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"436\",\"kind\":\"post-type\",\"label\":\"İletişim\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/iletisim/\"} /-->", "Anamenü", "", "publish", "closed", "closed", "", "anamenu", "", "", "2026-02-23 02:02:00", "2026-02-22 23:02:00", "", "0", "http://localhost:8888/ballielektrik/anamenu/", "0", "wp_navigation", "", "0");
INSERT INTO `nqcpo_posts` VALUES("34597", "1", "2026-02-23 02:02:00", "2026-02-22 23:02:00", "<!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page menu-item-home\",\"description\":\"\",\"id\":\"1169\",\"kind\":\"post-type\",\"label\":\"Anasayfa\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"357\",\"kind\":\"post-type\",\"label\":\"Hakkımızda\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/hakkimizda/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"395\",\"kind\":\"post-type\",\"label\":\"Hizmetlerimiz\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/hizmetlerimiz/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page current_page_parent\",\"description\":\"\",\"id\":\"9\",\"kind\":\"post-type\",\"label\":\"Blog\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/blog/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"413\",\"kind\":\"post-type\",\"label\":\"Sss\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/sss/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"436\",\"kind\":\"post-type\",\"label\":\"İletişim\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/iletisim/\"} /-->", "Anamenü", "", "publish", "closed", "closed", "", "anamenu-2", "", "", "2026-02-23 02:02:00", "2026-02-22 23:02:00", "", "0", "http://localhost:8888/ballielektrik/anamenu-2/", "0", "wp_navigation", "", "0");
INSERT INTO `nqcpo_posts` VALUES("34598", "1", "2026-02-23 02:02:00", "2026-02-22 23:02:00", "<!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page menu-item-home\",\"description\":\"\",\"id\":\"1169\",\"kind\":\"post-type\",\"label\":\"Anasayfa\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"357\",\"kind\":\"post-type\",\"label\":\"Hakkımızda\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/hakkimizda/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"395\",\"kind\":\"post-type\",\"label\":\"Hizmetlerimiz\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/hizmetlerimiz/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page current_page_parent\",\"description\":\"\",\"id\":\"9\",\"kind\":\"post-type\",\"label\":\"Blog\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/blog/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"413\",\"kind\":\"post-type\",\"label\":\"Sss\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/sss/\"} /--><!-- wp:navigation-link {\"className\":\" menu-item menu-item-type-post_type menu-item-object-page\",\"description\":\"\",\"id\":\"436\",\"kind\":\"post-type\",\"label\":\"İletişim\",\"opensInNewTab\":false,\"rel\":null,\"title\":\"\",\"type\":\"page\",\"url\":\"http://localhost:8888/ballielektrik/iletisim/\"} /-->", "Anamenü", "", "publish", "closed", "closed", "", "anamenu-3", "", "", "2026-02-23 02:02:00", "2026-02-22 23:02:00", "", "0", "http://localhost:8888/ballielektrik/anamenu-3/", "0", "wp_navigation", "", "0");

/* INSERT TABLE DATA: nqcpo_term_relationships */
INSERT INTO `nqcpo_term_relationships` VALUES("91", "40", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("95", "34", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("96", "34", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("97", "34", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("141", "49", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("143", "49", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("145", "49", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("146", "41", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("146", "49", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("147", "49", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("148", "49", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("149", "49", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("173", "45", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("177", "45", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("178", "45", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("206", "61", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("218", "62", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("219", "62", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("474", "47", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("476", "47", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("477", "47", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("478", "47", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("479", "47", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("480", "47", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("481", "47", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("482", "47", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("483", "47", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("484", "47", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("523", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("523", "10", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("523", "15", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("523", "31", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("523", "36", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("523", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("523", "39", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("523", "42", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("523", "44", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("523", "46", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("523", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("523", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("524", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("524", "14", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("524", "31", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("524", "36", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("524", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("524", "44", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("524", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("524", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("525", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("525", "15", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("525", "31", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("525", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("525", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("525", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("526", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("526", "16", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("526", "35", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("526", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("526", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("526", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("527", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("527", "14", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("527", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("527", "44", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("527", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("527", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("528", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("528", "15", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("528", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("528", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("528", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("529", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("529", "10", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("529", "13", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("529", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("529", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("529", "52", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("529", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("530", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("530", "10", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("530", "16", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("530", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("530", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("530", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("531", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("531", "8", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("531", "9", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("531", "10", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("531", "15", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("531", "35", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("531", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("531", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("531", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("532", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("532", "10", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("532", "15", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("532", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("532", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("532", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("533", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("533", "16", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("533", "36", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("533", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("533", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("533", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("534", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("534", "14", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("534", "31", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("534", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("534", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("534", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("535", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("535", "14", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("535", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("535", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("535", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("541", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("541", "16", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("541", "35", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("541", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("541", "43", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("541", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("542", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("542", "15", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("542", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("542", "44", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("542", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("542", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("543", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("543", "15", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("543", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("543", "43", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("543", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("543", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("544", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("544", "16", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("544", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("544", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("544", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1043", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1043", "16", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1043", "31", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1043", "43", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1043", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1047", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1047", "10", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1047", "15", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1047", "31", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1047", "36", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1047", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1047", "39", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1047", "42", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1047", "44", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1047", "46", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1047", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1047", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1051", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1051", "8", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1051", "9", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1051", "10", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1051", "35", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1051", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1051", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1051", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1052", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1052", "16", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1052", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1052", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1052", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1053", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1053", "10", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1053", "15", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1053", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1053", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1053", "52", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1053", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1054", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1054", "14", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1054", "35", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1054", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1054", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1054", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1055", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1055", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1055", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1055", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1056", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1056", "15", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1056", "35", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1056", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1056", "43", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1056", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1057", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1057", "15", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1057", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1057", "43", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1057", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1059", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1059", "16", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1059", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1059", "43", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1059", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1068", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1068", "10", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1068", "15", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1068", "31", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1068", "36", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1068", "39", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1068", "42", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1068", "44", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1068", "46", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1068", "50", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1171", "4", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1171", "16", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1171", "37", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1171", "38", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1171", "48", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1171", "53", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1235", "59", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1236", "59", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1237", "59", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1239", "59", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1240", "59", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1241", "59", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1313", "60", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1328", "60", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1356", "60", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1387", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1395", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1397", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1401", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1403", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1409", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1425", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1431", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1442", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1455", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1471", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1487", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1489", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1491", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1493", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1501", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1503", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1507", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1509", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1511", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1514", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1518", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1522", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1524", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1528", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1530", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1532", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1534", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1536", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1538", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1540", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1542", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1544", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1548", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1550", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1552", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1554", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1566", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1568", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1572", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1574", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1580", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1582", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1586", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1588", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1590", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1592", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1596", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1604", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1608", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1614", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1620", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1622", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1624", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1628", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1630", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1632", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1634", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1636", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1638", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1640", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1642", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1644", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1646", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1650", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1654", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1658", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1660", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1666", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1670", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1674", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1692", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1694", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1696", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1702", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1706", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1712", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1718", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1720", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1722", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1724", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1728", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1734", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1752", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1756", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1760", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1762", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1764", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1767", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1769", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1771", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1777", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1781", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1783", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1785", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1787", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1789", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1791", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1795", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1799", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1803", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1811", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1813", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1815", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1817", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1821", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1823", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1825", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1831", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1833", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1837", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1840", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1842", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1848", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1850", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1857", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1859", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1863", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1865", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1875", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1878", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1880", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1882", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1884", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1890", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1892", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1894", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1896", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1898", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1900", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1908", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1916", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1920", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1924", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1932", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1937", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1939", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1941", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1943", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1945", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1947", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1953", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1959", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1961", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1963", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1967", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1971", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1988", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1996", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("1998", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2000", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2004", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2010", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2020", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2026", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2028", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2030", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2032", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2036", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2048", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2050", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2052", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2059", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2061", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2063", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2065", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2067", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2073", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2075", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2077", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2079", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2083", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2085", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2091", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2093", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2097", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2099", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2101", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2103", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2105", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2107", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2111", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2113", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2119", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2123", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2125", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2129", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2131", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2133", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2135", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2137", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2141", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2143", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2145", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2147", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2149", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2153", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2157", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2159", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2161", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2163", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2165", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2167", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2169", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2171", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2175", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2177", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2179", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2181", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2185", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2189", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2191", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2193", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2195", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2197", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2199", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2201", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2203", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2207", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2209", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2211", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2213", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2215", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2217", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2219", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2221", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2223", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2225", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2227", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2229", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2232", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2237", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2241", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2247", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2249", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2251", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2253", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2255", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2257", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2259", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2261", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2263", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2265", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2267", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2269", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2271", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2275", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2277", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2279", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2281", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2283", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2285", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2289", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2291", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2293", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2295", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2297", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2299", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2301", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2305", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2307", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2309", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2311", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2313", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2315", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2317", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2319", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2321", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2322", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2325", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2327", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2329", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2331", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2333", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2335", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2337", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2339", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2342", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2344", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2346", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2348", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2350", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2352", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2354", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2356", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2358", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2360", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2362", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2364", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2366", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2368", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2370", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2372", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2374", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2376", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2378", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2380", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2384", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2386", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2388", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2390", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2392", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2394", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("2396", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("10188", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("10198", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("10200", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("10202", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("10204", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("10206", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("10208", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("10210", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("10212", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("10214", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("10216", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("10218", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("10220", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("10222", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17784", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17787", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17789", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17791", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17793", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17795", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17797", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17799", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17801", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17803", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17805", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17807", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17809", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17811", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17815", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17817", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17819", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17821", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17823", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17825", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17827", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17829", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17831", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17833", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17835", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17837", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17839", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17841", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17843", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17846", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17848", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17850", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17855", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17857", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17859", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17861", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17863", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17865", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17868", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17870", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17872", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17874", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17876", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17882", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17884", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17886", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17888", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17890", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17892", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17898", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17900", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17902", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17904", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17906", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17908", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17910", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17912", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17914", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17916", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17918", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17920", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17921", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17924", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17926", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17928", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17930", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17932", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17934", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17936", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17938", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17946", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17948", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17950", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17956", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17961", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17963", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17966", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17968", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17970", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17974", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17976", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17980", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17982", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17984", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17991", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17993", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17995", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17997", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("17999", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18001", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18007", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18010", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18014", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18016", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18020", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18022", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18025", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18027", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18029", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18031", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18033", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18035", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18037", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18039", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18041", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18043", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18045", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18047", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18049", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18053", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18054", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18073", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18075", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18080", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18084", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18088", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18092", "180", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18096", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18098", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18100", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18102", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18110", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18114", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18116", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18118", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18124", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18126", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18128", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18130", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18132", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18134", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18136", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18138", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18140", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18142", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18144", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18151", "180", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18155", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18178", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18192", "180", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18194", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18200", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18204", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18210", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18214", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18216", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18222", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18226", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18230", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18234", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18236", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18238", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18240", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18242", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18244", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18250", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18252", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18254", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18260", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18262", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18270", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18272", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18275", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18277", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18282", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18284", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18286", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18290", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18294", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18298", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18302", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18307", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18313", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18315", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18317", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18320", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18334", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18338", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18340", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18342", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18346", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18350", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18374", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18381", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18383", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18385", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18387", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18392", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18398", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18404", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18406", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18408", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18410", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18420", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18426", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18428", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18435", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18437", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18439", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18445", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18449", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18454", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18456", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18458", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18464", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18468", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18470", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18472", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18478", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18480", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18482", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18484", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18488", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18491", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18495", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18503", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18507", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18509", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18511", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18515", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18517", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18525", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18539", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18543", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18545", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18547", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18551", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18553", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18555", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18557", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18563", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18567", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18573", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18577", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18579", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18581", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18591", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18593", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18597", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18603", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18605", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18607", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18609", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18611", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18615", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18619", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18633", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18635", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18639", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18641", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18643", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18645", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18647", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18661", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18666", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18670", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18674", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18676", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18678", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18680", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18682", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18684", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18686", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18694", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18696", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18698", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18700", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18708", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18710", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18712", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18720", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18742", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18744", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18754", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18820", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("18822", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("19124", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("19126", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("19130", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("19132", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("19136", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("19138", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("19614", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("19646", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("19690", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("19712", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("19744", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("20082", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("20110", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("20709", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("21013", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("21027", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("21029", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("21037", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALUES("21039", "1", "0");
INSERT INTO `nqcpo_term_relationships` VALU