# Ballı Elektrik - Derinlemesine Spam Tarama Raporu

**Tarih:** 23 Şubat 2026  
**Proje:** Ballı Elektrik WordPress (MAMP localhost)  
**Kapsam:** Veritabanı + Dosya sistemi + Kod tabanı

---

## ÖZET

| Kategori | Durum | Detay |
|----------|-------|-------|
| **Veritabanı spam** | ⚠️ **KRİTİK** | Casino/bahis spam içerik tespit edildi |
| **Zararlı PHP kodu** | ✅ Temiz | Backdoor/eval/base64 kötüye kullanımı yok |
| **Şüpheli dosyalar** | ⚠️ Dikkat | Root'ta SQL dump, create_function kullanımı |
| **Yorum spam** | - | Tarama tamamlanamadı (timeout) |

---

## 1. VERİTABANI SPAM ANALİZİ

### 1.1 wpgo_pca_logs – Casino/Bahis Spam Enjeksiyonu

**Tablo:** `wpgo_pca_logs` (Post Creation Automation logs)  
**Tespit:** 96+ spam kayıt

Bu tablo, **otomatik içerik oluşturma** (PCA) sisteminden gelen logları tutuyor. Tüm kayıtlar **casino/bahis spam** içeriği gösteriyor:

| Özellik | Değer |
|---------|-------|
| Mesaj dili | Rusça ("Пост успешно создан" = Post başarıyla oluşturuldu) |
| Ana IP | 89.110.74.116 |
| İkincil IP | 185.68.244.20 |
| Tarih aralığı | 9 Kasım 2025 – 24 Aralık 2025 |
| Post ID aralığı | 34438 – 34589 |

**Örnek spam başlıkları:**
- "Die besten Neukundenboni in Österreich und Bet It All Casino-Angebote"
- "Royspins Casino Zahlungsmethoden"
- "Betify Casino Live Casino"
- "iWild Casino in België"
- "Tipwin Casino België"
- "Chipstars Casino UK"
- "PlayFrank Casino UK"
- "1win Canada live casino"
- "Pin-Up Casino"
- "Nine Casino"
- "Sol Casino"
- "Yolo247 in India"
- "Mines India"
- "1Win Uzbekistan"
- "Pin Up Bonus"
- "Aviator Pin Up"
- "Khelostar"

**Sonuç:** Site, bir **Post Creation Automation** eklentisi veya harici API üzerinden casino/bahis spam içeriği enjekte edilmiş. Bu içerikler `wpgo_posts` tablosuna yazılmış olabilir (post_id 34438–34589 aralığı).

### 1.2 Şüpheli Veritabanı Tabloları

| Tablo | Açıklama | Risk |
|-------|----------|------|
| `wpgo_pca_logs` | PCA log tablosu – spam kayıtları içeriyor | Yüksek |
| `wpgo_links` | WordPress standart blogroll tablosu | Düşük |
| `wpgo_ip_tracking` | IP takip tablosu (standart WP değil) | Orta – kökeni kontrol edilmeli |

---

## 2. DOSYA SİSTEMİ ANALİZİ

### 2.1 Root Dizinde SQL Dump – GÜVENLİK RİSKİ

**Dosya:** `/Applications/MAMP/htdocs/ballielektrik/u838283570_nuZH7.sql`  
**Boyut:** ~225 MB+  
**İçerik:** Tam veritabanı dökümü (phpMyAdmin export)

**Riskler:**
- Veritabanı yapısı ve tüm veriler düz metin halinde
- Kullanıcı bilgileri, parolalar (hash), API anahtarları açıkta
- Web root’ta olması, yanlış yapılandırmada doğrudan indirilebilir

**Öneri:** Bu dosyayı web root dışına taşıyın veya silin. Yedek gerekiyorsa güvenli bir dizinde tutun.

### 2.2 Zararlı Kod Taraması Sonuçları

**Taranan desenler:** `eval()`, `base64_decode`, `gzinflate`, `str_rot13`, `assert()`, `create_function`, `shell_exec`, `passthru`, `exec`, `system`

| Konum | Bulgu | Değerlendirme |
|-------|-------|---------------|
| wp-includes/* | base64_decode, gzinflate, shell_exec, exec | ✅ WordPress çekirdek – normal |
| wp-content/plugins/ingeniofy/widgets/* | create_function | ⚠️ PHP 7.2+ deprecated – güvenlik açığı değil, modernize edilmeli |
| wp-content/plugins/duplicator/* | shell_exec, exec, base64_decode | ✅ Duplicator eklentisi – normal |
| wp-content/plugins/elementor/* | base64_decode, eval (Twig) | ✅ Elementor – normal |
| Tema/özel kod | - | ✅ Şüpheli kullanım yok |

**Sonuç:** Backdoor, obfuscated malware veya kötüye kullanılan tehlikeli fonksiyon tespit edilmedi.

---

## 3. SPAM İÇERİK ÖNERİLERİ

### 3.1 Veritabanı Temizliği

MAMP MySQL’e bağlanıp aşağıdaki sorguları çalıştırın:

```sql
-- 1. Spam postları listele (önce kontrol)
SELECT ID, post_title, post_date, post_status, post_author 
FROM wpgo_posts 
WHERE ID BETWEEN 34438 AND 34589 
  AND post_type = 'post'
ORDER BY ID;

-- 2. wpgo_pca_logs tablosunu tamamen temizle
TRUNCATE TABLE wpgo_pca_logs;

-- 3. Spam postları sil (kalıcı - önce yedek alın!)
DELETE FROM wpgo_postmeta WHERE post_id BETWEEN 34438 AND 34589;
DELETE FROM wpgo_posts WHERE ID BETWEEN 34438 AND 34589 AND post_type = 'post';
```

### 3.2 PCA Eklentisi

`wpgo_pca_logs` tablosu oluşturan eklenti projede görünmüyor. Muhtemelen:
- Silinmiş
- Harici bir sistem (API) kullanılıyor
- Başka bir eklenti tarafından oluşturulmuş

**Öneri:** Bu tabloyu kullanmayı bırakıyorsanız `DROP TABLE wpgo_pca_logs` ile kaldırın. Kullanıyorsanız, erişim ve yetkilendirmeyi sıkı kontrol edin.

### 3.3 Root SQL Dosyası

```bash
# Güvenli yedek dizinine taşı
mv /Applications/MAMP/htdocs/ballielektrik/u838283570_nuZH7.sql ~/Desktop/ballielektrik-backup.sql

# Veya sil (yedek aldıysanız)
rm /Applications/MAMP/htdocs/ballielektrik/u838283570_nuZH7.sql
```

---

## 4. GÜVENLİK ÖNERİLERİ

1. **IP engelleme:** 89.110.74.116 ve 185.68.244.20 adreslerini firewall veya .htaccess ile engelleyin.
2. **Admin güvenliği:** wp-admin için IP kısıtlaması veya 2FA kullanın.
3. **Eklenti güncellemesi:** `create_function` kullanan ingeniofy widget’larını `add_action` ile yeniden yazın.
4. **Dosya izinleri:** SQL dump ve hassas dosyaların web’den erişilemez olduğundan emin olun.

---

## 5. TARAMA METODOLOJİSİ

- **Veritabanı:** SQL dump (`u838283570_nuZH7.sql`) ve Duplicator scan JSON incelendi
- **Kod:** grep ile zararlı PHP desenleri taranan
- **Spam desenleri:** casino, viagra, 1win, Pin Up, Betify vb. anahtar kelimeler

---

---

## 6. TEMİZLİK TAMAMLANDI (23 Şubat 2026)

| İşlem | Durum |
|-------|-------|
| SQL dump (u838283570_nuZH7.sql) | ✅ Web root'tan kaldırıldı (Desktop'a taşındı) |
| wpgo_pca_logs tablosu | ✅ TRUNCATE + DROP |
| Spam postlar (34438-34589) | ✅ Silindi |
| Spam IP engelleme | ✅ .htaccess'e eklendi (89.110.74.116, 185.68.244.20) |
| create_function modernizasyonu | ✅ 14 widget güncellendi (anonim fonksiyon) |
| **Kategori/etiket spam** | ✅ **3848 spam terim silindi** (2 tur: regex + whitelist) |
| **Kalan kategoriler** | Sadece 8 legitim: Genel, Elektrik, Güvenlik Kamerası, blog, News, Post, Review, uncategorized |

---
