<?php
class popular_widget extends WP_Widget
{
	public function __construct() { 
	
		$widget_ops = array('classname' => 'widget', 'description' => 'Select Category To Show Posts' );
		parent::__construct('latest-widget', '*Show Latest', $widget_ops);
	
	}
	

  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title = $instance['title'];
	$get_cate_posts = isset( $instance['get_cate_posts'] ) ? esc_attr( $instance['get_cate_posts'] ) : '';
	$nop = isset( $instance['nop'] ) ? esc_attr( $instance['nop'] ) : '';
?>
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
		 <?php esc_html_e('Title:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
	  </label>
	</p>   
  
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('get_cate_posts')); ?>">
		  <?php esc_html_e('Select Category:','kriate');?>
		  <select id="<?php echo esc_attr($this->get_field_id('get_cate_posts')); ?>" name="<?php echo esc_attr($this->get_field_name('get_cate_posts')); ?>" class="widefat">
			<?php
					foreach ( kriate_get_category_list_array('category') as $category){ ?>
						<option <?php if(esc_attr($get_cate_posts) == $category->slug){echo 'selected';}?> value="<?php echo esc_attr($category->slug);?>" >
							<?php echo substr($category->name, 0, 20);	if ( strlen($category->name) > 20 ) echo "...";?>
						</option>						
				<?php }?>
		  </select>
	  </label>
	 </p> 
	 
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('nop')); ?>">
		 <?php esc_html_e('Number of Posts To Display:','kriate');?> 
		  <input class="widefat" size="2" id="<?php echo esc_attr($this->get_field_id('nop')); ?>" name="<?php echo esc_attr($this->get_field_name('nop')); ?>" type="text" value="<?php echo esc_attr($nop); ?>" />
	  </label>
	</p>
<?php
  }
 
  function update($new_instance, $old_instance)
  {
  
    $instance = $old_instance;
    $instance['title'] = $new_instance['title'];
    $instance['get_cate_posts'] = $new_instance['get_cate_posts'];	
	$instance['nop'] = $new_instance['nop'];
    return $instance;
  }
  
	function widget($args, $instance)
	{  
		extract($args, EXTR_SKIP);
		$title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
		$get_cate_posts = isset( $instance['get_cate_posts'] ) ? esc_attr( $instance['get_cate_posts'] ) : '';		
		$nop = isset( $instance['nop'] ) ? esc_attr( $instance['nop'] ) : '';	
	
		if($nop == ""){$nop = '-1';}
		
		echo html_entity_decode($before_widget);	
	
			echo html_entity_decode($before_title);
			
			echo esc_attr($title);
			
			echo html_entity_decode($after_title);
			
			global $wpdb;
			
			echo '  <div class="rcnt-wrp">';

			$category_array = get_term_by('id', esc_attr($get_cate_posts), 'category');
			
			global $post;
			$args = array( 'numberposts' => $nop, 'category_name' => $get_cate_posts );
			$posts = get_posts( $args );
			foreach( $posts as $post ){ 
			
			setup_postdata($post); 
			
				if(strlen(get_the_title()) > 35){
					$title = esc_attr(mb_substr(get_the_title(), 0 , 35)).'...';
				}else{
					$title = get_the_title();
				}
				
				echo '
					<div class="rcnt-bx">
						<a class="brd-rd5" href="'.get_the_permalink().'" itemprop="url">'.get_the_post_thumbnail($post->ID, array(68,68)).'</a>
						<div class="rcnt-inf">
							<h6 itemprop="headline"><a href="'.get_the_permalink().'" itemprop="url">'.$title.'</a></h6>
							<span><i class="far fa-calendar-alt theme-clr"></i>'.get_the_date().'</span>
						</div>
					</div>';
			
			} // end foreach;
				
			echo '</div>';

			echo html_entity_decode($after_widget);	
	}
}

if ( ! version_compare( PHP_VERSION, '5.3.0', '>=' ) ) {
   add_action( 'widgets_init', create_function('', 'return register_widget("popular_widget");') );
}else{
    function popular_widget_init (){
        return register_widget('popular_widget');
    }
    add_action ('widgets_init', 'popular_widget_init');
}
?>