<?php
class footer_payment_gateway extends WP_Widget
{
  
	public function __construct() { 
	
		$widget_ops = array('classname' => 'widget', 'description' => 'Footer Paymnet Gateway Widget' );
		parent::__construct('footer_payment_gateway', '*Show Paymnet Gateways', $widget_ops);
	
	}
 
  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
	$title = $instance['title'];
	$kriate_title = isset( $instance['w_title'] ) ? esc_attr( $instance['w_title'] ) : '';
	$kriate_logo = isset( $instance['logo'] ) ? esc_attr( $instance['logo'] ) : get_template_directory_uri().'/assets/images/pay-method.png';	?>
	
	<p>
		<label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
			<?php esc_html_e('Title:','kriate');?>  
			<input class="widefat"  id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</label>
	</p>

	<p>
		<label for="<?php echo esc_attr($this->get_field_id('w_title')); ?>">
			<?php esc_html_e('Widget Label:','kriate');?>  
			<input class="widefat"  id="<?php echo esc_attr($this->get_field_id('w_title')); ?>" name="<?php echo esc_attr($this->get_field_name('w_title')); ?>" type="text" value="<?php echo esc_attr($kriate_title); ?>" />
		</label>
	</p>
	
	<p>
		<label for="<?php echo esc_attr($this->get_field_id('logo')); ?>">
			<?php esc_html_e('Image URL:','kriate');?>  
			<input class="widefat"  id="<?php echo esc_attr($this->get_field_id('logo')); ?>" name="<?php echo esc_attr($this->get_field_name('logo')); ?>" type="text" value="<?php echo esc_attr($kriate_logo); ?>" />
		</label>
	</p>

  
<?php
  
  }/* end of form function*/
 
  function update($new_instance, $old_instance)
  {
  
    $instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['w_title'] = $new_instance['w_title'];
		$instance['logo'] = $new_instance['logo'];
		
		return $instance;
  
  }/* end of update function */
 
	function widget($args, $instance)
	{
		
		extract($args, EXTR_SKIP);
		
		$kriate_title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$kriate_desc = isset( $instance['w_title'] ) ? esc_attr( $instance['w_title'] ) : '';
		$kriate_logo = isset( $instance['logo'] ) ? esc_attr( $instance['logo'] ) : '';
		
		
		
		echo '
		
		<div class="donat-methods text-center w-100">
			<h5 class="mb-0">'.$kriate_desc.'</h5>
			<img class="img-fluid" src="'.esc_url($kriate_logo).'" alt="'.esc_attr__('Featured Image','kriate').'">
		</div>';                 


		
		
	}/* end of widegat function */
	
}/* end of about_widget class */
	
if ( ! version_compare( PHP_VERSION, '5.3.0', '>=' ) ) {
   add_action( 'widgets_init', create_function('', 'return register_widget(footer_payment_gateway);') );
}else{
    function footer_payment_gateway_init (){
        return register_widget('footer_payment_gateway');
    }
    add_action ('widgets_init', 'footer_payment_gateway_init');
}	
?>