<?php

// Register our tweaked Category Archives widget
function myprefix_widgets_init() {
  register_widget( 'WP_Widget_Categories_custom' );
}
add_action( 'widgets_init', 'myprefix_widgets_init' );


/**
 * Duplicated and tweaked WP core Categories widget class
 */
class WP_Widget_Categories_Custom extends WP_Widget {

  function __construct() {
    $widget_ops = array( 'classname' => 'widget category_widget style2', 'description' => __( "A list of categories, with slightly tweaked output.", 'kriate'  ) );
    parent::__construct( 'categories_custom', __( '*Categories Custom', 'kriate' ), $widget_ops );
  }

  function widget( $args, $instance ) {
    extract( $args );

    $title = apply_filters( 'widget_title', empty( $instance['title'] ) ? __( 'Categories Custom', 'kriate'  ) : $instance['title'], $instance, $this->id_base);

    echo $before_widget;
    if ( $title )
      echo $before_title . $title . $after_title;
    ?>
   <ul class="caty mb-0 list-unstyled w-100">
    <?php
      // Get the category list, and tweak the output of the markup.
      $pattern = '#<li([^>]*)><a([^>]*)>(.*?)<\/a>\s*\(([0-9]*)\)\s*<\/li>#i';  // removed ( and )

      // $replacement = '<li$1><a$2>$3</a><span class="cat-count">$4</span>'; // no link on span
      // $replacement = '<li$1><a$2>$3</a><span class="cat-count"><a$2>$4</a></span>'; // wrap link in span
      $replacement = '<li$1><a$2><span class="cat-name">$3</span><span class="cat-count">$4</span></a>'; // give cat name and count a span, wrap it all in a link

      $subject      = wp_list_categories( 'echo=0&orderby=name&exclude=&title_li=&depth=1&show_count=1' );    
      print_r($subject);
	 
    ?>
    </ul>
    <?php
    echo $after_widget;
  }

  function update( $new_instance, $old_instance ) {
    $instance = $old_instance;
    $instance['title'] = strip_tags( $new_instance['title'] );
    $instance['count'] = 1;
    $instance['hierarchical'] = 0;
    $instance['dropdown'] = 0;

    return $instance;
  }

  function form( $instance ) {
    //Defaults
    $instance = wp_parse_args( (array) $instance, array( 'title' => '') );
    $title = esc_attr( $instance['title'] );
    $count = true;
    $hierarchical = false;
    $dropdown = false;
?>
    <p><label for="<?php echo $this->get_field_id('title', 'kriate' ); ?>"><?php _e( 'Title:', 'kriate'  ); ?></label>
    <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></p>

    <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('count'); ?>" name="<?php echo $this->get_field_name('count'); ?>"<?php checked( $count ); ?> disabled="disabled" />
    <label for="<?php echo $this->get_field_id('count'); ?>"><?php _e( 'Show post counts', 'kriate'  ); ?></label><br />
<?php
  }

}