<?php
class NewsletterWidgetSidebar extends WP_Widget
{
  
	public function __construct() { 
	
		$widget_ops = array('classname' => 'widget', 'description' => 'Newsletter Widget For Sidebar' );
		parent::__construct('NewsletterWidgetSidebar', '*NewsLetter Widget ', $widget_ops);
	
	}
 
  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
	$title = $instance['title'];
	$kriate_desc = isset( $instance['desc'] ) ? esc_attr( $instance['desc'] ) : ''; ?>
	
	<p>
		<label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
			<?php esc_html_e('Title:','kriate');?>  
			<input class="widefat"  id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</label>
	</p>

	<p>
		<label for="<?php echo esc_attr($this->get_field_id('desc')); ?>"></label>
		<?php esc_html_e('Add Contact Form 7 ID Only e.g 460:','kriate');?>  
        <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('desc')); ?>" name="<?php echo esc_attr($this->get_field_name('desc')); ?>"><?php echo esc_attr($kriate_desc); ?></textarea>
    </p>

  
<?php
  
  }/* end of form function*/
 
  function update($new_instance, $old_instance)
  {
  
    $instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['desc'] = $new_instance['desc'];
		
		return $instance;
  
  }/* end of update function */
 
	function widget($args, $instance)
	{
		
		extract($args, EXTR_SKIP);
		
		$kriate_title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$kriate_desc = isset( $instance['desc'] ) ? esc_attr( $instance['desc'] ) : '';
		
		echo html_entity_decode($before_widget); 
		
		echo '
		
		<div class="newsletter-widget text-center w-100 pat-bg thm-layer opc7 position-relative back-blend-multiply thm-bg" style="background-image: url('.get_template_directory_uri().'/assets/images/pattern-bg.jpg);">
			<h4>'.$kriate_title.'</h4>
			<div class="w-100">
				'.do_shortcode('[contact-form-7 id="460"]').'
			</div>
		</div>';                   

		/* WIDGET display CODE End*/
		echo html_entity_decode($after_widget);
		
		
	}/* end of widegat function */
	
}/* end of about_widget class */
	
if ( ! version_compare( PHP_VERSION, '5.3.0', '>=' ) ) {
   add_action( 'widgets_init', create_function('', 'return register_widget("NewsletterWidgetSidebar");') );
}else{
    function NewsletterWidgetSidebar_init (){
        return register_widget('NewsletterWidgetSidebar');
    }
    add_action ('widgets_init', 'NewsletterWidgetSidebar_init');
}	
?>