<?php
class map_widget extends WP_Widget
{
	public function __construct() { 
	
		$widget_ops = array('classname' => '', 'description' => 'Add Footer Map' );
		parent::__construct('map_widget', '*Show Map', $widget_ops);
	
	}
	

  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title = $instance['title'];
	$location_long = isset( $instance['long'] ) ? esc_attr( $instance['long'] ) : '';
	$location_lat = isset( $instance['lang'] ) ? esc_attr( $instance['lang'] ) : '';
?>
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
		 <?php esc_html_e('Title:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
	  </label>
	</p>

	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('long')); ?>">
		 <?php esc_html_e('Add Longitude:','kriate');?> 
		  <input class="widefat" size="2" id="<?php echo esc_attr($this->get_field_id('long')); ?>" name="<?php echo esc_attr($this->get_field_name('long')); ?>" type="text" value="<?php echo esc_attr($location_long); ?>" />
	  </label>
	</p>	
  

	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('lang')); ?>">
		 <?php esc_html_e('Add Langitude:','kriate');?> 
		  <input class="widefat" size="2" id="<?php echo esc_attr($this->get_field_id('lang')); ?>" name="<?php echo esc_attr($this->get_field_name('lang')); ?>" type="text" value="<?php echo esc_attr($location_lat); ?>" />
	  </label>
	</p>
<?php
  }
 
  function update($new_instance, $old_instance)
  {
  
    $instance = $old_instance;
    $instance['title'] = $new_instance['title'];
    $instance['long'] = $new_instance['long'];
	$instance['lang'] = $new_instance['lang'];
    return $instance;
  }
 
	function widget($args, $instance)
	{
		
		extract($args, EXTR_SKIP);
		$title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
		$location_long = isset( $instance['long'] ) ? esc_attr( $instance['long'] ) : '';		
		$location_lat = isset( $instance['lang'] ) ? esc_attr( $instance['lang'] ) : '';	
	
	
		echo html_entity_decode($before_widget);	

			echo html_entity_decode($before_title);
			
			echo esc_attr($title);
			
			echo html_entity_decode($after_title);
			
			global $kriate_options;
			
			$googleKey = $kriate_options['google_map_apikey'];
				
			if(!empty($googleKey)){ ?>

					<script src="http://maps.googleapis.com/maps/api/js?key=<?php echo esc_attr($googleKey); ?>"></script>
					<script>
						jQuery(document).ready(function($) {
							"use strict";
							//Footer Map
							if ($('#map_contact_2').length) {
								var map;
								var myLatLng = new google.maps.LatLng(<?php echo $location_lat; ?>, <?php echo $location_long; ?>);
								//Initialize MAP
								var myOptions = {
									zoom: 5,
									center: myLatLng,
									//disableDefaultUI: true,
									zoomControl: true,
									scrollwheel: false,
									mapTypeId: google.maps.MapTypeId.ROADMAP,
									mapTypeControl: false,
									styles: [{
										stylers: [{
											hue: '#2b2b2b'
										}, {
											saturation: -100,
										}, {
											lightness: 10
										}]
									}],
								}
								map = new google.maps.Map(document.getElementById('map_contact_2'), myOptions);
								//End Initialize MAP
								//Set Marker
								var marker = new google.maps.Marker({
									position: map.getCenter(),
									map: map,
									icon: '<?php echo get_template_directory_uri().'/images/footer-map-icon.png'?>'
								});
								marker.getPosition();
								//End marker
							}
							//Function End
						});
					</script>
					<?php
			}
			
			
			/* If Not Empty Map Lat Long API KEY */
			if(!empty($googleKey)){
				
				echo '

				<div class="footer-map">
					<div id="map_contact_2" class="map_canvas active"></div>
				</div>';
				
			}else{
			
				echo '
			
				<div class="footer-map">
					<h3>'.esc_html__('Please Enter Correct Map Details i.e API Key, Latitude, Longitude','kriate').'</h3>
				</div>';

			}

			echo html_entity_decode($after_widget);	
	}
}
add_action( 'widgets_init', create_function('', 'return register_widget("map_widget");') );?>