<?php
class contact_info_widget extends WP_Widget
{
  
	public function __construct() { 
	
		$widget_ops = array('classname' => 'widget', 'description' => 'Contact Infomation & Details' );
		parent::__construct('contact_info_widget', ' *Contact Info : Contact Us ', $widget_ops);
	
	}
 
  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title = $instance['title'];
	$widget_email = isset( $instance['w_email'] ) ? esc_html( $instance['w_email'] ) : '';
	$widget_phone = isset( $instance['w_phone'] ) ? esc_html( $instance['w_phone'] ) : '';
	$widget_address = isset( $instance['w_address'] ) ? esc_html( $instance['w_address'] ) : '';
	$widget_phone_label = isset( $instance['w_plabel'] ) ? esc_html( $instance['w_plabel'] ) : '';
	$widget_email_label = isset( $instance['w_elabel'] ) ? esc_html( $instance['w_elabel'] ) : '';
	$widget_address_label = isset( $instance['w_alabel'] ) ? esc_html( $instance['w_alabel'] ) : '';
?>
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
		 <?php esc_html_e('Title:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
	  </label>
	</p>   
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('w_plabel')); ?>">
		 <?php esc_html_e('Phone Label:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('w_plabel')); ?>" name="<?php echo esc_attr($this->get_field_name('w_plabel')); ?>" type="text" value="<?php echo esc_html($widget_phone_label); ?>" />
	  </label>
	</p> 
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('w_phone')); ?>">
		 <?php esc_html_e('Phone No:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('w_phone')); ?>" name="<?php echo esc_attr($this->get_field_name('w_phone')); ?>" type="text" value="<?php echo esc_html($widget_phone); ?>" />
	  </label>
	</p> 
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('w_elabel')); ?>">
		 <?php esc_html_e('Email Label:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('w_elabel')); ?>" name="<?php echo esc_attr($this->get_field_name('w_elabel')); ?>" type="text" value="<?php echo esc_html($widget_email_label); ?>" />
	  </label>
	</p> 
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('w_email')); ?>">
		 <?php esc_html_e('Email Address:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('w_email')); ?>" name="<?php echo esc_attr($this->get_field_name('w_email')); ?>" type="text" value="<?php echo esc_html($widget_email); ?>" />
	  </label>
	</p> 
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('w_alabel')); ?>">
		 <?php esc_html_e('Address Label:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('w_alabel')); ?>" name="<?php echo esc_attr($this->get_field_name('w_alabel')); ?>" type="text" value="<?php echo esc_html($widget_address_label); ?>" />
	  </label>
	</p> 
	
	
	<p>
	  <label for="<?php echo esc_attr($this->get_field_id('w_address')); ?>">
		 <?php esc_html_e('Address:','kriate');?>  
		  <input class="widefat"  id="<?php echo esc_attr($this->get_field_id('w_address')); ?>" name="<?php echo esc_attr($this->get_field_name('w_address')); ?>" type="text" value="<?php echo esc_html($widget_address); ?>" />
	  </label>
	</p> 

<?php
  
  }/* end of form function*/
 
  function update($new_instance, $old_instance)
  {
  
    $instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['w_address'] = $new_instance['w_address'];
		$instance['w_email'] = $new_instance['w_email'];
		$instance['w_phone'] = $new_instance['w_phone'];
		$instance['w_elabel'] = $new_instance['w_elabel'];
		$instance['w_plabel'] = $new_instance['w_plabel'];
		$instance['w_alabel'] = $new_instance['w_alabel'];
		
		return $instance;
  
  }/* end of update function */
 
	function widget($args, $instance)
	{
		
		extract($args, EXTR_SKIP);
		
		$widget_title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
		$kriate_w_address = isset( $instance['w_address'] ) ? esc_attr( $instance['w_address'] ) : '';	
		$kriate_w_phone = isset( $instance['w_phone'] ) ? esc_attr( $instance['w_phone'] ) : '';	
		$kriate_w_email = isset( $instance['w_email'] ) ? esc_attr( $instance['w_email'] ) : '';	
		$kriate_w_elabel = isset( $instance['w_elabel'] ) ? esc_attr( $instance['w_elabel'] ) : '';
		$kriate_w_plabel = isset( $instance['w_plabel'] ) ? esc_attr( $instance['w_plabel'] ) : '';
		$kriate_w_alabel = isset( $instance['w_alabel'] ) ? esc_attr( $instance['w_alabel'] ) : '';
		
		echo html_entity_decode($before_widget);
    
		if (!empty($widget_title))
			echo html_entity_decode($before_title);
			echo esc_attr($widget_title);
			echo html_entity_decode($after_title);
		
		echo '	
		<ul class="cont-info-list2 mb-0 list-unstyled w-100">
			<li><i class="thm-clr">'.$kriate_w_plabel.'</i>'.$kriate_w_phone.'</li>
			<li><i class="thm-clr">'.$kriate_w_elabel.'</i><a href="mailto: '.$kriate_w_email.'" title="">'.$kriate_w_email.'</a></li>
			<li><i class="thm-clr">'.$kriate_w_alabel.'</i>'.$kriate_w_address.'</li>
		</ul>';
		
	/* WIDGET display CODE End*/
	echo html_entity_decode($after_widget);
		
		
	}/* end of widegat function */
	
}/* end of contact_info_widget class */

if ( ! version_compare( PHP_VERSION, '5.3.0', '>=' ) ) {
   add_action( 'widgets_init', create_function('', 'return register_widget("contact_info_widget");') );
}else{
    function contact_info_widget_init (){
        return register_widget('contact_info_widget');
    }
    add_action ('widgets_init', 'contact_info_widget_init');
}
?>