<?php
class bio_desc_widget extends WP_Widget
{
  
	public function __construct() { 
	
		$widget_ops = array('classname' => 'widget', 'description' => 'Author Intro  Widget' );
		parent::__construct('bio_desc_widget', '*Author Info', $widget_ops);
	
	}
 
  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
	$title = $instance['title'];
	$kriate_desc = isset( $instance['desc'] ) ? esc_attr( $instance['desc'] ) : '';
	$kriate_logo = isset( $instance['logo'] ) ? esc_attr( $instance['logo'] ) : get_template_directory_uri().'/assets/images/logo2.png';
	$fb_url = isset( $instance['fb_url'] ) ? esc_attr( $instance['fb_url'] ) : 'https://facebook.com';
	$author_name = isset( $instance['author_name'] ) ? esc_attr( $instance['author_name'] ) : ''; ?>
	
	<p>
		<label for="<?php echo esc_attr($this->get_field_id('logo')); ?>">
			<?php esc_html_e('Author URL:','kriate');?>  
			<input class="widefat"  id="<?php echo esc_attr($this->get_field_id('logo')); ?>" name="<?php echo esc_attr($this->get_field_name('logo')); ?>" type="text" value="<?php echo esc_attr($kriate_logo); ?>" />
		</label>
	</p>
	
	<p>
		<label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
			<?php esc_html_e('Title:','kriate');?>  
			<input class="widefat"  id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</label>
	</p>

	<p>
		<label for="<?php echo esc_attr($this->get_field_id('desc')); ?>"></label>
		<?php esc_html_e('Add Description:','kriate');?>  
        <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('desc')); ?>" name="<?php echo esc_attr($this->get_field_name('desc')); ?>"><?php echo esc_attr($kriate_desc); ?></textarea>
    </p>
	
	<p>
		<label for="<?php echo esc_attr($this->get_field_id('fb_url')); ?>">
			<?php esc_html_e('Facebook URL:','kriate');?>  
			<input class="widefat"  id="<?php echo esc_attr($this->get_field_id('fb_url')); ?>" name="<?php echo esc_attr($this->get_field_name('fb_url')); ?>" type="text" value="<?php echo esc_attr($fb_url); ?>" />
		</label>
	</p>
	
	<p>
		<label for="<?php echo esc_attr($this->get_field_id('author_name')); ?>">
			<?php esc_html_e('Author Name:','kriate');?>  
			<input class="widefat"  id="<?php echo esc_attr($this->get_field_id('author_name')); ?>" name="<?php echo esc_attr($this->get_field_name('author_name')); ?>" type="text" value="<?php echo esc_attr($author_name); ?>" />
		</label>
	</p>
	
	

  
<?php
  
  }/* end of form function*/
 
  function update($new_instance, $old_instance)
  {
  
    $instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['desc'] = $new_instance['desc'];
		$instance['logo'] = $new_instance['logo'];
		$instance['author_name'] = $new_instance['author_name'];
		$instance['fb_url'] = $new_instance['fb_url'];
		
		return $instance;
  
  }/* end of update function */
 
	function widget($args, $instance)
	{
		
		extract($args, EXTR_SKIP);
		
		$kriate_title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$kriate_desc = isset( $instance['desc'] ) ? esc_attr( $instance['desc'] ) : '';
		$kriate_logo = isset( $instance['logo'] ) ? esc_attr( $instance['logo'] ) : '';
		$author_name = isset( $instance['author_name'] ) ? esc_attr( $instance['author_name'] ) : '';
		$fb_url = isset( $instance['fb_url'] ) ? esc_attr( $instance['fb_url'] ) : '';
		
		echo html_entity_decode($before_widget); 
		
		echo '
		
		<div class="about-widget text-center w-100">
			<div class="about-widget-img d-inline-block">
				<a class="thm-bg rounded-circle" href="'.$fb_url.'" title=""><i class="fab fa-facebook-f"></i></a>
				<img class="img-fluid rounded-circle" src="'.esc_url($kriate_logo).'" alt="'.esc_attr__('Author Image','kriate').'">
			</div>
			<h4 class="mb-0">'.$kriate_title.'</h4>
			<p class="mb-0">“'.$kriate_desc.'”</p>
			<span class="d-block"><img class="img-fluid" src="'.get_template_directory_uri().'/assets/images/about-widget-icon1.png" alt="About Widget Icon 1">'.$author_name.'</span>
		</div>';                    

		/* WIDGET display CODE End*/
		echo html_entity_decode($after_widget);
		
		
	}/* end of widegat function */
	
}/* end of about_widget class */
	
if ( ! version_compare( PHP_VERSION, '5.3.0', '>=' ) ) {
   add_action( 'widgets_init', create_function('', 'return register_widget("bio_desc_widget");') );
}else{
    function bio_desc_widget_init (){
        return register_widget('bio_desc_widget');
    }
    add_action ('widgets_init', 'bio_desc_widget_init');
}	
?>