<?php

// Bismillah...

	defined( 'ABSPATH' ) or die( 'Stop! You can not do this!' );

	include_once('PrayTimeNamaz.php');
	
	if (!class_exists('uCal')) {
			include_once('uCal.php');
		}
	
/********** Modified Shortcode - Ingeniofy ***********/
   
	function kriate_salat_times_shortcode() {
	
		$st_options = get_option("st_options");
		if (!is_array($st_options)) {
			$st_options = array(
				'lat_long_tz' => '23.7 90.4 6',
				'lat' => '23.7',
				'long' => '90.4',
				'custom_loc' => '0',
				'custom_loc' => '0',
				'calc_method' => '1',
				'asr_method' => '0',
				'time_format' => '1',
				'time_zone' => '6',
				'daylight' => '0',
				'wgt_title1' => 'Salat Times',
				'location' => 'London, UK',
				'show_date' => '1',
				'show_hdate' => '0',
				'hijri_adjust' => '-0',
				'dir' => 'inherit',
				'iqamah' => '900',
				'width' => '100%',
				'halign' => 'center',
				'talign' => 'center',
				'walign' => 'left',
				'scheme' => '#4189dd #ffffff #4472C4 #ffffff #B4C6E7 #D9E2F3 #000000',
				'custom' => 'Salat-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamah',
				'lang' => 'en',
				'timetable' => '0' );
		}
	   
	   /* Get Option Value From Theme Options */
		global $kriate_options;
		
		$jummah_title = $kriate_options['jummah_title']; 
		$jummah_start = $kriate_options['jummah_start']; 
		$jummah_iqamah = $kriate_options['jummah_iqamah']; 
		
	
		if (!$st_options['timetable'] == '1') { // Automatic Timetable
	
			$prayTime = new PrayTimeNamaz();
			$prayTime->setCalcMethod($st_options['calc_method']);
			$prayTime->setAsrMethod($st_options['asr_method']);
			$prayTime->setTimeFormat($st_options['time_format']);
	
			$location = explode(" ", $st_options['lat_long_tz']);
	
			if ($st_options['custom_loc'] == '0') {
				$latitude = $location[0];
				$longitude = $location[1];
				$time_zone = $location[2]+$st_options['daylight'];
			}else{
				$latitude = $st_options['lat'];
				$longitude = $st_options['long'];
				$time_zone = $st_options['time_zone']+$st_options['daylight'];
			}
	
			$d = new uCal;
			$offset = $time_zone *60*60;
			$hoffset = $st_options['hijri_adjust']*60*60;
		
		
			if ($st_options['show_date'] == '1') {
				$stdate = '<br/>'. gmdate("l, jS F, Y", time()+$offset);
			}
			if ($st_options['show_hdate'] == '1') {
				$sthdate = '<br/>'. $d->date("jS F, Y", time()+$hoffset);
			}
			
	
			$color = explode(" ", $st_options['scheme']);
	
			if ($st_options['lang'] == "en") {
				$cl = explode("-", "Salat-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamah");
			}else{
				$cl = explode("-", $st_options['custom']); 
			}
			
			$times = $prayTime->getPrayerTimes(time(), $latitude, $longitude, $time_zone);
			
			$iqamah_offset = '+'.$st_options['iqamah']. 'minutes';
			
			$return_time = '
			<li><span class="thm-clr">'.$cl[2].'</span><span>'. $times[0] . '</span><span>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[0]))).'</span></li>
			<li><span class="thm-clr">'.$cl[4].'</span><span>'. $times[2] . '</span><span>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[2]))).'</span></li>
			<li><span class="thm-clr">'.$cl[5].'</span><span>'. $times[3] . '</span><span>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[3]))).'</span></li>
			<li><span class="thm-clr">'.$cl[6].'</span><span>'. $times[4] . '</span><span>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[4]))).'</span></li>
			<li><span class="thm-clr">'.$cl[7].'</span><span>'. $times[6] . '</span><span>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[6]))).'</span></li>';
			
			if(!empty($jummah_title) || !empty($jummah_start) || !empty($jummah_iqamah)){
				$return_time .= '<li><span class="thm-clr">'.$jummah_title.'</span><span>'. $jummah_start . '</span><span>'.$jummah_iqamah.'</span></li>';
			}else{
				$return_time .= '<li><span class="thm-clr">'.$cl[9].'</span><span>'. $times[2] . '</span><span>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[2]))).'</span></li>';
			}
			
			return $return_time;


		}else{ // Manual Timetable
		
			$prayTime = new PrayTimeNamaz();
			$prayTime->setCalcMethod($st_options['calc_method']);
			$prayTime->setAsrMethod($st_options['asr_method']);
			$prayTime->setTimeFormat($st_options['time_format']);
	
			$location = explode(" ", $st_options['lat_long_tz']);
	
			if ($st_options['custom_loc'] == '0') {
				$latitude = $location[0];
				$longitude = $location[1];
				$time_zone = $location[2]+$st_options['daylight'];
			}else{
				$latitude = $st_options['lat'];
				$longitude = $st_options['long'];
				$time_zone = $st_options['time_zone']+$st_options['daylight'];
			}
	
			$d = new uCal;
			$offset = $time_zone *60*60;
			$hoffset = $st_options['hijri_adjust']*60*60;
		
			
			if ($st_options['show_date'] == '1') {
				$stdate = '<br/>'. gmdate("l, jS F, Y", time()+$offset);
			}
			if ($st_options['show_hdate'] == '1') {
				$sthdate = '<br/>'. $d->date("jS F, Y", time()+$hoffset);
			}
			
	
			$dir = WP_CONTENT_DIR .'/plugin_data/salat-times/';
			
			$file = $dir . 'manual_time.data';
			$lines = file($file);//file in to an array

			$lineN = gmdate("z", time()+$offset);
		
			$color = explode(" ", $st_options['scheme']);
		
			if ($st_options['lang'] == "en") {
				$cl = explode("-", "Salat-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamah");
			} else { $cl = explode("-", $st_options['custom']); }
			
			$times = explode("--", $lines[$lineN]);
			
			$return_time = '
			<li><span class="thm-clr">'.$cl[2].'</span><span>'. $times[1] . '</span><span>'. $times[6] . '</span></li>
			<li><span class="thm-clr">'.$cl[4].'</span><span>'. $times[2] . '</span><span>'. $times[7] . '</span></li>
			<li><span class="thm-clr">'.$cl[5].'</span><span>'. $times[3] . '</span><span>'. $times[8] . '</span></li>
			<li><span class="thm-clr">'.$cl[6].'</span><span>'. $times[4] . '</span><span>'. $times[9] . '</span></li>
			<li><span class="thm-clr">'.$cl[7].'</span><span>'. $times[5] . '</span><span>'. $times[10] . '</span></li>';
			
			if(!empty($jummah_title) || !empty($jummah_start) || !empty($jummah_iqamah)){
				$return_time .= '<li><span class="thm-clr">'.$jummah_title.'</span><span>'. $jummah_start . '</span><span>'. $jummah_iqamah . '</span></li>';
			}else{
				$return_time .= '<li><span class="thm-clr">'.$cl[9].'</span><span>'. $times[2] . '</span><span>'. $times[7] . '</span></li>';
			}
			
			return $return_time;
			
		}
	}


/* Ramadan Timings */
function kriate_ramadan_timings_shortcode() {
	
	$st_options = get_option("st_options");
	if (!is_array($st_options)) {
		$st_options = array(
			'lat_long_tz' => '23.7 90.4 6',
			'lat' => '23.7',
			'long' => '90.4',
			'custom_loc' => '0',
			'iqamah' => '900',
			'calc_method' => '1',
			'asr_method' => '0',
			'time_format' => '1',
			'time_zone' => '6',
			'daylight' => '0',
			'wgt_title1' => 'Salat Times',
			'location' => 'London, UK',
			'show_date' => '1',
			'show_hdate' => '0',
			'hijri_adjust' => '-0',
			'dir' => 'inherit',
			'width' => '100%',
			'halign' => 'center',
			'talign' => 'center',
			'walign' => 'left',
			'scheme' => '#4189dd #ffffff #4472C4 #ffffff #B4C6E7 #D9E2F3 #000000',
			'custom' => 'Salah-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamah',
			'lang' => 'en',
			'timetable' => '0' );
	}
	
	
	/* Variable Redux Options */
	global $kriate_options;
	
	/* Get Ramadan Time Table */
	$ramadan_times = $kriate_options['ramadan-sehr-iftar'];
	/* Convert Times Into Array */
	$ramadan_times = explode(PHP_EOL, $ramadan_times); /* explode at every end of line eol */
	$lineN = gmdate("z", time());
	$times = explode("--", $ramadan_times[$lineN]);
	
	$prayTime = new PrayTimeNamaz();
	$prayTime->setCalcMethod($st_options['calc_method']);
	$prayTime->setAsrMethod($st_options['asr_method']);
	$prayTime->setTimeFormat($st_options['time_format']);
	
	$location = explode(" ", $st_options['lat_long_tz']);
	
	if ($st_options['custom_loc'] == '0') {
		$latitude = $location[0];
		$longitude = $location[1];
		$time_zone = $location[2]+$st_options['daylight'];
	}else { 
		$latitude = $st_options['lat'];
		$longitude = $st_options['long'];
		$time_zone = $st_options['time_zone']+$st_options['daylight'];
	}
	
	$d = new uCal;
	$offset = $time_zone *60*60;
	$hoffset = $st_options['hijri_adjust']*60*60;
		

	if ($st_options['show_date'] == '1') {
		$stdate = gmdate("l, jS F, Y", time()+$offset);
	}
	if ($st_options['show_hdate'] == '1') {
		$sthdate = $d->date("jS F, Y", time()+$hoffset);
	}

	
	return array($times[1], $times[2], $stdate, $sthdate);
		
}

/* Hijri Date Only */
function kriate_hijridate_shortcode() {
	
	$st_options = get_option("st_options");
	if (!is_array($st_options)) {
		$st_options = array(
			'lat_long_tz' => '23.7 90.4 6',
			'lat' => '23.7',
			'long' => '90.4',
			'custom_loc' => '0',
			'iqamah' => '900',
			'calc_method' => '1',
			'asr_method' => '0',
			'time_format' => '1',
			'time_zone' => '6',
			'daylight' => '0',
			'wgt_title1' => 'Salat Times',
			'location' => 'London, England',
			'show_date' => '1',
			'show_hdate' => '0',
			'hijri_adjust' => '-0',
			'dir' => 'inherit',
			'width' => '100%',
			'halign' => 'center',
			'talign' => 'center',
			'walign' => 'left',
			'scheme' => '#4189dd #ffffff #4472C4 #ffffff #B4C6E7 #D9E2F3 #000000',
			'custom' => 'Salat-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamah',
			'lang' => 'en',
			'timetable' => '0' );
	}
	
	$location = explode(" ", $st_options['lat_long_tz']);
	
	if ($st_options['custom_loc'] == '0') {
		$latitude = $location[0];
		$longitude = $location[1];
		$time_zone = $location[2]+$st_options['daylight'];
	}else { 
		$latitude = $st_options['lat'];
		$longitude = $st_options['long'];
		$time_zone = $st_options['time_zone']+$st_options['daylight'];
	}
	
	$d = new uCal;
	$offset = $time_zone *60*60;
	$hoffset = $st_options['hijri_adjust']*60*60;
		

	if ($st_options['show_date'] == '1') {
		$stdate = gmdate("l, jS M, Y", time()+$offset);
	}
	if ($st_options['show_hdate'] == '1') {
		$sthdate = $d->date("jS F, Y", time()+$hoffset);
	}
	
	
	$output = $sthdate.' - '.$stdate.' - '.$st_options['location']; 
	
	return $output;
}


/********** Modified Shortcode - Ingeniofy ***********/
   
	function kriate_salat_times_elementor_widget_shortcode() {
	
		$st_options = get_option("st_options");
		if (!is_array($st_options)) {
			$st_options = array(
				'lat_long_tz' => '23.7 90.4 6',
				'lat' => '23.7',
				'long' => '90.4',
				'custom_loc' => '0',
				'custom_loc' => '0',
				'calc_method' => '1',
				'asr_method' => '0',
				'time_format' => '1',
				'time_zone' => '6',
				'iqamah' => '900',
				'daylight' => '0',
				'wgt_title1' => 'Salat Times',
				'location' => 'London, UK',
				'show_date' => '1',
				'show_hdate' => '0',
				'hijri_adjust' => '-0',
				'dir' => 'inherit',
				'width' => '100%',
				'halign' => 'center',
				'talign' => 'center',
				'walign' => 'left',
				'scheme' => '#4189dd #ffffff #4472C4 #ffffff #B4C6E7 #D9E2F3 #000000',
				'custom' => 'Salat-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat',
				'lang' => 'en',
				'timetable' => '0' );
		}
	   
	    /* Get Option Value From Theme Options */
		global $kriate_options;
		
		$jummah_title = $kriate_options['jummah_title']; 
		$jummah_start = $kriate_options['jummah_start']; 
		$jummah_iqamah = $kriate_options['jummah_iqamah']; 
	
		if (!$st_options['timetable'] == '1') { // Automatic Timetable
	
			$prayTime = new PrayTimeNamaz();
			$prayTime->setCalcMethod($st_options['calc_method']);
			$prayTime->setAsrMethod($st_options['asr_method']);
			$prayTime->setTimeFormat($st_options['time_format']);
	
			$location = explode(" ", $st_options['lat_long_tz']);
	
			if ($st_options['custom_loc'] == '0') {
				$latitude = $location[0];
				$longitude = $location[1];
				$time_zone = $location[2]+$st_options['daylight'];
			}else{
				$latitude = $st_options['lat'];
				$longitude = $st_options['long'];
				$time_zone = $st_options['time_zone']+$st_options['daylight'];
			}
	
			$d = new uCal;
			$offset = $time_zone *60*60;
			$hoffset = $st_options['hijri_adjust']*60*60;
		
			
			if ($st_options['show_date'] == '1') {
				$stdate = '<br/>'. gmdate("l, jS F, Y", time()+$offset);
			}
			if ($st_options['show_hdate'] == '1') {
				$sthdate = '<br/>'. $d->date("jS F, Y", time()+$hoffset);
			}
			
	
			$color = explode(" ", $st_options['scheme']);
	
			if ($st_options['lang'] == "en") {
				$cl = explode("-", "Start-Iqamah-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat");
			}else{
				$cl = explode("-", $st_options['custom']); 
			}
	

			$times = $prayTime->getPrayerTimes(time(), $latitude, $longitude, $time_zone);
			
			$iqamah_offset = '+'.$st_options['iqamah']. 'minutes';

			$return_time = '
				<li class="pr-tm-bx wow fadeInRight" data-wow-duration="1s">
					<h6 itemprop="headline">'.$cl[2].'</h6>
					<span><i class="thm-clr">'.$cl[0].':</i>'. $times[0] . '</span>
					<span><i class="thm-clr">'.$cl[1].':</i>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[0]))).'</span>
				</li>
				<li class="pr-tm-bx wow fadeInRight" data-wow-duration="1.5s">
					<h6 itemprop="headline">'.$cl[4].'</h6>
					<span><i class="thm-clr">'.$cl[0].':</i>'. $times[2] . '</span>
					<span><i class="thm-clr">'.$cl[1].':</i>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[2]))).'</span>
				</li>
				<li class="pr-tm-bx wow fadeInRight" data-wow-duration="2s">
					<h6 itemprop="headline">'.$cl[5].'</h6>
					<span><i class="thm-clr">'.$cl[0].':</i>'. $times[3] . '</span>
					<span><i class="thm-clr">'.$cl[1].':</i>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[3]))).'</span>
				</li>
				<li class="pr-tm-bx wow fadeInRight" data-wow-duration="2.5s">
					<h6 itemprop="headline">'.$cl[6].'</h6>
					<span><i class="thm-clr">'.$cl[0].':</i>'. $times[4] . '</span>
					<span><i class="thm-clr">'.$cl[1].':</i>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[4]))).'</span>
				</li>
				<li class="pr-tm-bx wow fadeInRight" data-wow-duration="3s">
					<h6 itemprop="headline">'.$cl[7].'</h6>
					<span><i class="thm-clr">'.$cl[0].':</i>'. $times[6] . '</span>
					<span><i class="thm-clr">'.$cl[1].':</i>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[6]))).'</span>
				</li>';
				
				$return_time .= '
				<li class="pr-tm-bx spc-pr-tm wow fadeInRight" data-wow-duration="3.5s">
					<h6 itemprop="headline">'.$jummah_title.'</h6>
					<span><i>'.$cl[0].':</i> '. $jummah_start . '</span>
					<span><i>'.$cl[1].':</i> '.$jummah_iqamah.'</span>
				</li>';
		
				return $return_time;

		}else{ // Manual Timetable - Elementor Namaz Time Widget
		
			$prayTime = new PrayTimeNamaz();
			$prayTime->setCalcMethod($st_options['calc_method']);
			$prayTime->setAsrMethod($st_options['asr_method']);
			$prayTime->setTimeFormat($st_options['time_format']);
	
			$location = explode(" ", $st_options['lat_long_tz']);
	
			if ($st_options['custom_loc'] == '0') {
				$latitude = $location[0];
				$longitude = $location[1];
				$time_zone = $location[2]+$st_options['daylight'];
			}else{
				$latitude = $st_options['lat'];
				$longitude = $st_options['long'];
				$time_zone = $st_options['time_zone']+$st_options['daylight'];
			}
	
			$d = new uCal;
			$offset = $time_zone *60*60;
			$hoffset = $st_options['hijri_adjust']*60*60;
		
			
			if ($st_options['show_date'] == '1') {
				$stdate = '<br/>'. gmdate("l, jS F, Y", time()+$offset);
			}
			if ($st_options['show_hdate'] == '1') {
				$sthdate = '<br/>'. $d->date("jS F, Y", time()+$hoffset);
			}
			
			$dir = WP_CONTENT_DIR .'/plugin_data/salat-times/';
			
			$file = $dir . 'manual_time.data';
			$lines = file($file);//file in to an array

			$lineN = gmdate("z", time()+$offset);
		
			$color = explode(" ", $st_options['scheme']);
		
			if ($st_options['lang'] == "en") {
				$cl = explode("-", "Salat-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat");
			} else { $cl = explode("-", $st_options['custom']); }

			$times = explode("--", $lines[$lineN]);
				
			$return_time = '
					
					<li class="pr-tm-bx">
						<h6 itemprop="headline">'.$cl[2].'</h6>
						<span><i class="thm-clr">'.$cl[0].':</i>'. $times[1] . '</span>
						<span><i class="thm-clr">'.$cl[1].':</i>'. $times[6] . '</span>
					</li>
					<li class="pr-tm-bx">
						<h6 itemprop="headline">'.$cl[4].'</h6>
						<span><i class="thm-clr">'.$cl[0].':</i>'. $times[2] . '</span>
						<span><i class="thm-clr">'.$cl[1].':</i>'. $times[7] . '</span>
					</li>
					<li class="pr-tm-bx">
						<h6 itemprop="headline">'.$cl[5].'</h6>
						<span><i class="thm-clr">'.$cl[0].':</i>'. $times[3] . '</span>
						<span><i class="thm-clr">'.$cl[1].':</i>'. $times[8] . '</span>
					</li>
					<li class="pr-tm-bx">
						<h6 itemprop="headline">'.$cl[6].'</h6>
						<span><i class="thm-clr">'.$cl[0].':</i>'. $times[4] . '</span>
						<span><i class="thm-clr">'.$cl[1].':</i>'. $times[9] . '</span>
					</li>
					<li class="pr-tm-bx">
						<h6 itemprop="headline">'.$cl[7].'</h6>
						<span><i class="thm-clr">'.$cl[0].':</i>'. $times[5] . '</span>
						<span><i class="thm-clr">'.$cl[1].':</i>'. $times[10] . '</span>
					</li>';
					
					$return_time .= '
					<li class="pr-tm-bx spc-pr-tm">
						<h6 itemprop="headline">'.$jummah_title.'</h6>
						<span><i>'.$cl[0].':</i> '. $jummah_start . '</span>
						<span><i>'.$cl[1].':</i> '.$jummah_iqamah.'</span>
					</li>';
			
					return $return_time;				
		
		}
	}


function kriate_namaz_timings_header() {
		$st_options = get_option("st_options");
	  if (!is_array($st_options)) {
		$st_options = array(
			'lat_long_tz' => '23.7 90.4 6',
			'lat' => '23.7',
			'long' => '90.4',
			'custom_loc' => '0',
			'calc_method' => '1',
			'iqamah' => '900',
			'asr_method' => '0',
			'time_format' => '1',
			'time_zone' => '6',
			'wgt_title1' => 'Salat Times',
			'location' => 'London, UK',
			'custom' => 'Salat-Time-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat',
			'show_date' => '1',
			'width' => '100%',
			'lang' => 'en', 'timetable' => '0' );
	   }
	
	   
	$location = explode(" ", $st_options['lat_long_tz']);
	
	if ($st_options['custom_loc'] == '0') {
		$latitude = $location[0];
		$longitude = $location[1];
		$time_zone = $location[2];
		}
	else { $latitude = $st_options['lat'];
		$longitude = $st_options['long'];
		$time_zone = $st_options['time_zone'];
		}
	
	$offset = $time_zone *60*60;
	
	$date = '<br/>'. gmdate("l, jS F, Y", time()+$offset);
	
	if ($st_options['lang'] == "en") {
		$cl = explode("-", "Start-Iqamah-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat");
	}else{
		$cl = explode("-", $st_options['custom']); 
	}
	
	$prayTime = new PrayTimeNamaz();
	$prayTime->setCalcMethod($st_options['calc_method']);
	$prayTime->setAsrMethod($st_options['asr_method']);
	$prayTime->setTimeFormat($st_options['time_format']);
	
	/* Get Option Value From Theme Options */
	global $kriate_options;

	$head_1 = $kriate_options['topbar_salat_head1'];
	$head_2 = $kriate_options['topbar_salat_head2'];
	$head_3 = $kriate_options['topbar_salat_head3'];
	
	if (!$st_options['timetable'] == '1') { /* automatic data in header dropdown*/
		$times = $prayTime->getPrayerTimes(time(), $latitude, $longitude, $time_zone);
		
		if ($st_options['lang'] == "en") {
		$cl = explode("-", "Start-Iqamah-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat");
	}else{
		$cl = explode("-", $st_options['custom']); 
	}
		
	$iqamah_offset = '+'.$st_options['iqamah']. 'minutes';
		
		//Modified Code
		print('
			  <table class="table table-borderless">
				  <thead>
					<tr>
					  <th scope="col">'.$head_1.'</th>
					  <th scope="col">'.$head_2.'</th>
					  <th scope="col">'.$head_3.'</th>
					</tr>
				  </thead>
				  <tbody>
					<tr>
					  <td><i class="fa fa-sun-o" aria-hidden="true"></i>'.$cl[2].'</td>
					  <td>'.$times[0].'</td>
					  <td>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[0]))).'</td>
					</tr>
					<tr>
					  <td><i class="fa fa-sun-o" aria-hidden="true"></i>'.$cl[4].'</td>
					  <td>'.$times[2].'</td>
					  <td>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[2]))).'</td>
					</tr>
					<tr>
					  <td><i class="fa fa-sun-o" aria-hidden="true"></i>'.$cl[5].'</td>
					  <td>'.$times[3].'</td>
					  <td>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[3]))).'</td>
					</tr>
					<tr>
					  <td><i class="fa fa-moon-o" aria-hidden="true"></i>'.$cl[6].'</td>
					  <td>'.$times[5].'</td>
					  <td>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[5]))).'</td>
					</tr>
					<tr>
					  <td><i class="fa fa-moon-o" aria-hidden="true"></i>'.$cl[7].'</td>
					  <td>'.$times[6].'</td>
					  <td>'.date('g:i a', strtotime("$iqamah_offset", strtotime($times[6]))).'</td>
					</tr>
				  </tbody>
				</table>
			</div>'
		);
	
	}else{ /* MANUAL data in header dropdown */
	
	
		$dir = WP_CONTENT_DIR .'/plugin_data/salat-times/';
				
		$file = $dir . 'manual_time.data';
		$lines = file($file);//file in to an array

		$lineN = gmdate("z", time());
		
		$times = explode("--", $lines[$lineN]);
		
		if ($st_options['lang'] == "en") {
			$cl = explode("-", "Start-Iqamah-Fajr-Sunrise-Zuhr-Asr-Magrib-Isha-Begins-Jamaat");
		}else{
			$cl = explode("-", $st_options['custom']); 
		}
		
		
		//Modified Code
		print('
			  <table class="table table-borderless">
				  <thead>
					<tr>
					  <th scope="col">'.$head_1.'</th>
					  <th scope="col">'.$head_2.'</th>
					  <th scope="col">'.$head_3.'</th>
					</tr>
				  </thead>
				  <tbody>
					<tr>
					  <td><i class="fa fa-sun-o" aria-hidden="true"></i><strong>'.$cl[2].'</strong></td>
					  <td>'.$times[1].'</td>
					  <td>'.$times[6].'</td>
					</tr>
					<tr>
					  <td><i class="fa fa-sun-o" aria-hidden="true"></i><strong>'.$cl[4].'</strong></td>
					  <td>'.$times[2].'</td>
					  <td>'.$times[7].'</td>
					</tr>
					<tr>
					  <td><i class="fa fa-sun-o" aria-hidden="true"></i><strong>'.$cl[5].'</strong></td>
					  <td>'.$times[3].'</td>
					  <td>'.$times[8].'</td>
					</tr>
					<tr>
					  <td><i class="fa fa-moon-o" aria-hidden="true"></i><strong>'.$cl[6].'</strong></td>
					  <td>'.$times[4].'</td>
					  <td>'.$times[9].'</td>
					</tr>
					<tr>
					  <td><i class="fa fa-moon-o" aria-hidden="true"></i><strong>'.$cl[7].'</strong></td>
					  <td>'.$times[5].'</td>
					  <td>'.$times[10].'</td>
					</tr>					
				  </tbody>
				</table>
			</div>'
		);	
	}
}


// ========== Action Links =================
 
function st_action_links($links) {
	$links[] = '<a href="' . get_admin_url(null, 'options-general.php?page=salat_times') . '">Settings</a>';
	return $links;
}

	add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'st_action_links');

// =====================
add_shortcode('kriate_salat_times', 'kriate_salat_times_shortcode');
add_shortcode('kriate_salat_headers', 'kriate_namaz_timings_header');
add_shortcode('kriate_ramadan_timings', 'kriate_ramadan_timings_shortcode');
add_shortcode('kriate_salat_times_elementor', 'kriate_salat_times_elementor_widget_shortcode');
add_shortcode('kriate_hijri_date', 'kriate_hijridate_shortcode');

    if(is_admin())
    include 'salat_times_admin.php';
?>