<?php /* Theme Dependent Functions */
	
	/* Event Block For Elementor Element Event Grid */
	function kriate_events_grid_elementor_block($heading = '', $caption = '', $icon_class = '', $top_image = '', $category = '', $post_count = '', $pagination = ''){

		if (class_exists('EM_Events')) {
			
			if($heading || $caption){ $top_classes = "pt-90 pb-80"; }else { $top_classes = "pt-120 pb-280"; }
														 
			$output = '
			
			<section>
                <div class="w-100 '.$top_classes.' position-relative">';
				if($top_image){ 
					$output .= '<img class="img-fluid sec-top-mckp position-absolute" src="'.esc_url($top_image).'" alt="'.esc_attr__('Events','kriate').'">'; 
				}
				
				$output .= '
                    <div class="container">';
					if($heading || $caption){
						$output .= '
							<div class="sec-title text-center w-100">
								<div class="sec-title-inner d-inline-block">';
									if($icon_class){ $output .= '<i class="thm-clr '.$icon_class.'"></i>'; }
									if($heading){ $output .= '<h2 class="mb-0">'.$heading.'</h2>'; }
									if($caption){ $output .= '<p class="mb-0">'.$caption.'</p>'; }
									$output .= '
								</div>
							</div>';
					}	
						
					$output .= '	
                        <div class="event-wrap res-row w-100">
                            <div class="row">';

								if (class_exists('EM_Events')) {
																		 
									global $EM_Events,$bp;
										
									$counter = rand(1,1000);
									$order = 'ASC';
									$limit = $post_count;
									$offset = '';
									$rowno = 0;
									$event_count = 0;
				
									$argu = array('pagination'=>1,'category'=>$category, 'group'=>'this','scope'=>'future', 'limit' => $limit, 'order' => $order);
									$argu['page'] = (!empty($_REQUEST['pno']) && is_numeric($_REQUEST['pno']) )? $_REQUEST['pno'] : 1;
									$EM_Events = EM_Events::get( $argu );
													
									$events_count = count ( $EM_Events );

									if($events_count > 0){
																
										foreach ( $EM_Events as $event ) {
										
										/* International Date Format */
										$localised_start_date = date_i18n(get_option('dbem_date_format'), $event->start);
										$localised_end_date = date_i18n(get_option('dbem_date_format'), $event->end);
										
										/* Location Functions */
										if(!empty($event->location_id->name)){
											$location_summary = "<b>" . $event->get_location()->name . "</b><br/>" . $event->get_location()->address . " - " . $event->get_location()->town;
										}else{
											$location_summary = '';
										}
										
										/* Event Day and Month */
										$event_month_alpha = date('M',$event->start);
										$event_day = date('d',$event->start);
										
										
										/* Get Dates In Parts */
										$event_year = date('y',$event->start);
										$event_year_4digit = date('Y',$event->start);
										$event_month = date('m',$event->start);
										$event_month_alpha = date('M',$event->start);
										$event_day = date('d',$event->start);
										
										/* Change Time Format */
										if($event->start_time <> ''){
											$event_start_time_count = date("G,i,s", strtotime($event->start_time));
										}
										
										$event_element_id = $event->event_id; 
									
										$content = str_replace(']]>', ']]&gt;',$event->post_content); 
										
										if(strlen($content >  65)){
										
												$content = mb_substr($content, 0 , 65).'...';
												
										}else{
										
												$content = $content;
										}
										
										if(($event->start_time) <> ''){
										  
										  $event_time = date("g:i a", strtotime($event->start_time)) .' - '.  date("g:i a", strtotime($event->end_time));
										  
										
										}
										
										if(!empty($event->get_location()->name)){
										
											$event_location = $event->get_location()->name;
										
										}else{
										
											$event_location = '';
										}
										

										$formatted_event_date =  date(get_option('date_format'),strtotime($event->start_date));
										
										
										$featured_image_url = get_the_post_thumbnail_url($event->post_id, array( 370, 260, 'bfi_thumb' => true ));
										
										static $event_counter = 1;
										
										$kriate_event_year = date('Y',$event->start);
										$kriate_event_month = date('m',$event->start);
										$kriate_event_day = date('d',$event->start);
										$kriate_event_start_time_count = date("G:i:s", strtotime($event->start_time));

										$event_counter_formatted = sprintf("%02d", $event_counter); 
										
										/* Event Currency, Event Booking Price */
										$currency = ''; $price = '';
										$currency = get_post_meta( $event->ID, 'event_booking_currency', true );
										$price = get_post_meta( $event->ID, 'event_booking_price', true );
										
										$output .= '
											<div class="col-md-6 col-sm-6 col-lg-4">
												<div class="event-box w-100">';
												
												if($featured_image_url){
													$output .= '
														<div class="event-img overflow-hidden position-relative w-100">
															<a href="'.esc_url($event->guid).'" title=""><img class="img-fluid w-100" src="'.esc_url($featured_image_url).'" alt="'.esc_attr__('Featured Image','kriate').'"></a>
														</div>';
												}
													
												$output .= '	
													<div class="event-info pat-bg gray-layer opc85 position-relative back-blend-multiply gray-bg w-100" style="background-image: url('.get_template_directory_uri().'/assets/images/pattern-bg.jpg);">
														<span class="event-loc d-block thm-clr"><i class="fas fa-map-marker-alt"></i>'.$event_location.'</span>
														<h3 class="mb-0"><a href="'.esc_url($event->guid).'" title="">'.wp_trim_words( $event->event_name , 6, '...' ).'</a></h3>
														<span class="event-time d-block thm-clr">'.$event_time.'</span>';
														if($currency || $price){
															$output .= '
																<span class="event-price d-block"><sup>'.$currency.'</sup>'.$price.'<i>'.esc_html__('Booking Price','kriate').'</i></span>';
														}
														
														$output .= '
													</div>
												</div>
											</div>';
										
											$event_counter++;
										}
									}else{
										
										$output .='<div class="event-box"><h6>'.esc_html__('No Future Published Event Found','kriate').'</h6></div>';
									}
								} /* endif */ 
								$output .= '
							</div>
						</div>';
						if($pagination == 'Yes'){
							$events_count = EM_Events::count($argu);
							$output .='<div class="pagination-wrap text-center">';
							$output .= EM_Events::get_pagination_links($argu, $events_count);
							$output .='</div>';
						}
						$output .= '
					</div>
				</div><!-- Events Wrap -->
               </div>
              </div>
            </section>';
			
		} wp_reset_query(); /* endif */ 
		
		return $output;
	}

	/* ======== Post View Counter ====== */
	function kriate_get_post_view() {
		$count = get_post_meta( get_the_ID(), 'post_views_count', true );
		return "$count";
	}
	function kriate_set_post_view() {
		$key = 'post_views_count';
		$post_id = get_the_ID();
		$count = (int) get_post_meta( $post_id, $key, true );
		$count++;
		update_post_meta( $post_id, $key, $count );
	}
	function kriate_posts_column_views( $columns ) {
		$columns['post_views'] = 'Views';
		return $columns;
	}
	function kriate_posts_custom_column_views( $column ) {
		if ( $column === 'post_views') {
			echo kriate_get_post_view();
		}
	}
	add_filter( 'manage_posts_columns', 'kriate_posts_column_views' );
	add_action( 'manage_posts_custom_column', 'kriate_posts_custom_column_views' );
	
	/* Social Sharing Function */
	function kriate_post_social_shares($post_id){
			
		/* Get current page URL  */
        $post_url   = rawurlencode( esc_url( get_permalink() ) );

		/* Get current page title */
		$pshare_title = str_replace( ' ', '%20', get_the_title());
		
		/* Get Post Thumbnail for pinterest */
		$pshare_thumb = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'full' );
		
		$facebook_sharing = sprintf('https://www.facebook.com/sharer/sharer.php?u=%1$s&t=%2$s', $post_url, $pshare_title);
        $twitter_sharing = sprintf('https://twitter.com/intent/tweet?text=%2$s&url=%1$s', $post_url, $pshare_title);
		$googleplus_sharing = sprintf('https://plus.google.com/share?url=%1$s', $post_url);
		$linkedIn = sprintf('https://www.linkedin.com/shareArticle?url=%1$s&title=%2$s&mini=true', $post_url, $pshare_title);
		
		$return_html = '';
		/* Facebook Share */
		$return_html .= '<a class="facebook-clr" href="'.esc_url($facebook_sharing).'" title="'.esc_attr__('Facebook','kriate').'" data-toggle="tooltip" data-placement="top" itemprop="url" target="_blank"><i class="fab fa-facebook-f"></i></a>';
		/* Twitter Share */
		$return_html .= '<a class="twitter-clr" href="'.esc_url($twitter_sharing).'" title="'.esc_attr__('Twitter','kriate').'" data-toggle="tooltip" data-placement="top" itemprop="url" target="_blank"><i class="fab fa-twitter"></i></a>';
		/*  LinkedIn Share */
		$return_html .= '<a class="google-clr" href="'.esc_url($linkedIn).'" title="'.esc_attr__('Linkedin','kriate').'" data-toggle="tooltip" data-placement="top" itemprop="url" target="_blank"><i class="fab fa-linkedin-in"></i></a>';
		
	
		return $return_html;
	}
	
	/*-----------------------------------------------------------*/
    /*   Add RelatedRelated Posts (functions.php)
    /*-----------------------------------------------------------*/
	function kriate_related_posts($post_id, $count){

		$tags = wp_get_post_tags($post_id);
		
		$returnable_html = '';
		
		if ($tags){
			$first_tag = $tags[0]->term_id;
			$args=array(
				'tag__in' => array($first_tag),
				'post__not_in' => array($post_id),
				'posts_per_page'=>$count,
				'ignore_sticky_posts '=> 1
			);
			$my_query = new WP_Query($args); 
			
			if( $my_query->have_posts() ) {
				
				$returnable_html = '
				
				<div class="pst-rltd-wrp">
					<h6 itemprop="headline">'.esc_html__('Related Articles:','kriate').'</h6>    
					    <div class="remove-ext3">
							 <div class="row">';
					            	while ($my_query->have_posts()) : $my_query->the_post(); global $post;
						
    								$archive_year  = get_the_time('Y'); 
    								$archive_month = get_the_time('m'); 
    								$archive_day   = get_the_time('d'); 
    								
									/* Get Comment Count */
									$comment_count = wp_count_comments( $post->ID );
									
									$comment_count = $comment_count->total_comments;
									
									$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 370, 240, 'bfi_thumb' => true ));
    								
    								$returnable_html .= '
    							        	<div class="col-md-4 col-sm-6 col-lg-4">
												<div class="article-box">
													<div class="article-thmb">';
														if(!empty($featured_image_url)){
															$returnable_html .= '<a href="'.get_the_permalink().'" itemprop="url"><img src="'.esc_url($featured_image_url).'" alt="'.esc_attr__('Blog Thumbnail','kriate').'" itemprop="image"></a>';
														}
													$returnable_html .= '
													</div>
													<div class="article-info">
														'.get_avatar( $post->post_author, 72 , '', '', array('class' => 'brd-rd50')).'
														<span class="article-author">'.esc_html__('Posted By','kriate').' <a class="theme-clr" href="'.get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ).'" itemprop="url">'.get_the_author_meta( 'display_name' , $post->post_author ).'</a></span>
														<h5 itemprop="headline"><a href="'.get_the_permalink().'" itemprop="url">'.get_the_title().'</a></h5>
														<ul class="article-meta">
															<li><a class="theme-clr" href="'.get_day_link( $archive_year, $archive_month, $archive_day).'" itemprop="url">'.date_i18n( get_option( 'date_format' ), strtotime( get_the_date() ) ).'</a></li>
															<li>'.get_comments_number(). esc_html__(' Comments','kriate').'</li>
														</ul>
													</div>
												</div>
											</div>';
					            
					            	endwhile;  wp_reset_query();	
							
						       	$returnable_html .= '
				        	</div>
				        </div>
			    </div>';
			}
										
		}
		
		return $returnable_html;
	}
	
	/* Event Detail Organizers */
	function kriate_speakers_list($selected_category){
		
		global $post;
		
		$args = array( 
			'post_type' 		=> 'team',
			'posts_per_page' 	=> 3,
			'tax_query' => array(
				array(
					'taxonomy' 	=> 'team-category',
					'terms' 	=> $selected_category,
					'field' 	=> 'term_id',
				)
			), 
			'post_status'      	=> 'publish',
			'orderby' 			=> 'date',
			'order' 			=> 'DESC'
		);
		
		query_posts($args);
		
		if ( have_posts() ) { 
		
			while ( have_posts() ): the_post(); 
			
			$team_designation = ''; $team_facebook = ''; $team_linkedin = ''; $team_twitter = '';
			$team_designation = get_post_meta( get_the_ID(), 'team_designation', true );
			$team_facebook = get_post_meta( get_the_ID(), 'team_facebook', true );
			$team_linkedin = get_post_meta( get_the_ID(), 'team_linkedin', true );
			$team_twitter = get_post_meta( get_the_ID(), 'team_twitter', true ); ?>
			
				<div class="col-md-4 col-sm-6 col-lg-4">
					<div class="team-box text-center w-100">
						<div class="team-img overflow-hidden position-relative w-100">
							<a href="<?php echo get_the_permalink(); ?>" itemprop="url"><?php echo get_the_post_thumbnail($post->ID, array( 310, 310, 'bfi_thumb' => true )); ?></a>
							<?php
							if($team_facebook || $team_twitter || $team_linkedin){ ?>
								
								<div class="social-links2 text-center d-inline-flex position-absolute">
									<?php if($team_facebook){ ?> 
										<a class="facebook" href="<?php echo esc_url($team_facebook); ?>" title="Facebook" target="_blank"><i class="fab fa-facebook-f"></i></a>
									<?php } ?>
									<?php if($team_twitter){ ?> <a class="twitter" href="<?php echo esc_url($team_twitter); ?>" title="Twitter" target="_blank"><i class="fab fa-twitter"></i></a><?php } ?>
									
									<?php if($team_linkedin){ ?><a class="youtube" href="<?php echo esc_url($team_linkedin); ?>" title="Youtube" target="_blank"><i class="fab fa-linkedin-in"></i></a><?php } ?>
									
								</div>
							
							<?php } ?>
						</div>
						<div class="team-info">
							<h3 class="mb-0"><a href="<?php echo get_the_permalink(); ?>" title=""><?php echo get_the_title(); ?></a></h3>
							<?php if($team_designation){  ?>
								<span class="d-block thm-clr"><?php echo esc_html($team_designation); ?></span>
							<?php } ?>
						</div>
					</div>
				</div>
			
			<?php endwhile; wp_reset_query();
		}
					
	}
	
	/* WooCommerce Cart For Header */
	function custom_mini_cart() { 
		$html_cart = '
			<div class="crt-bx">
				<a class="theme-clr" href="'.get_permalink( wc_get_page_id( 'cart' ) ).'" itemprop="url"><i class="flaticon-basket"></i><span class="brd-rd50">'.WC()->cart->get_cart_contents_count().'</span></a>
			</div>';
		return $html_cart;
	}
	add_shortcode( 'custom_woo_cart', 'custom_mini_cart' );
	
	/* Event Detail Page Map */
	function kriate_get_event_map($map_lat, $map_long){
	
		global $kriate_options;
				
			$googleKey = $kriate_options['google_map_apikey'];

					
			if(!empty($googleKey)){ ?>
				<script src="https://maps.googleapis.com/maps/api/js?key=<?php echo esc_attr($googleKey); ?>"></script>
				<script>
					jQuery(document).ready(function ($) {
						'use strict';

						var marker;

						function initMap() {
							var map = new google.maps.Map(document.getElementById('event-loc2'), {
								zoom: 15,
								center: {lat: <?php echo $map_lat;?>, lng: <?php echo $map_long;?>}
							});

							marker = new google.maps.Marker({
								map: map,
								draggable: true,
								animation: google.maps.Animation.DROP,
								position: {lat: <?php echo $map_lat;?>, lng: <?php echo $map_long;?>}
							});
							marker.addListener('click', toggleBounce);
						}

						function toggleBounce() {
							if (marker.getAnimation() !== null) {
								marker.setAnimation(null);
							} else {
								marker.setAnimation(google.maps.Animation.BOUNCE);
							}
						}

						google.maps.event.addDomListener(window, 'load', initMap);

					});
				</script>
				<?php 
			} ?>
			
			
			<h3 itemprop="headline"><?php esc_html_e('Location','kriate');?></h3>
			<div class="event-loc2 w-100" id="event-loc2"></div>
				
	<?php
	} 

	
	/* Event Block For Elementor Element Event Grid */
	function kriate_events_namaz_elementor_block($category_name = '', $num_posts = '', $num_characters = '', $description = '', $caption = '', $heading = '', $bg_image = '', $namaz_colorh= '', $namaz_defaulth= '', $salat = '', $start = '', $iqamah = '', $onoffhdate = ''){

		if (class_exists('EM_Events')) {
			
			$output = '
			
			<section class = "alim">
				<div class="gap bottom-spac140 gray-layer opc95">';
				if(!empty($bg_image)){ $output .= '<div class="fixed-bg" style="background-image: url('.esc_url($bg_image).');"></div>'; }
				$output .= '
					<div class="container">
						<div class="evnt-pry-wrap">
							<div class="row">
								<div class="col-md-8 col-sm-12 col-lg-8">
									<div class="sec-title">';
										if(($caption) || ($heading)){
											$output .= '
												<div class="sec-title-inner">
													<h3><span>'.$caption.'</span> '.$heading.'</h3>
												</div>';
										}
										if($description) { $output .= '<p>'.$description.'</p>';}
										$output .= '
									</div>
									<div class="evnt-wrap remove-ext5">
										<div class="row mrg20">';
										if (class_exists('EM_Events')) {
																			
										global $EM_Events,$bp;
											
										$counter = rand(1,1000);
										$order = 'ASC';
										$limit = $num_posts;
										$offset = '';
										$rowno = 0;
										$event_count = 0;
					
										$argu = array('pagination'=>1,'category'=>$category_name, 'group'=>'this','scope'=>'future', 'limit' => $limit, 'order' => $order);
										$argu['page'] = (!empty($_REQUEST['pno']) && is_numeric($_REQUEST['pno']) )? $_REQUEST['pno'] : 1;
										$EM_Events = EM_Events::get( $argu );
														
										$events_count = count ( $EM_Events );


										if($events_count > 0){
																	
											foreach ( $EM_Events as $event ) {
											
												/* International Date Format */
											$localised_start_date = date_i18n(get_option('dbem_date_format'), $event->start);
											$localised_end_date = date_i18n(get_option('dbem_date_format'), $event->end);
											
											$today = date ( "Y-m-d" );
											
											if(!empty($event->location_id->name)){
												$location_summary = "<b>" . $event->get_location()->name . "</b><br/>" . $event->get_location()->address . " - " . $event->get_location()->town;
											}else{
												$location_summary = '';
											}
											
											if ($event->start_date < $today && $event->end_date < $today){
												$class .= " past";
											}
											
											/* Check Event Status */
											if ( !$event->status ){
												$class .= " pending";
											}	
											
											
											/* Event Day and Month */
											$event_month_alpha = date('M',$event->start);
											$event_day = date('d',$event->start);
											
											
											/* Get Dates In Parts */
											$event_year = date('y',$event->start);
											$event_year_4digit = date('Y',$event->start);
											$event_month = date('m',$event->start);
											$event_month_alpha = date('M',$event->start);
											$event_day = date('d',$event->start);
											
											/* Change Time Format */
											if($event->start_time <> ''){
												$event_start_time_count = date("G,i,s", strtotime($event->start_time));
											}
											
											$thumbnail_id = get_post_thumbnail_id( $event->post_id );
											$thumbnail = wp_get_attachment_image_src( $thumbnail_id , array(261,231));
											
											$event_element_id = $event->event_id; 
										
											$content = str_replace(']]>', ']]&gt;',$event->post_content); 
											
											if(strlen($content >  $num_characters)){
											
													$content = mb_substr($content, 0 , $num_characters).'...';
													
											}else{
											
													$content = $content;
											}
											
											if(($event->start_time) <> ''){
											
											$event_time = date("g:i a", strtotime($event->start_time)) .' to '.  date("g:i a", strtotime($event->end_time));
											
											
											}
											
											if(!empty($event->get_location()->name)){
											
												$event_location = $event->get_location()->name;
											
											}else{
											
												$event_location = '';
											}
											

											$formatted_event_date =  date(get_option('date_format'),strtotime($event->start_date));
											
											
											$featured_image_url = get_the_post_thumbnail_url($event->post_id, array( 365, 215, 'bfi_thumb' => true ));
											
											static $event_counter = 1;
											
											$kriate_event_year = date('Y',$event->start);
											$kriate_event_month = date('m',$event->start);
											$kriate_event_day = date('d',$event->start);
											$kriate_event_start_time_count = date("G:i:s", strtotime($event->start_time));

											$output  .= '
											
											<div class="col-md-6 col-sm-6 col-lg-6">
												<div class="evnt-box">
													<div class="evnt-thmb">
														<a href="'.esc_url($event->guid).'" title=""><img src="'.esc_url($featured_image_url).'" alt="'.esc_attr__('Featured Image','kriate').'"></a>
													</div>
													<div class="evnt-info">
														<h4><a href="'.esc_url($event->guid).'" title="">'.$event->name.'</a></h4>
														<ul class="pst-mta">
															<li><i class="thm-clr far fa-calendar-alt"></i>'.$formatted_event_date.'</li>
															<li><i class="thm-clr far fa-clock"></i>'.$event_time.'</li>
														</ul>
														'.wpautop($content).'
													</div>
												</div>
											</div>';
											
												
												$event_counter++;
											}
										}else{
											
											$output .= '<div class="event-box"><h6>'.esc_html__('No Future Published Event Found','kriate').'</h6></div>';
										}
									} /* endif */ 
									wp_reset_query(); /* endif */        
										
											
											
										$output .= '	
										</div>
									</div><!-- Events Wrap -->
								</div>
								<div class="col-md-4 col-sm-12 col-lg-4">';
									if(($namaz_colorh) || ($namaz_defaulth)){ 
										$output .= '
											<div class="sec-title">
												<div class="sec-title-inner">
													<h3>'.$namaz_colorh.' <span>'.$namaz_defaulth.'</span></h3>
												</div>
											</div>';
									}
									$output .= '
									<ul class="prayer-times">
									<li class="pry-tim-hed"><span>'.$salat.'</span><span>'.$start.'</span><span>'.$iqamah.'</span></li>';
										if(shortcode_exists('kriate_salat_times')){ $output .= do_shortcode('[kriate_salat_times]'); }
										$output .= '
									</ul>';
									/* Hijri Date */
									if(shortcode_exists('kriate_hijri_date') && $onoffhdate == 'yes'){ $output .= do_shortcode('[kriate_hijri_date]'); }
									$output .= '
								</div>
							</div>
						</div><!-- Events & Prayer Wrap -->
					</div>
				</div>
			</section>';
			
			return $output;
		}
	}
	
	function events_sermon_elementor_block($category = '', $count = ''){ ?>
		<div class="event-caro">
			<?php 
			if (class_exists('EM_Events')) {
												 
			global $EM_Events,$bp;
				
			$counter = rand(1,1000);
			$order = 'ASC';
			$limit = $count;
			$offset = '';
			$rowno = 0;
			$event_count = 0;

			$argu = array('pagination'=>1,'category'=>$category, 'group'=>'this','scope'=>'future', 'limit' => $limit, 'order' => $order);
			$argu['page'] = (!empty($_REQUEST['pno']) && is_numeric($_REQUEST['pno']) )? $_REQUEST['pno'] : 1;
			$EM_Events = EM_Events::get( $argu );
							
			$events_count = count ( $EM_Events );

			if($events_count > 0){
										
				foreach ( $EM_Events as $event ) {
				
				/* International Date Format */
				$localised_start_date = date_i18n(get_option('dbem_date_format'), $event->start);
				$localised_end_date = date_i18n(get_option('dbem_date_format'), $event->end);
				
				/* Location Functions */
				if(!empty($event->location_id->name)){
					$location_summary = "<b>" . $event->get_location()->name . "</b><br/>" . $event->get_location()->address . " - " . $event->get_location()->town;
				}else{
					$location_summary = '';
				}
				
				/* Event Day and Month */
				$event_month_alpha = date('M',$event->start);
				$event_day = date('d',$event->start);
				
				
				/* Get Dates In Parts */
				$event_year = date('y',$event->start);
				$event_year_4digit = date('Y',$event->start);
				$event_month = date('m',$event->start);
				$event_month_alpha = date('M',$event->start);
				$event_day = date('d',$event->start);
				
				/* Change Time Format */
				if($event->start_time <> ''){
					$event_start_time_count = date("G,i,s", strtotime($event->start_time));
				}
				
				$event_element_id = $event->event_id; 
			
				$content = str_replace(']]>', ']]&gt;',$event->post_content); 
				
				if(strlen($content >  65)){
				
						$content = mb_substr($content, 0 , 65).'...';
						
				}else{
				
						$content = $content;
				}
				
				if(($event->start_time) <> ''){
				  
				  $event_time = date("g:i a", strtotime($event->start_time)) .' - '.  date("g:i a", strtotime($event->end_time));
				  
				
				}
				
				if(!empty($event->get_location()->name)){
				
					$event_location = $event->get_location()->name;
				
				}else{
				
					$event_location = '';
				}
				

				$formatted_event_date =  date(get_option('date_format'),strtotime($event->start_date));
				
				
				$featured_image_url = get_the_post_thumbnail_url($event->post_id, array( 160, 130, 'bfi_thumb' => true ));
				
				static $event_counter = 1;
				
				$kriate_event_year = date('Y',$event->start);
				$kriate_event_month = date('m',$event->start);
				$kriate_event_day = date('d',$event->start);
				$kriate_event_start_time_count = date("G:i:s", strtotime($event->start_time));

				$event_counter_formatted = sprintf("%02d", $event_counter); 
				
				/* Event Currency, Event Booking Price */
				$currency = ''; $price = '';
				$currency = get_post_meta( $event->ID, 'event_booking_currency', true );
				$price = get_post_meta( $event->ID, 'event_booking_price', true ); ?>
				
				<div class="event-list-box d-flex flex-wrap align-items-center w-100">
					<div class="event-img2 overflow-hidden position-relative"><a href="<?php echo esc_url($event->guid); ?>" title=""><img class="img-fluid w-100" src="<?php echo esc_url($featured_image_url); ?>" alt="<?php esc_attr__('Featured Image','kriate'); ?>"></a></div>
					<div class="event-info2">
						<h3 class="mb-0"><a href="<?php echo esc_url($event->guid); ?>" title=""><?php echo $event->name; ?></a></h3>
						<ul class="event-meta mb-0 list-unstyled d-inline-flex flex-wrap">
							<li class="thm-clr"><i class="far fa-calendar"></i><?php echo $formatted_event_date; ?> @ <?php echo $event_time; ?></li>
						</ul>
					</div>
				</div>
				
				<?php }
			} ?>
		</div>
		<?php
		}
	}
	

	function kriate_progress_bar_campaign($ID, $Percentage){
	
	/* Circle Full JS */
	wp_enqueue_script( 'waypoints-min', get_template_directory_uri() . '/assets/js/waypoints.min.js', array('jquery'), '1.0.0', true );
	wp_enqueue_script( 'circlefull-min', get_template_directory_uri() . '/assets/js/circle-progress.min.js', array('jquery'), '1.0.0', true ); ?>
	
	<script>
		jQuery(document).ready(function($){
			'use strict';
			$("#goal-prog<?php echo $ID; ?>").waypoint(function(){
			  $("#goal-prog<?php echo $ID; ?>").circleProgress({
				value: 0.<?php echo $Percentage; ?>,
				fill: {color: '#147736'},
				thickness: 5,
				emptyFill: '#fff',
				size: 100
			  }).on('circle-animation-progress', function(event, progress) {
				$(this).find('span').html(Math.round(<?php echo $Percentage; ?> * progress) + '<i>%</i>');
			  });
			}, { offset: '70%'})
		});
	</script>
	
	<?php } 
	
	function kriate_cmb2_get_all_terms() {
		$args = array(
			'taxonomy' => 'team-category',
			'hide_empty' => false
		);

		$terms = get_terms( $args );

		foreach( $terms as $term ) {
			$select_items[ $term->slug ] = $term->name;
		}

		return $select_items;
	}
	
	function kriate_cmb2_get_all_sidebars() {
		
		global $wp_registered_sidebars;
		
		$sidebars = $wp_registered_sidebars;
		
		$select_items = array();

		foreach( $sidebars as $sidebar ) {
			$select_items[ $sidebar['id'] ] = $sidebar['name'];
		}

		return $select_items;
	}
	
	/**
	 * Adds social links to user profile
	 *
	 * @param $user_contact
	 * @return mixed
	 */
	function kriate_user_social_links( $user_contact ) {
	   /* Add user contact methods */
	   $user_contact['facebook'] = __('Facebook Link', 'kriate');
	   $user_contact['twitter'] = __('Twitter Link', 'kriate');
	   $user_contact['linkedin'] = __('LinkedIn Link', 'kriate');
	   $user_contact['designation'] = __('Designation', 'kriate');

	   return $user_contact;
	}
	
	add_filter('user_contactmethods', 'kriate_user_social_links');

	// Woocommerce rating stars always
	add_filter('woocommerce_product_get_rating_html', 'your_get_rating_html', 10, 2);

	function your_get_rating_html($rating_html, $rating) {
		if ( $rating > 0 ) {
			$title = sprintf( __( 'Rated %s out of 5', 'woocommerce' ), $rating );
		} else {
			$title = 'Not yet rated';
			$rating = 0;
		}

		$rating_html  = '<div class="star-rating" title="' . $title . '">';
		$rating_html .= '<span style="width:' . ( ( $rating / 5 ) * 100 ) . '%"><strong class="rating">' . $rating . '</strong> ' . __( 'out of 5', 'woocommerce' ) . '</span>';
		$rating_html .= '</div>';
		return $rating_html;
	}
	add_filter( 'woocommerce_product_reviews_tab_title', 'add_stars_to_review_tab', 98 );

	function add_stars_to_review_tab( $title ) {
		global $product;

		$average_rating = $product->get_average_rating();
		$rating_count = $product->get_rating_count();
		$review_count = $product->get_review_count();

		//if( ! empty($average_rating) && $average_rating > 0 ) {
			return wc_get_rating_html($average_rating);
		//}
	}
	
		/* Add Services Meta Boxes */
	add_action( 'cmb2_admin_init', 'kriate_products_posttype_metaboxes' );

	function kriate_products_posttype_metaboxes() {

		$cmb = new_cmb2_box( array(
			'id'            => 'products_metabox',
			'title'         => __( 'Product Options', 'kriate' ),
			'object_types'  => array( 'product', ),
			'context'       => 'normal',
			'priority'      => 'high',
			'show_names'    => true,
		) );
		
		$cmb->add_field( array(
			'name'    => 'Company Name',
			'desc'    => 'Comapny Name Goes Here',
			'default' => 'Audible Studios',
			'id'      => 'product_company_name',
			'type'    => 'text',
		) );
		
	} /* Meta boxes Ends Here */
	
	
	add_shortcode('recent-posts', 'recent_posts_function');
	//[recent-posts posts="5"]This is the list heading[/recent-posts]
	function recent_posts_function($atts){
	   extract(shortcode_atts(array(
		  'image1' => '',
		  'image2' => '',
		  'image3' => '',
	   ), $atts));

	   $html = '
	   
	   <div class="gallery-wrap w-100 mt-30">
			<div class="row mrg10">';
				
				$html .= '
				<div class="col-md-4 col-sm-4 col-lg-4">
					<div class="gallery-box text-center overflow-hidden position-relative w-100">
						<img class="img-fluid w-100" src="'.get_template_directory_uri().'/assets/images/'.$image1.'" alt="Gallery Image 1">
						<div class="gallery-info position-absolute">
							<h3 class="mb-0">Construction Site</h3>
							<span class="d-block thm-clr">Click To View</span>
							<a class="d-inline-block thm-clr" href="'.get_template_directory_uri().'/assets/images/gal-1-full.jpg" data-fancybox="gallery" title=""><i class="fas fa-expand"></i></a>
						</div>
					</div>
				</div>
				<div class="col-md-4 col-sm-4 col-lg-4">
					<div class="gallery-box text-center overflow-hidden position-relative w-100">
						<img class="img-fluid w-100" src="'.get_template_directory_uri().'/assets/images/'.$image2.'" alt="Gallery Image 1">
						<div class="gallery-info position-absolute">
							<h3 class="mb-0">Melting Iron</h3>
							<span class="d-block thm-clr">Click To View</span>
							<a class="d-inline-block thm-clr" href="'.get_template_directory_uri().'/assets/images/gal-2-full.jpg" data-fancybox="gallery" title=""><i class="fas fa-expand"></i></a>
						</div>
					</div>
				</div>
				<div class="col-md-4 col-sm-4 col-lg-4">
					<div class="gallery-box text-center overflow-hidden position-relative w-100">
						<img class="img-fluid w-100" src="'.get_template_directory_uri().'/assets/images/'.$image3.'" alt="Gallery Image 1">
						<div class="gallery-info position-absolute">
							<h3 class="mb-0">Piercing Steel</h3>
							<span class="d-block thm-clr">Click To View</span>
							<a class="d-inline-block thm-clr" href="'.get_template_directory_uri().'/assets/images/gal-3-full.jpg" data-fancybox="gallery" title=""><i class="fas fa-expand"></i></a>
						</div>
					</div>
				</div>
			</div>
		</div>';
		return $html;
	}
