<?php
/***** Required Functions For Services Post Type *****/
if ( ! function_exists('prefix_post_type_services') ) {

	/* 1. Register CLASSES Post Type */
	function prefix_post_type_services() {

		$labels = array(
			'name'                  => _x( 'Services', 'Post Type General Name', 'kriate' ),
			'singular_name'         => _x( 'Service', 'Post Type Singular Name', 'kriate' ),
			'menu_name'             => __( 'Services', 'kriate' ),
			'name_admin_bar'        => __( 'Services', 'kriate' ),
			'archives'              => __( 'Service Archives', 'kriate' ),
			'attributes'            => __( 'Service Attributes', 'kriate' ),
			'parent_item_colon'     => __( 'Parent Service:', 'kriate' ),
			'all_items'             => __( 'All Services', 'kriate' ),
			'add_new_item'          => __( 'Add New Service', 'kriate' ),
			'add_new'               => __( 'Add New Service', 'kriate' ),
			'new_item'              => __( 'Add New Service', 'kriate' ),
			'edit_item'             => __( 'Edit Service', 'kriate' ),
			'update_item'           => __( 'Update Service', 'kriate' ),
			'view_item'             => __( 'View Service', 'kriate' ),
			'view_items'            => __( 'View Services', 'kriate' ),
			'search_items'          => __( 'Search Service', 'kriate' ),
			'not_found'             => __( 'Not found', 'kriate' ),
			'not_found_in_trash'    => __( 'Not found in Trash', 'kriate' ),
			'featured_image'        => __( 'Service Featured Image', 'kriate' ),
			'set_featured_image'    => __( 'Set featured image', 'kriate' ),
			'remove_featured_image' => __( 'Remove featured image', 'kriate' ),
			'use_featured_image'    => __( 'Use as featured image', 'kriate' ),
			'insert_into_item'      => __( 'Insert into Service', 'kriate' ),
			'uploaded_to_this_item' => __( 'Uploaded to this Service', 'kriate' ),
			'items_list'            => __( 'Services list', 'kriate' ),
			'items_list_navigation' => __( 'Services list navigation', 'kriate' ),
			'filter_items_list'     => __( 'Filter Services list', 'kriate' ),
		);
		$args = array(
			'label'                 => __( 'Services', 'kriate' ),
			'description'           => __( 'Services Posts Generated By Ingeniofy Plugin', 'kriate' ),
			'labels'                => $labels,
			'supports'              => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
			'hierarchical'          => true,
			'public'                => true,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'menu_position'         => 20,
			'menu_icon'             => 'dashicons-yes',
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'can_export'            => true,
			'has_archive'           => 'services',
			'exclude_from_search'   => false,
			'publicly_queryable'    => true,
			'capability_type'       => 'page',
		);
		register_post_type( 'services', $args );
	
		/* Add new taxonomy, make it hierarchical (like categories) */
		$cat_labels = array(
			'name'              => _x( 'Service Categories', 'taxonomy general name', 'kriate' ),
			'singular_name'     => _x( 'Service Category', 'taxonomy singular name', 'kriate' ),
			'search_items'      => __( 'Search Service Category', 'kriate' ),
			'all_items'         => __( 'All Service Categories', 'kriate' ),
			'parent_item'       => __( 'Parent Service Category', 'kriate' ),
			'parent_item_colon' => __( 'Parent Service Category:', 'kriate' ),
			'edit_item'         => __( 'Edit Service Category', 'kriate' ),
			'update_item'       => __( 'Update Service Category', 'kriate' ),
			'add_new_item'      => __( 'Add New Service Category', 'kriate' ),
			'new_item_name'     => __( 'New Service Category Name', 'kriate' ),
			'menu_name'         => __( 'Service Categories', 'kriate' ),
		);

		$cat_args = array(
			'hierarchical'      => true,
			'labels'            => $cat_labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'services-category' ),
		);

		register_taxonomy( 'services-cat', array( 'services' ), $cat_args );

	} /* service post type function ends */

	/* Add Action For Generating Post Type */
	add_action( 'init', 'prefix_post_type_services', 0 );
	
	
	/* Add Services Meta Boxes */
	add_action( 'cmb2_admin_init', 'kriate_services_posttype_metaboxes' );

	function kriate_services_posttype_metaboxes() {

		$cmb = new_cmb2_box( array(
			'id'            => 'services_metabox',
			'title'         => __( 'Services Options', 'kriate' ),
			'object_types'  => array( 'services', ),
			'context'       => 'normal',
			'priority'      => 'high',
			'show_names'    => true,
		) );

		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Icon Class', 'kriate' ),
			'desc'       => __( 'Add Flaticon or FontAwesome Class Here e.g flaticon-mat or far fa-envelope', 'kriate' ),
			'id'         => 'service_icon',
			'type'       => 'text',
		) );
		
		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Service Caption', 'kriate' ),
			'desc'       => __( 'Service Caption Goes Here e.g Builders Merchant Sales', 'kriate' ),
			'id'         => 'service_caption',
			'type'       => 'text',
		) );

		// List Service field
		$cmb->add_field( array(
			'name' => __( 'Service Details List', 'kriate' ),
			'desc' => __( 'Add Services List Here, Click -Add Row- To Enter More', 'kriate' ),
			'id'   => 'service_list',
			'type' => 'text',
			'repeatable' => true,
		) );
		
		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Secondary Title', 'kriate' ),
			'desc'       => __( 'Hot Deal: Yacht Build Package', 'kriate' ),
			'id'         => 'service_sec_title',
			'type'       => 'text',
		) );
		
		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Discount', 'kriate' ),
			'desc'       => __( '15%', 'kriate' ),
			'id'         => 'service_discount',
			'type'       => 'text',
		) );
		
		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Discount Text', 'kriate' ),
			'desc'       => __( 'Off', 'kriate' ),
			'id'         => 'service_discount_text',
			'type'       => 'text',
		) );
		
		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Caption Text', 'kriate' ),
			'desc'       => __( 'We are always ready to best solution for your problem.', 'kriate' ),
			'id'         => 'service_caption_text',
			'type'       => 'text',
		) );
	} /* Meta boxes Ends Here */

}