<?php
/***** Required Functions For sermons Post Type *****/
if ( ! function_exists('prefix_post_type_sermons') ) {

/* 1. Register CLASSES Post Type */
function prefix_post_type_sermons() {

	$labels = array(
		'name'                  => _x( 'Sermons', 'Post Type General Name', 'kriate' ),
		'singular_name'         => _x( 'Sermons', 'Post Type Singular Name', 'kriate' ),
		'menu_name'             => __( 'Sermons', 'kriate' ),
		'name_admin_bar'        => __( 'Sermons', 'kriate' ),
		'archives'              => __( 'Sermons Archives', 'kriate' ),
		'attributes'            => __( 'Sermons Attributes', 'kriate' ),
		'parent_item_colon'     => __( 'Parent Item:', 'kriate' ),
		'all_items'             => __( 'All Items', 'kriate' ),
		'add_new_item'          => __( 'Add New Sermons', 'kriate' ),
		'add_new'               => __( 'Add New Sermons', 'kriate' ),
		'new_item'              => __( 'Add New Sermons', 'kriate' ),
		'edit_item'             => __( 'Edit Sermons', 'kriate' ),
		'update_item'           => __( 'Update Item', 'kriate' ),
		'view_item'             => __( 'View Item', 'kriate' ),
		'view_items'            => __( 'View Items', 'kriate' ),
		'search_items'          => __( 'Search Item', 'kriate' ),
		'not_found'             => __( 'Not found', 'kriate' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'kriate' ),
		'featured_image'        => __( 'Sermons Featured Image', 'kriate' ),
		'set_featured_image'    => __( 'Set featured image', 'kriate' ),
		'remove_featured_image' => __( 'Remove featured image', 'kriate' ),
		'use_featured_image'    => __( 'Use as featured image', 'kriate' ),
		'insert_into_item'      => __( 'Insert into item', 'kriate' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'kriate' ),
		'items_list'            => __( 'Items list', 'kriate' ),
		'items_list_navigation' => __( 'Items list navigation', 'kriate' ),
		'filter_items_list'     => __( 'Filter items list', 'kriate' ),
	);
	$args = array(
		'label'                 => __( 'Sermons', 'kriate' ),
		'description'           => __( 'Sermons Posts Generated By Ingeniofy Plugin', 'kriate' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
		'hierarchical'          => true,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 20,
		'menu_icon'             => 'dashicons-format-video',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => 'sermons',
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'sermons', $args );
	
	/* Add new taxonomy, make it hierarchical (like categories) */
	$cat_labels = array(
		'name'              => _x( 'Sermons Categories', 'taxonomy general name', 'kriate' ),
		'singular_name'     => _x( 'Sermons Category', 'taxonomy singular name', 'kriate' ),
		'search_items'      => __( 'Search Sermons Category', 'kriate' ),
		'all_items'         => __( 'All Sermons Categories', 'kriate' ),
		'parent_item'       => __( 'Parent Sermons Category', 'kriate' ),
		'parent_item_colon' => __( 'Parent Sermons Category:', 'kriate' ),
		'edit_item'         => __( 'Edit Sermons Category', 'kriate' ),
		'update_item'       => __( 'Update Sermons Category', 'kriate' ),
		'add_new_item'      => __( 'Add New Sermons Category', 'kriate' ),
		'new_item_name'     => __( 'New Sermons Category Name', 'kriate' ),
		'menu_name'         => __( 'Sermons Categories', 'kriate' ),
	);

	$cat_args = array(
		'hierarchical'      => true,
		'labels'            => $cat_labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'sermons-category' ),
	);

	register_taxonomy( 'sermons-category', array( 'sermons' ), $cat_args );

}

	/* Add Action For Generating Post Type */
	add_action( 'init', 'prefix_post_type_sermons', 0 );

}

	/* Add Services Meta Boxes */
	add_action( 'cmb2_admin_init', 'kriate_sermons_posttype_metaboxes' );

	function kriate_sermons_posttype_metaboxes() {

		$cmb = new_cmb2_box( array(
			'id'            => 'sermons_metabox',
			'title'         => __( 'Sermons Options', 'kriate' ),
			'object_types'  => array( 'sermons', ),
			'context'       => 'normal',
			'priority'      => 'high',
			'show_names'    => true,
		) );
		
		$cmb->add_field( array(
			'name'    => 'Sub Title',
			'desc'    => 'Add Sub Title For Sermon',
			'default' => 'Muslims to Achieve Spiritual Goals',
			'id'      => 'sermon_sub_title',
			'type'    => 'text',
		) );

		$cmb->add_field( array(
			'name'    => 'Video File',
			'desc'    => 'Upload an Video or enter an URL.',
			'id'      => 'sermon_video_url',
			'type'    => 'file',
			// Optional:
			'options' => array(
				'url' => true, // Hide the text input for the url
			),
			'text'    => array(
				'add_upload_file_text' => 'Add Video File' // Change upload button text. Default: "Add or Upload File"
			),
			// query_args are passed to wp.media's library query.
			'query_args' => array(
				'type' => 'application/pdf', // Make library only display PDFs.
				// Or only allow gif, jpg, or png images
				// 'type' => array(
				// 	'image/gif',
				// 	'image/jpeg',
				// 	'image/png',
				// ),
			),
			'preview_size' => 'small', // Image size to use when previewing in the admin.
		) );
		
		$cmb->add_field( array(
			'name'    => 'Audio File',
			'desc'    => 'Upload an Audio or enter an URL.',
			'id'      => 'sermon_audio_url',
			'type'    => 'file',
			// Optional:
			'options' => array(
				'url' => true, // Hide the text input for the url
			),
			'text'    => array(
				'add_upload_file_text' => 'Add Audio File' // Change upload button text. Default: "Add or Upload File"
			),
			// query_args are passed to wp.media's library query.
			'query_args' => array(
				'type' => 'application/pdf', // Make library only display PDFs.
				// Or only allow gif, jpg, or png images
				// 'type' => array(
				// 	'image/gif',
				// 	'image/jpeg',
				// 	'image/png',
				// ),
			),
			'preview_size' => 'small', // Image size to use when previewing in the admin.
		) );
		
		$cmb->add_field( array(
			'name'    => 'PDF File',
			'desc'    => 'Upload an PDF or enter an URL.',
			'id'      => 'sermon_pdf_url',
			'type'    => 'file',
			// Optional:
			'options' => array(
				'url' => true, // Hide the text input for the url
			),
			'text'    => array(
				'add_upload_file_text' => 'Add PDF File' // Change upload button text. Default: "Add or Upload File"
			),
			// query_args are passed to wp.media's library query.
			'query_args' => array(
				'type' => 'application/pdf', // Make library only display PDFs.
				// Or only allow gif, jpg, or png images
				// 'type' => array(
				// 	'image/gif',
				// 	'image/jpeg',
				// 	'image/png',
				// ),
			),
			'preview_size' => 'small', // Image size to use when previewing in the admin.
		) );
		
		$cmb->add_field( array(
			'name' => 'Short Caption',
			'desc' => 'Short Caption For Thumbnail: ISLAMIC HADITH LESSONS',
			'type' => 'text',
			'default' => 'ISLAMIC HADITH LESSONS',
			'id'   => 'sermon_short_caption'
		) );
		
		$cmb->add_field( array(
			'name'    => 'List Title',
			'desc'    => 'Minutes Title Description: ABOUT SERMON:',
			'default' => 'ABOUT SERMON:',
			'id'      => 'sermon_minutes_title',
			'type'    => 'text',
		) );
		

		// List Service field
		$cmb->add_field( array(
			'name' => __( 'Sermon Minutes', 'kriate' ),
			'desc' => __( 'Add Sermons List Here, Click -Add Row- To Enter More', 'kriate' ),
			'id'   => 'sermons_list',
			'type' => 'text',
			'repeatable' => true,
		) );
	} /* Meta boxes Ends Here */