<?php
/***** Required Functions For Projects Post Type *****/
if ( ! function_exists('prefix_post_type_projects') ) {

	/* 1. Register CLASSES Post Type */
	function prefix_post_type_projects() {

		$labels = array(
			'name'                  => _x( 'Projects', 'Post Type General Name', 'kriate' ),
			'singular_name'         => _x( 'Project', 'Post Type Singular Name', 'kriate' ),
			'menu_name'             => __( 'Projects', 'kriate' ),
			'name_admin_bar'        => __( 'Projects', 'kriate' ),
			'archives'              => __( 'Project Archives', 'kriate' ),
			'attributes'            => __( 'Project Attributes', 'kriate' ),
			'parent_item_colon'     => __( 'Parent Project:', 'kriate' ),
			'all_items'             => __( 'All Projects', 'kriate' ),
			'add_new_item'          => __( 'Add New Project', 'kriate' ),
			'add_new'               => __( 'Add New Project', 'kriate' ),
			'new_item'              => __( 'Add New Project', 'kriate' ),
			'edit_item'             => __( 'Edit Project', 'kriate' ),
			'update_item'           => __( 'Update Project', 'kriate' ),
			'view_item'             => __( 'View Project', 'kriate' ),
			'view_items'            => __( 'View Projects', 'kriate' ),
			'search_items'          => __( 'Search Project', 'kriate' ),
			'not_found'             => __( 'Not found', 'kriate' ),
			'not_found_in_trash'    => __( 'Not found in Trash', 'kriate' ),
			'featured_image'        => __( 'Project Featured Image', 'kriate' ),
			'set_featured_image'    => __( 'Set featured image', 'kriate' ),
			'remove_featured_image' => __( 'Remove featured image', 'kriate' ),
			'use_featured_image'    => __( 'Use as featured image', 'kriate' ),
			'insert_into_item'      => __( 'Insert into Project', 'kriate' ),
			'uploaded_to_this_item' => __( 'Uploaded to this Project', 'kriate' ),
			'items_list'            => __( 'Projects list', 'kriate' ),
			'items_list_navigation' => __( 'Projects list navigation', 'kriate' ),
			'filter_items_list'     => __( 'Filter Projects list', 'kriate' ),
		);
		$args = array(
			'label'                 => __( 'Projects', 'kriate' ),
			'description'           => __( 'Projects Posts Generated By Ingeniofy Plugin', 'kriate' ),
			'labels'                => $labels,
			'supports'              => array( 'title', 'editor', 'thumbnail', 'comments' ),
			'hierarchical'          => true,
			'public'                => true,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'menu_position'         => 20,
			'menu_icon'             => 'dashicons-yes',
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'can_export'            => true,
			'has_archive'           => 'projects',
			'exclude_from_search'   => false,
			'publicly_queryable'    => true,
			'capability_type'       => 'page',
		);
		register_post_type( 'projects', $args );
	
		/* Add new taxonomy, make it hierarchical (like categories) */
		$cat_labels = array(
			'name'              => _x( 'Project Categories', 'taxonomy general name', 'kriate' ),
			'singular_name'     => _x( 'Project Category', 'taxonomy singular name', 'kriate' ),
			'search_items'      => __( 'Search Project Category', 'kriate' ),
			'all_items'         => __( 'All Project Categories', 'kriate' ),
			'parent_item'       => __( 'Parent Project Category', 'kriate' ),
			'parent_item_colon' => __( 'Parent Project Category:', 'kriate' ),
			'edit_item'         => __( 'Edit Project Category', 'kriate' ),
			'update_item'       => __( 'Update Project Category', 'kriate' ),
			'add_new_item'      => __( 'Add New Project Category', 'kriate' ),
			'new_item_name'     => __( 'New Project Category Name', 'kriate' ),
			'menu_name'         => __( 'Project Categories', 'kriate' ),
		);

		$cat_args = array(
			'hierarchical'      => true,
			'labels'            => $cat_labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'projects-category' ),
		);

		register_taxonomy( 'projects-category', array( 'projects' ), $cat_args );

	} /* service post type function ends */

	/* Add Action For Generating Post Type */
	add_action( 'init', 'prefix_post_type_projects', 0 );
	
	
	/* Add projects Meta Boxes */
	add_action( 'cmb2_admin_init', 'kriate_projects_posttype_metaboxes' );

	function kriate_projects_posttype_metaboxes() {

		$cmb = new_cmb2_box( array(
			'id'            => 'projects_metabox',
			'title'         => __( 'Project Options', 'kriate' ),
			'object_types'  => array( 'projects', ),
			'context'       => 'normal',
			'priority'      => 'high',
			'show_names'    => true,
		) );

		// Regular text field
		$cmb->add_field( array(
			'name'       => __( 'Icon Class', 'kriate' ),
			'desc'       => __( 'Add Flaticon or FontAwesome Class Here e.g flaticon-mat or far fa-envelope', 'kriate' ),
			'id'         => 'projects_icon',
			'type'       => 'text',
		) );
		
		$cmb->add_field( array(
			'name'    => 'Sidebar Layout',
			'id'      => 'projects_sidebar_layout',
			'type'    => 'radio_inline',
			'options' => array(
				'right' => __( 'Right SideBar', 'cmb2' ),
				'left'   => __( 'Left SideBar', 'cmb2' ),
				'no'     => __( 'No SideBar', 'cmb2' ),
			),
			'default' => 'right',
		) );
		
		$cmb->add_field( array(
			'name'             => 'Select SideBar',
			'desc'             => 'Select Your Desired SideBar',
			'id'               => 'projects_sidebar_selected',
			'type'             => 'select',
			'show_option_none' => true,
			'default'          => '',
			'options_cb' => 'kriate_cmb2_get_all_sidebars',
		) );
		
	} /* Meta boxes Ends Here */

}