<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class ServicesGrid extends Widget_Base{

  public function get_name(){
    return 'services_grid';
  }

  public function get_title(){
    return 'Services + Facts';
  }

  public function get_icon(){
    return 'fa fa-cogs';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'services',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'services-cat',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'kriate' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
		'chose_style',
		[
			'label'     => esc_html__( 'Chose Style', 'kriate' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => [
				'style-one'  => esc_html__( 'Dark Style', 'kriate' ),
				'style-two' => esc_html__( 'Light Style', 'kriate' ),
			],
			'default'   => 'style-one',
		]
	);
	
	$this->add_control(
      'content_subcaption',
      [
        'label' => 'Element Sub Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Our Standard Services'
      ]
    );
	
	$this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Al is no longer a futuristic notion, its here right now'
      ]
    );

    $this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Morem Gpsum is simply dummy text of the printing and typesetting industry.'
      ]
    );
	
	$this->add_control(
		'background-image',
		[
			'label' => __( 'Choose Background Image', 'kriate' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/parallax1.jpg',
			],
		]
	);
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'kriate' ),
				'title' => __( 'Title', 'kriate' ),
				'name' => __( 'Name', 'kriate' ),
				'rand' => __( 'Random', 'kriate' ),
				'ID' => __( 'ID', 'kriate' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'kriate' ),
				'ASC' => __( 'ASCENDING', 'kriate' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Posts Count', 'kriate' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 40,
			'step' => 1,
			'default' => 4,
		]
    );
	
	$this->add_control(
      'words_count',
      [
        'label' => 'Words Count',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '15'
      ]
    );

	$this->add_control(
		'display_pagination',
		[
			'label' => __( 'Pagination', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'No',
			'options' => [
				'No'  => __( 'No', 'kriate' ),
				'Yes' => __( 'Yes', 'kriate' ),
			],
		]
    );
	
	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'More Services'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'kriate' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'kriate' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );
	
	$this->add_control(
		'show_facts',
		[
			'label' => __( 'Show Facts Section', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => __( 'Show', 'your-plugin' ),
			'label_off' => __( 'Hide', 'your-plugin' ),
			'return_value' => 'yes',
			'default' => 'yes',
		]
	);
	
	$this->add_control(
		'fact-bg-image',
		[
			'label' => __( 'Choose Facts Background Image', 'kriate' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/pattern-bg1.png',
			],
		]
	);
	
	$repeater = new \Elementor\Repeater();
	
    $repeater->add_control(
      'fact_count',
      [
        'label' => 'Fact Count',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '18'
      ]
    );
	
	$repeater->add_control(
      'fact_suffix',
      [
        'label' => 'Fact Suffix',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '+'
      ]
    );

	$repeater->add_control(
      'fact_text',
      [
        'label' => 'Fact Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Experience'
      ]
    );

		   
	$this->add_control(
		'list',
			[
			'label' => __( 'Fact Counts', 'plugin-domain' ),
			'type' => \Elementor\Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls(),
			'default' => [
				[		
					'fact_count' => __( '18', 'plugin-domain' ),
					'fact_suffix' => __( '+', 'plugin-domain' ),
					'fact_text' => __( 'Experience', 'plugin-domain' ),
				],
				[		
					'fact_count' => __( '502', 'plugin-domain' ),
					'fact_suffix' => __( '+', 'plugin-domain' ),
					'fact_text' => __( 'Completed Projects', 'plugin-domain' ),
				],
				[		
					'fact_count' => __( '120', 'plugin-domain' ),
					'fact_suffix' => __( '+', 'plugin-domain' ),
					'fact_text' => __( 'Constructions', 'plugin-domain' ),
				],
				[		
					'fact_count' => __( '12', 'plugin-domain' ),
					'fact_suffix' => __( '+', 'plugin-domain' ),
					'fact_text' => __( 'Running Projects', 'plugin-domain' ),
				],
			],
			'title_field' => '{{{ fact_text }}}',
			]
		);
	

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = kriate_get_post_query('services', 'services-cat', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']); 
	
	if($settings['chose_style'] == 'style-one'){
		
	/* Particles */
	wp_enqueue_script( 'particles-js', get_template_directory_uri() . '/assets/js/particles.min.js', array('jquery'), '1.0.0', true ); ?>
	<script>
	jQuery(document).ready(function($){
  'use strict';
  var particlesID = '';
  var particlesColor = '#fff';

  jQuery('.particles-js').each(function(i, el) {
    particlesID = jQuery(el).attr('id');
    if( jQuery(el).data('color') != undefined ){
      particlesColor = jQuery(el).data('color');
    }
    var test = particlesJS(particlesID,
    {
      "particles": {
        "number": {
          "value": 160,
          "density": {
            "enable": true,
            "value_area": 800
          }
        },
        "color": {
          "value": particlesColor
        },
        "shape": {
          "type": "circle",
          "stroke": {
            "width": 0,
            "color": "#000000"
          },
          "polygon": {
            "nb_sides": 5
          },
          "image": {
            "src": "img/github.svg",
            "width": 100,
            "height": 100
          }
        },
        "opacity": {
          "value": 1,
          "random": true,
          "anim": {
            "enable": true,
            "speed": 1,
            "opacity_min": 0,
            "sync": false
          }
        },
        "size": {
          "value": 4,
          "random": true,
          "anim": {
            "enable": false,
            "speed": 4,
            "size_min": 0.3,
            "sync": false
          }
        },
        "line_linked": {
          "enable": false,
          "distance": 150,
          "color": "#ffffff",
          "opacity": 0.4,
          "width": 1
        },
        "move": {
          "enable": true,
          "speed": 1,
          "direction": "none",
          "random": true,
          "straight": false,
          "out_mode": "out",
          "bounce": false,
          "attract": {
            "enable": false,
            "rotateX": 600,
            "rotateY": 600
          }
        }
      },
      "interactivity": {
        "detect_on": "canvas",
        "events": {
          "onhover": {
            "enable": true,
            "mode": "bubble"
          },
          "onclick": {
            "enable": true,
            "mode": "repulse"
          },
          "resize": true
        },
        "modes": {
          "grab": {
            "distance": 400,
            "line_linked": {
              "opacity": 1
            }
          },
          "bubble": {
            "distance": 250,
            "size": 0,
            "duration": 2,
            "opacity": 0,
            "speed": 3
          },
          "repulse": {
            "distance": 400,
            "duration": 0.4
          },
          "push": {
            "particles_nb": 4
          },
          "remove": {
            "particles_nb": 2
          }
        }
      },
      "retina_detect": true
    }

    );
  });
});</script>
	<?php 	$bg_class = 'blue-layer'; $padding_class = 'pt-100 opc7 position-relative'; }else{ $bg_class = ''; $padding_class = 'w-100 pt-100 pb-70 position-relative';}
	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : ''; 
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : '';  ?>
	
	<section>
		<div class="w-100 <?php echo esc_html($bg_class);?> <?php echo esc_html($padding_class); ?>">
			<?php if($settings['background-image']['url']){ ?>
				<div class="fixed-bg" style="background-image: url(<?php echo esc_url($settings['background-image']['url']); ?>);"></div>
			<?php } ?>
			<div class="particles-js" id="prtcl"></div>
			<div class="container">
			<?php if(!empty($settings['content_heading']) || !empty($settings['content_subcaption'])){ ?>
				<div class="sec-title v2 text-center w-100">
					<div class="sec-title-inner d-inline-block">
						<?php if($settings['content_subcaption']){ ?><span class="thm-clr d-block"><?php echo esc_html($settings['content_subcaption']);?></span><?php } ?>
						<?php if($settings['content_heading']){ ?><h2 class="mb-0"><?php echo esc_html($settings['content_heading']);?></h2><?php } ?>
						<?php if($settings['content_caption']){ ?><p class="mb-0"><?php echo esc_html($settings['content_caption']);?></p><?php } ?>
					</div>
				</div>
			<?php } ?>
				<div class="serv-wrap text-center w-100">
					<div class="row res-caro2">
						<?php /* Services Loop */
						if ( have_posts() ) {
							
							while ( have_posts() ) { the_post(); global $post;
			
							static $counter = 1; 
							
							$service_icon = ''; $service_caption = '';
							$service_icon = get_post_meta( get_the_ID(), 'service_icon', true ); 
							$service_caption = get_post_meta( get_the_ID(), 'service_caption', true ); 
							
							$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 270, 327, 'bfi_thumb' => true )); ?>
							
							<div class="col-md-3 col-sm-6 col-lg-3">
								<div class="serv-box2 position-relative overflow-hidden w-100" style="background-image: url(<?php echo esc_html($featured_image_url); ?>);">
									<?php if($service_icon){ ?><i class="thm-clr <?php echo esc_html($service_icon); ?>"></i><?php } ?>
									<div class="serv-box-inner">
										<h3 class="mb-0"><a href="<?php echo get_the_permalink(); ?>" title=""><?php echo get_the_title(); ?></a></h3>
										<p class="mb-0"><?php echo wp_trim_words( get_the_excerpt(), $settings['words_count'], '...' ); ?></p>
										<?php if($service_caption){ ?>
											<span class="d-block"><i class="thm-clr far fa-star" aria-hidden="true"></i> <?php echo esc_html($service_caption); ?></span> 
										<?php } ?>
									</div>
								</div>
							</div>
							<?php }
						} wp_reset_query(); ?>
					</div>
				</div><!-- Services Wrap -->
				<?php if($settings['show_facts'] == 'yes'){ ?>
					<div class="facts-wrap thm-layer opc1 text-center position-relative overflow-hidden brd-rd5 w-100">
						<div class="parallax-bg zoom-anim back-blend-multiply patern-bg thm-bg" style="background-image: url(<?php echo esc_url($settings['fact-bg-image']['url']); ?>);"></div>
						<div class="row">
							<?php 
							if ( $settings['list'] ) {
											
								foreach (  $settings['list'] as $item ) { ?>
									
									<div class="col-md-3 col-sm-6 col-lg-3">
										<div class="fact-box w-100">
											<?php if($item['fact_count']){ ?>
												<h2 class="mb-0"><span class="counter"><?php echo $item['fact_count']; ?></span><sup><?php echo $item['fact_suffix']; ?></sup></h2>
											<?php } ?>
											<?php if($item['fact_text']){ ?><h4 class="mb-0"><?php echo $item['fact_text']; ?></h4><?php } ?>
										</div>
									</div>
								<?php }
							} ?>
						</div>
					</div><!-- Facts Wrap -->
				<?php } ?>
			</div>
		</div>
	</section>

    <?php
  }
}