<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class ProjectsGrid extends Widget_Base{

  public function get_name(){
    return 'projects_grid';
  }

  public function get_title(){
    return 'Projects Grid';
  }

  public function get_icon(){
    return 'fa fa-cogs';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'projects',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'projects-category',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'kriate' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
      'content_caption',
      [
        'label' => 'Sub Heading',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Development Works'
      ]
    );
	
	$this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Our Latest Projects'
      ]
    );	
	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'kriate' ),
				'title' => __( 'Title', 'kriate' ),
				'name' => __( 'Name', 'kriate' ),
				'rand' => __( 'Random', 'kriate' ),
				'ID' => __( 'ID', 'kriate' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'kriate' ),
				'ASC' => __( 'ASCENDING', 'kriate' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Posts Count', 'kriate' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 40,
			'step' => 1,
			'default' => 4,
		]
    );
	
	$this->add_control(
      'words_count',
      [
        'label' => 'Words Count',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '15'
      ]
    );
	
	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'View All Projects'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'kriate' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );
	

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = kriate_get_post_query('projects', 'projects-category', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']); ?>
	
	<section>
		<div class="w-100 pt-100 pb-100 position-relative">
			<div class="container">
				<?php if($settings['content_heading'] || $settings['content_caption']){ ?>
				<div class="sec-title w-100 faqs">
					<div class="sec-title-inner d-inline-block">
						<?php if($settings['content_caption']){ ?><span class="d-block thm-clr"><?php echo esc_html($settings['content_caption']); ?></span><?php } ?>
						<?php if($settings['content_heading']){ ?><h3 class="mb-0"><?php echo esc_html($settings['content_heading']); ?></h3><?php } ?>
					</div>
				</div> 
				<?php } ?>
				<div class="proj-wrap w-100">
					<div class="row justify-content-center">
					<?php
					if ( have_posts() ) {
						
						while ( have_posts() ) { the_post(); global $post;
		
							static $counter = 1; 
							
							$projects_icon = '';
							$projects_icon = get_post_meta( get_the_ID(), 'projects_icon', true ); 
							
							$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 270, 300, 'bfi_thumb' => true )); ?>	
						
							<div class="col-md-4 col-sm-6 col-lg-3">
								<div class="proj-box position-relative w-100">
									<?php if($featured_image_url){ ?>
										<div class="proj-thumb overflow-hidden w-100">
											<a href="<?php echo get_the_permalink(); ?>" title="">
												<img class="img-fluid w-100" src="<?php echo esc_url($featured_image_url); ?>" alt="<?php esc_attr__('Project Image','kriate'); ?>">
											</a>
										</div>
									<?php } ?>
									<div class="proj-info position-absolute">
										<?php if($projects_icon){ ?><i class="<?php echo esc_html($projects_icon); ?>"></i><?php } ?>
										<h3 class="mb-0"><a href="<?php echo get_the_permalink(); ?>" title=""><?php echo get_the_title(); ?></a></h3>
									</div>
								</div>
							</div>
						<?php }
					} wp_reset_query(); ?>
					</div>
				</div><!-- Projects Wrap -->
				<?php if($settings['button_text']){ ?>
					<div class="view-all mt-20 w-100 text-center">
						<a class="thm-btn thm-bg" href="<?php echo esc_url($settings['button_url']['url']); ?>" title=""><?php echo esc_html($settings['button_text']); ?><i class="flaticon-arrow-pointing-to-right"></i></a>
					</div><!-- View All -->
				<?php } ?>
			</div>
		</div>
	</section>

    <?php
  }
}