<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class CTA extends Widget_Base{

  public function get_name(){
    return 'cta';
  }

  public function get_title(){
    return 'Call To Action';
  }

  public function get_icon(){
    return 'fa fa-exclamation-circle';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
      'heading_subcaption',
      [
        'label' => 'Heading Icon',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Ready to get started?'
      ]
    );

    $this->add_control(
      'element_title',
      [
        'label' => 'Element Heading',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Get in touch, or create an account.'
      ]
    );

    $this->add_control(
      'element_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Consectetur adipiscing elit duis volutpat ligula nulla dapibus. Simply dummy text of the printing.'
      ]
    );
	
	
	
	$this->add_control(
		'background-image',
		[
			'label' => __( 'Choose Background Image', 'kriate' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/parallax2.jpg',
			],
		]
	);

	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Subscribe Now'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'kriate' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );
	

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : '';
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : '';  ?>
	<style>
	.getin-touch-blob:before {
		-webkit-animation: zoom 8s linear infinite;
		-ms-animation: zoom 8s linear infinite;
		-o-animation: zoom 8s linear infinite;
		animation: zoom 8s linear infinite;
		background-image: url(<?php echo esc_url($settings['background-image']['url']); ?>);
	}
	</style>

	<section>
		<div class="w-100 pt-100 pb-100 blue-layer opc8 position-relative">
			<?php if($settings['background-image']['url']){ ?>
				<div class="fixed-bg" style="background-image: url(<?php echo esc_url($settings['background-image']['url']); ?>);"></div>
			<?php } ?>
			<div class="particles-js" id="prtcl2"></div>
			<div class="container">
				<div class="getin-touch-wrap w-100">
					<div class="row align-items-center">
						<div class="col-md-7 col-sm-12 col-lg-7">
							<div class="getin-touch-title with-shap w-100">
								<div class="getin-touch-blob thm-bg overflow-hidden position-absolute"></div>
								<?php if($settings['heading_subcaption']){ ?><span class="d-block"><?php echo esc_html($settings['heading_subcaption']); ?></span><?php } ?>
								<?php if($settings['element_title']){ ?><h2 class="mb-0"><?php echo esc_html($settings['element_title']); ?></h2><?php } ?>
								<?php if($settings['element_caption']){ ?><p class="mb-0"><?php echo esc_html($settings['element_caption']); ?></p><?php } ?>
							</div>
						</div>
						<div class="col-md-5 col-sm-12 col-lg-5">
							<?php if($settings['button_text']){ ?>
								<div class="getin-touch-btn position-relative text-right">
									<a class="thm-btn thm-bg" href="<?php echo $settings['button_url']; ?>" title=""><?php echo $settings['button_text']; ?><i class="flaticon-arrow-pointing-to-right"></i></a>
								</div>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	
    <?php
  }
}
